/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.ExchangeRateUtils;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodException;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import java.util.Date;

public class PeriodUtils {
    public static PeriodInfo getPrePeriodInfo(Context ctx, PeriodInfo periodInfo) throws BOSException, EASBizException {
        if (periodInfo == null) {
            throw new PeriodException(PeriodException.PERIODNOTNULL);
        }
        PeriodInfo prePeriodInfo = new PeriodInfo();
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        periodInfo = iPeriod.getPeriodInfo((IObjectPK)new ObjectUuidPK(periodInfo.getId()));
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)periodInfo.getEndDate()), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodInfo.getPeriodType().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)new Integer(periodInfo.getPeriodNumber() - 1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodInfo.getPeriodYear()), CompareType.EQUALS));
        evi.setFilter(filter);
        PeriodCollection periodc = new PeriodCollection();
        periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            periodInfo = periodc.get(0);
        }
        if (periodc.size() == 0) {
            EntityViewInfo evi1 = new EntityViewInfo();
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodInfo.getPeriodYear() - 1), CompareType.EQUALS));
            filter1.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodInfo.getPeriodType().getId().toString(), CompareType.EQUALS));
            filter1.setMaskString("#0 and #1");
            evi1.setFilter(filter1);
            evi1.getSorter().add(new SorterItemInfo("periodNumber"));
            periodc = iPeriod.getPeriodCollection(evi1);
        }
        if (periodc.size() > 0) {
            prePeriodInfo = periodc.get(periodc.size() - 1);
        }
        if (prePeriodInfo.getId() == null) {
            prePeriodInfo = null;
        }
        return prePeriodInfo;
    }

    public static PeriodInfo getPeriodInfo(Context ctx, Date date, boolean isAdjustPeriod, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        if (companyInfo == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        if (companyInfo.getAccountPeriodType() == null || companyInfo.getAccountPeriodType().getId() == null) {
            ICompanyOrgUnit iCompanyOrgUnit = null;
            iCompanyOrgUnit = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx) : CompanyOrgUnitFactory.getRemoteInstance();
            companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        }
        if (companyInfo.getAccountPeriodType() == null) {
            return null;
        }
        PeriodInfo periodInfo = new PeriodInfo();
        IPeriod iPeriod = null;
        iPeriod = ctx != null ? PeriodFactory.getLocalInstance((Context)ctx) : PeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (isAdjustPeriod) {
            filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)date)));
            filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)date)));
            filter.getFilterItems().add(new FilterItemInfo("isadjustperiod", (Object)1));
            filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
            filter.setMaskString("#0 and #1 and #2 and #3");
        } else {
            filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)date), CompareType.LESS_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)date), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("isadjustperiod", (Object)0));
            filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
            filter.setMaskString("#0 and #1 and #2 and #3");
        }
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            periodInfo = periodc.get(0);
        }
        if (periodInfo.getId() == null) {
            periodInfo = null;
        }
        return periodInfo;
    }
}

