/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.data.datasource.DSParam;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.print.IPrintActionListener;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.DefaultNoteDataProvider;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataParameter;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSortItem;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSource;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintRuntimeException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubObjectCollection;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.multiapprove.MultiApproveCollection;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.base.noteprint.util.NotePrtRecordUtil;
import com.kingdee.eas.basedata.assistant.IPrintIntegration;
import com.kingdee.eas.basedata.assistant.PrintIntegrationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AssItemsForCashRecCollection;
import com.kingdee.eas.fi.cas.AssItemsForCashRecFactory;
import com.kingdee.eas.fi.cas.AssItemsForCashRecInfo;
import com.kingdee.eas.fi.cas.CasForArApUtil;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ReceivingBillNewDataProvider
extends DefaultNoteDataProvider {
    private static Logger logger = Logger.getLogger((String)ReceivingBillNewDataProvider.class.getName());
    private IMetaDataPK qpk = new MetaDataPK("com.kingdee.eas.fi.cas.ReceivingBillTDQuery");
    private Set ids = null;
    private String templatePath = "/FI/CAS/RECEIVINGBILL";
    private IObjectPK currentPK = null;
    private boolean isPrintUnPassAuditResult = true;
    KDNoteHelper currentHelper = null;
    ReceivingBillPrintListener listener = new ReceivingBillPrintListener();

    public ReceivingBillNewDataProvider(Set id) {
        this.ids = id;
    }

    public ReceivingBillNewDataProvider(List id) {
        this(new HashSet(id));
    }

    public ReceivingBillNewDataProvider(List id, IMetaDataPK pk) {
        this(new HashSet(id));
        this.qpk = pk;
    }

    public ReceivingBillNewDataProvider(Set id, KDNoteHelper currentHelper) {
        this.ids = id;
        this.currentHelper = currentHelper;
        currentHelper.addKDNoteActionListener((IPrintActionListener)this.listener);
    }

    public ReceivingBillNewDataProvider(List id, KDNoteHelper currentHelper) {
        this(new HashSet(id));
        this.currentHelper = currentHelper;
        currentHelper.addKDNoteActionListener((IPrintActionListener)this.listener);
    }

    public ReceivingBillNewDataProvider(List id, boolean isPrintUnPassAuditResult) {
        this(new HashSet(id));
        this.isPrintUnPassAuditResult = isPrintUnPassAuditResult;
    }

    public ReceivingBillNewDataProvider(List id, boolean isPrintUnPassAuditResult, IMetaDataPK pk) {
        this(new HashSet(id));
        this.isPrintUnPassAuditResult = isPrintUnPassAuditResult;
        this.qpk = pk;
    }

    public void setCurrentHelper(KDNoteHelper currentHelper) {
        this.currentHelper = currentHelper;
    }

    public IRowSet getData(R1PrintDataSource dataSource) throws Exception {
        IRowSet iRowSet;
        block7: {
            iRowSet = null;
            try {
                IMetaDataPK pk;
                if (!StringUtil.isEmptyString((String)dataSource.getReference()) && !this.existEntryEntity(dataSource.getReference())) {
                    pk = MetaDataPKFactory.getMetaDataPK((String)dataSource.getReference());
                    log.info((Object)("DefaultNoteDataProvider, datasource has BOSQuery reference. MetaDataPK: " + pk));
                } else {
                    pk = this.qpk;
                }
                if (pk == null) {
                    throw new R1PrintRuntimeException(MultiLanguageUtil.getMLS((String)"client.DefaultNoteDataProvider.exception", (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.client.RptRepaymentResource", (String)"DefaultNoteDataProvider")));
                }
                log.info((Object)("com.kingdee.eas.fi.arap.util.DefinitionDataProvider, MetaDataPK is appointed: " + pk));
                QueryInfo queryInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery(pk);
                if ("ReceivingBillEntry".equals(queryInfo.getMainObject().getName())) {
                    iRowSet = this.execute(dataSource, pk);
                    break block7;
                }
                if ("ReceivingBill".equals(queryInfo.getMainObject().getName())) {
                    iRowSet = this.execute0(dataSource, pk);
                    break block7;
                }
                throw new RecPayException(RecPayException.TDQUERYOFMAINENTITY, new Object[]{pk, queryInfo.getMainObject().getName()});
            }
            catch (Exception e) {
                ExceptionHandler.handle((Component)((CoreUI)null), (Throwable)e);
            }
        }
        return iRowSet;
    }

    private IRowSet execute0(R1PrintDataSource ds, IMetaDataPK pk) throws BOSException {
        IRowSet iRowSet = null;
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)pk);
        exec.option().isAutoTranslateEnum = true;
        exec.option().isIgnoreOrder = true;
        EntityViewInfo ev = this.createWrappedBosRunsstimeInfo(ds);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.ids, CompareType.INCLUDE));
        ev.setFilter(filter);
        exec.setObjectView(ev);
        iRowSet = exec.executeQuery();
        return iRowSet;
    }

    private EntityViewInfo createWrappedBosRunsstimeInfo(R1PrintDataSource ds) {
        int i;
        EntityViewInfo evi = new EntityViewInfo();
        SorterItemCollection ori = (SorterItemCollection)evi.getSorter().clone();
        evi.getSorter().clear();
        R1PrintDataSortItem[] sorts = ds.getSortFields();
        int c = sorts.length;
        for (i = 0; i < c; ++i) {
            SorterItemInfo sorterItemInfo = new SorterItemInfo();
            sorterItemInfo.setPropertyName(sorts[i].getSortField());
            if (sorts[i].getSortType() == 1) {
                sorterItemInfo.setSortType(SortType.DESCEND);
            } else {
                sorterItemInfo.setSortType(SortType.ASCEND);
            }
            evi.getSorter().add(sorterItemInfo);
        }
        c = ori.size();
        for (i = 0; i < c; ++i) {
            evi.getSorter().add(ori.get(i));
        }
        return evi;
    }

    private IRowSet execute(R1PrintDataSource ds, IMetaDataPK pk) {
        IRowSet iRowSet = null;
        try {
            IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)pk);
            exec.option().isAutoTranslateEnum = true;
            exec.option().isIgnoreOrder = true;
            EntityViewInfo ev = this.createWrappedBosRunsstimeInfo(ds);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("receivingBill.id", (Object)this.ids, CompareType.INCLUDE));
            ev.setFilter(filter);
            ArrayList param = this.getDataFilter(ds);
            FMClientHelper.addDataFilter((FilterInfo)filter, (ArrayList)param);
            exec.setObjectView(ev);
            iRowSet = exec.executeQuery();
            NotePrtRecordUtil.setQueryPK((String)"com.kingdee.eas.base.noteprint.app.PrtRecordQuery");
            boolean isControlPrintAmount = this.currentHelper.isPrintTimesControllable2(this.templatePath);
            int maxPrintTimes = 0;
            if (isControlPrintAmount) {
                maxPrintTimes = this.currentHelper.getMaxPrintTimes2(this.templatePath);
            }
            while (iRowSet.next()) {
                IPrintIntegration pinfo = PrintIntegrationFactory.getRemoteInstance();
                String currentPKTemp = iRowSet.getString("receivingBill.id");
                this.currentPK = new ObjectUuidPK(currentPKTemp);
                if (isControlPrintAmount) {
                    int printedTimes = 0;
                    printedTimes = NotePrtRecordUtil.getPrintedTimes((IObjectPK)this.currentPK);
                    int prepareTimes = this.currentHelper.getCopies();
                    if (printedTimes < maxPrintTimes) {
                        if (printedTimes + prepareTimes <= maxPrintTimes) {
                            iRowSet.updateString("printCount", Integer.toString(printedTimes + prepareTimes));
                        } else {
                            iRowSet.updateString("printCount", Integer.toString(maxPrintTimes));
                        }
                    } else {
                        iRowSet.updateString("printCount", Integer.toString(printedTimes));
                    }
                } else {
                    iRowSet.updateString("canPrtControl", Integer.toString(3));
                }
                int precision = iRowSet.getInt("currency.precision");
                iRowSet.updateBigDecimal("actualAmt", iRowSet.getBigDecimal("actualAmt").setScale(precision, 4));
                String entryID = iRowSet.getString("receivingBillEntry.id");
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo filteri = new FilterInfo();
                filteri.getFilterItems().add(new FilterItemInfo("entryParent", (Object)entryID));
                evi.setFilter(filteri);
                evi.getSelector().add(new SelectorItemInfo("*"));
                evi.getSelector().add(new SelectorItemInfo("asstActType.*"));
                AssItemsForCashRecCollection assColl = AssItemsForCashRecFactory.getRemoteInstance().getAssItemsForCashRecCollection(evi);
                AssItemsForCashRecInfo infoTmp = null;
                CoreBaseInfo entityInfo = null;
                StringBuffer sf_assName = new StringBuffer();
                StringBuffer sf_assType = new StringBuffer();
                for (int i = 0; i < assColl.size(); ++i) {
                    infoTmp = assColl.get(i);
                    if (infoTmp.getAsstActType() != null) {
                        sf_assType.append(infoTmp.getAsstActType().getName());
                    }
                    if (infoTmp.getFromID() != null && !infoTmp.getFromID().equals("") && (entityInfo = EJBAccessFactory.createRemoteInstance().getEntityInfo(infoTmp.getFromID())) != null && entityInfo.getString("name") != null) {
                        sf_assName.append(entityInfo.getString("name"));
                    }
                    if (i + 1 == assColl.size()) continue;
                    sf_assType.append("\uff1b");
                    sf_assName.append("\uff1b");
                }
                iRowSet.updateString("assName", sf_assName.toString());
                iRowSet.updateString("assType", sf_assType.toString());
                String currencyId = iRowSet.getString("currency.id");
                String companyId = iRowSet.getString("company.id");
                Date bizDate = iRowSet.getDate("receivingBill.bizDate");
                int exRatePrec = CasRecPayHandler.getExRatePrec((String)currencyId, null, (String)companyId, (java.util.Date)bizDate);
                iRowSet.updateBigDecimal("receivingBill.exchangeRate", iRowSet.getBigDecimal("receivingBill.exchangeRate").setScale(exRatePrec, 4));
                iRowSet.updateString("recType.name", iRowSet.getString("recType.name"));
                iRowSet.updateString("settlementType.name", iRowSet.getString("settlementType.name"));
                iRowSet.updateString("person.name", iRowSet.getString("person.name"));
                iRowSet.updateString("adminOrgUnit.name", iRowSet.getString("adminOrgUnit.name"));
                iRowSet.updateString("coreBillNumber", iRowSet.getString("coreBillNumber"));
                iRowSet.updateString("coreBillType.name", iRowSet.getString("coreBillType.name"));
                iRowSet.updateString("contractNum", iRowSet.getString("contractNum"));
                iRowSet.updateString("contractEntrySeq", iRowSet.getString("contractEntrySeq"));
                iRowSet.updateBigDecimal("receivingBill.actRecAmt", iRowSet.getBigDecimal("receivingBill.actRecAmt").setScale(precision, 4));
                iRowSet.updateBigDecimal("receivingBill.actRecAmtVc", iRowSet.getBigDecimal("receivingBill.actRecAmtVc").setScale(precision, 4));
                iRowSet.updateBigDecimal("receivingBill.actRecLocAmt", iRowSet.getBigDecimal("receivingBill.actRecLocAmt").setScale(precision, 4));
                iRowSet.updateBigDecimal("receivingBill.actRecLocAmtVc", iRowSet.getBigDecimal("receivingBill.actRecLocAmtVc").setScale(precision, 4));
                iRowSet.updateBigDecimal("amount", iRowSet.getBigDecimal("amount").setScale(precision, 4));
                iRowSet.updateBigDecimal("amountVc", iRowSet.getBigDecimal("amountVc").setScale(precision, 4));
                iRowSet.updateBigDecimal("localAmt", iRowSet.getBigDecimal("localAmt").setScale(precision, 4));
                iRowSet.updateBigDecimal("localAmtVc", iRowSet.getBigDecimal("localAmtVc").setScale(precision, 4));
                iRowSet.updateBigDecimal("unVcAmount", iRowSet.getBigDecimal("unVcAmount").setScale(precision, 4));
                iRowSet.updateBigDecimal("unVcLocAmount", iRowSet.getBigDecimal("unVcLocAmount").setScale(precision, 4));
                iRowSet.updateBigDecimal("rebate", iRowSet.getBigDecimal("rebate").setScale(precision, 4));
                iRowSet.updateBigDecimal("rebateAmtVc", iRowSet.getBigDecimal("rebateAmtVc").setScale(precision, 4));
                iRowSet.updateBigDecimal("rebateLocAmt", iRowSet.getBigDecimal("rebateLocAmt").setScale(precision, 4));
                iRowSet.updateBigDecimal("rebateLocAmtVc", iRowSet.getBigDecimal("rebateLocAmtVc").setScale(precision, 4));
                iRowSet.updateBigDecimal("actualAmtVc", iRowSet.getBigDecimal("actualAmtVc").setScale(precision, 4));
                iRowSet.updateBigDecimal("actualLocAmt", iRowSet.getBigDecimal("actualLocAmt").setScale(precision, 4));
                iRowSet.updateBigDecimal("actualLocAmtVc", iRowSet.getBigDecimal("actualLocAmtVc").setScale(precision, 4));
                String billId = iRowSet.getString("id");
                MultiApproveCollection col = FSClientHelper.getMutiApprove((String)billId);
                for (int i = 1; i <= col.size() && i <= 5; ++i) {
                    MultiApproveInfo info = col.get(i - 1);
                    iRowSet.updateString("censor" + i, info.getCreator().getName());
                }
                if (iRowSet.getString("receivingBill.auditDate") != null) {
                    iRowSet.updateString("receivingBill.auditDate", iRowSet.getString("receivingBill.auditDate").substring(0, 10));
                }
                if (iRowSet.getString("payerType.name") == null) {
                    iRowSet.updateString("payerType.name", EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"374_PaymentBillDataProvider"));
                }
                iRowSet.updateString("sourceBillId", FMClientHelper.getBillNumber((String)iRowSet.getString("sourceBillId")));
                StringBuffer voucherNumber = new StringBuffer("");
                VoucherCollection colVoucher = null;
                if (!iRowSet.getBoolean("receivingBill.fiVouchered")) continue;
                colVoucher = FMClientHelper.getVoucherCollection((String)iRowSet.getString("receivingBill.id"));
                if (colVoucher != null && colVoucher.size() > 0) {
                    for (VoucherInfo info : colVoucher) {
                        voucherNumber.append(info.getNumber());
                        voucherNumber.append("  ");
                    }
                }
                iRowSet.updateString("voucherNumber", voucherNumber.toString());
            }
            iRowSet.beforeFirst();
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Component)((CoreUI)null), (Throwable)e1);
        }
        return iRowSet;
    }

    public boolean existEntryEntity(String dsReference) {
        IMetaDataPK pk = MetaDataPKFactory.getMetaDataPK((String)dsReference);
        QueryInfo queryInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery(pk);
        SubObjectCollection subObjCol = queryInfo.getSubObjects();
        for (int i = 0; i < subObjCol.size(); ++i) {
            SubObjectInfo subObj = subObjCol.get(i);
            if (!"ReceivingBillEntry".equals(subObj.getName())) continue;
            return true;
        }
        return false;
    }

    private void updatePrintCount(Map paramMap) {
        if (paramMap != null && paramMap.size() > 0) {
            try {
                IPaymentBill ipb = PaymentBillFactory.getRemoteInstance();
                ipb.updatePrintCount(paramMap);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
        }
    }

    public ArrayList getDataFilter(R1PrintDataSource dataSource) {
        ArrayList<DSParam> kdfDs = new ArrayList<DSParam>();
        R1PrintDataParameter[] r1Params = dataSource.getParams();
        for (int i = 0; i < r1Params.length; ++i) {
            R1PrintDataParameter r1Param = r1Params[i];
            DSParam kdfParam = new DSParam(r1Param.getId(), r1Param.getAssociateSource(), r1Param.getAssociateField());
            if (r1Param.getValue() != null) {
                kdfParam.setValue(new Variant(r1Param.getValue().getValue()));
                if (StringUtil.isEmptyString((String)r1Param.getAssociateSource())) {
                    kdfParam.setAssociateField(r1Param.getValue().toString());
                    log.info((Object)("KdfToR1\u8f6c\u53c2\u6570:" + kdfParam.getColName() + "" + kdfParam.getValue()));
                }
            } else {
                kdfParam.setValue(Variant.getNewEmptyVariant());
            }
            kdfDs.add(kdfParam);
        }
        return kdfDs;
    }

    class ReceivingBillPrintListener
    implements IPrintActionListener {
        public void beforePrintOrPreview() {
        }

        public void beforePreview() {
        }

        public void beforePrint() {
            try {
                if (ReceivingBillNewDataProvider.this.currentHelper.isPrintTimesControllable2(ReceivingBillNewDataProvider.this.templatePath)) {
                    int printedTimes = NotePrtRecordUtil.getPrintedTimes((IObjectPK)ReceivingBillNewDataProvider.this.currentPK);
                    int prepareTimes = ReceivingBillNewDataProvider.this.currentHelper.getCopies();
                    int maxPrintTimes = ReceivingBillNewDataProvider.this.currentHelper.getMaxPrintTimes2(ReceivingBillNewDataProvider.this.templatePath);
                    if (printedTimes >= maxPrintTimes) {
                        MsgBox.showError((String)CasForArApUtil.getStrResource("printCountIsOver"));
                        ReceivingBillNewDataProvider.this.currentHelper.diposePrint();
                        SysUtil.abort();
                    } else if (printedTimes + prepareTimes > maxPrintTimes) {
                        MsgBox.showWarning((String)CasForArApUtil.getStrResource("printCountIsOverRemainCan"));
                        int remain = maxPrintTimes - printedTimes;
                        ReceivingBillNewDataProvider.this.currentHelper.setCopies(remain);
                        NotePrtRecordUtil.updatePrtTimes((String)ReceivingBillNewDataProvider.this.templatePath, (IObjectPK)ReceivingBillNewDataProvider.this.currentPK, (int)remain);
                    } else {
                        ReceivingBillNewDataProvider.this.currentHelper.setCopies(prepareTimes);
                        NotePrtRecordUtil.updatePrtTimes((String)ReceivingBillNewDataProvider.this.templatePath, (IObjectPK)ReceivingBillNewDataProvider.this.currentPK, (int)prepareTimes);
                    }
                    HashMap<String, Integer> idMap = new HashMap<String, Integer>();
                    idMap.put(ReceivingBillNewDataProvider.this.currentPK.toString(), new Integer(prepareTimes));
                    ReceivingBillNewDataProvider.this.updatePrintCount(idMap);
                } else {
                    NotePrtRecordUtil.updatePrtTimes((String)ReceivingBillNewDataProvider.this.templatePath, (IObjectPK)ReceivingBillNewDataProvider.this.currentPK, (int)0);
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }

        public void closePreview() {
        }
    }
}

