/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.validate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.AbstractRecPayBillInfo;
import com.kingdee.eas.fi.cas.ArApRecPayException;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.CasForArApException;
import com.kingdee.eas.fi.cas.CasRecPayBillTypeEnum;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.IReceivingBill;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.ReceivingBillEntryCollection;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.ArApRecPayServerHelper;
import com.kingdee.eas.fi.cas.validate.AbstractPaymentBillValidator;
import com.kingdee.eas.fi.cas.validate.ValidateResult;
import com.kingdee.eas.fm.be.BankPayingBillCollection;
import com.kingdee.eas.fm.be.BankPayingBillFactory;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.IContextHelper;
import com.kingdee.eas.fm.fs.ISettlementBill;
import com.kingdee.eas.fm.fs.SettBizTypeEnum;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.nt.PayableBillFactory;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.fm.nt.PayableBillStateEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PaymentBillCancelPayValidator
extends AbstractPaymentBillValidator {
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    private static String AP_OTHERBILL_BOSTYPE = "48DA3A71";
    private int tm105 = 0;
    private Map destBillIDSet_Map;
    private PaymentBillCollection srcAgentPayBill = null;

    @Override
    public void internValidate(Context ctx, IObjectValue objectValue) throws BOSException, EASBizException {
        PaymentBillInfo info = (PaymentBillInfo)objectValue;
        if (!info.getBillStatus().equals((Object)BillStatusEnum.PAYED)) {
            throw new RecPayException(RecPayException.CANNOT_CANCELPAY_BEFORE_PAYED);
        }
        boolean isVoucher = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS017", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        if (!EmptyUtil.isEmpty((String)info.getVoucherNumber())) {
            if (info.isIsAppointVoucher()) {
                throw new CasException(CasException.HASAPPOINTMENTVOUCHER_PAY);
            }
            if (isVoucher) {
                throw new CasException(CasException.MUSTDELVOUCHERFORPAY_2, new Object[]{info.getNumber()});
            }
        }
        if (isVoucher && info.isPcaVouchered()) {
            throw new CasException(CasException.MUSTDELPCAVOUCHERFORPAY, new Object[]{info.getNumber()});
        }
        boolean isForBE = (Boolean)ctx.get((Object)"isForBE");
        if (!isForBE) {
            if (info.isIsCommittoBe()) {
                throw new CasException(CasException.UNSETTLEERROR);
            }
            if (this.hasGenPayInfo(ctx, info.getId().toString())) {
                throw new CasException(CasException.UNSETTLEERROR);
            }
        }
        if (ctx.get((Object)"cancelPayFromAgentOrgFlag") == null) {
            PaymentBillInfo agentBillInfo;
            String agentBillID = info.getAgentPaymentBillID();
            IPaymentBill biz = PaymentBillFactory.getLocalInstance(ctx);
            if (!FMHelper.isEmpty((String)agentBillID) && biz.exists(ConvertUtils.PK((Object)agentBillID)) && BillStatusEnum.PAYED == (agentBillInfo = biz.getPaymentBillInfo(ConvertUtils.PK((Object)agentBillID))).getBillStatus()) {
                throw new CasException(CasException.REALPAYBILLHASPAYEDNOTCANCELPAY);
            }
        }
        boolean isFinance = info.getPayBillType() != null && info.getPayBillType().isIsFinanceTranUp() && this.tm105 == 0;
        boolean isRecBySettle = this.checkIsActionFromSettle(ctx, info.getId().toString());
        if (!isRecBySettle && !isFinance) {
            this.isCanManualRecPay(ctx, info);
        }
        this.checkPSClose(ctx, info);
        if (info.getSourceType() == SourceTypeEnum.AP) {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            String value = null;
            UserInfo userInfo = null;
            SystemStatusCtrolInfo arapStatus = ArApRecPayServerHelper.getSysStatusCtrolInfo(ctx, info.getCompany(), SystemEnum.ACCOUNTSPAYABLE);
            if (info.getBizDate().before(arapStatus.getCurrentPeriod().getBeginDate())) {
                throw new CasForArApException(CasForArApException.BIZDATEBEFORCURRENTPERIOD);
            }
            if (!paramMap.containsKey(info.getCompany().getId().toString())) {
                value = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"AP_027");
                paramMap.put(info.getCompany().getId().toString(), value);
            } else {
                value = paramMap.get(info.getCompany().getId().toString()).toString();
            }
            if (value != null && ("true".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value)) && (userInfo = ContextUtil.getCurrentUserInfo((Context)ctx)) != null && info.getCashier() != null && !userInfo.getId().toString().equals(info.getCashier().getId().toString())) {
                throw new ArApRecPayException(ArApRecPayException.RECPAY_IS_SAMEPAYER_PERSON);
            }
        }
        PaymentBillEntryCollection entryColl = info.getEntries();
        PaymentBillEntryInfo entryInfo = null;
        BigDecimal matchedAmount = ZERO;
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = entryColl.get(i);
            if (entryInfo == null) continue;
            if (entryInfo.getMatchedAmount() == null) {
                entryInfo.setMatchedAmount(ZERO);
            }
            if (entryInfo.getMatchedAmountLoc() == null) {
                entryInfo.setMatchedAmountLoc(ZERO);
            }
            matchedAmount = matchedAmount.add(entryInfo.getMatchedAmount());
        }
        if (matchedAmount.signum() != 0) {
            throw new ArApRecPayException(ArApRecPayException.PAY_NOTALLCANCELPAY_MATCHEDAMOUNTISNOTZEOR);
        }
        ISettlementBill isettle = SettlementBillFactory.getLocalInstance((Context)ctx);
        IReceivingBill iReceivingBill = ReceivingBillFactory.getLocalInstance(ctx);
        Set destSet = (Set)this.destBillIDSet_Map.get(info.getId().toString());
        if (destSet != null && destSet.size() > 0) {
            List destList = FMHelper.set2List((Set)destSet);
            for (int i = 0; i < destList.size(); ++i) {
                PayableBillInfo payableBillInfo;
                SettlementBillInfo settleInfo;
                ReceivingBillInfo receivingBillInfo;
                String bizBillId = destList.get(i).toString();
                BOSObjectType bosType = BOSUuid.read((String)bizBillId).getType();
                ObjectUuidPK pk = new ObjectUuidPK(bizBillId);
                if (bosType.equals((Object)new ReceivingBillInfo().getBOSType()) && (receivingBillInfo = iReceivingBill.getReceivingBillInfo((IObjectPK)pk)).isIsCoopBuild()) {
                    ReceivingBillEntryCollection entryCol = receivingBillInfo.getEntries();
                    Iterator iterator = entryCol.iterator();
                    while (iterator.hasNext()) {
                        ReceivingBillEntryInfo rentryInfo = (ReceivingBillEntryInfo)iterator.next();
                        BigDecimal verifyAmount = rentryInfo.getAmountVc();
                        if (verifyAmount.compareTo(SysConstant.BIGZERO) == 0 && !receivingBillInfo.isFiVouchered() && 14 != receivingBillInfo.getBillStatus().getValue() && 12 != receivingBillInfo.getBillStatus().getValue()) continue;
                        throw new RecPayException(RecPayException.CANNOTDELETEFORCANCELPAY, new String[]{receivingBillInfo.getNumber()});
                    }
                }
                if (bosType.equals((Object)new SettlementBillInfo().getBOSType()) && (settleInfo = isettle.getSettlementBillInfo((IObjectPK)pk)).getType().equals((Object)SettBizTypeEnum.RECOUTSIDE) && settleInfo.isIsAccepted()) {
                    throw new RecPayException(RecPayException.CANNOTREVERSEPAY);
                }
                if (!bosType.equals((Object)new PayableBillInfo().getBOSType()) || PayableBillStateEnum.SUBMIT.equals((Object)(payableBillInfo = PayableBillFactory.getLocalInstance((Context)ctx).getPayableBillInfo((IObjectPK)pk)).getBillState()) || PayableBillStateEnum.TempSaved.equals((Object)payableBillInfo.getBillState())) continue;
                throw new RecPayException(RecPayException.CANNOT_CANCELPAY_WHEN_PAYABLEBILL_PROCESSED);
            }
        }
        try {
            if (info.getPaymentBillType() != CasRecPayBillTypeEnum.RealType) {
                StringBuffer sb = new StringBuffer();
                sb.append("SELECT 1 FROM t_bot_Relation bot INNER JOIN T_CAS_PaymentBill bill ON bot.fDestObjectId = bill.fid");
                sb.append(" WHERE bot.fSrcObjectId = '").append(info.getId().toString()).append("'");
                sb.append(" AND bot.fSrcEntityID = '").append(info.getBOSType().toString()).append("'");
                sb.append(" AND bot.fDestEntityID = '").append(info.getBOSType().toString()).append("'");
                sb.append(" AND bill.fSourceSysType = ").append(101);
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                if (rs.next()) {
                    throw new ArApRecPayException(ArApRecPayException.HASREFUNDDESTBILL);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void init(Context ctx) {
        IContextHelper ctxHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo companyInfo = ctxHelper.getCurrentCompany();
        this.tm105 = ctxHelper.getIntParam("TM105", (IObjectPK)new ObjectUuidPK(companyInfo.getId().toString()));
    }

    @Override
    public ValidateResult validate(Context ctx, IObjectCollection abstractObjectCollection, boolean throwException) throws BOSException, EASBizException {
        PaymentBillCollection coll = (PaymentBillCollection)abstractObjectCollection;
        this.getAgentBillCollection(ctx, coll);
        HashSet<String> idSet = new HashSet<String>();
        int j = coll.size();
        for (int i = 0; i < j; ++i) {
            idSet.add(coll.get(i).getId().toString());
        }
        this.destBillIDSet_Map = FMHelper.getDestBillIDSet((Context)ctx, idSet);
        ValidateResult result = super.validate(ctx, abstractObjectCollection, throwException);
        AbstractRecPayBillInfo info = null;
        if (coll != null && coll.size() > 0) {
            info = coll.get(0);
        }
        if (info != null && info.getSourceType() == SourceTypeEnum.AP && result.getValidIdSet().size() > 0) {
            IBOTRelation iBotRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
            EntityViewInfo btpView = new EntityViewInfo();
            btpView.getSelector().add(new SelectorItemInfo("srcEntityID"));
            btpView.getSelector().add(new SelectorItemInfo("srcObjectID"));
            FilterInfo entryFilter = new FilterInfo();
            entryFilter.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)result.getValidIdSet(), CompareType.INCLUDE));
            btpView.setFilter(entryFilter);
            BOTRelationCollection relColl = iBotRelation.getCollection(btpView);
            HashSet<String> apOtherbillIdSet = new HashSet<String>();
            if (null != relColl && relColl.size() > 0) {
                Iterator relIterator = relColl.iterator();
                BOTRelationInfo relInfo = null;
                String srcEntityID = null;
                while (relIterator.hasNext()) {
                    relInfo = (BOTRelationInfo)relIterator.next();
                    srcEntityID = relInfo.getSrcEntityID();
                    if (!AP_OTHERBILL_BOSTYPE.equalsIgnoreCase(srcEntityID)) continue;
                    apOtherbillIdSet.add(relInfo.getSrcObjectID());
                }
            }
            if (apOtherbillIdSet.size() > 0) {
                BOSObjectType otherBillBosType = BOSObjectType.create((String)AP_OTHERBILL_BOSTYPE);
                IDynamicObject iObjectInstance = DynamicObjectFactory.getLocalInstance((Context)ctx);
                EntityViewInfo otherbillView = new EntityViewInfo();
                otherbillView.getSelector().add(new SelectorItemInfo("prePayBillNumber"));
                otherbillView.getSelector().add(new SelectorItemInfo("number"));
                FilterInfo otherbillFilter = new FilterInfo();
                otherbillFilter.getFilterItems().add(new FilterItemInfo("id", apOtherbillIdSet, CompareType.INCLUDE));
                otherbillView.setFilter(otherbillFilter);
                IObjectCollection otherbillcoll = iObjectInstance.getCollection(otherBillBosType, otherbillView);
                String prePayBillNumber = null;
                String billNumber = null;
                IObjectValue otherbillInfo2 = null;
                StringBuilder otherbillNums = new StringBuilder();
                if (null != otherbillcoll && otherbillcoll.size() > 0) {
                    for (IObjectValue otherbillInfo2 : otherbillcoll) {
                        billNumber = otherbillInfo2.getString("number");
                        prePayBillNumber = otherbillInfo2.getString("prePayBillNumber");
                        if (StringUtils.isEmpty((String)prePayBillNumber) || !prePayBillNumber.contains(info.getNumber())) continue;
                        otherbillNums.append(billNumber).append(",");
                    }
                }
                if (otherbillNums.length() > 0) {
                    String otherbillNumsStr = otherbillNums.substring(0, otherbillNums.length() - 1);
                    throw new CasForArApException(CasForArApException.PAYMENTBILL_HAS_PREVERIFIED, new Object[]{info.getNumber(), otherbillNumsStr});
                }
            }
        }
        return result;
    }

    @Override
    public ValidateResult validate(Context ctx, IObjectCollection abstractObjectCollection, boolean throwException, boolean isForBE) throws BOSException, EASBizException {
        PaymentBillCollection coll = (PaymentBillCollection)abstractObjectCollection;
        this.getAgentBillCollection(ctx, coll);
        HashSet<String> idSet = new HashSet<String>();
        int j = coll.size();
        for (int i = 0; i < j; ++i) {
            idSet.add(coll.get(i).getId().toString());
        }
        this.destBillIDSet_Map = FMHelper.getDestBillIDSet((Context)ctx, idSet);
        ValidateResult result = super.validate(ctx, abstractObjectCollection, throwException, isForBE);
        AbstractRecPayBillInfo info = null;
        if (coll != null && coll.size() > 0) {
            info = coll.get(0);
        }
        if (info != null && info.getSourceType() == SourceTypeEnum.AP && result.getValidIdSet().size() > 0) {
            IBOTRelation iBotRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
            EntityViewInfo btpView = new EntityViewInfo();
            btpView.getSelector().add(new SelectorItemInfo("srcEntityID"));
            btpView.getSelector().add(new SelectorItemInfo("srcObjectID"));
            FilterInfo entryFilter = new FilterInfo();
            entryFilter.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)result.getValidIdSet(), CompareType.INCLUDE));
            btpView.setFilter(entryFilter);
            BOTRelationCollection relColl = iBotRelation.getCollection(btpView);
            HashSet<String> apOtherbillIdSet = new HashSet<String>();
            if (null != relColl && relColl.size() > 0) {
                Iterator relIterator = relColl.iterator();
                BOTRelationInfo relInfo = null;
                String srcEntityID = null;
                while (relIterator.hasNext()) {
                    relInfo = (BOTRelationInfo)relIterator.next();
                    srcEntityID = relInfo.getSrcEntityID();
                    if (!AP_OTHERBILL_BOSTYPE.equalsIgnoreCase(srcEntityID)) continue;
                    apOtherbillIdSet.add(relInfo.getSrcObjectID());
                }
            }
            if (apOtherbillIdSet.size() > 0) {
                BOSObjectType otherBillBosType = BOSObjectType.create((String)AP_OTHERBILL_BOSTYPE);
                IDynamicObject iObjectInstance = DynamicObjectFactory.getLocalInstance((Context)ctx);
                EntityViewInfo otherbillView = new EntityViewInfo();
                otherbillView.getSelector().add(new SelectorItemInfo("prePayBillNumber"));
                otherbillView.getSelector().add(new SelectorItemInfo("number"));
                FilterInfo otherbillFilter = new FilterInfo();
                otherbillFilter.getFilterItems().add(new FilterItemInfo("id", apOtherbillIdSet, CompareType.INCLUDE));
                otherbillView.setFilter(otherbillFilter);
                IObjectCollection otherbillcoll = iObjectInstance.getCollection(otherBillBosType, otherbillView);
                String prePayBillNumber = null;
                String billNumber = null;
                IObjectValue otherbillInfo2 = null;
                StringBuilder otherbillNums = new StringBuilder();
                if (null != otherbillcoll && otherbillcoll.size() > 0) {
                    for (IObjectValue otherbillInfo2 : otherbillcoll) {
                        billNumber = otherbillInfo2.getString("number");
                        prePayBillNumber = otherbillInfo2.getString("prePayBillNumber");
                        if (StringUtils.isEmpty((String)prePayBillNumber) || !prePayBillNumber.contains(info.getNumber())) continue;
                        otherbillNums.append(billNumber).append(",");
                    }
                }
                if (otherbillNums.length() > 0) {
                    String otherbillNumsStr = otherbillNums.substring(0, otherbillNums.length() - 1);
                    throw new CasForArApException(CasForArApException.PAYMENTBILL_HAS_PREVERIFIED, new Object[]{info.getNumber(), otherbillNumsStr});
                }
            }
        }
        return result;
    }

    private void getAgentBillCollection(Context ctx, PaymentBillCollection coll) throws BOSException {
        HashSet<String> agentBillIDSet = new HashSet<String>();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            PaymentBillInfo paymentbill = coll.get(i);
            if (FMHelper.isEmpty((String)paymentbill.getSrcAgenPaymentBillID())) continue;
            agentBillIDSet.add(paymentbill.getSrcAgenPaymentBillID());
        }
        if (agentBillIDSet.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", agentBillIDSet, CompareType.INCLUDE));
            this.srcAgentPayBill = PaymentBillFactory.getLocalInstance(ctx).getPaymentBillCollection(view);
        }
    }

    private boolean hasGenPayInfo(Context ctx, String srcBillId) throws BOSException {
        if (EmptyUtil.isEmpty((String)srcBillId)) {
            return false;
        }
        BankPayingBillCollection oldColl = this.getOldColl(ctx, srcBillId);
        return oldColl != null && !oldColl.isEmpty();
    }

    private BankPayingBillCollection getOldColl(Context ctx, String srcBillId) throws BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)srcBillId));
        filter.getFilterItems().add(new FilterItemInfo("isBitBack", (Object)0));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(sic);
        evi.setFilter(filter);
        BankPayingBillCollection oldColl = BankPayingBillFactory.getLocalInstance((Context)ctx).getBankPayingBillCollection(evi);
        return oldColl;
    }

    @Override
    public void internValidate(Context ctx, IObjectValue objectValue, boolean isForBE) throws BOSException, EASBizException {
        PaymentBillInfo info = (PaymentBillInfo)objectValue;
        if (!info.getBillStatus().equals((Object)BillStatusEnum.PAYED)) {
            throw new RecPayException(RecPayException.CANNOT_CANCELPAY_BEFORE_PAYED);
        }
        boolean isVoucher = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS017", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        if (!EmptyUtil.isEmpty((String)info.getVoucherNumber())) {
            if (info.isIsAppointVoucher()) {
                throw new CasException(CasException.HASAPPOINTVOUCHERFORPAY, new Object[]{info.getNumber()});
            }
            if (isVoucher) {
                throw new CasException(CasException.MUSTDELVOUCHERFORPAY_2, new Object[]{info.getNumber()});
            }
        }
        if (isVoucher && info.isPcaVouchered()) {
            throw new CasException(CasException.MUSTDELPCAVOUCHERFORPAY, new Object[]{info.getNumber()});
        }
        if (!isForBE) {
            if (info.isIsCommittoBe()) {
                throw new CasException(CasException.UNSETTLEERROR);
            }
            if (this.hasGenPayInfo(ctx, info.getId().toString())) {
                throw new CasException(CasException.UNSETTLEERROR);
            }
        }
        if (ctx.get((Object)"cancelPayFromAgentOrgFlag") == null) {
            PaymentBillInfo agentBillInfo;
            String agentBillID = info.getAgentPaymentBillID();
            IPaymentBill biz = PaymentBillFactory.getLocalInstance(ctx);
            if (!FMHelper.isEmpty((String)agentBillID) && biz.exists(ConvertUtils.PK((Object)agentBillID)) && BillStatusEnum.PAYED == (agentBillInfo = biz.getPaymentBillInfo(ConvertUtils.PK((Object)agentBillID))).getBillStatus()) {
                throw new CasException(CasException.REALPAYBILLHASPAYEDNOTCANCELPAY);
            }
        }
        boolean isFinance = info.getPayBillType() != null && info.getPayBillType().isIsFinanceTranUp() && this.tm105 == 0;
        boolean isRecBySettle = this.checkIsActionFromSettle(ctx, info.getId().toString());
        if (!isRecBySettle && !isFinance) {
            this.isCanManualRecPay(ctx, info);
        }
        this.checkPSClose(ctx, info);
        if (info.getSourceType() == SourceTypeEnum.AP) {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            String value = null;
            UserInfo userInfo = null;
            SystemStatusCtrolInfo arapStatus = ArApRecPayServerHelper.getSysStatusCtrolInfo(ctx, info.getCompany(), SystemEnum.ACCOUNTSPAYABLE);
            if (info.getBizDate().before(arapStatus.getCurrentPeriod().getBeginDate())) {
                throw new CasForArApException(CasForArApException.BIZDATEBEFORCURRENTPERIOD);
            }
            if (!paramMap.containsKey(info.getCompany().getId().toString())) {
                value = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"AP_027");
                paramMap.put(info.getCompany().getId().toString(), value);
            } else {
                value = paramMap.get(info.getCompany().getId().toString()).toString();
            }
            if (value != null && ("true".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value)) && (userInfo = ContextUtil.getCurrentUserInfo((Context)ctx)) != null && info.getCashier() != null && !userInfo.getId().toString().equals(info.getCashier().getId().toString())) {
                throw new ArApRecPayException(ArApRecPayException.RECPAY_IS_SAMEPAYER_PERSON);
            }
        }
        PaymentBillEntryCollection entryColl = info.getEntries();
        PaymentBillEntryInfo entryInfo = null;
        BigDecimal matchedAmount = ZERO;
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = entryColl.get(i);
            if (entryInfo == null) continue;
            if (entryInfo.getMatchedAmount() == null) {
                entryInfo.setMatchedAmount(ZERO);
            }
            if (entryInfo.getMatchedAmountLoc() == null) {
                entryInfo.setMatchedAmountLoc(ZERO);
            }
            matchedAmount = matchedAmount.add(entryInfo.getMatchedAmount());
        }
        if (matchedAmount.signum() != 0) {
            throw new ArApRecPayException(ArApRecPayException.PAY_NOTALLCANCELPAY_MATCHEDAMOUNTISNOTZEOR);
        }
        ISettlementBill isettle = SettlementBillFactory.getLocalInstance((Context)ctx);
        IReceivingBill iReceivingBill = ReceivingBillFactory.getLocalInstance(ctx);
        Set destSet = (Set)this.destBillIDSet_Map.get(info.getId().toString());
        if (destSet != null && destSet.size() > 0) {
            List destList = FMHelper.set2List((Set)destSet);
            for (int i = 0; i < destList.size(); ++i) {
                PayableBillInfo payableBillInfo;
                SettlementBillInfo settleInfo;
                ReceivingBillInfo receivingBillInfo;
                String bizBillId = destList.get(i).toString();
                BOSObjectType bosType = BOSUuid.read((String)bizBillId).getType();
                ObjectUuidPK pk = new ObjectUuidPK(bizBillId);
                if (bosType.equals((Object)new ReceivingBillInfo().getBOSType()) && (receivingBillInfo = iReceivingBill.getReceivingBillInfo((IObjectPK)pk)).isIsCoopBuild()) {
                    ReceivingBillEntryCollection entryCol = receivingBillInfo.getEntries();
                    Iterator iterator = entryCol.iterator();
                    while (iterator.hasNext()) {
                        ReceivingBillEntryInfo rentryInfo = (ReceivingBillEntryInfo)iterator.next();
                        BigDecimal verifyAmount = rentryInfo.getAmountVc();
                        if (verifyAmount.compareTo(SysConstant.BIGZERO) == 0 && !receivingBillInfo.isFiVouchered() && 14 != receivingBillInfo.getBillStatus().getValue() && 12 != receivingBillInfo.getBillStatus().getValue()) continue;
                        throw new RecPayException(RecPayException.CANNOTDELETEFORCANCELPAY, new String[]{receivingBillInfo.getNumber()});
                    }
                }
                if (bosType.equals((Object)new SettlementBillInfo().getBOSType()) && (settleInfo = isettle.getSettlementBillInfo((IObjectPK)pk)).getType().equals((Object)SettBizTypeEnum.RECOUTSIDE) && settleInfo.isIsAccepted()) {
                    throw new RecPayException(RecPayException.CANNOTREVERSEPAY);
                }
                if (!bosType.equals((Object)new PayableBillInfo().getBOSType()) || PayableBillStateEnum.SUBMIT.equals((Object)(payableBillInfo = PayableBillFactory.getLocalInstance((Context)ctx).getPayableBillInfo((IObjectPK)pk)).getBillState()) || PayableBillStateEnum.TempSaved.equals((Object)payableBillInfo.getBillState())) continue;
                throw new RecPayException(RecPayException.CANNOT_CANCELPAY_WHEN_PAYABLEBILL_PROCESSED);
            }
        }
        try {
            if (info.getPaymentBillType() != CasRecPayBillTypeEnum.RealType) {
                StringBuffer sb = new StringBuffer();
                sb.append("SELECT 1 FROM t_bot_Relation bot INNER JOIN T_CAS_PaymentBill bill ON bot.fDestObjectId = bill.fid");
                sb.append(" WHERE bot.fSrcObjectId = '").append(info.getId().toString()).append("'");
                sb.append(" AND bot.fSrcEntityID = '").append(info.getBOSType().toString()).append("'");
                sb.append(" AND bot.fDestEntityID = '").append(info.getBOSType().toString()).append("'");
                sb.append(" AND bill.fSourceSysType = ").append(101);
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                if (rs.next()) {
                    throw new ArApRecPayException(ArApRecPayException.HASREFUNDDESTBILL);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

