/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.vo;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fi.cas.vo.WelcomePageFundRptCategoryVO;
import com.kingdee.eas.fi.cas.vo.WelcomePageFundRptChartVO;
import com.kingdee.eas.fi.cas.vo.WelcomePageFundRptDatasetVO;
import com.kingdee.eas.fi.cas.vo.WelcomePageFundRptTrendlinesVO;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class WelcomePageFundRptVO
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String CN_RECEIPTNAME = "WorkPlatform_Receipt";
    private static final String CN_RECEIPTCOLOR = "21BAFD";
    private static final String CN_PAYMENTNAME = "WorkPlatform_Payment";
    private static final String CN_PAYMENTCOLOR = "FFA123";
    private static final String CN_BALANCENAME = "WorkPlatform_Balance";
    private static final String CN_BALANCECOLOR = "5DE2A8";
    private static final String CN_AVERAGELABEL = "WorkPlatform_AverageLabel";
    private static final String CN_AVERAGECOLOR = "A0522D";
    public static SimpleDateFormat DATE_FM = new SimpleDateFormat("yyyy-MM-dd");
    private WelcomePageFundRptChartVO chart;
    private List<WelcomePageFundRptCategoryVO> categories;
    private List<WelcomePageFundRptDatasetVO> dataset;
    private List<WelcomePageFundRptTrendlinesVO> trendlines;

    public WelcomePageFundRptVO() {
    }

    public WelcomePageFundRptVO(Context ctx, boolean autoDef, Date startDate, Date endDate) {
        Long diff;
        if (!autoDef) {
            return;
        }
        int minVal = 15;
        if (startDate == null || endDate == null) {
            endDate = new Date();
            startDate = DateUtil.getFirstDayOfMonth((Date)endDate);
        }
        if ((diff = Long.valueOf(Math.abs(DateUtil.dateDiff((String)"d", (Date)endDate, (Date)startDate)))).compareTo(new Long(minVal)) > 0) {
            minVal = diff.intValue() + 1;
        }
        if (this.getChart() == null) {
            WelcomePageFundRptChartVO chartVO = new WelcomePageFundRptChartVO();
            this.setChart(chartVO);
            Calendar cal = Calendar.getInstance();
            cal.setTime(startDate);
            String[] args = new String[]{String.valueOf(cal.get(1)), String.valueOf(cal.get(2) + 1)};
            chartVO.setCaption(CASWebUtil.getResource(ctx, "WorkPlatform_CashFlowChartName", args));
            chartVO.setNumvdivlines(0);
        }
        if (this.getCategories().size() <= 0) {
            WelcomePageFundRptCategoryVO categoryVO = new WelcomePageFundRptCategoryVO();
            this.getCategories().add(categoryVO);
            for (int idx = 0; idx < minVal + 1; ++idx) {
                WelcomePageFundRptCategoryVO.WelcomePageFundRptCategory_LabelVO cLabelVo = categoryVO.new WelcomePageFundRptCategoryVO.WelcomePageFundRptCategory_LabelVO();
                cLabelVo.setLabel(Integer.toString(idx));
                categoryVO.getCategory().add(cLabelVo);
            }
        }
        if (this.getDataset().size() <= 0) {
            WelcomePageFundRptDatasetVO recDataVO = new WelcomePageFundRptDatasetVO();
            this.getDataset().add(recDataVO);
            recDataVO.setSeriesname(CASWebUtil.getResource(ctx, CN_RECEIPTNAME));
            recDataVO.setColor(CN_RECEIPTCOLOR);
            recDataVO.setAnchorbordercolor(CN_RECEIPTCOLOR);
            WelcomePageFundRptDatasetVO payDataVO = new WelcomePageFundRptDatasetVO();
            this.getDataset().add(payDataVO);
            payDataVO.setSeriesname(CASWebUtil.getResource(ctx, CN_PAYMENTNAME));
            payDataVO.setColor(CN_PAYMENTCOLOR);
            payDataVO.setAnchorbordercolor(CN_PAYMENTCOLOR);
            WelcomePageFundRptDatasetVO balanceDataVO = new WelcomePageFundRptDatasetVO();
            this.getDataset().add(balanceDataVO);
            balanceDataVO.setSeriesname(CASWebUtil.getResource(ctx, CN_BALANCENAME));
            balanceDataVO.setColor(CN_BALANCECOLOR);
            balanceDataVO.setAnchorbordercolor(CN_BALANCECOLOR);
        }
        if (this.getTrendlines().size() <= 0) {
            WelcomePageFundRptTrendlinesVO linesVO = new WelcomePageFundRptTrendlinesVO();
            this.getTrendlines().add(linesVO);
            WelcomePageFundRptTrendlinesVO.WelcomePageFundRptTrendlines_LineVO balanceLineVO = linesVO.new WelcomePageFundRptTrendlinesVO.WelcomePageFundRptTrendlines_LineVO();
            linesVO.getLine().add(balanceLineVO);
            balanceLineVO.setDisplayvalue(CASWebUtil.getResource(ctx, CN_AVERAGELABEL));
            balanceLineVO.setColor(CN_AVERAGECOLOR);
        }
    }

    public WelcomePageFundRptChartVO getChart() {
        return this.chart;
    }

    public void setChart(WelcomePageFundRptChartVO chart) {
        this.chart = chart;
    }

    public List<WelcomePageFundRptCategoryVO> getCategories() {
        if (this.categories == null) {
            this.categories = new ArrayList<WelcomePageFundRptCategoryVO>();
        }
        return this.categories;
    }

    public void setCategories(List<WelcomePageFundRptCategoryVO> categories) {
        this.categories = categories;
    }

    public List<WelcomePageFundRptDatasetVO> getDataset() {
        if (this.dataset == null) {
            this.dataset = new ArrayList<WelcomePageFundRptDatasetVO>();
        }
        return this.dataset;
    }

    public void setDataset(List<WelcomePageFundRptDatasetVO> dataset) {
        this.dataset = dataset;
    }

    public List<WelcomePageFundRptTrendlinesVO> getTrendlines() {
        if (this.trendlines == null) {
            this.trendlines = new ArrayList<WelcomePageFundRptTrendlinesVO>();
        }
        return this.trendlines;
    }

    public void setTrendlines(List<WelcomePageFundRptTrendlinesVO> trendlines) {
        this.trendlines = trendlines;
    }

    public static long getSerialversionuid() {
        return 1L;
    }
}

