/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.dbclean.app;

import com.kingdee.bos.sql.shell.KDConnection;
import com.kingdee.eas.base.dbclean.JZContext;
import com.kingdee.eas.base.dbclean.JZTaskException;
import com.kingdee.eas.base.dbclean.app.CodeJZTask;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BankStatementJZTask
extends CodeJZTask {
    public boolean doTask(JZContext context) throws JZTaskException {
        String companyId = context.getOrgFId();
        String periodId = context.getPeriodFId();
        Date endDate = context.getEndDt();
        String sql1 = "";
        String sql2 = "";
        String sql3 = "";
        KDConnection conn = context.getDbConn();
        PreparedStatement ps1 = null;
        PreparedStatement ps2 = null;
        PreparedStatement ps3 = null;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        BigDecimal monthBalance = null;
        BigDecimal debitAmt = null;
        BigDecimal creditAmt = null;
        BigDecimal finalAmt = null;
        BigDecimal debitStartAmt = null;
        BigDecimal creditStartAmt = null;
        Map resultMap = new HashMap();
        String currencyId = "";
        String accountBankId2 = "";
        String accountViewId = "";
        Iterator itCurrency = this.getCurrencyList(context).iterator();
        Iterator itAccountBank = null;
        sql1 = "select fmonthbalance from T_CAS_JOURNALBALANCE where fcompanyid=? and faccountbankid=? and fcurrencyid=? and fisinit=1 and ftype=3";
        sql2 = "select sum(FDebitAmount) debitAmt, sum(FCreditAmount) creditAmt from T_CAS_BANKSTATEMENT where fcompanyid=? and faccountbankid=? and fcurrencyid=? and FPeriodId IS NOT NULL and FCreateDate < ?";
        sql3 = "update T_CAS_JOURNALBALANCE set FMonthStartAmt=?,FMonthBalance=?,FYearStartAmt=?,FYearBalance=?,FDebitStartAmt=?,FCreditStartAmt=?,FPeriodId=?  where FCompanyid=? and FAccountBankid=? and FCurrencyId=? and ftype=3";
        try {
            ps3 = conn.prepareStatement(sql3);
            int i = 0;
            while (itCurrency.hasNext()) {
                currencyId = (String)itCurrency.next();
                for (String accountBankId2 : this.getAccountBankList(context)) {
                    ++i;
                    ps1 = conn.prepareStatement(sql1);
                    ps1.setString(1, companyId);
                    ps1.setString(2, accountBankId2);
                    ps1.setString(3, currencyId);
                    rs1 = ps1.executeQuery();
                    if (rs1.next()) {
                        monthBalance = rs1.getBigDecimal("FMonthBalance");
                    }
                    JZContext.closeResultSet((ResultSet)rs1);
                    JZContext.closeStatment((Statement)ps1);
                    if (monthBalance == null) {
                        monthBalance = new BigDecimal(0);
                    }
                    ps2 = conn.prepareStatement(sql2);
                    ps2.setString(1, companyId);
                    ps2.setString(2, accountBankId2);
                    ps2.setString(3, currencyId);
                    ps2.setDate(4, endDate);
                    rs2 = ps2.executeQuery();
                    if (rs2.next()) {
                        debitAmt = rs2.getBigDecimal("debitAmt");
                        creditAmt = rs2.getBigDecimal("creditAmt");
                    }
                    JZContext.closeResultSet((ResultSet)rs2);
                    JZContext.closeStatment((Statement)ps2);
                    if (debitAmt == null) {
                        debitAmt = new BigDecimal(0);
                    }
                    if (creditAmt == null) {
                        creditAmt = new BigDecimal(0);
                    }
                    if (!(this.isExistBSInitRecord(context, companyId, accountBankId2, currencyId) || debitAmt.compareTo(new BigDecimal(0)) == 0 && creditAmt.compareTo(new BigDecimal(0)) == 0)) {
                        accountViewId = this.getAccountByAccountBank(context, accountBankId2);
                        this.insertBSInitRecord(context, companyId, accountBankId2, accountViewId, currencyId);
                    }
                    finalAmt = monthBalance.add(creditAmt).subtract(debitAmt);
                    resultMap = this.getDebitCreditYearAmount(context, companyId, accountBankId2, currencyId);
                    debitStartAmt = (BigDecimal)resultMap.get("fdebitamount");
                    creditStartAmt = (BigDecimal)resultMap.get("fcreditamount");
                    ps3.setBigDecimal(1, finalAmt);
                    ps3.setBigDecimal(2, finalAmt);
                    ps3.setBigDecimal(3, finalAmt);
                    ps3.setBigDecimal(4, finalAmt);
                    ps3.setBigDecimal(5, debitStartAmt);
                    ps3.setBigDecimal(6, creditStartAmt);
                    ps3.setString(7, periodId);
                    ps3.setString(8, companyId);
                    ps3.setString(9, accountBankId2);
                    ps3.setString(10, currencyId);
                    ps3.addBatch();
                    if (i % context.getBachRowCount(2) != 0) continue;
                    ps3.executeBatch();
                    conn.commit();
                }
                ps3.executeBatch();
            }
            conn.commit();
        }
        catch (SQLException e) {
            throw new JZTaskException(e.getMessage(), 5);
        }
        finally {
            JZContext.closeStatment(ps1);
            JZContext.closeStatment(ps2);
            JZContext.closeStatment((Statement)ps3);
            JZContext.closeResultSet(rs1);
            JZContext.closeResultSet(rs2);
        }
        return true;
    }

    public List getCurrencyList(JZContext context) throws JZTaskException {
        KDConnection conn = context.getDbConn();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<String> currencyList = new ArrayList<String>();
        String fid = "";
        String sql = "SELECT FID FROM T_BD_CURRENCY";
        try {
            ps = conn.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                fid = rs.getString("FID");
                currencyList.add(fid);
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new JZTaskException(e.getMessage(), 5);
            }
            catch (Throwable throwable) {
                JZContext.closeStatment((Statement)ps);
                JZContext.closeResultSet(rs);
                throw throwable;
            }
        }
        JZContext.closeStatment((Statement)ps);
        JZContext.closeResultSet((ResultSet)rs);
        return currencyList;
    }

    public String getAccountByAccountBank(JZContext context, String accountBankId) throws JZTaskException {
        KDConnection conn = context.getDbConn();
        PreparedStatement ps = null;
        ResultSet rs = null;
        String faccountid = "";
        String sql = "select FAccountId from T_BD_ACCOUNTBANKS where fid=?";
        try {
            ps = conn.prepareStatement(sql);
            ps.setString(1, accountBankId);
            rs = ps.executeQuery();
            if (rs.next()) {
                faccountid = rs.getString("FAccountID");
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new JZTaskException(e.getMessage(), 5);
            }
            catch (Throwable throwable) {
                JZContext.closeStatment((Statement)ps);
                JZContext.closeResultSet(rs);
                throw throwable;
            }
        }
        JZContext.closeStatment((Statement)ps);
        JZContext.closeResultSet((ResultSet)rs);
        return faccountid;
    }

    public void insertBSInitRecord(JZContext context, String companyId, String accountBankId, String accountViewId, String currencyId) throws JZTaskException {
        KDConnection conn = context.getDbConn();
        PreparedStatement ps = null;
        String sql = "";
        StringBuffer sb = new StringBuffer();
        String fid = "5E97F3D1";
        sb.append("insert into T_CAS_JOURNALBALANCE (fid, fcompanyid, faccountviewid, \t\t\r\n").append("fcurrencyid, faccountbankid, fperiodid, fisinit, fisbalanced, ftype) \t\r\n").append("values(dbo.newbosid(?), ?, ?, ?, ?, ?, 1, 1, 3)");
        sql = sb.toString();
        try {
            ps = conn.prepareStatement(sql);
            ps.setString(1, fid);
            ps.setString(2, companyId);
            ps.setString(3, accountViewId);
            ps.setString(4, currencyId);
            ps.setString(5, accountBankId);
            ps.setString(6, context.getPeriodFId());
            ps.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new JZTaskException(e.getMessage(), 5);
        }
        finally {
            JZContext.closeStatment((Statement)ps);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isExistBSInitRecord(JZContext context, String companyId, String accountBankId, String currencyId) throws JZTaskException {
        ResultSet rs;
        PreparedStatement ps;
        block6: {
            boolean bl;
            block5: {
                KDConnection conn = context.getDbConn();
                ps = null;
                rs = null;
                int i = 0;
                String sql = "select count(fid) c from T_CAS_JOURNALBALANCE where fcompanyid=? and faccountbankid=? and fcurrencyid=? and ftype=3 and fisinit=1";
                try {
                    ps = conn.prepareStatement(sql);
                    ps.setString(1, companyId);
                    ps.setString(2, accountBankId);
                    ps.setString(3, currencyId);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        i = rs.getInt("c");
                        if (i != 0) continue;
                        bl = false;
                        break block5;
                    }
                    break block6;
                }
                catch (SQLException e) {
                    try {
                        e.printStackTrace();
                        throw new JZTaskException(e.getMessage(), 5);
                    }
                    catch (Throwable throwable) {
                        JZContext.closeStatment((Statement)ps);
                        JZContext.closeResultSet(rs);
                        throw throwable;
                    }
                }
            }
            JZContext.closeStatment((Statement)ps);
            JZContext.closeResultSet((ResultSet)rs);
            return bl;
        }
        JZContext.closeStatment((Statement)ps);
        JZContext.closeResultSet((ResultSet)rs);
        return true;
    }

    public List getAccountBankList(JZContext context) throws JZTaskException {
        KDConnection conn = context.getDbConn();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<String> accountBankList = new ArrayList<String>();
        String fid = "";
        String companyId = context.getOrgFId();
        String sql = "SELECT FID FROM T_BD_ACCOUNTBANKS where FCompanyid=? AND FIsClosed=0";
        try {
            ps = conn.prepareStatement(sql);
            ps.setString(1, companyId);
            rs = ps.executeQuery();
            while (rs.next()) {
                fid = rs.getString("FID");
                accountBankList.add(fid);
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new JZTaskException(e.getMessage(), 5);
            }
            catch (Throwable throwable) {
                JZContext.closeStatment((Statement)ps);
                JZContext.closeResultSet(rs);
                throw throwable;
            }
        }
        JZContext.closeStatment((Statement)ps);
        JZContext.closeResultSet((ResultSet)rs);
        return accountBankList;
    }

    public Map getDebitCreditYearAmount(JZContext context, String companyId, String accountBankId, String currencyId) throws JZTaskException {
        Date endDate = context.getEndDt();
        int year = context.getYear();
        BigDecimal fdebitamount = null;
        BigDecimal fcreditamount = null;
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        KDConnection conn = context.getDbConn();
        PreparedStatement ps = null;
        ResultSet rs = null;
        String sql = "select sum(bs.fdebitamount) debitamount, sum(bs.fcreditamount) creditamount from T_CAS_BANKSTATEMENT bs left join T_BD_PERIOD p on bs.fperiodid=p.fid where bs.fcreatedate < ? and p.fperiodyear = ? and bs.fcompanyid=? and bs.faccountbankid=? and bs.fcurrencyid=?";
        try {
            ps = conn.prepareStatement(sql);
            ps.setDate(1, endDate);
            ps.setInt(2, year);
            ps.setString(3, companyId);
            ps.setString(4, accountBankId);
            ps.setString(5, currencyId);
            rs = ps.executeQuery();
            while (rs.next()) {
                fdebitamount = rs.getBigDecimal("debitamount");
                fcreditamount = rs.getBigDecimal("creditamount");
            }
            if (fdebitamount == null) {
                fdebitamount = new BigDecimal(0);
            }
            if (fcreditamount == null) {
                fcreditamount = new BigDecimal(0);
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new JZTaskException(e.getMessage(), 5);
            }
            catch (Throwable throwable) {
                JZContext.closeStatment((Statement)ps);
                JZContext.closeResultSet(rs);
                throw throwable;
            }
        }
        JZContext.closeStatment((Statement)ps);
        JZContext.closeResultSet((ResultSet)rs);
        resultMap.put("fdebitamount", fdebitamount);
        resultMap.put("fcreditamount", fcreditamount);
        return resultMap;
    }
}

