/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.basedata;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FABgException;
import com.kingdee.eas.ma.budget.BgControlException;
import com.kingdee.eas.ma.nbudget.BgControlCaller;
import com.kingdee.eas.ma.nbudget.face.IBalance;
import com.kingdee.eas.ma.nbudget.face.IBudgetBalance;
import com.kingdee.eas.ma.nbudget.face.IControlResult;
import com.kingdee.eas.ma.nbudget.face.IExtBillCheck;
import com.kingdee.eas.util.ResourceBase;
import java.awt.Component;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class NBgControlCallerUtil {
    private static final String RES = "com.kingdee.eas.cp.bc.WebCommonUtilResource";
    public static final String BUDGET_ITEMNAME = "itemName";
    public static final String BUDGET_ORGNAME = "orgUnitName";
    public static final String BUDGET_ELEMENTNAME = "elementName";
    public static final String BUDGET_PERIODNAME = "periodName";
    public static final String BUDGET_BUDGET = "budget";
    public static final String BUDGET_ACTUAL = "actual";
    public static final String BUDGET_BALANCE = "balance";
    public static final String BUDGET_BALANCESTRING = "balanceString";
    public static final DecimalFormat DEFAULT_AMOUNT_FORMAT = new DecimalFormat("#,##0.00");
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.util.NBgControlCallerUtil");
    private static BgControlCaller caller = new BgControlCaller();

    public static boolean requestBudget(Context ctx, BOSUuid billId) throws EASBizException, BOSException {
        IControlResult callerResult = null;
        boolean result = false;
        callerResult = ctx == null ? caller.requestBudget(billId) : caller.requestBudget(ctx, billId);
        if (callerResult.getResult() != 1) {
            List cause = callerResult.getCause();
            if (cause.size() > 0) {
                logger.error((Object)cause);
                throw new BgControlException(FABgException.APPLYOVERBUDGETCTRL);
            }
        } else {
            result = true;
        }
        return result;
    }

    public static boolean specialBudget(Context ctx, BOSUuid billId) throws EASBizException, BOSException {
        IControlResult callerResult = null;
        boolean result = false;
        callerResult = ctx == null ? caller.specialBudget(billId) : caller.specialBudget(ctx, billId);
        if (callerResult.getResult() != 1) {
            List cause = callerResult.getCause();
            if (cause.size() > 0) {
                logger.error((Object)cause);
                throw new BgControlException(FABgException.APPLYOVERBUDGETCTRL);
            }
        } else {
            result = true;
        }
        return result;
    }

    public static IControlResult returnBudget(Context ctx, BOSUuid billId) throws EASBizException, BOSException {
        IControlResult callerResult = null;
        boolean result = false;
        callerResult = ctx == null ? caller.returnBudget(billId) : caller.returnBudget(ctx, billId);
        if (callerResult.getResult() != 1) {
            List cause = callerResult.getCause();
            if (cause.size() > 0) {
                logger.error((Object)cause);
                throw new BgControlException(FABgException.APPLYOVERBUDGETCTRL);
            }
        } else {
            result = true;
        }
        return callerResult;
    }

    public static IBudgetBalance queryBalance(Context ctx, BOSUuid billId) throws EASBizException, BOSException {
        if (ctx == null) {
            return caller.queryBalance(billId);
        }
        return caller.queryBalance(ctx, billId);
    }

    public static IBudgetBalance queryBalance(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        if (ctx == null) {
            return caller.queryBalance(model);
        }
        return caller.queryBalance(ctx, model);
    }

    public static List getBalance(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        ArrayList resultList = new ArrayList();
        HashMap result = new HashMap();
        IBudgetBalance budgetBalance = NBgControlCallerUtil.queryBalance(ctx, model);
        return NBgControlCallerUtil.getBalanceList(budgetBalance, ctx);
    }

    public static List getBalance(Context ctx, BOSUuid billId) throws EASBizException, BOSException {
        ArrayList resultList = new ArrayList();
        HashMap result = new HashMap();
        IBudgetBalance budgetBalance = NBgControlCallerUtil.queryBalance(ctx, billId);
        return NBgControlCallerUtil.getBalanceList(budgetBalance, ctx);
    }

    private static List getBalanceList(IBudgetBalance budgetBalance, Context ctx) {
        ArrayList<String[]> resultList = new ArrayList<String[]>();
        String[] result = null;
        List balances = budgetBalance.getBalance();
        IBalance balance = null;
        String[] object = null;
        BigDecimal data = new BigDecimal(0);
        HashMap dump = new HashMap();
        String itemNumber = null;
        if (balances != null) {
            for (int i = 0; i < balances.size(); ++i) {
                StringBuffer balanceString = new StringBuffer();
                result = new String[9];
                balance = (IBalance)balances.get(i);
                if (balance.getBudget() == null && balance.getActual() == null) continue;
                object = balance.getReqItem();
                String string = itemNumber = object != null && object.length >= 2 ? object[0] : null;
                if (itemNumber == null) continue;
                result[0] = object != null && object.length >= 2 ? object[1] : null;
                object = balance.getOrgUnit();
                result[1] = object != null && object.length >= 2 ? object[2] : null;
                object = balance.getElement();
                result[2] = object != null && object.length >= 2 ? object[2] : null;
                object = balance.getPeriod();
                result[3] = object != null && object.length >= 2 ? object[2] : null;
                result[7] = object != null && object.length >= 2 ? object[1] : null;
                data = balance.getBudget() != null ? balance.getBudget() : new BigDecimal(0);
                result[4] = DEFAULT_AMOUNT_FORMAT.format(data);
                data = balance.getActual() != null ? balance.getActual() : new BigDecimal(0);
                result[5] = DEFAULT_AMOUNT_FORMAT.format(data);
                BigDecimal bigDecimal = data = balance.getBalance() != null ? balance.getBalance() : new BigDecimal(0);
                if (balance.getExtBalance() != null) {
                    balanceString.append(DEFAULT_AMOUNT_FORMAT.format(balance.getExtBalance()));
                    balanceString.append("(").append(DEFAULT_AMOUNT_FORMAT.format(data)).append(")");
                } else {
                    balanceString.append(DEFAULT_AMOUNT_FORMAT.format(data));
                }
                result[6] = balanceString.toString();
                StringBuffer extName = new StringBuffer();
                result[8] = extName.toString();
                resultList.add(result);
            }
        }
        return resultList;
    }

    private static List getBalanceMap(IBudgetBalance budgetBalance) {
        ArrayList resultList = new ArrayList();
        HashMap<String, CharSequence> result = new HashMap<String, CharSequence>();
        List balances = budgetBalance.getBalance();
        IBalance balance = null;
        String[] object = null;
        BigDecimal data = new BigDecimal(0);
        StringBuffer balanceString = new StringBuffer();
        if (balances != null) {
            for (int i = 0; i < balances.size(); ++i) {
                balance = (IBalance)balances.get(i);
                object = balance.getReqItem();
                result.put(BUDGET_ITEMNAME, object != null && object.length >= 2 ? object[1] : null);
                object = balance.getOrgUnit();
                result.put(BUDGET_ORGNAME, object != null && object.length >= 2 ? object[2] : null);
                object = balance.getPeriod();
                result.put(BUDGET_PERIODNAME, object != null && object.length >= 2 ? object[2] : null);
                data = balance.getBudget() != null ? balance.getBudget() : new BigDecimal(0);
                result.put(BUDGET_BUDGET, DEFAULT_AMOUNT_FORMAT.format(data));
                data = balance.getActual() != null ? balance.getActual() : new BigDecimal(0);
                result.put(BUDGET_ACTUAL, DEFAULT_AMOUNT_FORMAT.format(data));
                data = balance.getBalance() != null ? balance.getBalance() : new BigDecimal(0);
                result.put(BUDGET_BALANCE, DEFAULT_AMOUNT_FORMAT.format(data));
                if (balance.getExtBalance() != null) {
                    balanceString.append(DEFAULT_AMOUNT_FORMAT.format(balance.getExtBalance()));
                    balanceString.append("(").append(DEFAULT_AMOUNT_FORMAT.format(data)).append(")");
                } else {
                    balanceString = null;
                }
                result.put(BUDGET_BALANCESTRING, balanceString);
                resultList.add(result);
            }
        }
        return resultList;
    }

    public static boolean checkBizUnitInfo(Context ctx, BOSUuid billId, IExtBillCheck check) throws EASBizException, BOSException {
        if (ctx == null) {
            return caller.checkBizUnitInfo(billId, check);
        }
        return caller.checkBizUnitInfo(ctx, billId, check);
    }

    public static boolean checkBizUnitInfo(Context ctx, IObjectValue model, IExtBillCheck check) throws EASBizException, BOSException {
        if (ctx == null) {
            return caller.checkBizUnitInfo(model, check);
        }
        return caller.checkBizUnitInfo(ctx, model, check);
    }

    public static void showBudget(Component owner, IObjectValue info) throws EASBizException, BOSException {
        BgControlCaller.showBudget((Component)owner, (IObjectValue)info);
    }

    public static void checkBudget(Context ctx, BOSUuid billId) throws EASBizException, BOSException {
        if (ctx == null) {
            caller.checkBudget(billId);
        } else {
            caller.checkBudget(ctx, billId);
        }
    }

    public static void checkBudget(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        if (ctx == null) {
            caller.checkBudget(model);
        } else {
            caller.checkBudget(ctx, model);
        }
    }

    public static Map checkBudgetResult(Context ctx, IObjectValue model, boolean submitCheckBg, boolean isMustDesWhenOverBg) throws EASBizException, BOSException {
        int i;
        HashMap<String, Comparable<Boolean>> result = new HashMap<String, Comparable<Boolean>>();
        StringBuffer message = new StringBuffer();
        IBudgetBalance budgetBalance = caller.queryBalance(ctx, model);
        if (submitCheckBg) {
            caller.checkBudget(budgetBalance);
        }
        if (isMustDesWhenOverBg && model.get("initdata") != null) {
            List balances = budgetBalance.getBalance();
            IBalance balance = null;
            result.put("isBudgetPass", Boolean.valueOf(true));
            if (balances != null) {
                for (i = 0; i < balances.size(); ++i) {
                    balance = (IBalance)balances.get(i);
                    if (!balance.isControl() || !balance.isOverBudget()) continue;
                    message.append(ResourceBase.getString((String)RES, (String)"ISOVERBUDGET", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{balance.getOrgUnit()[2], balance.getReqItem()[1]})).append(";");
                }
            }
            if (message.length() > 0) {
                result.put("message", message);
            }
        }
        List balancesIsOverBuget = budgetBalance.getBalance();
        IBalance IsOverBuget = null;
        if (balancesIsOverBuget != null) {
            for (i = 0; i < balancesIsOverBuget.size(); ++i) {
                IsOverBuget = (IBalance)balancesIsOverBuget.get(i);
                if (IsOverBuget.isOverBudget()) {
                    result.put("isOverBudget", Boolean.valueOf(true));
                    continue;
                }
                result.put("isOverBudget", Boolean.valueOf(false));
            }
        }
        return result;
    }
}

