/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelFactory;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QueryPanelTypeEnum;
import com.kingdee.eas.base.commonquery.QuerySolutionCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.app.CustomerParams;
import com.kingdee.eas.base.commonquery.app.XMLBeanServer;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AbstractAccountRefContrastProcess;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaContrastCaclFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaDepCalFacadeFactory;
import com.kingdee.eas.fi.fa.manage.FaDepreciationFactory;
import com.kingdee.eas.fi.fa.manage.IFaCurCard;
import com.kingdee.eas.fi.fa.manage.IFaDepCalFacade;
import com.kingdee.eas.fi.fa.manage.IFaDepreciation;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class FaAccountRefContrastProcess
extends AbstractAccountRefContrastProcess {
    private Logger logger = Logger.getLogger(FaAccountRefContrastProcess.class);

    public boolean enable(Context ctx, String companyID, String acrefID) throws BOSException, EASBizException {
        int systemEnum = 14;
        String curPeriodId = super.getCurrentPeriod(ctx, systemEnum, companyID);
        if (curPeriodId == null) {
            return false;
        }
        PeriodInfo perInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)curPeriodId)));
        if (!this.isStartSystem(ctx, systemEnum, companyID)) {
            return false;
        }
        if (!perInfo.isIsAdjustPeriod()) {
            throw this.util.getEASBizException(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.BASEDATAAutoGenerateResource", (String)"7_FaAccountRefContrastProcess", (Locale)ctx.getOriginLocale()), null);
        }
        if (this.isBiz(ctx, companyID, acrefID)) {
            throw this.util.getEASBizException(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.BASEDATAAutoGenerateResource", (String)"8_FaAccountRefContrastProcess", (Locale)ctx.getOriginLocale()), null);
        }
        this.FaAlterModeSwap(ctx, companyID, acrefID);
        this.FaEvalSchemeSwap(ctx, companyID, acrefID);
        this.FaCurCardSwap(ctx, companyID, acrefID);
        this.FaMonCardSwap(ctx, companyID, acrefID);
        this.FaEvaSum(ctx, companyID, acrefID);
        this.FaMaintainExpenseSwap(ctx, companyID, acrefID);
        return false;
    }

    public boolean disEnable(Context ctx, String companyID, String acrefID) throws BOSException, EASBizException {
        String templeTable = super.createTempleTable(ctx, acrefID);
        this.unFaAlterModeSwap(ctx, companyID, acrefID, templeTable);
        this.unFaEvalSchemeSwap(ctx, companyID, acrefID, templeTable);
        this.unFaCurCardSwap(ctx, companyID, acrefID, templeTable);
        this.unFaMonCardSwap(ctx, companyID, acrefID, templeTable);
        this.unFaEvaSum(ctx, companyID, acrefID, templeTable);
        this.unFaMaintainExpenseSwap(ctx, companyID, acrefID, templeTable);
        return false;
    }

    private boolean bizChecker(Context ctx, String companyID, String acrefID) throws BOSException, EASBizException {
        String[] bizTables = new String[]{"T_FA_FaCurCard", "T_FA_FaChangeBill", "T_FA_ClearBill", "T_FA_FaCombinBill", "T_FA_FaDecValue", "T_FA_FaDispatchBill", "T_FA_FaEvaluateBill", "T_FA_FaSplitBill", "T_FA_StocktakingTaskBill", "T_FA_FaDepreciation", "T_FA_FaLeaseBill", "T_FA_FaLeaseInBill"};
        String[] unAuditResources = new String[]{"unAuditNewCard", "unAuditChange", "unAuditClean", "unAuditCombin", "unAuditDecValue", "unAuditDispatch", "unAuditEvalute", "unAuditSplit", "unAuditStockTask", "unAuditDepr", "unAudtiLeaseOut", "unAuditLeaseIn"};
        String[] notVouchedResources = new String[]{"notVouchedNewCard", "notVouchedChange", "notVouchedClean", "notVouchedCombin", "notVouchedDecValue", "notVouchedDispatch", "notVouchedEvalute", "notVouchedSplit", "notVouchedStock", "notVouchedDepr", "notVouchedLeaseOut", "notVouchedLeaseIn"};
        HashMap hmPara = this.gethmParam(ctx, companyID);
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyID));
        int systemEnum = 14;
        String curPeriodId = super.getCurrentPeriod(ctx, systemEnum, companyID);
        PeriodInfo perInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)curPeriodId)));
        if (!this.isStartSystem(ctx, systemEnum, companyID)) {
            return false;
        }
        if (!perInfo.isIsAdjustPeriod()) {
            throw this.util.getEASBizException(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.BASEDATAAutoGenerateResource", (String)"7_FaAccountRefContrastProcess", (Locale)ctx.getOriginLocale()), null);
        }
        StringBuffer sql = new StringBuffer();
        String oldAcctTableID = super.getOldAcctTableID(ctx, acrefID);
        sql.append("select 1 where exists(select distinct * from t_fa_facurcard card ").append("inner join t_bd_period per on card.fperiodid=per.fid ").append("inner join t_bd_accountview acct on acct.fid=card.FAccountAssetID ").append("or acct.fid=card.FAccountAccuDeprID or acct.fid=card.FAccountDecValueID").append(" where card.fcompanyid='" + companyID + "' and acct.FAccountTableID='" + oldAcctTableID).append("' and per.fperiodyear*100+per.fperiodNumber>" + perInfo.getNumber() + ") ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                throw this.util.getEASBizException(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.BASEDATAAutoGenerateResource", (String)"9_FaAccountRefContrastProcess", (Locale)ctx.getOriginLocale()), null);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sql.delete(0, sql.length());
        String newAcctTableID = super.getNewAcctTableID(ctx, acrefID);
        sql.append("select 1 where exists(select distinct * from t_fa_facurcard card ").append("inner join t_bd_period per on card.fperiodid=per.fid ").append("inner join t_bd_accountview acct on acct.fid=card.FAccountAssetID ").append("or acct.fid=card.FAccountAccuDeprID or acct.fid=card.FAccountDecValueID ").append("where card.fcompanyid='" + companyID + "' and acct.FAccountTableID='" + newAcctTableID + "'").append(" and per.fperiodyear*100+per.fperiodnumber<=" + perInfo.getNumber() + ") ");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                throw this.util.getEASBizException(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.BASEDATAAutoGenerateResource", (String)"10_FaAccountRefContrastProcess", (Locale)ctx.getOriginLocale()), null);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        String checkGL = (String)hmPara.get("FA_004");
        StringBuffer checkerStr = new StringBuffer();
        boolean isCheckGL = false;
        if (checkGL != null && checkGL.trim().length() > 0) {
            isCheckGL = Boolean.valueOf(checkGL.trim());
        }
        if (isCheckGL) {
            for (int j = 0; j < bizTables.length; ++j) {
                if (!this.existNotVouchered(ctx, companyID, bizTables[j])) continue;
                checkerStr.append(this.getResource(ctx, "com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource", notVouchedResources[j]));
                throw new EASBizException(new NumericExceptionSubItem("1", checkerStr.toString()));
            }
            String checkDep = (String)hmPara.get("FA_005");
            if (checkDep != null && checkDep.trim().length() > 0) {
                boolean isCheckDep = Boolean.valueOf(checkDep.trim());
                if (isCheckDep && this.isExitNoCal(ctx, company, perInfo)) {
                    checkerStr.append(this.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaPeriodClose", "forward_NoDep"));
                    throw new EASBizException(new NumericExceptionSubItem("1", checkerStr.toString()));
                }
                if (this.isNeedRedoDep(ctx, companyID)) {
                    checkerStr.append(this.getResource(ctx, "com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource", "needRedoDep"));
                    throw new EASBizException(new NumericExceptionSubItem("1", checkerStr.toString()));
                }
            }
        }
        if (isCheckGL) {
            boolean isRelAccount = SystemStatusCtrolUtils.isRelAccount((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)company);
            boolean checkResult = FaContrastCaclFactory.getLocalInstance((Context)ctx).isAcctEquals(companyID, null);
            if (!checkResult && isRelAccount) {
                checkerStr.append(this.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaPeriodClose", "forward_CheckGL"));
                throw new EASBizException(new NumericExceptionSubItem("1", checkerStr.toString()));
            }
        }
        return true;
    }

    private boolean existNotVouchered(Context ctx, String companyId, String tableName) throws BOSException, EASBizException {
        if ("T_FA_FaCombinBill".equalsIgnoreCase(tableName) || "T_FA_FaSplitBill".equalsIgnoreCase(tableName) || "T_FA_FaDispatchBill".equalsIgnoreCase(tableName) || "T_FA_StocktakingBill".equalsIgnoreCase(tableName) || "T_FA_StocktakingTaskBill".equalsIgnoreCase(tableName)) {
            return false;
        }
        CompanyOrgUnitInfo currCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT bill.fid as fid");
        sql.append(" FROM ").append(tableName).append(" as bill");
        if ("T_FA_FaChangeBill".equals(tableName)) {
            sql.append(" INNER JOIN t_fa_fachangebillentry entry ON bill.fid = entry.fchangebillid and bill.FBillType is null ");
        } else if ("T_FA_ClearBill".equals(tableName)) {
            sql.append(" INNER JOIN t_fa_clearbillentry entry ON bill.fid = entry.fentryid");
            sql.append(" INNER JOIN t_fa_facurcard card ON card.fid = entry.fcurcardid");
        }
        if ("T_FA_FaDepreciation".equals(tableName)) {
            sql.append(" INNER JOIN T_BD_SystemStatusCtrol ssc on ssc.fcompanyid = bill.fcompanyid and ssc.FCurrentPeriodID = bill.FPeriod ");
        } else {
            sql.append(" INNER JOIN T_BD_SystemStatusCtrol ssc on ssc.fcompanyid = bill.fcompanyid and ssc.FCurrentPeriodID = bill.FPeriodID ");
        }
        sql.append(" INNER JOIN T_BD_SystemStatus ss ON ss.FID = ssc.FSystemStatusID");
        sql.append(" WHERE bill.ffivouchered = 0 and ssc.fisrelaccount = 1");
        if ("T_FA_FaCurCard".equalsIgnoreCase(tableName)) {
            sql.append(" and bill.fassetValue != 0");
            sql.append(" and bill.foriginFlag != 0");
            sql.append(" and bill.foriginFlag != 6");
        } else if ("T_FA_ClearBill".equalsIgnoreCase(tableName)) {
            sql.append(" and card.fassetValue != 0");
        } else if ("T_FA_FaChangeBill".equals(tableName)) {
            sql.append(" and (entry.toriginChg != 0 or entry.taccuDeprChg != 0 or entry.tdecValueChg != 0)");
        }
        sql.append(" and ss.FName = ").append(14);
        sql.append(" and bill.fcompanyid = '").append(currCompany.getId().toString()).append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowSet.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    private boolean isExitNoCal(Context ctx, CompanyOrgUnitInfo company, PeriodInfo period) throws BOSException, EASBizException {
        IFaDepCalFacade depCal;
        FaCurCardCollection card;
        boolean hasDep = this.ifAlreadyCal(ctx, company, period);
        return !hasDep && (card = (depCal = FaDepCalFacadeFactory.getLocalInstance((Context)ctx)).getDepCardCollection(company)).size() > 0;
    }

    private boolean ifAlreadyCal(Context ctx, CompanyOrgUnitInfo company, PeriodInfo period) throws BOSException, EASBizException {
        if (period == null) {
            throw new BOSException("period is null");
        }
        IFaDepreciation iDep = FaDepreciationFactory.getLocalInstance((Context)ctx);
        String companyId = company.getId().toString();
        String periodId = period.getId().toString();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("period", (Object)periodId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("company", (Object)companyId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("depType", (Object)new Integer(0), CompareType.EQUALS));
        return iDep.exists(filterInfo);
    }

    private boolean isNeedRedoDep(Context ctx, String companyId) throws BOSException, EASBizException {
        IFaCurCard icard = FaCurCardFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("isNeedReDepr", (Object)"1", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("deprMethod.number", (Object)"006", CompareType.NOTEQUALS));
        return icard.exists(filter);
    }

    private void FaAlterModeSwap(Context ctx, String companyid, String acrefID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_fa_altermode set faccountid = (select max(e.FNewAcctid)");
        sql.append(" from t_bd_acctrefcontrast a inner join t_bd_acctrefcontrastentry e on a.fid = e.facctrefcontrastid");
        sql.append(" where a.fid = ? and e.FOldAcctid = t_fa_altermode.faccountid)");
        sql.append(" where fcompanyid = ? and faccountid in (");
        sql.append(" select foldacctid from t_bd_acctrefcontrastentry where facctrefcontrastid = ?)");
        Object[] params = new Object[]{acrefID, companyid, acrefID};
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
    }

    private void unFaAlterModeSwap(Context ctx, String companyid, String acrefID, String templeTable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_fa_altermode set (faccountid) = (select tem.FoldAcctid");
        sql.append(" from ").append(templeTable).append(" tem where faccountid=tem.fnewAcctID) ");
        sql.append(" where fcompanyid=? ");
        sql.append(" and faccountid in (select fnewAcctID from ").append(templeTable).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyid});
    }

    private void FaEvalSchemeSwap(Context ctx, String companyID, String acrefID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_fa_faevascheme set fincrementAccountid = (select max(e.FNewAcctID)");
        sql.append(" from t_bd_acctrefcontrast a inner join t_bd_acctrefcontrastentry e on a.fid = e.facctrefcontrastid");
        sql.append(" where a.fid = ? and e.FOldAcctID = t_fa_faevascheme.fincrementAccountid)");
        sql.append(" where fcompanyid = ? and fincrementAccountid in (");
        sql.append(" select foldacctid from t_bd_acctrefcontrastentry where facctrefcontrastid = ?)");
        Object[] params = new Object[]{acrefID, companyID, acrefID};
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
        sql = new StringBuffer();
        sql.append("update t_fa_faevascheme set flossAccountid = (select max(e.FNewAcctID)");
        sql.append(" from t_bd_acctrefcontrast a inner join t_bd_acctrefcontrastentry e on a.fid = e.facctrefcontrastid");
        sql.append(" where a.fid = ? and e.FOldAcctID = t_fa_faevascheme.flossAccountid)");
        sql.append(" where fcompanyid = ? and flossAccountid in (");
        sql.append(" select foldacctid from t_bd_acctrefcontrastentry where facctrefcontrastid = ?)");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
        sql = new StringBuffer();
        sql.append("update t_fa_faevascheme set fcommuteLossAccountid = (select max(e.FNewAcctID)");
        sql.append(" from t_bd_acctrefcontrast a inner join t_bd_acctrefcontrastentry e on a.fid = e.facctrefcontrastid");
        sql.append(" where a.fid = ? and e.FOldAcctID = t_fa_faevascheme.fcommuteLossAccountid)");
        sql.append(" where fcompanyid = ? and fcommuteLossAccountid in (");
        sql.append(" select foldacctid from t_bd_acctrefcontrastentry where facctrefcontrastid = ?)");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
    }

    private void unFaEvalSchemeSwap(Context ctx, String companyID, String acrefID, String templeTable) throws BOSException {
        this.unFaEvalSchemeSwapItem(ctx, companyID, acrefID, templeTable, "fincrementAccountid");
        this.unFaEvalSchemeSwapItem(ctx, companyID, acrefID, templeTable, "flossAccountid");
        this.unFaEvalSchemeSwapItem(ctx, companyID, acrefID, templeTable, "fcommuteLossAccountid");
    }

    private void unFaEvalSchemeSwapItem(Context ctx, String companyID, String acrefID, String templeTable, String fieldname) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_fa_faevascheme set (" + fieldname + ") = (select tem.FoldAcctID");
        sql.append(" from " + templeTable + " tem where " + fieldname + "=tem.fnewAcctID) ");
        sql.append(" where fcompanyid=? ");
        sql.append(" and " + fieldname + " in (select fnewAcctID from ").append(templeTable).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyID});
    }

    private void FaCurCardSwap(Context ctx, String companyID, String acrefID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_fa_facurcard set faccountAssetid = (select max(e.FNewAcctID)");
        sql.append(" from t_bd_acctrefcontrast a inner join t_bd_acctrefcontrastentry e on a.fid = e.facctrefcontrastid");
        sql.append(" where a.fid = ? and e.FOldAcctID = t_fa_facurcard.faccountAssetid)");
        sql.append(" where fcompanyid = ? and faccountAssetid in (");
        sql.append(" select foldacctid from t_bd_acctrefcontrastentry where facctrefcontrastid = ?)");
        Object[] params = new Object[]{acrefID, companyID, acrefID};
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
        sql = new StringBuffer();
        sql.append("update t_fa_facurcard set faccountAccuDeprid = (select max(e.FNewAcctID)");
        sql.append(" from t_bd_acctrefcontrast a inner join t_bd_acctrefcontrastentry e on a.fid = e.facctrefcontrastid");
        sql.append(" where a.fid = ? and e.FOldAcctID = t_fa_facurcard.faccountAccuDeprid)");
        sql.append(" where fcompanyid = ? and faccountAccuDeprid in (");
        sql.append(" select foldacctid from t_bd_acctrefcontrastentry where facctrefcontrastid = ?)");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
        sql = new StringBuffer();
        sql.append("update t_fa_facurcard set faccountDecValueid = (select max(e.FNewAcctID)");
        sql.append(" from t_bd_acctrefcontrast a inner join t_bd_acctrefcontrastentry e on a.fid = e.facctrefcontrastid");
        sql.append(" where a.fid = ? and e.FOldAcctID = t_fa_facurcard.faccountDecValueid)");
        sql.append(" where fcompanyid = ? and faccountDecValueid in (");
        sql.append(" select foldacctid from t_bd_acctrefcontrastentry where facctrefcontrastid = ?)");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
        sql = new StringBuffer();
        sql.append("update t_fa_facurcostcenter set faccountviewid = (select max(e.FNewAcctID)");
        sql.append(" from t_bd_acctrefcontrast a inner join t_bd_acctrefcontrastentry e on a.fid = e.facctrefcontrastid");
        sql.append(" where a.fid = ? and e.FOldAcctID = t_fa_facurcostcenter.faccountviewid)");
        sql.append(" where ffacurcardid in (select fid from t_fa_facurcard where fcompanyid = ?) and faccountviewid in (");
        sql.append(" select foldacctid from t_bd_acctrefcontrastentry where facctrefcontrastid = ?)");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
    }

    private void FaMonCardSwap(Context ctx, String companyID, String acrefID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_fa_faMoncard set faccountAssetid = (select max(e.FNewAcctID)");
        sql.append(" from t_bd_acctrefcontrast a inner join t_bd_acctrefcontrastentry e on a.fid = e.facctrefcontrastid");
        sql.append(" where a.fid = ? and e.FOldAcctID = t_fa_famoncard.faccountAssetid)");
        sql.append(" where fcompanyid = ? and faccountAssetid in (");
        sql.append(" select foldacctid from t_bd_acctrefcontrastentry where facctrefcontrastid = ?)");
        Object[] params = new Object[]{acrefID, companyID, acrefID};
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
        sql = new StringBuffer();
        sql.append("update t_fa_faMoncard set faccountAccuDeprid = (select max(e.FNewAcctID)");
        sql.append(" from t_bd_acctrefcontrast a inner join t_bd_acctrefcontrastentry e on a.fid = e.facctrefcontrastid");
        sql.append(" where a.fid = ? and e.FOldAcctID = t_fa_famoncard.faccountAccuDeprid)");
        sql.append(" where fcompanyid = ? and faccountAccuDeprid in (");
        sql.append(" select foldacctid from t_bd_acctrefcontrastentry where facctrefcontrastid = ?)");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
        sql = new StringBuffer();
        sql.append("update t_fa_faMoncard set faccountDecValueid = (select max(e.FNewAcctID)");
        sql.append(" from t_bd_acctrefcontrast a inner join t_bd_acctrefcontrastentry e on a.fid = e.facctrefcontrastid");
        sql.append(" where a.fid = ? and e.FOldAcctID = t_fa_famoncard.faccountDecValueid)");
        sql.append(" where fcompanyid = ? and faccountDecValueid in (");
        sql.append(" select foldacctid from t_bd_acctrefcontrastentry where facctrefcontrastid = ?)");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
        sql = new StringBuffer();
        sql.append("update t_fa_famoncostcenter set faccountviewid = (select max(e.FNewAcctID)");
        sql.append(" from t_bd_acctrefcontrast a inner join t_bd_acctrefcontrastentry e on a.fid = e.facctrefcontrastid");
        sql.append(" where a.fid = ? and e.FOldAcctID = t_fa_famoncostcenter.faccountviewid)");
        sql.append(" where ffamoncardid in (select fid from t_fa_famoncard where fcompanyid = ?) and faccountviewid in (");
        sql.append(" select foldacctid from t_bd_acctrefcontrastentry where facctrefcontrastid = ?)");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
    }

    private void unFaCurCardSwap(Context ctx, String companyID, String acrefID, String templeTable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql = new StringBuffer();
        sql.append("update t_fa_facurcostcenter set (faccountviewid) = (select tem.FoldAcctID ");
        sql.append(" from " + templeTable + " tem where faccountviewid=tem.fnewAcctID) ");
        sql.append(" where ffacurcardid in (select fid from t_fa_facurcard where fcompanyid = ?)");
        sql.append(" and faccountviewid in (select fnewAcctID from ").append(templeTable).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyID});
        this.unFaCurCardSwapItem(ctx, companyID, acrefID, templeTable, "faccountAssetid");
        this.unFaCurCardSwapItem(ctx, companyID, acrefID, templeTable, "faccountAccuDeprid");
        this.unFaCurCardSwapItem(ctx, companyID, acrefID, templeTable, "faccountDecValueid");
    }

    private void unFaMonCardSwap(Context ctx, String companyID, String acrefID, String templeTable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql = new StringBuffer();
        sql.append("update t_fa_famoncostcenter set (faccountviewid) = (select tem.FoldAcctID ");
        sql.append(" from " + templeTable + " tem where faccountviewid=tem.fnewAcctID) ");
        sql.append(" where ffamoncardid in (select fid from t_fa_famoncard where fcompanyid = ?)");
        sql.append(" and faccountviewid in (select fnewAcctID from ").append(templeTable).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyID});
        this.unFaMonCardSwapItem(ctx, companyID, acrefID, templeTable, "faccountAssetid");
        this.unFaMonCardSwapItem(ctx, companyID, acrefID, templeTable, "faccountAccuDeprid");
        this.unFaMonCardSwapItem(ctx, companyID, acrefID, templeTable, "faccountDecValueid");
    }

    private void unFaCurCardSwapItem(Context ctx, String companyID, String acrefID, String templeTable, String fieldname) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_fa_facurcard set (" + fieldname + ") = (select tem.FoldAcctID ");
        sql.append(" from " + templeTable + " tem where " + fieldname + "=tem.fnewAcctID) ");
        sql.append(" where fcompanyid = ? and " + fieldname + " in (select fnewAcctID from ").append(templeTable).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyID});
    }

    private void unFaMonCardSwapItem(Context ctx, String companyID, String acrefID, String templeTable, String fieldname) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_fa_famoncard set (" + fieldname + ") = (select tem.FoldAcctID ");
        sql.append(" from " + templeTable + " tem where " + fieldname + "=tem.fnewAcctID) ");
        sql.append(" where fcompanyid = ? and " + fieldname + " in (select fnewAcctID from ").append(templeTable).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyID});
    }

    private void FaEvaSum(Context ctx, String companyID, String acrefID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_FA_FaEvaSum set faccountviewid = (select max(e.FNewAcctID)");
        sql.append(" from t_bd_acctrefcontrast a inner join t_bd_acctrefcontrastentry e on a.fid = e.facctrefcontrastid");
        sql.append(" where a.fid = ? and e.FOldAcctID = T_FA_FaEvaSum.faccountviewid)");
        sql.append(" where FEvaBillID in (select distinct esum.fid from T_FA_FaEvaSum esum ");
        sql.append(" inner join T_FA_FaEvaluateBill bill on esum.fevabillid=bill.fid ");
        sql.append(" where bill.fcompanyid = ?) and faccountviewid in (");
        sql.append(" select foldacctid from t_bd_acctrefcontrastentry where facctrefcontrastid = ?)");
        Object[] params = new Object[]{acrefID, companyID, acrefID};
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
    }

    private void unFaEvaSum(Context ctx, String companyID, String acrefID, String templeTable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_FA_FaEvaSum set (faccountviewid) = (select tem.FoldAcctID");
        sql.append(" from " + templeTable + " tem where faccountviewid=tem.fnewAcctID) ");
        sql.append(" where FEvaBillID in (select distinct esum.fid from T_FA_FaEvaSum esum ");
        sql.append(" inner join T_FA_FaEvaluateBill bill on esum.fevabillid=bill.fid where bill.fcompanyid = ?)");
        sql.append(" and faccountviewid in (select fnewAcctID from ").append(templeTable).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyID});
    }

    private void FaMaintainExpenseSwap(Context ctx, String companyID, String acrefID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_FA_FaMaintainExpense set FCostRateAccountID = (select max(e.FNewAcctID)");
        sql.append(" from t_bd_acctrefcontrast a inner join t_bd_acctrefcontrastentry e on a.fid = e.facctrefcontrastid");
        sql.append(" where a.fid = ? and e.FOldAcctID = T_FA_FaMaintainExpense.FCostRateAccountID)");
        sql.append(" where fcompanyid = ? and FCostRateAccountID in (");
        sql.append(" select foldacctid from t_bd_acctrefcontrastentry where facctrefcontrastid = ?)");
        Object[] params = new Object[]{acrefID, companyID, acrefID};
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
        sql = new StringBuffer();
        sql.append("update T_FA_FaMaintainExpense set FPaymentAccountID = (select max(e.FNewAcctID)");
        sql.append(" from t_bd_acctrefcontrast a inner join t_bd_acctrefcontrastentry e on a.fid = e.facctrefcontrastid");
        sql.append(" where a.fid = ? and e.FOldAcctID = T_FA_FaMaintainExpense.FPaymentAccountID)");
        sql.append(" where fcompanyid = ? and FPaymentAccountID in (");
        sql.append(" select foldacctid from t_bd_acctrefcontrastentry where facctrefcontrastid = ?)");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
    }

    private void unFaMaintainExpenseSwap(Context ctx, String companyID, String acrefID, String templeTable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_FA_FaMaintainExpense set (FCostRateAccountID) = (select tem.FoldAcctID");
        sql.append(" from " + templeTable + " tem where FCostRateAccountID=tem.fnewAcctID)");
        sql.append(" where fcompanyid = ? ");
        sql.append(" and FCostRateAccountID in (select fnewAcctID from ").append(templeTable).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyID});
        sql = new StringBuffer();
        sql.append("update T_FA_FaMaintainExpense set (FPaymentAccountID)  = (select tem.FoldAcctID");
        sql.append(" from " + templeTable + " tem where FPaymentAccountID=tem.fnewAcctID)");
        sql.append(" where fcompanyid = ? ");
        sql.append(" and FPaymentAccountID in (select fnewAcctID from ").append(templeTable).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyID});
    }

    private HashMap gethmParam(Context ctx, String companyIds) throws BOSException, EASBizException {
        HashMap hmParam = null;
        ObjectUuidPK pk = new ObjectUuidPK(companyIds);
        HashMap<String, ObjectUuidPK> paramKeyMap = new HashMap<String, ObjectUuidPK>();
        paramKeyMap.put("FA_004", pk);
        paramKeyMap.put("FA_005", pk);
        paramKeyMap.put("FA_006", pk);
        IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
        hmParam = iParamControl.getParamHashMap(paramKeyMap);
        return hmParam;
    }

    private String getResource(Context ctx, String s1, String s2) {
        Locale l = ctx.getOriginLocale();
        return ResourceBase.getString((String)s1, (String)s2, (Locale)l);
    }

    private void FaFaContrastSwap(Context ctx, String companyId, String acrefID, boolean isEnable) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo orgItemInfo = new FilterItemInfo("orgID", (Object)companyId);
        filterInfo.getFilterItems().add(orgItemInfo);
        FilterItemInfo queryItemFilter = new FilterItemInfo("queryObjectName", (Object)"com.kingdee.eas.fi.fa.manage.FaChangeBillQuery");
        filterInfo.getFilterItems().add(queryItemFilter);
        FilterItemInfo uiItemInfo = new FilterItemInfo("parentUIName", (Object)"com.kingdee.eas.fi.fa.manage.client.FaContrastUI");
        filterInfo.getFilterItems().add(uiItemInfo);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filterInfo);
        QuerySolutionCollection solutionColl = QuerySolutionFactory.getLocalInstance((Context)ctx).getQuerySolutionCollection(view);
        CoreBaseCollection updatePanelColl = new CoreBaseCollection();
        for (int i = 0; i < solutionColl.size(); ++i) {
            QuerySolutionInfo solutionInfo = solutionColl.get(i);
            QueryPanelCollection queryPanels = solutionInfo.getQueryPanelInfo();
            QueryPanelInfo queryPanel = null;
            int size = queryPanels.size();
            for (int j = 0; j < size; ++j) {
                if (queryPanels.get(j).getQueryPanelType() != QueryPanelTypeEnum.CUSTOMER_PANEL) continue;
                queryPanel = queryPanels.get(j);
                break;
            }
            if (queryPanel == null || queryPanel.getCustomerParams() == null) continue;
            try {
                if (queryPanel.getCustomerParams() == null) continue;
                String params = this.changeAccount(ctx, companyId, queryPanel.getCustomerParams(), acrefID, isEnable);
                queryPanel.setCustomerParams(params);
                updatePanelColl.add((CoreBaseInfo)queryPanel);
                continue;
            }
            catch (BOSException ex) {
                throw ex;
            }
            catch (Exception e) {
                this.logger.error((Object)"FaAccountRefContrastProcess:", (Throwable)e);
            }
        }
        if (updatePanelColl.size() > 0) {
            QueryPanelFactory.getLocalInstance((Context)ctx).update(updatePanelColl);
        }
    }

    private String changeAccount(Context ctx, String companyId, String strParams, String acrefID, boolean isEnable) throws Exception {
        String oldAccount;
        int i;
        CustomerParams params = XMLBeanServer.TransStrToCustParams((String)strParams);
        if (params == null) {
            return strParams;
        }
        CustomerParams accountMap = params.getMe("AccountMap");
        TreeSet assetKeySet = new TreeSet(accountMap.getMe("ASSET").getCustomerParamsHashMap().keySet());
        TreeSet decvalueKeySet = new TreeSet(accountMap.getMe("DECVALUE").getCustomerParamsHashMap().keySet());
        TreeSet depreKeySet = new TreeSet(accountMap.getMe("DEPRE").getCustomerParamsHashMap().keySet());
        ArrayList<String> idList = new ArrayList<String>();
        for (i = 0; i < assetKeySet.size(); ++i) {
            oldAccount = (String)accountMap.getMe("ASSET").getCustomerParamsHashMap().get(assetKeySet.toArray()[i]);
            if (oldAccount == null || oldAccount.trim().length() <= 0) continue;
            idList.add(oldAccount);
        }
        for (i = 0; i < decvalueKeySet.size(); ++i) {
            oldAccount = (String)accountMap.getMe("DECVALUE").getCustomerParamsHashMap().get(decvalueKeySet.toArray()[i]);
            if (oldAccount == null || oldAccount.trim().length() <= 0) continue;
            idList.add(oldAccount);
        }
        for (i = 0; i < depreKeySet.size(); ++i) {
            oldAccount = (String)accountMap.getMe("DEPRE").getCustomerParamsHashMap().get(depreKeySet.toArray()[i]);
            if (oldAccount == null || oldAccount.trim().length() <= 0) continue;
            idList.add(oldAccount);
        }
        if (idList.size() == 0) {
            return strParams;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select e.foldacctid,e.fnewacctid ");
        sql.append(" from t_bd_acctrefcontrast a inner join t_bd_acctrefcontrastentry e on a.fid = e.facctrefcontrastid");
        sql.append(" where a.fid = '" + acrefID + "' and a.fcompanyid = '" + companyId + "'");
        if (isEnable) {
            sql.append(" and e.foldacctid in (");
        } else {
            sql.append(" and e.fnewacctid in (");
        }
        for (int i2 = 0; i2 < idList.size(); ++i2) {
            if (i2 > 0) {
                sql.append(",");
            }
            sql.append("'").append(idList.get(i2).toString()).append("'");
        }
        sql.append(")");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rowSet.next()) {
            String oldAcctId = rowSet.getString("foldacctid");
            String newAcctId = rowSet.getString("fnewacctid");
            if (oldAcctId == null || newAcctId == null) continue;
            if (isEnable) {
                strParams = StringUtils.replace((String)strParams, (String)oldAcctId, (String)newAcctId);
                continue;
            }
            strParams = StringUtils.replace((String)strParams, (String)newAcctId, (String)oldAcctId);
        }
        return strParams;
    }

    private boolean isBiz(Context ctx, String companyID, String acrefID) throws EASBizException, BOSException {
        int systemEnum = 14;
        String curPeriodId = super.getCurrentPeriod(ctx, systemEnum, companyID);
        PeriodInfo perInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)curPeriodId)));
        StringBuffer sql = new StringBuffer();
        String oldAcctTableID = super.getOldAcctTableID(ctx, acrefID);
        sql.append("select 1 where exists(select distinct * from t_fa_famoncard card ").append("inner join t_bd_period per on card.ffaperiodid=per.fid ").append("inner join t_bd_accountview acct on acct.fid=card.FAccountAssetID ").append("inner join t_bd_accountview acct1 on acct1.fid=card.FAccountAccuDeprID  ").append("inner join t_bd_accountview acct2 on acct2.fid=card.FAccountDecValueID ").append("where card.fcompanyid='" + companyID + "' and acct.FAccountTableID='" + oldAcctTableID).append("' and per.fnumber>" + perInfo.getNumber() + ") ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }
}

