/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.BizReferenceException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaBasicException;
import com.kingdee.eas.fi.fa.basedata.FaCatCollection;
import com.kingdee.eas.fi.fa.basedata.FaCatFactory;
import com.kingdee.eas.fi.fa.basedata.FaCatInfo;
import com.kingdee.eas.fi.fa.basedata.app.AbstractFaCatControllerBean;
import com.kingdee.eas.fi.fa.manage.FaBakCardFactory;
import com.kingdee.eas.fi.fa.manage.FaBizCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaMonCardFactory;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.framework.TreeBaseException;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class FaCatControllerBean
extends AbstractFaCatControllerBean {
    private static final long serialVersionUID = -1426006297578207366L;
    private static final Logger logger = Logger.getLogger(FaCatControllerBean.class);

    protected void checkLNForTree(Context ctx, TreeBaseInfo treeBaseInfo) throws BOSException, EASBizException, TreeBaseException {
        FilterInfo lNfilter = new FilterInfo();
        lNfilter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)treeBaseInfo.getLongNumber()));
        lNfilter.getFilterItems().add(new FilterItemInfo("id", (Object)treeBaseInfo.getId().toString(), CompareType.NOTEQUALS));
        FaCatInfo faCatInfo = (FaCatInfo)treeBaseInfo;
        if (faCatInfo.getCompany() != null) {
            lNfilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)faCatInfo.getCompany().getId().toString(), CompareType.EQUALS));
        }
        if (this.exists(ctx, lNfilter)) {
            throw new TreeBaseException(TreeBaseException.CHECKNUMBERDUPLICATED, new Object[]{treeBaseInfo.getNumber()});
        }
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaCatInfo faCatInfo = (FaCatInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)faCatInfo.getName(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (faCatInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)faCatInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (faCatInfo.getCompany() != null) {
            filterItem = new FilterItemInfo("company.id", (Object)faCatInfo.getCompany().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("company.id", null, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            if (i != 0) {
                sb.append(" and #" + i);
                continue;
            }
            sb.append("#" + i);
        }
        filter.setMaskString(sb.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String name = this._getPropertyAlias(ctx, (DataBaseInfo)faCatInfo, "name") + faCatInfo.getName();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{name});
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkHasBeanImported(ctx, pk);
        super._delete(ctx, pk);
    }

    protected void checkHasBeanImported(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.longNumber"));
        FaCatInfo info = FaCatFactory.getLocalInstance(ctx).getFaCatInfo(pk, sic);
        String catNumber = info.getNumber();
        String companyLongNumber = info.getCompany().getLongNumber();
        FaCatCollection importedCats = FaCatFactory.getLocalInstance(ctx).getFaCatCollection("select id where number = '" + catNumber + "' and sourceMode = 2 and company.longNumber like '" + companyLongNumber + "!%' ");
        if (importedCats.size() > 0) {
            throw new FaBasicException(FaBasicException.HAVE_IMPORTED);
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaCatInfo faCatInfo = (FaCatInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)faCatInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (faCatInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)faCatInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (faCatInfo.getCompany() != null) {
            filterItem = new FilterItemInfo("company.id", (Object)faCatInfo.getCompany().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("company.id", null, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            if (i != 0) {
                sb.append(" and #" + i);
                continue;
            }
            sb.append("#" + i);
        }
        filter.setMaskString(sb.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, (DataBaseInfo)faCatInfo, "number") + faCatInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        FaCatInfo faCatInfo = (FaCatInfo)model;
        if (faCatInfo.getParent() != null && faCatInfo.getParent().getId() != null) {
            FaCatInfo faCatInfoParent = faCatInfo.getParent();
            ObjectUuidPK pkParent = new ObjectUuidPK(faCatInfoParent.getId());
            try {
                this.isReferenced(ctx, (IObjectPK)pkParent);
            }
            catch (ObjectReferedException e) {
                String name = this._getPropertyAlias(ctx, (DataBaseInfo)faCatInfo, "name") + faCatInfo.getName();
                throw new EASBizException(EASBizException.CHECKPARENTBEUSED, (Throwable)e, new Object[]{name});
            }
        }
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaCatInfo faCatInfo = (FaCatInfo)model;
        if (faCatInfo.getParent() != null && faCatInfo.getParent().getId() != null) {
            FaCatInfo faCatInfoParent = faCatInfo.getParent();
            ObjectUuidPK pkParent = new ObjectUuidPK(faCatInfoParent.getId());
            try {
                this.isReferenced(ctx, (IObjectPK)pkParent);
            }
            catch (ObjectReferedException e) {
                String name = this._getPropertyAlias(ctx, (DataBaseInfo)faCatInfo, "name") + faCatInfo.getName();
                throw new EASBizException(EASBizException.CHECKPARENTBEUSED, (Throwable)e, new Object[]{name});
            }
        }
        IObjectPK pk = super._addnew(ctx, model);
        return pk;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._save(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
        FaCatInfo faCatInfo = (FaCatInfo)model;
        if (faCatInfo != null) {
            try {
                HashSet allIdSet = this.getAllIdSet(ctx, faCatInfo, this.isParentNode(ctx));
                StringBuffer sbSql = new StringBuffer(100);
                if (allIdSet != null && allIdSet.size() > 0) {
                    if (faCatInfo.isGcUseLimitAndPureRate()) {
                        sbSql.append("  update t_fa_cat set FUseLimitFrom = ").append(faCatInfo.getBigDecimal("uselimitfrom"));
                        sbSql.append(", FUseLimitTo = ").append(faCatInfo.getBigDecimal("uselimitto"));
                        sbSql.append(", FPrePureRateFrom = ").append(faCatInfo.getPrePureRateFrom().toPlainString());
                        sbSql.append(", FPrePureRateTo = ").append(faCatInfo.getPrePureRateTo().toPlainString());
                        sbSql.append(", FGCUseLimitAndPureRate = ").append(1);
                        sbSql.append("  where fid in (").append(this.getIdList(allIdSet)).append(")");
                    } else {
                        sbSql.append("  update t_fa_cat set FGCUseLimitAndPureRate = ").append(0);
                        sbSql.append(", FUseLimitFrom = ").append(faCatInfo.getBigDecimal("uselimitfrom"));
                        sbSql.append(", FUseLimitTo = ").append(faCatInfo.getBigDecimal("uselimitto"));
                        sbSql.append(", FPrePureRateFrom = ").append(faCatInfo.getPrePureRateFrom().toPlainString());
                        sbSql.append(", FPrePureRateTo = ").append(faCatInfo.getPrePureRateTo().toPlainString());
                        sbSql.append(", FUseLimit = ").append(faCatInfo.getBigDecimal("uselimit"));
                        sbSql.append(", FPrePureRemnantRate = ").append(faCatInfo.getPrePureRate());
                        sbSql.append("  where fid in (").append(this.getIdList(allIdSet)).append(")");
                    }
                    DbUtil.execute((Context)ctx, (String)sbSql.toString());
                }
            }
            catch (Exception e) {
                logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.BASEDATAAutoGenerateResource", (String)"58_FaCatControllerBean", (Locale)ctx.getLocale()) + e));
            }
        }
    }

    private HashSet getAllIdSet(Context ctx, FaCatInfo faCatInfo, boolean isParentNode) throws SQLException, BOSException, EASBizException {
        HashSet allIdSet = new HashSet();
        HashSet<String> parentIdSet = new HashSet<String>();
        StringBuffer sbSql = new StringBuffer(100);
        IRowSet rowSet = null;
        String companyId = faCatInfo.getCompany().getId().toString();
        CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        String longNumber = companyOrgUnitInfo.getLongNumber();
        if (isParentNode) {
            sbSql.append("select fid from t_fa_cat where fnumber= '").append(faCatInfo.getNumber()).append("'");
        } else {
            sbSql.append(" select a.fid from t_fa_cat a ");
            sbSql.append(" inner join t_org_company b on a.fcompanyid = b.fid ");
            sbSql.append(" where a.fnumber = '").append(faCatInfo.getNumber()).append("'");
            sbSql.append(" and (b.flongnumber = '").append(longNumber).append("'");
            sbSql.append(" or b.flongnumber like '").append(longNumber + "!%").append("' )");
        }
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString());
        while (rowSet.next()) {
            parentIdSet.add(rowSet.getString("fid"));
        }
        allIdSet.addAll(parentIdSet);
        if (!faCatInfo.isGcUseLimitAndPureRate() && this.hasUseLimitChange(ctx)) {
            return allIdSet;
        }
        String parentIdList = this.getIdList(parentIdSet);
        if (StringUtils.isNotBlank((String)parentIdList)) {
            while (true) {
                HashSet<String> idSet = new HashSet<String>();
                sbSql.setLength(0);
                sbSql.append("select fid from t_fa_cat where fparentid in (").append(parentIdList).append(")");
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString());
                if (rowSet == null || rowSet.size() <= 0) break;
                while (rowSet.next()) {
                    idSet.add(rowSet.getString("fid"));
                }
                parentIdList = this.getIdList(idSet);
                allIdSet.addAll(idSet);
            }
        }
        return allIdSet;
    }

    private String getIdList(HashSet idSet) {
        String idList = "";
        if (idSet != null && idSet.size() > 0) {
            Iterator iter = idSet.iterator();
            while (iter.hasNext()) {
                idList = idList + "'" + (String)iter.next() + "',";
            }
            idList = idList.substring(0, idList.length() - 1);
        }
        return idList;
    }

    private boolean isParentNode(Context ctx) {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        return aCompanyOrgUnitInfo.getId().toString().equals("00000000-0000-0000-0000-000000000000CCE7AED4");
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._submit(ctx, model);
    }

    @Override
    public FaCatCollection getFaCatCollection(Context ctx, EntityViewInfo view) throws BOSException {
        return super.getFaCatCollection(ctx, view);
    }

    protected void _isReferenced(Context ctx, IObjectPK pk) throws ObjectReferedException {
        boolean isRef = false;
        try {
            isRef = FaCurCardFactory.getLocalInstance((Context)ctx).exists("where assetcat.id='" + pk.toString() + "'");
            if (isRef) {
                throw new ObjectReferedException((Object)new BizReferenceException(BizReferenceException.BIZ_REFENCED));
            }
            isRef = FaBizCardFactory.getLocalInstance((Context)ctx).exists("where assetcat.id='" + pk.toString() + "'");
            if (isRef) {
                throw new ObjectReferedException((Object)new BizReferenceException(BizReferenceException.BIZ_REFENCED));
            }
            isRef = FaMonCardFactory.getLocalInstance((Context)ctx).exists("where assetcat.id='" + pk.toString() + "'");
            if (isRef) {
                throw new ObjectReferedException((Object)new BizReferenceException(BizReferenceException.BIZ_REFENCED));
            }
            isRef = FaBakCardFactory.getLocalInstance((Context)ctx).exists("where assetcat.id='" + pk.toString() + "'");
            if (isRef) {
                throw new ObjectReferedException((Object)new BizReferenceException(BizReferenceException.BIZ_REFENCED));
            }
        }
        catch (Exception e) {
            throw new ObjectReferedException((Object)e);
        }
    }

    @Override
    protected IObjectPK _importData(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        UserInfo userInfo = this.getUserInfo(ctx);
        FaCatInfo faCatInfo = (FaCatInfo)model;
        faCatInfo.setCreator(userInfo);
        Date date = new Date();
        long time = date.getTime();
        faCatInfo.setCreateTime(new Timestamp(time));
        faCatInfo.setLastUpdateUser(userInfo);
        faCatInfo.setLastUpdateTime(new Timestamp(time));
        IObjectPK pk = this.innerAddnew(ctx, model);
        return pk;
    }

    protected UserInfo getUserInfo(Context ctx) throws BOSException {
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        return userInfo;
    }

    @Override
    protected IObjectCollection _getCollectionByView(Context ctx, EntityViewInfo view) throws BOSException {
        return super.getFaCatCollection(ctx, view);
    }

    private List getWrongCompany(Context ctx) throws EASBizException, BOSException {
        ArrayList<PeriodInfo> d = new ArrayList<PeriodInfo>();
        CompanyOrgUnitInfo companyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)companyOrgUnitInfo);
        PeriodInfo startPeriodInfo = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)companyOrgUnitInfo);
        PeriodInfo nextPeriodInfo = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)startPeriodInfo);
        if (nextPeriodInfo.isIsAdjustPeriod()) {
            nextPeriodInfo = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)startPeriodInfo);
        }
        IRowSet result = null;
        while (nextPeriodInfo.getNumber() < currentPeriodInfo.getNumber()) {
            result = this.getWrongNumber(ctx, companyOrgUnitInfo, nextPeriodInfo, startPeriodInfo);
            try {
                if (result != null && result.next()) {
                    String periodId = result.getString("ffaperiodid");
                    PeriodInfo info = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(periodId));
                    d.add(info);
                    return d;
                }
                startPeriodInfo = nextPeriodInfo;
                if (!(nextPeriodInfo = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)nextPeriodInfo)).isIsAdjustPeriod()) continue;
                nextPeriodInfo = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)startPeriodInfo);
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
        }
        return null;
    }

    private IRowSet getWrongNumber(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, PeriodInfo nextPeriodInfo, PeriodInfo startPeriodInfo) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct mon1.ffaperiodid from t_fa_famoncard mon1  ");
        sql.append(" inner join t_fa_famoncard mon2  ");
        sql.append(" on mon1.ffacurcardid = mon2.ffacurcardid  ");
        sql.append(" and mon1.FAccuDepr = mon2.FAccuDepr  ");
        sql.append(" where mon1.fcompanyid='" + companyOrgUnitInfo.getId().toString() + "'  ");
        sql.append(" and mon2.fcompanyid='" + companyOrgUnitInfo.getId().toString() + "'  ");
        sql.append(" and mon1.ffaperiodid in  (select fid from t_bd_period where fnumber=" + nextPeriodInfo.getNumber() + ")  ");
        sql.append(" and mon2.ffaperiodid in (select fid from t_bd_period where fnumber=" + startPeriodInfo.getNumber() + ")  ");
        sql.append(" and mon1.FDeprTTerm>0  ");
        try {
            return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)e);
            return null;
        }
    }

    private void makeMoncard(Context ctx, String companyid, String makeID, String preID) {
        StringBuffer sql = new StringBuffer();
        sql.append(" update t_fa_famoncard set FAccuDepr=FAccuDepr+FDeprTTerm  ");
        sql.append(",FAccuDeprAll=FAccuDeprAll+FDeprTTerm ");
        sql.append(",FAccuDeprTYear=FAccuDeprTYear+FDeprTTerm  ");
        sql.append(",FNeatValue=FNeatValue-FDeprTTerm  ");
        sql.append(",FNeatAmt=FNeatAmt-FDeprTTerm  ");
        sql.append(",FDeprTermCount=FDeprTermCount+1  ");
        sql.append("where ffaperiodid='" + makeID + "'  ");
        sql.append("and fcompanyid='" + companyid + "'  ");
        sql.append("and ffacurcardid in  ");
        sql.append("(  ");
        sql.append("select mon1.ffacurcardid from t_fa_famoncard mon1  ");
        sql.append("inner join t_fa_famoncard mon2  ");
        sql.append("on mon1.ffacurcardid = mon2.ffacurcardid  ");
        sql.append("and mon1.FAccuDepr = mon2.FAccuDepr  ");
        sql.append("where mon1.fcompanyid='" + companyid + "'  ");
        sql.append("and mon2.fcompanyid='" + companyid + "'  ");
        sql.append("and mon1.ffaperiodid='" + makeID + "'  ");
        sql.append("and mon2.ffaperiodid ='" + preID + "'  ");
        sql.append("and mon1.FDeprTTerm>0  ");
        sql.append(")");
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    private void makeMoncard(Context ctx, String companyid, String makeID, String preID, String wrongID) {
        StringBuffer sql = new StringBuffer();
        sql.append(" update t_fa_famoncard set (FAccuDepr,FAccuDeprAll,FAccuDeprTYear,FNeatValue,FNeatAmt,FDeprTermCount)  ");
        sql.append(" =( ");
        sql.append("select t_fa_famoncard.FAccuDepr+mon.FDeprTTerm, ");
        sql.append(" t_fa_famoncard.FAccuDeprAll+mon.FDeprTTerm, t_fa_famoncard.FAccuDeprTYear+mon.FDeprTTerm, t_fa_famoncard.FNeatValue-mon.FDeprTTerm,  ");
        sql.append(" t_fa_famoncard.FNeatAmt-mon.FDeprTTerm,t_fa_famoncard.FDeprTermCount+1  ");
        sql.append(" from t_fa_famoncard mon where mon.fcompanyid='" + companyid + "'  ");
        sql.append(" and mon.ffaperiodid='" + wrongID + "' ");
        sql.append(" and mon.ffacurcardid=t_fa_famoncard.ffacurcardid and mon.fcompanyid=t_fa_famoncard.fcompanyid ");
        sql.append(" ) ");
        sql.append(" where ffaperiodid='" + makeID + "' ");
        sql.append("and fcompanyid='" + companyid + "'  ");
        sql.append("and ffacurcardid in  ");
        sql.append("(  ");
        sql.append("select mon1.ffacurcardid from t_fa_famoncard mon1  ");
        sql.append("inner join t_fa_famoncard mon2  ");
        sql.append("on mon1.ffacurcardid = mon2.ffacurcardid  ");
        sql.append("and mon1.FAccuDepr = mon2.FAccuDepr  ");
        sql.append("where mon1.fcompanyid='" + companyid + "' ");
        sql.append("and mon2.fcompanyid='" + companyid + "'  ");
        sql.append("and mon1.ffaperiodid='" + wrongID + "'  ");
        sql.append("and mon2.ffaperiodid ='" + preID + "' ");
        sql.append("and mon1.FDeprTTerm>0  ");
        sql.append(")");
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    private void makeCurcard(Context ctx, String companyid, String wrongPeriodid, String prePeriodId) {
        StringBuffer sql = new StringBuffer();
        sql.append(" update t_fa_facurcard set (FAccuDepr,FAccuDeprAll,FAccuDeprTYear,FNeatValue,FNeatAmt,FDeprTermCount) = ");
        sql.append(" ( ");
        sql.append("select t_fa_facurcard.FAccuDepr+entry.FDepreciation, t_fa_facurcard.FAccuDeprAll+entry.FDepreciation,t_fa_facurcard.FAccuDeprTYear+entry.FDepreciation ");
        sql.append(",t_fa_facurcard.FNeatValue-entry.FDepreciation,t_fa_facurcard.FNeatAmt-entry.FDepreciation,t_fa_facurcard.FDeprTermCount+1 from t_fa_fadepreciationentry as entry ");
        sql.append("inner join t_Fa_fadepreciation as head ");
        sql.append(" on entry.FLnkFaDepreEntry = head.fid ");
        sql.append("where head.fcompanyid='" + companyid + "' ");
        sql.append("and head.fperiod='" + wrongPeriodid + "' ");
        sql.append("and  entry.fdepreciation>0 ");
        sql.append("and  entry.ffacurcardid = t_fa_facurcard.fid ");
        sql.append(") ");
        sql.append("where fcompanyid= '" + companyid + "' ");
        sql.append("and fid in ");
        sql.append("( ");
        sql.append("select mon1.ffacurcardid from t_fa_famoncard mon1 ");
        sql.append("inner join t_fa_famoncard mon2 ");
        sql.append("on mon1.ffacurcardid = mon2.ffacurcardid ");
        sql.append("and mon1.FAccuDepr = mon2.FAccuDepr ");
        sql.append("where mon1.fcompanyid='" + companyid + "' ");
        sql.append("and mon2.fcompanyid='" + companyid + "' ");
        sql.append("and mon1.ffaperiodid='" + wrongPeriodid + "' ");
        sql.append("and mon2.ffaperiodid ='" + prePeriodId + "' ");
        sql.append("and mon1.FDeprTTerm>0 ");
        sql.append(" ) ");
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    @Override
    protected List _checkCurrentCompanyData(Context ctx) throws BOSException, EASBizException {
        return this.getWrongCompany(ctx);
    }

    private boolean checkInputNumberValid(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, PeriodInfo nextPeriodInfo, PeriodInfo startPeriodInfo) {
        IRowSet result = this.getWrongNumber(ctx, companyOrgUnitInfo, nextPeriodInfo, startPeriodInfo);
        try {
            if (result == null || !result.next()) {
                return false;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return true;
    }

    @Override
    protected void _makeCurrentCompanyData(Context ctx, String dfd) throws BOSException, EASBizException {
        boolean valid;
        PeriodInfo prePeriodInfo;
        int year = new Integer(dfd.substring(0, 4));
        int number = new Integer(dfd.substring(5, dfd.length()));
        CompanyOrgUnitInfo companyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)companyOrgUnitInfo);
        PeriodInfo currentPeriodPre = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)currentPeriodInfo);
        PeriodInfo periodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (int)year, (int)number, (CompanyOrgUnitInfo)companyOrgUnitInfo);
        PeriodInfo wrongNextPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)periodInfo);
        if (wrongNextPeriod.isIsAdjustPeriod()) {
            wrongNextPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)wrongNextPeriod);
        }
        if ((prePeriodInfo = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)periodInfo)).isIsAdjustPeriod()) {
            prePeriodInfo = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)prePeriodInfo);
        }
        if (!(valid = this.checkInputNumberValid(ctx, companyOrgUnitInfo, periodInfo, prePeriodInfo))) {
            throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.BASEDATAAutoGenerateResource", (String)"5_FaCatControllerBean", (Locale)ctx.getOriginLocale())));
        }
        while (wrongNextPeriod.getNumber() <= currentPeriodPre.getNumber()) {
            this.makeMoncard(ctx, companyOrgUnitInfo.getId().toString(), wrongNextPeriod.getId().toString(), prePeriodInfo.getId().toString(), periodInfo.getId().toString());
            if (!(wrongNextPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)wrongNextPeriod)).isIsAdjustPeriod()) continue;
            wrongNextPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)wrongNextPeriod);
        }
        this.makeCurcard(ctx, companyOrgUnitInfo.getId().toString(), periodInfo.getId().toString(), prePeriodInfo.getId().toString());
        this.makeMoncard(ctx, companyOrgUnitInfo.getId().toString(), periodInfo.getId().toString(), prePeriodInfo.getId().toString());
    }

    private List getAllCompanyFromCard(Context ctx) throws BOSException, EASBizException {
        ArrayList<CompanyOrgUnitInfo> company = new ArrayList<CompanyOrgUnitInfo>();
        StringBuffer sql = new StringBuffer();
        sql.append("select  fcompanyid from t_fa_facurcard group by fcompanyid ");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            CompanyOrgUnitInfo companyOrgUnitInfo = null;
            while (result != null && result.next()) {
                String companyid = result.getString("fcompanyid");
                companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyid));
                company.add(companyOrgUnitInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return company;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _getAllWrongCompany(Context ctx) throws BOSException, EASBizException {
        List companyList;
        ResultSet result;
        PreparedStatement pst;
        Connection conn;
        ArrayList<CompanyOrgUnitInfo> d;
        block11: {
            StringBuffer sql = new StringBuffer();
            sql.append("select distinct mon1.ffaperiodid from t_fa_famoncard mon1 ");
            sql.append("inner join t_fa_famoncard mon2 ");
            sql.append("on mon1.ffacurcardid = mon2.ffacurcardid ");
            sql.append("and mon1.FAccuDepr = mon2.FAccuDepr ");
            sql.append("where mon1.fcompanyid =? ");
            sql.append("and mon2.fcompanyid =? ");
            sql.append("and mon1.ffaperiodid in (select fid from t_bd_period where fnumber =?) ");
            sql.append("and mon2.ffaperiodid in (select fid from t_bd_period where fnumber =?) ");
            sql.append("and mon1.FDeprTTerm > 0 ");
            d = new ArrayList<CompanyOrgUnitInfo>();
            conn = null;
            pst = null;
            result = null;
            conn = EJBFactory.getConnection((Context)ctx);
            pst = conn.prepareStatement(sql.toString());
            companyList = this.getAllCompanyFromCard(ctx);
            if (companyList != null && companyList.size() > 0) break block11;
            List list = null;
            SQLUtils.cleanup(result, (Statement)pst, (Connection)conn);
            return list;
        }
        try {
            block7: for (CompanyOrgUnitInfo companyOrgUnitInfo : companyList) {
                PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)companyOrgUnitInfo);
                PeriodInfo startPeriodInfo = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)companyOrgUnitInfo);
                PeriodInfo nextPeriodInfo = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)startPeriodInfo);
                if (nextPeriodInfo.isIsAdjustPeriod()) {
                    nextPeriodInfo = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)startPeriodInfo);
                }
                while (nextPeriodInfo.getNumber() < currentPeriodInfo.getNumber()) {
                    pst.setString(1, companyOrgUnitInfo.getId().toString());
                    pst.setString(2, companyOrgUnitInfo.getId().toString());
                    pst.setInt(3, nextPeriodInfo.getNumber());
                    pst.setInt(4, startPeriodInfo.getNumber());
                    result = pst.executeQuery();
                    try {
                        if (result != null && result.next()) {
                            d.add(companyOrgUnitInfo);
                            continue block7;
                        }
                        startPeriodInfo = nextPeriodInfo;
                        if (!(nextPeriodInfo = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)nextPeriodInfo)).isIsAdjustPeriod()) continue;
                        nextPeriodInfo = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)startPeriodInfo);
                    }
                    catch (SQLException e) {
                        logger.error((Object)e);
                    }
                }
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(result, pst, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup(result, (Statement)pst, (Connection)conn);
        }
        SQLUtils.cleanup(result, (Statement)pst, (Connection)conn);
        return d;
    }

    @Override
    protected List _checkCurrentCompanyClearData(Context ctx) throws BOSException, EASBizException {
        ArrayList<StringBuffer> d = new ArrayList<StringBuffer>();
        CompanyOrgUnitInfo companyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        StringBuffer sql = new StringBuffer();
        sql.append(" select card.fnumber as fnumber1,period.fnumber as fnumber2 from t_fa_facurcard card ");
        sql.append(" inner join t_fa_clearbillentry entry  on card.fid = entry.FCurCardID ");
        sql.append(" inner join t_fa_clearbill head on head.fid = entry.FEntryID ");
        sql.append(" inner join t_bd_period period on period.fid = head.FPeriodID ");
        sql.append(" inner join t_fa_fabizcard biz on biz.fid=entry.FBizCardID ");
        sql.append(" where card.faccudepr!=entry.FClrAddupDep and entry.FClrQty=card.FAssetAmt ");
        sql.append(" and card.fcompanyid='" + companyOrgUnitInfo.getId().toString() + "'");
        sql.append(" and biz.FBillType=4 ");
        IRowSet reuslt = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (reuslt.next()) {
                StringBuffer number = new StringBuffer();
                number.append(reuslt.getInt("fnumber2") + "$" + reuslt.getString("fnumber1"));
                d.add(number);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return d;
    }

    @Override
    protected List _checkCurrentCompanyTwoData(Context ctx) throws BOSException, EASBizException {
        ArrayList<StringBuffer> d = new ArrayList<StringBuffer>();
        CompanyOrgUnitInfo companyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)companyOrgUnitInfo);
        PeriodInfo startPeriodInfo = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)companyOrgUnitInfo);
        PeriodInfo nextPeriodInfo = startPeriodInfo;
        if (nextPeriodInfo.isIsAdjustPeriod()) {
            nextPeriodInfo = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)startPeriodInfo);
        }
        IRowSet result = null;
        while (nextPeriodInfo.getNumber() < currentPeriodInfo.getNumber()) {
            StringBuffer sql = new StringBuffer();
            sql.append(" select mon1.fnumber as fnumber1,pd.fnumber as fnumber2 from t_fa_famoncard mon1  ");
            sql.append(" inner join t_fa_fadepreciationentry entry on mon1.ffacurcardid=entry.ffacurcardid ");
            sql.append(" inner join t_fa_fadepreciation head on head.fid = entry.flnkfadepreentry ");
            sql.append(" inner join t_bd_period pd on pd.fid = head.fperiod ");
            sql.append(" where  head.fcompanyid='" + companyOrgUnitInfo.getId().toString() + "' and head.fperiod='" + nextPeriodInfo.getId().toString() + "' ");
            sql.append(" and mon1.ffaperiodid='" + nextPeriodInfo.getId().toString() + "' and mon1.fcompanyid='" + companyOrgUnitInfo.getId().toString() + "' ");
            sql.append(" and entry.fdepreciation!=mon1.fdeprtterm ");
            sql.append(" and mon1.fdeprtterm =0 ");
            result = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                while (result != null && result.next()) {
                    StringBuffer resultString = new StringBuffer();
                    resultString.append(result.getInt("fnumber2") + "$" + result.getString("fnumber1"));
                    d.add(resultString);
                }
                startPeriodInfo = nextPeriodInfo;
                if (!(nextPeriodInfo = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)nextPeriodInfo)).isIsAdjustPeriod()) continue;
                nextPeriodInfo = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)startPeriodInfo);
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
        }
        return d;
    }

    @Override
    protected List _getAllClearWrongCompany(Context ctx) throws BOSException, EASBizException {
        ArrayList<CompanyOrgUnitInfo> d = new ArrayList<CompanyOrgUnitInfo>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select card.fcompanyid from t_fa_facurcard card ");
        sql.append(" inner join t_fa_clearbillentry entry  on card.fid = entry.FCurCardID ");
        sql.append(" inner join t_fa_clearbill head on head.fid = entry.FEntryID ");
        sql.append(" inner join t_fa_fabizcard biz on biz.fid=entry.FBizCardID ");
        sql.append(" where card.faccudepr!=entry.FClrAddupDep and entry.FClrQty=card.FAssetAmt and biz.FBillType=4 group by card.fcompanyid");
        IRowSet reuslt = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        try {
            while (reuslt.next()) {
                String companyId = reuslt.getString("fcompanyid");
                companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                d.add(companyOrgUnitInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return d;
    }

    @Override
    protected List _getAllWrongTwoCompany(Context ctx) throws BOSException, EASBizException {
        ArrayList<CompanyOrgUnitInfo> d = new ArrayList<CompanyOrgUnitInfo>();
        List companyList = this.getAllCompanyFromCard(ctx);
        if (companyList == null || companyList.size() <= 0) {
            return null;
        }
        block2: for (CompanyOrgUnitInfo companyOrgUnitInfo : companyList) {
            PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)companyOrgUnitInfo);
            PeriodInfo startPeriodInfo = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)companyOrgUnitInfo);
            PeriodInfo nextPeriodInfo = startPeriodInfo;
            if (nextPeriodInfo.isIsAdjustPeriod()) {
                nextPeriodInfo = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)startPeriodInfo);
            }
            IRowSet result = null;
            while (nextPeriodInfo.getNumber() < currentPeriodInfo.getNumber()) {
                result = this.getAllWrongCardNumberByCompanyid(ctx, companyOrgUnitInfo, nextPeriodInfo);
                try {
                    if (result != null && result.next()) {
                        d.add(companyOrgUnitInfo);
                        continue block2;
                    }
                    startPeriodInfo = nextPeriodInfo;
                    if (!(nextPeriodInfo = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)nextPeriodInfo)).isIsAdjustPeriod()) continue;
                    nextPeriodInfo = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)startPeriodInfo);
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
        }
        return d;
    }

    private IRowSet getAllWrongCardNumberByCompanyid(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, PeriodInfo nextPeriodInfo) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select top 1 mon1.fcompanyid from t_fa_famoncard mon1  ");
        sql.append(" inner join t_fa_fadepreciationentry entry on mon1.ffacurcardid=entry.ffacurcardid ");
        sql.append(" inner join t_fa_fadepreciation head on head.fid = entry.flnkfadepreentry ");
        sql.append(" inner join t_bd_period pd on pd.fid = head.fperiod ");
        sql.append(" where  head.fcompanyid='" + companyOrgUnitInfo.getId().toString() + "' and head.fperiod='" + nextPeriodInfo.getId().toString() + "' ");
        sql.append("  and mon1.ffaperiodid='" + nextPeriodInfo.getId().toString() + "' and mon1.fcompanyid='" + companyOrgUnitInfo.getId().toString() + "' ");
        sql.append(" and entry.fdepreciation!=mon1.fdeprtterm ");
        sql.append(" and mon1.fdeprtterm =0 ");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return result;
    }

    @Override
    protected void _makeCurrentCompanyTwoData(Context ctx, String dfd) throws BOSException, EASBizException {
        FaCurCardInfo curCardInfo;
        PeriodInfo periodInfo;
        dfd = dfd.trim();
        int first = dfd.indexOf("$");
        String periodNmber = dfd.substring(0, first);
        String cardnumber = dfd.substring(first + 1, dfd.length());
        int year = new Integer(periodNmber.substring(0, 4));
        int number = new Integer(periodNmber.substring(5, periodNmber.length()));
        CompanyOrgUnitInfo companyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)companyOrgUnitInfo);
        PeriodInfo currentPeriodPre = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)currentPeriodInfo);
        PeriodInfo wrongPeriodInfo = periodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (int)year, (int)number, (CompanyOrgUnitInfo)companyOrgUnitInfo);
        PeriodInfo nextPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)periodInfo);
        if (nextPeriod.isIsAdjustPeriod()) {
            nextPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)nextPeriod);
        }
        if ((curCardInfo = FaCurCardFactory.getLocalInstance((Context)ctx).getFaCurCardInfo(" where company.id='" + companyOrgUnitInfo.getId().toString() + "' and number='" + cardnumber + "'")) == null) {
            return;
        }
        String cardID = curCardInfo.getId().toString();
        IRowSet rowSet = this.getAllWrongCardNumberByCompanyid(ctx, companyOrgUnitInfo, periodInfo);
        if (rowSet == null || rowSet.size() <= 0) {
            throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.BASEDATAAutoGenerateResource", (String)"22_FaCatControllerBean", (Locale)ctx.getOriginLocale())));
        }
        this.makeTwoMoncard(ctx, companyOrgUnitInfo.getId().toString(), periodInfo.getId().toString(), wrongPeriodInfo.getId().toString(), cardID, true);
        while (nextPeriod.getNumber() <= currentPeriodPre.getNumber()) {
            this.makeTwoMoncard(ctx, companyOrgUnitInfo.getId().toString(), nextPeriod.getId().toString(), wrongPeriodInfo.getId().toString(), cardID, false);
            if (!(nextPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)nextPeriod)).isIsAdjustPeriod()) continue;
            nextPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)nextPeriod);
        }
        this.makeTwoCurcard(ctx, companyOrgUnitInfo.getId().toString(), wrongPeriodInfo.getId().toString(), cardID);
    }

    private void makeTwoMoncard(Context ctx, String companyid, String makeID, String wrongID, String cardId, boolean curr) {
        StringBuffer sql = new StringBuffer();
        if (!curr) {
            sql.append(" update t_fa_famoncard set (FAccuDepr,FAccuDeprAll,FAccuDeprTYear,FNeatValue,FNeatAmt,FDeprTermCount)  ");
            sql.append(" =( ");
            sql.append("select t_fa_famoncard.FAccuDepr+entry.FDepreciation, ");
            sql.append(" t_fa_famoncard.FAccuDeprAll+entry.FDepreciation, t_fa_famoncard.FAccuDeprTYear+entry.FDepreciation, t_fa_famoncard.FNeatValue-entry.FDepreciation,  ");
            sql.append(" t_fa_famoncard.FNeatAmt-entry.FDepreciation,t_fa_famoncard.FDeprTermCount+1  ");
            sql.append(" from t_fa_fadepreciationentry entry ");
            sql.append(" inner join t_fa_fadepreciation head on head.fid = entry.flnkfadepreentry ");
            sql.append(" where head.fcompanyid='" + companyid + "'  ");
            sql.append(" and head.fperiod='" + wrongID + "' ");
            sql.append(" and entry.ffacurcardid='" + cardId + "'");
            sql.append(" and entry.ffacurcardid=t_fa_famoncard.ffacurcardid and head.fcompanyid=t_fa_famoncard.fcompanyid ");
            sql.append(" ) ");
            sql.append(" where ffaperiodid='" + makeID + "' ");
            sql.append("and fcompanyid='" + companyid + "'  ");
            sql.append("and ffacurcardid in  ");
            sql.append("(  ");
            sql.append("'" + cardId + "'");
            sql.append(")");
        } else {
            sql.append(" update t_fa_famoncard set (FAccuDepr,FAccuDeprAll,FAccuDeprTYear,FNeatValue,FNeatAmt,FDeprTermCount,fdeprtterm)  ");
            sql.append(" =( ");
            sql.append("select t_fa_famoncard.FAccuDepr+entry.FDepreciation, ");
            sql.append(" t_fa_famoncard.FAccuDeprAll+entry.FDepreciation, t_fa_famoncard.FAccuDeprTYear+entry.FDepreciation, t_fa_famoncard.FNeatValue-entry.FDepreciation,  ");
            sql.append(" t_fa_famoncard.FNeatAmt-entry.FDepreciation,t_fa_famoncard.FDeprTermCount+1 ,entry.fdepreciation ");
            sql.append(" from t_fa_fadepreciationentry entry ");
            sql.append(" inner join t_fa_fadepreciation head on head.fid = entry.flnkfadepreentry ");
            sql.append(" where head.fcompanyid='" + companyid + "'  ");
            sql.append(" and head.fperiod='" + wrongID + "' ");
            sql.append(" and entry.ffacurcardid='" + cardId + "'");
            sql.append(" and entry.ffacurcardid=t_fa_famoncard.ffacurcardid and head.fcompanyid=t_fa_famoncard.fcompanyid ");
            sql.append(" ) ");
            sql.append(" where ffaperiodid='" + makeID + "' ");
            sql.append("and fcompanyid='" + companyid + "'  ");
            sql.append("and ffacurcardid in  ");
            sql.append("(  ");
            sql.append("'" + cardId + "'");
            sql.append(")");
        }
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    private void makeTwoCurcard(Context ctx, String companyid, String wrongPeriodid, String cardId) {
        StringBuffer sql = new StringBuffer();
        sql.append(" update t_fa_facurcard set (FAccuDepr,FAccuDeprAll,FAccuDeprTYear,FNeatValue,FNeatAmt,FDeprTermCount) = ");
        sql.append(" ( ");
        sql.append("select t_fa_facurcard.FAccuDepr+entry.FDepreciation, t_fa_facurcard.FAccuDeprAll+entry.FDepreciation,t_fa_facurcard.FAccuDeprTYear+entry.FDepreciation ");
        sql.append(",t_fa_facurcard.FNeatValue-entry.FDepreciation,t_fa_facurcard.FNeatAmt-entry.FDepreciation,t_fa_facurcard.FDeprTermCount+1 from t_fa_fadepreciationentry as entry ");
        sql.append("inner join t_Fa_fadepreciation as head ");
        sql.append(" on entry.FLnkFaDepreEntry = head.fid ");
        sql.append("where head.fcompanyid='" + companyid + "' ");
        sql.append("and head.fperiod='" + wrongPeriodid + "' ");
        sql.append("and  entry.ffacurcardid='" + cardId + "' ");
        sql.append("and  entry.ffacurcardid = t_fa_facurcard.fid ");
        sql.append(") ");
        sql.append("where fcompanyid= '" + companyid + "' ");
        sql.append("and fid in ");
        sql.append("( ");
        sql.append("'" + cardId + "'");
        sql.append(" ) ");
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    @Override
    protected void _makeCurrentCompanyClearData(Context ctx, String dfd) throws BOSException, EASBizException {
        FaCurCardInfo curCardInfo;
        PeriodInfo periodInfo;
        dfd = dfd.trim();
        int first = dfd.indexOf("$");
        String periodNmber = dfd.substring(0, first);
        String cardnumber = dfd.substring(first + 1, dfd.length());
        int year = new Integer(periodNmber.substring(0, 4));
        int number = new Integer(periodNmber.substring(5, periodNmber.length()));
        CompanyOrgUnitInfo companyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)companyOrgUnitInfo);
        PeriodInfo currentPeriodPre = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)currentPeriodInfo);
        PeriodInfo wrongPeriodInfo = periodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (int)year, (int)number, (CompanyOrgUnitInfo)companyOrgUnitInfo);
        PeriodInfo nextPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)periodInfo);
        if (nextPeriod.isIsAdjustPeriod()) {
            nextPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)nextPeriod);
        }
        if ((curCardInfo = FaCurCardFactory.getLocalInstance((Context)ctx).getFaCurCardInfo(" where company.id='" + companyOrgUnitInfo.getId().toString() + "' and number='" + cardnumber + "'")) == null) {
            return;
        }
        String cardID = curCardInfo.getId().toString();
        this.makeClearBillEntry(ctx, companyOrgUnitInfo.getId().toString(), wrongPeriodInfo.getId().toString(), cardID);
        this.makeAccountBalance(ctx, companyOrgUnitInfo.getId().toString(), wrongPeriodInfo.getId().toString(), cardID);
        while (nextPeriod.getNumber() <= currentPeriodPre.getNumber()) {
            this.RecalculationBalance(ctx, companyOrgUnitInfo.getId().toString(), nextPeriod.getId().toString(), wrongPeriodInfo.getId().toString(), cardID, false);
            if (!(nextPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)nextPeriod)).isIsAdjustPeriod()) continue;
            nextPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)nextPeriod);
        }
    }

    private void makeClearBillEntry(Context ctx, String companyid, String wrongPeriodid, String cardId) {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_fa_clearbillentry set fclraddupdep=( select faccudepr from  t_fa_facurcard ");
        sql.append("where fcompanyid='" + companyid + "'");
        sql.append(" and fid='" + cardId + "')");
        sql.append(" where fcurcardid='" + cardId + "'");
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    private void makeAccountBalance(Context ctx, String companyid, String wrongPeriodid, String cardID) {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_fa_faaccountbalance set  FDepreDebitFor=(");
        sql.append("select FClrAddupDep from t_fa_clearbillentry where FCurCardID='" + cardID + "' )");
        sql.append("where FFaCurCardID='" + cardID + "'");
        sql.append("and FCompanyOrgUnitID='" + companyid + "'");
        sql.append("and FPeriodID='" + wrongPeriodid + "'");
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        sql.append("update t_fa_faaccountbalance set ");
        sql.append("frealendbalancefor = frealbeginbalancefor + frealdebitfor - frealcreditfor, ");
        sql.append("fdepreendbalancefor = fdeprebeginbalancefor - fdepredebitfor + fdeprecreditfor, ");
        sql.append("fdecvalueendbalancefor = fdecvaluebeginbalancefor - fdecvaluedebitfor + fdecvaluecreditfor, ");
        sql.append("fevalueendbalancefor = fevalueendbalancefor + fevaluedebitfor - fevaluecreditfor ");
        sql.append("where fcompanyOrgUnitid = '" + companyid + "' ");
        sql.append("and fperiodid ='" + wrongPeriodid + "' ");
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    private void RecalculationBalance(Context ctx, String companyid, String wrongPeriodid, String cardID, String periodid, boolean b) {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_fa_faaccountbalance set ");
        sql.append("(frealBeginBalanceFor,FDepreBeginBalanceFor,FDecValueBeginBalanceFor,FEvalueBeginBalanceFor) =( ");
        sql.append("select FRealEndBalanceFor,FDepreEndBalanceFor,fdecvalueendbalancefor,fevalueendbalancefor from ");
        sql.append("(select * from t_fa_faaccountbalance) acc where acc.fcompanyOrgUnitid ='" + companyid + "'");
        sql.append("and acc.fperiodid = " + wrongPeriodid + "");
        sql.append("and t_fa_faaccountbalance.ffacurcardid=acc.ffacurcardid ) ");
        sql.append("where t_fa_faaccountbalance.fcompanyOrgUnitid ='" + companyid + "'");
        sql.append("and t_fa_faaccountbalance.fperiodid = (select fid from t_bd_period where fnumber = " + periodid + " )");
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        sql.append("update t_fa_faaccountbalance set ");
        sql.append("frealendbalancefor = frealbeginbalancefor + frealdebitfor - frealcreditfor, ");
        sql.append("fdepreendbalancefor = fdeprebeginbalancefor - fdepredebitfor + fdeprecreditfor, ");
        sql.append("fdecvalueendbalancefor = fdecvaluebeginbalancefor - fdecvaluedebitfor + fdecvaluecreditfor, ");
        sql.append("fevalueendbalancefor = fevalueendbalancefor + fevaluedebitfor - fevaluecreditfor ");
        sql.append("where fcompanyOrgUnitid = '" + companyid + "' ");
        sql.append("and fperiodid ='" + periodid + "' ");
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    @Override
    public TreeBaseCollection getTreeBaseCollection(Context ctx, EntityViewInfo view) throws BOSException {
        return super.getTreeBaseCollection(ctx, view.toString());
    }

    private boolean hasUseLimitChange(Context ctx) throws EASBizException, BOSException {
        boolean hasUseLimitChanged = false;
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        HashMap hmResult = FaManageUtils.getFAParameter((BOSUuid)company.getId(), (Context)ctx);
        String hasUseLimit = (String)hmResult.get("FA_288");
        if (hasUseLimit != null && "true".equals(hasUseLimit)) {
            hasUseLimitChanged = true;
        }
        return hasUseLimitChanged;
    }
}

