/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.KAClassficationCollection;
import com.kingdee.eas.basedata.assistant.KAClassficationFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FADecValuePolicyFactory;
import com.kingdee.eas.fi.fa.basedata.FADepreciationPolicyFactory;
import com.kingdee.eas.fi.fa.basedata.FaCatCollection;
import com.kingdee.eas.fi.fa.basedata.FaCatFactory;
import com.kingdee.eas.fi.fa.basedata.FaCatInfo;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeCollection;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeFactory;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.fa.basedata.IFaCat;
import com.kingdee.eas.fi.fa.def.FaDefStyleFactory;
import com.kingdee.eas.fi.fa.def.FaDefStyleInfo;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.STConverter;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.log4j.Logger;

public class FaCatDataImport
extends AbstractDataTransmission {
    private static final Logger logger = Logger.getLogger(FaCatDataImport.class);
    private String[] EXP_FIELD_IN_FILE = new String[]{"FNumber", "FParentId", "FGroupLevel", "Fname", "FUseLimit", "FPrePureRemnantRate", "FMeasureUnitID", "FDepreciationModeID", "FClassficationID", "FDepreciationPolicy", "FNumberRule", "FCalcuByEvaluate", "FDecValPolicy", "Fdescription", "FCreatorNumber", "FCreateTime", "FStyleNumber"};
    private String[] EXP_FIELD_IN_QUERY = new String[]{"number", "parent.number", "groupLevel", "name", "useLimit", "prePureRate", "measureUnit.number", "depreMode.number", "classfication.number", "DepreciationPolicy.number", "numberRule", "calcuByEvaluate", "decPolicy.Name", "description", "creator.number", "createTime", "style.number"};

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            this.getController(ctx).addnew(coreBaseInfo);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return FaCatFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        String strTemp;
        String message;
        FaCatInfo info;
        BigDecimal decValue;
        String str;
        Locale locale;
        CompanyOrgUnitInfo aCompanyOrgUnitInfo;
        block71: {
            AbstractObjectCollection policyColl;
            aCompanyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
            locale = ctx.getOriginLocale();
            str = null;
            decValue = null;
            info = new FaCatInfo();
            info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
            info.setCompany(aCompanyOrgUnitInfo);
            boolean isDefCu = "00000000-0000-0000-0000-000000000000CCE7AED4".equals(info.getCU().getId().toString());
            str = this.getDataString(hsData, "FNumber");
            message = null;
            strTemp = "";
            IFaCat iFactory = (IFaCat)this.getController(ctx);
            if (str == null || str.trim().length() == 0) {
                message = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource.strNumberIsNull", (Locale)locale);
            } else {
                info.setNumber(str.trim());
                try {
                    iFactory.checkNumberDup((DataBaseInfo)info);
                }
                catch (Exception e) {
                    message = FaResUtil.getRes("faCatNumberDup", locale);
                }
            }
            str = this.getDataString(hsData, "Fname");
            if (str == null || str.trim().length() == 0) {
                strTemp = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource.strNameIsNull", (Locale)locale);
                message = this.appendErrMsg(message, strTemp);
            } else {
                boolean isfileName = StringUtils.isFileName((String)str);
                if (!isfileName) {
                    strTemp = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource.strIllegalName", (Locale)locale);
                    message = this.appendErrMsg(message, strTemp);
                } else {
                    info.setName(str);
                    try {
                        iFactory.checkNameDup((DataBaseInfo)info);
                    }
                    catch (Exception e) {
                        message = FaResUtil.getRes("faCatNameDup", locale);
                    }
                }
            }
            str = this.getDataString(hsData, "FMeasureUnitID");
            if (str != null && str.trim().length() != 0) {
                MeasureUnitCollection measureUnitColl = null;
                try {
                    measureUnitColl = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitCollection(this.getGroupFilter(str));
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
                if (measureUnitColl == null || measureUnitColl.size() == 0) {
                    strTemp = FaResUtil.getRes("noMeasureUnitNumber", locale);
                    message = this.appendErrMsg(message, strTemp);
                } else {
                    info.setMeasureUnit(measureUnitColl.get(0));
                }
            }
            if ((str = this.getDataString(hsData, "FDepreciationPolicy")) == null || str.trim().length() == 0) {
                strTemp = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource.FaCatEditUI_DeprPolicyIsNull", (Locale)locale);
                message = this.appendErrMsg(message, strTemp);
            } else {
                policyColl = null;
                try {
                    policyColl = FADepreciationPolicyFactory.getLocalInstance(ctx).getFADepreciationPolicyCollection(this.getGroupFilter(str));
                }
                catch (BOSException e1) {
                    logger.error((Object)e1);
                }
                if (policyColl == null || policyColl.size() == 0) {
                    strTemp = FaResUtil.getRes("noDprPolicyNumber", locale);
                    message = this.appendErrMsg(message, strTemp);
                } else {
                    info.setDepreciationPolicy(policyColl.get(0));
                }
            }
            str = this.getDataString(hsData, "FDecValPolicy");
            if (str == null || str.trim().length() == 0) {
                strTemp = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource.FaCatEditUI_decValPolicyIsNull", (Locale)locale);
                message = this.appendErrMsg(message, strTemp);
            } else {
                policyColl = null;
                try {
                    policyColl = FADecValuePolicyFactory.getLocalInstance(ctx).getFADecValuePolicyCollection("where name='" + str + "'");
                }
                catch (BOSException e1) {
                    logger.error((Object)e1);
                }
                if (policyColl == null || policyColl.size() == 0) {
                    strTemp = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource.FaCatEditUI_decValPolicyIsNull", (Locale)locale);
                    message = this.appendErrMsg(message, strTemp);
                } else {
                    info.setDecValPolicy(policyColl.get(0));
                }
            }
            str = this.getDataString(hsData, "FNumberRule");
            if (str == null || str.trim().length() == 0) {
                strTemp = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource.FaCatEditUI_NumberRuleIsNull", (Locale)locale);
                message = this.appendErrMsg(message, strTemp);
            } else {
                info.setNumberRule(str);
            }
            str = this.getDataString(hsData, "FParentId");
            if (str != null && str.trim().length() != 0) {
                FaCatCollection catColl = null;
                try {
                    catColl = iFactory.getFaCatCollection(this.getCUFilter(str, aCompanyOrgUnitInfo.getCU().getId().toString()));
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
                if (catColl == null || catColl.size() == 0) {
                    strTemp = " " + MessageFormat.format(FaResUtil.getRes("noParentCat", locale), str);
                    message = this.appendErrMsg(message, strTemp);
                } else {
                    info.setParent(catColl.get(0));
                    int groupLevel = catColl.get(0).getGroupLevel();
                    if (!isDefCu) {
                        try {
                            iFactory.isReferenced((IObjectPK)new ObjectUuidPK(info.getParent().getId()));
                            if (catColl.get(0).getLevel() >= groupLevel) {
                                info.setGroupLevel(groupLevel);
                                break block71;
                            }
                            strTemp = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.BASEDATAAutoGenerateResource", (String)"3_FaCatDataImport", (Locale)ctx.getOriginLocale());
                            message = this.appendErrMsg(message, strTemp);
                        }
                        catch (Exception e) {
                            strTemp = " " + FaResUtil.getRes("parentIsRef", locale);
                            message = this.appendErrMsg(message, strTemp);
                        }
                    } else if (catColl.get(0).getLevel() < groupLevel) {
                        info.setGroupLevel(groupLevel);
                    } else {
                        strTemp = " " + FaResUtil.getRes("inputCatOverGroupLevel", locale);
                        message = this.appendErrMsg(message, strTemp);
                    }
                }
            } else if (isDefCu) {
                try {
                    int level = this.getDataInt(hsData, "FGroupLevel");
                    if (level <= 0) {
                        throw new Exception();
                    }
                    info.setGroupLevel(level);
                }
                catch (Exception e1) {
                    strTemp = FaResUtil.getRes("oneControlLevelGreater0", locale);
                    message = this.appendErrMsg(message, strTemp);
                }
            } else {
                strTemp = FaResUtil.getRes("mustInputParentId", locale);
                message = this.appendErrMsg(message, strTemp);
            }
        }
        try {
            BigDecimal limit = this.getDataBigDecimal(hsData, "FUseLimit");
            if (limit != null) {
                info.setUseLimit(limit);
            }
        }
        catch (Exception e1) {
            strTemp = FaResUtil.getRes("yearMustGreater0", locale);
            message = this.appendErrMsg(message, strTemp);
        }
        try {
            decValue = this.getDataBigDecimal(hsData, "FPrePureRemnantRate");
            if (decValue == null) {
                decValue = new BigDecimal("0");
            }
            if (decValue.compareTo(new BigDecimal("0")) < 0 || decValue.compareTo(new BigDecimal("100")) > 0) {
                throw new Exception();
            }
            info.setPrePureRate(decValue.setScale(2, 4));
        }
        catch (Exception e1) {
            strTemp = MessageFormat.format(FaResUtil.getRes("preNetValueMustBetween", locale), "0", "100");
            message = this.appendErrMsg(message, strTemp);
        }
        str = this.getDataString(hsData, "FDepreciationModeID");
        if (str != null && str.trim().length() != 0) {
            FaDepreciationModeCollection modeColl = null;
            try {
                modeColl = FaDepreciationModeFactory.getLocalInstance(ctx).getFaDepreciationModeCollection(this.getGroupFilter(str));
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            if (modeColl != null && modeColl.size() > 0) {
                info.setDepreMode(modeColl.get(0));
            } else {
                strTemp = " " + MessageFormat.format(FaResUtil.getRes("ofDprModeIsNo", locale), str);
                message = this.appendErrMsg(message, strTemp);
            }
        }
        if ((str = this.getDataString(hsData, "FClassficationID")) != null && str.trim().length() != 0) {
            KAClassficationCollection classColl = null;
            try {
                EntityViewInfo classViewInfo = new EntityViewInfo();
                FilterItemInfo filterItem = new FilterItemInfo("number", (Object)str, CompareType.EQUALS);
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(filterItem);
                FilterItemInfo companyFilterItemInfo3 = new FilterItemInfo("currencyCompany.id", (Object)aCompanyOrgUnitInfo.getId().toString(), CompareType.EQUALS);
                filterInfo.getFilterItems().add(companyFilterItemInfo3);
                filterInfo.getFilterItems().add(new FilterItemInfo("typelink.objectType.number", (Object)"5000", CompareType.EQUALS));
                classViewInfo.setFilter(filterInfo);
                classColl = KAClassficationFactory.getLocalInstance((Context)ctx).getKAClassficationCollection(classViewInfo);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            if (classColl != null && classColl.size() > 0) {
                info.setClassfication(classColl.get(0));
            } else {
                strTemp = " " + MessageFormat.format(FaResUtil.getRes("ofAccountCatNo", locale), str);
                message = this.appendErrMsg(message, strTemp);
            }
        }
        if ((str = this.getDataString(hsData, "FStyleNumber")) != null && str.trim().length() != 0) {
            FaDefStyleInfo faDefStyleInfo = null;
            try {
                faDefStyleInfo = FaDefStyleFactory.getLocalInstance((Context)ctx).getFaDefStyleInfo("where number = '" + str + "' ");
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            if (faDefStyleInfo != null && faDefStyleInfo.getId() != null) {
                info.setStyle(faDefStyleInfo);
            } else {
                strTemp = " " + MessageFormat.format(FaResUtil.getRes("ofDefStyleNo", locale), str);
                message = this.appendErrMsg(message, strTemp);
            }
        }
        str = this.getDataString(hsData, "Fdescription");
        info.setDescription(str);
        if (message != null) {
            throw new TaskExternalException(message);
        }
        boolean isCalcuByEvaluate = FaCatDataImport.getBooleanValue(ctx, this.getDataString(hsData, "FCalcuByEvaluate"));
        info.setCalcuByEvaluate(isCalcuByEvaluate);
        Locale currentLocale = ctx.getLocale();
        this.setMutiLang(info, currentLocale, "name", info.getName());
        this.setMutiLang(info, currentLocale, "description", info.getDescription());
        this.setMutiLang(info, currentLocale, "displayName", info.getDisplayName());
        return info;
    }

    private String appendErrMsg(String message, String strTemp) {
        message = message == null ? strTemp : message + ";" + strTemp;
        return message;
    }

    private void setMutiLang(FaCatInfo info, Locale currentLocale, String property, Object value) {
        if (value == null) {
            return;
        }
        if (LocaleUtils.locale_L1.equals(currentLocale)) {
            info.put(property + "_l1", value);
            info.put(property + "_l2", value);
            info.put(property + "_l3", value);
        } else if (LocaleUtils.locale_L2.equals(currentLocale)) {
            info.put(property + "_l1", value);
            info.put(property + "_l2", value);
            info.put(property + "_l3", STConverter.sc2tc((String)((String)value)));
        } else if (LocaleUtils.locale_L3.equals(currentLocale)) {
            info.put(property + "_l1", value);
            info.put(property + "_l2", STConverter.tc2sc((String)((String)value)));
            info.put(property + "_l3", value);
        }
    }

    private EntityViewInfo getGroupFilter(String str) {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)str, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        return view;
    }

    private EntityViewInfo getCUFilter(String str, String cuId) {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)str, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("CU", (Object)cuId, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filter.setMaskString("#0 and #1");
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        return view;
    }

    private String getDataString(Hashtable hsData, String fieldName) {
        return DataImportTools.getDataString((Hashtable)hsData, (String)fieldName);
    }

    private BigDecimal getDataBigDecimal(Hashtable hsData, String fieldName) {
        return DataImportTools.getDataBigDecimal((Hashtable)hsData, (String)fieldName);
    }

    private int getDataInt(Hashtable hsData, String fieldName) {
        return DataImportTools.getDataint((Hashtable)hsData, (String)fieldName);
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        try {
            Hashtable result = this.setDataForExport(this.EXP_FIELD_IN_FILE, this.EXP_FIELD_IN_QUERY, rs, ctx);
            if (result.get("FCalcuByEvaluate") == null || result.get("FCalcuByEvaluate").toString().equalsIgnoreCase("false")) {
                result.put("FCalcuByEvaluate", FaResUtil.getRes("NG", ctx.getOriginLocale()));
            } else {
                result.put("FCalcuByEvaluate", FaResUtil.getRes("YES", ctx.getOriginLocale()));
            }
            return result;
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        if (ContextUtil.getCurrentFIUnit((Context)ctx) == null) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()));
        return filter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fi.fa.basedata.FaCatExportQuery";
    }

    private Hashtable setDataForExport(String[] fields, String[] keys, IRowSet rs, Context ctx) throws SQLException, TaskExternalException {
        int i;
        if (fields.length != keys.length) {
            throw new IllegalArgumentException("field length not match key length :" + fields.length + " " + keys.length);
        }
        Hashtable<String, String> result = new Hashtable<String, String>();
        HashMap<String, Integer> typeMap = new HashMap<String, Integer>();
        for (i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
            int columnType = rs.getMetaData().getColumnType(i);
            String columnName = rs.getMetaData().getColumnName(i);
            typeMap.put(columnName, new Integer(columnType));
        }
        for (i = 0; i < fields.length; ++i) {
            String field = fields[i];
            String key = keys[i];
            Object obj = rs.getObject(key);
            if (obj == null) continue;
            int type = (Integer)typeMap.get(key);
            if (type == 91 || type == 92 || type == 93) {
                Date date = rs.getDate(key);
                result.put(field, FaCatDataImport.dateToString(date, ctx));
                continue;
            }
            if (type == 3 || type == 2) {
                result.put(field, rs.getBigDecimal(key).toString());
                continue;
            }
            result.put(field, rs.getString(key));
        }
        return result;
    }

    private static String dateToString(java.util.Date date, Context ctx) throws TaskExternalException {
        if (date == null) {
            return null;
        }
        try {
            return FaLocalUtils.formatDate((Context)ctx, (java.util.Date)date);
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private static boolean getBooleanValue(Context ctx, String value) {
        if (value == null || value.toString().trim().length() == 0) {
            return false;
        }
        return !value.equalsIgnoreCase("N") && !value.equalsIgnoreCase("NO") && !value.equalsIgnoreCase("0") && !value.equalsIgnoreCase(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.BASEDATAAutoGenerateResource", (String)"4_FaCatDataImport", (Locale)ctx.getOriginLocale()));
    }
}

