/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.dbclean.app;

import com.kingdee.bos.sql.shell.KDConnection;
import com.kingdee.eas.base.dbclean.JZContext;
import com.kingdee.eas.base.dbclean.JZTaskException;
import com.kingdee.eas.base.dbclean.app.CodeJZTask;
import com.kingdee.eas.fi.fa.dbclean.app.FaUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class FaAccountBalanceTask
extends CodeJZTask {
    public boolean doTask(JZContext context) throws JZTaskException {
        KDConnection dbConn = context.getDbConn();
        String orgId = context.getOrgFId();
        int periodNumber = context.getPeriodNumber();
        String periodId = context.getPeriodFId();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        StringBuffer prePeriodSql = new StringBuffer();
        prePeriodSql.append(" select top 1 FID,FNumber from t_bd_period where ftypeid in ( ");
        prePeriodSql.append(" select ftypeid from t_bd_period where fid = ? ) ");
        prePeriodSql.append(" and fnumber < ? order by fnumber desc ");
        try {
            if (!FaUtils.checkBeforeTask(dbConn, context)) {
                String msg = "\u7ec4\u7ec7" + context.getOrgNumber() + "\u672a\u542f\u7528\u56fa\u5b9a\u8d44\u4ea7\u6a21\u5757\uff0c\u76f4\u63a5\u8bbe\u7f6e\u7ed3\u8f6c\u4efb\u52a1\u6210\u529f\uff01";
                throw new JZTaskException(msg, 4);
            }
            pstmt = dbConn.prepareStatement(prePeriodSql.toString());
            pstmt.clearParameters();
            pstmt.setString(1, periodId);
            pstmt.setInt(2, periodNumber);
            rs = pstmt.executeQuery();
            int prePeriodNumber = 0;
            prePeriodNumber = rs.next() ? rs.getInt("FNumber") : periodNumber;
            StringBuffer sltBillIdSql = new StringBuffer();
            sltBillIdSql.append(" select bill.fid from t_fa_faaccountbalance bill ");
            sltBillIdSql.append(" inner join t_bd_period pd on pd.fid = bill.fperiodid ");
            sltBillIdSql.append(" where bill.fcompanyorgunitid = ? ");
            sltBillIdSql.append(" and pd.fnumber < ? ");
            StringBuffer deleteBillSql = new StringBuffer();
            deleteBillSql.append(" delete from t_fa_faaccountbalance where fid in (");
            deleteBillSql.append(sltBillIdSql.toString());
            deleteBillSql.append(") ");
            FaUtils.getLoggerOnTaskBegin(context, "\u4f59\u989d\u8868");
            context.getLogger().println("~~~~\u5220\u9664\u7ec4\u7ec7" + context.getOrgNumber() + " \u671f\u95f4 " + prePeriodNumber + " \u4e4b\u524d\u7684\u4f59\u989d\u6570\u636e~~~~");
            pstmt = dbConn.prepareStatement(deleteBillSql.toString());
            pstmt.clearParameters();
            pstmt.setString(1, orgId);
            pstmt.setInt(2, prePeriodNumber);
            pstmt.execute();
            FaUtils.getLoggerOnTaskEnd(context, "\u4f59\u989d\u8868");
        }
        catch (SQLException e) {
            try {
                FaUtils.getLoggerOnTaskError(context, "\u4f59\u989d\u8868");
                throw new JZTaskException(e.getMessage(), 2);
            }
            catch (Throwable throwable) {
                JZContext.closeResultSet(rs);
                JZContext.closeStatment(pstmt);
                throw throwable;
            }
        }
        JZContext.closeResultSet((ResultSet)rs);
        JZContext.closeStatment((Statement)pstmt);
        return true;
    }
}

