/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.dbclean.app;

import com.kingdee.bos.sql.shell.KDConnection;
import com.kingdee.eas.base.dbclean.JZContext;
import com.kingdee.eas.base.dbclean.JZTaskException;
import com.kingdee.eas.base.dbclean.app.CodeJZTask;
import com.kingdee.eas.fi.fa.dbclean.app.FaUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class FaMonCardTask
extends CodeJZTask {
    public boolean doTask(JZContext context) throws JZTaskException {
        KDConnection dbConn = context.getDbConn();
        String orgId = context.getOrgFId();
        String periodId = context.getPeriodFId();
        int period = context.getPeriodNumber();
        int periodNumber = context.getPeriod();
        int periodYear = context.getYear();
        PreparedStatement pstmt = null;
        PreparedStatement updateInitPst = null;
        ResultSet rs = null;
        ResultSet rSet = null;
        try {
            dbConn.setAutoCommit(false);
            if (!FaUtils.checkBeforeTask(dbConn, context)) {
                String msg = "\u7ec4\u7ec7" + context.getOrgNumber() + "\u672a\u542f\u7528\u56fa\u5b9a\u8d44\u4ea7\u6a21\u5757\uff0c\u76f4\u63a5\u8bbe\u7f6e\u7ed3\u8f6c\u4efb\u52a1\u6210\u529f\uff01";
                throw new JZTaskException(msg, 4);
            }
            FaUtils.getLoggerOnTaskBegin(context, "\u6bcf\u671f\u5361\u7247");
            StringBuffer prePeriodSql = new StringBuffer();
            prePeriodSql.append(" select top 1 FID,FNumber from t_bd_period where ftypeid in ( ");
            prePeriodSql.append(" select ftypeid from t_bd_period where fid = ? ) ");
            prePeriodSql.append(" and fnumber < ? order by fnumber desc ");
            pstmt = dbConn.prepareStatement(prePeriodSql.toString());
            pstmt.clearParameters();
            pstmt.setString(1, periodId);
            pstmt.setInt(2, period);
            rs = pstmt.executeQuery();
            int prePeriod = 0;
            String prePeriodId = "";
            if (!rs.next()) {
                String msg = "\u65e0\u6cd5\u83b7\u53d6\u7ed3\u8f6c\u671f\u95f4\u7684\u524d\u4e00\u671f\u95f4\uff0c\u65e0\u6cd5\u8fdb\u884c\u56fa\u5b9a\u8d44\u4ea7\u5e10\u5957\u7ed3\u8d26\uff01\u8bf7\u68c0\u67e5\u7ec4\u7ec7" + orgId + "\u7684\u7ed3\u8f6c\u671f\u95f4\u3002";
                throw new JZTaskException(msg, 5);
            }
            prePeriod = rs.getInt("FNumber");
            prePeriodId = rs.getString("FID");
            context.getLogger().println("monCard-\u7ed3\u8f6c\u671f\u95f4\u7684\u524d\u4e00\u671f\u95f4\u4e3a" + prePeriod);
            this.dltInitData(context, dbConn, orgId);
            if (prePeriodId == null || "".equals(prePeriodId)) {
                context.getLogger().println("monCard-\u7ed3\u8f6c\u671f\u95f4\u7684\u524d\u4e00\u671f\u95f4\u4e3a" + prePeriodId);
                dbConn.rollback();
                throw new JZTaskException("\u7ed3\u8f6c\u524d\u4e00\u671f\u95f4\u6709\u95ee\u9898\uff0c\u8bf7\u6838\u5bf9\u540e\u518d\u7ee7\u7eed\u7ed3\u8f6c\uff01", 5);
            }
            this.dltBeforeJZPeriod(context, dbConn, prePeriodId, orgId, prePeriod);
            this.dltDeletedStatusCards(context, dbConn, orgId, prePeriodId);
            context.getLogger().println("monCard-\u628a\u7ed3\u8f6c\u524d\u4e00\u671f\u6bcf\u671f\u5361\u7247\u5904\u7406\u4e3a\u521d\u59cb\u5316\u5361\u7247");
            String updateInitSql = " update t_fa_famoncard set fdeprtterm=0,fmonthdeprerate=0,ffivouchered=1, fsourcebillid=null, foriginflag=0, fbizstatus = '9999' , ffaperiodid=null, fperiodid=null, flastbillid=null where fcompanyid = ? and ffaperiodid = ? ";
            updateInitPst = dbConn.prepareStatement(updateInitSql);
            updateInitPst.setString(1, orgId);
            updateInitPst.setString(2, prePeriodId);
            updateInitPst.executeUpdate();
            dbConn.commit();
            if (periodNumber == 1) {
                StringBuffer initdataInsertSql = new StringBuffer();
                initdataInsertSql.append(" insert into t_fa_famoninitdata (fid,foriginbeginqty,foriginincqty,forigindecqty,fdeprbeginqty,fdeprincqty,fdeprdecqty,");
                initdataInsertSql.append(" fdecvaluebeginqty,fdecvalueincqty,fdecvaluedecqty,fassetamtbeginqty,fassetamtincqty,fassetamtdecqty,ffamoncardid) ");
                initdataInsertSql.append(" select newbosid('13A84A82') as fid,mon.FAssetValue,0,0,mon.FAccuDepr,0,0,mon.FDecValue,0,0,mon.FAssetAmt,0,0,mon.fid");
                initdataInsertSql.append(" from t_fa_famoncard mon where fcompanyid = ? ");
                initdataInsertSql.append(" and ffaperiodid is null and FLaterPeriodData = 0");
                pstmt = dbConn.prepareStatement(initdataInsertSql.toString());
                pstmt.clearParameters();
                pstmt.setString(1, orgId);
                pstmt.execute();
                String updateAccuDeprTYearSql = "update t_fa_famoncard set FAccuDeprTYear = 0 where fcompanyid = ? and ffaperiodid is null and FLaterPeriodData = 0 ";
                pstmt = dbConn.prepareStatement(updateAccuDeprTYearSql);
                pstmt.clearParameters();
                pstmt.setString(1, orgId);
                pstmt.execute();
            } else {
                int firstPeriodOfYear = periodYear * 100 + 1;
                int startPeriod = 0;
                StringBuffer startPeriodSql = new StringBuffer();
                startPeriodSql.append(" select FNumber from T_BD_SystemStatusCtrol sysStaCtr,T_BD_SystemStatus sysSta,T_BD_PERIOD pd ");
                startPeriodSql.append(" where sysStaCtr.FSystemStatusID=sysSta.FID ");
                startPeriodSql.append(" and sysStaCtr.FSTARTPERIODID=pd.FID ");
                startPeriodSql.append(" and sysStaCtr.FCompanyID = ? ");
                startPeriodSql.append(" and sysSta.FName=14");
                pstmt = dbConn.prepareStatement(startPeriodSql.toString());
                pstmt.clearParameters();
                pstmt.setString(1, orgId);
                rSet = pstmt.executeQuery();
                if (!rSet.next()) {
                    String msg = "\u7ec4\u7ec7" + orgId + "\u751f\u6210\u5e74\u6570\u6570\u636e\u65f6\uff0c\u83b7\u53d6\u4e0d\u5230\u8be5\u7ec4\u7ec7\u542f\u7528\u671f\u95f4\uff01";
                    throw new JZTaskException(msg, 5);
                }
                startPeriod = rSet.getInt("FNumber");
                if (startPeriod <= firstPeriodOfYear) {
                    StringBuffer initNotFstInsertSql = new StringBuffer();
                    initNotFstInsertSql.append(" insert into t_fa_famoninitdata (fid,foriginbeginqty,foriginincqty,forigindecqty,fdeprbeginqty,fdeprincqty,fdeprdecqty,");
                    initNotFstInsertSql.append(" fdecvaluebeginqty,fdecvalueincqty,fdecvaluedecqty,fassetamtbeginqty,fassetamtincqty,fassetamtdecqty,ffamoncardid) ");
                    initNotFstInsertSql.append(" select newbosid('13A84A82') as fid,(case when balinit.frealbeginbalancefor is null then 0 else balinit.frealbeginbalancefor end),");
                    initNotFstInsertSql.append(" balance.frealdebitfor,balance.frealcreditfor,(case when balinit.fdeprebeginbalancefor is null then 0 else balinit.fdeprebeginbalancefor end),");
                    initNotFstInsertSql.append(" balance.fdeprecreditfor,balance.fdepredebitfor,(case when balinit.fdecvaluebeginbalancefor is null then 0 else balinit.fdecvaluebeginbalancefor end),");
                    initNotFstInsertSql.append(" balance.fdecvaluedebitfor,balance.fdecvaluecreditfor,(case when balinit.fassetamt is null then 0 else balinit.fassetamt end),");
                    initNotFstInsertSql.append(" 0,0,balinit.ffamoncardid from ");
                    initNotFstInsertSql.append(" (select acc.frealbeginbalancefor,acc.fdeprebeginbalancefor,acc.fdecvaluebeginbalancefor,acc.ffacurcardid,acc.fperiodid,mon.fid as ffamoncardid,mon.fassetamt as fassetamt from t_fa_faaccountbalance acc ");
                    initNotFstInsertSql.append(" inner join t_bd_period pd on pd.fid = acc.fperiodid ");
                    initNotFstInsertSql.append(" inner join t_fa_famoncard mon on mon.ffacurcardid = acc.ffacurcardid ");
                    initNotFstInsertSql.append(" where mon.fcompanyid = ? ");
                    initNotFstInsertSql.append(" and mon.ffaperiodid is null and mon.FLaterPeriodData = 0 and pd.fnumber = ? ) balinit ");
                    initNotFstInsertSql.append(" inner join (select sum(acc.frealdebitfor) as frealdebitfor,sum(acc.frealcreditfor) as frealcreditfor,sum(acc.fdepredebitfor) as fdepredebitfor,");
                    initNotFstInsertSql.append(" sum(acc.fdeprecreditfor) as fdeprecreditfor,sum(acc.fdecvaluedebitfor) as fdecvaluedebitfor,sum(acc.fdecvaluecreditfor) as fdecvaluecreditfor,acc.ffacurcardid ");
                    initNotFstInsertSql.append(" from t_fa_faaccountbalance acc inner join t_bd_period pd on pd.fid = acc.fperiodid where acc.ffacurcardid in (");
                    initNotFstInsertSql.append(" select ffacurcardid from t_fa_famoncard mon where mon.fcompanyid = ? ");
                    initNotFstInsertSql.append(" and mon.ffaperiodid is null and mon.FLaterPeriodData = 0) and pd.fnumber >= ? and pd.fnumber < ? ");
                    initNotFstInsertSql.append(" group by acc.ffacurcardid) balance on balinit.ffacurcardid = balance.ffacurcardid ");
                    pstmt = dbConn.prepareStatement(initNotFstInsertSql.toString());
                    pstmt.clearParameters();
                    pstmt.setString(1, orgId);
                    pstmt.setInt(2, firstPeriodOfYear);
                    pstmt.setString(3, orgId);
                    pstmt.setInt(4, firstPeriodOfYear);
                    pstmt.setInt(5, period);
                    pstmt.execute();
                    StringBuffer initNotFInsertSql = new StringBuffer();
                    initNotFInsertSql.append(" insert into t_fa_famoninitdata (fid,foriginbeginqty,foriginincqty,forigindecqty,fdeprbeginqty,fdeprincqty,fdeprdecqty,");
                    initNotFInsertSql.append(" fdecvaluebeginqty,fdecvalueincqty,fdecvaluedecqty,fassetamtbeginqty,fassetamtincqty,fassetamtdecqty,ffamoncardid) ");
                    initNotFInsertSql.append(" select newbosid('13A84A82') as fid,(case when balinit.frealbeginbalancefor is null then 0 else balinit.frealbeginbalancefor end),");
                    initNotFInsertSql.append(" balance.frealdebitfor,balance.frealcreditfor,(case when balinit.fdeprebeginbalancefor is null then 0 else balinit.fdeprebeginbalancefor end),");
                    initNotFInsertSql.append(" balance.fdeprecreditfor,balance.fdepredebitfor,(case when balinit.fdecvaluebeginbalancefor is null then 0 else balinit.fdecvaluebeginbalancefor end),");
                    initNotFInsertSql.append(" balance.fdecvaluedebitfor,balance.fdecvaluecreditfor,(case when balinit.fassetamt is null then 0 else balinit.fassetamt end),");
                    initNotFInsertSql.append(" 0,0,balinit.ffamoncardid from ");
                    initNotFInsertSql.append(" (select acc.frealbeginbalancefor,acc.fdeprebeginbalancefor,acc.fdecvaluebeginbalancefor,acc.ffacurcardid,acc.fperiodid,mon.fid as ffamoncardid,mon.fassetamt as fassetamt from t_fa_faaccountbalance acc ");
                    initNotFInsertSql.append(" inner join t_bd_period pd on pd.fid = acc.fperiodid ");
                    initNotFInsertSql.append(" inner join t_fa_famoncard mon on mon.ffacurcardid = acc.ffacurcardid ");
                    initNotFInsertSql.append(" where mon.fcompanyid = ? ");
                    initNotFInsertSql.append(" and mon.ffaperiodid is null and mon.FLaterPeriodData = 0 and pd.fnumber > ? and acc.frealbeginbalancefor = 0) balinit ");
                    initNotFInsertSql.append(" inner join (select sum(acc.frealdebitfor) as frealdebitfor,sum(acc.frealcreditfor) as frealcreditfor,sum(acc.fdepredebitfor) as fdepredebitfor,");
                    initNotFInsertSql.append(" sum(acc.fdeprecreditfor) as fdeprecreditfor,sum(acc.fdecvaluedebitfor) as fdecvaluedebitfor,sum(acc.fdecvaluecreditfor) as fdecvaluecreditfor,acc.ffacurcardid ");
                    initNotFInsertSql.append(" from t_fa_faaccountbalance acc inner join t_bd_period pd on pd.fid = acc.fperiodid where acc.ffacurcardid in (");
                    initNotFInsertSql.append(" select ffacurcardid from t_fa_famoncard mon where mon.fcompanyid = ? ");
                    initNotFInsertSql.append(" and mon.ffaperiodid is null and mon.FLaterPeriodData = 0) and pd.fnumber >= ? and pd.fnumber < ? ");
                    initNotFInsertSql.append(" group by acc.ffacurcardid) balance on balinit.ffacurcardid = balance.ffacurcardid ");
                    pstmt = dbConn.prepareStatement(initNotFInsertSql.toString());
                    pstmt.clearParameters();
                    pstmt.setString(1, orgId);
                    pstmt.setInt(2, firstPeriodOfYear);
                    pstmt.setString(3, orgId);
                    pstmt.setInt(4, firstPeriodOfYear);
                    pstmt.setInt(5, period);
                    pstmt.execute();
                } else {
                    StringBuffer initOtherInsertSql = new StringBuffer();
                    initOtherInsertSql.append(" insert into t_fa_famoninitdata (fid,foriginbeginqty,foriginincqty,forigindecqty,fdeprbeginqty,fdeprincqty,fdeprdecqty,");
                    initOtherInsertSql.append(" fdecvaluebeginqty,fdecvalueincqty,fdecvaluedecqty,fassetamtbeginqty,fassetamtincqty,fassetamtdecqty,ffamoncardid) ");
                    initOtherInsertSql.append(" select newbosid('13A84A82') as fid,0,balance.frealdebitfor+balinit.frealbeginbalancefor,balance.frealcreditfor,0,balance.fdeprecreditfor+balinit.fdeprebeginbalancefor,balance.fdepredebitfor,0,");
                    initOtherInsertSql.append(" balance.fdecvaluedebitfor+balinit.fdecvaluebeginbalancefor,balance.fdecvaluecreditfor,0,balinit.fassetamt,0,balinit.ffamoncardid from ");
                    initOtherInsertSql.append(" (select acc.frealbeginbalancefor,acc.fdeprebeginbalancefor,acc.fdecvaluebeginbalancefor,acc.ffacurcardid,acc.fperiodid,mon.fid as ffamoncardid,mon.fassetamt as fassetamt from t_fa_faaccountbalance acc ");
                    initOtherInsertSql.append(" inner join t_bd_period pd on pd.fid = acc.fperiodid ");
                    initOtherInsertSql.append(" inner join t_fa_famoncard mon on mon.ffacurcardid = acc.ffacurcardid");
                    initOtherInsertSql.append(" where mon.fcompanyid = ? ");
                    initOtherInsertSql.append(" and mon.ffaperiodid is null and mon.FLaterPeriodData = 0 and pd.fnumber = ? ) balinit ");
                    initOtherInsertSql.append(" inner join (select sum(acc.frealdebitfor) as frealdebitfor,sum(acc.frealcreditfor) as frealcreditfor,sum(acc.fdepredebitfor) as fdepredebitfor,");
                    initOtherInsertSql.append(" sum(acc.fdeprecreditfor) as fdeprecreditfor,sum(acc.fdecvaluedebitfor) as fdecvaluedebitfor,sum(acc.fdecvaluecreditfor) as fdecvaluecreditfor,acc.ffacurcardid ");
                    initOtherInsertSql.append(" from t_fa_faaccountbalance acc inner join t_bd_period pd on pd.fid = acc.fperiodid where acc.ffacurcardid in (");
                    initOtherInsertSql.append(" select ffacurcardid from t_fa_famoncard mon where mon.fcompanyid = ? ");
                    initOtherInsertSql.append(" and mon.ffaperiodid is null and mon.FLaterPeriodData = 0) and pd.fnumber >= ? and pd.fnumber < ? ");
                    initOtherInsertSql.append(" group by acc.ffacurcardid) balance on balinit.ffacurcardid = balance.ffacurcardid ");
                    pstmt = dbConn.prepareStatement(initOtherInsertSql.toString());
                    pstmt.clearParameters();
                    pstmt.setString(1, orgId);
                    pstmt.setInt(2, startPeriod);
                    pstmt.setString(3, orgId);
                    pstmt.setInt(4, startPeriod);
                    pstmt.setInt(5, period);
                    pstmt.execute();
                    StringBuffer initOtherTwoInsertSql = new StringBuffer();
                    initOtherTwoInsertSql.append(" insert into t_fa_famoninitdata (fid,foriginbeginqty,foriginincqty,forigindecqty,fdeprbeginqty,fdeprincqty,fdeprdecqty,");
                    initOtherTwoInsertSql.append(" fdecvaluebeginqty,fdecvalueincqty,fdecvaluedecqty,fassetamtbeginqty,fassetamtincqty,fassetamtdecqty,ffamoncardid) ");
                    initOtherTwoInsertSql.append(" select newbosid('13A84A82') as fid,0,balance.frealdebitfor+balinit.frealbeginbalancefor,balance.frealcreditfor,0,balance.fdeprecreditfor+balinit.fdeprebeginbalancefor,balance.fdepredebitfor,0,");
                    initOtherTwoInsertSql.append(" balance.fdecvaluedebitfor+balinit.fdecvaluebeginbalancefor,balance.fdecvaluecreditfor,0,balinit.fassetamt,0,balinit.ffamoncardid from ");
                    initOtherTwoInsertSql.append(" (select acc.frealbeginbalancefor,acc.fdeprebeginbalancefor,acc.fdecvaluebeginbalancefor,acc.ffacurcardid,acc.fperiodid,mon.fid as ffamoncardid,mon.fassetamt as fassetamt from t_fa_faaccountbalance acc ");
                    initOtherTwoInsertSql.append(" inner join t_bd_period pd on pd.fid = acc.fperiodid ");
                    initOtherTwoInsertSql.append(" inner join t_fa_famoncard mon on mon.ffacurcardid = acc.ffacurcardid");
                    initOtherTwoInsertSql.append(" where mon.fcompanyid = ? ");
                    initOtherTwoInsertSql.append(" and mon.ffaperiodid is null and mon.FLaterPeriodData = 0 and pd.fnumber > ? and acc.frealbeginbalancefor = 0) balinit ");
                    initOtherTwoInsertSql.append(" inner join (select sum(acc.frealdebitfor) as frealdebitfor,sum(acc.frealcreditfor) as frealcreditfor,sum(acc.fdepredebitfor) as fdepredebitfor,");
                    initOtherTwoInsertSql.append(" sum(acc.fdeprecreditfor) as fdeprecreditfor,sum(acc.fdecvaluedebitfor) as fdecvaluedebitfor,sum(acc.fdecvaluecreditfor) as fdecvaluecreditfor,acc.ffacurcardid ");
                    initOtherTwoInsertSql.append(" from t_fa_faaccountbalance acc inner join t_bd_period pd on pd.fid = acc.fperiodid where acc.ffacurcardid in (");
                    initOtherTwoInsertSql.append(" select ffacurcardid from t_fa_famoncard mon where mon.fcompanyid = ? ");
                    initOtherTwoInsertSql.append(" and mon.ffaperiodid is null and mon.FLaterPeriodData = 0) and pd.fnumber >= ? and pd.fnumber < ? ");
                    initOtherTwoInsertSql.append(" group by acc.ffacurcardid) balance on balinit.ffacurcardid = balance.ffacurcardid ");
                    pstmt = dbConn.prepareStatement(initOtherTwoInsertSql.toString());
                    pstmt.clearParameters();
                    pstmt.setString(1, orgId);
                    pstmt.setInt(2, startPeriod);
                    pstmt.setString(3, orgId);
                    pstmt.setInt(4, startPeriod);
                    pstmt.setInt(5, period);
                    pstmt.execute();
                    StringBuffer updateIncQtySql = new StringBuffer();
                    updateIncQtySql.append(" update t_fa_famoninitdata set fassetamtincqty = (select mon.fassetamt from t_fa_famoncard mon ");
                    updateIncQtySql.append(" where mon.fid = t_fa_famoninitdata.ffamoncardid) ");
                    updateIncQtySql.append(" where ffamoncardid in (");
                    updateIncQtySql.append(" select mon.fid from t_fa_famoncard mon ");
                    updateIncQtySql.append(" inner join t_fa_famoninitdata initdata on initdata.ffamoncardid = mon.fid ");
                    updateIncQtySql.append(" where mon.fcompanyid = ? and mon.ffaperiodid is null ");
                    updateIncQtySql.append(" and mon.FLaterPeriodData = 0 and initdata.fassetamtincqty < mon.fassetamt) ");
                    pstmt = dbConn.prepareStatement(updateIncQtySql.toString());
                    pstmt.clearParameters();
                    pstmt.setString(1, orgId);
                    pstmt.execute();
                    StringBuffer updateDecQtySql = new StringBuffer();
                    updateDecQtySql.append(" update t_fa_famoninitdata set fassetamtdecqty = (select fassetamtincqty-mon.fassetamt from t_fa_famoncard mon ");
                    updateDecQtySql.append(" where mon.fid = t_fa_famoninitdata.ffamoncardid) ");
                    updateDecQtySql.append(" where ffamoncardid in (");
                    updateDecQtySql.append(" select mon.fid from t_fa_famoncard mon ");
                    updateDecQtySql.append(" inner join t_fa_famoninitdata initdata on initdata.ffamoncardid = mon.fid ");
                    updateDecQtySql.append(" where mon.fcompanyid = ? and mon.ffaperiodid is null ");
                    updateDecQtySql.append(" and mon.FLaterPeriodData = 0 and initdata.fassetamtincqty > mon.fassetamt) ");
                    pstmt = dbConn.prepareStatement(updateDecQtySql.toString());
                    pstmt.clearParameters();
                    pstmt.setString(1, orgId);
                    pstmt.execute();
                }
            }
            StringBuffer initdataAllInsertSql = new StringBuffer();
            initdataAllInsertSql.append(" insert into t_fa_famoninitdata (fid,foriginbeginqty,foriginincqty,forigindecqty,fdeprbeginqty,fdeprincqty,fdeprdecqty,");
            initdataAllInsertSql.append(" fdecvaluebeginqty,fdecvalueincqty,fdecvaluedecqty,fassetamtbeginqty,fassetamtincqty,fassetamtdecqty,ffamoncardid) ");
            initdataAllInsertSql.append(" select newbosid('13A84A82') as fid,initdata.foriginbeginqty,initdata.foriginincqty,initdata.forigindecqty,initdata.fdeprbeginqty,initdata.fdeprincqty,initdata.fdeprdecqty,");
            initdataAllInsertSql.append(" initdata.fdecvaluebeginqty,initdata.fdecvalueincqty,initdata.fdecvaluedecqty,initdata.fassetamtbeginqty,initdata.fassetamtincqty,initdata.fassetamtdecqty,initdata.ffamoncardid from ");
            initdataAllInsertSql.append(" (select init.fid,init.foriginbeginqty,init.foriginincqty,init.forigindecqty,init.fdeprbeginqty,init.fdeprincqty,init.fdeprdecqty,");
            initdataAllInsertSql.append(" init.fdecvaluebeginqty,init.fdecvalueincqty,init.fdecvaluedecqty,init.fassetamtbeginqty,init.fassetamtincqty,init.fassetamtdecqty,init.ffamoncardid,mon.ffacurcardid ");
            initdataAllInsertSql.append(" from t_fa_famoninitdata init,t_fa_famoncard mon where init.ffamoncardid = mon.fid and mon.fcompanyid = ? ");
            initdataAllInsertSql.append(" and mon.ffaperiodid is null and mon.FLaterPeriodData = 0) initdata ");
            initdataAllInsertSql.append(" inner join t_fa_famoncard moncard on initdata.ffacurcardid = moncard.ffacurcardid ");
            initdataAllInsertSql.append(" where moncard.fcompanyid = ? and moncard.ffaperiodid is not null ");
            pstmt = dbConn.prepareStatement(initdataAllInsertSql.toString());
            pstmt.clearParameters();
            pstmt.setString(1, orgId);
            pstmt.setString(2, orgId);
            pstmt.execute();
            StringBuffer updateCurCardPeriod = new StringBuffer();
            updateCurCardPeriod.append(" update t_fa_facurcard set fperiodid = ? ");
            updateCurCardPeriod.append("where fid in (");
            updateCurCardPeriod.append("select ffacurcardid from t_fa_famoncard where fcompanyid = ? ");
            updateCurCardPeriod.append("and ffaperiodid is null and FLaterPeriodData = 0) ");
            pstmt = dbConn.prepareStatement(updateCurCardPeriod.toString());
            pstmt.clearParameters();
            pstmt.setString(1, periodId);
            pstmt.setString(2, orgId);
            pstmt.execute();
            StringBuffer updateMonCardPeriod = new StringBuffer();
            updateMonCardPeriod.append(" update t_fa_famoncard set fperiodid = ? ");
            updateMonCardPeriod.append("where ffacurcardid in (");
            updateMonCardPeriod.append("select ffacurcardid from t_fa_famoncard where fcompanyid = ? ");
            updateMonCardPeriod.append("and ffaperiodid is null and FLaterPeriodData = 0) ");
            updateMonCardPeriod.append("and fperiodid is not null ");
            pstmt = dbConn.prepareStatement(updateCurCardPeriod.toString());
            pstmt.clearParameters();
            pstmt.setString(1, periodId);
            pstmt.setString(2, orgId);
            pstmt.execute();
            dbConn.commit();
            FaUtils.getLoggerOnTaskEnd(context, "\u6bcf\u671f\u5361\u7247");
        }
        catch (SQLException e) {
            try {
                FaUtils.getLoggerOnTaskError(context, "\u6bcf\u671f\u5361\u7247");
                throw new JZTaskException(e.getMessage(), 5);
            }
            catch (Throwable throwable) {
                JZContext.closeResultSet(rs);
                JZContext.closeResultSet(rSet);
                JZContext.closeStatment(pstmt);
                JZContext.closeStatment(updateInitPst);
                throw throwable;
            }
        }
        JZContext.closeResultSet((ResultSet)rs);
        JZContext.closeResultSet((ResultSet)rSet);
        JZContext.closeStatment((Statement)pstmt);
        JZContext.closeStatment((Statement)updateInitPst);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dltInitData(JZContext context, KDConnection dbConn, String orgId) throws JZTaskException {
        context.getLogger().println("monCard-\u5220\u9664\u7ed3\u8f6c\u524d\u7684\u521d\u59cb\u5316\u5361\u7247");
        PreparedStatement delInitDptPst = null;
        PreparedStatement delInitFacPst = null;
        PreparedStatement delInitDataPst = null;
        PreparedStatement delInitAsstPst = null;
        PreparedStatement delInitCostPst = null;
        PreparedStatement pst = null;
        try {
            String delInitDptSql = " delete from t_fa_famondepartment where ffamoncardid in (select fid from t_fa_famoncard where fcompanyid = ? and ffaperiodid is null and FLaterPeriodData = 0) ";
            delInitDptPst = dbConn.prepareStatement(delInitDptSql);
            delInitDptPst.setString(1, orgId);
            delInitDptPst.execute();
            String delInitFacSql = " delete from t_fa_famonfacility where ffamoncardid in (select fid from t_fa_famoncard where fcompanyid = ? and ffaperiodid is null and FLaterPeriodData = 0) ";
            delInitFacPst = dbConn.prepareStatement(delInitFacSql);
            delInitFacPst.setString(1, orgId);
            delInitFacPst.execute();
            String delInitDataSql = " delete from t_fa_famoninitdata where ffamoncardid in (select fid from t_fa_famoncard where fcompanyid = ? )";
            delInitDataPst = dbConn.prepareStatement(delInitDataSql);
            delInitDataPst.setString(1, orgId);
            delInitDataPst.execute();
            String delInitAsstSql = " delete from T_FA_FaMonAsstActComposit where FFaMonCostCenterID in (select fid from t_fa_famoncostcenter where ffamoncardid in (select fid from t_fa_famoncard where fcompanyid = ? and ffaperiodid is null and FLaterPeriodData = 0)) ";
            delInitAsstPst = dbConn.prepareStatement(delInitAsstSql);
            delInitAsstPst.setString(1, orgId);
            delInitAsstPst.execute();
            String delInitCostSql = " delete from t_fa_famoncostcenter where ffamoncardid in (select fid from t_fa_famoncard where fcompanyid = ? and ffaperiodid is null and FLaterPeriodData = 0) ";
            delInitCostPst = dbConn.prepareStatement(delInitCostSql);
            delInitCostPst.setString(1, orgId);
            delInitCostPst.execute();
            String deleteInitSql = " delete from t_fa_famoncard where fcompanyid = ? and ffaperiodid is null and FLaterPeriodData = 0 ";
            pst = dbConn.prepareStatement(deleteInitSql);
            pst.setString(1, orgId);
            pst.execute();
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                JZContext.closeStatment(delInitDptPst);
                JZContext.closeStatment(delInitFacPst);
                JZContext.closeStatment(delInitDataPst);
                JZContext.closeStatment(delInitAsstPst);
                JZContext.closeStatment(delInitCostPst);
                JZContext.closeStatment(pst);
                throw throwable;
            }
            JZContext.closeStatment((Statement)delInitDptPst);
            JZContext.closeStatment(delInitFacPst);
            JZContext.closeStatment(delInitDataPst);
            JZContext.closeStatment(delInitAsstPst);
            JZContext.closeStatment(delInitCostPst);
            JZContext.closeStatment(pst);
        }
        JZContext.closeStatment((Statement)delInitDptPst);
        JZContext.closeStatment((Statement)delInitFacPst);
        JZContext.closeStatment((Statement)delInitDataPst);
        JZContext.closeStatment((Statement)delInitAsstPst);
        JZContext.closeStatment((Statement)delInitCostPst);
        JZContext.closeStatment((Statement)pst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dltBeforeJZPeriod(JZContext context, KDConnection dbConn, String prePeriodId, String orgId, int prePeriod) throws JZTaskException {
        block5: {
            context.getLogger().println("monCard-\u5220\u9664\u7ed3\u8f6c\u671f\u95f4\u524d\u4e00\u671f\u95f4\u4e4b\u524d\u7684\u6240\u6709\u671f\u95f4\u7684\u6bcf\u671f\u5361\u7247\u6570\u636e");
            PreparedStatement delPreDptPst = null;
            PreparedStatement delPreFacPst = null;
            PreparedStatement delPreDataPst = null;
            PreparedStatement delPreAsstPst = null;
            PreparedStatement delPreCostPst = null;
            PreparedStatement pst = null;
            try {
                StringBuffer selMonCardIdSql = new StringBuffer();
                selMonCardIdSql.append(" select fid from t_fa_famoncard where fcompanyid = ? ");
                selMonCardIdSql.append(" and ffaperiodid in ( select fid from t_bd_period where ftypeid = (");
                selMonCardIdSql.append(" select ftypeid from t_bd_period where fid = ? ");
                selMonCardIdSql.append("and fnumber < ? ) ");
                StringBuffer deletePreDptSql = new StringBuffer();
                deletePreDptSql.append(" delete from t_fa_famondepartment where ffamoncardid in (");
                deletePreDptSql.append(selMonCardIdSql.toString());
                deletePreDptSql.append(") ");
                delPreDptPst = dbConn.prepareStatement(deletePreDptSql.toString());
                delPreDptPst.setString(1, orgId);
                delPreDptPst.setString(2, prePeriodId);
                delPreDptPst.setInt(3, prePeriod);
                delPreDptPst.execute();
                StringBuffer deletePreFacSql = new StringBuffer();
                deletePreFacSql.append(" delete from t_fa_famonfacility where ffamoncardid in (");
                deletePreFacSql.append(selMonCardIdSql.toString());
                deletePreFacSql.append(") ");
                delPreFacPst = dbConn.prepareStatement(deletePreFacSql.toString());
                delPreFacPst.setString(1, orgId);
                delPreFacPst.setString(2, prePeriodId);
                delPreFacPst.setInt(3, prePeriod);
                delPreFacPst.execute();
                StringBuffer deletePreDataSql = new StringBuffer();
                deletePreDataSql.append(" delete from t_fa_famoninitdata where ffamoncardid in (");
                deletePreDataSql.append(selMonCardIdSql.toString());
                deletePreDataSql.append(") ");
                delPreDataPst = dbConn.prepareStatement(deletePreDataSql.toString());
                delPreDataPst.setString(1, orgId);
                delPreDataPst.setString(2, prePeriodId);
                delPreDataPst.setInt(3, prePeriod);
                delPreDataPst.execute();
                StringBuffer deletePreAsstSql = new StringBuffer();
                deletePreAsstSql.append(" delete from T_FA_FaMonAsstActComposit where FFaMonCostCenterID in (");
                deletePreAsstSql.append(" select fid from t_fa_famoncostcenter where ffamoncardid in (");
                deletePreAsstSql.append(selMonCardIdSql.toString());
                deletePreAsstSql.append(")) ");
                delPreAsstPst = dbConn.prepareStatement(deletePreAsstSql.toString());
                delPreAsstPst.setString(1, orgId);
                delPreAsstPst.setString(2, prePeriodId);
                delPreAsstPst.setInt(3, prePeriod);
                delPreAsstPst.execute();
                StringBuffer deletePreCostSql = new StringBuffer();
                deletePreCostSql.append(" delete from t_fa_famoncostcenter where ffamoncardid in (");
                deletePreCostSql.append(selMonCardIdSql.toString());
                deletePreCostSql.append(") ");
                delPreCostPst = dbConn.prepareStatement(deletePreCostSql.toString());
                delPreCostPst.setString(1, orgId);
                delPreCostPst.setString(2, prePeriodId);
                delPreCostPst.setInt(3, prePeriod);
                delPreCostPst.execute();
                StringBuffer deletePreSql = new StringBuffer();
                deletePreSql.append(" delete from t_fa_famoncard where fid in (");
                deletePreSql.append(selMonCardIdSql.toString());
                deletePreSql.append(") ");
                pst = dbConn.prepareStatement(deletePreSql.toString());
                pst.setString(1, orgId);
                pst.setString(2, prePeriodId);
                pst.setInt(3, prePeriod);
                pst.execute();
                JZContext.closeStatment((Statement)delPreDptPst);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block5;
            }
            finally {
                JZContext.closeStatment(delPreDptPst);
                JZContext.closeStatment(delPreFacPst);
                JZContext.closeStatment(delPreDataPst);
                JZContext.closeStatment(delPreAsstPst);
                JZContext.closeStatment(delPreCostPst);
                JZContext.closeStatment(pst);
            }
            JZContext.closeStatment((Statement)delPreFacPst);
            JZContext.closeStatment((Statement)delPreDataPst);
            JZContext.closeStatment((Statement)delPreAsstPst);
            JZContext.closeStatment((Statement)delPreCostPst);
            JZContext.closeStatment((Statement)pst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dltDeletedStatusCards(JZContext context, KDConnection dbConn, String orgId, String prePeriodId) throws JZTaskException {
        context.getLogger().println("monCard-\u5220\u9664\u7ed3\u8f6c\u671f\u95f4\u524d\u4e00\u671f\u6708\u7ed3\u5361\u7247\u4e2d\u5df2\u7ecf\u62a5\u5e9f\u7684\u5361\u7247");
        PreparedStatement statusDptPst = null;
        PreparedStatement statusFacPst = null;
        PreparedStatement statusDataPst = null;
        PreparedStatement statusAsstPst = null;
        PreparedStatement statusCostPst = null;
        PreparedStatement statusPst = null;
        try {
            String deleteStatusDptSql = " delete from t_fa_famondepartment where ffamoncardid in (select fid from t_fa_famoncard where fcompanyid = ? and ffaperiodid = ? and FDeletedStatus = 2) ";
            statusDptPst = dbConn.prepareStatement(deleteStatusDptSql);
            statusDptPst.setString(1, orgId);
            statusDptPst.setString(2, prePeriodId);
            statusDptPst.execute();
            String deleteStatusFacSql = " delete from t_fa_famonfacility where ffamoncardid in (select fid from t_fa_famoncard where fcompanyid = ? and ffaperiodid = ? and FDeletedStatus = 2) ";
            statusFacPst = dbConn.prepareStatement(deleteStatusFacSql);
            statusFacPst.setString(1, orgId);
            statusFacPst.setString(2, prePeriodId);
            statusFacPst.execute();
            String deleteStatusDataSql = " delete from t_fa_famoninitdata where ffamoncardid in (select fid from t_fa_famoncard where fcompanyid = ? and ffaperiodid = ? and FDeletedStatus = 2) ";
            statusDataPst = dbConn.prepareStatement(deleteStatusDataSql);
            statusDataPst.setString(1, orgId);
            statusDataPst.setString(2, prePeriodId);
            statusDataPst.execute();
            String deleteStatusAsstSql = "delete from T_FA_FaMonAsstActComposit where FFaMonCostCenterID in (select fid from t_fa_famoncostcenter where ffamoncardid in (select fid from t_fa_famoncard where fcompanyid = ? and ffaperiodid = ? and FDeletedStatus = 2)) ";
            statusAsstPst = dbConn.prepareStatement(deleteStatusAsstSql);
            statusAsstPst.setString(1, orgId);
            statusAsstPst.setString(2, prePeriodId);
            statusAsstPst.execute();
            String deleteStatusCostSql = " delete from t_fa_famoncostcenter where ffamoncardid in (select fid from t_fa_famoncard where fcompanyid = ? and ffaperiodid = ? and FDeletedStatus = 2) ";
            statusCostPst = dbConn.prepareStatement(deleteStatusCostSql);
            statusCostPst.setString(1, orgId);
            statusCostPst.setString(2, prePeriodId);
            statusCostPst.execute();
            String deleteStatusSql = "delete from t_fa_famoncard where fcompanyid = ? and ffaperiodid = ? and FDeletedStatus = 2 ";
            statusPst = dbConn.prepareStatement(deleteStatusSql);
            statusPst.setString(1, orgId);
            statusPst.setString(2, prePeriodId);
            statusPst.execute();
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                JZContext.closeStatment(statusDptPst);
                JZContext.closeStatment(statusFacPst);
                JZContext.closeStatment(statusDataPst);
                JZContext.closeStatment(statusAsstPst);
                JZContext.closeStatment(statusCostPst);
                JZContext.closeStatment(statusPst);
                throw throwable;
            }
            JZContext.closeStatment((Statement)statusDptPst);
            JZContext.closeStatment(statusFacPst);
            JZContext.closeStatment(statusDataPst);
            JZContext.closeStatment(statusAsstPst);
            JZContext.closeStatment(statusCostPst);
            JZContext.closeStatment(statusPst);
        }
        JZContext.closeStatment((Statement)statusDptPst);
        JZContext.closeStatment((Statement)statusFacPst);
        JZContext.closeStatment((Statement)statusDataPst);
        JZContext.closeStatment((Statement)statusAsstPst);
        JZContext.closeStatment((Statement)statusCostPst);
        JZContext.closeStatment((Statement)statusPst);
    }
}

