/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage;

import com.kingdee.bos.Context;
import com.kingdee.bos.appframework.databinding.ComponentProperty;
import com.kingdee.bos.appframework.databinding.DataComponentMap;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.manage.IFaBillValidator;
import com.kingdee.eas.framework.BillBaseInfo;
import java.awt.Component;
import java.awt.Container;
import java.util.Locale;
import java.util.Map;
import javax.swing.JComponent;

abstract class AbstractFaBillValidatorImpl
implements IFaBillValidator {
    protected DataComponentMap componentMap;
    protected String invalidTarget;
    protected StringBuffer invalidMsg;
    protected boolean exitAnyError;
    protected Context ctx;
    protected BillBaseInfo billInfo;
    protected String bosType;
    protected Map params;
    protected Locale locale;
    private String resource = "com.kingdee.eas.fi.fa.manage.FaResource";

    public AbstractFaBillValidatorImpl(Context ctx, BillBaseInfo billInfo, boolean exitAnyError) {
        if (billInfo == null) {
            throw new IllegalArgumentException(EASResource.getString((String)this.resource, (String)"billInfoCantNull"));
        }
        if (ctx == null) {
            throw new IllegalArgumentException(EASResource.getString((String)this.resource, (String)"contextIsNull") + "(CoreBillBaseInfo billInfo, DataComponentMap componentMap, boolean exitAnyError)");
        }
        this.ctx = ctx;
        this.locale = ctx.getOriginLocale();
        this.billInfo = billInfo;
        this.bosType = billInfo.getBOSType().toString();
        this.exitAnyError = exitAnyError;
    }

    public AbstractFaBillValidatorImpl(BillBaseInfo billInfo, DataComponentMap componentMap, boolean exitAnyError) {
        if (billInfo == null) {
            throw new IllegalArgumentException(EASResource.getString((String)this.resource, (String)"billInfoCantNull"));
        }
        this.locale = SysContext.getSysContext().getOriginLocale();
        this.billInfo = billInfo;
        this.bosType = billInfo.getBOSType().toString();
        this.componentMap = componentMap;
        this.exitAnyError = exitAnyError;
    }

    @Override
    public JComponent getFocusComponent() {
        if (this.componentMap == null || this.invalidTarget == null) {
            return null;
        }
        ComponentProperty prop = this.componentMap.getComponentProperty(this.invalidTarget);
        JComponent component = (JComponent)(prop == null ? null : prop.getComponent());
        if (component != null) {
            Container tabbedPane;
            Container panel = null;
            for (tabbedPane = component.getParent(); tabbedPane != null && !(tabbedPane instanceof KDTabbedPane); tabbedPane = tabbedPane.getParent()) {
                panel = tabbedPane;
            }
            if (tabbedPane != null) {
                ((KDTabbedPane)tabbedPane).setSelectedComponent((Component)panel);
            }
        }
        return component;
    }

    @Override
    public String getInvalidMsg() {
        return this.invalidMsg == null ? null : this.invalidMsg.toString();
    }

    protected void appendInvalidMsg(String target, String message) {
        if (this.invalidMsg == null || this.invalidMsg.length() == 0) {
            this.invalidMsg = new StringBuffer();
            this.invalidMsg.append(message);
        } else {
            this.invalidMsg.append(message == null || message.length() == 0 ? "" : ";" + message);
        }
        if (this.invalidTarget == null) {
            this.invalidTarget = target;
        }
    }

    @Override
    public void setParam(Map params) {
        this.params = params;
    }

    public Object getParam(String key) {
        return this.params == null ? null : this.params.get(key);
    }

    @Override
    public abstract boolean validate();

    @Override
    public void setBillInfo(BillBaseInfo billInfo) {
        if (billInfo == null) {
            throw new IllegalArgumentException(EASResource.getString((String)this.resource, (String)"billInfoCantNull"));
        }
        this.billInfo = billInfo;
    }

    protected void reset() {
        this.invalidMsg = null;
        this.invalidTarget = null;
    }
}

