/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.excel.model.util.profile.IObjectProfileNode;
import com.kingdee.bos.ctrl.excel.model.util.profile.ObjectProfiler;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.wssc.BillImageFacadeFactory;
import com.kingdee.eas.base.wssc.BillImageMapCollection;
import com.kingdee.eas.base.wssc.BillImageMapFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.common.AccountConstant;
import com.kingdee.eas.basedata.master.auxacct.AsstActType;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnit;
import com.kingdee.eas.basedata.org.CompanyOrgUnit;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.basedata.FaUtils;
import com.kingdee.eas.fi.fa.manage.FaBakCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBizCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBorrowingEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaBorrowingInfo;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.FaCardInfo;
import com.kingdee.eas.fi.fa.manage.FaChangeBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaChangeBillInfo;
import com.kingdee.eas.fi.fa.manage.FaClearBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaClearBillInfo;
import com.kingdee.eas.fi.fa.manage.FaCombinBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaCombinBillInfo;
import com.kingdee.eas.fi.fa.manage.FaCurAsstActCompositCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCostCenterCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCostCenterInfo;
import com.kingdee.eas.fi.fa.manage.FaDecValueEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaDecValueInfo;
import com.kingdee.eas.fi.fa.manage.FaDepreciationEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaDepreciationEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaDepreciationInfo;
import com.kingdee.eas.fi.fa.manage.FaDispatchBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaDispatchBillInfo;
import com.kingdee.eas.fi.fa.manage.FaEvalDepreciationEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaEvaluateBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaEvaluateBillInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseBillInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillInfo;
import com.kingdee.eas.fi.fa.manage.FaMaintainEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaMaintainInfo;
import com.kingdee.eas.fi.fa.manage.FaMonCardInfo;
import com.kingdee.eas.fi.fa.manage.FaMortagBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaMortagBillInfo;
import com.kingdee.eas.fi.fa.manage.FaPeriodCloseJobCollection;
import com.kingdee.eas.fi.fa.manage.FaPeriodCloseJobFactory;
import com.kingdee.eas.fi.fa.manage.FaPeriodCloseJobInfo;
import com.kingdee.eas.fi.fa.manage.FaRefundingEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaRefundingInfo;
import com.kingdee.eas.fi.fa.manage.FaRequisitionedBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaRequisitionedBillInfo;
import com.kingdee.eas.fi.fa.manage.FaReturnEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaReturnInfo;
import com.kingdee.eas.fi.fa.manage.FaSplitBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaSplitBillInfo;
import com.kingdee.eas.fi.fa.manage.FaStocktakingBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaStocktakingBillInfo;
import com.kingdee.eas.fi.fa.manage.IFaPeriodCloseJob;
import com.kingdee.eas.fi.fa.manage.app.FaCardDefPropertyPersist;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class FaManageUtils
extends FaUtils {
    private static final Logger logger = Logger.getLogger(FaManageUtils.class);
    public static final String IN_TEMP_TABLE = "inTempTable";
    public static final String TEMP_TABLE = "tempTable";
    public static final String IDS_TEMP_TABLE = "idsTempTable";
    public static final String ID_SET = "idSet";
    public static final String FACURCARD_COLLECTION = "curCardCollection";
    protected static Class[] COLLECTION_PARATYPE = new Class[]{Integer.TYPE};
    public static final String[] facardEntry = new String[]{"CostCenter", "Facility", "Department", "InitData"};
    public static final int worklaodPrecision = 2;
    private static String resource = "com.kingdee.eas.fi.fa.manage.FaResource";
    public static final int periodCountPrecision = 0;
    public static final BigDecimal zero = new BigDecimal("0");
    public static final BigDecimal percent = new BigDecimal("100");
    public static final int TAX_RATE_PRECISION = 3;
    private static final String[] dispatchByCardItemDefault = new String[]{"assetName", "oldNumber", "assetAmt", "measureUnit", "accountDate", "fiAccountDate", "specs", "pArea", "mfr", "levFrDate", "paperNo", "wrtyPeriod", "wrtyNumber", "currency", "originAmt", "taxOriginAmt", "isDeduct", "inputTaxRate", "isHasTax", "addons", "exRate", "assetValue", "initEvalValue", "buyValue", "inputTax", "treatmentIncome", "buyAccuDepr", "addonFare", "fairValue", "deliverDate", "startUseDate", "deprTermCount", "useYears", "useTermCount", "evalLeftPeriod", "accuDepr", "neatRemValue", "accuDeprTYear", "neatLeftRate", "deprMethod", "measureUnitWL", "accuDeprAll", "decValue", "faCurFacility"};
    private static final String[] dispatchByCardItem = new String[]{"assetCat", "assetName", "oldNumber", "assetAmt", "measureUnit", "accountDate", "fiAccountDate", "originMethod", "useStatus", "storeCity", "economicPurp", "specs", "pArea", "mfr", "levFrDate", "paperNo", "dept", "keeper", "wrtyPeriod", "wrtyNumber", "currency", "originAmt", "taxOriginAmt", "isDeduct", "inputTaxRate", "isHasTax", "addons", "exRate", "assetValue", "initEvalValue", "buyValue", "inputTax", "treatmentIncome", "buyAccuDepr", "addonFare", "fairValue", "deliverDate", "startUseDate", "deprTermCount", "useYears", "useTermCount", "evalLeftPeriod", "accuDepr", "neatRemValue", "accuDeprTYear", "neatLeftRate", "deprMethod", "measureUnitWL", "accuDeprAll", "decValue", "accountAsset", "accountAccuDepr", "accountDecValue", "faCurDepartment", "faCurFacility", "faCurCostCenter"};
    private static final String[] ouIsolateItem = new String[]{"useStatus", "economicPurp", "assetCat", "originMethod"};
    private static final String[] dispatchByCardselector = new String[]{"assetCat.*", "assetName", "oldNumber", "assetAmt", "measureUnit.id", "accountDate", "fiAccountDate", "originMethod.*", "useStatus.*", "storeCity.id", "economicPurp.*", "specs", "pArea", "mfr", "levFrDate", "paperNo", "dept.id", "keeper.id", "wrtyPeriod", "wrtyNumber", "currency.id", "originAmt", "addons", "exRate", "assetValue", "initEvalValue", "buyValue", "inputTax", "treatmentIncome", "buyAccuDepr", "addonFare", "fairValue", "deliverDate", "startUseDate", "deprTermCount", "useYears", "useTermCount", "evalLeftPeriod", "accuDepr", "neatRemValue", "accuDeprTYear", "neatLeftRate", "deprMethod.id", "measureUnitWL.id", "accuDeprAll", "decValue", "accountAsset.*", "accountAccuDepr.*", "accountDecValue.*", "faCurDepartment.*", "faCurFacility.*", "faCurCostCenter.*", "faCurCostCenter.faCurAsstActComposit.*"};
    public static final String[] COSTTYPES = new String[]{"Cost_Type_Advance_Payment", "Cost_Type_Init_Direct_Fee", "Cost_Type_Guaranteed_Residual_Value", "Cost_Type_Exercise_Expenses", "Cost_Type_Termination_Costs", "Cost_Type_Recovery_Costs", "Cost_Type_Rent_Incentive"};

    public static boolean getFaParamValue(Context ctx, String paramName, String companyId) throws EASBizException, BOSException {
        HashMap hmParam = FaManageUtils.getFAParameter(ctx, new String[]{paramName}, companyId);
        String isUseCalDepSeparately = (String)hmParam.get(paramName);
        return Boolean.valueOf(isUseCalDepSeparately);
    }

    public static int getIntFaParamValue(Context ctx, String paramName, String companyId) throws EASBizException, BOSException {
        HashMap hmParam = FaManageUtils.getFAParameter(ctx, new String[]{paramName}, companyId);
        return Integer.valueOf((String)hmParam.get(paramName));
    }

    public static Map getInSql(Context ctx, String strCompanyInclude) throws BOSException {
        HashMap<String, String> hashMap;
        block9: {
            HashMap<String, String> map = new HashMap<String, String>();
            if (strCompanyInclude.indexOf("(") >= 0) {
                strCompanyInclude = strCompanyInclude.replace(" ", "");
                strCompanyInclude = strCompanyInclude.replace("(", "");
                strCompanyInclude = strCompanyInclude.replace(")", "");
            }
            if (strCompanyInclude.indexOf("'") >= 0) {
                strCompanyInclude = strCompanyInclude.replace("'", "");
            }
            String[] IDsArr = strCompanyInclude.split(",");
            StringBuffer inClause = new StringBuffer();
            String tempTableName = null;
            PreparedStatement pst = null;
            Connection conn = null;
            try {
                conn = FaManageUtils.getConnection(ctx);
                String createTableSql = "create table fa_select_cashcompany (FID varchar(44))";
                tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(createTableSql);
                TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FID", false, false);
                String insertSql = "insert into " + tempTableName + " (FID) values( ? )";
                pst = conn.prepareStatement(insertSql);
                int j = 0;
                for (int i = 0; i < IDsArr.length; ++i) {
                    pst.clearParameters();
                    pst.setString(1, IDsArr[i]);
                    pst.addBatch();
                    if (++j % 5000 != 0) continue;
                    pst.executeBatch();
                    pst.clearBatch();
                    j = 0;
                }
                if (j > 0) {
                    pst.executeBatch();
                }
                inClause.append(" select FID from ").append(tempTableName).append(" ");
                map.put("inClause", inClause.toString());
                map.put("tempTableName", tempTableName);
                hashMap = map;
                if (pst == null) break block9;
            }
            catch (Exception e) {
                try {
                    logger.error((Object)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (pst != null) {
                        SQLUtils.cleanup(pst, (Connection)conn);
                    }
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)pst, (Connection)conn);
        }
        return hashMap;
    }

    public static DateFormat getDateFormat() {
        return CtrlFormatUtilities.getDateFormat();
    }

    protected static Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    public static String formatNumber(BigDecimal val, int scale) {
        if (val == null) {
            return "";
        }
        return FaManageUtils.withComma(val.setScale(scale, 4), scale);
    }

    private static String withComma(BigDecimal val, int scale) {
        String pattern = FaManageUtils.getFormatPattern(scale);
        return new DecimalFormat(pattern).format(val);
    }

    public static String getFormatPatternForColumn(int scale) {
        return FaManageUtils.getFormatPattern(scale);
    }

    public static String getFormatPattern(int scale) {
        String pattern = null;
        switch (scale) {
            case 0: {
                pattern = "#,##0";
                break;
            }
            case 1: {
                pattern = "#,##0.0";
                break;
            }
            case 2: {
                pattern = "#,##0.00";
                break;
            }
            case 3: {
                pattern = "#,##0.000";
                break;
            }
            case 4: {
                pattern = "#,##0.0000";
                break;
            }
            default: {
                StringBuffer buf = new StringBuffer("#,##0.00000");
                for (int i = 5; i < scale; ++i) {
                    buf.append("0");
                }
                pattern = buf.toString();
            }
        }
        return pattern;
    }

    public static FaCurCardInfo BakCard2CurCard(FaBakCardInfo faBakCardInfo) {
        if (faBakCardInfo == null) {
            return null;
        }
        FaCurCardInfo faCurCardInfo = new FaCurCardInfo();
        try {
            FaManageUtils.copyValueBetweenCard(faBakCardInfo, faCurCardInfo, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return faCurCardInfo;
    }

    public static FaMonCardInfo BakCard2MonCard(FaBakCardInfo faBakCardInfo) {
        if (faBakCardInfo == null) {
            return null;
        }
        FaMonCardInfo faMonCardInfo = new FaMonCardInfo();
        try {
            FaManageUtils.copyValueBetweenCard(faBakCardInfo, faMonCardInfo, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return faMonCardInfo;
    }

    public static FaCurCardInfo BizCard2CurCard(FaBizCardInfo faBizCardInfo) {
        if (faBizCardInfo == null) {
            return null;
        }
        FaCurCardInfo faCurCardInfo = new FaCurCardInfo();
        try {
            FaManageUtils.copyValueBetweenCard(faBizCardInfo, faCurCardInfo, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return faCurCardInfo;
    }

    public static FaBizCardInfo CurCard2BizCard(FaCurCardInfo faCurCardInfo) {
        if (faCurCardInfo == null) {
            return null;
        }
        FaBizCardInfo faBizCardInfo = new FaBizCardInfo();
        try {
            FaManageUtils.copyValueBetweenCard(faCurCardInfo, faBizCardInfo, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return faBizCardInfo;
    }

    public static FaCurCardInfo BizCard2CurCardKeepId(FaBizCardInfo faBizCardInfo) {
        if (faBizCardInfo == null) {
            return null;
        }
        FaCurCardInfo faCurCardInfo = new FaCurCardInfo();
        try {
            FaManageUtils.copyValueBetweenCard(faBizCardInfo, faCurCardInfo, true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return faCurCardInfo;
    }

    public static FaBizCardInfo CurCard2BizCardKeepId(FaCurCardInfo faCurCardInfo) {
        if (faCurCardInfo == null) {
            return null;
        }
        FaBizCardInfo faBizCardInfo = new FaBizCardInfo();
        try {
            FaManageUtils.copyValueBetweenCard(faCurCardInfo, faBizCardInfo, true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return faBizCardInfo;
    }

    public static FaMonCardInfo CurCard2MonCard(FaCurCardInfo faCurCardInfo) {
        if (faCurCardInfo == null) {
            return null;
        }
        FaMonCardInfo faMonCardInfo = new FaMonCardInfo();
        try {
            FaManageUtils.copyValueBetweenCard(faCurCardInfo, faMonCardInfo, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return faMonCardInfo;
    }

    public static FaCurCardInfo MonCard2CurCard(FaMonCardInfo faMonCardInfo) {
        if (faMonCardInfo == null) {
            return null;
        }
        FaCurCardInfo faCurCardInfo = new FaCurCardInfo();
        try {
            FaManageUtils.copyValueBetweenCard(faMonCardInfo, faCurCardInfo, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return faCurCardInfo;
    }

    public static FaBakCardInfo MonCard2BakCard(FaMonCardInfo faMonCardInfo) {
        if (faMonCardInfo == null) {
            return null;
        }
        FaBakCardInfo faBakCardInfo = new FaBakCardInfo();
        try {
            FaManageUtils.copyValueBetweenCard(faMonCardInfo, faBakCardInfo, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return faBakCardInfo;
    }

    public static FaBakCardInfo CurCard2BakCard(FaCurCardInfo faCurCardInfo) {
        if (faCurCardInfo == null) {
            return null;
        }
        FaBakCardInfo faBakCardInfo = new FaBakCardInfo();
        try {
            FaManageUtils.copyValueBetweenCard(faCurCardInfo, faBakCardInfo, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return faBakCardInfo;
    }

    public static void copyItemBetweenCard(FaCardInfo srcCard, FaCardInfo destCard, boolean includeID, List itemList) throws Exception {
        String destPreFix = FaManageUtils.getCardPreFix(destCard);
        String srcPreFix = FaManageUtils.getCardPreFix(srcCard);
        for (int index = 0; index < itemList.size(); ++index) {
            String element = (String)itemList.get(index);
            if (!element.equalsIgnoreCase("id")) {
                Object o = srcCard.get(element);
                if (o instanceof IObjectCollection) {
                    IObjectCollection colObj = (IObjectCollection)o;
                    boolean flag = true;
                    for (int i = 0; i < facardEntry.length; ++i) {
                        if (!element.endsWith(facardEntry[i].toLowerCase()) || !destCard.containsKey(destPreFix + facardEntry[i])) continue;
                        Class c = FaManageUtils.getCollectionObject(destCard.get(destPreFix + facardEntry[i]));
                        for (int j = 0; j < colObj.size(); ++j) {
                            IObjectValue newObj = (IObjectValue)c.newInstance();
                            String[] excludeCostCenterElement = new String[]{srcPreFix + "card", srcPreFix + "AsstActComposit"};
                            FaManageUtils.copyValueNoID(colObj.getObject(j), newObj, excludeCostCenterElement, includeID);
                            newObj.put(destPreFix + "card", (Object)destCard);
                            ((IObjectCollection)destCard.get(destPreFix + facardEntry[i])).addObject(newObj);
                        }
                        flag = false;
                    }
                    if (!flag) continue;
                    destCard.put(element, o);
                    continue;
                }
                destCard.put(element, o);
                continue;
            }
            if (!includeID) continue;
            destCard.put(element, srcCard.get(element));
        }
        if (itemList.contains("faCurCostCenter")) {
            FaCurCostCenterCollection collection = (FaCurCostCenterCollection)((Object)destCard.get("faCurCostCenter"));
            for (int j = 0; j < collection.size(); ++j) {
                FaCurCostCenterInfo costCenter = collection.get(j);
                FaCurAsstActCompositCollection composit = costCenter.getFaCurAsstActComposit();
                for (int k = 0; k < composit.size(); ++k) {
                    composit.get(k).setId(null);
                }
                costCenter.setId(null);
            }
        }
    }

    public static void copyValueBetweenCard(FaCardInfo srcCard, FaCardInfo destCard, boolean includeID) throws Exception {
        FaCardInfo parent = (FaCardInfo)destCard.clone();
        if (includeID) {
            parent.put("id", srcCard.get("id"));
        }
        String destPreFix = FaManageUtils.getCardPreFix(destCard);
        String srcPreFix = FaManageUtils.getCardPreFix(srcCard);
        Enumeration enumKeys = srcCard.keys();
        while (enumKeys.hasMoreElements()) {
            String element = (String)enumKeys.nextElement();
            if (!element.equalsIgnoreCase("id")) {
                Object o = srcCard.get(element);
                if (o instanceof IObjectCollection) {
                    IObjectCollection colObj = (IObjectCollection)o;
                    boolean flag = true;
                    for (int i = 0; i < facardEntry.length; ++i) {
                        if (!element.endsWith(facardEntry[i].toLowerCase()) || !destCard.containsKey(destPreFix + facardEntry[i])) continue;
                        Class c = FaManageUtils.getCollectionObject(destCard.get(destPreFix + facardEntry[i]));
                        for (int j = 0; j < colObj.size(); ++j) {
                            IObjectValue newObj = (IObjectValue)c.newInstance();
                            String[] excludeCostCenterElement = new String[]{srcPreFix + "card", srcPreFix + "AsstActComposit"};
                            FaManageUtils.copyValueNoID(colObj.getObject(j), newObj, excludeCostCenterElement, includeID);
                            newObj.put(destPreFix + "card", (Object)parent);
                            ((IObjectCollection)destCard.get(destPreFix + facardEntry[i])).addObject(newObj);
                        }
                        flag = false;
                    }
                    if (!flag) continue;
                    destCard.put(element, o);
                    continue;
                }
                destCard.put(element, o);
                continue;
            }
            if (!includeID) continue;
            destCard.put(element, srcCard.get(element));
        }
        FaManageUtils.copyMultiAsstActInfo(srcCard, destCard, includeID);
    }

    public static void copyMultiAsstActInfo(FaCardInfo srcCard, FaCardInfo destCard, boolean includeID) throws Exception {
        String destPreFix = FaManageUtils.getCardPreFix(destCard);
        String srcPreFix = FaManageUtils.getCardPreFix(srcCard);
        Object srcCostCenterObj = srcCard.get(srcPreFix + "CostCenter");
        Object descCostCenterObj = destCard.get(destPreFix + "CostCenter");
        if (srcCostCenterObj != null && descCostCenterObj != null) {
            IObjectCollection srColObj = (IObjectCollection)srcCostCenterObj;
            IObjectCollection descColObj = (IObjectCollection)descCostCenterObj;
            for (int j = 0; j < srColObj.size(); ++j) {
                Object asstActObj = srColObj.getObject(j).get(srcPreFix + "AsstActComposit");
                IObjectValue aDesCostCenter = null;
                IObjectValue parentDesCostCenter = null;
                for (int i = 0; i < descColObj.size(); ++i) {
                    if (descColObj.getObject(i).get("seq") == null || srColObj.getObject(j).get("seq") == null || !descColObj.getObject(i).get("seq").equals(srColObj.getObject(j).get("seq")) || descColObj.getObject(i).get("accountview") == null || srColObj.getObject(j).get("accountview") == null || !descColObj.getObject(i).get("accountview").equals(srColObj.getObject(j).get("accountview"))) continue;
                    aDesCostCenter = descColObj.getObject(i);
                    parentDesCostCenter = (IObjectValue)((AbstractObjectValue)aDesCostCenter).clone();
                    parentDesCostCenter.clear();
                    parentDesCostCenter.setBOSUuid("id", aDesCostCenter.getBOSUuid("id"));
                    break;
                }
                if (aDesCostCenter == null) continue;
                Class asstActClass = FaManageUtils.getCollectionObject(aDesCostCenter.get(destPreFix + "AsstActComposit"));
                if (!(asstActObj instanceof IObjectCollection)) continue;
                IObjectCollection colAsstActObj = (IObjectCollection)asstActObj;
                for (int k = 0; k < colAsstActObj.size(); ++k) {
                    HashSet<String> set = new HashSet<String>();
                    if (colAsstActObj.getObject(k).get("asstActType") != null && ((AsstActTypeInfo)colAsstActObj.getObject(k).get("asstActType")).getId() != null) {
                        if (set.contains(((AsstActTypeInfo)colAsstActObj.getObject(k).get("asstActType")).getId().toString())) continue;
                        set.add(((AsstActTypeInfo)colAsstActObj.getObject(k).get("asstActType")).getId().toString());
                    }
                    IObjectValue asstActObjNew = (IObjectValue)asstActClass.newInstance();
                    String[] excludeAsstActElement = new String[]{srcPreFix + "CostCenter"};
                    if (colAsstActObj.getObject(k).get("asstActItem") != null && colAsstActObj.getObject(k).get("asstActType") != null) {
                        FaManageUtils.copyValueNoID(colAsstActObj.getObject(k), asstActObjNew, excludeAsstActElement, includeID);
                        asstActObjNew.put(destPreFix + "CostCenter", (Object)parentDesCostCenter);
                        ((IObjectCollection)aDesCostCenter.get(destPreFix + "AsstActComposit")).addObject(asstActObjNew);
                        continue;
                    }
                    logger.info((Object)"------src blank line in CostCenter---------");
                }
            }
        }
    }

    private static String getCardPreFix(FaCardInfo info) {
        String cardPreFix = "";
        if (info instanceof FaBakCardInfo) {
            cardPreFix = "fabak";
        }
        if (info instanceof FaBizCardInfo) {
            cardPreFix = "fabiz";
        }
        if (info instanceof FaCurCardInfo) {
            cardPreFix = "facur";
        }
        if (info instanceof FaMonCardInfo) {
            cardPreFix = "famon";
        }
        return cardPreFix;
    }

    public static Class getCollectionObject(Object colObj) throws Exception {
        Class<?> cls = colObj.getClass();
        Method mtd = cls.getMethod("get", COLLECTION_PARATYPE);
        return mtd.getReturnType();
    }

    public static void copyValueNoID(IObjectValue srcInfo, IObjectValue destInfo, String[] fix, boolean includeID) {
        if (srcInfo == null) {
            return;
        }
        Enumeration enumKeys = srcInfo.keys();
        ArrayList<String> fixList = new ArrayList<String>();
        for (int i = 0; i < fix.length; ++i) {
            fixList.add(fix[i].toLowerCase());
        }
        while (enumKeys.hasMoreElements()) {
            String element = (String)enumKeys.nextElement();
            Object o = srcInfo.get(element);
            if (!element.equalsIgnoreCase("id")) {
                if (fixList.contains(element.toLowerCase())) continue;
                destInfo.put(element, o);
                continue;
            }
            if (!includeID) continue;
            destInfo.put(element, srcInfo.get(element));
        }
    }

    public static HashMap getFAParameter(Context ctx, String[] numbers, String orgId) throws EASBizException, BOSException {
        if (numbers.length == 0) {
            return new HashMap();
        }
        HashMap result = ParamManager.getParamHashMap((Context)ctx, (String[])numbers, (String)orgId);
        return result == null ? new HashMap() : result;
    }

    public static HashMap getFAParameter(BOSUuid id) throws EASBizException, BOSException {
        return FaManageUtils.getFAParameter(id, null);
    }

    public static HashMap getFAParameter(BOSUuid id, Context ctx) throws EASBizException, BOSException {
        String depr;
        if (id == null) {
            return new HashMap();
        }
        ObjectUuidPK pk = new ObjectUuidPK(id);
        HashMap<String, ObjectUuidPK> paramKeyMap = new HashMap<String, ObjectUuidPK>();
        paramKeyMap.put("FA_000", pk);
        paramKeyMap.put("FA_001", pk);
        paramKeyMap.put("FA_002", pk);
        paramKeyMap.put("FA_003", pk);
        paramKeyMap.put("FA_004", pk);
        paramKeyMap.put("FA_005", pk);
        paramKeyMap.put("FA_006", pk);
        paramKeyMap.put("FA_007", pk);
        paramKeyMap.put("FA_008", pk);
        paramKeyMap.put("FA_010", pk);
        paramKeyMap.put("FA_011", pk);
        paramKeyMap.put("FA_012", pk);
        paramKeyMap.put("FA_013", pk);
        paramKeyMap.put("FA_014", pk);
        paramKeyMap.put("FA_015", pk);
        paramKeyMap.put("FA_016", pk);
        paramKeyMap.put("FA_017", pk);
        paramKeyMap.put("FA_018", pk);
        paramKeyMap.put("FA_019", pk);
        paramKeyMap.put("FA_021", pk);
        paramKeyMap.put("FA_022", pk);
        paramKeyMap.put("FA_023", pk);
        paramKeyMap.put("FA_024", pk);
        paramKeyMap.put("FA_025", pk);
        paramKeyMap.put("FA_026", pk);
        paramKeyMap.put("FA_027", pk);
        paramKeyMap.put("FA_028", pk);
        paramKeyMap.put("FA_029", pk);
        paramKeyMap.put("FA_030", pk);
        paramKeyMap.put("FA_031", pk);
        paramKeyMap.put("FA_032", pk);
        paramKeyMap.put("FA_033", pk);
        paramKeyMap.put("FA_036", pk);
        paramKeyMap.put("FA_037", pk);
        paramKeyMap.put("FA_039", pk);
        paramKeyMap.put("FA_040", pk);
        paramKeyMap.put("FA_041", pk);
        paramKeyMap.put("FA_042", pk);
        paramKeyMap.put("FA_043", pk);
        paramKeyMap.put("FA_044", pk);
        paramKeyMap.put("FA_045", pk);
        paramKeyMap.put("FA_046", pk);
        paramKeyMap.put("FA_047", pk);
        paramKeyMap.put("FA_048", pk);
        paramKeyMap.put("FA_049", pk);
        paramKeyMap.put("FA_050", pk);
        paramKeyMap.put("FA_051", pk);
        paramKeyMap.put("FA_052", pk);
        paramKeyMap.put("FA_053", pk);
        paramKeyMap.put("FA_054", pk);
        paramKeyMap.put("FA_055", pk);
        paramKeyMap.put("FA_057", pk);
        paramKeyMap.put("FA_100", pk);
        paramKeyMap.put("FA_101", pk);
        paramKeyMap.put("FA_102", pk);
        paramKeyMap.put("FA_189", pk);
        paramKeyMap.put("FA_998", pk);
        paramKeyMap.put("FA_999", pk);
        paramKeyMap.put("GL_111", pk);
        paramKeyMap.put("GL_115", pk);
        paramKeyMap.put("FA_201", pk);
        paramKeyMap.put(AccountConstant.GovermentAccountingSystem, null);
        paramKeyMap.put("FA_112", pk);
        paramKeyMap.put("FA_056", pk);
        paramKeyMap.put("FA_063", pk);
        paramKeyMap.put("FA_077", pk);
        paramKeyMap.put("FA_288", pk);
        paramKeyMap.put("FA_CHECK_001", pk);
        paramKeyMap.put("FA_289", pk);
        Set set = paramKeyMap.keySet();
        Object[] paramObject = set.toArray();
        String[] paramNumber = new String[paramObject.length];
        for (int i = 0; i < paramObject.length; ++i) {
            paramNumber[i] = (String)paramObject[i];
        }
        HashMap result = ParamManager.getParamHashMap((Context)ctx, (String[])paramNumber, (String)id.toString());
        if (result != null && ((depr = (String)result.get("FA_007")) == null || depr.trim().length() == 0)) {
            result.put("FA_007", "2");
        }
        return result == null ? new HashMap() : result;
    }

    public static HashMap getFAParameter4CurCard(BOSUuid id, Context ctx) throws EASBizException, BOSException {
        String depr;
        String[] paramNumbers = new String[]{"FA_019", "FA_043", "FA_001", "FA_003", "FA_189", "FA_101", "FA_050", "FA_023", "FA_021", "FA_027", "FA_036", "FA_022", "FA_054", "FA_030", "FA_033", "FA_040", "FA_013", "FA_014", "FA_015", "FA_007", "FA_025", "FA_017", "FA_047", "FA_046", "FA_042", "FA_045", "FA_024", "FA_008", "FA_016", "FA_018", "FA_102", "FA_029", "FA_011", "GL_111", "GL_115", "FA_063", "FA_289"};
        HashMap result = ParamManager.getParamHashMap((Context)ctx, (String[])paramNumbers, (String)id.toString());
        if (result != null && ((depr = (String)result.get("FA_007")) == null || depr.trim().length() == 0)) {
            result.put("FA_007", "2");
        }
        return result == null ? new HashMap() : result;
    }

    public static int getCurrencyScale(BOSUuid currencyID) throws EASBizException, BOSException {
        return FaManageUtils.getCurrencyScale(currencyID, null);
    }

    public static int getCurrencyScale(BOSUuid currencyID, Context ctx) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("precision"));
        ObjectUuidPK pk = new ObjectUuidPK(currencyID);
        CurrencyInfo currencyInfo = ctx == null ? CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)pk, sic) : CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)pk, sic);
        return currencyInfo == null ? 2 : currencyInfo.getPrecision();
    }

    public static int getCurrencyScale(CompanyOrgUnitInfo company, Context ctx) throws EASBizException, BOSException {
        CurrencyInfo currency = company.getBaseCurrency();
        if (currency != null && currency.get("precision") != null) {
            return currency.getPrecision();
        }
        if (currency == null || currency.getId() == null) {
            CompanyOrgUnitInfo _comp = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select baseCurrency.precision where id='" + company.getId() + "'");
            return _comp.getBaseCurrency().getPrecision();
        }
        return CurrencyFactory.getLocalInstance((Context)ctx).getValue("select precision where id='" + company.getBaseCurrency().getId() + "'").getInt("precision");
    }

    public static void profile(Object obj) {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(new File("w:/traceObj.log"), true));
            IObjectProfileNode profile = ObjectProfiler.profile((Object)obj);
            out.write("Undo mem cost: " + (float)profile.size() / 1024.0f + " KB");
            out.write(profile.dump());
        }
        catch (Exception e) {
            if (out != null) {
                logger.error((Object)new PrintWriter(out));
            } else {
                logger.error((Object)e);
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static CurrencyInfo getBaseCurrency(Context ctx) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = null;
        ICurrency iCurrency = null;
        if (ctx != null) {
            company = ContextUtil.getCurrentFIUnit((Context)ctx);
            ICompanyOrgUnit icompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            company = icompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()));
            iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
        } else {
            company = SysContext.getSysContext().getCurrentFIUnit();
            iCurrency = CurrencyFactory.getRemoteInstance();
        }
        ObjectUuidPK pk = new ObjectUuidPK(company.getBaseCurrency().getId());
        return iCurrency.getCurrencyInfo((IObjectPK)pk);
    }

    public static int getExchangRateScale(CurrencyInfo srcCyInfo, Context ctx) {
        int rateScale = 4;
        try {
            CurrencyInfo targetCyInfo = FaManageUtils.getBaseCurrency(ctx);
            if (srcCyInfo != null && targetCyInfo != null) {
                if (srcCyInfo.getId().equals((Object)targetCyInfo.getId())) {
                    rateScale = targetCyInfo.getPrecision();
                } else {
                    IExchangeRate iExchangeRate;
                    ExchangeRateInfo exchangeRateInfo;
                    CompanyOrgUnitInfo companyInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
                    String companyID = companyInfo.getId().toString();
                    ExchangeTableInfo exchangeTableInfo = companyInfo.getBaseExchangeTable();
                    if (exchangeTableInfo != null && (exchangeRateInfo = (iExchangeRate = ExchangeRateFactory.getLocalInstance((Context)ctx)).getExchangeRate((IObjectPK)new ObjectUuidPK(exchangeTableInfo.getId()), (IObjectPK)new ObjectUuidPK(srcCyInfo.getId()), (IObjectPK)new ObjectUuidPK(targetCyInfo.getId()), (Date)FaManageUtils.getCurrentPeriod(companyID, ctx).getEndDate())) != null) {
                        rateScale = exchangeRateInfo.getPrecision();
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            MsgBox.showInfo((String)"Error in getting ExchangeRate");
            SysUtil.abort();
        }
        return rateScale;
    }

    public static PeriodInfo getCurrentPeriod(String companyID, Context ctx) throws BOSException, EASBizException {
        PeriodInfo currentPeriod = null;
        ISystemStatusCtrol ictrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("systemStatus.name", (Object)new Integer(SystemEnum.FIXEDASSETS.getValue())));
        fic.add(new FilterItemInfo("company.id", (Object)companyID));
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("currentPeriod.periodYear"));
        sic.add(new SelectorItemInfo("currentPeriod.periodNumber"));
        sic.add(new SelectorItemInfo("currentPeriod.beginDate"));
        sic.add(new SelectorItemInfo("currentPeriod.isAdjustPeriod"));
        sic.add(new SelectorItemInfo("currentPeriod.endDate"));
        sic.add(new SelectorItemInfo("currentPeriod.periodType.*"));
        SystemStatusCtrolCollection col = ictrol.getSystemStatusCtrolCollection(view);
        if (col.size() > 0) {
            currentPeriod = col.get(0).getCurrentPeriod();
        }
        return currentPeriod;
    }

    public static void deleteFaMonCard(Context ctx, String pk) throws BOSException, EASBizException {
        DbUtil.execute((Context)ctx, (String)"delete from t_fa_famonfacility where FFaMonCardID in (select fid from t_fa_famoncard where ffacurcardid = ? and FFaPeriodId is not null)", (Object[])new Object[]{pk});
        DbUtil.execute((Context)ctx, (String)"delete from T_FA_FaMonAsstActComposit where ffaMonCostCenterID in (select FID from T_Fa_faMonCostCenter where  FFaMonCardID in (select fid from t_fa_famoncard where ffacurcardid = ? and FFaPeriodId is not null))", (Object[])new Object[]{pk});
        DbUtil.execute((Context)ctx, (String)"delete from t_fa_famoncostcenter where FFaMonCardID in (select fid from t_fa_famoncard where ffacurcardid = ? and FFaPeriodId is not null)", (Object[])new Object[]{pk});
        DbUtil.execute((Context)ctx, (String)"delete from t_fa_famoninitdata where FFaMonCardID in (select fid from t_fa_famoncard where ffacurcardid = ? and FFaPeriodId is not null)", (Object[])new Object[]{pk});
        DbUtil.execute((Context)ctx, (String)"delete from t_fa_famondepartment where FFaMonCardID in (select fid from t_fa_famoncard where ffacurcardid = ? and FFaPeriodId is not null)", (Object[])new Object[]{pk});
        DbUtil.execute((Context)ctx, (String)"delete from t_fa_famoncard where ffacurcardid = ? and FFaPeriodId is not null", (Object[])new Object[]{pk});
    }

    public static void deleteFaDepreciation(Context ctx, CompanyOrgUnitInfo currCompanyInfo) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("delete from T_FA_FaDepreciation ");
        sql.append(" where fcompanyid = '").append(currCompanyInfo.getId()).append("' ");
        sql.append(" and fdeptype <> 2");
        sql.append("   and not exists (");
        sql.append("select fid from t_fa_fadepreciationentry entry ");
        sql.append(" where entry.flnkfadepreentry = T_FA_FaDepreciation.fid");
        sql.append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("delete from T_FA_FaEvalDepreciation ");
        sql.append(" where fcompanyid = '").append(currCompanyInfo.getId()).append("' ");
        sql.append("   and not exists (");
        sql.append("select fid from t_fa_faEvaldepreciationentry entry ");
        sql.append(" where entry.flnkfadepreentry = T_FA_FaEvalDepreciation.fid");
        sql.append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    public static void deleteFaDepreEntry(Context ctx, String pk) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("faCurCard", (Object)pk, CompareType.EQUALS));
        FaDepreciationEntryFactory.getLocalInstance(ctx).delete(filter);
        FaEvalDepreciationEntryFactory.getLocalInstance(ctx).delete(filter);
    }

    public static boolean deleteBill(Context ctx, String pk) throws BOSException, EASBizException {
        boolean result = true;
        if (pk == null || pk.trim().length() == 0) {
            throw new IllegalArgumentException("deleteBill method parameter pk can not be null");
        }
        BOSObjectType bosType = BOSUuid.getBOSObjectType((String)pk, (boolean)true);
        if (bosType == null) {
            throw new IllegalArgumentException("Invalid bostype in parameter pk :" + pk);
        }
        AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
        if (bosType.toString().equals(new FaCurCardInfo().getBOSType().toString())) {
            FaCardDefPropertyPersist.deleteByCurCardPK(ctx, pk);
            DbUtil.execute((Context)ctx, (String)"delete from t_fa_facurfacility where FFaCurCardID = ?", (Object[])new Object[]{pk});
            DbUtil.execute((Context)ctx, (String)"delete from T_FA_FaCurAsstActComposit where ffaCurCostCenterID in (select FID from T_Fa_faCurCostCenter where FFaCurCardID = ?)", (Object[])new Object[]{pk});
            DbUtil.execute((Context)ctx, (String)"delete from t_fa_facurcostcenter where FFaCurCardID = ?", (Object[])new Object[]{pk});
            DbUtil.execute((Context)ctx, (String)"delete from t_fa_facurinitdata where FFaCurCardID = ?", (Object[])new Object[]{pk});
            DbUtil.execute((Context)ctx, (String)"delete from t_fa_facurdepartment where FFaCurCardID = ?", (Object[])new Object[]{pk});
            DbUtil.execute((Context)ctx, (String)"delete from t_fa_facurcard where FID = ?", (Object[])new Object[]{pk});
            DbUtil.execute((Context)ctx, (String)"delete from t_bot_relation where FDestobjectID = ?", (Object[])new Object[]{pk});
            asm.deleteAttachemtsByBoID(pk.toString());
            try {
                Integer unAuditValue = new Integer(1);
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select fid from t_fa_famoncard where ffacurcardid = ? and FCheckedStatus=?", (Object[])new Object[]{pk, unAuditValue});
                while (rs.next()) {
                    asm.deleteAttachemtsByBoID(rs.getString(1));
                }
                FaManageUtils.deleteFaMonCard(ctx, pk);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        } else if (bosType.toString().equals(new FaChangeBillInfo().getBOSType().toString())) {
            DbUtil.execute((Context)ctx, (String)"delete from t_fa_fachangebillentry where FChangeBillID = ?", (Object[])new Object[]{pk});
            DbUtil.execute((Context)ctx, (String)"delete from t_fa_fachangebill where FID = ?", (Object[])new Object[]{pk});
        } else if (bosType.toString().equals(new FaClearBillInfo().getBOSType().toString())) {
            DbUtil.execute((Context)ctx, (String)"delete from t_fa_clearbillentry where FEntryID = ?", (Object[])new Object[]{pk});
            DbUtil.execute((Context)ctx, (String)"delete from t_fa_clearbill where FID = ?", (Object[])new Object[]{pk});
        } else if (bosType.toString().equals(new FaSplitBillInfo().getBOSType().toString())) {
            DbUtil.execute((Context)ctx, (String)"delete from t_fa_fasplitbillentry where FFaSplitBillID = ?", (Object[])new Object[]{pk});
            DbUtil.execute((Context)ctx, (String)"delete from t_fa_fasplitbill where FID = ?", (Object[])new Object[]{pk});
        } else if (bosType.toString().equals(new FaCombinBillInfo().getBOSType().toString())) {
            DbUtil.execute((Context)ctx, (String)"delete from t_fa_facombinbillentry where FFaCombinBill = ?", (Object[])new Object[]{pk});
            DbUtil.execute((Context)ctx, (String)"delete from t_fa_facombinbill where FID = ?", (Object[])new Object[]{pk});
        } else if (bosType.toString().equals(new FaDispatchBillInfo().getBOSType().toString())) {
            DbUtil.execute((Context)ctx, (String)"delete from t_fa_fadispatchbillentry where FFaDispatchBillID = ?", (Object[])new Object[]{pk});
            DbUtil.execute((Context)ctx, (String)"delete from t_fa_fadispatchbill where FID = ?", (Object[])new Object[]{pk});
        } else if (bosType.toString().equals(new FaEvaluateBillInfo().getBOSType().toString())) {
            DbUtil.execute((Context)ctx, (String)"delete from t_fa_faevaluatedoc where FFaEvaluateBillID = ?", (Object[])new Object[]{pk});
            DbUtil.execute((Context)ctx, (String)"delete from t_fa_faevavalue where FEvaEntryID in (select fid from t_fa_faevaluatebillentry where FFaEvaluateBillID = ?)", (Object[])new Object[]{pk});
            DbUtil.execute((Context)ctx, (String)"delete from t_fa_faevaluatebillentry where FFaEvaluateBillID = ?", (Object[])new Object[]{pk});
            DbUtil.execute((Context)ctx, (String)"delete from t_fa_faevaluatebill where FID = ?", (Object[])new Object[]{pk});
        } else if (bosType.toString().equals(new FaLeaseBillInfo().getBOSType().toString())) {
            DbUtil.execute((Context)ctx, (String)"delete from t_fa_faleasebillentry where FFaLeaseBillID = ?", (Object[])new Object[]{pk});
            DbUtil.execute((Context)ctx, (String)"delete from t_fa_faleasebill where FID = ?", (Object[])new Object[]{pk});
        } else if (bosType.toString().equals(new FaMortagBillInfo().getBOSType().toString())) {
            DbUtil.execute((Context)ctx, (String)"delete from t_fa_famortagbillentry where FFaMortagBillID = ?", (Object[])new Object[]{pk});
            DbUtil.execute((Context)ctx, (String)"delete from t_fa_famortagbill where FID = ?", (Object[])new Object[]{pk});
        } else {
            result = false;
        }
        return result;
    }

    public static boolean isEnableUndo(Context ctx) {
        try {
            String canUnAudit = ParamManager.getSpecialParamValue((Context)ctx, (String)"REVERSE_AUDITING_ENABLE");
            if (canUnAudit != null) {
                return Boolean.valueOf(canUnAudit);
            }
        }
        catch (Exception e) {
            return true;
        }
        return true;
    }

    public static void checkEnableUndo(Context ctx) throws BOSException, EASBizException {
        if (!FaManageUtils.isEnableUndo(ctx)) {
            throw new FaCardException(FaCardException.CANT_UNDO, new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource", (String)"disableUndo", (Locale)ctx.getOriginLocale())});
        }
    }

    public static String getBillHeadEntryRelName(String bostype, boolean refEntry) {
        if (bostype == null || bostype.trim().length() == 0) {
            return null;
        }
        if (bostype.equals(new FaChangeBillInfo().getBOSType().toString()) || bostype.equals(new FaChangeBillEntryInfo().getBOSType().toString())) {
            return refEntry ? "changeBillEntry" : "changeBill";
        }
        if (bostype.equals(new FaClearBillInfo().getBOSType().toString()) || bostype.equals(new FaClearBillEntryInfo().getBOSType().toString())) {
            return refEntry ? "clearBillEntry" : "entry";
        }
        if (bostype.equals(new FaDispatchBillInfo().getBOSType().toString()) || bostype.equals(new FaDispatchBillEntryInfo().getBOSType().toString())) {
            return refEntry ? "FaDispatchBillEntry" : "faDispatchBill";
        }
        if (bostype.equals(new FaSplitBillInfo().getBOSType().toString()) || bostype.equals(new FaSplitBillEntryInfo().getBOSType().toString())) {
            return refEntry ? "faSplitBillEntry" : "FaSplitBill";
        }
        if (bostype.equals(new FaCombinBillInfo().getBOSType().toString()) || bostype.equals(new FaCombinBillEntryInfo().getBOSType().toString())) {
            return refEntry ? "faCombinBillEntry" : "faCombinBill";
        }
        if (bostype.equals(new FaEvaluateBillInfo().getBOSType().toString()) || bostype.equals(new FaEvaluateBillEntryInfo().getBOSType().toString())) {
            return refEntry ? "faEvaluateBillEntry" : "faEvaluateBill";
        }
        if (bostype.equals(new FaLeaseBillInfo().getBOSType().toString()) || bostype.equals(new FaLeaseBillEntryInfo().getBOSType().toString())) {
            return refEntry ? "faLeaseBillEntry" : "faLeaseBill";
        }
        if (bostype.equals(new FaMortagBillInfo().getBOSType().toString()) || bostype.equals(new FaMortagBillEntryInfo().getBOSType().toString())) {
            return refEntry ? "faMortagBillEntry" : "faMortagBill";
        }
        if (bostype.equals(new FaDecValueInfo().getBOSType().toString()) || bostype.equals(new FaDecValueInfo().getBOSType().toString())) {
            return refEntry ? "entry" : "head";
        }
        if (bostype.equals(new FaStocktakingBillInfo().getBOSType().toString()) || bostype.equals(new FaStocktakingBillEntryInfo().getBOSType().toString())) {
            return refEntry ? "entries" : "bill";
        }
        if (bostype.equals(new FaLeaseInBillInfo().getBOSType().toString()) || bostype.equals(new FaLeaseInBillEntryInfo().getBOSType().toString())) {
            return refEntry ? "entry" : "head";
        }
        if (bostype.equals(new FaMaintainInfo().getBOSType().toString()) || bostype.equals(new FaMaintainEntryInfo().getBOSType().toString())) {
            return refEntry ? "maintainEntry" : "entry";
        }
        if (bostype.equals(new FaDecValueInfo().getBOSType().toString()) || bostype.equals(new FaDecValueEntryInfo().getBOSType().toString())) {
            return refEntry ? "entry" : "head";
        }
        if (bostype.equals(new FaRequisitionedBillInfo().getBOSType().toString()) || bostype.equals(new FaRequisitionedBillEntryInfo().getBOSType().toString())) {
            return refEntry ? "Entrys" : "parent";
        }
        if (bostype.equals(new FaBorrowingInfo().getBOSType().toString()) || bostype.equals(new FaBorrowingEntryInfo().getBOSType().toString())) {
            return refEntry ? "entry" : "parent";
        }
        if (bostype.equals(new FaReturnInfo().getBOSType().toString()) || bostype.equals(new FaReturnEntryInfo().getBOSType().toString())) {
            return refEntry ? "entry" : "parent";
        }
        if (bostype.equals(new FaRefundingInfo().getBOSType().toString()) || bostype.equals(new FaRefundingEntryInfo().getBOSType().toString())) {
            return refEntry ? "entry" : "parent";
        }
        if (bostype.equals(new FaDepreciationInfo().getBOSType().toString()) || bostype.equals(new FaDepreciationEntryInfo().getBOSType().toString())) {
            return refEntry ? "lnkFaDepreEntry" : "LnkFaDepreEntry";
        }
        return null;
    }

    public static SelectorItemCollection getDepCardSelector() {
        SelectorItemCollection sic = FaManageUtils.getDepCommonSelector();
        sic.add(new SelectorItemInfo("faCurCostCenter.id"));
        sic.add(new SelectorItemInfo("faCurCostCenter.seq"));
        sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActType.*"));
        sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActItem.*"));
        sic.add(new SelectorItemInfo("faCurCostCenter.apportionScale"));
        sic.add(new SelectorItemInfo("faCurCostCenter.accountView.id"));
        sic.add(new SelectorItemInfo("faCurCostCenter.accountView.name"));
        sic.add(new SelectorItemInfo("faCurCostCenter.accountView.number"));
        sic.add(new SelectorItemInfo("faCurCostCenter.accountView.assgrp"));
        sic.add(new SelectorItemInfo("faCurCostCenter.accountView.assgrp.*"));
        sic.add(new SelectorItemInfo("faCurCostCenter.profitCenter.number"));
        sic.add(new SelectorItemInfo("faCurCostCenter.profitCenter.name"));
        sic.add(new SelectorItemInfo("faCurCostCenter.profitCenter.*"));
        return sic;
    }

    public static SelectorItemCollection getDepMonCardSelector() {
        SelectorItemCollection sic = FaManageUtils.getDepCommonSelector();
        sic.add(new SelectorItemInfo("faCurCard.id"));
        sic.add(new SelectorItemInfo("faMonCostCenter.id"));
        sic.add(new SelectorItemInfo("faMonCostCenter.seq"));
        sic.add(new SelectorItemInfo("faMonCostCenter.apportionScale"));
        sic.add(new SelectorItemInfo("faMonCostCenter.accountView.id"));
        sic.add(new SelectorItemInfo("faMonCostCenter.accountView.name"));
        sic.add(new SelectorItemInfo("faMonCostCenter.accountView.number"));
        sic.add(new SelectorItemInfo("faMonCostCenter.accountView.name"));
        sic.add(new SelectorItemInfo("faMonCostCenter.faMonAsstActComposit.asstActType.id"));
        sic.add(new SelectorItemInfo("faMonCostCenter.faMonAsstActComposit.asstActItem.id"));
        sic.add(new SelectorItemInfo("faMonCostCenter.profitCenter.id"));
        sic.add(new SelectorItemInfo("faMonCostCenter.profitCenter.name"));
        sic.add(new SelectorItemInfo("faMonCostCenter.profitCenter.number"));
        return sic;
    }

    public static SelectorItemCollection getDepBakCardSelector() {
        SelectorItemCollection sic = FaManageUtils.getDepCommonSelector();
        sic.add(new SelectorItemInfo("faCurCard.id"));
        sic.add(new SelectorItemInfo("faBakCostCenter.id"));
        sic.add(new SelectorItemInfo("faBakCostCenter.seq"));
        sic.add(new SelectorItemInfo("faBakCostCenter.apportionScale"));
        sic.add(new SelectorItemInfo("faBakCostCenter.accountView.id"));
        sic.add(new SelectorItemInfo("faBakCostCenter.accountView.name"));
        sic.add(new SelectorItemInfo("faBakCostCenter.accountView.number"));
        sic.add(new SelectorItemInfo("faBakCostCenter.accountView.name"));
        sic.add(new SelectorItemInfo("faBakCostCenter.faBakAsstActComposit.asstActType.id"));
        sic.add(new SelectorItemInfo("faBakCostCenter.faBakAsstActComposit.asstActItem.id"));
        sic.add(new SelectorItemInfo("faMonCostCenter.profitCenter.id"));
        sic.add(new SelectorItemInfo("faMonCostCenter.profitCenter.name"));
        sic.add(new SelectorItemInfo("faMonCostCenter.profitCenter.number"));
        return sic;
    }

    public static SelectorItemCollection getDepCommonSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("assetName"));
        sic.add(new SelectorItemInfo("deletedStatus"));
        sic.add(new SelectorItemInfo("fiAccountDate"));
        sic.add(new SelectorItemInfo("assetCat.id"));
        sic.add(new SelectorItemInfo("assetCat.number"));
        sic.add(new SelectorItemInfo("assetCat.name"));
        sic.add(new SelectorItemInfo("assetCat.prePureRate"));
        sic.add(new SelectorItemInfo("assetCat.depreRule"));
        sic.add(new SelectorItemInfo("assetCat.endDiffDeal"));
        sic.add(new SelectorItemInfo("assetCat.calcuByEvaluate"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.*"));
        sic.add(new SelectorItemInfo("assetCat.notCalDep"));
        sic.add(new SelectorItemInfo("deprMethod.period"));
        sic.add(new SelectorItemInfo("deprMethod.isCustom"));
        sic.add(new SelectorItemInfo("deprMethod.depValuePolicy"));
        sic.add(new SelectorItemInfo("deprMethod.isWorkload"));
        sic.add(new SelectorItemInfo("deprMethod.id"));
        sic.add(new SelectorItemInfo("deprMethod.number"));
        sic.add(new SelectorItemInfo("deprMethod.name"));
        sic.add(new SelectorItemInfo("addons"));
        sic.add(new SelectorItemInfo("accuDeprChg"));
        sic.add(new SelectorItemInfo("accuDeprAccuChg"));
        sic.add(new SelectorItemInfo("accuDeprAccuClean"));
        sic.add(new SelectorItemInfo("accuDeprChgTYear"));
        sic.add(new SelectorItemInfo("accuDeprAccuChgTYear"));
        sic.add(new SelectorItemInfo("accuDeprAccuCleanTYear"));
        sic.add(new SelectorItemInfo("decValueChg"));
        sic.add(new SelectorItemInfo("decValueAccuChg"));
        sic.add(new SelectorItemInfo("originDif"));
        sic.add(new SelectorItemInfo("originAccuDif"));
        sic.add(new SelectorItemInfo("fairValue"));
        sic.add(new SelectorItemInfo("treatmentIncome"));
        sic.add(new SelectorItemInfo("decValueForDAP"));
        sic.add(new SelectorItemInfo("buyValue"));
        sic.add(new SelectorItemInfo("originAmt"));
        sic.add(new SelectorItemInfo("assetValue"));
        sic.add(new SelectorItemInfo("deprTermCount"));
        sic.add(new SelectorItemInfo("useTermCount"));
        sic.add(new SelectorItemInfo("useYears"));
        sic.add(new SelectorItemInfo("accuDepr"));
        sic.add(new SelectorItemInfo("accuDeprTYear"));
        sic.add(new SelectorItemInfo("accuDeprAll"));
        sic.add(new SelectorItemInfo("deprTTerm"));
        sic.add(new SelectorItemInfo("neatRemValue"));
        sic.add(new SelectorItemInfo("decValue"));
        sic.add(new SelectorItemInfo("neatValue"));
        sic.add(new SelectorItemInfo("neatAmt"));
        sic.add(new SelectorItemInfo("deprTermCount"));
        sic.add(new SelectorItemInfo("initEvalValue"));
        sic.add(new SelectorItemInfo("evalLeftPeriod"));
        sic.add(new SelectorItemInfo("neatLeftRate"));
        sic.add(new SelectorItemInfo("company.baseCurrency.precision"));
        sic.add(new SelectorItemInfo("company.baseCurrency.id"));
        sic.add(new SelectorItemInfo("isInitChange"));
        sic.add(new SelectorItemInfo("leftYear"));
        sic.add(new SelectorItemInfo("LeftYearTwo"));
        sic.add(new SelectorItemInfo("leftYearUp"));
        sic.add(new SelectorItemInfo("deprCount"));
        sic.add(new SelectorItemInfo("lastPeriodCount"));
        sic.add(new SelectorItemInfo("originFlag"));
        sic.add(new SelectorItemInfo("accuDeprForCal"));
        sic.add(new SelectorItemInfo("bizStatus"));
        sic.add(new SelectorItemInfo("checkedStatus"));
        sic.add(new SelectorItemInfo("tempDeprMethod"));
        sic.add(new SelectorItemInfo("tempDeprTermCount"));
        sic.add(new SelectorItemInfo("tempUseTermCount"));
        sic.add(new SelectorItemInfo("useStatus.isDepreciation"));
        sic.add(new SelectorItemInfo("useStatus.id"));
        sic.add(new SelectorItemInfo("period.id"));
        sic.add(new SelectorItemInfo("period.periodYear"));
        sic.add(new SelectorItemInfo("period.periodNumber"));
        sic.add(new SelectorItemInfo("period.isAdjustPeriod"));
        sic.add(new SelectorItemInfo("hasChanged"));
        sic.add(new SelectorItemInfo("hasCleared"));
        sic.add(new SelectorItemInfo("hasEvaled"));
        sic.add(new SelectorItemInfo("hasNew"));
        sic.add(new SelectorItemInfo("hasSplited"));
        sic.add(new SelectorItemInfo("isNeedReDepr"));
        sic.add(new SelectorItemInfo("leaseStatus"));
        sic.add(new SelectorItemInfo("monthDepreRate"));
        sic.add(new SelectorItemInfo("evalDeprMode.number"));
        sic.add(new SelectorItemInfo("evalDeprMode.name"));
        sic.add(new SelectorItemInfo("evalDeprMode.isWorkload"));
        sic.add(new SelectorItemInfo("evalDeprMode.isCustom"));
        sic.add(new SelectorItemInfo("evalDeprMode.depValuePolicy"));
        sic.add(new SelectorItemInfo("evalDeprMode.id"));
        sic.add(new SelectorItemInfo("evalDeprMode.period"));
        sic.add(new SelectorItemInfo("evalDeprPeriodNum"));
        sic.add(new SelectorItemInfo("evalMonthRate"));
        sic.add(new SelectorItemInfo("evalAddDepr"));
        sic.add(new SelectorItemInfo("evalRemValue"));
        sic.add(new SelectorItemInfo("evalYearDepr"));
        sic.add(new SelectorItemInfo("evalDecValue"));
        sic.add(new SelectorItemInfo("evalUseTermCount"));
        sic.add(new SelectorItemInfo("evalNeatValue"));
        sic.add(new SelectorItemInfo("evalNeatAmt"));
        sic.add(new SelectorItemInfo("evalAssetValue"));
        sic.add(new SelectorItemInfo("evalTaxLeftPeriod"));
        sic.add(new SelectorItemInfo("evalDeprTTerm"));
        sic.add(new SelectorItemInfo("evalNeatLeftRate"));
        return sic;
    }

    public static SelectorItemCollection getUserDepSelector(Context ctx, String companyId, String modeId) throws BOSException {
        if (companyId == null) {
            companyId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        }
        String sql = "select sch.FMonDepExpr,sch.FMonDepRateExpr,m.FIsBaseDeprRateTable from t_fa_depreciationmode m inner join t_fa_depreciationscheme sch on sch.FDeprMethodID=m.fid where m.fid in (select distinct FDeprMethodID from t_fa_facurcard where fcompanyid=? and FDeprMethodID is not null)";
        if (modeId != null) {
            sql = "select sch.FMonDepExpr,sch.FMonDepRateExpr,m.FIsBaseDeprRateTable from t_fa_depreciationmode m inner join t_fa_depreciationscheme sch on sch.FDeprMethodID=m.fid where m.fid = ?";
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{modeId == null ? companyId : modeId});
        Vector<String> set = new Vector<String>();
        try {
            while (rs.next()) {
                String monDepExpr = rs.getString(1);
                String monDepRate = rs.getString(2);
                boolean isBaseDeprRateTable = rs.getBoolean(3);
                Pattern p = Pattern.compile("__src(\\.\\w+)+");
                Matcher m = p.matcher(monDepExpr);
                while (m.find()) {
                    set.add(m.group().substring("__src.".length()));
                }
                if (isBaseDeprRateTable) continue;
                m = p.matcher(monDepRate);
                while (m.find()) {
                    set.add(m.group().substring("__src.".length()));
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        for (int i = 0; i < set.size(); ++i) {
            sic.add(new SelectorItemInfo(set.get(i).toString()));
        }
        return sic;
    }

    public static boolean isUseWorkflow(Context ctx, String companyId) throws EASBizException, BOSException {
        if (companyId == null) {
            if (ctx == null) {
                companyId = SysContext.getSysContext().getCurrentFIUnit() == null ? null : SysContext.getSysContext().getCurrentFIUnit().getId().toString();
            } else {
                String string = companyId = ContextUtil.getCurrentFIUnit((Context)ctx) == null ? null : ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
            }
            if (companyId == null) {
                return false;
            }
        }
        HashMap<String, ObjectUuidPK> paramKeyMap = new HashMap<String, ObjectUuidPK>();
        paramKeyMap.put("FA_018", new ObjectUuidPK(companyId));
        HashMap result = ParamManager.getParamHashMap((Context)ctx, paramKeyMap);
        String _useWorkflow = result.get("FA_018") == null ? null : result.get("FA_018").toString();
        return _useWorkflow == null ? false : Boolean.valueOf(_useWorkflow);
    }

    public static boolean isUseWorkflow(Context ctx, String companyId, Class cls) throws EASBizException, BOSException {
        boolean rest;
        if (companyId == null) {
            if (ctx == null) {
                companyId = SysContext.getSysContext().getCurrentFIUnit() == null ? null : SysContext.getSysContext().getCurrentFIUnit().getId().toString();
            } else {
                String string = companyId = ContextUtil.getCurrentFIUnit((Context)ctx) == null ? null : ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
            }
            if (companyId == null) {
                return false;
            }
        }
        HashMap<String, ObjectUuidPK> paramKeyMap = new HashMap<String, ObjectUuidPK>();
        paramKeyMap.put("FA_018", new ObjectUuidPK(companyId));
        paramKeyMap.put("FA_102", new ObjectUuidPK(companyId));
        HashMap result = ParamManager.getParamHashMap((Context)ctx, paramKeyMap);
        String _useWorkflow = result.get("FA_018") == null ? null : result.get("FA_018").toString();
        boolean bl = rest = _useWorkflow == null ? false : Boolean.valueOf(_useWorkflow);
        if (rest) {
            if (result.get("FA_102") == null || result.get("FA_102").toString().trim().length() == 0) {
                return false;
            }
            List<String> chgItemList = Arrays.asList(FaManageUtils.parseCheckFlowListParam((String)result.get("FA_102").toString()));
            String simpleName = cls.getName().substring(cls.getName().lastIndexOf(".") + 1);
            if (simpleName.equalsIgnoreCase("FaLeaseBalanceUI")) {
                return chgItemList.contains("FaLeaseBill");
            }
            if (simpleName.equalsIgnoreCase("FaLeaseInListUI") || simpleName.equalsIgnoreCase("FaLeaseInEditUI") || simpleName.equalsIgnoreCase("FaLeaseInBillControllerBean")) {
                return chgItemList.contains("FaLeaseInBill");
            }
            if (cls.getName().indexOf("FaMortagBill") > 0) {
                return rest;
            }
            return chgItemList.contains(simpleName.replaceAll("ListUI(.*)", "").replaceAll("EditUI(.*)", "").replaceAll("ControllerBean(.*)", "").replaceAll("UI(.*)", ""));
        }
        return false;
    }

    public static boolean isFaReferedId(Context ctx, String parentId, BOSObjectType type) throws BOSException {
        if (parentId == null) {
            return false;
        }
        String[] companyFieldArray = new String[]{"company"};
        String[] adminFieldArray = new String[]{"department", "dept"};
        String[] asstActFieldArray = new String[]{"asstActItem"};
        String faPreFix = "T_FA_";
        CompanyOrgUnit comany = new CompanyOrgUnit();
        AdminOrgUnit admin = new AdminOrgUnit();
        AsstActType asstType = new AsstActType();
        if (comany.getType().equals((Object)type)) {
            String[] exCludeTable = new String[]{"T_FA_FAEVALACCOUNTBALANCE"};
            return FaManageUtils.isReffered(ctx, companyFieldArray, parentId, faPreFix, exCludeTable);
        }
        if (admin.getType().equals((Object)type)) {
            String[] exCludeTable = new String[]{"T_FA_FAEVALDEPDISTRIBUTE", "T_FA_FAEVALDEPASSTACTCOMPOSIT"};
            return FaManageUtils.isReffered(ctx, asstActFieldArray, parentId, faPreFix, exCludeTable) || FaManageUtils.isDefProReffered(ctx, parentId);
        }
        if (asstType.getType().equals((Object)type)) {
            String[] exCludeTable = new String[]{"T_FA_AssistActItem"};
            return FaManageUtils.isReffered(ctx, asstActFieldArray, parentId, faPreFix, exCludeTable);
        }
        return false;
    }

    public static boolean isReffered(Context ctx, String[] fieldNameArray, String parentId, String preFix, String[] exCludeTable) throws BOSException {
        if (null == fieldNameArray || fieldNameArray.length == 0) {
            return false;
        }
        for (int i = 0; i < fieldNameArray.length; ++i) {
            List faTableList = FaManageUtils.getTableList(ctx, fieldNameArray[i], preFix);
            for (int j = 0; j < faTableList.size(); ++j) {
                String[] tableWithColumn = (String[])faTableList.get(j);
                String tableName = tableWithColumn[0];
                String fieldName = tableWithColumn[1];
                if (FaManageUtils.containsElenet(exCludeTable, tableName)) continue;
                String sqlQuery = "select  " + fieldName + " from " + tableName + " where " + fieldName + " =? ";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlQuery, (Object[])new Object[]{parentId});
                if (rs.size() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public static void updateFaRefIds(Context ctx, String subId, String parentId, BOSObjectType type) throws BOSException {
        if (parentId == null) {
            return;
        }
        String[] companyFieldArray = new String[]{"company"};
        String[] adminFieldArray = new String[]{"department", "admin", "dept"};
        String[] asstActFieldArray = new String[]{"asstActItem"};
        String faPreFix = "T_FA_";
        CompanyOrgUnit comany = new CompanyOrgUnit();
        AdminOrgUnit admin = new AdminOrgUnit();
        AsstActType asstType = new AsstActType();
        if (comany.getType().equals((Object)type)) {
            String[] exCludeTable = new String[]{"T_FA_FAEVALACCOUNTBALANCE"};
            FaManageUtils.updateRefIds(ctx, companyFieldArray, subId, parentId, faPreFix, exCludeTable);
        } else if (admin.getType().equals((Object)type)) {
            Map ortType = FaManageUtils.getTypeMap();
            boolean canUpdate = FaManageUtils.checkForUpdate(ctx, ortType, parentId, subId);
            if (canUpdate) {
                String[] exCludeTable = new String[]{"T_FA_FAEVALDEPDISTRIBUTE", "T_FA_FAEVALDEPASSTACTCOMPOSIT"};
                FaManageUtils.updateRefIds(ctx, asstActFieldArray, subId, parentId, faPreFix, exCludeTable);
                FaManageUtils.updateDefProRefIds(ctx, subId, parentId);
            }
        } else if (asstType.getType().equals((Object)type)) {
            FaManageUtils.updateRefIds(ctx, asstActFieldArray, subId, parentId, faPreFix);
        }
    }

    public static Map getTypeMap() {
        HashMap<String, String> typeMap = new HashMap<String, String>();
        typeMap.put("adminOrg", OrgType.Admin.getName());
        typeMap.put("costOrg", OrgType.CostCenter.getName());
        typeMap.put("companyOrg", OrgType.Company.getName());
        typeMap.put("saleOrg", OrgType.Sale.getName());
        typeMap.put("profitOrg", OrgType.ProfitCenter.getName());
        typeMap.put("purchaseOrg", OrgType.Purchase.getName());
        typeMap.put("storeageOrg", OrgType.Storage.getName());
        typeMap.put("orgUnit", OrgType.ControlUnit.getName());
        return typeMap;
    }

    public static boolean checkForUpdate(Context ctx, Map typeMap, String parentId, String id) throws BOSException {
        boolean canUpdate = false;
        StringBuffer sbSql = new StringBuffer(50);
        String orgTypeStr = "";
        try {
            FullOrgUnitInfo unitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(id));
            if (unitInfo != null) {
                orgTypeStr = unitInfo.getOrgTypeStr();
            }
            sbSql.append(" select distinct q.fasstactitem as fasstactitem, q.fasstacttype as fasstacttype, m.fassthgattribute as fassthgattribute \n");
            sbSql.append("  from t_fa_facurcard t \n");
            sbSql.append("  inner join T_FA_FaCurCostCenter p on t.fid = p.ffacurcardid \n");
            sbSql.append("  inner join t_fa_facurasstactcomposit q  on p.fid = q.ffacurcostcenterid \n");
            sbSql.append("  inner join t_bd_asstacttype m on q.fasstacttype = m.fid \n");
            sbSql.append("  where q.fasstactitem = ? \n");
            sbSql.append("  and t.fdeletedstatus = ? \n");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString(), (Object[])new Object[]{parentId, DeletedStatusEnum.NORMAL.getValue()});
            while (rs.next()) {
                String asstHGAttribute = rs.getString("fassthgattribute");
                String orgType = (String)typeMap.get(asstHGAttribute);
                if (orgTypeStr.indexOf(orgType) != -1 && !orgType.equals("CostCenter")) {
                    canUpdate = true;
                    continue;
                }
                canUpdate = false;
            }
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        return canUpdate;
    }

    public static List getTableList(Context ctx, String fieldName, String preFix) throws BOSException {
        String selectSql = "select KSQL_COL_TABNAME,KSQL_COL_NAME from KSQL_USERCOLUMNS where KSQL_COL_TABNAME like  '" + preFix + "%' and KSQL_COL_NAME like '%" + fieldName + "%' and  KSQL_COL_NAME not  like 'FHASDEPARTMENTCHANGED' ";
        ArrayList<String[]> tableList = new ArrayList<String[]>();
        try {
            IRowSet tableSet = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            while (tableSet.next()) {
                String[] tableWithColumn = new String[]{tableSet.getString("KSQL_COL_TABNAME").trim(), tableSet.getString("KSQL_COL_NAME").trim()};
                if (tableWithColumn[0] == null || tableWithColumn[1] == null) continue;
                tableList.add(tableWithColumn);
            }
        }
        catch (Exception e) {
            tableList = new ArrayList();
        }
        return tableList;
    }

    public static void updateRefIds(Context ctx, String[] fieldNameArray, String subId, String parentId, String preFix, String[] exCludeTable) throws BOSException {
        if (null == fieldNameArray || fieldNameArray.length == 0) {
            return;
        }
        for (int i = 0; i < fieldNameArray.length; ++i) {
            List faTableList = FaManageUtils.getTableList(ctx, fieldNameArray[i], preFix);
            for (int j = 0; j < faTableList.size(); ++j) {
                String[] tableWithColumn = (String[])faTableList.get(j);
                String tableName = tableWithColumn[0];
                String fieldName = tableWithColumn[1];
                if (FaManageUtils.containsElenet(exCludeTable, tableName)) continue;
                String sqlUpdate = "update " + tableName + " set  " + fieldName + "=? where " + fieldName + " =? ";
                DbUtil.execute((Context)ctx, (String)sqlUpdate, (Object[])new Object[]{subId, parentId});
            }
        }
    }

    public static void updateRefIds(Context ctx, String[] fieldNameArray, String subId, String parentId, String preFix) throws BOSException {
        FaManageUtils.updateRefIds(ctx, fieldNameArray, subId, parentId, preFix, new String[0]);
    }

    private static boolean containsElenet(String[] exCludeTable, String tableName) {
        if (exCludeTable != null && exCludeTable.length > 0) {
            for (int k = 0; k < exCludeTable.length; ++k) {
                if (!tableName.trim().equalsIgnoreCase(exCludeTable[k].trim())) continue;
                return true;
            }
        }
        return false;
    }

    private static Set getRefferedFaDefProperty(Context ctx) throws BOSException {
        HashSet<String> numberSet = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select def.fnumber from T_FA_FaDefProperty as def ");
        sql.append(" left outer join T_BD_AsstActType as aType on def.fasstacttypeid=aType.fid ");
        sql.append(" where aType.frealtiondataobject='T_ORG_Admin' ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs != null && rs.next()) {
                numberSet.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return numberSet;
    }

    private static boolean isDefProReffered(Context ctx, String parentId) throws BOSException {
        Set numberSet = FaManageUtils.getRefferedFaDefProperty(ctx);
        StringBuffer where = new StringBuffer();
        Iterator iterator = numberSet.iterator();
        while (iterator.hasNext()) {
            where.append("or F").append(((String)iterator.next()).trim()).append("='").append(parentId).append("' ");
        }
        String sql = "select top 1 fid from T_FA_FaDefPropertyValue where " + where.toString().substring(2);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs != null && rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    private static void updateDefProRefIds(Context ctx, String subId, String parentId) throws BOSException {
        Set numberSet = FaManageUtils.getRefferedFaDefProperty(ctx);
        Iterator iterator = numberSet.iterator();
        while (iterator.hasNext()) {
            String fieldName = "F" + ((String)iterator.next()).trim();
            String sqlUpdate = "update T_FA_FaDefPropertyValue set  " + fieldName + "=? where " + fieldName + " =? ";
            DbUtil.execute((Context)ctx, (String)sqlUpdate, (Object[])new Object[]{subId, parentId});
        }
    }

    public static boolean isDisPlayDeptLName(Context ctx) throws BOSException {
        Object isDisPlayLName;
        if (ctx == null) {
            return false;
        }
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        HashMap hmParam = null;
        boolean isUseDeptLName = false;
        try {
            HashMap<String, BOSUuid> paramKeyMap = new HashMap<String, BOSUuid>();
            paramKeyMap.put("FA_025", aCompanyOrgUnitInfo.getId());
            hmParam = ParamManager.getParamHashMap((Context)ctx, paramKeyMap);
        }
        catch (EASBizException e) {
            hmParam = null;
        }
        if (hmParam != null && (isDisPlayLName = hmParam.get("FA_025")) != null) {
            isUseDeptLName = Boolean.valueOf(isDisPlayLName.toString());
        }
        return isUseDeptLName;
    }

    public static boolean isEnableOneNumberRule(Context ctx, HashMap hm) throws EASBizException, BOSException {
        Object isUseOneNumber;
        HashMap hmParam = hm;
        if (hmParam == null) {
            CompanyOrgUnitInfo aCompanyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
            hmParam = FaManageUtils.getFAParameter(aCompanyOrgUnitInfo.getId(), ctx);
        }
        boolean isUSEOneRule = (isUseOneNumber = hmParam.get("FA_033")) != null && Boolean.valueOf(isUseOneNumber.toString()) != false;
        return isUSEOneRule;
    }

    public static String[] getDispatchByCardItemDefault() {
        return dispatchByCardItemDefault;
    }

    public static String[] getDispatchByCardItem() {
        return dispatchByCardItem;
    }

    public static String[] getOuIsolateItem() {
        return ouIsolateItem;
    }

    public static String[] getDispatchByCardselector() {
        return dispatchByCardselector;
    }

    public static CompanyOrgUnitInfo getCurrentCompany(Context ctx, String companyId) throws EASBizException, BOSException {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("accountPeriodType.id"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        sic.add(new SelectorItemInfo("reportCurrency.id"));
        sic.add(new SelectorItemInfo("reportCurrency.number"));
        sic.add(new SelectorItemInfo("reportCurrency.name"));
        sic.add(new SelectorItemInfo("baseExchangeTable.id"));
        sic.add(new SelectorItemInfo("reportExchangeTable.id"));
        sic.add(new SelectorItemInfo("accountTable.id"));
        ICompanyOrgUnit iCompanyOrgUnit = null;
        iCompanyOrgUnit = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        aCompanyOrgUnitInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), sic);
        return aCompanyOrgUnitInfo;
    }

    public static Date getAccountDate(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        PeriodInfo aPeriodInfo = null;
        Date today = new Date(System.currentTimeMillis());
        aPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)company);
        if (aPeriodInfo == null) {
            return today;
        }
        if (today.before(aPeriodInfo.getBeginDate())) {
            today = aPeriodInfo.getBeginDate();
        }
        if (today.after(aPeriodInfo.getEndDate())) {
            today = aPeriodInfo.getEndDate();
        }
        return today;
    }

    public static String getCardImageUrl(Set idSet, UserInfo user) throws BOSException, EASBizException {
        String url = null;
        ArrayList list = new ArrayList(idSet);
        try {
            url = BillImageFacadeFactory.getRemoteInstance().getImageURL((String)list.get(0), false, false);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return url;
    }

    public static BillImageMapCollection getBillMapImageColl(Set billIdSet) throws BOSException {
        FilterInfo mapFilter = new FilterInfo();
        mapFilter.getFilterItems().add(new FilterItemInfo("billID", (Object)billIdSet, CompareType.INCLUDE));
        return BillImageMapFactory.getRemoteInstance().getBillImageMapCollection(EntityViewInfo.getInstance((FilterInfo)mapFilter, null, null));
    }

    public static FaPeriodCloseJobInfo getPeriodCloseJob(Context ctx, FilterInfo filter) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("faPeriod.*"));
        sic.add(new SelectorItemInfo("periodNumber"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("faMonCard"));
        sic.add(new SelectorItemInfo("faMonInitDataInit"));
        sic.add(new SelectorItemInfo("faMonFacility"));
        sic.add(new SelectorItemInfo("faMonDepartment"));
        sic.add(new SelectorItemInfo("faMonCostCenter"));
        sic.add(new SelectorItemInfo("faMonAsstActComposit"));
        sic.add(new SelectorItemInfo("faAccountBalance"));
        sic.add(new SelectorItemInfo("srcFunction"));
        view.setSelector(sic);
        IFaPeriodCloseJob iFaPeriodCloseJob = null;
        iFaPeriodCloseJob = ctx == null ? FaPeriodCloseJobFactory.getRemoteInstance() : FaPeriodCloseJobFactory.getLocalInstance(ctx);
        FaPeriodCloseJobCollection coll = iFaPeriodCloseJob.getFaPeriodCloseJobCollection(view);
        if (coll.size() > 1) {
            throw new IllegalArgumentException("getFaPeriodCloseJobCollection size > 1, error!");
        }
        return coll.size() > 0 ? coll.get(0) : null;
    }

    public static int subDate(Date date1, Date date2) {
        Calendar cld1 = Calendar.getInstance();
        Calendar cld2 = Calendar.getInstance();
        cld1.setTime(date1);
        cld2.setTime(date2);
        cld1.set(cld1.get(1), cld1.get(2), cld1.get(5), 0, 0, 0);
        cld2.set(cld2.get(1), cld2.get(2), cld2.get(5), 0, 0, 0);
        return (int)((cld1.getTimeInMillis() - cld2.getTimeInMillis()) / 86400000L);
    }

    public static int subMonth(Date date1, Date date2) {
        Calendar cld1 = Calendar.getInstance();
        Calendar cld2 = Calendar.getInstance();
        cld1.setTime(date1);
        cld2.setTime(date2);
        return (cld1.get(1) - cld2.get(1)) * 12 + cld1.get(2) - cld2.get(2);
    }

    public static Date getFirstImplDateClient() {
        int is2021 = 0;
        try {
            is2021 = FaManageUtils.getIntFaParamValue(null, "NLM_305", SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
        }
        catch (EASBizException e) {
            logger.error((Object)("getFirstImplDateClient:" + e.getMessage()));
        }
        catch (BOSException e) {
            logger.error((Object)("getFirstImplDateClient:" + e.getMessage()));
        }
        Calendar cld = Calendar.getInstance();
        if (is2021 == 0) {
            cld.set(2021, 0, 1, 0, 0, 0);
        } else {
            cld.set(2019, 0, 1, 0, 0, 0);
        }
        cld.set(14, 0);
        return cld.getTime();
    }

    public static Date getFirstImplDateServer(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo) {
        int is2021 = 0;
        try {
            is2021 = FaManageUtils.getIntFaParamValue(ctx, "NLM_305", companyOrgUnitInfo.getId().toString());
        }
        catch (EASBizException e) {
            logger.error((Object)("getFirstImplDateClient:" + e.getMessage()));
        }
        catch (BOSException e) {
            logger.error((Object)("getFirstImplDateClient:" + e.getMessage()));
        }
        Calendar cld = Calendar.getInstance();
        if (is2021 == 0) {
            cld.set(2021, 0, 1, 0, 0, 0);
        } else {
            cld.set(2019, 0, 1, 0, 0, 0);
        }
        cld.set(14, 0);
        return cld.getTime();
    }

    public static int comparePeriods(PeriodInfo firstPeriod, PeriodInfo secondPeriod) {
        Integer firstNumber = FaManageUtils.changePeriodString2Int(firstPeriod);
        Integer secondNumber = FaManageUtils.changePeriodString2Int(secondPeriod);
        return firstNumber.compareTo(secondNumber);
    }

    public static Integer changePeriodString2Int(PeriodInfo period) {
        String year = period.getPeriodYear() + "";
        String month = period.getPeriodNumber() + "";
        String intNumber = "";
        intNumber = period.getPeriodNumber() >= 10 ? year + month : year + "0" + month;
        return Integer.valueOf(intNumber);
    }
}

