/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOtherDealSealUp;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class FaOrgBizChecker
implements IOtherDealSealUp {
    private static Logger logger = Logger.getLogger((String)FaOrgBizChecker.class.getName());

    public void ouSealUp(Context ctx, String id) throws BOSException, EASBizException {
    }

    public void ouUnSealUp(Context ctx, String id) throws BOSException, EASBizException {
    }

    public void bizSealUp(Context ctx, String id, int oryType) throws BOSException, EASBizException {
        FullOrgUnitInfo unitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(id));
        OrgType type = OrgType.getEnum((int)oryType);
        if (unitInfo != null && type.getValue() == 0) {
            boolean isCardQuoteOne = false;
            boolean isCardQuoteTwo = false;
            boolean isCardQuoteThree = false;
            StringBuffer companyNumberAndNameOne = new StringBuffer();
            StringBuffer companyNumberAndNameTwo = new StringBuffer();
            StringBuffer companyNumberAndNameThree = new StringBuffer();
            try {
                IRowSet resultOne = DbUtil.executeQuery((Context)ctx, (String)this.getFirstCondition().toString(), (Object[])new Object[]{14, unitInfo.getId().toString(), unitInfo.getId().toString(), 2, 2});
                IRowSet resultTwo = DbUtil.executeQuery((Context)ctx, (String)this.getSecondCondition(type).toString(), (Object[])new Object[]{14, unitInfo.getId().toString(), 2, 2});
                IRowSet resultThree = DbUtil.executeQuery((Context)ctx, (String)this.getTreadCondition(type).toString(), (Object[])new Object[]{14, unitInfo.getId().toString()});
                if (resultOne.next()) {
                    isCardQuoteOne = true;
                }
                if (resultTwo.next()) {
                    isCardQuoteTwo = true;
                }
                if (resultThree.next()) {
                    isCardQuoteThree = true;
                }
                this.splicingData(resultOne, companyNumberAndNameOne);
                this.splicingData(resultTwo, companyNumberAndNameTwo);
                this.splicingData(resultThree, companyNumberAndNameThree);
            }
            catch (Exception e) {
                logger.error((Object)"+++++++++++++++++++");
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new EASBizException(new NumericExceptionSubItem("1", "Error:" + e.getMessage().toString()));
            }
            if (isCardQuoteOne) {
                throw new FaCardException(FaCardException.CURCARD_HAS_QUOTE3, new String[]{companyNumberAndNameOne.toString()});
            }
            if (isCardQuoteTwo) {
                throw new FaCardException(FaCardException.CURCARD_HAS_QUOTE, new String[]{companyNumberAndNameTwo.toString()});
            }
            if (isCardQuoteThree) {
                throw new FaCardException(FaCardException.CURCARD_HAS_QUOTE2, new String[]{companyNumberAndNameThree.toString()});
            }
        }
        if (unitInfo != null && type.getValue() != 0) {
            boolean isCardQuote = false;
            boolean isCardQuoteThree = false;
            StringBuffer companyNumberAndName = new StringBuffer();
            StringBuffer companyNumberAndNameThree = new StringBuffer();
            try {
                IRowSet result = DbUtil.executeQuery((Context)ctx, (String)this.getSecondCondition(type).toString(), (Object[])new Object[]{14, unitInfo.getId().toString(), 2, 2});
                IRowSet resultThree = DbUtil.executeQuery((Context)ctx, (String)this.getTreadCondition(type).toString(), (Object[])new Object[]{14, unitInfo.getId().toString()});
                if (result.next()) {
                    isCardQuote = true;
                }
                if (resultThree.next()) {
                    isCardQuoteThree = true;
                }
                this.splicingData(result, companyNumberAndName);
                this.splicingData(resultThree, companyNumberAndNameThree);
            }
            catch (Exception e) {
                logger.error((Object)"+++++++++++++++++++");
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new EASBizException(new NumericExceptionSubItem("1", "Error:" + e.getMessage().toString()));
            }
            if (isCardQuote) {
                throw new FaCardException(FaCardException.CURCARD_HAS_QUOTE, new String[]{companyNumberAndName.toString()});
            }
            if (isCardQuoteThree) {
                throw new FaCardException(FaCardException.CURCARD_HAS_QUOTE2, new String[]{companyNumberAndNameThree.toString()});
            }
        }
    }

    public void bizUnSealUp(Context ctx, String id, int oryType) throws BOSException, EASBizException {
    }

    private StringBuffer getFirstCondition() {
        StringBuffer firstCondition = new StringBuffer();
        firstCondition.append(" select distinct company.fid as fid, company.fnumber as fnumber, company.fname_l2 as fname_l2, curcard.FNumber AS number ");
        firstCondition.append(" from t_fa_facurcard curcard ");
        firstCondition.append(" inner join t_org_company company on curcard.fcompanyid = company.fid ");
        firstCondition.append(" inner join t_bd_systemstatusctrol ctrl on ctrl.fcompanyid = company.fid ");
        firstCondition.append(" inner join t_bd_systemstatus ss on ss.fid = ctrl.fsystemstatusid and ss.fname = ? ");
        firstCondition.append(" inner join t_bd_period sysperiod on sysperiod.fid = ctrl.fcurrentperiodid ");
        firstCondition.append(" inner join T_FA_FaCurDepartment department on curcard.fid = department.ffacurcardid ");
        firstCondition.append(" where (curcard.FDEPTID = ? or department.FUseDepartmentID = ?) ");
        firstCondition.append(" and ( ");
        firstCondition.append(" ( curcard.fhascleared <> ? and curcard.FDeletedStatus <> ? ) ");
        firstCondition.append(" or ");
        firstCondition.append(" (sysperiod.fnumber in (\n                select clearbillperiod.fnumber\n        from t_fa_clearbillentry clearbillentry\n        inner join t_fa_clearbill clearbill on clearbill.fid = clearbillentry.fentryid\n        inner join t_bd_period clearbillperiod on clearbillperiod.fid = clearbill.fperiodid\n        where clearbillentry.fcurcardid = curcard.fid ) )");
        firstCondition.append(" ) ");
        return firstCondition;
    }

    private StringBuffer getSecondCondition(OrgType type) {
        StringBuffer secondCondition = new StringBuffer();
        secondCondition.append(" select distinct company.fid as fid, company.fnumber as fnumber, company.fname_l2 as fname_l2, curcard.FNumber AS number, asstActComposit.FASSTACTTYPE as FASSTACTTYPE ");
        secondCondition.append(" from t_fa_facurcard curcard ");
        secondCondition.append(" inner join t_org_company company on curcard.fcompanyid = company.fid ");
        secondCondition.append(" inner join t_bd_systemstatusctrol ctrl on ctrl.fcompanyid = company.fid ");
        secondCondition.append(" inner join t_bd_systemstatus ss on ss.fid = ctrl.fsystemstatusid and ss.fname = ? ");
        secondCondition.append(" inner join t_bd_period sysperiod on sysperiod.fid = ctrl.fcurrentperiodid ");
        secondCondition.append(" inner join T_FA_FaCurCostCenter costCenter on curcard.fid = costCenter.ffacurcardid ");
        secondCondition.append(" inner join T_FA_FaCurAsstActComposit asstActComposit on costCenter.fid = asstActComposit.ffacurcostcenterid ");
        secondCondition.append(" inner join T_BD_AsstActType asstActType on asstActType.fid=asstActComposit.FASSTACTTYPE ");
        secondCondition.append(" where asstActComposit.fasstactitem = ? ");
        if (type.getValue() == 0) {
            secondCondition.append(" and asstActType.frealtionDataObject='T_ORG_Admin' ");
        }
        if (type.getValue() == 1) {
            secondCondition.append(" and asstActType.frealtionDataObject='T_ORG_Company' ");
        }
        if (type.getValue() == 5) {
            secondCondition.append(" and asstActType.frealtionDataObject='T_ORG_CostCenter' ");
        }
        secondCondition.append(" and ( ");
        secondCondition.append(" ( curcard.fhascleared <> ? and curcard.FDeletedStatus <> ? ) ");
        secondCondition.append(" or ");
        secondCondition.append(" (sysperiod.fnumber in (\n                select clearbillperiod.fnumber\n        from t_fa_clearbillentry clearbillentry\n        inner join t_fa_clearbill clearbill on clearbill.fid = clearbillentry.fentryid\n        inner join t_bd_period clearbillperiod on clearbillperiod.fid = clearbill.fperiodid\n        where clearbillentry.fcurcardid = curcard.fid ) )");
        secondCondition.append(" ) ");
        return secondCondition;
    }

    private StringBuffer getTreadCondition(OrgType type) {
        StringBuffer treadCondition = new StringBuffer();
        treadCondition.append(" select distinct company.fid as fid, company.fnumber as fnumber, company.fname_l2 as fname_l2, bakcard.FNumber AS number ");
        treadCondition.append(" from t_fa_fabakcard bakcard ");
        treadCondition.append(" inner join t_org_company company on bakcard.fcompanyid = company.fid ");
        treadCondition.append(" inner join t_bd_systemstatusctrol ctrl on ctrl.fcompanyid = company.fid ");
        treadCondition.append(" inner join t_bd_systemstatus ss on ss.fid = ctrl.fsystemstatusid and ss.fname = ? ");
        treadCondition.append(" inner join t_bd_period sysperiod on sysperiod.fid = ctrl.fcurrentperiodid ");
        treadCondition.append(" inner join T_FA_FaBakCostCenter costCenter on bakcard.fid = costCenter.ffabakcardid ");
        treadCondition.append(" inner join T_FA_FaBakAsstActComposit asstActComposit on costCenter.fid = asstActComposit.ffabakcostcenterid ");
        treadCondition.append(" inner join T_FA_Cat cat on bakcard.FAssetCatId = cat.fid ");
        treadCondition.append(" inner join T_FA_DepreciationPolicy DepreciationPolicy on cat.FDepreciationPolicyID = DepreciationPolicy.fid ");
        treadCondition.append(" inner join T_BD_AsstActType asstActType on asstActType.fid=asstActComposit.FASSTACTTYPE ");
        treadCondition.append(" where asstActComposit.fasstactitem = ? ");
        if (type.getValue() == 0) {
            treadCondition.append(" and asstActType.frealtionDataObject='T_ORG_Admin' ");
        }
        if (type.getValue() == 1) {
            treadCondition.append(" and asstActType.frealtionDataObject='T_ORG_Company' ");
        }
        if (type.getValue() == 5) {
            treadCondition.append(" and asstActType.frealtionDataObject='T_ORG_CostCenter' ");
        }
        treadCondition.append(" and DepreciationPolicy.FCostCenterChange = 0 ");
        treadCondition.append(" and sysperiod.fnumber in  ");
        treadCondition.append(" ( select changebillperiod.fnumber\n          from t_fa_fachangebillentry changebillentry\n          inner join t_fa_fachangebill changebill on changebill.fid = changebillentry.fchangebillid\n          inner join t_bd_period changebillperiod on changebillperiod.fid = changebill.fperiodid\n          where changebillentry.fcurcardid = bakcard.ffacurcardid )\n ");
        return treadCondition;
    }

    private void splicingData(IRowSet result, StringBuffer companyNumberAndName) throws SQLException {
        result.beforeFirst();
        while (result.next()) {
            String number = result.getString("fnumber");
            String name = result.getString("fname_l2");
            companyNumberAndName.append("\n").append(number).append("---").append(name);
        }
    }
}

