/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaAccountBalanceCollection;
import com.kingdee.eas.fi.fa.manage.FaAccountBalanceFactory;
import com.kingdee.eas.fi.fa.manage.FaAccountBalanceInfo;
import com.kingdee.eas.fi.fa.manage.IFaAccountBalance;
import com.kingdee.eas.framework.BillBaseInfo;
import java.math.BigDecimal;

public abstract class AbstractFaBalanceUpdStrategy {
    protected static final BigDecimal zeroValue = new BigDecimal(0);

    protected String getFaCardID(BillBaseInfo billInfo) {
        return billInfo.getId().toString();
    }

    protected String getCompanyID(BillBaseInfo billInfo) {
        return billInfo.getCompany().getId().toString();
    }

    protected IFaAccountBalance getAFaAcctBalanceInstance(Context ctx) throws BOSException, EASBizException {
        IFaAccountBalance faAccountBalance = null;
        faAccountBalance = FaAccountBalanceFactory.getLocalInstance(ctx);
        return faAccountBalance;
    }

    protected BigDecimal calcRealEndBalanceFor(FaAccountBalanceInfo faActBalanceInfo) {
        BigDecimal realBeginBalanceFor = new BigDecimal(0);
        if (faActBalanceInfo.getRealBeginBalanceFor() != null) {
            realBeginBalanceFor = faActBalanceInfo.getRealBeginBalanceFor();
        }
        BigDecimal realDebitFor = new BigDecimal(0);
        if (faActBalanceInfo.getRealDebitFor() != null) {
            realDebitFor = faActBalanceInfo.getRealDebitFor();
        }
        BigDecimal realCreditFor = new BigDecimal(0);
        if (faActBalanceInfo.getRealCreditFor() != null) {
            realCreditFor = faActBalanceInfo.getRealCreditFor();
        }
        BigDecimal returnValue = realBeginBalanceFor.add(realDebitFor).subtract(realCreditFor);
        return returnValue;
    }

    protected BigDecimal calcDepreEndBalanceFor(FaAccountBalanceInfo faActBalanceInfo) {
        BigDecimal depreBeginBalanceFor = new BigDecimal(0);
        if (faActBalanceInfo.getDepreBeginBalanceFor() != null) {
            depreBeginBalanceFor = faActBalanceInfo.getDepreBeginBalanceFor();
        }
        BigDecimal depreDebitFor = new BigDecimal(0);
        if (faActBalanceInfo.getDepreDebitFor() != null) {
            depreDebitFor = faActBalanceInfo.getDepreDebitFor();
        }
        BigDecimal depreCreditFor = new BigDecimal(0);
        if (faActBalanceInfo.getDepreCreditFor() != null) {
            depreCreditFor = faActBalanceInfo.getDepreCreditFor();
        }
        BigDecimal returnValue = depreBeginBalanceFor.subtract(depreDebitFor).add(depreCreditFor);
        return returnValue;
    }

    protected BigDecimal calcDecValueEndBalanceFor(FaAccountBalanceInfo faActBalanceInfo) {
        BigDecimal decValueBeginBalanceFor = new BigDecimal(0);
        if (faActBalanceInfo.getDecValueBeginBalanceFor() != null) {
            decValueBeginBalanceFor = faActBalanceInfo.getDecValueBeginBalanceFor();
        }
        BigDecimal decValueDebitFor = new BigDecimal(0);
        if (faActBalanceInfo.getDecValueDebitFor() != null) {
            decValueDebitFor = faActBalanceInfo.getDecValueDebitFor();
        }
        BigDecimal decValueCreditFor = new BigDecimal(0);
        if (faActBalanceInfo.getDecValueCreditFor() != null) {
            decValueCreditFor = faActBalanceInfo.getDecValueCreditFor();
        }
        BigDecimal returnValue = decValueBeginBalanceFor.subtract(decValueDebitFor).add(decValueCreditFor);
        return returnValue;
    }

    protected BigDecimal calcEvalueEndBalanceFor(FaAccountBalanceInfo faActBalanceInfo) {
        BigDecimal evalueBeginBalanceFor = new BigDecimal(0);
        if (faActBalanceInfo.getEvalueBeginBalanceFor() != null) {
            evalueBeginBalanceFor = faActBalanceInfo.getEvalueBeginBalanceFor();
        }
        BigDecimal evalueDebitFor = new BigDecimal(0);
        if (faActBalanceInfo.getEvalueDebitFor() != null) {
            evalueDebitFor = faActBalanceInfo.getEvalueDebitFor();
        }
        BigDecimal evalueCreditFor = new BigDecimal(0);
        if (faActBalanceInfo.getEvalueCreditFor() != null) {
            evalueCreditFor = faActBalanceInfo.getEvalueCreditFor();
        }
        BigDecimal returnValue = evalueBeginBalanceFor.add(evalueDebitFor).subtract(evalueCreditFor);
        return returnValue;
    }

    protected FaAccountBalanceInfo getFaAcctBalanceByCurCard(Context ctx, String curCardID, String companyID, PeriodInfo periodInfo) throws BOSException, EASBizException {
        IFaAccountBalance faAccountBalance = null;
        faAccountBalance = FaAccountBalanceFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("faCurCard", (Object)curCardID));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)periodInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit", (Object)companyID));
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        FaAccountBalanceCollection faAcctBalanceCol = faAccountBalance.getFaAccountBalanceCollection(evi);
        if (faAcctBalanceCol.size() > 0) {
            FaAccountBalanceInfo faAcctInfo = faAcctBalanceCol.get(0);
            if (faAcctInfo != null) {
                BigDecimal bZero = new BigDecimal(0.0);
                String[] strKey = new String[]{"decValueBeginBalanceFor", "decValueCreditFor", "decValueDebitFor", "decValueEndBalanceFor", "depreBeginBalanceFor", "depreCreditFor", "depreDebitFor", "depreEndBalanceFor", "depreTerm", "evalueBeginBalanceFor", "evalueCreditFor", "evalueDebitFor", "evalueEndBalanceFor", "realBeginBalanceFor", "realCreditFor", "realDebitFor", "realEndBalanceFor"};
                for (int i = 0; i < strKey.length; ++i) {
                    faAcctInfo.put(strKey[i], faAcctInfo.get(strKey[i]) == null ? bZero : faAcctInfo.get(strKey[i]));
                }
                return faAcctInfo;
            }
            return null;
        }
        return null;
    }

    public abstract FaAccountBalanceCollection proc4UpdateFaBalance(Context var1, BillBaseInfo var2, PeriodInfo var3) throws BOSException, EASBizException;

    public abstract FaAccountBalanceCollection proc4RollbackFaBalance(Context var1, BillBaseInfo var2, PeriodInfo var3) throws BOSException, EASBizException;
}

