/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FALeaseContractException;
import com.kingdee.eas.fi.fa.manage.FALeaseContractInfo;
import com.kingdee.eas.fi.fa.manage.FaBillBizProcessor;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.FaLeaseBillCollection;
import com.kingdee.eas.fi.fa.manage.FaLeaseBillFactory;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillCollection;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillFactory;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.app.AbstractFALeaseContractControllerBean;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;

public class FALeaseContractControllerBean
extends AbstractFALeaseContractControllerBean {
    private static final long serialVersionUID = -4737967515964773254L;
    protected static final String FACARDRESOURCE = "com.kingdee.eas.fi.fa.manage.FaCardResource";
    private int recursiveNumber = 0;

    @Override
    protected void _passAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FaBillBizProcessor.lockTable(ctx, pk.toString());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        FALeaseContractInfo billInfo = this.getFALeaseContractInfo(ctx, pk, selector);
        this.checkForAudit(ctx, (IObjectValue)billInfo);
        this._passAuditSelf(ctx, pk);
    }

    private void checkForAudit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        FALeaseContractInfo billInfo = (FALeaseContractInfo)model;
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.getDeletedStatus().equals((Object)DeletedStatusEnum.DELETED)) {
            sbMsg.append(" ");
            sbMsg.append(this.getDeletedStatus(billInfo, ctx));
        }
        if (billInfo.getEffectedStatus().equals((Object)EffectedStatusEnum.TEMPSTORE)) {
            sbMsg.append(" ");
            sbMsg.append(this.getEffectedStatus(billInfo, ctx));
        }
        if (billInfo.getCheckedStatus().equals((Object)CheckedStatusEnum.AUDITED)) {
            sbMsg.append(" ");
            sbMsg.append(this.getCheckedStatus(billInfo, ctx));
        }
        if (sbMsg.toString().length() > 0) {
            String msg = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FALeaseContractResource.thisBill", (Locale)ctx.getOriginLocale(), (Object[])new String[]{billInfo.getNumber()});
            StringTokenizer token = new StringTokenizer(msg, "!");
            StringBuffer sbAll = new StringBuffer(token.nextToken());
            sbAll.append(sbMsg);
            sbAll.append("\n");
            throw new FALeaseContractException(FALeaseContractException.CANNOTBEAUIT, new String[]{sbAll.toString()});
        }
    }

    protected StringBuffer getCheckedStatus(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("checkedStatus").equals(new Integer(2))) {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"CHECKED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    protected StringBuffer getDeletedStatus(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("deletedStatus").equals(new Integer(2))) {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"DELETED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    protected StringBuffer getEffectedStatus(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("effectedStatus").equals(new Integer(2))) {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"EFFECTED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    @Override
    protected void _unpassAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FaBillBizProcessor.lockTable(ctx, pk.toString());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("period.*"));
        FALeaseContractInfo billInfo = this.getFALeaseContractInfo(ctx, pk, selector);
        this.checkForUnAudit(ctx, (IObjectValue)billInfo);
        this._unpassAuditSelf(ctx, pk);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FaBillBizProcessor.lockTable(ctx, pk.toString());
        this.checkStateForDel(ctx, pk);
        this._deleteSelf(ctx, pk);
    }

    protected void checkStateForDel(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        FALeaseContractInfo billInfo = this.getFALeaseContractInfo(ctx, pk, selector);
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.getCheckedStatus().equals((Object)CheckedStatusEnum.AUDITED)) {
            sbMsg.append(" ");
            sbMsg.append(this.getCheckedStatus(billInfo, ctx));
        }
        if (sbMsg.toString().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)FACARDRESOURCE, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append("[" + billInfo.getNumber() + "]");
            sbAll.append(sbMsg);
            sbAll.append("\n");
            throw new FaCardException(FaCardException.CANNOT_BE_DELETED, new String[]{sbAll.toString()});
        }
        if (billInfo.getSourceBillId() != null && billInfo.getSourceBillId().trim().length() != 0) {
            FaLeaseBillCollection bBillColl;
            FaLeaseInBillCollection aBillColl = FaLeaseInBillFactory.getLocalInstance(ctx).getFaLeaseInBillCollection("select id,number where id = '" + billInfo.getSourceBillId() + "'");
            String sourceBillNumber = null;
            boolean isFromLeaseInBill = true;
            if (aBillColl != null && aBillColl.size() != 0) {
                sourceBillNumber = aBillColl.get(0).getNumber();
                isFromLeaseInBill = true;
            }
            if ((bBillColl = FaLeaseBillFactory.getLocalInstance(ctx).getFaLeaseBillCollection("select id,number where id = '" + billInfo.getSourceBillId() + "'")) != null && bBillColl.size() != 0) {
                sourceBillNumber = bBillColl.get(0).getNumber();
                isFromLeaseInBill = false;
            }
            if (sourceBillNumber != null) {
                String aMsg = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FALeaseContractResource", (String)"fromBillGen", (Locale)ctx.getOriginLocale());
                StringTokenizer token = new StringTokenizer(aMsg, "!");
                StringBuffer bMsg = new StringBuffer(token.nextToken() + billInfo.getNumber() + token.nextToken() + sourceBillNumber);
                if (isFromLeaseInBill) {
                    bMsg.append(token.nextToken());
                    token.nextToken();
                    bMsg.append(token.nextToken());
                } else {
                    token.nextToken();
                    bMsg.append(token.nextToken());
                    bMsg.append(token.nextToken());
                }
                throw new FALeaseContractException(FALeaseContractException.FROMBILLGEN, new String[]{bMsg.toString()});
            }
        }
    }

    @Override
    protected void _deleteSelf(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("CU.id"));
        FALeaseContractInfo billInfo = this.getFALeaseContractInfo(ctx, pk, sic);
        this.recycleNumber(ctx, billInfo);
        super._delete(ctx, pk);
    }

    protected void recycleNumber(Context ctx, BillBaseInfo caller) throws EASBizException, BOSException {
        if (caller == null) {
            return;
        }
        caller.setCU(CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select id,CU.id,CU.number,CU.name where id='" + caller.getCompany().getId() + "'").getCU());
        String strCompanyID = caller.getCompany() != null && caller.getCompany().getId() != null ? caller.getCompany().getId().toString() : ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (iCodingRuleManager.getCodingRule((IObjectValue)caller, strCompanyID) != null && iCodingRuleManager.isUseIntermitNumber((IObjectValue)caller, strCompanyID)) {
            if (caller.getNumber() == null) {
                return;
            }
            iCodingRuleManager.recycleNumber((IObjectValue)caller, strCompanyID, caller.getNumber());
        }
    }

    @Override
    protected void _unpassAuditSelf(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("company.id"));
        FALeaseContractInfo billInfo = this.getFALeaseContractInfo(ctx, pk, sic);
        billInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        billInfo.setAuditor(null);
        billInfo.setBizDate(null);
        super._unpassAudit(ctx, pk, (IObjectValue)billInfo);
    }

    protected void checkForUnAudit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        FaLeaseBillCollection bBillColl;
        FALeaseContractInfo billInfo = (FALeaseContractInfo)model;
        StringBuffer sbMsg = new StringBuffer();
        PeriodInfo curPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)ContextUtil.getCurrentFIUnit((Context)ctx));
        PeriodInfo faPeriod = billInfo.getPeriod();
        if (!curPeriod.getId().toString().equals(faPeriod.getId().toString())) {
            sbMsg.append(" ");
            sbMsg.append(ResourceBase.getString((String)FACARDRESOURCE, (String)"NOT_IN_CURPERIOD", (Locale)ctx.getOriginLocale()));
        }
        if (billInfo.getDeletedStatus().equals((Object)DeletedStatusEnum.DELETED)) {
            sbMsg.append(" ");
            sbMsg.append(this.getDeletedStatus(billInfo, ctx));
        }
        if (billInfo.getEffectedStatus().equals((Object)EffectedStatusEnum.TEMPSTORE)) {
            sbMsg.append(" ");
            sbMsg.append(this.getEffectedStatus(billInfo, ctx));
        }
        if (billInfo.getCheckedStatus().equals((Object)CheckedStatusEnum.UNAUDITED)) {
            sbMsg.append(" ");
            sbMsg.append(this.getCheckedStatus(billInfo, ctx));
        }
        if (sbMsg.toString().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)FACARDRESOURCE, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            String tips = billInfo.getNumber();
            sbAll.append(tips + sbMsg);
            sbAll.append("\n");
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, new String[]{"", sbAll.toString()});
        }
        FaLeaseInBillCollection aBillColl = FaLeaseInBillFactory.getLocalInstance(ctx).getFaLeaseInBillCollection("select id,number where bargainNum = '" + billInfo.getNumber() + "' and company.id = '" + billInfo.getCompany().getId().toString() + "'");
        String genBillNumber = null;
        boolean isGenLeaseInBill = true;
        if (aBillColl != null && aBillColl.size() != 0) {
            genBillNumber = aBillColl.get(0).getNumber();
            isGenLeaseInBill = true;
        }
        if ((bBillColl = FaLeaseBillFactory.getLocalInstance(ctx).getFaLeaseBillCollection("select id,number where bargainNum = '" + billInfo.getNumber() + "' and company.id = '" + billInfo.getCompany().getId().toString() + "'")) != null && bBillColl.size() != 0) {
            genBillNumber = bBillColl.get(0).getNumber();
            isGenLeaseInBill = false;
        }
        if (genBillNumber != null) {
            String aMsg = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FALeaseContractResource", (String)"genBill", (Locale)ctx.getOriginLocale());
            StringTokenizer token = new StringTokenizer(aMsg, "!");
            StringBuffer bMsg = new StringBuffer(token.nextToken() + billInfo.getNumber() + token.nextToken() + genBillNumber);
            if (isGenLeaseInBill) {
                bMsg.append(token.nextToken());
                token.nextToken();
                bMsg.append(token.nextToken());
            } else {
                token.nextToken();
                bMsg.append(token.nextToken());
                bMsg.append(token.nextToken());
            }
            throw new FALeaseContractException(FALeaseContractException.HASGENBILL, new String[]{bMsg.toString()});
        }
    }

    @Override
    protected void _passAuditSelf(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("company.id"));
        FALeaseContractInfo billInfo = this.getFALeaseContractInfo(ctx, pk, sic);
        billInfo.setCheckedStatus(CheckedStatusEnum.AUDITED);
        billInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        Date today = DateTimeUtils.truncateDate((Date)new Date());
        billInfo.setBizDate(today);
        super._passAudit(ctx, pk, (IObjectValue)billInfo);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo;
        String pk = model.get("id") == null ? null : model.get("id").toString();
        FaBillBizProcessor.lockTable(ctx, pk);
        FALeaseContractInfo billInfo = (FALeaseContractInfo)model;
        if (billInfo.getId() != null) {
            this.checkSubmit(ctx, (IObjectPK)new ObjectUuidPK(billInfo.getId()));
        }
        if ((aCompanyOrgUnitInfo = billInfo.getCompany()) == null) {
            billInfo.setCompany(ContextUtil.getCurrentFIUnit((Context)ctx));
        }
        if (billInfo.getNumber() == null || billInfo.getNumber().trim().length() == 0 || this.existNumber(ctx, (IObjectValue)billInfo)) {
            this.setNewNumber(ctx, billInfo);
        }
        billInfo.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        return super._submit(ctx, model);
    }

    private void checkSubmit(Context ctx, IObjectPK pk) throws BOSException, EASBizException, FaCardException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("checkedStatus"));
        FALeaseContractInfo billInfo = this.getFALeaseContractInfo(ctx, pk);
        if (CheckedStatusEnum.AUDITED.equals((Object)billInfo.getCheckedStatus())) {
            String msg = this.getCheckedStatus(billInfo, ctx).toString();
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)FACARDRESOURCE, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append(msg);
            sbAll.append("\n");
            throw new FaCardException(FaCardException.CANNOT_BE_EDITED, new String[]{sbAll.toString()});
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo;
        String pk = model.get("id") == null ? null : model.get("id").toString();
        FaBillBizProcessor.lockTable(ctx, pk);
        FALeaseContractInfo billInfo = (FALeaseContractInfo)model;
        if (billInfo.getId() != null) {
            this.checkSave(ctx, (IObjectPK)new ObjectUuidPK(billInfo.getId()));
        }
        if ((aCompanyOrgUnitInfo = billInfo.getCompany()) == null) {
            billInfo.setCompany(ContextUtil.getCurrentFIUnit((Context)ctx));
        }
        if (aCompanyOrgUnitInfo != null) {
            ObjectUuidPK companyPK = new ObjectUuidPK(aCompanyOrgUnitInfo.getId());
            if (billInfo.getPeriod() == null) {
                PeriodInfo aPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (IObjectPK)companyPK);
                billInfo.setPeriod(aPeriodInfo);
            }
        }
        if (billInfo.getNumber() == null || billInfo.getNumber().trim().length() == 0 || this.existNumber(ctx, (IObjectValue)billInfo)) {
            this.setNewNumber(ctx, billInfo);
        }
        billInfo.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        return super._save(ctx, model);
    }

    private void checkSave(Context ctx, IObjectPK pk) throws BOSException, EASBizException, FaCardException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("checkedStatus"));
        FALeaseContractInfo billInfo = this.getFALeaseContractInfo(ctx, pk);
        if (EffectedStatusEnum.EFFECTED.equals((Object)billInfo.getEffectedStatus())) {
            String msg = this.getEffectedStatus(billInfo, ctx).toString();
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)FACARDRESOURCE, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append(msg);
            sbAll.append("\n");
            throw new FaCardException(FaCardException.CANNOT_BE_EDITED, new String[]{sbAll.toString()});
        }
    }

    protected boolean _checkNumberDup(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        if (this.existNumber(ctx, model)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
        return true;
    }

    protected void setNewNumber(Context ctx, FALeaseContractInfo billInfo) throws EASBizException, BOSException {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = billInfo.getCompany();
        if (aCompanyOrgUnitInfo == null) {
            aCompanyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        String strCompanyId = aCompanyOrgUnitInfo.getId().toString();
        String number = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)billInfo, strCompanyId);
        billInfo.setNumber(number);
        if (this.existNumber(ctx, (IObjectValue)billInfo)) {
            ++this.recursiveNumber;
            if (this.recursiveNumber >= 100) {
                this.recursiveNumber = 0;
                throw new FALeaseContractException(FALeaseContractException.CONDINGRULEERROREXCEPTION);
            }
            this.setNewNumber(ctx, billInfo);
        } else {
            this.recursiveNumber = 0;
        }
    }

    protected boolean existNumber(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        FALeaseContractInfo billInfo = (FALeaseContractInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)billInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (billInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)billInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (billInfo.getCompany() != null) {
            filterItem = new FilterItemInfo("company", (Object)billInfo.getCompany().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("company", null, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        StringBuffer sb = new StringBuffer().append("#0");
        int size = filter.getFilterItems().size();
        for (int i = 1; i < size; ++i) {
            sb.append(" and #" + i);
        }
        filter.setMaskString(sb.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        return this._exists(ctx, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        try {
            CompanyOrgUnitInfo comp = (CompanyOrgUnitInfo)model.get("company");
            this.setWorkflowServiceState(ctx, comp == null ? null : comp.getId().toString(), model.getId() == null ? null : model.getId().toString());
            IObjectPK iObjectPK = super.submit(ctx, model);
            return iObjectPK;
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    @Override
    public void passAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            this.setWorkflowServiceState(ctx, pk);
            super.passAudit(ctx, pk);
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    @Override
    public void unpassAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            this.setWorkflowServiceState(ctx, pk);
            super.unpassAudit(ctx, pk);
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            this.setWorkflowServiceState(ctx, pk);
            super.delete(ctx, pk);
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    protected void setWorkflowServiceState(Context ctx, IObjectPK objId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.id"));
        CompanyOrgUnitInfo comp = (CompanyOrgUnitInfo)this.getValue(ctx, objId, sic).get("company");
        this.setWorkflowServiceState(ctx, comp.getId().toString(), objId.toString());
    }

    protected void setWorkflowServiceState(Context ctx, String companyId, String objId) throws BOSException, EASBizException {
        boolean isUseWorkflow = FaManageUtils.isUseWorkflow(ctx, companyId, this.getClass());
        if (!isUseWorkflow && (objId == null || objId != null && !FaLocalUtils.isRunningWorkflow(ctx, objId))) {
            WfEventListenerStateManager.getInstance().disableEventListener();
        }
    }
}

