/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaBarCodeGennerFacadeControllerBean;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.framework.report.util.DBUtilx;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class FaBarCodeGennerFacadeControllerBean
extends AbstractFaBarCodeGennerFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.manage.app.FaBarCodeGennerFacadeControllerBean");

    @Override
    protected String _updateCardBarCode(Context ctx, String[] orderbys, String companyId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FID from T_FA_FACurCard where FCompanyID=? and FBarCode is null order by ");
        for (int i = 0; i < orderbys.length; ++i) {
            sql.append(orderbys[i]).append(",");
        }
        sql.append("FCreateTime");
        int count = 0;
        Connection con = null;
        Statement ps = null;
        int BATCH_COUNT = 100;
        try {
            con = DBUtilx.getConnection((Context)ctx);
            ps = con.prepareStatement(sql.toString());
            ps.setString(1, companyId);
            ArrayList<String> idList = new ArrayList<String>(150);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                idList.add(rs.getString(1));
            }
            rs.close();
            ps.close();
            int size = idList.size();
            if (size == 0) {
                String string = FaLocalUtils.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaBarCordResource", "No_updated_records");
                return string;
            }
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo ff = new FilterInfo();
            ev.setFilter(ff);
            FilterItemCollection fc = ff.getFilterItems();
            SorterItemCollection sc = new SorterItemCollection();
            ev.setSorter(sc);
            for (int i = 0; i < orderbys.length; ++i) {
                String property = orderbys[i].substring(1);
                if ("AssetCatId".equalsIgnoreCase(property)) {
                    property = "AssetCat";
                }
                sc.add(new SorterItemInfo(property));
            }
            sc.add(new SorterItemInfo("CreateTime"));
            for (int curIndex = 0; curIndex < size; curIndex += 100) {
                HashSet idSet = new HashSet();
                int to = curIndex + 100;
                if (to > size) {
                    to = size;
                }
                idSet.addAll(idList.subList(curIndex, to));
                if (curIndex == 0) {
                    fc.add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                } else {
                    fc.set(fc.size() - 1, new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                }
                FaCurCardCollection cards = FaCurCardFactory.getLocalInstance(ctx).getFaCurCardCollection(ev);
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                HashMap<String, String> barcodeMap = new HashMap<String, String>();
                int n = cards.size();
                for (int i = 0; i < n; ++i) {
                    FaCurCardInfo card = cards.get(i);
                    String barCode = iCodingRuleManager.getNumber((IObjectValue)card, companyId, "barCodeStatus", "");
                    barCode = FaBarCodeGennerFacadeControllerBean.ensureEAN13(barCode);
                    barcodeMap.put(card.getNumber(), barCode);
                }
                count = this.updateHistoryCard(ctx, companyId);
                String sql1 = "UPDATE T_FA_FACURCARD SET FBarCode=? where FNumber=? and FCompanyId=?";
                String sql2 = "UPDATE T_FA_FABIZCARD SET FBarCode=? where FNumber=? and FCompanyId=?";
                String sql3 = "UPDATE T_FA_FABAKCARD SET FBarCode=? where FNumber=? and FCompanyId=?";
                String sql4 = "UPDATE T_FA_FAMONCARD SET FBarCode=? where FNumber=? and FCompanyId=?";
                String[] sqls = new String[]{sql1, sql2, sql3, sql4};
                for (int i = 0; i < sqls.length; ++i) {
                    ps = con.prepareStatement(sqls[i]);
                    for (String number : barcodeMap.keySet()) {
                        String barCode = (String)barcodeMap.get(number);
                        ps.setString(1, barCode);
                        ps.setString(2, number);
                        ps.setString(3, companyId);
                        ps.executeUpdate();
                        ps.clearParameters();
                    }
                    ps.close();
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return MessageFormat.format(FaLocalUtils.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaBarCordResource", "Updated_hiscards_success"), count + "");
    }

    private int updateHistoryCard(Context ctx, String companyId) throws BOSException, EASBizException {
        Connection con = null;
        Statement ps = null;
        int count = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("select count(1) from t_fa_facurcard where fbarcode is  null and FCompanyId=?");
        try {
            con = DBUtilx.getConnection((Context)ctx);
            ps = con.prepareStatement(sql.toString());
            ps.setString(1, companyId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                count = Integer.parseInt(rs.getString(1));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return count;
    }

    public static String ensureEAN13(String seq) {
        if (seq == null || seq.length() != 12 || !seq.matches("\\d+") || seq.charAt(0) == '0') {
            return seq;
        }
        char[] ch = seq.toCharArray();
        int c1 = 0;
        int c2 = 0;
        int n = ch.length;
        for (int i = 0; i < n; ++i) {
            int m = Integer.parseInt(String.valueOf(ch[i]));
            if ((i + 1) % 2 == 0) {
                c2 += m;
                continue;
            }
            c1 += m;
        }
        int cc = c1 + c2 * 3;
        int c = 10 - cc % 10;
        if (c == 10) {
            c = 0;
        }
        return seq + c;
    }
}

