/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaBillBaseInfo;
import com.kingdee.eas.fi.fa.manage.FaBillBizProcessor;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaBillBaseControllerBean;
import com.kingdee.eas.fi.fa.manage.app.AbstractPrcFaManageStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaLastPeriodChangeUtils;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.PrcFaCoreManager;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public abstract class FaBillBaseControllerBean
extends AbstractFaBillBaseControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.manage.app.FaBillBaseControllerBean");
    private static final String RES_PATH_CARD = "com.kingdee.eas.fi.fa.manage.FaCardResource";

    protected FilterInfo getFilterForCheckNumber(CoreBillBaseInfo model) {
        FaBillBaseInfo billBaseInfo = (FaBillBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        if (billBaseInfo.getCompany() != null) {
            filter.getFilterItems().add(new FilterItemInfo("company", (Object)billBaseInfo.getCompany().getId().toString(), CompareType.EQUALS));
        }
        if (billBaseInfo.getCU() != null) {
            filter.getFilterItems().add(new FilterItemInfo("company", (Object)billBaseInfo.getCU().getId().toString(), CompareType.EQUALS));
        }
        return filter;
    }

    protected boolean _checkStatusValid(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(this.getBillStrategy());
        prcFaCoreManager.getFaManageStrategy().checkForEdit(ctx, model);
        return true;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FaBillBizProcessor.lockTable(ctx, pk.toString());
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(this.getBillStrategy());
        prcFaCoreManager.getFaManageStrategy().checkForDelete(ctx, pk);
        prcFaCoreManager.getFaManageStrategy().deleteBill(ctx, pk);
    }

    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            this.setWorkflowServiceState(ctx, pk);
            super.delete(ctx, pk);
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    @Override
    protected void _deleteSelf(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (!FaManageUtils.deleteBill(ctx, pk.toString())) {
            super._delete(ctx, pk);
        }
    }

    @Override
    protected void _deleteSelf(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        super._delete(ctx, arrayPK);
    }

    protected SelectorItemCollection getSelfSelctor() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("auditor.id"));
        sic.add(new SelectorItemInfo("handler.id"));
        sic.add(new SelectorItemInfo("period.id"));
        return sic;
    }

    @Override
    protected void _passAudit(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        FaBillBizProcessor.lockTable(ctx, pk.toString());
        FaBillBaseInfo model = this.getFaBillBaseInfo(ctx, pk, this.getSelfSelctor());
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(this.getBillStrategy());
        prcFaCoreManager.getFaManageStrategy().checkForAudit(ctx, pk);
        prcFaCoreManager.getFaManageStrategy().auditBill(ctx, (IObjectValue)model);
        logger.debug((Object)"_passAudit");
    }

    @Override
    public void passAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            this.setWorkflowServiceState(ctx, pk);
            super.passAudit(ctx, pk);
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    public abstract String getMasterTable();

    @Override
    protected void _passAuditSelf(Context ctx, IObjectPK pk, FaBillBaseInfo model) throws BOSException, EASBizException {
        StringBuffer _sql = new StringBuffer("update " + this.getMasterTable() + "  set");
        _sql.append(" FCheckedStatus = ?");
        _sql.append(",FAuditorId = ?");
        _sql.append(",FAuditTime = ?");
        _sql.append(",FBizDate = ?");
        _sql.append(" where fid = ?");
        Object[] params = new Object[5];
        params[0] = new Integer(2);
        params[1] = ctx.getCaller().toString();
        Date date = new Date();
        long time = date.getTime();
        params[2] = new Timestamp(time);
        CompanyOrgUnitInfo company = model.getCompany();
        if (company == null || company.getId() == null) {
            company = (CompanyOrgUnitInfo)this.getValue(ctx, "select company.id where id ='" + pk + "'").get("company");
        }
        params[3] = new Timestamp(FaLocalUtils.getBizDate(ctx, company.getId().toString()).getTime());
        params[4] = pk.toString();
        DbUtil.execute((Context)ctx, (String)_sql.toString(), (Object[])params);
        BOSUuid uuid = model.getId();
        if ("78C04DFE".equals(uuid.getType().toString())) {
            return;
        }
        if ("562AC667".equals(uuid.getType().toString())) {
            return;
        }
        FaLastPeriodChangeUtils.updateCardLastPeriodChange(ctx, company.getId().toString(), pk.toString(), 4);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String pk = model.get("id") == null ? null : model.get("id").toString();
        FaBillBizProcessor.lockTable(ctx, pk);
        this.checkBeforeSave(ctx, model);
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(this.getBillStrategy());
        FaBillBaseInfo billBaseInfo = (FaBillBaseInfo)model;
        if (billBaseInfo != null && billBaseInfo.getBOSUuid("id") != null) {
            prcFaCoreManager.getFaManageStrategy().checkForSave(ctx, (IObjectValue)billBaseInfo);
        } else {
            if (billBaseInfo.getCompany() != null && billBaseInfo.getCompany().getId() != null) {
                prcFaCoreManager.getFaManageStrategy().checkUnAuditFaDep(ctx, prcFaCoreManager.getFaManageStrategy().getCurrentPeriod(ctx, billBaseInfo), billBaseInfo.getCompany());
            }
            FaLocalUtils.verifyForLastestPeriod(ctx, (IObjectValue)billBaseInfo, 1);
        }
        logger.debug((Object)"_save");
        return prcFaCoreManager.getFaManageStrategy().saveBill(ctx, model);
    }

    protected abstract void checkBeforeSave(Context var1, IObjectValue var2) throws BOSException, EASBizException;

    @Override
    protected void _saveSelf(Context ctx, IObjectPK pk, FaBillBaseInfo model) throws BOSException, EASBizException {
        model.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        super._save(ctx, pk, (IObjectValue)model);
        FaLastPeriodChangeUtils.updateCardLastPeriodChange(ctx, model.getCompany().getId().toString(), pk.toString(), 1);
    }

    @Override
    protected IObjectPK _saveSelf(Context ctx, FaBillBaseInfo model) throws BOSException, EASBizException {
        model.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        IObjectPK pk = super._save(ctx, (IObjectValue)model);
        BOSUuid uuid = model.getId();
        if ("78C04DFE".equals(uuid.getType().toString())) {
            return pk;
        }
        if ("562AC667".equals(uuid.getType().toString())) {
            return pk;
        }
        FaLastPeriodChangeUtils.updateCardLastPeriodChange(ctx, model.getCompany().getId().toString(), pk.toString(), 1);
        return pk;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String pk = model.get("id") == null ? null : model.get("id").toString();
        FaBillBizProcessor.lockTable(ctx, pk);
        this.checkBeforeSubmit(ctx, model);
        if (model != null && model.getBoolean("forDAP")) {
            return this._submitSelf(ctx, (FaBillBaseInfo)model);
        }
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(this.getBillStrategy());
        FaBillBaseInfo billBaseInfo = (FaBillBaseInfo)model;
        if (billBaseInfo != null && billBaseInfo.getBOSUuid("id") != null) {
            prcFaCoreManager.getFaManageStrategy().checkForEdit(ctx, (IObjectValue)billBaseInfo);
        } else {
            if (billBaseInfo.getCompany() != null && billBaseInfo.getCompany().getId() != null) {
                prcFaCoreManager.getFaManageStrategy().checkUnAuditFaDep(ctx, prcFaCoreManager.getFaManageStrategy().getCurrentPeriod(ctx, billBaseInfo), billBaseInfo.getCompany());
            }
            FaLocalUtils.verifyForLastestPeriod(ctx, (IObjectValue)billBaseInfo, 1);
        }
        logger.debug((Object)"_submit");
        return prcFaCoreManager.getFaManageStrategy().submitBill(ctx, model);
    }

    protected abstract void checkBeforeSubmit(Context var1, IObjectValue var2) throws BOSException, EASBizException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        try {
            CompanyOrgUnitInfo comp = (CompanyOrgUnitInfo)model.get("company");
            this.setWorkflowServiceState(ctx, comp == null ? null : comp.getId().toString(), model.getId() == null ? null : model.getId().toString());
            IObjectPK iObjectPK = super.submit(ctx, model);
            return iObjectPK;
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    @Override
    protected void _submitSelf(Context ctx, IObjectPK pk, FaBillBaseInfo model) throws BOSException, EASBizException {
        model.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        super._submit(ctx, pk, (IObjectValue)model);
        FaLastPeriodChangeUtils.updateCardLastPeriodChange(ctx, model.getCompany().getId().toString(), pk.toString(), 3);
    }

    @Override
    protected IObjectPK _submitSelf(Context ctx, FaBillBaseInfo model) throws BOSException, EASBizException {
        model.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        IObjectPK pk = super._submit(ctx, (IObjectValue)model);
        BOSUuid uuid = model.getId();
        if ("78C04DFE".equals(uuid.getType().toString())) {
            return pk;
        }
        if ("562AC667".equals(uuid.getType().toString())) {
            return pk;
        }
        FaLastPeriodChangeUtils.updateCardLastPeriodChange(ctx, model.getCompany().getId().toString(), pk.toString(), 3);
        return pk;
    }

    @Override
    protected void _unpassAudit(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        FaBillBizProcessor.lockTable(ctx, pk.toString());
        FaBillBaseInfo model = this.getFaBillBaseInfo(ctx, pk, this.getSelfSelctor());
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(this.getBillStrategy());
        prcFaCoreManager.getFaManageStrategy().checkForUnAudit(ctx, pk);
        prcFaCoreManager.getFaManageStrategy().unAuditBill(ctx, (IObjectValue)model);
        logger.debug((Object)"_unpassAudit");
    }

    @Override
    public void unpassAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            this.setWorkflowServiceState(ctx, pk);
            super.unpassAudit(ctx, pk);
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    protected void setWorkflowServiceState(Context ctx, IObjectPK objId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.id"));
        CompanyOrgUnitInfo comp = (CompanyOrgUnitInfo)this.getValue(ctx, objId, sic).get("company");
        this.setWorkflowServiceState(ctx, comp.getId().toString(), objId.toString());
    }

    protected void setWorkflowServiceState(Context ctx, String companyId, String objId) throws BOSException, EASBizException {
        boolean isUseWorkflow = FaManageUtils.isUseWorkflow(ctx, companyId, this.getClass());
        if (!isUseWorkflow && (objId == null || objId != null && !FaLocalUtils.isRunningWorkflow(ctx, objId))) {
            WfEventListenerStateManager.getInstance().disableEventListener();
        }
    }

    @Override
    protected void _unpassAuditSelf(Context ctx, IObjectPK pk, FaBillBaseInfo model) throws BOSException, EASBizException {
        StringBuffer _sql = new StringBuffer("update " + this.getMasterTable() + "  set");
        _sql.append(" FCheckedStatus = ?");
        _sql.append(",FAuditorId = null");
        _sql.append(",FAuditTime = null");
        _sql.append(" where fid = ?");
        Object[] params = new Object[]{new Integer(1), pk.toString()};
        CompanyOrgUnitInfo company = model.getCompany();
        if (company == null || company.getId() == null) {
            company = (CompanyOrgUnitInfo)this.getValue(ctx, "select company.id where id ='" + pk + "'").get("company");
        }
        DbUtil.execute((Context)ctx, (String)_sql.toString(), (Object[])params);
        BOSUuid uuid = model.getId();
        if ("78C04DFE".equals(uuid.getType().toString())) {
            return;
        }
        if ("562AC667".equals(uuid.getType().toString())) {
            return;
        }
        FaLastPeriodChangeUtils.updateCardLastPeriodChange(ctx, company.getId().toString(), pk.toString(), 5);
    }

    @Override
    public void updatePartial(Context ctx, FaBillBaseInfo model, SelectorItemCollection selector) throws BOSException, EASBizException {
        super.updatePartial(ctx, model, selector);
    }

    protected abstract AbstractPrcFaManageStrategy getBillStrategy();

    protected DAPTransformResult _generateVoucher(Context ctx, IObjectCollection sourceBillCollection, IObjectPK botMappingPK) throws BOSException, EASBizException {
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(this.getBillStrategy());
        int size = sourceBillCollection.size();
        for (int i = 0; i < size; ++i) {
            BillBaseInfo info = (BillBaseInfo)sourceBillCollection.getObject(i);
            if (info == null) continue;
            prcFaCoreManager.getFaManageStrategy().checkForOperate(ctx, info, 2);
        }
        return super._generateVoucher(ctx, sourceBillCollection, botMappingPK);
    }

    @Override
    protected void _checkBeforePeriodClose(Context ctx, String periodID, String companyID) throws BOSException, EASBizException {
    }

    @Override
    protected boolean _hasNotAuditValue(Context ctx, String periodID, String companyID) throws BOSException, EASBizException {
        FilterInfo auditFilter = new FilterInfo();
        auditFilter.getFilterItems().add(new FilterItemInfo("period", (Object)periodID, CompareType.EQUALS));
        auditFilter.getFilterItems().add(new FilterItemInfo("company", (Object)companyID, CompareType.EQUALS));
        auditFilter.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
        return this.exists(ctx, auditFilter);
    }

    @Override
    protected boolean _hasNotGenVoucherValue(Context ctx, String periodID, String companyID) throws BOSException, EASBizException {
        return this.isNeedGenVoucher() && this.exists(ctx, this.getVoucherFilter(periodID, companyID));
    }

    protected FilterInfo getVoucherFilter(String periodID, String companyID) {
        FilterInfo voucherFilter = new FilterInfo();
        voucherFilter.getFilterItems().add(new FilterItemInfo("period", (Object)periodID, CompareType.EQUALS));
        voucherFilter.getFilterItems().add(new FilterItemInfo("company", (Object)companyID, CompareType.EQUALS));
        voucherFilter.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
        voucherFilter.getFilterItems().add(new FilterItemInfo("fiVouchered", (Object)"1", CompareType.NOTEQUALS));
        voucherFilter.setMaskString("#0 and #1 and (#2 or #3)");
        return voucherFilter;
    }

    protected boolean isNeedGenVoucher() {
        return false;
    }

    protected boolean _checkNumberDup(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        BillBaseInfo billBaseInfo = (BillBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)billBaseInfo.getString("number"), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (billBaseInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)billBaseInfo.getId().toString(), CompareType.NOTEQUALS));
        }
        if (billBaseInfo.getCompany() != null) {
            filter.getFilterItems().add(new FilterItemInfo("company", (Object)billBaseInfo.getCompany().getId().toString(), CompareType.EQUALS));
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            if (i != 0) {
                sb.append(" and #" + i);
                continue;
            }
            sb.append("#" + i);
        }
        filter.setMaskString(sb.toString());
        if (super._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{billBaseInfo.getString("number"), ""});
        }
        return true;
    }

    protected SystemEnum _getOwnedSys(Context ctx) throws BOSException, EASBizException {
        return SystemEnum.FIXEDASSETS;
    }

    @Override
    protected HashMap _getInfoForInitUI(Context ctx, String companyID) throws BOSException, EASBizException {
        HashMap<String, Object> initInfo = new HashMap<String, Object>();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("accountPeriodType.id"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("reportCurrency.id"));
        sic.add(new SelectorItemInfo("reportCurrency.number"));
        sic.add(new SelectorItemInfo("reportCurrency.name"));
        sic.add(new SelectorItemInfo("baseExchangeTable.id"));
        sic.add(new SelectorItemInfo("reportExchangeTable.id"));
        CompanyOrgUnitInfo currentCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyID)), sic);
        initInfo.put("currentCompany", currentCompany);
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)currentCompany);
        initInfo.put("currentPeriod", currentPeriod);
        Boolean isInitEnd = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)currentCompany);
        initInfo.put("isInitEnd", isInitEnd);
        HashMap hmParam = FaManageUtils.getFAParameter(currentCompany.getId(), ctx);
        initInfo.put("hmParam", hmParam);
        return initInfo;
    }
}

