/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgBizChecker;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.fa.manage.FaAccountBalanceFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaMonCardFactory;
import com.kingdee.eas.fi.fa.manage.IFaAccountBalance;
import com.kingdee.eas.fi.fa.manage.IFaCurCard;
import com.kingdee.eas.fi.fa.manage.IFaMonCard;
import com.kingdee.eas.fi.fa.manage.app.FaDepLocalUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.Locale;
import org.apache.log4j.Logger;

public class FaBizChecker
implements IOrgBizChecker {
    private Logger logger = Logger.getLogger(FaBizChecker.class);

    public void checkBizClear(Context ctx, FullOrgUnitInfo unit, OrgType type) throws EASBizException {
        if (OrgType.CostCenter == type && unit != null && unit.getId() != null) {
            FilterInfo filterInfo = new FilterInfo();
            try {
                filterInfo = FaDepLocalUtils.getDepCardFilter(ctx, false, this.getCurrentCompanyId(ctx));
            }
            catch (BOSException e) {
                throw new EASBizException(new NumericExceptionSubItem("1", e.getMessage()), (Throwable)e);
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("faCurCostCenter.id", (Object)unit.getId().toString()));
            try {
                IFaCurCard iCurCard = FaCurCardFactory.getLocalInstance(ctx);
                if (iCurCard.exists(filterInfo)) {
                    throw new EASBizException(new NumericExceptionSubItem("1", FaResUtil.getRes((String)"assetCardUseCostCenter", (Locale)ctx.getOriginLocale())));
                }
            }
            catch (BOSException e) {
                this.logger.error((Object)e);
            }
        }
    }

    private String getCurrentCompanyId(Context ctx) {
        if (ctx.get((Object)"depCompanyID") != null) {
            return ctx.get((Object)"depCompanyID").toString();
        }
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = null;
        aCompanyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        String strCompanyOrgUnitInfoID = aCompanyOrgUnitInfo.getId().toString();
        return strCompanyOrgUnitInfoID;
    }

    public static boolean hasFaInitData(Context ctx, String orgUnitId) throws BOSException, EASBizException {
        FilterInfo filterInfo1 = new FilterInfo();
        FilterInfo filterInfo2 = new FilterInfo();
        filterInfo1.getFilterItems().add(new FilterItemInfo("company.id", (Object)orgUnitId));
        filterInfo2.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)orgUnitId));
        IFaMonCard iMonCard = FaMonCardFactory.getLocalInstance(ctx);
        IFaAccountBalance iAcBalance = FaAccountBalanceFactory.getLocalInstance(ctx);
        IFaCurCard iCurCard = FaCurCardFactory.getLocalInstance(ctx);
        return iCurCard.exists(filterInfo1) || iMonCard.exists(filterInfo1) || iAcBalance.exists(filterInfo2);
    }

    public void bizUpdateWhenBizParentChanged(Context ctx, String unitID, String oldBizParentID, String newBizParentID, OrgType orgType) throws EASBizException {
    }
}

