/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaBillBaseInfo;
import com.kingdee.eas.fi.fa.manage.FaBillBizProcessor;
import com.kingdee.eas.fi.fa.manage.FaBizStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaBorrowingEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaBorrowingEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaBorrowingInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaPhysicalManageBaseException;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaBorrowingControllerBean;
import com.kingdee.eas.fi.fa.manage.app.FaLastPeriodChangeUtils;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class FaBorrowingControllerBean
extends AbstractFaBorrowingControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.manage.app.FaBorrowingControllerBean");
    public static final Set bizState = new HashSet();

    @Override
    public String getMasterTable() {
        return "T_FA_FaBorrowing";
    }

    @Override
    protected void _saveSelf(Context ctx, IObjectPK pk, FaBillBaseInfo model) throws BOSException, EASBizException {
        this.updateCurCard(ctx, (FaBorrowingInfo)model);
        super._saveSelf(ctx, pk, model);
        String lastBillID = pk.toString();
        String bizStatus = FaBizStatusEnum.BORROWING.getValue();
        String curCardIDsql = "select FCurcardID from T_FA_FaBorrowingEntry where FParentID='" + lastBillID + "'";
        this.updateCurCardBySQL(ctx, bizStatus, lastBillID, curCardIDsql);
    }

    @Override
    protected IObjectPK _saveSelf(Context ctx, FaBillBaseInfo model) throws BOSException, EASBizException {
        this.updateCurCard(ctx, (FaBorrowingInfo)model);
        IObjectPK pk = super._saveSelf(ctx, model);
        String lastBillID = pk.toString();
        String bizStatus = FaBizStatusEnum.BORROWING.getValue();
        String curCardIDsql = "select FCurcardID from T_FA_FaBorrowingEntry where FParentID='" + lastBillID + "'";
        this.updateCurCardBySQL(ctx, bizStatus, lastBillID, curCardIDsql);
        return pk;
    }

    protected void updateCurCard(Context ctx, FaBorrowingInfo newInfo) throws EASBizException, BOSException {
        FaBorrowingEntryInfo entryInfo;
        int i;
        if (newInfo.getId() == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(newInfo.getId().toString());
        SelectorItemCollection sic = this.getSelfSelctor();
        sic.add("entry.bizCard.id");
        sic.add("entry.bizCard.bizStatus");
        sic.add("entry.bizCard.lastBillID");
        HashSet<String> set = new HashSet<String>();
        FaBorrowingInfo info = this.getFaBorrowingInfo(ctx, (IObjectPK)pk, sic);
        for (i = 0; i < info.getEntry().size(); ++i) {
            entryInfo = info.getEntry().get(i);
            if (entryInfo.getBizCard() == null) continue;
            set.add(entryInfo.getFaCurCard().getId().toString());
        }
        for (i = 0; i < newInfo.getEntry().size(); ++i) {
            entryInfo = newInfo.getEntry().get(i);
            if (entryInfo.getId() == null || entryInfo.getBizCard() == null) continue;
            set.remove(entryInfo.getFaCurCard().getId().toString());
        }
        if (set.isEmpty()) {
            return;
        }
        for (i = 0; i < info.getEntry().size(); ++i) {
            entryInfo = info.getEntry().get(i);
            if (entryInfo.getBizCard() == null || !set.contains(entryInfo.getFaCurCard().getId().toString())) continue;
            FaLastPeriodChangeUtils.updateCurCardBySQL(ctx, entryInfo.getBizCard().getBizStatus().getValue(), entryInfo.getBizCard().getLastBillID(), entryInfo.getFaCurCard().getId().toString(), entryInfo.getBizCard().isLastPeriodChange());
        }
    }

    @Override
    protected void _submitSelf(Context ctx, IObjectPK pk, FaBillBaseInfo model) throws BOSException, EASBizException {
        this.updateCurCard(ctx, (FaBorrowingInfo)model);
        this.checkIsBorrowed(ctx, (FaBorrowingInfo)model);
        super._submitSelf(ctx, pk, model);
        String lastBillID = pk != null ? pk.toString() : (model.getId() == null ? null : model.getId().toString());
        String bizStatus = FaBizStatusEnum.BORROWING.getValue();
        String curCardIDsql = "select FCurcardID from T_FA_FaBorrowingEntry where FParentID='" + lastBillID + "'";
        this.updateCurCardBySQL(ctx, bizStatus, lastBillID, curCardIDsql);
    }

    @Override
    protected IObjectPK _submitSelf(Context ctx, FaBillBaseInfo model) throws BOSException, EASBizException {
        this.updateCurCard(ctx, (FaBorrowingInfo)model);
        this.checkIsBorrowed(ctx, (FaBorrowingInfo)model);
        IObjectPK pk = super._submitSelf(ctx, model);
        String lastBillID = pk != null ? pk.toString() : (model.getId() == null ? null : model.getId().toString());
        String bizStatus = FaBizStatusEnum.BORROWING.getValue();
        String curCardIDsql = "select FCurcardID from T_FA_FaBorrowingEntry where FParentID='" + lastBillID + "'";
        this.updateCurCardBySQL(ctx, bizStatus, lastBillID, curCardIDsql);
        return pk;
    }

    private void checkIsBorrowed(Context ctx, FaBorrowingInfo model) throws BOSException, EASBizException {
        String billID = model.getId() == null ? null : model.getId().toString();
        FaBorrowingEntryCollection collection = model.getEntry();
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            FaCurCardInfo info = collection.get(i).getFaCurCard();
            if (billID != null && billID.equalsIgnoreCase(info.getLastBillID())) continue;
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("bizStatus");
            FaCurCardInfo facurcardInfo = FaCurCardFactory.getLocalInstance(ctx).getFaCurCardInfo((IObjectPK)new ObjectUuidPK(info.getId().toString()), sic);
            if (!facurcardInfo.getBizStatus().getValue().toString().endsWith("01")) continue;
            throw new FaPhysicalManageBaseException(FaPhysicalManageBaseException.EXSITYW_JY, new Object[]{info.getNumber(), facurcardInfo.getBizStatus().getAlias()});
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.updateCurCard(ctx, (FaBorrowingInfo)model);
        super._update(ctx, pk, model);
        this.updateCurCardBySQL(ctx, FaBizStatusEnum.BORROWING.getValue(), pk.toString(), "select FCurcardID from T_FA_FaBorrowingEntry where FParentID='" + pk.toString() + "'");
    }

    @Override
    protected void verfyBeforeAudit(IObjectValue model) throws BOSException, EASBizException {
        super.verfyBeforeAudit(model);
        FaBorrowingInfo info = (FaBorrowingInfo)model;
        if (null == info.getEntry() || info.getEntry().size() == 0) {
            throw new FaPhysicalManageBaseException(FaPhysicalManageBaseException.ENTRY_BORROW_NULL, new Object[0]);
        }
    }

    @Override
    protected SelectorItemCollection getSelfSelctor() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("auditor.id"));
        sic.add(new SelectorItemInfo("handler.id"));
        sic.add(new SelectorItemInfo("period.id"));
        sic.add("company.id");
        sic.add("entry.id");
        sic.add("entry.faCurCard.isBorrowing");
        sic.add("entry.faCurCard.bizStatus");
        sic.add("entry.faCurCard.id");
        sic.add("entry.faCurCard.number");
        sic.add("user.id");
        sic.add("userDispartment.id");
        sic.add("userDispartment.isLeaf");
        sic.add("CU.id");
        sic.add("entry.faCurCard.faCurDepartment.*");
        sic.add("entry.faCurCard.isRequisitioned");
        return sic;
    }

    @Override
    protected void _unpassAudit(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        super._unpassAudit(ctx, pk);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        super._unpassAudit(ctx, pk, model);
    }

    @Override
    protected void _unpassAuditSelf(Context ctx, IObjectPK pk, FaBillBaseInfo model) throws BOSException, EASBizException {
        super._unpassAuditSelf(ctx, pk, model);
        String lastBillID = pk.toString();
        String bizStatus = FaBizStatusEnum.BORROWING.getValue();
        String curCardIDsql = "select FCurcardID from T_FA_FaBorrowingEntry where FParentID='" + lastBillID + "'";
        this.updateCurCardBySQL(ctx, bizStatus, lastBillID, curCardIDsql);
    }

    @Override
    protected void _passAuditSelf(Context ctx, IObjectPK pk, FaBillBaseInfo model) throws BOSException, EASBizException {
        this.updateCurCard(ctx, (FaBorrowingInfo)model);
        super._passAuditSelf(ctx, pk, model);
        String lastBillID = pk.toString();
        String bizStatus = FaBizStatusEnum.HAVE_BORROWED.getValue();
        String curCardIDsql = "select FCurcardID from T_FA_FaBorrowingEntry where FParentID='" + lastBillID + "'";
        this.updateCurCardBySQL(ctx, bizStatus, lastBillID, curCardIDsql);
    }

    public Set getFaBizStatusEnumSet() {
        if (bizState.isEmpty()) {
            bizState.add(FaBizStatusEnum.BORROWING);
        }
        return bizState;
    }

    @Override
    protected void _deleteSelf(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = this.getSelfSelctor();
        sic.add("entry.bizCard.id");
        sic.add("entry.bizCard.bizStatus");
        sic.add("entry.bizCard.lastBillID");
        FaBorrowingInfo info = this.getFaBorrowingInfo(ctx, pk, sic);
        for (int i = 0; i < info.getEntry().size(); ++i) {
            FaBorrowingEntryInfo entryInfo = info.getEntry().get(i);
            if (entryInfo.getBizCard() == null || entryInfo.getBizCard().getBizStatus() == null) continue;
            FaLastPeriodChangeUtils.updateCurCardBySQL(ctx, entryInfo.getBizCard().getBizStatus().getValue(), entryInfo.getBizCard().getLastBillID(), entryInfo.getFaCurCard().getId().toString(), entryInfo.getBizCard().isLastPeriodChange());
        }
        super._deleteSelf(ctx, pk);
    }

    @Override
    protected void _deleteSelf(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        if (arrayPK == null || arrayPK.length == 0) {
            return;
        }
        for (int k = 0; k < arrayPK.length; ++k) {
            SelectorItemCollection sic = this.getSelfSelctor();
            sic.add("entry.bizCard.bizStatus");
            sic.add("entry.bizCard.lastBillID");
            sic.add("entry.bizCard.lastPeriodChange");
            FaBorrowingInfo info = this.getFaBorrowingInfo(ctx, arrayPK[k], sic);
            for (int i = 0; i < info.getEntry().size(); ++i) {
                FaBorrowingEntryInfo entryInfo = info.getEntry().get(i);
                FaLastPeriodChangeUtils.updateCurCardBySQL(ctx, entryInfo.getBizCard().getBizStatus().getValue(), entryInfo.getBizCard().getLastBillID(), entryInfo.getFaCurCard().getId().toString(), entryInfo.getBizCard().isLastPeriodChange());
            }
        }
        super._deleteSelf(ctx, arrayPK);
    }

    @Override
    protected void checkBeforeSave(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaBorrowingInfo borrowingBill = (FaBorrowingInfo)model;
        FaBorrowingEntryCollection entryColl = borrowingBill.getEntry();
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            FaCurCardInfo card = entryColl.get(i).getFaCurCard();
            if (card == null || card.getId() == null || card.getLastUpdateTime() == null) continue;
            FaBillBizProcessor.lockFaCurCard(ctx, card.getId().toString());
            FaBillBizProcessor.checkFaCurCardVersion(ctx, card.getId().toString(), card.getLastUpdateTime());
        }
    }

    @Override
    protected void checkBeforeSubmit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaBorrowingInfo borrowingBill = (FaBorrowingInfo)model;
        FaBorrowingEntryCollection entryColl = borrowingBill.getEntry();
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            FaCurCardInfo card = entryColl.get(i).getFaCurCard();
            if (card == null || card.getId() == null || card.getLastUpdateTime() == null) continue;
            FaBillBizProcessor.lockFaCurCard(ctx, card.getId().toString());
            FaBillBizProcessor.checkFaCurCardVersion(ctx, card.getId().toString(), card.getLastUpdateTime());
        }
    }
}

