/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.def.FaDefCommonFacadeFactory;
import com.kingdee.eas.fi.fa.def.FaDefPropertyCollection;
import com.kingdee.eas.fi.fa.def.FaDefPropertyInfo;
import com.kingdee.eas.fi.fa.def.FaDefPropertyValueFactory;
import com.kingdee.eas.fi.fa.def.FaDefPropertyValueInfo;
import com.kingdee.eas.fi.fa.def.FaDefResource;
import com.kingdee.eas.fi.fa.def.FaDefStyleInfo;
import com.kingdee.eas.fi.fa.manage.FaCardInfo;
import com.kingdee.eas.fi.fa.manage.FaDataImportException;
import com.kingdee.eas.framework.report.util.DBUtilx;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class FaCardDefPropertyPersist {
    public static FaDefPropertyValueInfo getById(BOSUuid propertyId, Context ctx) throws BOSException {
        return FaDefCommonFacadeFactory.getLocalInstance((Context)ctx).getPropertyValueById(propertyId.toString());
    }

    public static void deleteById(BOSUuid propertyId, Context ctx) throws BOSException, EASBizException {
        if (propertyId != null) {
            FaDefPropertyValueFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(propertyId));
        }
    }

    public static FaDefPropertyValueInfo save(BOSUuid propertyId, FaDefStyleInfo style, Context ctx) throws BOSException {
        return FaDefCommonFacadeFactory.getLocalInstance((Context)ctx).savePropertyValue(propertyId, style);
    }

    public static FaDefPropertyValueInfo save(FaDefPropertyValueInfo propertyValueInfo, Context ctx) throws BOSException {
        return FaDefCommonFacadeFactory.getLocalInstance((Context)ctx).savePropertyValue(propertyValueInfo);
    }

    public static void save(FaCardInfo card, Context ctx) throws BOSException {
        boolean fromUI;
        boolean bl = fromUI = card.getPropertyValue() == null;
        if (!fromUI) {
            if (card.getAssetCat() != null && card.getAssetCat().getStyle() != null) {
                FaDefPropertyValueInfo cv = card.getAssetCat().getStyle().getPropertyValue(null);
                boolean bl2 = fromUI = cv.getPropertyValueMap().size() > 0;
            }
            if (!fromUI && card.getPropertyValue() != null && card.getPropertyValue().getId() != null && card.getPropertyValue().valueSize() == 0) {
                return;
            }
        }
        FaDefPropertyValueInfo pv = fromUI ? FaCardDefPropertyPersist.save(card.getPropertyValue() == null ? null : card.getPropertyValue().getId(), card.getAssetCat() == null ? null : card.getAssetCat().getStyle(), ctx) : FaCardDefPropertyPersist.save(card.getPropertyValue(), ctx);
        card.setPropertyValue(pv);
    }

    public static FaDefPropertyValueInfo copy(BOSUuid fromPropertyValueId, Context ctx) throws BOSException {
        return FaCardDefPropertyPersist.copy(null, fromPropertyValueId, ctx);
    }

    public static FaDefPropertyValueInfo copy(BOSUuid toPropertyValueId, BOSUuid fromPropertyValueId, Context ctx) throws BOSException {
        if (fromPropertyValueId == null) {
            return null;
        }
        FaDefPropertyValueInfo propertyValueInfo = FaCardDefPropertyPersist.getById(fromPropertyValueId, ctx);
        if (propertyValueInfo != null) {
            propertyValueInfo.setId(toPropertyValueId);
            return FaCardDefPropertyPersist.save(propertyValueInfo, ctx);
        }
        return null;
    }

    public static void deleteByMonCardPK(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FaCardDefPropertyPersist.deleteByCardPKs(ctx, new IObjectPK[]{pk}, "T_Fa_FaMonCard");
    }

    public static void deleteByCurCardPK(Context ctx, String pk) throws BOSException {
        FaCardDefPropertyPersist.deleteByCardPKs(ctx, new String[]{pk}, "T_Fa_FaCurCard");
    }

    public static void deleteByBizCardPKs(Context ctx, IObjectPK[] pks) throws BOSException {
        FaCardDefPropertyPersist.deleteByCardPKs(ctx, pks, "T_Fa_FaBizCard");
    }

    public static void deleteByBakCardPKs(Context ctx, IObjectPK[] pks) throws BOSException {
        FaCardDefPropertyPersist.deleteByCardPKs(ctx, pks, "T_Fa_FaBakCard");
    }

    public static void updateBizCardPropertyId(Context ctx, String cardId, String propetyValueID) throws BOSException {
        FaCardDefPropertyPersist.updateCardPropertyId(ctx, cardId, propetyValueID, "T_Fa_FaBizCard");
    }

    public static void updateBakCardPropertyId(Context ctx, String cardId, String propetyValueID) throws BOSException {
        FaCardDefPropertyPersist.updateCardPropertyId(ctx, cardId, propetyValueID, "T_Fa_FaBakCard");
    }

    private static void updateCardPropertyId(Context ctx, String cardId, String propetyValueID, String cardTable) throws BOSException {
        String sql = "update " + cardTable + " set FPropertyValueID=? where FID=?";
        SqlParams sp = new SqlParams();
        sp.addString(propetyValueID).addString(cardId);
        try {
            DBUtilx.executeUpdate((String)sql, (SqlParams)sp, (Context)ctx);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private static void deleteByCardPKs(Context ctx, IObjectPK[] pks, String cardTable) throws BOSException {
        String[] pks2 = new String[pks.length];
        for (int i = 0; i < pks.length; ++i) {
            pks2[i] = pks[i].toString();
        }
        FaCardDefPropertyPersist.deleteByCardPKs(ctx, pks2, cardTable);
    }

    private static void deleteByCardPKs(Context ctx, String[] pks, String cardTable) throws BOSException {
        if (pks.length == 0) {
            return;
        }
        try {
            StringBuffer pos = new StringBuffer();
            SqlParams sp = new SqlParams();
            for (int i = 0; i < pks.length; ++i) {
                sp.addString(pks[i]);
                pos.append("?");
                if (i == pks.length - 1) continue;
                pos.append(",");
            }
            String sql = "delete from t_fa_FaDefPropertyValue where fid in (select FPropertyValueID from " + cardTable + " where FID in(" + pos.toString() + ") and FPropertyValueID is not null)";
            DBUtilx.executeUpdate((String)sql, (SqlParams)sp, (Context)ctx);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public static void checkRequired(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String companyId = null;
        CompanyOrgUnitInfo curCompanyInfo = (CompanyOrgUnitInfo)model.get("company");
        companyId = curCompanyInfo != null && curCompanyInfo.getId() != null ? curCompanyInfo.getId().toString() : ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        FaDefPropertyCollection ps = FaDefCommonFacadeFactory.getLocalInstance((Context)ctx).getProperties(companyId, true);
        FaCardDefPropertyPersist.checkRequired(ctx, model, ps, new HashMap());
    }

    public static void checkRequired(Context ctx, IObjectValue model, FaDefPropertyCollection ps, Map cache) throws BOSException, EASBizException {
        String catId;
        ArrayList<FaDefPropertyInfo> checkPSList;
        if (!(model instanceof FaCardInfo) || ((FaCardInfo)model).getAssetCat() == null) {
            return;
        }
        FaCardInfo card = (FaCardInfo)model;
        FaDefPropertyValueInfo value = card.getPropertyValue();
        if ((value == null || value != null && value.valueSize() == 0) && card.getAssetCat() != null && card.getAssetCat().getStyle() != null) {
            FaDefPropertyValueInfo cv;
            value = cv = card.getAssetCat().getStyle().getPropertyValue(value == null ? null : value.getId());
        }
        if ((checkPSList = (ArrayList<FaDefPropertyInfo>)cache.get(catId = card.getAssetCat().getId().toString())) == null) {
            checkPSList = new ArrayList<FaDefPropertyInfo>();
            cache.put(catId, checkPSList);
            String sql = " select D.Fpropertyid from t_fa_cat A inner join t_fa_fadefstyle B on B.Fid=A.Fstyleid inner join t_fa_fadefstylepage C on C.Fstyleid=B.FID inner join t_fa_fadefstylepageproperty D on D.Fpageid=C.FID where A.FID=?";
            SqlParams sp = new SqlParams();
            sp.addString(catId);
            try {
                RptRowSet rs = DBUtilx.executeQuery((String)sql, (SqlParams)sp, (Context)ctx);
                while (rs.next()) {
                    String pid = rs.getString("fpropertyid");
                    int n = ps.size();
                    for (int i = 0; i < n; ++i) {
                        FaDefPropertyInfo p = ps.get(i);
                        if (!pid.equals(p.getId().toString()) || !p.isIsRequired() || p.getType().getValue() == 2) continue;
                        checkPSList.add(p);
                    }
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        if (checkPSList.size() > 0) {
            if (value != null && value.getId() != null && value.valueSize() == 0) {
                value = FaCardDefPropertyPersist.getById(value.getId(), ctx);
            }
            int n = checkPSList.size();
            for (int i = 0; i < n; ++i) {
                Object v;
                FaDefPropertyInfo p = (FaDefPropertyInfo)checkPSList.get(i);
                Object object = v = value == null ? null : value.get(p.getNumber());
                if (v != null && !v.equals("")) continue;
                String msg = MessageFormat.format(FaDefResource.getResource((String)"cantNotWithEmpty"), ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"51_FaCurCardListUI", (Locale)ctx.getOriginLocale()) + card.getNumber() + ": \"" + p.getName() + "\"");
                throw new FaDataImportException(new NumericExceptionSubItem("def", msg));
            }
        }
    }
}

