/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaAlterModeFactory;
import com.kingdee.eas.fi.fa.basedata.FaAlterModeInfo;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeInfo;
import com.kingdee.eas.fi.fa.basedata.IFaAlterMode;
import com.kingdee.eas.fi.fa.def.FaDefPropertyValueInfo;
import com.kingdee.eas.fi.fa.facade.app.FaDAPChangeBillStrategy;
import com.kingdee.eas.fi.fa.manage.AbstractFaCardException;
import com.kingdee.eas.fi.fa.manage.AssistActItemInfo;
import com.kingdee.eas.fi.fa.manage.FaAppLogForBusinessTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaBakCardFactory;
import com.kingdee.eas.fi.fa.manage.FaBakCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBakCostCenterFactory;
import com.kingdee.eas.fi.fa.manage.FaBakDepartmentCollection;
import com.kingdee.eas.fi.fa.manage.FaBakDepartmentInfo;
import com.kingdee.eas.fi.fa.manage.FaBillBizProcessor;
import com.kingdee.eas.fi.fa.manage.FaBillTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaBizAsstActCompositCollection;
import com.kingdee.eas.fi.fa.manage.FaBizCardFactory;
import com.kingdee.eas.fi.fa.manage.FaBizCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBizCostCenterCollection;
import com.kingdee.eas.fi.fa.manage.FaBizCostCenterFactory;
import com.kingdee.eas.fi.fa.manage.FaBizCostCenterInfo;
import com.kingdee.eas.fi.fa.manage.FaBizDepartmentCollection;
import com.kingdee.eas.fi.fa.manage.FaBizDepartmentInfo;
import com.kingdee.eas.fi.fa.manage.FaBizStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.FaCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCardWebValidatorImpl;
import com.kingdee.eas.fi.fa.manage.FaChangeBillDAPVoucherSumCollection;
import com.kingdee.eas.fi.fa.manage.FaChangeBillDAPVoucherSumFactory;
import com.kingdee.eas.fi.fa.manage.FaChangeBillDAPVoucherSumInfo;
import com.kingdee.eas.fi.fa.manage.FaChangeBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaChangeBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaChangeBillFactory;
import com.kingdee.eas.fi.fa.manage.FaChangeBillInfo;
import com.kingdee.eas.fi.fa.manage.FaChangeTypeForVoucherEnum;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCostCenterFactory;
import com.kingdee.eas.fi.fa.manage.FaLeaseBillInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaMonCardFactory;
import com.kingdee.eas.fi.fa.manage.FaMonCardInfo;
import com.kingdee.eas.fi.fa.manage.FaWorkLoadCollection;
import com.kingdee.eas.fi.fa.manage.FaWorkLoadFactory;
import com.kingdee.eas.fi.fa.manage.FaWorkLoadInfo;
import com.kingdee.eas.fi.fa.manage.IFaBizCard;
import com.kingdee.eas.fi.fa.manage.IFaMonCard;
import com.kingdee.eas.fi.fa.manage.IFaWorkLoad;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaChangeBillControllerBean;
import com.kingdee.eas.fi.fa.manage.app.FaCardDefPropertyPersist;
import com.kingdee.eas.fi.fa.manage.app.FaLastPeriodChangeUtils;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.PrcFaChangeStrategy;
import com.kingdee.eas.fi.fa.manage.app.PrcFaCoreManager;
import com.kingdee.eas.fi.fa.manage.app.falog.event.FaMethodCalcOrderEnum;
import com.kingdee.eas.fi.fa.manage.app.falog.utils.FaRPCMethodMappingUtils;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class FaChangeBillControllerBean
extends AbstractFaChangeBillControllerBean {
    private static final String RESOURCE_PATH = "com.kingdee.eas.fi.fa.manage.FaCardResource";
    private static final long serialVersionUID = 2598422998855062996L;
    private static final BigDecimal ZERO = new BigDecimal("0");
    private PeriodInfo curPeriod;
    private final String IS_ADD_DISTRIBUTE_SUM = "isAddDistributeSum";
    protected boolean canShowProfit = false;

    protected boolean _checkStatusValid(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(new PrcFaChangeStrategy());
        prcFaCoreManager.getFaManageStrategy().checkForEdit(ctx, model);
        return true;
    }

    protected boolean _checkLineExist(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return false;
    }

    protected SystemEnum _getOwnedSys(Context ctx) throws BOSException, EASBizException {
        return SystemEnum.FIXEDASSETS;
    }

    @Override
    public IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        SelectorItemCollection changebillSic = this.getChangeBillSelectors();
        for (int i = 0; i < selector.size(); ++i) {
            SelectorItemInfo info = selector.get(i);
            changebillSic.add(info);
        }
        FaChangeBillInfo changeBillInfo = (FaChangeBillInfo)super._getValue(ctx, pk, changebillSic);
        return changeBillInfo;
    }

    @Override
    protected IObjectCollection _getCollection(Context ctx, IServiceContext svcCtx, EntityViewInfo view) throws BOSException {
        view.getSelector().addObjectCollection((IObjectCollection)this.getChangeBillSelectors());
        return super._getCollection(ctx, svcCtx, view);
    }

    private SelectorItemCollection getChangeBillSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("fiVouchered"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("changeMode.*"));
        sic.add(new SelectorItemInfo("changeBillEntry.*"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.faBakCard.id"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.number"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.assetValue"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.assetAmt"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.buyValue"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.buyAccuDepr"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.accuDepr"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.accuDeprTYear"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.decValue"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.isNeedReDepr"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.fiVouchered"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.tempDeprMethod"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.tempDeprTermCount"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.deprTermCount"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.deprMethod.*"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.currency.*"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.fiAccountDate"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.evalAssetValue"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.evalAddDepr"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.evalYearDepr"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.evalDecValue"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.evalDeprPeriodNum"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.evalDeprMode.*"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.accountAsset.number"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.accountAccuDepr.number"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.accountDecValue.number"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.voucher.id"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.voucherNumber"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.faBakCard.accountAsset.number"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.faBakCard.accountAccuDepr.number"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.faBakCard.accountDecValue.number"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.faBakCard.assetValue"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.faBakCard.accuDepr"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.faBakCard.decValue"));
        return sic;
    }

    @Override
    public void _passAuditSelf(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        FaLastPeriodChangeUtils.updateCardLastPeriodChange(ctx, ((FaChangeBillInfo)model).getCompany().getId().toString(), pk.toString(), 4);
    }

    @Override
    public void _unpassAuditSelf(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        FaLastPeriodChangeUtils.updateCardLastPeriodChange(ctx, ((FaChangeBillInfo)model).getCompany().getId().toString(), pk.toString(), 5);
    }

    @Override
    public void _deleteSelf(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (!FaManageUtils.deleteBill(ctx, pk.toString())) {
            super._delete(ctx, pk);
        }
    }

    @Override
    public void _submitSelf(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    public IObjectPK _submitSelf(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CoreBaseInfo coreBaseInfo = (CoreBaseInfo)model;
        if (this._isExistPropertyName(ctx, coreBaseInfo, "effectedStatus")) {
            coreBaseInfo.setInt("effectedStatus", 2);
        }
        ServiceStateManager.getInstance().enableNextCallServices();
        if (coreBaseInfo.getId() != null && this._exists(ctx, (IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
            ObjectUuidPK retValue = new ObjectUuidPK(coreBaseInfo.getId());
            this.update(ctx, (IObjectPK)retValue, coreBaseInfo);
            FaChangeBillEntryCollection changeBillCollection = ((FaChangeBillInfo)coreBaseInfo).getChangeBillEntry();
            for (int i = 0; i < changeBillCollection.size(); ++i) {
                FaChangeBillEntryInfo changeBillInfo = changeBillCollection.get(i);
                FaBizCardInfo bizCard = changeBillInfo.getBizCard();
                this.updateFaAsstActLName(ctx, bizCard);
                IFaBizCard iFaBizCard = FaBizCardFactory.getLocalInstance(ctx);
                iFaBizCard.update((IObjectPK)new ObjectUuidPK(bizCard.getId()), (CoreBaseInfo)bizCard);
            }
            FaLastPeriodChangeUtils.updateCardLastPeriodChange(ctx, ((FaChangeBillInfo)model).getCompany().getId().toString(), retValue.toString(), 3);
            return retValue;
        }
        IObjectPK retValue = this.addnew(ctx, coreBaseInfo);
        FaChangeBillEntryCollection changeBillCollection = ((FaChangeBillInfo)coreBaseInfo).getChangeBillEntry();
        for (int i = 0; i < changeBillCollection.size(); ++i) {
            FaChangeBillEntryInfo changeBillInfo = changeBillCollection.get(i);
            FaBizCardInfo bizCard = changeBillInfo.getBizCard();
            this.updateFaAsstActLName(ctx, bizCard);
            IFaBizCard iFaBizCard = FaBizCardFactory.getLocalInstance(ctx);
            iFaBizCard.update((IObjectPK)new ObjectUuidPK(bizCard.getId()), (CoreBaseInfo)bizCard);
        }
        FaLastPeriodChangeUtils.updateCardLastPeriodChange(ctx, ((FaChangeBillInfo)model).getCompany().getId().toString(), retValue.toString(), 3);
        return retValue;
    }

    @Override
    public void _saveSelf(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    public IObjectPK _saveSelf(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._save(ctx, model);
        FaLastPeriodChangeUtils.updateCardLastPeriodChange(ctx, ((FaChangeBillInfo)model).getCompany().getId().toString(), pk.toString(), 1);
        return pk;
    }

    @Override
    public void _deleteSelf(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model != null && model.getBoolean("forDAP")) {
            return this._submitSelf(ctx, model);
        }
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(new PrcFaChangeStrategy());
        FaChangeBillInfo changeBillInfo = (FaChangeBillInfo)model.get("changeBill");
        if (changeBillInfo != null && changeBillInfo.getBOSUuid("id") != null) {
            FaBillBizProcessor.lockTable(ctx, changeBillInfo.getId().toString());
            prcFaCoreManager.getFaManageStrategy().checkForEdit(ctx, (IObjectValue)changeBillInfo);
            this.checkBeforeSubmit(ctx, (FaCurCardInfo)model, true);
            this.verifyInput(ctx, (FaCurCardInfo)model, true);
        } else {
            FaCurCardInfo card = (FaCurCardInfo)model;
            FaBillBizProcessor.lockFaCurCard(ctx, card.getId().toString());
            FaBillBizProcessor.checkFaCurCardVersion(ctx, card.getId().toString(), card.getLastUpdateTime());
            BillBaseInfo billBaseInfo = (BillBaseInfo)model;
            if (billBaseInfo.getCompany() != null && billBaseInfo.getCompany().getId() != null) {
                prcFaCoreManager.getFaManageStrategy().checkUnAuditFaDep(ctx, prcFaCoreManager.getFaManageStrategy().getCurrentPeriod(ctx, billBaseInfo), billBaseInfo.getCompany());
            }
        }
        if (this.isCurrencyDisable(ctx, changeBillInfo)) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)RESOURCE_PATH, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append(" ");
            sbAll.append(ResourceBase.getString((String)RESOURCE_PATH, (String)"CurrencyDisable", (Locale)ctx.getOriginLocale()));
            throw new FaCardException(FaCardException.UN_SUCCESS, new String[]{sbAll.toString()});
        }
        return prcFaCoreManager.getFaManageStrategy().submitBill(ctx, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        try {
            CompanyOrgUnitInfo comp = (CompanyOrgUnitInfo)model.get("company");
            FaChangeBillInfo changeBillInfo = (FaChangeBillInfo)model.get("changeBill");
            this.setWorkflowServiceState(ctx, comp == null ? null : comp.getId().toString(), changeBillInfo == null || changeBillInfo.getId() == null ? null : changeBillInfo.getId().toString());
            IObjectPK iObjectPK = super.submit(ctx, model);
            return iObjectPK;
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    public void submit(Context ctx, IObjectPK pk, CoreBaseInfo model) throws BOSException, EASBizException {
        if (model instanceof FaCurCardInfo) {
            this.submit(ctx, model);
        } else if (model instanceof FaChangeBillInfo) {
            FaChangeBillInfo changeBillInfo = (FaChangeBillInfo)model;
            FaBizCardInfo bizCardInfo = changeBillInfo.getChangeBillEntry().get(0).getBizCard();
            FaCurCardInfo curCardInfo = FaManageUtils.BizCard2CurCardKeepId(bizCardInfo);
            curCardInfo.put("changeBill", changeBillInfo);
            this.submit(ctx, (CoreBaseInfo)curCardInfo);
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(new PrcFaChangeStrategy());
        FaChangeBillInfo changeBillInfo = null;
        if (model instanceof FaCurCardInfo) {
            changeBillInfo = (FaChangeBillInfo)model.get("changeBill");
            FaCurCardInfo card = (FaCurCardInfo)model;
            FaBillBizProcessor.lockFaCurCard(ctx, card.getId().toString());
            FaBillBizProcessor.checkFaCurCardVersion(ctx, card.getId().toString(), card.getLastUpdateTime());
        } else if (model instanceof FaChangeBillInfo) {
            changeBillInfo = (FaChangeBillInfo)model;
        }
        if (changeBillInfo != null && changeBillInfo.getBOSUuid("id") != null) {
            FaBillBizProcessor.lockTable(ctx, changeBillInfo.getId().toString());
            prcFaCoreManager.getFaManageStrategy().checkForSave(ctx, (IObjectValue)changeBillInfo);
        } else {
            BillBaseInfo billBaseInfo = (BillBaseInfo)model;
            if (billBaseInfo.getCompany() != null && billBaseInfo.getCompany().getId() != null) {
                prcFaCoreManager.getFaManageStrategy().checkUnAuditFaDep(ctx, prcFaCoreManager.getFaManageStrategy().getCurrentPeriod(ctx, billBaseInfo), billBaseInfo.getCompany());
            }
        }
        if (this.isCurrencyDisable(ctx, changeBillInfo)) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)RESOURCE_PATH, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append(" ");
            sbAll.append(ResourceBase.getString((String)RESOURCE_PATH, (String)"CurrencyDisable", (Locale)ctx.getOriginLocale()));
            throw new FaCardException(FaCardException.UN_SUCCESS, new String[]{sbAll.toString()});
        }
        return prcFaCoreManager.getFaManageStrategy().saveBill(ctx, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FaBillBizProcessor.lockTable(ctx, pk.toString());
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(new PrcFaChangeStrategy());
        prcFaCoreManager.getFaManageStrategy().checkForDelete(ctx, pk);
        prcFaCoreManager.getFaManageStrategy().deleteBill(ctx, pk);
    }

    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            this.setWorkflowServiceState(ctx, pk);
            super.delete(ctx, pk);
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    @Override
    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        FaBillBizProcessor.lockTable(ctx, pk.toString());
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(new PrcFaChangeStrategy());
        prcFaCoreManager.getFaManageStrategy().checkForAudit(ctx, pk);
        BillBaseInfo billInfo = prcFaCoreManager.getFaManageStrategy().perpareBillInfo(ctx, pk);
        if (this.isCurrencyDisable(ctx, (FaChangeBillInfo)billInfo)) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)RESOURCE_PATH, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append(" ");
            sbAll.append(ResourceBase.getString((String)RESOURCE_PATH, (String)"CurrencyDisable", (Locale)ctx.getOriginLocale()));
            throw new FaCardException(FaCardException.UN_SUCCESS, new String[]{sbAll.toString()});
        }
        FaChangeBillInfo bill = new FaChangeBillInfo();
        bill.setId(BOSUuid.read((String)pk.toString()));
        prcFaCoreManager.getFaManageStrategy().auditBill(ctx, (IObjectValue)bill);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void passAudit(Context ctx, IObjectPK pk, BillBaseInfo model) throws BOSException, EASBizException {
        try {
            this.setWorkflowServiceState(ctx, pk);
            super.passAudit(ctx, pk, model);
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    @Override
    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        if (model == null) {
            model = this.getValue(ctx, pk, new SelectorItemCollection());
        }
        FaChangeBillInfo billInfo = (FaChangeBillInfo)model;
        PeriodInfo period = this.getCurrentPeriod(ctx);
        IFaAlterMode iAlterMode = FaAlterModeFactory.getLocalInstance((Context)ctx);
        if (iAlterMode.exists("where id='" + billInfo.getChangeMode().getId() + "' and number='000'")) {
            boolean isInCurPeriod;
            boolean bl = isInCurPeriod = billInfo.getChangeDate().after(period.getBeginDate()) && billInfo.getChangeDate().before(period.getEndDate());
            if (billInfo.getChangeDate().equals(period.getBeginDate()) || billInfo.getChangeDate().equals(period.getEndDate())) {
                isInCurPeriod = true;
            }
            if (isInCurPeriod) {
                DbUtil.execute((Context)ctx, (String)("update T_fa_fachangebill set fperiodId = '" + period.getId().toString() + "' where fid = '" + pk.toString() + "'"));
                billInfo.setPeriod(period);
            }
        }
        FaBillBizProcessor.lockTable(ctx, pk.toString());
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(new PrcFaChangeStrategy());
        prcFaCoreManager.getFaManageStrategy().checkForUnAudit(ctx, pk);
        prcFaCoreManager.getFaManageStrategy().unAuditBill(ctx, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unpassAudit(Context ctx, IObjectPK pk, BillBaseInfo model) throws BOSException, EASBizException {
        try {
            this.setWorkflowServiceState(ctx, pk);
            super.unpassAudit(ctx, pk, model);
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    protected boolean _checkNumberDup(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        BillBaseInfo billBaseInfo = (BillBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)billBaseInfo.getString("number"), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (billBaseInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)billBaseInfo.getId().toString(), CompareType.NOTEQUALS));
        }
        if (billBaseInfo.getCompany() != null) {
            filter.getFilterItems().add(new FilterItemInfo("company", (Object)billBaseInfo.getCompany().getId().toString(), CompareType.EQUALS));
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            if (i != 0) {
                sb.append(" and #" + i);
                continue;
            }
            sb.append("#" + i);
        }
        filter.setMaskString(sb.toString());
        if (super._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{billBaseInfo.getString("number"), ""});
        }
        return true;
    }

    protected DAPTransformResult _generateVoucher(Context ctx, IObjectCollection sourceBillCollection, IObjectPK botMappingPK) throws BOSException, EASBizException {
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(new PrcFaChangeStrategy());
        FaDAPChangeBillStrategy dAPTransStrategy = new FaDAPChangeBillStrategy();
        int size = sourceBillCollection.size();
        for (int i = 0; i < size; ++i) {
            FaChangeBillInfo changeBill = (FaChangeBillInfo)sourceBillCollection.getObject(i);
            if (changeBill == null) continue;
            prcFaCoreManager.getFaManageStrategy().checkForOperate(ctx, changeBill, 2);
            FaChangeBillEntryCollection entryCol = changeBill.getChangeBillEntry();
            FaChangeBillEntryInfo entryInfo = entryCol.get(0);
            BigDecimal bZero = new BigDecimal("0.0");
            if (entryInfo != null && entryInfo.getOriginChg().compareTo(bZero) == 0 && entryInfo.getAccuDeprChg().compareTo(bZero) == 0 && entryInfo.getDecValueChg().compareTo(bZero) == 0 && !this.isDepartChangeNeedVourcher(ctx, (IObjectValue)changeBill)) {
                String bizAccountSql = "select accountAsset.id,accountAccuDepr.id,accountDecValue.id where id='" + entryInfo.getBizCard().getId() + "'";
                String bakAccountSql = "select accountAsset.id,accountAccuDepr.id,accountDecValue.id where id='" + entryInfo.getBizCard().getFaBakCard().getId() + "'";
                FaBizCardInfo bizCard = FaBizCardFactory.getLocalInstance(ctx).getFaBizCardInfo(bizAccountSql);
                FaBakCardInfo oldCard = FaBakCardFactory.getLocalInstance(ctx).getFaBakCardInfo(bakAccountSql);
                if (this.isAccountEqual(bizCard.getAccountAsset(), oldCard.getAccountAsset()) && this.isAccountEqual(bizCard.getAccountAccuDepr(), oldCard.getAccountAccuDepr()) && this.isAccountEqual(bizCard.getAccountDecValue(), oldCard.getAccountDecValue())) {
                    throw new FaCardException(FaCardException.DONT_HAVE_TO_GENVOUCHER);
                }
            }
            if (entryInfo.getCurCard() != null) {
                String oql = "select id, seq, asstActLName, asstActItem.id, asstActType.id, accountView.id, remark, apportionScale, faCurCard.id, faCurAsstActComposit.id, faCurAsstActComposit.seq, faCurAsstActComposit.asstActType.id, faCurAsstActComposit.asstActItem.id, faCurAsstActComposit.faCurCostCenter.id where faCurCard.id='" + entryInfo.getCurCard().getId() + "'";
                entryInfo.getCurCard().put("faCurCostCenter", (Object)FaCurCostCenterFactory.getLocalInstance(ctx).getFaCurCostCenterCollection(oql));
                if (entryInfo.getBizCard() != null && entryInfo.getBizCard().getFaBakCard() != null) {
                    oql = "select id, seq, asstActLName, asstActItem.id, asstActType.id, accountView.id, remark, apportionScale, faBizCard.id, faBizAsstActComposit.id, faBizAsstActComposit.seq, faBizAsstActComposit.asstActType.id, faBizAsstActComposit.asstActItem.id, faBizAsstActComposit.faBizCostCenter.id where faBizCard.id='" + entryInfo.getBizCard().getId() + "'";
                    entryInfo.getBizCard().put("faBizCostCenter", (Object)FaBizCostCenterFactory.getLocalInstance(ctx).getFaBizCostCenterCollection(oql));
                    oql = "select id, seq, asstActLName, asstActItem.id, asstActType.id, accountView.id, remark, apportionScale, faBakCard.id, faBakAsstActComposit.id, faBakAsstActComposit.seq, faBakAsstActComposit.asstActType.id, faBakAsstActComposit.asstActItem.id, faBakAsstActComposit.faBakCostCenter.id where faBakCard.id='" + entryInfo.getBizCard().getFaBakCard().getId() + "'";
                    entryInfo.getBizCard().getFaBakCard().put("faBakCostCenter", (Object)FaBakCostCenterFactory.getLocalInstance(ctx).getFaBakCostCenterCollection(oql));
                }
            }
            sourceBillCollection.setObject(i, (IObjectValue)dAPTransStrategy.process4DAP((BillBaseInfo)changeBill, ctx));
        }
        HashSet cardIdSet = new HashSet();
        this.getChangedFaBizCardIdSet(ctx, sourceBillCollection, cardIdSet);
        FaChangeBillInfo faChangeBillInfo = (FaChangeBillInfo)sourceBillCollection.getObject(0);
        this.insertFaCardSumData(ctx, faChangeBillInfo, cardIdSet);
        FaChangeBillDAPVoucherSumCollection changeBillSumCollection = this.getFaChangeBillDAPVoucherSumInfo(ctx, faChangeBillInfo.getId().toString());
        faChangeBillInfo.put("faChangeBillSum", (Object)changeBillSumCollection);
        FaChangeBillDAPVoucherSumCollection zeroSumCollection = new FaChangeBillDAPVoucherSumCollection();
        int size2 = sourceBillCollection.size();
        for (int i = 0; i < size2; ++i) {
            FaChangeBillInfo changeBillInfo = (FaChangeBillInfo)sourceBillCollection.getObject(i);
            if (zeroSumCollection.size() == 0) {
                changeBillInfo.put("faChangeBillSum", (Object)changeBillSumCollection);
                int m = changeBillSumCollection.size();
                for (int n = 0; n < m; ++n) {
                    FaChangeBillDAPVoucherSumInfo faChangeBillDAPVoucherSumInfo = (FaChangeBillDAPVoucherSumInfo)changeBillSumCollection.get(n).clone();
                    faChangeBillDAPVoucherSumInfo.setAsstAmount(BigDecimal.ZERO);
                    faChangeBillDAPVoucherSumInfo.setDeprAmount(BigDecimal.ZERO);
                    faChangeBillDAPVoucherSumInfo.setDecAmount(BigDecimal.ZERO);
                    zeroSumCollection.add(faChangeBillDAPVoucherSumInfo);
                }
                continue;
            }
            changeBillInfo.put("faChangeBillSum", (Object)zeroSumCollection);
        }
        return super._generateVoucher(ctx, sourceBillCollection, botMappingPK);
    }

    private boolean isAccountEqual(AccountViewInfo src, AccountViewInfo target) {
        if (src == null && target != null || src != null && target == null) {
            return false;
        }
        if (src == null && target == null) {
            return true;
        }
        return src.getId().toString().equals(target.getId().toString());
    }

    protected boolean isVoucherFlag(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("fiVouchered"));
        sic.add(new SelectorItemInfo("id"));
        FaChangeBillInfo coreBillInfo = (FaChangeBillInfo)super._getValue(ctx, pk, sic);
        return coreBillInfo.isFiVouchered();
    }

    @Override
    protected void _batchSubmit(Context ctx, FaChangeBillInfo[] changebills) throws BOSException, EASBizException {
        FaChangeBillInfo changeBillInfo;
        if (changebills == null) {
            return;
        }
        for (int m = 0; m < changebills.length; ++m) {
            changeBillInfo = changebills[m];
            FaChangeBillEntryCollection collect = changeBillInfo.getChangeBillEntry();
            for (int n = 0; n < collect.size(); ++n) {
                FaCurCardInfo card = collect.get(n).getCurCard();
                FaBillBizProcessor.lockFaCurCard(ctx, card.getId().toString());
                FaBillBizProcessor.checkFaCurCardVersion(ctx, card.getId().toString(), card.getLastUpdateTime());
            }
        }
        for (int i = 0; i < changebills.length; ++i) {
            changeBillInfo = changebills[i];
            FaLocalUtils.verifyForLastestPeriod(ctx, (IObjectValue)changeBillInfo, 3);
            this.setNewNumber(ctx, changeBillInfo);
            FaChangeBillEntryCollection entryColl = changeBillInfo.getChangeBillEntry();
            for (int j = 0; j < entryColl.size(); ++j) {
                FaBizCardInfo bizCard = entryColl.get(j).getBizCard();
                FaBakCardInfo bakCard = bizCard.getFaBakCard();
                bakCard.setId((BOSUuid)FaBakCardFactory.getLocalInstance(ctx).submit((CoreBaseInfo)bakCard).getKeyValue("id"));
            }
            IObjectPK pk = FaChangeBillFactory.getLocalInstance(ctx).submitSelf((CoreBaseInfo)changeBillInfo);
            for (int j = 0; j < entryColl.size(); ++j) {
                FaCurCardInfo cardInfo = entryColl.get(j).getCurCard();
                this.updateCurCardBySQL(ctx, "0101", pk.toString(), cardInfo.getId().toString().toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batchSubmit(Context ctx, FaChangeBillInfo[] changebills) throws BOSException, EASBizException {
        if (changebills.length == 0) {
            return;
        }
        try {
            FaChangeBillInfo changeBillInfo = changebills[0];
            CompanyOrgUnitInfo comp = changeBillInfo.getCompany();
            this.setWorkflowServiceState(ctx, comp == null ? null : comp.getId().toString(), null);
            super.batchSubmit(ctx, changebills);
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    @Override
    protected Map _buildChangeBills(Context ctx, FaCurCardInfo[] cards) throws BOSException, EASBizException {
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(new PrcFaChangeStrategy());
        prcFaCoreManager.getFaManageStrategy().checkUnAuditFaDep(ctx, this.getCurrentPeriod(ctx), ContextUtil.getCurrentFIUnit((Context)ctx));
        StringBuffer info = new StringBuffer();
        ArrayList<FaChangeBillInfo> changebills = new ArrayList<FaChangeBillInfo>();
        PeriodInfo currPeriod = this.getCurrentPeriod(ctx);
        String strCard = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaChangeResource", (String)"card", (Locale)ctx.getOriginLocale());
        String cantChange = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaChangeResource", (String)"cantChange", (Locale)ctx.getOriginLocale());
        PrcFaChangeStrategy changeStrategy = new PrcFaChangeStrategy();
        for (int i = 0; i < cards.length; ++i) {
            FaDefPropertyValueInfo pv;
            FaCurCardInfo cardInfo = cards[i];
            FaCurCardInfo curCardold = (FaCurCardInfo)cardInfo.get("oldCard");
            FaBakCardInfo bakCard = PrcFaCoreManager.CurCard2BakCard(curCardold);
            FaBizCardInfo bizCard = PrcFaCoreManager.CurCard2BizCard(cardInfo);
            if (curCardold.getPropertyValue() != null) {
                pv = FaCardDefPropertyPersist.copy(curCardold.getPropertyValue().getId(), ctx);
                bakCard.setPropertyValue(pv);
            }
            if (cardInfo.getPropertyValue() != null) {
                pv = FaCardDefPropertyPersist.save(cardInfo.getPropertyValue(), ctx);
                cardInfo.setPropertyValue(pv);
                if (pv != null) {
                    pv = FaCardDefPropertyPersist.copy(pv.getId(), ctx);
                    bizCard.setPropertyValue(pv);
                }
            }
            try {
                changeStrategy.checkFaCurCardValid(ctx, cardInfo, curCardold);
                if (cardInfo.getAssetValue().compareTo(curCardold.getAssetValue()) > 0 && cardInfo.getUseTermCount().compareTo(cardInfo.getDeprTermCount()) == 0) {
                    throw new FaCardException(FaCardException.CANNOT_ADD_ASSET_WITHOUT_USETERMCNT);
                }
                bakCard.setFaCurCard(curCardold);
                bakCard.setBillType(FaBillTypeEnum.CHANGE);
                FaLocalUtils.verifyCardLimitAmt(bizCard);
                bizCard.setFaBakCard(bakCard);
                bizCard.setBillType(FaBillTypeEnum.CHANGE);
                bizCard.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
                changeStrategy.checkSameChangeBill(ctx, bakCard, bizCard, curCardold, currPeriod);
            }
            catch (FaCardException ex) {
                info.append("\uff1b").append(ex.getMessage());
                info.append(strCard).append(cardInfo.getNumber()).append("(").append(cardInfo.getAssetName()).append(")");
                info.append(cantChange);
                continue;
            }
            FaChangeBillInfo changeBillInfo = new FaChangeBillInfo();
            changeBillInfo.setChangeDate((Date)cardInfo.get("changeDate"));
            changeBillInfo.setChangeMode((FaAlterModeInfo)cardInfo.get("changeMode"));
            changeBillInfo.setDescription((String)cardInfo.get("description"));
            changeBillInfo.setHandler(ContextUtil.getCurrentUserInfo((Context)ctx));
            changeBillInfo.setPeriod(this.getCurrentPeriod(ctx));
            changeBillInfo.setCompany(ContextUtil.getCurrentFIUnit((Context)ctx));
            changeBillInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
            changeBillInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
            changeBillInfo.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
            changeBillInfo.setFiVouchered(false);
            changeBillInfo.setEffectedStatus(EffectedStatusEnum.EFFECTED);
            FaChangeBillEntryInfo entryInfo = new FaChangeBillEntryInfo();
            entryInfo.setBizCard(bizCard);
            entryInfo.setCurCard(cardInfo);
            int oldScale = curCardold.getCurrency() != null ? curCardold.getCurrency().getPrecision() : 2;
            int newScale = cardInfo.getCurrency() != null ? cardInfo.getCurrency().getPrecision() : 2;
            BigDecimal zeroValue = new BigDecimal("0");
            entryInfo.setOriginChg((cardInfo.getAssetValue() != null ? cardInfo.getAssetValue().setScale(newScale, 4) : zeroValue).subtract(curCardold.getAssetValue() != null ? curCardold.getAssetValue().setScale(oldScale, 4) : zeroValue));
            entryInfo.setAccuDeprChg((cardInfo.getAccuDepr() != null ? cardInfo.getAccuDepr().setScale(newScale, 4) : zeroValue).subtract(curCardold.getAccuDepr() != null ? curCardold.getAccuDepr().setScale(oldScale, 4) : zeroValue));
            entryInfo.setDecValueChg((cardInfo.getDecValue() != null ? cardInfo.getDecValue().setScale(newScale, 4) : zeroValue).subtract(curCardold.getDecValue() != null ? curCardold.getDecValue().setScale(oldScale, 4) : zeroValue));
            changeBillInfo.getChangeBillEntry().add(entryInfo);
            changebills.add(changeBillInfo);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("info", info.length() > 0 ? info.substring(1) : null);
        result.put("changebills", changebills);
        return result;
    }

    protected void setNewNumber(Context ctx, FaChangeBillInfo billInfo) throws EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = billInfo.getCompany();
        if (aCompanyOrgUnitInfo == null) {
            aCompanyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        String strCompanyId = aCompanyOrgUnitInfo.getId().toString();
        PeriodInfo aPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
        billInfo.setBizDate(aPeriodInfo.getEndDate());
        String number = iCodingRuleManager.getNumber((IObjectValue)billInfo, strCompanyId);
        billInfo.setNumber(number);
        if (this.existNumber(ctx, (IObjectValue)billInfo)) {
            this.setNewNumber(ctx, billInfo);
        }
    }

    protected boolean existNumber(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        FaChangeBillInfo billInfo = (FaChangeBillInfo)model;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FID FROM T_FA_FACHANGEBILL WHERE FNUMBER = '");
        sql.append(billInfo.getNumber()).append("'");
        sql.append(" AND FCOMPANYID = '").append(billInfo.getCompany().getId().toString()).append("'");
        if (billInfo.getId() != null) {
            sql.append(" AND FID != '").append(billInfo.getId().toString()).append("'");
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            return rowSet.next();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected boolean existCard(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        FaChangeBillInfo billInfo = (FaChangeBillInfo)model;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FID FROM T_FA_FACHANGEBILL WHERE  FCOMPANYID = '").append(billInfo.getCompany().getId().toString());
        sql.append("'");
        if (billInfo.getId() != null) {
            sql.append(" AND FID = '").append(billInfo.getId().toString()).append("'");
        }
        sql.append(" and fchangemodeid=(select fid from t_fa_altermode where fnumber='000' and fcompanyid='");
        sql.append(billInfo.getCompany().getId().toString()).append("')");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            return rowSet.next();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected PeriodInfo getCurrentPeriod(Context ctx) throws EASBizException, BOSException {
        if (this.curPeriod == null) {
            this.curPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)ContextUtil.getCurrentFIUnit((Context)ctx));
        }
        return this.curPeriod;
    }

    protected void updateCurCardBySQL(Context ctx, String bizStatus, String lastBillID, String curCardID) throws BOSException {
        String sql = "update T_FA_FACURCARD set fbizStatus = '" + bizStatus + "',flastBillID = " + (lastBillID == null ? "NULL" : "'" + lastBillID + "'") + ",flastupdatetime = GETDATE() where fid = '" + curCardID + "'";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    public IObjectPK addnew(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        FaChangeBillInfo billInfo = (FaChangeBillInfo)model;
        if (billInfo.getEffectedStatus().getValue() == 2) {
            this.verifyChangeInit(ctx, billInfo);
            this.checkForSubmitSelf(ctx, billInfo);
        }
        return super.addnew(ctx, model);
    }

    public void update(Context ctx, IObjectPK pk, CoreBaseInfo model) throws BOSException, EASBizException {
        FaChangeBillInfo billInfo = (FaChangeBillInfo)model;
        if (billInfo.getEffectedStatus().getValue() == 2 && billInfo.getCheckedStatus().getValue() == 1) {
            this.verifyChangeInit(ctx, billInfo);
        }
        super.update(ctx, pk, model);
    }

    private void verifyChangeInit(Context ctx, FaChangeBillInfo billInfo) throws BOSException, EASBizException {
        PeriodInfo period = FaLocalUtils.getCurrentPeriod(ctx, billInfo.getCompany().getId().toString());
        IFaAlterMode iAlterMode = FaAlterModeFactory.getLocalInstance((Context)ctx);
        if (!iAlterMode.exists("where id='" + billInfo.getChangeMode().getId() + "' and number='000'")) {
            billInfo.setPeriod(period);
            return;
        }
        PeriodInfo preAdjPeriodInfo = PeriodUtils.getPreAdjPeriodInfo((Context)ctx, (PeriodInfo)period);
        if (preAdjPeriodInfo == null || !preAdjPeriodInfo.isIsAdjustPeriod()) {
            throw new FaCardException(FaCardException.ADJ_PREIDO_NOT_FOUND);
        }
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)ContextUtil.getCurrentFIUnit((Context)ctx));
        if (startPeriod.getPeriodYear() > preAdjPeriodInfo.getPeriodYear()) {
            throw new FaCardException(FaCardException.ADJ_NOT_NEED);
        }
        IFaMonCard iMonCard = FaMonCardFactory.getLocalInstance(ctx);
        billInfo.setPeriod(period);
        String sql = "select id where periodyear=" + period.getPeriodYear() + " and periodnumber<= " + period.getPeriodNumber() + " and periodType.id ='" + period.getPeriodType().getId() + "'";
        PeriodCollection periods = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(sql);
        HashSet<String> periodIdSet = new HashSet<String>();
        StringBuffer _periodIds = new StringBuffer();
        for (int i = 0; i < periods.size(); ++i) {
            periodIdSet.add(periods.get(i).getId().toString());
            _periodIds.append("'" + periods.get(i).getId() + "',");
        }
        HashSet<String> cardSet = new HashSet<String>();
        cardSet.add(billInfo.getChangeBillEntry().get(0).getCurCard().getId().toString());
        if (!(billInfo.getId() != null && !billInfo.getChangeMode().getNumber().equals("000") || billInfo.getId() != null && this.existCard(ctx, (IObjectValue)billInfo))) {
            FaLocalUtils.hasFANewBiz(ctx, periodIdSet, cardSet, billInfo.getCompany().getId().toString());
        }
        String periodIds = _periodIds.substring(0, _periodIds.length() - 1);
        try {
            IRowSet rs = null;
            FaChangeBillEntryCollection entries = billInfo.getChangeBillEntry();
            for (int i = 0; i < entries.size(); ++i) {
                String checkSql;
                FaChangeBillEntryInfo entry = entries.get(i);
                BigDecimal diffAmt = entry.getOriginChg();
                BigDecimal diffAccu = entry.getAccuDeprChg();
                if (!iMonCard.exists("select id where faCurCard.id='" + entry.getCurCard().getId() + "' and faPeriod.id='" + preAdjPeriodInfo.getId() + "'")) {
                    throw new FaCardException(FaCardException.CARD_ADJ_NO_NEED, new Object[]{" "});
                }
                if (periods.size() > 1) {
                    String queryCat = "select 1 from t_fa_cat where fid = ? and FCalcuByEvaluate !=(select cat.FCalcuByEvaluate from t_fa_facurcard card inner join t_fa_cat cat on card.FAssetCatID=cat.fid where card.fid=?)";
                    rs = DbUtil.executeQuery((Context)ctx, (String)queryCat, (Object[])new Object[]{entry.getBizCard().getAssetCat().getId().toString(), entry.getCurCard().getId().toString()});
                    if (rs.next()) {
                        throw new FaCardException(FaCardException.CANNOT_MODIFY_WHEN_CAT_POLICY_LIMIT, new Object[]{entry.getBizCard().getNumber()});
                    }
                    if (periods.size() > 2 && (rs = DbUtil.executeQuery((Context)ctx, (String)(queryCat = "select count(distinct(cat.FCalcuByEvaluate)) from t_fa_famoncard card inner join t_fa_cat cat on cat.fid=card.FAssetCatID where card.FFaCurCardID=? and card.FFaPeriodID in (" + periodIds + ")"), (Object[])new Object[]{entry.getCurCard().getId().toString()})).next() && rs.getInt(1) > 1) {
                        throw new FaCardException(FaCardException.CANNOT_MODIFY_WHEN_CAT_INCONSITENT, new Object[]{entry.getBizCard().getNumber()});
                    }
                }
                if (diffAmt.compareTo(ZERO) < 0) {
                    checkSql = "select p.fperiodyear,p.fperiodnumber,moncard.fnumber from t_fa_famoncard moncard inner join t_bd_period p on moncard.ffaperiodid=p.fid where moncard.fassetvalue+(" + diffAmt + ") <=0 and p.fid in(" + periodIds + ") and moncard.FFaCurCardID=?";
                    rs = DbUtil.executeQuery((Context)ctx, (String)checkSql, (Object[])new Object[]{entry.getCurCard().getId().toString()});
                    if (rs.next()) {
                        throw new FaCardException(FaCardException.MONCARD_AMT_LESSTHAN_CHG, new Object[]{rs.getString(1), rs.getString(2), rs.getString(3)});
                    }
                    checkSql = "select p.fperiodyear,p.fperiodnumber,card.fnumber from t_fa_faaccountbalance bal inner join t_fa_facurcard card on card.fid=bal.FFaCurCardID inner join t_bd_period p on bal.FPeriodID=p.fid where (bal.FRealBeginBalanceFor+(" + diffAmt + ") <0 or bal.FRealEndBalanceFor+(" + diffAmt + ") <0) and p.fid in(" + periodIds + ") and bal.FFaCurCardID=?";
                    rs = DbUtil.executeQuery((Context)ctx, (String)checkSql, (Object[])new Object[]{entry.getCurCard().getId().toString()});
                    if (rs.next()) {
                        throw new FaCardException(FaCardException.BALANCE_AMT_LESSTHAN_CHG, new Object[]{rs.getString(1), rs.getString(2), rs.getString(3)});
                    }
                }
                if (diffAccu.compareTo(ZERO) >= 0) continue;
                checkSql = "select p.fperiodyear,p.fperiodnumber,moncard.fnumber from t_fa_famoncard moncard inner join t_bd_period p on moncard.ffaperiodid=p.fid where moncard.faccudepr+(" + diffAccu + ") <0 and p.fid in(" + periodIds + ") and moncard.FFaCurCardID=?";
                rs = DbUtil.executeQuery((Context)ctx, (String)checkSql, (Object[])new Object[]{entry.getCurCard().getId().toString()});
                if (rs.next()) {
                    throw new FaCardException(FaCardException.MONCARD_ACCU_LESSTHAN_CHG, new Object[]{rs.getString(1), rs.getString(2), rs.getString(3)});
                }
                checkSql = "select p.fperiodyear,p.fperiodnumber,card.fnumber from t_fa_faaccountbalance bal inner join t_fa_facurcard card on card.fid=bal.FFaCurCardID inner join t_bd_period p on bal.FPeriodID=p.fid where (bal.FDepreBeginBalanceFor+(" + diffAccu + ") <0 or bal.FDepreEndBalanceFor+(" + diffAccu + ") <0) and p.fid in(" + periodIds + ") and bal.FFaCurCardID=?";
                rs = DbUtil.executeQuery((Context)ctx, (String)checkSql, (Object[])new Object[]{entry.getCurCard().getId().toString()});
                if (!rs.next()) continue;
                throw new FaCardException(FaCardException.BALANCE_ACCU_LESSTHAN_CHG, new Object[]{rs.getString(1), rs.getString(2), rs.getString(3)});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void setWorkflowServiceState(Context ctx, IObjectPK objId) throws BOSException, EASBizException {
        CompanyOrgUnitInfo comp = (CompanyOrgUnitInfo)this.getFaChangeBillInfo(ctx, "select company.id where id='" + objId + "'").get("company");
        this.setWorkflowServiceState(ctx, comp.getId().toString(), objId.toString());
    }

    protected void setWorkflowServiceState(Context ctx, String companyId, String objId) throws BOSException, EASBizException {
        boolean isUseWorkflow = FaManageUtils.isUseWorkflow(ctx, companyId, this.getClass());
        if (!isUseWorkflow && (objId == null || objId != null && !FaLocalUtils.isRunningWorkflow(ctx, objId))) {
            WfEventListenerStateManager.getInstance().disableEventListener();
        }
    }

    @Override
    protected IObjectValue _getChangeInfoBySelector(Context ctx, EntityViewInfo entityview) throws BOSException, EASBizException {
        return (FaChangeBillInfo)super._getValue(ctx, entityview.toString());
    }

    @Override
    protected IObjectCollection _getChangeCollectionBySelector(Context ctx, EntityViewInfo entityview) throws BOSException, EASBizException {
        return super.getFaChangeBillCollection(ctx, entityview.toString());
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        VoucherInfo voucher = FaLocalUtils.LookVoucherInfo(ctx, bOTRelationInfo);
        if (bOTBillOperStateEnum == BOTBillOperStateEnum.ADDNEW) {
            DbUtil.execute((Context)ctx, (String)"update T_FA_FaChangeBill set FFiVouchered = 1, FhasDepartmentChanged = 0, FVoucherID = ?, FVoucherNumber = ?, FAbstract = ? where fid = ?", (Object[])new Object[]{voucher.getId().toString(), voucher.getNumber(), voucher.getVoucherAbstract(), srcBillVO.get("id").toString()});
        } else if (bOTBillOperStateEnum == BOTBillOperStateEnum.DELETE) {
            DbUtil.execute((Context)ctx, (String)"update T_FA_FaChangeBill set FFiVouchered = 0, FVoucherID = null, FVoucherNumber = null, FAbstract = null where fid = ?", (Object[])new Object[]{srcBillVO.get("id").toString()});
            if (this.isDepartChangeNeedVourcher(ctx, srcBillVO)) {
                DbUtil.execute((Context)ctx, (String)"update T_FA_FaChangeBill set FhasDepartmentChanged = 1 where fid = ?", (Object[])new Object[]{srcBillVO.get("id").toString()});
            }
        } else if (bOTBillOperStateEnum == BOTBillOperStateEnum.EDIT) {
            DbUtil.execute((Context)ctx, (String)"update T_FA_FaChangeBill set FVoucherNumber = ?, FAbstract = ? where fid = ?", (Object[])new Object[]{voucher.getNumber(), voucher.getVoucherAbstract(), srcBillVO.get("id").toString()});
        } else {
            super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
        }
    }

    private boolean isDepartChangeNeedVourcher(Context ctx, IObjectValue srcBillVO) throws EASBizException, BOSException {
        SelectorItemCollection sicBill = new SelectorItemCollection();
        sicBill.add(new SelectorItemInfo("id"));
        sicBill.add(new SelectorItemInfo("changeBillEntry.id"));
        sicBill.add(new SelectorItemInfo("changeBillEntry.bizCard.id"));
        FaChangeBillInfo billInfo = this.getFaChangeBillInfo(ctx, (IObjectPK)new ObjectUuidPK(srcBillVO.get("id").toString()), sicBill);
        FaChangeBillEntryCollection collection = billInfo.getChangeBillEntry();
        if (collection == null) {
            return false;
        }
        HashMap map = FaManageUtils.getFAParameter(ContextUtil.getCurrentFIUnit((Context)ctx).getId(), ctx);
        boolean departChangeNeedVoucher = false;
        if (map != null && map.get("FA_039") != null && map.get("FA_039").toString().equals("true")) {
            departChangeNeedVoucher = true;
        }
        if (!departChangeNeedVoucher) {
            return false;
        }
        for (int i = 0; i < collection.size(); ++i) {
            FaBizCardInfo bizCardInfo;
            FaChangeBillEntryInfo entryInfo = collection.get(i);
            if (entryInfo == null || (bizCardInfo = entryInfo.getBizCard()) == null || bizCardInfo.getId() == null) continue;
            SelectorItemCollection sicBizCard = new SelectorItemCollection();
            sicBizCard.add(new SelectorItemInfo("id"));
            sicBizCard.add(new SelectorItemInfo("faBakCard.id"));
            sicBizCard.add(new SelectorItemInfo("faBizDepartment.id"));
            sicBizCard.add(new SelectorItemInfo("faBizDepartment.useDepartment.id"));
            bizCardInfo = FaBizCardFactory.getLocalInstance(ctx).getFaBizCardInfo((IObjectPK)new ObjectUuidPK(bizCardInfo.getId()), sicBizCard);
            FaBakCardInfo bakCardInfo = bizCardInfo.getFaBakCard();
            if (bakCardInfo == null || bakCardInfo.getId() == null) continue;
            SelectorItemCollection sic = new SelectorItemCollection();
            PrcFaCoreManager.getBakCardSelectors();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("faBakDepartment.id"));
            sic.add(new SelectorItemInfo("faBakDepartment.useDepartment.id"));
            bakCardInfo = FaBakCardFactory.getLocalInstance(ctx).getFaBakCardInfo((IObjectPK)new ObjectUuidPK(bakCardInfo.getId()), sic);
            return this.isDepartMentChanged(bakCardInfo, bizCardInfo);
        }
        return false;
    }

    private boolean isDepartMentChanged(FaBakCardInfo bakCardInfo, FaBizCardInfo bizCardInfo) {
        FaBakDepartmentCollection bakCollection = bakCardInfo.getFaBakDepartment();
        FaBizDepartmentCollection bizcollCollection = bizCardInfo.getFaBizDepartment();
        if (bakCollection.size() != bizcollCollection.size()) {
            return true;
        }
        HashMap<BOSUuid, Integer> map = new HashMap<BOSUuid, Integer>();
        for (int j = 0; j < bizcollCollection.size(); ++j) {
            FaBizDepartmentInfo bizDepartmentInfo = bizcollCollection.get(j);
            map.put(bizDepartmentInfo.getUseDepartment().getId(), new Integer(j));
        }
        for (int i = 0; i < bakCollection.size(); ++i) {
            FaBakDepartmentInfo bakDepartmentInfo = bakCollection.get(i);
            if (map.containsKey(bakDepartmentInfo.getUseDepartment().getId())) continue;
            return true;
        }
        return false;
    }

    private void updateFaAsstActLName(Context ctx, FaBizCardInfo bizCardInfo) {
        if (bizCardInfo == null || bizCardInfo.getFaBizCostCenter() == null) {
            return;
        }
        FaBizCostCenterCollection bizCostCenterCollection = bizCardInfo.getFaBizCostCenter();
        for (int i = 0; i < bizCostCenterCollection.size(); ++i) {
            String LName = this.getAsstActLongName(bizCostCenterCollection.get(i), ctx);
            bizCostCenterCollection.get(i).setAsstActLName(LName);
        }
    }

    private String getAsstActLongName(FaBizCostCenterInfo fabizCostCenterInfo, Context ctx) {
        if (fabizCostCenterInfo == null || fabizCostCenterInfo.getAccountView() == null) {
            return "";
        }
        String asstActLName = " ";
        FaBizAsstActCompositCollection curAsstActCollection = fabizCostCenterInfo.getFaBizAsstActComposit();
        int size = curAsstActCollection.size();
        for (int i = 0; i < size - 1; ++i) {
            AsstActTypeInfo asstActType = curAsstActCollection.get(i).getAsstActType();
            AssistActItemInfo asstActItem = curAsstActCollection.get(i).getAsstActItem();
            if (asstActType == null || asstActItem == null) continue;
            asstActLName = asstActLName + curAsstActCollection.get(i).getAsstActType().getName(ctx.getLocale()) + "-" + curAsstActCollection.get(i).getAsstActItem().getName(ctx.getLocale()) + "/";
        }
        if (curAsstActCollection.get(size - 1) != null && curAsstActCollection.get(size - 1).getAsstActType() != null && curAsstActCollection.get(size - 1).getAsstActItem() != null) {
            asstActLName = asstActLName + curAsstActCollection.get(size - 1).getAsstActType().getName(ctx.getLocale()) + "-" + curAsstActCollection.get(size - 1).getAsstActItem().getName(ctx.getLocale());
        }
        return asstActLName;
    }

    private boolean isCurrencyDisable(Context ctx, FaChangeBillInfo changeBillInfo) throws EASBizException, BOSException {
        FaBizCardInfo bizCardInfo;
        boolean isDisable = false;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("Currency.*"));
        sic.add(new SelectorItemInfo("Currency.id"));
        sic.add(new SelectorItemInfo("Currency.name"));
        sic.add(new SelectorItemInfo("Currency.number"));
        if (changeBillInfo != null && changeBillInfo.getChangeBillEntry() != null && changeBillInfo.getChangeBillEntry().get(0) != null && changeBillInfo.getChangeBillEntry().get(0).getBizCard() != null && (bizCardInfo = changeBillInfo.getChangeBillEntry().get(0).getBizCard()) != null && bizCardInfo.getId() != null) {
            bizCardInfo = FaBizCardFactory.getLocalInstance(ctx).getFaBizCardInfo((IObjectPK)new ObjectUuidPK(bizCardInfo.getId()), sic);
            CurrencyInfo currencyInfo = bizCardInfo.getCurrency();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)currencyInfo.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)"2", CompareType.EQUALS));
            isDisable = CurrencyFactory.getLocalInstance((Context)ctx).exists(filter);
        }
        return isDisable;
    }

    protected void checkForSubmitSelf(Context ctx, FaChangeBillInfo faChangeBillInfo) throws BOSException, EASBizException {
        block6: {
            FaCurCardInfo faCurCardInfo = null;
            FaBizCardInfo faBizCardInfo = null;
            if (faChangeBillInfo != null && faChangeBillInfo.getChangeBillEntry() != null && faChangeBillInfo.getChangeBillEntry().size() > 0) {
                faCurCardInfo = faChangeBillInfo.getChangeBillEntry().get(0).getCurCard();
                faBizCardInfo = faChangeBillInfo.getChangeBillEntry().get(0).getBizCard();
            }
            if (faCurCardInfo == null || faBizCardInfo == null) {
                return;
            }
            try {
                String hasBorrowingNotReturn = "select 1 from T_FA_FaBorrowingEntry where FCurCardID = ? and FIsReturned = 0";
                IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)hasBorrowingNotReturn, (Object[])new Object[]{faCurCardInfo.getId().toString()});
                if (!rs1.next()) break block6;
                if (faBizCardInfo.getKeeper() != null) {
                    String isFaTreasuryManager = "select 1 from T_FA_FaTreasuryManage where FManageID = ?";
                    IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)isFaTreasuryManager, (Object[])new Object[]{faBizCardInfo.getKeeper().getId().toString()});
                    if (!rs2.next()) {
                        throw new AbstractFaCardException(AbstractFaCardException.KEEPER_MUST_BE_FATREASURYMANAGER, new String[]{faCurCardInfo.getNumber() + "(" + faCurCardInfo.getAssetName() + ")"});
                    }
                    break block6;
                }
                throw new AbstractFaCardException(AbstractFaCardException.KEEPER_CANNOT_BE_NULL, new String[]{faCurCardInfo.getNumber() + "(" + faCurCardInfo.getAssetName() + ")"});
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    @Override
    protected Map _buildMulChangeBills(Context ctx, FaCurCardInfo[] cards) throws BOSException, EASBizException {
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(new PrcFaChangeStrategy());
        prcFaCoreManager.getFaManageStrategy().checkUnAuditFaDep(ctx, this.getCurrentPeriod(ctx), ContextUtil.getCurrentFIUnit((Context)ctx));
        StringBuffer info = new StringBuffer();
        ArrayList<FaChangeBillInfo> changebills = new ArrayList<FaChangeBillInfo>();
        PeriodInfo currPeriod = this.getCurrentPeriod(ctx);
        String strCard = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaChangeResource", (String)"card", (Locale)ctx.getOriginLocale());
        String cantChange = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaChangeResource", (String)"cantChange", (Locale)ctx.getOriginLocale());
        PrcFaChangeStrategy changeStrategy = new PrcFaChangeStrategy();
        FaCurCardInfo cardInfo = null;
        FaCurCardInfo curCardold = null;
        FaBakCardInfo bakCard = null;
        FaBizCardInfo bizCard = null;
        FaChangeBillInfo changeBillInfo = null;
        FaChangeBillEntryInfo entryInfo = null;
        BigDecimal zeroValue = new BigDecimal("0");
        for (int i = 0; i < cards.length; ++i) {
            cardInfo = cards[i];
            curCardold = (FaCurCardInfo)cardInfo.get("oldCard");
            bakCard = PrcFaCoreManager.CurCard2BakCard(curCardold);
            bizCard = PrcFaCoreManager.CurCard2BizCard(cardInfo);
            if (curCardold == null) continue;
            try {
                changeStrategy.checkFaCurCardValid(ctx, cardInfo, curCardold);
                if (cardInfo.getAssetValue().compareTo(curCardold.getAssetValue()) > 0 && cardInfo.getUseTermCount().compareTo(cardInfo.getDeprTermCount()) == 0) {
                    throw new FaCardException(FaCardException.CANNOT_ADD_ASSET_WITHOUT_USETERMCNT);
                }
                bakCard.setFaCurCard(curCardold);
                bakCard.setBillType(FaBillTypeEnum.CHANGE);
                FaLocalUtils.verifyCardLimitAmt(bizCard);
                if (cardInfo.getGroupNumber() != null && curCardold.getGroupNumber() != null && !cardInfo.getGroupNumber().equals(curCardold.getGroupNumber())) {
                    this.checkGroupNumberDup(ctx, cardInfo, i + 1);
                }
                this.checkNumberDup(ctx, cardInfo, i + 1);
                if (cardInfo.getBarCode() != null && curCardold.getBarCode() != null && !cardInfo.getBarCode().equals(curCardold.getBarCode())) {
                    this.checkBarCodeDup(ctx, cardInfo, i + 1);
                }
                bizCard.setFaBakCard(bakCard);
                bizCard.setBillType(FaBillTypeEnum.CHANGE);
                bizCard.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
                changeStrategy.checkSameChangeBill(ctx, bakCard, bizCard, curCardold, currPeriod);
            }
            catch (FaCardException ex) {
                info.append("\uff1b").append(ex.getMessage());
                info.append(strCard).append(cardInfo.getNumber()).append("(").append(cardInfo.getAssetName()).append(")");
                info.append(cantChange);
                continue;
            }
            changeBillInfo = new FaChangeBillInfo();
            changeBillInfo.setChangeDate((Date)cardInfo.get("changeDate"));
            changeBillInfo.setChangeMode((FaAlterModeInfo)cardInfo.get("changeMode"));
            changeBillInfo.setDescription((String)cardInfo.get("description"));
            changeBillInfo.setHandler(ContextUtil.getCurrentUserInfo((Context)ctx));
            changeBillInfo.setPeriod(this.getCurrentPeriod(ctx));
            changeBillInfo.setCompany(ContextUtil.getCurrentFIUnit((Context)ctx));
            changeBillInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
            changeBillInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
            changeBillInfo.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
            changeBillInfo.setFiVouchered(false);
            changeBillInfo.setEffectedStatus(EffectedStatusEnum.EFFECTED);
            entryInfo = new FaChangeBillEntryInfo();
            entryInfo.setBizCard(bizCard);
            entryInfo.setCurCard(cardInfo);
            int oldScale = curCardold.getCurrency() != null ? curCardold.getCurrency().getPrecision() : 2;
            int newScale = cardInfo.getCurrency() != null ? cardInfo.getCurrency().getPrecision() : 2;
            entryInfo.setOriginChg((cardInfo.getAssetValue() != null ? cardInfo.getAssetValue().setScale(newScale, 4) : zeroValue).subtract(curCardold.getAssetValue() != null ? curCardold.getAssetValue().setScale(oldScale, 4) : zeroValue));
            entryInfo.setAccuDeprChg((cardInfo.getAccuDepr() != null ? cardInfo.getAccuDepr().setScale(newScale, 4) : zeroValue).subtract(curCardold.getAccuDepr() != null ? curCardold.getAccuDepr().setScale(oldScale, 4) : zeroValue));
            entryInfo.setDecValueChg((cardInfo.getDecValue() != null ? cardInfo.getDecValue().setScale(newScale, 4) : zeroValue).subtract(curCardold.getDecValue() != null ? curCardold.getDecValue().setScale(oldScale, 4) : zeroValue));
            changeBillInfo.getChangeBillEntry().add(entryInfo);
            changebills.add(changeBillInfo);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("info", info.length() > 0 ? info.substring(1) : null);
        result.put("changebills", changebills);
        return result;
    }

    private boolean checkNumberDup(Context ctx, FaCurCardInfo card, int i) throws EASBizException, BOSException {
        FaCurCardInfo oldCardInfo = FaCurCardFactory.getLocalInstance(ctx).getFaCurCardInfo((IObjectPK)new ObjectUuidPK(card.getId()));
        if (oldCardInfo != null && (oldCardInfo.getNumber() != null && !oldCardInfo.getNumber().equals(card.getNumber()) || oldCardInfo.getGroupNumber() != null && !oldCardInfo.getGroupNumber().equals(card.getGroupNumber())) && (FaLocalUtils.existCardNumForChanageBill(ctx, (IObjectValue)card) || FaLocalUtils.checkNumberDupForChange(ctx, card))) {
            String numberDup = FaLocalUtils.getResource(ctx, RESOURCE_PATH, "cardCodeDup");
            throw new EASBizException(new NumericExceptionSubItem("1", numberDup), (Object[])new String[]{String.valueOf(i), card.getNumber()});
        }
        return true;
    }

    private boolean checkBarCodeDup(Context ctx, FaCurCardInfo cardInfo, int i) throws EASBizException, BOSException {
        FilterItemInfo barCodeFilter = new FilterItemInfo("barCode", (Object)cardInfo.getBarCode(), CompareType.EQUALS);
        if (FaLocalUtils.existNumber(ctx, (IObjectValue)cardInfo, barCodeFilter)) {
            String barCodeDup = FaLocalUtils.getResource(ctx, RESOURCE_PATH, "barCodeDup");
            throw new EASBizException(new NumericExceptionSubItem("1", barCodeDup), (Object[])new String[]{String.valueOf(i), cardInfo.getBarCode()});
        }
        return true;
    }

    private boolean checkGroupNumberDup(Context ctx, FaCurCardInfo cardInfo, int i) throws EASBizException, BOSException {
        FilterItemInfo groupNumberFilter = new FilterItemInfo("groupNumber", (Object)cardInfo.getGroupNumber(), CompareType.EQUALS);
        if (FaLocalUtils.existGroupNumber(ctx, (IObjectValue)cardInfo, groupNumberFilter)) {
            String groupNumberDup = FaLocalUtils.getResource(ctx, RESOURCE_PATH, "groupCodeDup");
            throw new EASBizException(new NumericExceptionSubItem("1", groupNumberDup), (Object[])new String[]{String.valueOf(i), cardInfo.getGroupNumber()});
        }
        return true;
    }

    private void getChangedFaBizCardIdSet(Context ctx, IObjectCollection sourceBillCollection, HashSet cardIdSet) {
        int size = sourceBillCollection.size();
        for (int i = 0; i < size; ++i) {
            FaChangeBillInfo info = (FaChangeBillInfo)sourceBillCollection.getObject(i);
            if (info != null) {
                for (int j = 0; j < info.getChangeBillEntry().size(); ++j) {
                    FaChangeBillEntryInfo entryInfo = info.getChangeBillEntry().get(j);
                    if (entryInfo == null || entryInfo.getBizCard() == null) continue;
                    cardIdSet.add("'" + entryInfo.getBizCard().getId() + "'");
                }
            }
            info.put("faChangeBillSum", null);
        }
    }

    private void insertFaCardSumData(Context ctx, FaChangeBillInfo changeBillInfo, HashSet cardIdSet) throws BOSException, EASBizException {
        DbUtil.execute((Context)ctx, (String)("delete from T_FA_FaChangeBillDAPVoucherSum where FChangeBillID='" + changeBillInfo.getId() + "'"));
        if (cardIdSet.size() > 0) {
            String companyId = changeBillInfo.getCompany().getId().toString();
            boolean isAddDistributeSum = FaManageUtils.getFaParamValue(ctx, "FA_204", companyId);
            changeBillInfo.put("isAddDistributeSum", isAddDistributeSum);
            String cardIds = cardIdSet.toString();
            cardIds = cardIds.substring(1, cardIds.length() - 1);
            String accountIdSetSql = "select FAccountAssetID as accountId from t_fa_fabakcard where fid in (select ffabakcardid from t_fa_fabizcard where fid in (" + cardIds + ")) union select FAccountAccuDeprID as accountId from t_fa_fabakcard where fid in (select ffabakcardid from t_fa_fabizcard where fid in (" + cardIds + ")) union select FAccountDecValueID as accountId from t_fa_fabakcard where fid in (select ffabakcardid from t_fa_fabizcard where fid in (" + cardIds + "))";
            if (isAddDistributeSum) {
                accountIdSetSql = accountIdSetSql + " union SELECT cost.FACCOUNTVIEWID as accountId FROM T_FA_FaBakCostCenter cost inner join  t_fa_fabakcard bak on bak.fid = cost.FFABAKCARDID where bak.fid in ( select ffabakcardid from t_fa_fabizcard where fid in (" + cardIds + "))";
            }
            Map accountMap = this.getAccountMap(ctx, accountIdSetSql);
            StringBuffer sql = this.getFaBakCardAccountAssetItemSql(ctx, cardIds, false);
            List list = this.combineCardAssetItem(ctx, changeBillInfo, accountMap, sql, "FaBakCard", "UseDepartment");
            this.saveFaChangeBillDAPVoucherSumInfo(ctx, list);
            if (list.get(1).hashCode() == 0) {
                sql = this.getFaBakCardAccountAssetItemSql(ctx, cardIds, true);
                list = this.combineCardAssetItem(ctx, changeBillInfo, accountMap, sql, "FaBakCard", "");
                this.saveFaChangeBillDAPVoucherSumInfo(ctx, list);
            }
            accountIdSetSql = "select FAccountAssetID as accountId from t_fa_fabizcard where fid in (" + cardIds + ") union select FAccountAccuDeprID as accountId from t_fa_fabizcard where fid in (" + cardIds + ") union select FAccountDecValueID as accountId from t_fa_fabizcard where fid in (" + cardIds + ")";
            if (isAddDistributeSum) {
                accountIdSetSql = accountIdSetSql + " union SELECT cost.FACCOUNTVIEWID as accountId FROM t_fa_fabizcostcenter cost inner join t_fa_fabizcard biz on biz.fid = cost.FFABIZCARDID where biz.fid in (" + cardIds + ")";
            }
            accountMap = this.getAccountMap(ctx, accountIdSetSql);
            sql = this.getBizCardAssetItemForUseDepartmentChangedSql(ctx, cardIds);
            list = this.combineCardAssetItem(ctx, changeBillInfo, accountMap, sql, "FaBizCard", "UseDepartment");
            this.saveFaChangeBillDAPVoucherSumInfo(ctx, list);
            if (list.get(1).hashCode() == 0) {
                sql = this.getBizCardAssetItemForAccountViewChangedSql(ctx, cardIds);
                list = this.combineCardAssetItem(ctx, changeBillInfo, accountMap, sql, "FaBizCard", "AccountView");
                this.saveFaChangeBillDAPVoucherSumInfo(ctx, list);
                sql = this.getBizCardAssetItemForAmountChangedSql(ctx, cardIds, true);
                list = this.combineCardAssetItem(ctx, changeBillInfo, accountMap, sql, "FaBizCard", "Amount");
                this.saveFaChangeBillDAPVoucherSumInfo(ctx, list);
                sql = this.getBizCardAssetItemForAmountChangedSql(ctx, cardIds, false);
                list = this.combineCardAssetItem(ctx, changeBillInfo, accountMap, sql, "FaBizCard", "Amount");
                this.saveFaChangeBillDAPVoucherSumInfo(ctx, list);
            }
            changeBillInfo.remove("isAddDistributeSum");
        }
    }

    private void saveFaChangeBillDAPVoucherSumInfo(Context ctx, List list) throws EASBizException, BOSException {
        CoreBaseCollection faChangeBillSumCollection = new CoreBaseCollection();
        faChangeBillSumCollection = new CoreBaseCollection();
        for (int count = 0; count < list.size(); ++count) {
            Map map = (Map)list.get(count);
            if (map == null || map.size() <= 0) continue;
            for (String key : map.keySet()) {
                faChangeBillSumCollection.add((CoreBaseInfo)((FaChangeBillDAPVoucherSumInfo)map.get(key)));
            }
        }
        if (faChangeBillSumCollection.size() > 0) {
            FaChangeBillDAPVoucherSumFactory.getLocalInstance(ctx).save(faChangeBillSumCollection);
        }
    }

    private Map getAccountMap(Context ctx, String accountIdSetSql) throws BOSException {
        IRowSet accountIdsRs = DbUtil.executeQuery((Context)ctx, (String)accountIdSetSql);
        HashSet<String> accountIdSet = new HashSet<String>();
        try {
            while (accountIdsRs.next()) {
                accountIdSet.add("'" + accountIdsRs.getString("accountId") + "'");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        String accountIds = accountIdSet.toString();
        accountIds = accountIds.substring(1, accountIds.length() - 1);
        HashMap accountMap = new HashMap();
        StringBuffer accountAsstSql = new StringBuffer();
        accountAsstSql.append("select accountview.fid, asstdetail.fasstacttypeID ");
        accountAsstSql.append("from T_BD_AccountView accountview inner join T_BD_AsstAccount asstaccount on accountview.fcaa = asstaccount.fid ");
        accountAsstSql.append("inner join T_BD_AsstActGroupDetail asstdetail on asstdetail.fasstaccountid = asstaccount.fid ");
        accountAsstSql.append("where accountview.fid in (");
        accountAsstSql.append(accountIds);
        accountAsstSql.append(") ");
        accountAsstSql.append("order by accountview.fid");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)accountAsstSql.toString());
        String tempAccountViewId = "";
        try {
            while (rs.next()) {
                String accountViewId = rs.getString("fid");
                String asstActTypeId = rs.getString("fasstacttypeID");
                if (!"".equals(tempAccountViewId.trim()) && accountViewId.equals(tempAccountViewId)) {
                    List oldList = (List)accountMap.get(accountViewId);
                    oldList.add(asstActTypeId);
                    continue;
                }
                ArrayList<String> newList = new ArrayList<String>();
                newList.add(asstActTypeId);
                accountMap.put(accountViewId, newList);
                tempAccountViewId = accountViewId;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return accountMap;
    }

    private StringBuffer getFaBakCardAccountAssetItemSql(Context ctx, String cardIds, boolean bl) throws EASBizException, BOSException {
        int scal = 4;
        CompanyOrgUnitInfo companyInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        if (companyInfo.getBaseCurrency() != null) {
            scal = FaManageUtils.getCurrencyScale(companyInfo.getBaseCurrency().getId(), ctx);
        }
        HashSet<String> faBakCardIDSet = new HashSet<String>();
        String faBakCardIdSql = "select ffabakcardid from t_fa_fabizcard where fid in (" + cardIds + ")";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)faBakCardIdSql);
        try {
            while (rowSet.next()) {
                faBakCardIDSet.add("'" + rowSet.getString("ffabakcardid") + "'");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        String faBakCardIDs = faBakCardIDSet.toString();
        faBakCardIDs = faBakCardIDs.substring(1, faBakCardIDs.length() - 1);
        StringBuffer sql = new StringBuffer();
        sql.append("select tempSum.* from (");
        try {
            String isUseProfit;
            HashMap hmResult = FaManageUtils.getFAParameter(ctx, new String[]{"GL_111"}, companyInfo.getId().toString());
            String string = isUseProfit = hmResult != null && hmResult.get("GL_111") != null ? (String)hmResult.get("GL_111") : "false";
            if ("true".equalsIgnoreCase(isUseProfit)) {
                this.canShowProfit = true;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (!this.canShowProfit) {
            sql.append(this.getBakCardAccountViewDistributeSQL(1, scal, faBakCardIDs, bl));
            sql.append(" union all\n");
            sql.append(this.getBakCardAccountViewDistributeSQL(2, scal, faBakCardIDs, bl));
            sql.append(" union all\n");
            sql.append(this.getBakCardAccountViewDistributeSQL(3, scal, faBakCardIDs, bl));
        } else {
            sql.append(this.getBakCardAccountViewDistributeSQLWithProfit(1, scal, faBakCardIDs, bl));
            sql.append(" union all\n");
            sql.append(this.getBakCardAccountViewDistributeSQLWithProfit(2, scal, faBakCardIDs, bl));
            sql.append(" union all\n");
            sql.append(this.getBakCardAccountViewDistributeSQLWithProfit(3, scal, faBakCardIDs, bl));
        }
        sql.append(") as tempSum ");
        sql.append("order by tempSum.FAccountAssetID, tempSum.FAccountAccuDeprID, tempSum.FAccountDecValueID, tempSum.costcenterid, ");
        sql.append("  tempSum.fseq, tempSum.fasstacttype, tempSum.fasstactitem");
        return sql;
    }

    private StringBuffer getBakCardAccountViewDistributeSQL(int accType, int baseCurPrecision, String cardIds, boolean bl) {
        StringBuffer result = new StringBuffer();
        String accountAssetID = "''";
        String accountAccuDeprID = "''";
        String accountDecValueID = "''";
        String amountValue = "";
        String groupAccountID = "";
        String accountFilter = "";
        if (accType == 1) {
            accountAssetID = "bakcard.FAccountAssetID";
            amountValue = "fassetValue";
            groupAccountID = accountAssetID;
            accountFilter = "bakcard.FAccountAssetID != bizcard.FAccountAssetID";
        } else if (accType == 2) {
            accountAccuDeprID = "bakcard.FAccountAccuDeprID";
            amountValue = "faccuDepr";
            groupAccountID = accountAccuDeprID;
            accountFilter = "bakcard.FAccountAccuDeprID != bizcard.FAccountAccuDeprID";
        } else {
            accountDecValueID = "bakcard.FAccountDecValueID";
            amountValue = "fdecValue";
            groupAccountID = accountDecValueID;
            accountFilter = "bakcard.FAccountDecValueID != bizcard.FAccountDecValueID";
        }
        result.append("SELECT bakcard.fid AS fid,\n");
        result.append(accountAssetID + " AS FAccountAssetID,\n");
        result.append(accountAccuDeprID + " AS FAccountAccuDeprID,\n");
        result.append(accountDecValueID + " AS FAccountDecValueID,\n");
        result.append("costcenter.fseq AS fseq, \n");
        result.append("costcenter.faccountviewid AS accountview,\n");
        result.append("costcenter.fapportionscale AS fapportionscale,\n");
        result.append("costcenter.fid AS costcenterid,\n");
        result.append("composit.fasstacttype AS fasstacttype,\n");
        result.append("composit.fasstactitem AS fasstactitem,\n");
        result.append("\t\t\t   CASE\n");
        result.append("               WHEN (   x.countseq * x.maxscale = 100 AND costcenter.fseq = x.minseq\n");
        result.append("                     OR (x.countseq * x.maxscale != 100) AND (costcenter.fapportionscale = x.maxscale AND costcenter.fseq = x.minseqofmaxscale) \n");
        result.append("                    )\n");
        result.append("                  THEN ROUND (costcenter.fapportionscale * bakcard." + amountValue + " / 100, " + baseCurPrecision + ") + tempoffset.toffset\n");
        result.append("              ELSE ROUND (costcenter.fapportionscale * bakcard." + amountValue + " / 100, " + baseCurPrecision + ")\n");
        result.append("            END AS amount \n");
        result.append(" FROM t_fa_fabakcard bakcard\n");
        result.append("INNER JOIN t_fa_fabizcard bizcard ON bizcard.ffabakcardid = bakcard.fid\n");
        if (!bl) {
            result.append("inner join t_fa_fachangebillentry chgentry on chgentry.fbizcardid=bizcard.fid  \n");
            result.append("inner join t_fa_fachangebill chgbill on chgbill.fid=chgentry.fchangebillid\n");
        }
        result.append("INNER JOIN t_fa_fabakcostcenter costcenter ON costcenter.ffabakcardid = bakcard.fid\n");
        result.append("LEFT OUTER JOIN t_fa_fabakasstactcomposit composit on composit.FFaBakCostCenterID = costcenter.fid\n");
        result.append("INNER JOIN (\n");
        result.append("            SELECT   MIN (center.fseq) AS minseqofmaxscale, center.ffabakcardid AS ffabakcardid, tmpcenter.MAX AS maxscale, tmpcenter.MIN AS minseq,\n");
        result.append("                     tmpcenter.countseq AS countseq\n");
        result.append("                FROM t_fa_fabakcostcenter center INNER JOIN (SELECT   MAX (fapportionscale) AS MAX, MIN (fseq) AS MIN, ffabakcardid AS cardid,\n");
        result.append("                                                                      COUNT (fseq) AS countseq\n");
        result.append("                                                                 FROM t_fa_fabakcostcenter\n");
        result.append("                                                             GROUP BY ffabakcardid) tmpcenter ON center.ffabakcardid = tmpcenter.cardid\n");
        result.append("               WHERE center.fapportionscale = tmpcenter.MAX\n");
        result.append("                 AND center.ffabakcardid in (" + cardIds + ")\n");
        result.append("            GROUP BY center.ffabakcardid, tmpcenter.MAX, tmpcenter.MIN, tmpcenter.countseq\n");
        result.append("            ) x ON x.ffabakcardid = bakcard.fid\n");
        result.append("INNER JOIN (" + this.getBakCardSumEntryAmount(amountValue, baseCurPrecision, cardIds) + ") tempoffset ON tempoffset.bakcardid = bakcard.fid\n");
        result.append("WHERE bakcard.fid in (" + cardIds + ")\n");
        if (bl) {
            result.append("  AND " + accountFilter + " \n");
        } else {
            result.append("  AND chgbill.FhasDepartmentChanged  = 1 \n");
        }
        result.append("GROUP BY bakcard.fid, " + groupAccountID + ", \n");
        result.append(" bakcard." + amountValue + ", costcenter.faccountviewid, costcenter.fseq,\n");
        result.append(" costcenter.fapportionscale, costcenter.fid, composit.fasstacttype, composit.fasstactitem, \n");
        result.append(" tempoffset.toffset, x.countseq, x.maxscale, x.minseqofmaxscale, x.minseq\n");
        return result;
    }

    private StringBuffer getBakCardAccountViewDistributeSQLWithProfit(int accType, int baseCurPrecision, String cardIds, boolean bl) {
        StringBuffer result = new StringBuffer();
        String accountAssetID = "''";
        String accountAccuDeprID = "''";
        String accountDecValueID = "''";
        String amountValue = "";
        String groupAccountID = "";
        String accountFilter = "";
        if (accType == 1) {
            accountAssetID = "bakcard.FAccountAssetID";
            amountValue = "fassetValue";
            groupAccountID = accountAssetID;
            accountFilter = "bakcard.FAccountAssetID != bizcard.FAccountAssetID";
        } else if (accType == 2) {
            accountAccuDeprID = "bakcard.FAccountAccuDeprID";
            amountValue = "faccuDepr";
            groupAccountID = accountAccuDeprID;
            accountFilter = "bakcard.FAccountAccuDeprID != bizcard.FAccountAccuDeprID";
        } else {
            accountDecValueID = "bakcard.FAccountDecValueID";
            amountValue = "fdecValue";
            groupAccountID = accountDecValueID;
            accountFilter = "bakcard.FAccountDecValueID != bizcard.FAccountDecValueID";
        }
        result.append("SELECT bakcard.fid AS fid,\n");
        result.append(accountAssetID + " AS FAccountAssetID,\n");
        result.append(accountAccuDeprID + " AS FAccountAccuDeprID,\n");
        result.append(accountDecValueID + " AS FAccountDecValueID,\n");
        result.append("costcenter.fseq AS fseq, \n");
        result.append("costcenter.faccountviewid AS accountview,\n");
        result.append("costcenter.FPROFITCENTERID AS profitcenter,\n");
        result.append("costcenter.fapportionscale AS fapportionscale,\n");
        result.append("costcenter.fid AS costcenterid,\n");
        result.append("composit.fasstacttype AS fasstacttype,\n");
        result.append("composit.fasstactitem AS fasstactitem,\n");
        result.append("\t\t\t   CASE\n");
        result.append("               WHEN (   x.countseq * x.maxscale = 100 AND costcenter.fseq = x.minseq\n");
        result.append("                     OR (x.countseq * x.maxscale != 100) AND (costcenter.fapportionscale = x.maxscale AND costcenter.fseq = x.minseqofmaxscale) \n");
        result.append("                    )\n");
        result.append("                  THEN ROUND (costcenter.fapportionscale * bakcard." + amountValue + " / 100, " + baseCurPrecision + ") + tempoffset.toffset\n");
        result.append("              ELSE ROUND (costcenter.fapportionscale * bakcard." + amountValue + " / 100, " + baseCurPrecision + ")\n");
        result.append("            END AS amount \n");
        result.append(" FROM t_fa_fabakcard bakcard\n");
        result.append("INNER JOIN t_fa_fabizcard bizcard ON bizcard.ffabakcardid = bakcard.fid\n");
        if (!bl) {
            result.append("inner join t_fa_fachangebillentry chgentry on chgentry.fbizcardid=bizcard.fid  \n");
            result.append("inner join t_fa_fachangebill chgbill on chgbill.fid=chgentry.fchangebillid\n");
        }
        result.append("INNER JOIN t_fa_fabakcostcenter costcenter ON costcenter.ffabakcardid = bakcard.fid\n");
        result.append("INNER JOIN t_fa_fabakasstactcomposit composit on composit.FFaBakCostCenterID = costcenter.fid\n");
        result.append("INNER JOIN (\n");
        result.append("            SELECT   MIN (center.fseq) AS minseqofmaxscale, center.ffabakcardid AS ffabakcardid, tmpcenter.MAX AS maxscale, tmpcenter.MIN AS minseq,\n");
        result.append("                     tmpcenter.countseq AS countseq\n");
        result.append("                FROM t_fa_fabakcostcenter center INNER JOIN (SELECT   MAX (fapportionscale) AS MAX, MIN (fseq) AS MIN, ffabakcardid AS cardid,\n");
        result.append("                                                                      COUNT (fseq) AS countseq\n");
        result.append("                                                                 FROM t_fa_fabakcostcenter\n");
        result.append("                                                             GROUP BY ffabakcardid) tmpcenter ON center.ffabakcardid = tmpcenter.cardid\n");
        result.append("               WHERE center.fapportionscale = tmpcenter.MAX\n");
        result.append("                 AND center.ffabakcardid in (" + cardIds + ")\n");
        result.append("            GROUP BY center.ffabakcardid, tmpcenter.MAX, tmpcenter.MIN, tmpcenter.countseq\n");
        result.append("            ) x ON x.ffabakcardid = bakcard.fid\n");
        result.append("INNER JOIN (" + this.getBakCardSumEntryAmount(amountValue, baseCurPrecision, cardIds) + ") tempoffset ON tempoffset.bakcardid = bakcard.fid\n");
        result.append("WHERE bakcard.fid in (" + cardIds + ")\n");
        if (bl) {
            result.append("  AND " + accountFilter + " \n");
        } else {
            result.append("  AND chgbill.FhasDepartmentChanged  = 1 \n");
        }
        result.append("GROUP BY bakcard.fid, " + groupAccountID + ", \n");
        result.append(" bakcard." + amountValue + ", costcenter.faccountviewid, costcenter.FPROFITCENTERID, costcenter.fseq,\n");
        result.append(" costcenter.fapportionscale, costcenter.fid, composit.fasstacttype, composit.fasstactitem, \n");
        result.append(" tempoffset.toffset, x.countseq, x.maxscale, x.minseqofmaxscale, x.minseq\n");
        return result;
    }

    private StringBuffer getBakCardSumEntryAmount(String amountValue, int baseCurPrecision, String cardIds) {
        StringBuffer result = new StringBuffer();
        result.append("SELECT\n");
        result.append("tempcal.fvalue - SUM (disamount) AS toffset,\n");
        result.append("tempcal.fvalue,\n");
        result.append("SUM (disamount) AS sumdisamount,\n");
        result.append("tempcal.ffabakcardid AS bakcardid\n");
        result.append("FROM (\n");
        result.append("SELECT bakcard." + amountValue + " AS fvalue, costcenter.fapportionscale,\n");
        result.append("ROUND (costcenter.fapportionscale * bakcard." + amountValue + " / 100, " + baseCurPrecision + ") AS disamount,\n");
        result.append("costcenter.ffabakcardid, costcenter.fseq\n");
        result.append("FROM t_fa_fabakcard bakcard\n");
        result.append("INNER JOIN t_fa_fabakcostcenter costcenter ON costcenter.ffabakcardid = bakcard.fid\n");
        result.append("WHERE bakcard.fid in (" + cardIds + ")\n");
        result.append(") tempcal\n");
        result.append("GROUP BY tempcal.ffabakcardid, tempcal.fvalue\n");
        return result;
    }

    private StringBuffer getBizCardAssetItemForUseDepartmentChangedSql(Context ctx, String cardIds) throws EASBizException, BOSException {
        int scal = 4;
        CompanyOrgUnitInfo companyInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        if (companyInfo.getBaseCurrency() != null) {
            scal = FaManageUtils.getCurrencyScale(companyInfo.getBaseCurrency().getId(), ctx);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select tempSum.* from (");
        try {
            String isUseProfit;
            HashMap hmResult = FaManageUtils.getFAParameter(ctx, new String[]{"GL_111"}, companyInfo.getId().toString());
            String string = isUseProfit = hmResult != null && hmResult.get("GL_111") != null ? (String)hmResult.get("GL_111") : "false";
            if ("true".equalsIgnoreCase(isUseProfit)) {
                this.canShowProfit = true;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (!this.canShowProfit) {
            sql.append(this.getBizCardDistributeForUseDepartmentChangedSQL(1, scal, cardIds));
            sql.append(" union all\n");
            sql.append(this.getBizCardDistributeForUseDepartmentChangedSQL(2, scal, cardIds));
            sql.append(" union all\n");
            sql.append(this.getBizCardDistributeForUseDepartmentChangedSQL(3, scal, cardIds));
        } else {
            sql.append(this.getBizCardDistributeForUseDepartmentChangedSQLWithProfit(1, scal, cardIds));
            sql.append(" union all\n");
            sql.append(this.getBizCardDistributeForUseDepartmentChangedSQLWithProfit(2, scal, cardIds));
            sql.append(" union all\n");
            sql.append(this.getBizCardDistributeForUseDepartmentChangedSQLWithProfit(3, scal, cardIds));
        }
        sql.append(") as tempSum ");
        sql.append("order by tempSum.FAccountAssetID, tempSum.FAccountAccuDeprID, tempSum.FAccountDecValueID, tempSum.costcenterid, ");
        sql.append("  tempSum.fseq, tempSum.fasstacttype, tempSum.fasstactitem");
        return sql;
    }

    private StringBuffer getBizCardAssetItemForAmountChangedSql(Context ctx, String cardIds, boolean isDebitOrCredit) throws EASBizException, BOSException {
        int scal = 4;
        CompanyOrgUnitInfo companyInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        if (companyInfo.getBaseCurrency() != null) {
            scal = FaManageUtils.getCurrencyScale(companyInfo.getBaseCurrency().getId(), ctx);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select tempSum.* from (");
        try {
            String isUseProfit;
            HashMap hmResult = FaManageUtils.getFAParameter(ctx, new String[]{"GL_111"}, companyInfo.getId().toString());
            String string = isUseProfit = hmResult != null && hmResult.get("GL_111") != null ? (String)hmResult.get("GL_111") : "false";
            if ("true".equalsIgnoreCase(isUseProfit)) {
                this.canShowProfit = true;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (!this.canShowProfit) {
            sql.append(this.getBizCardDistributeForAmountChangedSQL(1, scal, cardIds, isDebitOrCredit));
            sql.append(" union all\n");
            sql.append(this.getBizCardDistributeForAmountChangedSQL(2, scal, cardIds, isDebitOrCredit));
        } else {
            sql.append(this.getBizCardDistributeForAmountChangedSQLWithProfit(1, scal, cardIds, isDebitOrCredit));
            sql.append(" union all\n");
            sql.append(this.getBizCardDistributeForAmountChangedSQLWithProfit(2, scal, cardIds, isDebitOrCredit));
        }
        sql.append(") as tempSum ");
        sql.append("order by tempSum.FAccountAssetID, tempSum.FAccountAccuDeprID, tempSum.FAccountDecValueID, tempSum.costcenterid, ");
        sql.append("  tempSum.fseq, tempSum.fasstacttype, tempSum.fasstactitem");
        return sql;
    }

    private StringBuffer getBizCardAssetItemForAccountViewChangedSql(Context ctx, String cardIds) throws EASBizException, BOSException {
        int scal = 4;
        CompanyOrgUnitInfo companyInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        if (companyInfo.getBaseCurrency() != null) {
            scal = FaManageUtils.getCurrencyScale(companyInfo.getBaseCurrency().getId(), ctx);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select tempSum.* from (");
        try {
            String isUseProfit;
            HashMap hmResult = FaManageUtils.getFAParameter(ctx, new String[]{"GL_111"}, companyInfo.getId().toString());
            String string = isUseProfit = hmResult != null && hmResult.get("GL_111") != null ? (String)hmResult.get("GL_111") : "false";
            if ("true".equalsIgnoreCase(isUseProfit)) {
                this.canShowProfit = true;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (!this.canShowProfit) {
            sql.append(this.getBizCardDistributeForAccountViewChangedSQL(1, scal, cardIds));
            sql.append(" union all\n");
            sql.append(this.getBizCardDistributeForAccountViewChangedSQL(2, scal, cardIds));
            sql.append(" union all\n");
            sql.append(this.getBizCardDistributeForAccountViewChangedSQL(3, scal, cardIds));
        } else {
            sql.append(this.getBizCardDistributeForAccountViewChangedSQLWithProfit(1, scal, cardIds));
            sql.append(" union all\n");
            sql.append(this.getBizCardDistributeForAccountViewChangedSQLWithProfit(2, scal, cardIds));
            sql.append(" union all\n");
            sql.append(this.getBizCardDistributeForAccountViewChangedSQLWithProfit(3, scal, cardIds));
        }
        sql.append(") as tempSum ");
        sql.append("order by tempSum.FAccountAssetID, tempSum.FAccountAccuDeprID, tempSum.FAccountDecValueID, tempSum.costcenterid, ");
        sql.append("  tempSum.fseq, tempSum.fasstacttype, tempSum.fasstactitem");
        return sql;
    }

    private StringBuffer getBizCardDistributeForAccountViewChangedSQL(int accType, int baseCurPrecision, String cardIds) {
        StringBuffer result = new StringBuffer();
        String accountAssetID = "''";
        String accountAccuDeprID = "''";
        String accountDecValueID = "''";
        String amountValue = "";
        String groupAccountID = "";
        String accountFilter = "";
        if (accType == 1) {
            accountAssetID = "bizcard.FAccountAssetID";
            amountValue = "fassetValue";
            groupAccountID = accountAssetID;
            accountFilter = "bakcard.FAccountAssetID != bizcard.FAccountAssetID";
        } else if (accType == 2) {
            accountAccuDeprID = "bizcard.FAccountAccuDeprID";
            amountValue = "faccuDepr";
            groupAccountID = accountAccuDeprID;
            accountFilter = "bakcard.FAccountAccuDeprID != bizcard.FAccountAccuDeprID";
        } else {
            accountDecValueID = "bizcard.FAccountDecValueID";
            amountValue = "fdecValue";
            groupAccountID = accountDecValueID;
            accountFilter = "bakcard.FAccountDecValueID != bizcard.FAccountDecValueID";
        }
        result.append("SELECT bizcard.fid AS fid,\n");
        result.append(accountAssetID + " AS FAccountAssetID,\n");
        result.append(accountAccuDeprID + " AS FAccountAccuDeprID,\n");
        result.append(accountDecValueID + " AS FAccountDecValueID,\n");
        result.append("costcenter.fseq AS fseq, \n");
        result.append("costcenter.faccountviewid AS accountview,\n");
        result.append("costcenter.fapportionscale AS fapportionscale,\n");
        result.append("costcenter.fid AS costcenterid,\n");
        result.append("composit.fasstacttype AS fasstacttype,\n");
        result.append("composit.fasstactitem AS fasstactitem,\n");
        result.append("\t\t\t   CASE\n");
        result.append("               WHEN (   x.countseq * x.maxscale = 100 AND costcenter.fseq = x.minseq\n");
        result.append("                     OR (x.countseq * x.maxscale != 100) AND (costcenter.fapportionscale = x.maxscale AND costcenter.fseq = x.minseqofmaxscale) \n");
        result.append("                    )\n");
        result.append("                  THEN ROUND (costcenter.fapportionscale * bizcard." + amountValue + " / 100, " + baseCurPrecision + ") + tempoffset.toffset\n");
        result.append("              ELSE ROUND (costcenter.fapportionscale * bizcard." + amountValue + " / 100, " + baseCurPrecision + ")\n");
        result.append("            END AS amount \n");
        result.append(" FROM t_fa_fabizcard bizcard\n");
        result.append("INNER JOIN t_fa_fabakcard bakcard ON bakcard.fid = bizcard.ffabakcardid\n");
        result.append("INNER JOIN t_fa_fabizcostcenter costcenter ON costcenter.ffabizcardid = bizcard.fid\n");
        result.append("INNER JOIN t_fa_fabizasstactcomposit composit on composit.FFaBizCostCenterID = costcenter.fid\n");
        result.append("INNER JOIN (\n");
        result.append("            SELECT   MIN (center.fseq) AS minseqofmaxscale, center.ffabizcardid AS ffabizcardid, tmpcenter.MAX AS maxscale, tmpcenter.MIN AS minseq,\n");
        result.append("                     tmpcenter.countseq AS countseq\n");
        result.append("                FROM t_fa_fabizcostcenter center INNER JOIN (SELECT   MAX (fapportionscale) AS MAX, MIN (fseq) AS MIN, ffabizcardid AS cardid,\n");
        result.append("                                                                      COUNT (fseq) AS countseq\n");
        result.append("                                                                 FROM t_fa_fabizcostcenter\n");
        result.append("                                                             GROUP BY ffabizcardid) tmpcenter ON center.ffabizcardid = tmpcenter.cardid\n");
        result.append("               WHERE center.fapportionscale = tmpcenter.MAX\n");
        result.append("                 AND center.ffabizcardid in (" + cardIds + ")\n");
        result.append("            GROUP BY center.ffabizcardid, tmpcenter.MAX, tmpcenter.MIN, tmpcenter.countseq\n");
        result.append("            ) x ON x.ffabizcardid = bizcard.fid\n");
        result.append("INNER JOIN (" + this.getBizCardSumEntryAmount(amountValue, baseCurPrecision, cardIds) + ") tempoffset ON tempoffset.bizcardid = bizcard.fid\n");
        result.append("WHERE bizcard.fid in (" + cardIds + ")\n");
        result.append("  AND " + accountFilter + "\n");
        result.append("GROUP BY bizcard.fid, " + groupAccountID + ", \n");
        result.append(" bizcard." + amountValue + ", costcenter.faccountviewid, costcenter.fseq,\n");
        result.append(" costcenter.fapportionscale, costcenter.fid, composit.fasstacttype, composit.fasstactitem, \n");
        result.append(" tempoffset.toffset, x.countseq, x.maxscale, x.minseqofmaxscale, x.minseq\n");
        return result;
    }

    private StringBuffer getBizCardDistributeForAccountViewChangedSQLWithProfit(int accType, int baseCurPrecision, String cardIds) {
        StringBuffer result = new StringBuffer();
        String accountAssetID = "''";
        String accountAccuDeprID = "''";
        String accountDecValueID = "''";
        String amountValue = "";
        String groupAccountID = "";
        String accountFilter = "";
        if (accType == 1) {
            accountAssetID = "bizcard.FAccountAssetID";
            amountValue = "fassetValue";
            groupAccountID = accountAssetID;
            accountFilter = "bakcard.FAccountAssetID != bizcard.FAccountAssetID";
        } else if (accType == 2) {
            accountAccuDeprID = "bizcard.FAccountAccuDeprID";
            amountValue = "faccuDepr";
            groupAccountID = accountAccuDeprID;
            accountFilter = "bakcard.FAccountAccuDeprID != bizcard.FAccountAccuDeprID";
        } else {
            accountDecValueID = "bizcard.FAccountDecValueID";
            amountValue = "fdecValue";
            groupAccountID = accountDecValueID;
            accountFilter = "bakcard.FAccountDecValueID != bizcard.FAccountDecValueID";
        }
        result.append("SELECT bizcard.fid AS fid,\n");
        result.append(accountAssetID + " AS FAccountAssetID,\n");
        result.append(accountAccuDeprID + " AS FAccountAccuDeprID,\n");
        result.append(accountDecValueID + " AS FAccountDecValueID,\n");
        result.append("costcenter.fseq AS fseq, \n");
        result.append("costcenter.faccountviewid AS accountview,\n");
        result.append("costcenter.FPROFITCENTERID AS profitcenter,\n");
        result.append("costcenter.fapportionscale AS fapportionscale,\n");
        result.append("costcenter.fid AS costcenterid,\n");
        result.append("composit.fasstacttype AS fasstacttype,\n");
        result.append("composit.fasstactitem AS fasstactitem,\n");
        result.append("\t\t\t   CASE\n");
        result.append("               WHEN (   x.countseq * x.maxscale = 100 AND costcenter.fseq = x.minseq\n");
        result.append("                     OR (x.countseq * x.maxscale != 100) AND (costcenter.fapportionscale = x.maxscale AND costcenter.fseq = x.minseqofmaxscale) \n");
        result.append("                    )\n");
        result.append("                  THEN ROUND (costcenter.fapportionscale * bizcard." + amountValue + " / 100, " + baseCurPrecision + ") + tempoffset.toffset\n");
        result.append("              ELSE ROUND (costcenter.fapportionscale * bizcard." + amountValue + " / 100, " + baseCurPrecision + ")\n");
        result.append("            END AS amount \n");
        result.append(" FROM t_fa_fabizcard bizcard\n");
        result.append("INNER JOIN t_fa_fabakcard bakcard ON bakcard.fid = bizcard.ffabakcardid\n");
        result.append("INNER JOIN t_fa_fabizcostcenter costcenter ON costcenter.ffabizcardid = bizcard.fid\n");
        result.append("INNER JOIN t_fa_fabizasstactcomposit composit on composit.FFaBizCostCenterID = costcenter.fid\n");
        result.append("INNER JOIN (\n");
        result.append("            SELECT   MIN (center.fseq) AS minseqofmaxscale, center.ffabizcardid AS ffabizcardid, tmpcenter.MAX AS maxscale, tmpcenter.MIN AS minseq,\n");
        result.append("                     tmpcenter.countseq AS countseq\n");
        result.append("                FROM t_fa_fabizcostcenter center INNER JOIN (SELECT   MAX (fapportionscale) AS MAX, MIN (fseq) AS MIN, ffabizcardid AS cardid,\n");
        result.append("                                                                      COUNT (fseq) AS countseq\n");
        result.append("                                                                 FROM t_fa_fabizcostcenter\n");
        result.append("                                                             GROUP BY ffabizcardid) tmpcenter ON center.ffabizcardid = tmpcenter.cardid\n");
        result.append("               WHERE center.fapportionscale = tmpcenter.MAX\n");
        result.append("                 AND center.ffabizcardid in (" + cardIds + ")\n");
        result.append("            GROUP BY center.ffabizcardid, tmpcenter.MAX, tmpcenter.MIN, tmpcenter.countseq\n");
        result.append("            ) x ON x.ffabizcardid = bizcard.fid\n");
        result.append("INNER JOIN (" + this.getBizCardSumEntryAmount(amountValue, baseCurPrecision, cardIds) + ") tempoffset ON tempoffset.bizcardid = bizcard.fid\n");
        result.append("WHERE bizcard.fid in (" + cardIds + ")\n");
        result.append("  AND " + accountFilter + "\n");
        result.append("GROUP BY bizcard.fid, " + groupAccountID + ", \n");
        result.append(" bizcard." + amountValue + ", costcenter.faccountviewid, costcenter.FPROFITCENTERID, costcenter.fseq,\n");
        result.append(" costcenter.fapportionscale, costcenter.fid, composit.fasstacttype, composit.fasstactitem, \n");
        result.append(" tempoffset.toffset, x.countseq, x.maxscale, x.minseqofmaxscale, x.minseq\n");
        return result;
    }

    private StringBuffer getBizCardSumEntryAmount(String amountValue, int baseCurPrecision, String cardIds) {
        StringBuffer result = new StringBuffer();
        result.append("SELECT\n");
        result.append("tempcal.fvalue - SUM (disamount) AS toffset,\n");
        result.append("tempcal.fvalue,\n");
        result.append("SUM (disamount) AS sumdisamount,\n");
        result.append("tempcal.ffabizcardid AS bizcardid\n");
        result.append("FROM (\n");
        result.append("SELECT bizcard." + amountValue + " AS fvalue, costcenter.fapportionscale,\n");
        result.append("ROUND (costcenter.fapportionscale * bizcard." + amountValue + " / 100, " + baseCurPrecision + ") AS disamount,\n");
        result.append("costcenter.ffabizcardid, costcenter.fseq\n");
        result.append("FROM t_fa_fabizcard bizcard\n");
        result.append("INNER JOIN t_fa_fabizcostcenter costcenter ON costcenter.ffabizcardid = bizcard.fid\n");
        result.append("WHERE bizcard.fid in (" + cardIds + ")\n");
        result.append(") tempcal\n");
        result.append("GROUP BY tempcal.ffabizcardid, tempcal.fvalue\n");
        return result;
    }

    private StringBuffer getBizCardDistributeForUseDepartmentChangedSQL(int accType, int baseCurPrecision, String cardIds) {
        StringBuffer result = new StringBuffer();
        String accountAssetID = "''";
        String accountAccuDeprID = "''";
        String accountDecValueID = "''";
        String amountValue = "";
        String groupAccountID = "";
        if (accType == 1) {
            accountAssetID = "bizcard.FAccountAssetID";
            amountValue = "fassetValue";
            groupAccountID = accountAssetID;
        } else if (accType == 2) {
            accountAccuDeprID = "bizcard.FAccountAccuDeprID";
            amountValue = "faccuDepr";
            groupAccountID = accountAccuDeprID;
        } else {
            accountDecValueID = "bizcard.FAccountDecValueID";
            amountValue = "fdecValue";
            groupAccountID = accountDecValueID;
        }
        result.append("SELECT bizcard.fid AS fid,\n");
        result.append(accountAssetID + " AS FAccountAssetID,\n");
        result.append(accountAccuDeprID + " AS FAccountAccuDeprID,\n");
        result.append(accountDecValueID + " AS FAccountDecValueID,\n");
        result.append("costcenter.fseq AS fseq, \n");
        result.append("costcenter.faccountviewid AS accountview,\n");
        result.append("costcenter.fapportionscale AS fapportionscale,\n");
        result.append("costcenter.fid AS costcenterid,\n");
        result.append("composit.fasstacttype AS fasstacttype,\n");
        result.append("composit.fasstactitem AS fasstactitem,\n");
        result.append("\t\t\t   CASE\n");
        result.append("               WHEN (   x.countseq * x.maxscale = 100 AND costcenter.fseq = x.minseq\n");
        result.append("                     OR (x.countseq * x.maxscale != 100) AND (costcenter.fapportionscale = x.maxscale AND costcenter.fseq = x.minseqofmaxscale) \n");
        result.append("                    )\n");
        result.append("                  THEN ROUND (costcenter.fapportionscale * bizcard." + amountValue + " / 100, " + baseCurPrecision + ") + tempoffset.toffset\n");
        result.append("              ELSE ROUND (costcenter.fapportionscale * bizcard." + amountValue + " / 100, " + baseCurPrecision + ")\n");
        result.append("            END AS amount \n");
        result.append(" FROM t_fa_fabizcard bizcard\n");
        result.append("INNER JOIN t_fa_fachangebillentry chgentry ON chgentry.fbizcardid = bizcard.fid\n");
        result.append("INNER JOIN t_fa_fachangebill chgbill ON chgbill.fid = chgentry.fchangebillid\n");
        result.append("INNER JOIN t_fa_fabizcostcenter costcenter ON costcenter.ffabizcardid = bizcard.fid\n");
        result.append("LEFT OUTER JOIN t_fa_fabizasstactcomposit composit on composit.FFaBizCostCenterID = costcenter.fid\n");
        result.append("INNER JOIN (\n");
        result.append("            SELECT   MIN (center.fseq) AS minseqofmaxscale, center.ffabizcardid AS ffabizcardid, tmpcenter.MAX AS maxscale, tmpcenter.MIN AS minseq,\n");
        result.append("                     tmpcenter.countseq AS countseq\n");
        result.append("                FROM t_fa_fabizcostcenter center INNER JOIN (SELECT   MAX (fapportionscale) AS MAX, MIN (fseq) AS MIN, ffabizcardid AS cardid,\n");
        result.append("                                                                      COUNT (fseq) AS countseq\n");
        result.append("                                                                 FROM t_fa_fabizcostcenter\n");
        result.append("                                                             GROUP BY ffabizcardid) tmpcenter ON center.ffabizcardid = tmpcenter.cardid\n");
        result.append("               WHERE center.fapportionscale = tmpcenter.MAX\n");
        result.append("                 AND center.ffabizcardid in (" + cardIds + ")\n");
        result.append("            GROUP BY center.ffabizcardid, tmpcenter.MAX, tmpcenter.MIN, tmpcenter.countseq\n");
        result.append("            ) x ON x.ffabizcardid = bizcard.fid\n");
        result.append("INNER JOIN (" + this.getBizCardSumEntryAmount(amountValue, baseCurPrecision, cardIds) + ") tempoffset ON tempoffset.bizcardid = bizcard.fid\n");
        result.append("WHERE bizcard.fid in (" + cardIds + ")\n");
        result.append("  AND chgbill.FhasDepartmentChanged  = 1\n");
        result.append("GROUP BY bizcard.fid, " + groupAccountID + ", \n");
        result.append(" bizcard." + amountValue + ", costcenter.faccountviewid, costcenter.fseq,\n");
        result.append(" costcenter.fapportionscale, costcenter.fid, composit.fasstacttype, composit.fasstactitem, \n");
        result.append(" tempoffset.toffset, x.countseq, x.maxscale, x.minseqofmaxscale, x.minseq\n");
        return result;
    }

    private StringBuffer getBizCardDistributeForUseDepartmentChangedSQLWithProfit(int accType, int baseCurPrecision, String cardIds) {
        StringBuffer result = new StringBuffer();
        String accountAssetID = "''";
        String accountAccuDeprID = "''";
        String accountDecValueID = "''";
        String amountValue = "";
        String groupAccountID = "";
        if (accType == 1) {
            accountAssetID = "bizcard.FAccountAssetID";
            amountValue = "fassetValue";
            groupAccountID = accountAssetID;
        } else if (accType == 2) {
            accountAccuDeprID = "bizcard.FAccountAccuDeprID";
            amountValue = "faccuDepr";
            groupAccountID = accountAccuDeprID;
        } else {
            accountDecValueID = "bizcard.FAccountDecValueID";
            amountValue = "fdecValue";
            groupAccountID = accountDecValueID;
        }
        result.append("SELECT bizcard.fid AS fid,\n");
        result.append(accountAssetID + " AS FAccountAssetID,\n");
        result.append(accountAccuDeprID + " AS FAccountAccuDeprID,\n");
        result.append(accountDecValueID + " AS FAccountDecValueID,\n");
        result.append("costcenter.fseq AS fseq, \n");
        result.append("costcenter.faccountviewid AS accountview,\n");
        result.append("costcenter.FPROFITCENTERID AS profitcenter,\n");
        result.append("costcenter.fapportionscale AS fapportionscale,\n");
        result.append("costcenter.fid AS costcenterid,\n");
        result.append("composit.fasstacttype AS fasstacttype,\n");
        result.append("composit.fasstactitem AS fasstactitem,\n");
        result.append("\t\t\t   CASE\n");
        result.append("               WHEN (   x.countseq * x.maxscale = 100 AND costcenter.fseq = x.minseq\n");
        result.append("                     OR (x.countseq * x.maxscale != 100) AND (costcenter.fapportionscale = x.maxscale AND costcenter.fseq = x.minseqofmaxscale) \n");
        result.append("                    )\n");
        result.append("                  THEN ROUND (costcenter.fapportionscale * bizcard." + amountValue + " / 100, " + baseCurPrecision + ") + tempoffset.toffset\n");
        result.append("              ELSE ROUND (costcenter.fapportionscale * bizcard." + amountValue + " / 100, " + baseCurPrecision + ")\n");
        result.append("            END AS amount \n");
        result.append(" FROM t_fa_fabizcard bizcard\n");
        result.append("INNER JOIN t_fa_fachangebillentry chgentry ON chgentry.fbizcardid = bizcard.fid\n");
        result.append("INNER JOIN t_fa_fachangebill chgbill ON chgbill.fid = chgentry.fchangebillid\n");
        result.append("INNER JOIN t_fa_fabizcostcenter costcenter ON costcenter.ffabizcardid = bizcard.fid\n");
        result.append("INNER JOIN t_fa_fabizasstactcomposit composit on composit.FFaBizCostCenterID = costcenter.fid\n");
        result.append("INNER JOIN (\n");
        result.append("            SELECT   MIN (center.fseq) AS minseqofmaxscale, center.ffabizcardid AS ffabizcardid, tmpcenter.MAX AS maxscale, tmpcenter.MIN AS minseq,\n");
        result.append("                     tmpcenter.countseq AS countseq\n");
        result.append("                FROM t_fa_fabizcostcenter center INNER JOIN (SELECT   MAX (fapportionscale) AS MAX, MIN (fseq) AS MIN, ffabizcardid AS cardid,\n");
        result.append("                                                                      COUNT (fseq) AS countseq\n");
        result.append("                                                                 FROM t_fa_fabizcostcenter\n");
        result.append("                                                             GROUP BY ffabizcardid) tmpcenter ON center.ffabizcardid = tmpcenter.cardid\n");
        result.append("               WHERE center.fapportionscale = tmpcenter.MAX\n");
        result.append("                 AND center.ffabizcardid in (" + cardIds + ")\n");
        result.append("            GROUP BY center.ffabizcardid, tmpcenter.MAX, tmpcenter.MIN, tmpcenter.countseq\n");
        result.append("            ) x ON x.ffabizcardid = bizcard.fid\n");
        result.append("INNER JOIN (" + this.getBizCardSumEntryAmount(amountValue, baseCurPrecision, cardIds) + ") tempoffset ON tempoffset.bizcardid = bizcard.fid\n");
        result.append("WHERE bizcard.fid in (" + cardIds + ")\n");
        result.append("  AND chgbill.FhasDepartmentChanged  = 1\n");
        result.append("GROUP BY bizcard.fid, " + groupAccountID + ", \n");
        result.append(" bizcard." + amountValue + ", costcenter.faccountviewid, costcenter.FPROFITCENTERID, costcenter.fseq,\n");
        result.append(" costcenter.fapportionscale, costcenter.fid, composit.fasstacttype, composit.fasstactitem, \n");
        result.append(" tempoffset.toffset, x.countseq, x.maxscale, x.minseqofmaxscale, x.minseq\n");
        return result;
    }

    private StringBuffer getBizCardDistributeForAmountChangedSQL(int accType, int baseCurPrecision, String cardIds, boolean isDebitOrCredit) {
        StringBuffer result = new StringBuffer();
        String accountAssetID = "''";
        String accountAccuDeprID = "''";
        String accountDecValueID = "''";
        String amountValue = "";
        String groupAccountID = "";
        if (accType == 1) {
            accountAssetID = "bizcard.FAccountAssetID";
            amountValue = "TOriginChg";
            groupAccountID = accountAssetID;
        } else if (accType == 2) {
            accountAccuDeprID = "bizcard.FAccountAccuDeprID";
            amountValue = "TAccuDeprChg";
            groupAccountID = accountAccuDeprID;
        } else {
            accountDecValueID = "bizcard.FAccountDecValueID";
            amountValue = "TDecValueChg";
            groupAccountID = accountDecValueID;
        }
        result.append("SELECT bizcard.fid AS fid,\n");
        result.append(accountAssetID + " AS FAccountAssetID,\n");
        result.append(accountAccuDeprID + " AS FAccountAccuDeprID,\n");
        result.append(accountDecValueID + " AS FAccountDecValueID,\n");
        result.append("costcenter.fseq AS fseq, \n");
        result.append("costcenter.faccountviewid AS accountview,\n");
        result.append("costcenter.fapportionscale AS fapportionscale,\n");
        result.append("costcenter.fid AS costcenterid,\n");
        result.append("composit.fasstacttype AS fasstacttype,\n");
        result.append("composit.fasstactitem AS fasstactitem,\n");
        result.append("\t\t\t   CASE\n");
        result.append("               WHEN (   x.countseq * x.maxscale = 100 AND costcenter.fseq = x.minseq\n");
        result.append("                     OR (x.countseq * x.maxscale != 100) AND (costcenter.fapportionscale = x.maxscale AND costcenter.fseq = x.minseqofmaxscale) \n");
        result.append("                    )\n");
        result.append("                  THEN ROUND (costcenter.fapportionscale * chgentry." + amountValue + " / 100, " + baseCurPrecision + ") + tempoffset.toffset\n");
        result.append("              ELSE ROUND (costcenter.fapportionscale * chgentry." + amountValue + " / 100, " + baseCurPrecision + ")\n");
        result.append("            END AS amount \n");
        result.append(" FROM t_fa_fabizcard bizcard\n");
        result.append("INNER JOIN t_fa_fachangebillentry chgentry ON chgentry.fbizcardid = bizcard.fid\n");
        result.append("INNER JOIN t_fa_fabizcostcenter costcenter ON costcenter.ffabizcardid = bizcard.fid\n");
        result.append("LEFT OUTER JOIN t_fa_fabizasstactcomposit composit on composit.FFaBizCostCenterID = costcenter.fid\n");
        result.append("INNER JOIN (\n");
        result.append("            SELECT   MIN (center.fseq) AS minseqofmaxscale, center.ffabizcardid AS ffabizcardid, tmpcenter.MAX AS maxscale, tmpcenter.MIN AS minseq,\n");
        result.append("                     tmpcenter.countseq AS countseq\n");
        result.append("                FROM t_fa_fabizcostcenter center INNER JOIN (SELECT   MAX (fapportionscale) AS MAX, MIN (fseq) AS MIN, ffabizcardid AS cardid,\n");
        result.append("                                                                      COUNT (fseq) AS countseq\n");
        result.append("                                                                 FROM t_fa_fabizcostcenter\n");
        result.append("                                                             GROUP BY ffabizcardid) tmpcenter ON center.ffabizcardid = tmpcenter.cardid\n");
        result.append("               WHERE center.fapportionscale = tmpcenter.MAX\n");
        result.append("                 AND center.ffabizcardid in (" + cardIds + ")\n");
        result.append("            GROUP BY center.ffabizcardid, tmpcenter.MAX, tmpcenter.MIN, tmpcenter.countseq\n");
        result.append("            ) x ON x.ffabizcardid = bizcard.fid\n");
        result.append("INNER JOIN (" + this.getBizCardSumEntryAmountForAmountChanged(amountValue, baseCurPrecision, cardIds) + ") tempoffset ON tempoffset.bizcardid = bizcard.fid\n");
        result.append("WHERE bizcard.fid in (" + cardIds + ")\n");
        if (isDebitOrCredit) {
            result.append("AND chgentry." + amountValue + " > 0\n");
        } else {
            result.append("AND chgentry." + amountValue + " < 0\n");
        }
        result.append("GROUP BY bizcard.fid, " + groupAccountID + ", \n");
        result.append(" chgentry." + amountValue + ", costcenter.faccountviewid, costcenter.fseq,\n");
        result.append(" costcenter.fapportionscale, costcenter.fid, composit.fasstacttype, composit.fasstactitem, \n");
        result.append(" tempoffset.toffset, x.countseq, x.maxscale, x.minseqofmaxscale, x.minseq\n");
        return result;
    }

    private StringBuffer getBizCardDistributeForAmountChangedSQLWithProfit(int accType, int baseCurPrecision, String cardIds, boolean isDebitOrCredit) {
        StringBuffer result = new StringBuffer();
        String accountAssetID = "''";
        String accountAccuDeprID = "''";
        String accountDecValueID = "''";
        String amountValue = "";
        String groupAccountID = "";
        if (accType == 1) {
            accountAssetID = "bizcard.FAccountAssetID";
            amountValue = "TOriginChg";
            groupAccountID = accountAssetID;
        } else if (accType == 2) {
            accountAccuDeprID = "bizcard.FAccountAccuDeprID";
            amountValue = "TAccuDeprChg";
            groupAccountID = accountAccuDeprID;
        } else {
            accountDecValueID = "bizcard.FAccountDecValueID";
            amountValue = "TDecValueChg";
            groupAccountID = accountDecValueID;
        }
        result.append("SELECT bizcard.fid AS fid,\n");
        result.append(accountAssetID + " AS FAccountAssetID,\n");
        result.append(accountAccuDeprID + " AS FAccountAccuDeprID,\n");
        result.append(accountDecValueID + " AS FAccountDecValueID,\n");
        result.append("costcenter.fseq AS fseq, \n");
        result.append("costcenter.faccountviewid AS accountview,\n");
        result.append("costcenter.FPROFITCENTERID AS profitcenter,\n");
        result.append("costcenter.fapportionscale AS fapportionscale,\n");
        result.append("costcenter.fid AS costcenterid,\n");
        result.append("composit.fasstacttype AS fasstacttype,\n");
        result.append("composit.fasstactitem AS fasstactitem,\n");
        result.append("\t\t\t   CASE\n");
        result.append("               WHEN (   x.countseq * x.maxscale = 100 AND costcenter.fseq = x.minseq\n");
        result.append("                     OR (x.countseq * x.maxscale != 100) AND (costcenter.fapportionscale = x.maxscale AND costcenter.fseq = x.minseqofmaxscale) \n");
        result.append("                    )\n");
        result.append("                  THEN ROUND (costcenter.fapportionscale * chgentry." + amountValue + " / 100, " + baseCurPrecision + ") + tempoffset.toffset\n");
        result.append("              ELSE ROUND (costcenter.fapportionscale * chgentry." + amountValue + " / 100, " + baseCurPrecision + ")\n");
        result.append("            END AS amount \n");
        result.append(" FROM t_fa_fabizcard bizcard\n");
        result.append("INNER JOIN t_fa_fachangebillentry chgentry ON chgentry.fbizcardid = bizcard.fid\n");
        result.append("INNER JOIN t_fa_fabizcostcenter costcenter ON costcenter.ffabizcardid = bizcard.fid\n");
        result.append("INNER JOIN t_fa_fabizasstactcomposit composit on composit.FFaBizCostCenterID = costcenter.fid\n");
        result.append("INNER JOIN (\n");
        result.append("            SELECT   MIN (center.fseq) AS minseqofmaxscale, center.ffabizcardid AS ffabizcardid, tmpcenter.MAX AS maxscale, tmpcenter.MIN AS minseq,\n");
        result.append("                     tmpcenter.countseq AS countseq\n");
        result.append("                FROM t_fa_fabizcostcenter center INNER JOIN (SELECT   MAX (fapportionscale) AS MAX, MIN (fseq) AS MIN, ffabizcardid AS cardid,\n");
        result.append("                                                                      COUNT (fseq) AS countseq\n");
        result.append("                                                                 FROM t_fa_fabizcostcenter\n");
        result.append("                                                             GROUP BY ffabizcardid) tmpcenter ON center.ffabizcardid = tmpcenter.cardid\n");
        result.append("               WHERE center.fapportionscale = tmpcenter.MAX\n");
        result.append("                 AND center.ffabizcardid in (" + cardIds + ")\n");
        result.append("            GROUP BY center.ffabizcardid, tmpcenter.MAX, tmpcenter.MIN, tmpcenter.countseq\n");
        result.append("            ) x ON x.ffabizcardid = bizcard.fid\n");
        result.append("INNER JOIN (" + this.getBizCardSumEntryAmountForAmountChanged(amountValue, baseCurPrecision, cardIds) + ") tempoffset ON tempoffset.bizcardid = bizcard.fid\n");
        result.append("WHERE bizcard.fid in (" + cardIds + ")\n");
        if (isDebitOrCredit) {
            result.append("AND chgentry." + amountValue + " > 0\n");
        } else {
            result.append("AND chgentry." + amountValue + " < 0\n");
        }
        result.append("GROUP BY bizcard.fid, " + groupAccountID + ", \n");
        result.append(" chgentry." + amountValue + ", costcenter.faccountviewid, costcenter.FPROFITCENTERID, costcenter.fseq,\n");
        result.append(" costcenter.fapportionscale, costcenter.fid, composit.fasstacttype, composit.fasstactitem, \n");
        result.append(" tempoffset.toffset, x.countseq, x.maxscale, x.minseqofmaxscale, x.minseq\n");
        return result;
    }

    private StringBuffer getBizCardSumEntryAmountForAmountChanged(String amountValue, int baseCurPrecision, String cardIds) {
        StringBuffer result = new StringBuffer();
        result.append("SELECT\n");
        result.append("tempcal.fvalue - SUM (disamount) AS toffset,\n");
        result.append("tempcal.fvalue,\n");
        result.append("SUM (disamount) AS sumdisamount,\n");
        result.append("tempcal.ffabizcardid AS bizcardid\n");
        result.append("FROM (\n");
        result.append("SELECT entry." + amountValue + " AS fvalue, costcenter.fapportionscale,\n");
        result.append("ROUND (costcenter.fapportionscale * entry." + amountValue + " / 100, " + baseCurPrecision + ") AS disamount,\n");
        result.append("costcenter.ffabizcardid, costcenter.fseq\n");
        result.append("FROM t_fa_fabizcard bizcard\n");
        result.append("INNER JOIN t_fa_fachangebillentry entry ON entry.fbizcardid = bizcard.fid\n");
        result.append("INNER JOIN t_fa_fabizcostcenter costcenter ON costcenter.ffabizcardid = bizcard.fid\n");
        result.append("WHERE bizcard.fid in (" + cardIds + ")\n");
        result.append(") tempcal\n");
        result.append("GROUP BY tempcal.ffabizcardid, tempcal.fvalue\n");
        return result;
    }

    private List combineCardAssetItem(Context ctx, FaChangeBillInfo changeBillInfo, Map accountMap, StringBuffer sql, String sourceBill, String changeType) throws BOSException, EASBizException {
        boolean isAddDistributeSum = changeBillInfo.getBoolean("isAddDistributeSum");
        HashMap<String, FaChangeBillDAPVoucherSumInfo> accoutAssetMap = new HashMap<String, FaChangeBillDAPVoucherSumInfo>();
        HashMap<String, FaChangeBillDAPVoucherSumInfo> accountAccuDeprMap = new HashMap<String, FaChangeBillDAPVoucherSumInfo>();
        HashMap<String, FaChangeBillDAPVoucherSumInfo> accountDecMap = new HashMap<String, FaChangeBillDAPVoucherSumInfo>();
        HashMap<String, FaChangeBillDAPVoucherSumInfo> accountDistributeMap = new HashMap<String, FaChangeBillDAPVoucherSumInfo>();
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String tempCostcenterId = "";
        String tempAccountAssetId = "";
        String tempAccountAccuDeprId = "";
        String tempAccountDecValueId = "";
        String tempDistributeAccountId = "";
        String tempAccountViewId = "";
        StringBuffer tempasstAct = new StringBuffer();
        StringBuffer tempdeprAct = new StringBuffer();
        StringBuffer tempdecAct = new StringBuffer();
        StringBuffer tempDistributeAct = new StringBuffer();
        BigDecimal tempAmount = FaManageUtils.zero;
        String tempProfitcenterId = "";
        FaChangeTypeForVoucherEnum changType = null;
        if ("Amount".equals(changeType)) {
            changType = FaChangeTypeForVoucherEnum.AMOUNTCHANGED;
        } else if ("AccountView".equals(changeType)) {
            changType = FaChangeTypeForVoucherEnum.ACCOUNTVIEWCHANGED;
        } else if ("UseDepartment".equals(changeType)) {
            changType = FaChangeTypeForVoucherEnum.USEDEPARTMENTCHANGED;
        }
        try {
            while (rowSet.next()) {
                ProfitCenterOrgUnitInfo profit;
                AccountViewInfo distributeAccountView;
                String tempDistributeMapKey;
                FaChangeBillDAPVoucherSumInfo decCardSumInfo;
                FaChangeBillDAPVoucherSumInfo oldFaCardDecSumInfo;
                FaChangeBillDAPVoucherSumInfo deprCardSumInfo;
                FaChangeBillDAPVoucherSumInfo oldFaCardDeprSumInfo;
                ProfitCenterOrgUnitInfo profit2;
                FaChangeBillDAPVoucherSumInfo assetCardSumInfo;
                FaChangeBillDAPVoucherSumInfo oldFaCardAsstSumInfo;
                String costcenterId = rowSet.getString("costcenterid");
                String distributeAccountId = rowSet.getString("accountview");
                String accountAssetId = rowSet.getString("FAccountAssetID");
                String accountAccuDeprId = rowSet.getString("FAccountAccuDeprID");
                String accountDecValueId = rowSet.getString("FAccountDecValueID");
                String AccountViewId = accountAssetId + accountAccuDeprId + accountDecValueId;
                String asstacttypeId = rowSet.getString("fasstacttype");
                String asstactitemId = rowSet.getString("fasstactitem");
                String profitCenter = "";
                if (this.canShowProfit) {
                    profitCenter = rowSet.getString("profitcenter");
                }
                if (!("".equals(tempCostcenterId.trim()) || "".equals(tempAccountViewId.trim()) || AccountViewId.equals(tempAccountViewId) && (!AccountViewId.equals(tempAccountViewId) || costcenterId.equals(tempCostcenterId)))) {
                    if (tempAccountAssetId != null && !"".equals(tempAccountAssetId)) {
                        if (accoutAssetMap.get(tempAccountAssetId + tempasstAct + tempProfitcenterId) != null) {
                            oldFaCardAsstSumInfo = (FaChangeBillDAPVoucherSumInfo)accoutAssetMap.get(tempAccountAssetId + tempasstAct + tempProfitcenterId);
                            oldFaCardAsstSumInfo.setAsstAmount(oldFaCardAsstSumInfo.getAsstAmount().add(tempAmount));
                        } else {
                            assetCardSumInfo = new FaChangeBillDAPVoucherSumInfo();
                            assetCardSumInfo.setChangBill(changeBillInfo);
                            AccountViewInfo assetViewInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)tempAccountAssetId)));
                            if ("FaBakCard".equals(sourceBill)) {
                                assetCardSumInfo.setBakCardAssetAcct(assetViewInfo);
                            } else if ("FaBizCard".equals(sourceBill)) {
                                assetCardSumInfo.setBizCardAssetAcct(assetViewInfo);
                            }
                            assetCardSumInfo.setAsstItem(tempasstAct.toString());
                            assetCardSumInfo.setAsstAmount(tempAmount);
                            assetCardSumInfo.setChangeType(changType);
                            if (this.canShowProfit && tempProfitcenterId != null && !"".equals(tempProfitcenterId)) {
                                profit2 = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)tempProfitcenterId)));
                                assetCardSumInfo.setProfitCenter(profit2);
                            }
                            accoutAssetMap.put(tempAccountAssetId + tempasstAct + tempProfitcenterId, assetCardSumInfo);
                        }
                    }
                    if (tempAccountAccuDeprId != null && !"".equals(tempAccountAccuDeprId)) {
                        if (accountAccuDeprMap.get(tempAccountAccuDeprId + tempdeprAct + tempProfitcenterId) != null) {
                            oldFaCardDeprSumInfo = (FaChangeBillDAPVoucherSumInfo)accountAccuDeprMap.get(tempAccountAccuDeprId + tempdeprAct + tempProfitcenterId);
                            oldFaCardDeprSumInfo.setDeprAmount(oldFaCardDeprSumInfo.getDeprAmount().add(tempAmount));
                        } else {
                            deprCardSumInfo = new FaChangeBillDAPVoucherSumInfo();
                            deprCardSumInfo.setChangBill(changeBillInfo);
                            AccountViewInfo deprViewInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)tempAccountAccuDeprId)));
                            if ("FaBakCard".equals(sourceBill)) {
                                deprCardSumInfo.setBakCardAccuDeprAcct(deprViewInfo);
                            } else if ("FaBizCard".equals(sourceBill)) {
                                deprCardSumInfo.setBizCardAccuDeprAcct(deprViewInfo);
                            }
                            deprCardSumInfo.setDeprAmount(tempAmount);
                            deprCardSumInfo.setAsstItem(tempdeprAct.toString());
                            deprCardSumInfo.setChangeType(changType);
                            if (tempProfitcenterId != null && !"".equals(tempProfitcenterId)) {
                                profit2 = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)tempProfitcenterId)));
                                deprCardSumInfo.setProfitCenter(profit2);
                            }
                            accountAccuDeprMap.put(tempAccountAccuDeprId + tempdeprAct + tempProfitcenterId, deprCardSumInfo);
                        }
                    }
                    if (tempAccountDecValueId != null && !"".equals(tempAccountDecValueId)) {
                        if (accountDecMap.get(tempAccountDecValueId + tempdecAct + tempProfitcenterId) != null) {
                            oldFaCardDecSumInfo = (FaChangeBillDAPVoucherSumInfo)accountDecMap.get(tempAccountDecValueId + tempdecAct + tempProfitcenterId);
                            oldFaCardDecSumInfo.setDecAmount(oldFaCardDecSumInfo.getDecAmount().add(tempAmount));
                        } else if (tempAccountDecValueId != null) {
                            decCardSumInfo = new FaChangeBillDAPVoucherSumInfo();
                            decCardSumInfo.setChangBill(changeBillInfo);
                            AccountViewInfo decViewInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)tempAccountDecValueId)));
                            if ("FaBakCard".equals(sourceBill)) {
                                decCardSumInfo.setBakCardDecValueAcct(decViewInfo);
                            } else if ("FaBizCard".equals(sourceBill)) {
                                decCardSumInfo.setBizCardDecValueAcct(decViewInfo);
                            }
                            decCardSumInfo.setDecAmount(tempAmount);
                            decCardSumInfo.setAsstItem(tempdecAct.toString());
                            decCardSumInfo.setChangeType(changType);
                            if (tempProfitcenterId != null && !"".equals(tempProfitcenterId)) {
                                profit2 = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)tempProfitcenterId)));
                                decCardSumInfo.setProfitCenter(profit2);
                            }
                            accountDecMap.put(tempAccountDecValueId + tempdecAct + tempProfitcenterId, decCardSumInfo);
                        }
                    }
                    if (isAddDistributeSum && tempDistributeAccountId != null && !"".equals(tempDistributeAccountId)) {
                        tempDistributeMapKey = tempDistributeAccountId + tempDistributeAct + tempProfitcenterId;
                        if (accountDistributeMap.get(tempDistributeMapKey) != null) {
                            FaChangeBillDAPVoucherSumInfo oldFaCardDistributeSumInfo = (FaChangeBillDAPVoucherSumInfo)accountDistributeMap.get(tempDistributeMapKey);
                            oldFaCardDistributeSumInfo.setDeprAmount(oldFaCardDistributeSumInfo.getDeprAmount().add(tempAmount));
                        } else if (tempDistributeAccountId != null) {
                            FaChangeBillDAPVoucherSumInfo distributeSumInfo = new FaChangeBillDAPVoucherSumInfo();
                            distributeSumInfo.setChangBill(changeBillInfo);
                            distributeAccountView = new AccountViewInfo();
                            distributeAccountView.setId(BOSUuid.read((String)tempDistributeAccountId));
                            if ("FaBakCard".equals(sourceBill)) {
                                distributeSumInfo.setBakCardDistributeAcct(distributeAccountView);
                            } else if ("FaBizCard".equals(sourceBill)) {
                                distributeSumInfo.setBizCardDistributeAcct(distributeAccountView);
                            }
                            distributeSumInfo.setDeprAmount(tempAmount);
                            distributeSumInfo.setAsstItem(tempDistributeAct.toString());
                            distributeSumInfo.setChangeType(changType);
                            if (tempProfitcenterId != null && !"".equals(tempProfitcenterId)) {
                                profit = new ProfitCenterOrgUnitInfo();
                                profit.setId(BOSUuid.read((String)tempProfitcenterId));
                                distributeSumInfo.setProfitCenter(profit);
                            }
                            accountDistributeMap.put(tempDistributeMapKey, distributeSumInfo);
                        }
                    }
                    tempasstAct = new StringBuffer();
                    tempdeprAct = new StringBuffer();
                    tempdecAct = new StringBuffer();
                    tempDistributeAct = new StringBuffer();
                    tempAmount = FaManageUtils.zero;
                }
                if (accountMap.get(accountAssetId) != null) {
                    List assetAccountViewList = (List)accountMap.get(accountAssetId);
                    for (int j = 0; j < assetAccountViewList.size(); ++j) {
                        if (asstacttypeId == null || !asstacttypeId.equals(assetAccountViewList.get(j))) continue;
                        tempasstAct.append(asstacttypeId);
                        tempasstAct.append("::");
                        tempasstAct.append(asstactitemId);
                        tempasstAct.append(";;");
                        break;
                    }
                }
                if (accountMap.get(accountAccuDeprId) != null) {
                    List deprAccountViewList = (List)accountMap.get(accountAccuDeprId);
                    for (int k = 0; k < deprAccountViewList.size(); ++k) {
                        if (asstacttypeId == null || !asstacttypeId.equals(deprAccountViewList.get(k))) continue;
                        tempdeprAct.append(asstacttypeId);
                        tempdeprAct.append("::");
                        tempdeprAct.append(asstactitemId);
                        tempdeprAct.append(";;");
                        break;
                    }
                }
                if (accountDecValueId != null && accountMap.get(accountDecValueId) != null) {
                    List decAccountViewList = (List)accountMap.get(accountDecValueId);
                    for (int n = 0; n < decAccountViewList.size(); ++n) {
                        if (asstacttypeId == null || !asstacttypeId.equals(decAccountViewList.get(n))) continue;
                        tempdecAct.append(asstacttypeId);
                        tempdecAct.append("::");
                        tempdecAct.append(asstactitemId);
                        tempdecAct.append(";;");
                        break;
                    }
                }
                if (distributeAccountId != null && accountMap.get(distributeAccountId) != null) {
                    List distributeAccountViewList = (List)accountMap.get(distributeAccountId);
                    for (int n = 0; n < distributeAccountViewList.size(); ++n) {
                        if (asstacttypeId == null || !asstacttypeId.equals(distributeAccountViewList.get(n))) continue;
                        tempDistributeAct.append(asstacttypeId);
                        tempDistributeAct.append("::");
                        tempDistributeAct.append(asstactitemId);
                        tempDistributeAct.append(";;");
                        break;
                    }
                }
                tempCostcenterId = costcenterId;
                tempAccountAssetId = accountAssetId;
                tempAccountAccuDeprId = accountAccuDeprId;
                tempAccountDecValueId = accountDecValueId;
                tempDistributeAccountId = distributeAccountId;
                tempAccountViewId = accountAssetId + accountAccuDeprId + accountDecValueId;
                tempAmount = rowSet.getBigDecimal("amount");
                tempProfitcenterId = profitCenter;
                if (!rowSet.isLast()) continue;
                if (tempAccountAssetId != null && !"".equals(tempAccountAssetId)) {
                    if (accoutAssetMap.get(tempAccountAssetId + tempasstAct + tempProfitcenterId) != null) {
                        oldFaCardAsstSumInfo = (FaChangeBillDAPVoucherSumInfo)accoutAssetMap.get(tempAccountAssetId + tempasstAct + tempProfitcenterId);
                        oldFaCardAsstSumInfo.setAsstAmount(oldFaCardAsstSumInfo.getAsstAmount().add(tempAmount));
                    } else {
                        assetCardSumInfo = new FaChangeBillDAPVoucherSumInfo();
                        assetCardSumInfo.setChangBill(changeBillInfo);
                        AccountViewInfo assetViewInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)tempAccountAssetId)));
                        if ("FaBakCard".equals(sourceBill)) {
                            assetCardSumInfo.setBakCardAssetAcct(assetViewInfo);
                        } else if ("FaBizCard".equals(sourceBill)) {
                            assetCardSumInfo.setBizCardAssetAcct(assetViewInfo);
                        }
                        assetCardSumInfo.setAsstItem(tempasstAct.toString());
                        assetCardSumInfo.setAsstAmount(tempAmount);
                        assetCardSumInfo.setChangeType(changType);
                        if (tempProfitcenterId != null && !"".equals(tempProfitcenterId)) {
                            profit2 = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)tempProfitcenterId)));
                            assetCardSumInfo.setProfitCenter(profit2);
                        }
                        accoutAssetMap.put(tempAccountAssetId + tempasstAct + tempProfitcenterId, assetCardSumInfo);
                    }
                }
                if (tempAccountAccuDeprId != null && !"".equals(tempAccountAccuDeprId)) {
                    if (accountAccuDeprMap.get(tempAccountAccuDeprId + tempdeprAct + tempProfitcenterId) != null) {
                        oldFaCardDeprSumInfo = (FaChangeBillDAPVoucherSumInfo)accountAccuDeprMap.get(tempAccountAccuDeprId + tempdeprAct + tempProfitcenterId);
                        oldFaCardDeprSumInfo.setDeprAmount(oldFaCardDeprSumInfo.getDeprAmount().add(tempAmount));
                    } else {
                        deprCardSumInfo = new FaChangeBillDAPVoucherSumInfo();
                        deprCardSumInfo.setChangBill(changeBillInfo);
                        AccountViewInfo deprViewInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)tempAccountAccuDeprId)));
                        if ("FaBakCard".equals(sourceBill)) {
                            deprCardSumInfo.setBakCardAccuDeprAcct(deprViewInfo);
                        } else if ("FaBizCard".equals(sourceBill)) {
                            deprCardSumInfo.setBizCardAccuDeprAcct(deprViewInfo);
                        }
                        deprCardSumInfo.setDeprAmount(tempAmount);
                        deprCardSumInfo.setAsstItem(tempdeprAct.toString());
                        deprCardSumInfo.setChangeType(changType);
                        if (tempProfitcenterId != null && !"".equals(tempProfitcenterId)) {
                            profit2 = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)tempProfitcenterId)));
                            deprCardSumInfo.setProfitCenter(profit2);
                        }
                        accountAccuDeprMap.put(tempAccountAccuDeprId + tempdeprAct + tempProfitcenterId, deprCardSumInfo);
                    }
                }
                if (tempAccountDecValueId != null && !"".equals(tempAccountDecValueId)) {
                    if (accountDecMap.get(tempAccountDecValueId + tempdecAct + tempProfitcenterId) != null) {
                        oldFaCardDecSumInfo = (FaChangeBillDAPVoucherSumInfo)accountDecMap.get(tempAccountDecValueId + tempdecAct + tempProfitcenterId);
                        oldFaCardDecSumInfo.setDecAmount(oldFaCardDecSumInfo.getDecAmount().add(tempAmount));
                    } else if (tempAccountDecValueId != null) {
                        decCardSumInfo = new FaChangeBillDAPVoucherSumInfo();
                        decCardSumInfo.setChangBill(changeBillInfo);
                        AccountViewInfo decViewInfo = null;
                        decViewInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)tempAccountDecValueId)));
                        if ("FaBakCard".equals(sourceBill)) {
                            decCardSumInfo.setBakCardDecValueAcct(decViewInfo);
                        } else if ("FaBizCard".equals(sourceBill)) {
                            decCardSumInfo.setBizCardDecValueAcct(decViewInfo);
                        }
                        decCardSumInfo.setDecAmount(tempAmount);
                        decCardSumInfo.setAsstItem(tempdecAct.toString());
                        decCardSumInfo.setChangeType(changType);
                        if (tempProfitcenterId != null && !"".equals(tempProfitcenterId)) {
                            profit2 = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)tempProfitcenterId)));
                            decCardSumInfo.setProfitCenter(profit2);
                        }
                        accountDecMap.put(tempAccountDecValueId + tempdecAct + tempProfitcenterId, decCardSumInfo);
                    }
                }
                if (!isAddDistributeSum || tempDistributeAccountId == null || "".equals(tempDistributeAccountId)) continue;
                tempDistributeMapKey = tempDistributeAccountId + tempDistributeAct + tempProfitcenterId;
                if (accountDistributeMap.get(tempDistributeMapKey) != null) {
                    FaChangeBillDAPVoucherSumInfo oldFaCardDistributeSumInfo = (FaChangeBillDAPVoucherSumInfo)accountDistributeMap.get(tempDistributeMapKey);
                    oldFaCardDistributeSumInfo.setDeprAmount(oldFaCardDistributeSumInfo.getDeprAmount().add(tempAmount));
                    continue;
                }
                if (tempDistributeAccountId == null) continue;
                FaChangeBillDAPVoucherSumInfo distributeSumInfo = new FaChangeBillDAPVoucherSumInfo();
                distributeSumInfo.setChangBill(changeBillInfo);
                distributeAccountView = new AccountViewInfo();
                distributeAccountView.setId(BOSUuid.read((String)tempDistributeAccountId));
                if ("FaBakCard".equals(sourceBill)) {
                    distributeSumInfo.setBakCardDistributeAcct(distributeAccountView);
                } else if ("FaBizCard".equals(sourceBill)) {
                    distributeSumInfo.setBizCardDistributeAcct(distributeAccountView);
                }
                distributeSumInfo.setDeprAmount(tempAmount);
                distributeSumInfo.setAsstItem(tempDistributeAct.toString());
                distributeSumInfo.setChangeType(changType);
                if (tempProfitcenterId != null && !"".equals(tempProfitcenterId)) {
                    profit = new ProfitCenterOrgUnitInfo();
                    profit.setId(BOSUuid.read((String)tempProfitcenterId));
                    distributeSumInfo.setProfitCenter(profit);
                }
                accountDistributeMap.put(tempDistributeMapKey, distributeSumInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        ArrayList<HashMap<String, FaChangeBillDAPVoucherSumInfo>> list = new ArrayList<HashMap<String, FaChangeBillDAPVoucherSumInfo>>();
        list.add(accoutAssetMap);
        list.add(accountAccuDeprMap);
        list.add(accountDecMap);
        if (isAddDistributeSum) {
            list.add(accountDistributeMap);
        }
        return list;
    }

    protected FaChangeBillDAPVoucherSumCollection getFaChangeBillDAPVoucherSumInfo(Context ctx, String billID) throws BOSException {
        try {
            String isUseProfit;
            CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
            HashMap hmResult = FaManageUtils.getFAParameter(ctx, new String[]{"GL_111"}, company.getId().toString());
            String string = isUseProfit = hmResult != null && hmResult.get("GL_111") != null ? (String)hmResult.get("GL_111") : "false";
            if ("true".equalsIgnoreCase(isUseProfit)) {
                this.canShowProfit = true;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT vouchersum.FID \t\t\t   AS FID,");
        sql.append(" vouchersum.FBakCardAssetAcctID    AS FBakCardAssetAcctID,");
        sql.append(" vouchersum.FBakCardAccuDeprAcctID AS FBakCardAccuDeprAcctID,");
        sql.append(" vouchersum.FBakCardDecValueAcctID AS FBakCardDecValueAcctID,");
        sql.append(" vouchersum.FBizCardAssetAcctID    AS FBizCardAssetAcctID,");
        sql.append(" vouchersum.FBizCardAccuDeprAcctID AS FBizCardAccuDeprAcctID,");
        sql.append(" vouchersum.FBizCardDecValueAcctID AS FBizCardDecValueAcctID,");
        sql.append(" vouchersum.FASSTITEM \t\t\t   AS FASSTITEM,");
        sql.append(" isnull(vouchersum.FASSTAMOUNT, 0) AS FASSTAMOUNT,");
        sql.append(" isnull(vouchersum.FDEPRAMOUNT, 0) AS FDEPRAMOUNT,");
        sql.append(" isnull(vouchersum.FDECAMOUNT, 0)  AS FDECAMOUNT,");
        sql.append(" isnull(vouchersum.FCHANGETYPE, 0) AS FCHANGETYPE,");
        sql.append(" vouchersum.FChangeBillID \t\t   AS FChangeBillID ");
        if (this.canShowProfit) {
            sql.append(" ,vouchersum.fprofitcenterid as FPROFITID ");
        }
        sql.append("FROM T_FA_FaChangeBillDAPVoucherSum vouchersum ");
        sql.append("WHERE vouchersum.FChangeBillID = ?");
        Object[] sqlPara = new Object[]{billID};
        FaChangeBillDAPVoucherSumCollection cardSumCollection = new FaChangeBillDAPVoucherSumCollection();
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])sqlPara);
            while (rowSet.next()) {
                FaChangeBillDAPVoucherSumInfo voucherSumInfo = new FaChangeBillDAPVoucherSumInfo();
                voucherSumInfo.setId(BOSUuid.read((String)rowSet.getString("FID")));
                String assetAcct = rowSet.getString("FBakCardAssetAcctID");
                AccountViewInfo assetAcctInfo = new AccountViewInfo();
                if (assetAcct != null && !"".equals(assetAcct)) {
                    assetAcctInfo.setId(BOSUuid.read((String)assetAcct));
                } else {
                    assetAcctInfo = null;
                }
                voucherSumInfo.setBakCardAssetAcct(assetAcctInfo);
                String accuDeprAcct = rowSet.getString("FBakCardAccuDeprAcctID");
                AccountViewInfo accuDeprAcctInfo = new AccountViewInfo();
                if (accuDeprAcct != null && !"".equals(accuDeprAcct)) {
                    accuDeprAcctInfo.setId(BOSUuid.read((String)accuDeprAcct));
                } else {
                    accuDeprAcctInfo = null;
                }
                voucherSumInfo.setBakCardAccuDeprAcct(accuDeprAcctInfo);
                String decAcct = rowSet.getString("FBakCardDecValueAcctID");
                AccountViewInfo decAcctInfo = new AccountViewInfo();
                if (decAcct != null && !"".equals(decAcct)) {
                    decAcctInfo.setId(BOSUuid.read((String)decAcct));
                } else {
                    decAcctInfo = null;
                }
                voucherSumInfo.setBakCardDecValueAcct(decAcctInfo);
                String bizAssetAcct = rowSet.getString("FBizCardAssetAcctID");
                AccountViewInfo bizAssetAcctInfo = new AccountViewInfo();
                if (bizAssetAcct != null && !"".equals(bizAssetAcct)) {
                    bizAssetAcctInfo.setId(BOSUuid.read((String)bizAssetAcct));
                } else {
                    bizAssetAcctInfo = null;
                }
                voucherSumInfo.setBizCardAssetAcct(bizAssetAcctInfo);
                String bizAccuDeprAcct = rowSet.getString("FBizCardAccuDeprAcctID");
                AccountViewInfo bizAccuDeprAcctInfo = new AccountViewInfo();
                if (bizAccuDeprAcct != null && !"".equals(bizAccuDeprAcct)) {
                    bizAccuDeprAcctInfo.setId(BOSUuid.read((String)bizAccuDeprAcct));
                } else {
                    bizAccuDeprAcctInfo = null;
                }
                voucherSumInfo.setBizCardAccuDeprAcct(bizAccuDeprAcctInfo);
                String bizDecAcct = rowSet.getString("FBizCardDecValueAcctID");
                AccountViewInfo bizDecAcctInfo = new AccountViewInfo();
                if (bizDecAcct != null && !"".equals(bizDecAcct)) {
                    bizDecAcctInfo.setId(BOSUuid.read((String)bizDecAcct));
                } else {
                    bizDecAcctInfo = null;
                }
                voucherSumInfo.setBizCardDecValueAcct(bizDecAcctInfo);
                voucherSumInfo.setAsstItem(rowSet.getString("FASSTITEM"));
                voucherSumInfo.setAsstAmount(rowSet.getBigDecimal("FASSTAMOUNT"));
                voucherSumInfo.setDeprAmount(rowSet.getBigDecimal("FDEPRAMOUNT"));
                voucherSumInfo.setDecAmount(rowSet.getBigDecimal("FDECAMOUNT"));
                if (rowSet.getObject("FCHANGETYPE") != null) {
                    int changeType = rowSet.getInt("FCHANGETYPE");
                    FaChangeTypeForVoucherEnum changeTypeIten = FaChangeTypeForVoucherEnum.getEnum(changeType);
                    voucherSumInfo.setChangeType(changeTypeIten);
                }
                String changeBillId = rowSet.getString("FChangeBillID");
                FaChangeBillInfo changeBillInfo = new FaChangeBillInfo();
                if (changeBillId != null && !"".equals(changeBillId)) {
                    changeBillInfo.setId(BOSUuid.read((String)changeBillId));
                }
                voucherSumInfo.setChangBill(changeBillInfo);
                if (this.canShowProfit) {
                    String profitid = rowSet.getString("FPROFITID");
                    try {
                        if (profitid != null) {
                            ProfitCenterOrgUnitInfo profit = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)profitid)));
                            voucherSumInfo.setProfitCenter(profit);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                cardSumCollection.add(voucherSumInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        return cardSumCollection;
    }

    public void checkBeforeSubmit(Context ctx, FaCardInfo faCardInfo, boolean isSubmit) throws BOSException, EASBizException {
        String verifyBizStatus;
        StringBuffer errorMsg = new StringBuffer();
        FaCardWebValidatorImpl validator = new FaCardWebValidatorImpl(ctx, faCardInfo, false);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("verifySubmit", isSubmit);
        params.put("Company", faCardInfo.getCompany());
        params.put("fromBillUI", "FaChangeBillEditUI");
        validator.setParam(params);
        FaCurCardInfo verifyBill = (FaCurCardInfo)faCardInfo;
        if (faCardInfo instanceof FaMonCardInfo) {
            verifyBill = FaManageUtils.MonCard2CurCard((FaMonCardInfo)faCardInfo);
            verifyBill.setId(faCardInfo.getId());
        }
        validator.setBillInfo(verifyBill);
        if (!validator.validate()) {
            errorMsg.append(validator.getInvalidMsg());
        }
        if ((verifyBizStatus = this.verifyBizStatus(ctx, faCardInfo)).length() > 0) {
            errorMsg.append(verifyBizStatus);
        }
        if (errorMsg.length() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("1", errorMsg.toString()));
        }
    }

    protected void verifyInput(Context ctx, FaCurCardInfo faCurCardInfo, boolean isSubmit) throws BOSException, EASBizException {
        FaChangeBillInfo changeBillInfo;
        FaCurCardInfo oriCardInfo;
        String curCardID;
        HashMap hResult = this.gethmParam(ctx, faCurCardInfo.getCompany().getId());
        BigDecimal ZERO = new BigDecimal("0.00");
        StringBuffer errorMsg = new StringBuffer();
        Object isUseGroupNumber = hResult.get("FA_030");
        if (Boolean.parseBoolean(isUseGroupNumber.toString())) {
            FilterInfo f = new FilterInfo();
            f.getFilterItems().add(new FilterItemInfo("company.id", (Object)faCurCardInfo.getCompany().getId().toString()));
            if (faCurCardInfo.getId() != null && new FaCurCardInfo().getBOSType().equals((Object)faCurCardInfo.getId().getType())) {
                f.getFilterItems().add(new FilterItemInfo("id", (Object)faCurCardInfo.get("id").toString(), CompareType.NOTEQUALS));
            } else if (faCurCardInfo.get("changeBill") != null) {
                FaChangeBillInfo bill = (FaChangeBillInfo)faCurCardInfo.get("changeBill");
                curCardID = bill.getChangeBillEntry().get(0).getCurCard().getId().toString();
                f.getFilterItems().add(new FilterItemInfo("id", (Object)curCardID, CompareType.NOTEQUALS));
            }
            f.getFilterItems().add(new FilterItemInfo("groupNumber", (Object)faCurCardInfo.getGroupNumber()));
            boolean flag = FaCurCardFactory.getLocalInstance(ctx).exists(f);
            if (flag) {
                errorMsg.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"44_FaChangeBillEditUI"), faCurCardInfo.getGroupNumber()) + ";");
            }
        }
        if (hResult.get("FA_043") != null && "true".equals(hResult.get("FA_043").toString())) {
            FilterInfo f1 = new FilterInfo();
            f1.getFilterItems().add(new FilterItemInfo("company.id", (Object)faCurCardInfo.getCompany().getId().toString()));
            if (faCurCardInfo.getId() != null && new FaCurCardInfo().getBOSType().equals((Object)faCurCardInfo.getId().getType())) {
                f1.getFilterItems().add(new FilterItemInfo("id", (Object)faCurCardInfo.getId().toString(), CompareType.NOTEQUALS));
            } else if (faCurCardInfo.get("changeBill") != null) {
                FaChangeBillInfo bill = (FaChangeBillInfo)faCurCardInfo.get("changeBill");
                curCardID = bill.getChangeBillEntry().get(0).getCurCard().getId().toString();
                f1.getFilterItems().add(new FilterItemInfo("id", (Object)curCardID, CompareType.NOTEQUALS));
            }
            f1.getFilterItems().add(new FilterItemInfo("barCode", (Object)faCurCardInfo.getBarCode()));
            boolean flag1 = FaCurCardFactory.getLocalInstance(ctx).exists(f1);
            if (flag1) {
                errorMsg.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"47_FaChangeBillEditUI"), faCurCardInfo.getBarCode()) + ";");
            }
        }
        FaCurCardInfo faCurCardInfo2 = oriCardInfo = (changeBillInfo = (FaChangeBillInfo)faCurCardInfo.get("changeBill")) == null ? (FaCurCardInfo)faCurCardInfo.get("CHANGE_INFO_FOR_VERFY") : changeBillInfo.getChangeBillEntry().get(0).getCurCard();
        if (isSubmit) {
            boolean deprCountShoudLessThanUseCount;
            if (changeBillInfo.getChangeMode() == null && faCurCardInfo.get("changeMode") == null) {
                throw new EASBizException(new NumericExceptionSubItem("001", EASResource.getString((String)RESOURCE_PATH, (String)"FaChangeBillEditUI_ChangeModeIsNull")));
            }
            if (faCurCardInfo.get("changeDate") == null) {
                throw new EASBizException(new NumericExceptionSubItem("001", EASResource.getString((String)RESOURCE_PATH, (String)"FaChangeBillEditUI_ChangeDateIsNull")));
            }
            Date changeDate = (Date)faCurCardInfo.get("changeDate");
            Date accountDate = faCurCardInfo.getAccountDate();
            PeriodInfo aPeriodInfo = this.getCurrentPeriod(ctx);
            if (DateTimeUtils.dayBefore((Date)changeDate, (Date)accountDate)) {
                throw new EASBizException(new NumericExceptionSubItem("001", EASResource.getString((String)RESOURCE_PATH, (String)"FaChangeBillEditUI_ChangeDateBeforeAccountDate")));
            }
            if (aPeriodInfo != null && (DateTimeUtils.dayBefore((Date)changeDate, (Date)aPeriodInfo.getBeginDate()) || DateTimeUtils.dayAfter((Date)changeDate, (Date)aPeriodInfo.getEndDate()))) {
                throw new EASBizException(new NumericExceptionSubItem("001", EASResource.getString((String)RESOURCE_PATH, (String)"FaChangeBillEditUI_ChangeDateError")));
            }
            BigDecimal accuDepr = faCurCardInfo.getAccuDepr();
            BigDecimal assetValue = faCurCardInfo.getAssetValue();
            BigDecimal decValue = faCurCardInfo.getDecValue();
            if (assetValue.compareTo(oriCardInfo.getAssetValue()) != 0 && !this.isAccountEqual(faCurCardInfo.getAccountAsset(), oriCardInfo.getAccountAsset())) {
                errorMsg.append(EASResource.getString((String)RESOURCE_PATH, (String)"CantSynModifyAssetAcct") + ";");
            }
            if (accuDepr.compareTo(oriCardInfo.getAccuDepr()) != 0 && !this.isAccountEqual(faCurCardInfo.getAccountAccuDepr(), oriCardInfo.getAccountAccuDepr())) {
                errorMsg.append(EASResource.getString((String)RESOURCE_PATH, (String)"CantSynModifyAccuAcct") + ";");
            }
            if (decValue.compareTo(oriCardInfo.getDecValue()) != 0 && !this.isAccountEqual(faCurCardInfo.getAccountDecValue(), oriCardInfo.getAccountDecValue())) {
                errorMsg.append(EASResource.getString((String)RESOURCE_PATH, (String)"CantSynModifyDecAcct") + ";");
            }
            BigDecimal addUPDep = faCurCardInfo.getAccuDepr();
            BigDecimal useTermCount = faCurCardInfo.getUseTermCount();
            BigDecimal deprCount = faCurCardInfo.getDeprTermCount();
            if (addUPDep.compareTo(ZERO) == 0 && deprCount.compareTo(ZERO) != 0) {
                errorMsg.append(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"39_FaChangeBillEditUI") + ";");
            }
            if (addUPDep.compareTo(ZERO) != 0 && deprCount.compareTo(ZERO) == 0) {
                errorMsg.append(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"40_FaChangeBillEditUI") + ";");
            }
            boolean isStraightMethod = FaChangeBillControllerBean.isStraightAccountMethod(faCurCardInfo.getDeprMethod());
            boolean isAverageYearMethod = FaChangeBillControllerBean.isAveUsingOriginAgeMethod(faCurCardInfo.getDeprMethod());
            boolean FA_051On = false;
            if (hResult.get("FA_051") != null) {
                FA_051On = "true".equals(hResult.get("FA_051").toString());
            }
            boolean bl = deprCountShoudLessThanUseCount = !isStraightMethod && (!isAverageYearMethod || !FA_051On);
            if (deprCount.compareTo(useTermCount) > 0 && deprCountShoudLessThanUseCount) {
                errorMsg.append(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"48_FaChangeBillEditUI") + ";");
            }
            if (FaLocalUtils.isWorkLoadMethod((FaDepreciationModeInfo)faCurCardInfo.getDeprMethod())) {
                IFaWorkLoad iWorkLoad = FaWorkLoadFactory.getLocalInstance(ctx);
                EntityViewInfo view = new EntityViewInfo();
                view.getSelector().add(new SelectorItemInfo("*"));
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("period", (Object)this.curPeriod.getId(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("company", (Object)faCurCardInfo.getCompany().getId().toString(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("curCard.number", (Object)faCurCardInfo.getNumber(), CompareType.EQUALS));
                view.setFilter(filter);
                FaWorkLoadCollection workLoadCollection = iWorkLoad.getFaWorkLoadCollection(view);
                for (int n = 0; n < workLoadCollection.size(); ++n) {
                    BigDecimal deprTermCount;
                    FaWorkLoadInfo workLoad = workLoadCollection.get(n);
                    BigDecimal currentWorkLoad = workLoad.getCurrentWorkLoad() == null ? new BigDecimal("0") : workLoad.getCurrentWorkLoad();
                    BigDecimal totalWorkLoad = workLoad.getTotalWorkLoad() == null ? new BigDecimal("0") : workLoad.getTotalWorkLoad();
                    BigDecimal sumWorkLoad = workLoad.getSumWorkLoad() == null ? new BigDecimal("0") : workLoad.getSumWorkLoad();
                    BigDecimal lastWorkLoad = workLoad.getLastWorkLoad() == null ? new BigDecimal("0") : workLoad.getLastWorkLoad();
                    BigDecimal bigDecimal = deprTermCount = faCurCardInfo.getDeprTermCount() == null ? new BigDecimal("0") : faCurCardInfo.getDeprTermCount();
                    if (currentWorkLoad.compareTo(deprTermCount) <= 0) continue;
                    errorMsg.append("\u5df2\u4f7f\u7528\u5de5\u4f5c\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u8be5\u5361\u7247\u7ef4\u62a4\u7684\u5f53\u524d\u5de5\u4f5c\u91cf;");
                }
            }
        }
        if (errorMsg.length() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("404", errorMsg.toString()));
        }
    }

    protected HashMap gethmParam(Context ctx, BOSUuid id) {
        HashMap hmParam = new HashMap();
        try {
            hmParam = FaManageUtils.getFAParameter(id, ctx);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hmParam;
    }

    public static boolean isStraightAccountMethod(FaDepreciationModeInfo method) {
        if (method == null || method.getId() == null || method.getNumber() == null) {
            return false;
        }
        return method.getNumber().trim().equals("007");
    }

    public static boolean isAveUsingOriginAgeMethod(FaDepreciationModeInfo method) throws BOSException {
        if (method == null || method.getId() == null || method.getNumber() == null) {
            return false;
        }
        return method.getNumber().trim().equals("010");
    }

    private String verifyBizStatus(Context ctx, FaCardInfo faCardInfo) throws BOSException, EASBizException {
        if (faCardInfo == null || faCardInfo.getNumber() == null || faCardInfo.getCompany() == null) {
            return "";
        }
        String verifyBizStatusValue = "";
        FaCurCardInfo curCardInfo = FaCurCardFactory.getLocalInstance(ctx).getFaCurCardInfo("select id, number, bizStatus, checkedStatus, deletedStatus, hasDisabled, leaseStatus where number = '" + faCardInfo.getNumber() + "' and company.id = '" + faCardInfo.getCompany().getId().toString() + "'");
        FaBizStatusEnum faBizStatusEnum = curCardInfo.getBizStatus();
        if (faBizStatusEnum.getValue().endsWith("01") && FaBizStatusEnum.CHANGING != faBizStatusEnum) {
            verifyBizStatusValue = "\u5361\u7247\u7f16\u7801\uff1a" + faCardInfo.getNumber() + "\u5f53\u524d\u72b6\u6001\u4e3a\uff1a" + faBizStatusEnum.getAlias() + "\uff0c\u5361\u7247\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u505a\u53d8\u66f4 \n";
        }
        if (FaBizStatusEnum.HAVE_FULL_CLEANED == faBizStatusEnum) {
            verifyBizStatusValue = "\u5361\u7247\u7f16\u7801\uff1a" + faCardInfo.getNumber() + "\u5f53\u524d\u72b6\u6001\u4e3a\uff1a" + faBizStatusEnum.getAlias() + "\uff0c\u5361\u7247\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u505a\u53d8\u66f4 \n";
        }
        if (CheckedStatusEnum.UNAUDITED == curCardInfo.getCheckedStatus()) {
            verifyBizStatusValue = "\u5361\u7247\u7f16\u7801\uff1a" + faCardInfo.getNumber() + "\u5f53\u524d\u72b6\u6001\u4e3a\uff1a" + CheckedStatusEnum.UNAUDITED.getAlias() + "\uff0c\u5361\u7247\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u505a\u53d8\u66f4 \n";
        }
        if (curCardInfo.isHasDisabled() || DeletedStatusEnum.DELETED == curCardInfo.getDeletedStatus()) {
            verifyBizStatusValue = "\u5361\u7247\u7f16\u7801\uff1a" + faCardInfo.getNumber() + "\u5f53\u524d\u72b6\u6001\u4e3a\uff1a" + DeletedStatusEnum.DELETED.getAlias() + "\uff0c\u5361\u7247\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u505a\u53d8\u66f4 \n";
        }
        if (FaLeaseStatusEnum.WORKING_LEASE_OUT == curCardInfo.getLeaseStatus() || FaLeaseStatusEnum.FINANCE_LEASE_OUT == curCardInfo.getLeaseStatus()) {
            verifyBizStatusValue = faCardInfo.get("changeBill") != null && ((FaChangeBillInfo)faCardInfo.get("changeBill")).getSourceBillId() != null && BOSUuid.read((String)((FaChangeBillInfo)faCardInfo.get("changeBill")).getSourceBillId()).getType().equals((Object)new FaLeaseBillInfo().getBOSType()) ? "" : "\u5361\u7247\u7f16\u7801\uff1a" + faCardInfo.getNumber() + "\u5f53\u524d\u72b6\u6001\u4e3a\uff1a" + curCardInfo.getLeaseStatus().getAlias() + "\uff0c\u5361\u7247\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u505a\u53d8\u66f4 \n";
        }
        return verifyBizStatusValue;
    }

    protected void invokeServiceBefore(ServiceContext svcCtx) throws BOSException {
        FaRPCMethodMappingUtils.invokeRPCMethodEventListener(svcCtx, FaAppLogForBusinessTypeEnum.FA_CHANGE, FaMethodCalcOrderEnum.BEFORE);
        super.invokeServiceBefore(svcCtx);
    }

    protected void invokeServiceAfter(ServiceContext svcCtx) throws BOSException {
        FaRPCMethodMappingUtils.invokeRPCMethodEventListener(svcCtx, FaAppLogForBusinessTypeEnum.FA_CHANGE, FaMethodCalcOrderEnum.AFTER);
        super.invokeServiceAfter(svcCtx);
    }
}

