/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.base.wssc.app.BillImageFacadeControllerBean;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaCatInfo;
import com.kingdee.eas.fi.fa.facade.app.FaDAPClearBillStrategy;
import com.kingdee.eas.fi.fa.manage.FaAppLogForBusinessTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaBakCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBakCostCenterFactory;
import com.kingdee.eas.fi.fa.manage.FaBillBizProcessor;
import com.kingdee.eas.fi.fa.manage.FaBizCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBizCostCenterFactory;
import com.kingdee.eas.fi.fa.manage.FaBizStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaCardDAPVoucherSumCollection;
import com.kingdee.eas.fi.fa.manage.FaCardDAPVoucherSumFactory;
import com.kingdee.eas.fi.fa.manage.FaCardDAPVoucherSumInfo;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.FaCardInfo;
import com.kingdee.eas.fi.fa.manage.FaChangeStatusEnmu;
import com.kingdee.eas.fi.fa.manage.FaClearBillCollection;
import com.kingdee.eas.fi.fa.manage.FaClearBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaClearBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaClearBillException;
import com.kingdee.eas.fi.fa.manage.FaClearBillFactory;
import com.kingdee.eas.fi.fa.manage.FaClearBillInfo;
import com.kingdee.eas.fi.fa.manage.FaClearStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCostCenterFactory;
import com.kingdee.eas.fi.fa.manage.FaDepCalFacadeFactory;
import com.kingdee.eas.fi.fa.manage.FaDepreciationFactory;
import com.kingdee.eas.fi.fa.manage.FaLeaseStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaMonCardCollection;
import com.kingdee.eas.fi.fa.manage.FaMonCardFactory;
import com.kingdee.eas.fi.fa.manage.FaMonCardInfo;
import com.kingdee.eas.fi.fa.manage.IFaCurCard;
import com.kingdee.eas.fi.fa.manage.NoClearBillToVoucherException;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaClearBillControllerBean;
import com.kingdee.eas.fi.fa.manage.app.FaDepLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.FaLastPeriodChangeUtils;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.PrcFaClearStrategy;
import com.kingdee.eas.fi.fa.manage.app.PrcFaCoreManager;
import com.kingdee.eas.fi.fa.manage.app.falog.event.FaMethodCalcOrderEnum;
import com.kingdee.eas.fi.fa.manage.app.falog.utils.FaRPCMethodMappingUtils;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class FaClearBillControllerBean
extends AbstractFaClearBillControllerBean {
    protected HashMap hmParam;
    private CompanyOrgUnitInfo currCompany;
    protected boolean canShowProfit = false;
    private static final BigDecimal ZERO = new BigDecimal("0");
    private final int EXECUTE_SIZE = 5000;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.manage.app.FaClearBillControllerBean");

    protected boolean _checkLineExist(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return super._checkLineExist(ctx, pk);
    }

    protected SystemEnum _getOwnedSys(Context ctx) throws BOSException, EASBizException {
        return SystemEnum.FIXEDASSETS;
    }

    protected boolean _checkStatusValid(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(new PrcFaClearStrategy());
        prcFaCoreManager.getFaManageStrategy().checkForEdit(ctx, model);
        return true;
    }

    @Override
    public IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        FaClearBillInfo changeBillInfo = (FaClearBillInfo)super._getValue(ctx, pk, this.getClearBillSelectors(selector));
        if (changeBillInfo.getClearBillEntry() != null && changeBillInfo.getClearBillEntry().size() > 0) {
            for (int i = 0; i < changeBillInfo.getClearBillEntry().size(); ++i) {
                if (changeBillInfo.getClearBillEntry().get(i) == null || changeBillInfo.getClearBillEntry().get(i).getCurCard() == null) continue;
                changeBillInfo.getClearBillEntry().get(i).put("faCurCard", changeBillInfo.getClearBillEntry().get(i).getCurCard().getId().toString());
            }
        }
        return changeBillInfo;
    }

    @Override
    protected IObjectCollection _getCollection(Context ctx, IServiceContext svcCtx, EntityViewInfo view) throws BOSException {
        view.getSelector().addObjectCollection((IObjectCollection)this.getClearBillSelectors(new SelectorItemCollection()));
        return super._getCollection(ctx, svcCtx, view);
    }

    private SelectorItemCollection getClearBillSelectors(SelectorItemCollection curCardSelectors) {
        SelectorItemCollection sic = new SelectorItemCollection();
        for (int i = 0; i < curCardSelectors.size(); ++i) {
            sic.add(curCardSelectors.get(i));
        }
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("clearBillEntry.*"));
        sic.add(new SelectorItemInfo("clearBillEntry.bizCard.id"));
        sic.add(new SelectorItemInfo("clearBillEntry.curCard.id"));
        sic.add(new SelectorItemInfo("clearBillEntry.curCard.accuDepr"));
        sic.add(new SelectorItemInfo("clearBillEntry.curCard.hasNew"));
        sic.add(new SelectorItemInfo("clearBillEntry.curCard.assetAmt"));
        sic.add(new SelectorItemInfo("clearBillEntry.curCard.deprTTerm"));
        sic.add(new SelectorItemInfo("clearBillEntry.curCard.evalDeprTTerm"));
        sic.add(new SelectorItemInfo("clearBillEntry.curCard.fiVouchered"));
        sic.add(new SelectorItemInfo("clearBillEntry.bizCard.number"));
        sic.add(new SelectorItemInfo("clearBillEntry.bizCard.assetCat.id"));
        sic.add(new SelectorItemInfo("clearBillEntry.bizCard.assetCat.prePureRate"));
        sic.add(new SelectorItemInfo("clearBillEntry.bizCard.company.id"));
        sic.add(new SelectorItemInfo("clearBillEntry.bizCard.faBakCard"));
        sic.add(new SelectorItemInfo("clearBillEntry.bizCard.faBakCard.assetAmt"));
        sic.add(new SelectorItemInfo("clearBillEntry.bizCard.faBakCard.lastEvalValue"));
        sic.add(new SelectorItemInfo("clearBillEntry.bizCard.faBakCard.initEvalValue"));
        return sic;
    }

    private SelectorItemCollection getCardSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("assetName"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("assetAmt"));
        sic.add(new SelectorItemInfo("propertyValue.*"));
        sic.add(new SelectorItemInfo("specs"));
        sic.add(new SelectorItemInfo("measureUnit.name"));
        sic.add(new SelectorItemInfo("assetValue"));
        sic.add(new SelectorItemInfo("accuDepr"));
        sic.add(new SelectorItemInfo("decValue"));
        sic.add(new SelectorItemInfo("accountDate"));
        sic.add(new SelectorItemInfo("deprTTerm"));
        sic.add(new SelectorItemInfo("hasNew"));
        sic.add(new SelectorItemInfo("initEvalValue"));
        sic.add(new SelectorItemInfo("isEvaledBefore"));
        sic.add(new SelectorItemInfo("addons"));
        sic.add(new SelectorItemInfo("treatmentIncome"));
        sic.add(new SelectorItemInfo("barCode"));
        sic.add(new SelectorItemInfo("groupNumber"));
        sic.add(new SelectorItemInfo("assetCat.name"));
        sic.add(new SelectorItemInfo("assetCat.calcuByEvaluate"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.OldChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.TotalDeprChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.DevalueChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.LeaveValueChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.UsedLifeChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.DeprMethodChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.EvaluateChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.CostCenterChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.UseStatusChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.StartDeprTime"));
        return sic;
    }

    private FilterInfo getCardFilter(Set<String> idSet) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("effectedStatus", (Object)2));
        filter.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)2));
        filter.getFilterItems().add(new FilterItemInfo("blockedStatus", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)"%99", CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)"0399", CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("leaseStatus", (Object)1, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("leaseStatus", (Object)2, CompareType.NOTEQUALS));
        return filter;
    }

    protected boolean isNeedReDepr(FaCurCardInfo curCardInfo) {
        return curCardInfo.getAssetCat().getDepreciationPolicy().getStartDeprTime().getValue() != 0;
    }

    private void batchValidateCard(Context ctx, FaCurCardCollection cardCollection, FaClearBillInfo clearBill) throws BOSException, EASBizException {
        Date changeDate = clearBill.getClearDate();
        boolean isCheckDepVoucherOnce = false;
        for (int i = 0; i < cardCollection.size(); ++i) {
            FaCurCardInfo info = cardCollection.get(i);
            Date accountDate = info.getAccountDate();
            if (accountDate != null && DateTimeUtils.dayBefore((Date)changeDate, (Date)accountDate)) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"165_FaClearBillControllerBean", (Locale)ctx.getLocale()) + "[" + DateTimeUtils.format((Date)accountDate, (String)"yyyy-MM-dd") + "]");
            }
            boolean isAlreadyDep = info.getDeprTTerm() != null && info.getDeprTTerm().compareTo(ZERO) != 0;
            boolean isHasNew = info.isHasNew();
            if (info.getDeprMethod() == null || isHasNew || !isAlreadyDep || this.isNeedReDepr(info)) continue;
            isCheckDepVoucherOnce = true;
        }
        if (isCheckDepVoucherOnce && this._isAlreadyDepVoucher(ctx)) {
            throw new FaClearBillException(FaClearBillException.HAS_GENERATED_VOUCHER);
        }
    }

    private IObjectPK addEntryAndSubmit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK iObjectPK;
        block20: {
            FaClearBillInfo clearBill;
            Connection conn;
            PreparedStatement pst;
            block18: {
                BOSUuid bakCardId;
                block19: {
                    pst = null;
                    conn = null;
                    String pk = model.get("id") == null ? null : model.get("id").toString();
                    FaBillBizProcessor.lockTable(ctx, pk);
                    clearBill = (FaClearBillInfo)model;
                    clearBill.setId(BOSUuid.create((BOSObjectType)new FaClearBillInfo().getBOSType()));
                    Set idSet = (Set)model.get("idSet");
                    HashMap<String, Map<String, String>> idsMap = new HashMap<String, Map<String, String>>();
                    HashMap<String, Integer> cardIdMap = new HashMap<String, Integer>();
                    Iterator iterator = idSet.iterator();
                    logger.error((Object)("--------277--------" + new Date()));
                    while (iterator.hasNext()) {
                        cardIdMap.put(iterator.next().toString(), 4);
                    }
                    logger.error((Object)("--------280--------" + new Date()));
                    String tempTableName = this.batchSave2TempTable(ctx, cardIdMap);
                    logger.error((Object)("--------281--------" + new Date()));
                    model.put("tempTable", (Object)tempTableName);
                    String inSql = FaLocalUtils.getFIDInTempTableSql(tempTableName);
                    model.put("inTempTable", (Object)inSql);
                    this.batchLockCurCard(ctx, inSql);
                    logger.error((Object)("--------285--------" + new Date()));
                    EntityViewInfo view = new EntityViewInfo();
                    view.getSelector().addObjectCollection((IObjectCollection)this.getCardSelectors());
                    view.setFilter(this.getCardFilter(idSet));
                    logger.error((Object)("------225-----:" + new Date()));
                    FaCurCardCollection cardCollection = FaCurCardFactory.getLocalInstance(ctx).getFaCurCardCollection(view);
                    logger.error((Object)("------292-----:" + new Date()));
                    if (cardCollection.size() == 0) {
                        throw new FaClearBillException(FaClearBillException.NO_BILL_TO_CLEAR);
                    }
                    this.batchValidateCard(ctx, cardCollection, clearBill);
                    if (cardCollection.size() < idSet.size()) {
                        TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
                        cardIdMap.clear();
                        for (int i = 0; i < cardCollection.size(); ++i) {
                            cardIdMap.put(cardCollection.get(i).getId().toString(), 4);
                        }
                        tempTableName = this.batchSave2TempTable(ctx, cardIdMap);
                        model.put("tempTable", (Object)tempTableName);
                        inSql = FaLocalUtils.getFIDInTempTableSql(tempTableName);
                        model.put("inTempTable", (Object)inSql);
                    }
                    logger.error((Object)("--------301--------" + new Date()));
                    conn = this.getConnection(ctx);
                    String insertSql = "insert into T_FA_ClearBillEntry (FID, FSeq, FClrQty, FClrOriginal, FClrAddupDep, FClrDecPrep, FClrFare, FSpilthMoveIn, FPrice, FSpilthIncome, FSplithDeal, FEntryID, FBizCardID, FCurCardID, FClrEvalValue ) values( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )";
                    pst = conn.prepareStatement(insertSql);
                    int j = 0;
                    for (int i = 0; i < cardCollection.size(); ++i) {
                        FaCurCardInfo faCurCardInfo = cardCollection.get(i);
                        BOSUuid entryId = BOSUuid.create((BOSObjectType)new FaClearBillEntryInfo().getBOSType());
                        bakCardId = BOSUuid.create((BOSObjectType)new FaBakCardInfo().getBOSType());
                        BOSUuid bizCardId = BOSUuid.create((BOSObjectType)new FaBizCardInfo().getBOSType());
                        BigDecimal curCardLocalAmount = faCurCardInfo.getAssetValue();
                        if (curCardLocalAmount == null) {
                            curCardLocalAmount = ZERO;
                        }
                        HashMap<String, String> bakBizMap = new HashMap<String, String>();
                        bakBizMap.put(bakCardId.toString(), bizCardId.toString());
                        idsMap.put(faCurCardInfo.getId().toString(), bakBizMap);
                        pst.clearParameters();
                        pst.setString(1, entryId.toString());
                        pst.setInt(2, i + 1);
                        pst.setBigDecimal(3, faCurCardInfo.getAssetAmt());
                        pst.setBigDecimal(4, curCardLocalAmount);
                        pst.setBigDecimal(5, faCurCardInfo.getAccuDepr());
                        pst.setBigDecimal(6, faCurCardInfo.getDecValue());
                        pst.setBigDecimal(7, ZERO);
                        pst.setBigDecimal(8, ZERO);
                        pst.setBigDecimal(9, ZERO);
                        pst.setBigDecimal(10, ZERO);
                        pst.setInt(11, -1);
                        pst.setString(12, clearBill.getId().toString());
                        pst.setString(13, bizCardId.toString());
                        pst.setString(14, faCurCardInfo.getId().toString());
                        pst.setBigDecimal(15, faCurCardInfo.getInitEvalValue());
                        pst.addBatch();
                        if (++j % 5000 != 0) continue;
                        pst.executeBatch();
                        pst.clearBatch();
                        j = 0;
                    }
                    if (j > 0) {
                        pst.executeBatch();
                    }
                    logger.error((Object)("--------370--------" + new Date()));
                    String idsTempTable = this.saveIds2TempTable(ctx, idsMap);
                    model.put("idsTempTable", (Object)idsTempTable);
                    logger.error((Object)("--------374--------" + new Date()));
                    StringBuffer bakSql = new StringBuffer();
                    bakSql.append(" INSERT INTO t_fa_fabakcard (fid, fcreatorid, fcreatetime, flastupdateuserid, flastupdatetime, fcontrolunitid, fnumber, fbizdate, fhandlerid, fdescription, fhaseffected, fauditorid, fsourcebillid, fsourcefunction,  ");
                    bakSql.append(" fcompanyid, fassetcatid, fassetname, fassetamt, fmeasureunitid, faccountdate, foriginmethodid, fusestatusid, feconomicpurpid, fstorecityid, fspecs, fparea, fmfr, flevfrdate, fpaperno, fdeptid, fkeeperid,");
                    bakSql.append(" forigintype, foriginunit, fremark, fcurrencyid, fexrate, foriginamt, fassetvalue, fbuyvalue, fbuyaccudepr, faddons, fdeliverdate, fstartusedate, fdeprtermcount, fusetermcount, fuseyears, faccudepr, faccudeprtyear,");
                    bakSql.append(" fneatremvalue, fdecvalue, fmeasureunitwlid, fneatvalue, fneatamt, fdeprmethodid, faccudeprchg, faccudepraccuchg, faccudepraccuclean, fdeprtterm, faccudeprchgtyear, faccudepraccuchgtyear, faccudepraccucleantyear, ");
                    bakSql.append(" faccudeprall, fdecvaluechg, fdecvalueaccuchg, faccountassetid, faccountaccudeprid, faccountdecvalueid, foriginflag, fhasdisabled, fbizstatus, fcheckedstatus, fdeletedstatus, feffectedstatus, fblockedstatus, ");
                    bakSql.append(" ffivouchered, fvoucher, fevalleftperiod, finitevalvalue, flastevalvalue, forigindif, foriginaccudif, fhaschanged, fhascleared, fhasevaled, fhasnew, fhassplited, fisneedredepr, fperiodid, flastbillid, fleftyear, ");
                    bakSql.append(" faccudeprforcal, fleftyearup, fdeprcount, flastperiodcount, fwelldeprvalue, ftempdeprmethod, ftempdeprtermcount, ftempusetermcount, fisinitchange, fisevaledbefore, fmonthdeprerate, fisoveraged, ffairvalue, ");
                    bakSql.append(" ftreatmentincome, fneatleftrate, faddonfare, fworkloadfordap, fdecvaluefordap, ffiaccountdate, fleasestatus, fevalreinaccountdate, fevaldeprperiodnum, fevaldeprmodeid, fevalmonthrate, fevaladddepr, fevalremvalue,");
                    bakSql.append(" fevalyeardepr, fevaldecvalue, fevalneatvalue, fevalneatamt, foldnumber, fevalassetvalue, fevaltaxleftperiod, fevalmeasureunitwl, fevalusetermcount, fevaldeprtterm, fevalneatleftrate, flastperiodchange, ");
                    bakSql.append(" flaterperioddata, fgroupnumberstatus, fgroupnumber, fvouchernumber, finputtax, fwrtyperiod, fwrtynumber, fleftyeartwo, fbarcode, fbarcodestatus, fisrequisitioned, fisborrowing, fabstract, fpropertyvalueid, ");
                    bakSql.append(" fcaldepstatus, ffacurcardid, fbilltype, fbakperiodid)");
                    bakSql.append(" SELECT temp.fbakid AS FID,card.fcreatorid ,");
                    bakSql.append(this.translate(new Date())).append(" FCREATETIME ,");
                    bakSql.append(" card.flastupdateuserid,card.flastupdatetime,card.fcontrolunitid,card.fnumber,card.fbizdate,card.fhandlerid,card.fdescription,card.fhaseffected,card.fauditorid,card.fsourcebillid,card.fsourcefunction,");
                    bakSql.append(" card.fcompanyid,card.fassetcatid,card.fassetname,card.fassetamt,card.fmeasureunitid,card.faccountdate,card.foriginmethodid,card.fusestatusid,card.feconomicpurpid,card.fstorecityid,card.fspecs,card.fparea,card.fmfr,");
                    bakSql.append(" card.flevfrdate,card.fpaperno,card.fdeptid,card.fkeeperid,card.forigintype,card.foriginunit,card.fremark,card.fcurrencyid,card.fexrate,card.foriginamt,card.fassetvalue,card.fbuyvalue,card.fbuyaccudepr,card.faddons,");
                    bakSql.append(" card.fdeliverdate,card.fstartusedate,card.fdeprtermcount,card.fusetermcount,card.fuseyears,card.faccudepr,card.faccudeprtyear,card.fneatremvalue,card.fdecvalue,card.fmeasureunitwlid,card.fneatvalue,card.fneatamt,");
                    bakSql.append(" card.fdeprmethodid,card.faccudeprchg,card.faccudepraccuchg,card.faccudepraccuclean,card.fdeprtterm,card.faccudeprchgtyear,card.faccudepraccuchgtyear,card.faccudepraccucleantyear,card.faccudeprall,card.fdecvaluechg,");
                    bakSql.append(" card.fdecvalueaccuchg,card.faccountassetid,card.faccountaccudeprid,card.faccountdecvalueid,card.foriginflag,card.fhasdisabled,card.fbizstatus,card.fcheckedstatus,card.fdeletedstatus,card.feffectedstatus,");
                    bakSql.append(" card.fblockedstatus,card.ffivouchered,card.fvoucher,card.fevalleftperiod,card.finitevalvalue,card.flastevalvalue,card.forigindif,card.foriginaccudif,card.fhaschanged,card.fhascleared,card.fhasevaled,card.fhasnew,");
                    bakSql.append(" card.fhassplited,card.fisneedredepr,card.fperiodid,card.flastbillid,card.fleftyear,card.faccudeprforcal,card.fleftyearup,card.fdeprcount,card.flastperiodcount,card.fwelldeprvalue,card.ftempdeprmethod,");
                    bakSql.append(" card.ftempdeprtermcount,card.ftempusetermcount,card.fisinitchange,card.fisevaledbefore,card.fmonthdeprerate,card.fisoveraged,card.ffairvalue,card.ftreatmentincome,card.fneatleftrate,card.faddonfare,");
                    bakSql.append(" card.fworkloadfordap,card.fdecvaluefordap,card.ffiaccountdate,card.fleasestatus,card.fevalreinaccountdate,card.fevaldeprperiodnum,card.fevaldeprmodeid,card.fevalmonthrate,card.fevaladddepr,");
                    bakSql.append(" card.fevalremvalue,card.fevalyeardepr,card.fevaldecvalue,card.fevalneatvalue,card.fevalneatamt,card.foldnumber,card.fevalassetvalue,card.fevaltaxleftperiod,card.fevalmeasureunitwl,card.fevalusetermcount,");
                    bakSql.append(" card.fevaldeprtterm,card.fevalneatleftrate,card.flastperiodchange,card.flaterperioddata,card.fgroupnumberstatus,card.fgroupnumber,card.fvouchernumber,card.finputtax,card.fwrtyperiod,card.fwrtynumber,");
                    bakSql.append(" card.fleftyeartwo,card.fbarcode,card.fbarcodestatus,card.fisrequisitioned,card.fisborrowing,card.fabstract,card.fpropertyvalueid,card.fcaldepstatus, card.fid AS FFACURCARDID, 4 FBILLTYPE, NULL FBAKPERIODID FROM ");
                    bakSql.append(" t_fa_facurcard card inner join ").append(idsTempTable).append(" temp on card.fid = temp.fid ");
                    DbUtil.execute((Context)ctx, (String)bakSql.toString());
                    logger.error((Object)("--------406--------" + new Date()));
                    StringBuffer bizSql = new StringBuffer();
                    bizSql.append(" INSERT INTO t_fa_fabizcard (fid, fcreatorid, fcreatetime, flastupdateuserid, flastupdatetime, fcontrolunitid, fnumber, fbizdate, fhandlerid, fdescription, fhaseffected, fauditorid, fsourcebillid,  ");
                    bizSql.append(" fsourcefunction, fcompanyid, fassetcatid, fassetname, fassetamt, fmeasureunitid, faccountdate, foriginmethodid, fusestatusid, feconomicpurpid, fstorecityid, fspecs, fparea, fmfr, flevfrdate, fpaperno, fdeptid,  ");
                    bizSql.append(" fkeeperid, forigintype, foriginunit, fremark, fcurrencyid, fexrate, foriginamt, fassetvalue, fbuyvalue, fbuyaccudepr, faddons, fdeliverdate, fstartusedate, fdeprtermcount, fusetermcount, fuseyears, faccudepr,  ");
                    bizSql.append(" faccudeprtyear, fneatremvalue, fdecvalue, fmeasureunitwlid, fneatvalue, fneatamt, fdeprmethodid, faccudeprchg, faccudepraccuchg, faccudepraccuclean, fdeprtterm, faccudeprchgtyear, faccudepraccuchgtyear,  ");
                    bizSql.append(" faccudepraccucleantyear, faccudeprall, fdecvaluechg, fdecvalueaccuchg, faccountassetid, faccountaccudeprid, faccountdecvalueid, foriginflag, fhasdisabled, fbizstatus, fcheckedstatus, fdeletedstatus,  ");
                    bizSql.append(" feffectedstatus, fblockedstatus, ffivouchered, fvoucher, fevalleftperiod, finitevalvalue, flastevalvalue, forigindif, foriginaccudif, fhaschanged, fhascleared, fhasevaled, fhasnew, fhassplited, fisneedredepr,  ");
                    bizSql.append(" fperiodid, flastbillid, fleftyear, faccudeprforcal, fleftyearup, fdeprcount, flastperiodcount, fwelldeprvalue, ftempdeprmethod, ftempdeprtermcount, ftempusetermcount, fisinitchange, fisevaledbefore,  ");
                    bizSql.append(" fmonthdeprerate, fisoveraged, ffairvalue, ftreatmentincome, fneatleftrate, faddonfare, fworkloadfordap, fdecvaluefordap, ffiaccountdate, fleasestatus, fevalreinaccountdate, fevaldeprperiodnum, fevaldeprmodeid,  ");
                    bizSql.append(" fevalmonthrate, fevaladddepr, fevalremvalue, fevalyeardepr, fevaldecvalue, fevalneatvalue, fevalneatamt, foldnumber, fevalassetvalue, fevaltaxleftperiod, fevalmeasureunitwl, fevalusetermcount, fevaldeprtterm,  ");
                    bizSql.append(" fevalneatleftrate, flastperiodchange, flaterperioddata, fgroupnumberstatus, fgroupnumber, fvouchernumber, finputtax, fwrtyperiod, fwrtynumber, fleftyeartwo, fbarcode, fbarcodestatus, fisrequisitioned,  ");
                    bizSql.append(" fisborrowing, fabstract, fpropertyvalueid, fcaldepstatus, ffabakcardid, fbilltype) ");
                    bizSql.append(" SELECT temp.fbizid AS FID,card.fcreatorid, ");
                    bizSql.append(this.translate(new Date())).append(" FCREATETIME ,");
                    bizSql.append(" card.flastupdateuserid,card.flastupdatetime,card.fcontrolunitid,card.fnumber,card.fbizdate,card.fhandlerid,card.fdescription,card.fhaseffected,card.fauditorid,card.fsourcebillid,card.fsourcefunction, ");
                    bizSql.append(" card.fcompanyid,card.fassetcatid,card.fassetname,card.fassetamt,card.fmeasureunitid,card.faccountdate,card.foriginmethodid,card.fusestatusid,card.feconomicpurpid,card.fstorecityid,card.fspecs,card.fparea, ");
                    bizSql.append(" card.fmfr,card.flevfrdate,card.fpaperno,card.fdeptid,card.fkeeperid,card.forigintype,card.foriginunit,card.fremark,card.fcurrencyid,card.fexrate,card.foriginamt,card.fassetvalue,card.fbuyvalue, ");
                    bizSql.append(" card.fbuyaccudepr,card.faddons,card.fdeliverdate,card.fstartusedate,card.fdeprtermcount,card.fusetermcount,card.fuseyears,card.faccudepr,card.faccudeprtyear,card.fneatremvalue,card.fdecvalue, ");
                    bizSql.append(" card.fmeasureunitwlid,card.fneatvalue,card.fneatamt,card.fdeprmethodid,card.faccudeprchg,card.faccudepraccuchg,card.faccudepraccuclean,card.fdeprtterm,card.faccudeprchgtyear,card.faccudepraccuchgtyear, ");
                    bizSql.append(" card.faccudepraccucleantyear,card.faccudeprall,card.fdecvaluechg,card.fdecvalueaccuchg,card.faccountassetid,card.faccountaccudeprid,card.faccountdecvalueid,card.foriginflag,card.fhasdisabled,card.fbizstatus, ");
                    bizSql.append(" card.fcheckedstatus,card.fdeletedstatus,card.feffectedstatus,card.fblockedstatus,card.ffivouchered,card.fvoucher,card.fevalleftperiod,card.finitevalvalue,card.flastevalvalue,card.forigindif,card.foriginaccudif, ");
                    bizSql.append(" card.fhaschanged,card.fhascleared,card.fhasevaled,card.fhasnew,card.fhassplited,card.fisneedredepr,card.fperiodid,card.flastbillid,card.fleftyear,card.faccudeprforcal,card.fleftyearup,card.fdeprcount, ");
                    bizSql.append(" card.flastperiodcount,card.fwelldeprvalue,card.ftempdeprmethod,card.ftempdeprtermcount,card.ftempusetermcount,card.fisinitchange,card.fisevaledbefore,card.fmonthdeprerate,card.fisoveraged,card.ffairvalue, ");
                    bizSql.append(" card.ftreatmentincome,card.fneatleftrate,card.faddonfare,card.fworkloadfordap,card.fdecvaluefordap,card.ffiaccountdate,card.fleasestatus,card.fevalreinaccountdate,card.fevaldeprperiodnum,card.fevaldeprmodeid, ");
                    bizSql.append(" card.fevalmonthrate,card.fevaladddepr,card.fevalremvalue,card.fevalyeardepr,card.fevaldecvalue,card.fevalneatvalue,card.fevalneatamt,card.foldnumber,card.fevalassetvalue,card.fevaltaxleftperiod, ");
                    bizSql.append(" card.fevalmeasureunitwl,card.fevalusetermcount,card.fevaldeprtterm,card.fevalneatleftrate,card.flastperiodchange,card.flaterperioddata,card.fgroupnumberstatus,card.fgroupnumber,card.fvouchernumber, ");
                    bizSql.append(" card.finputtax,card.fwrtyperiod,card.fwrtynumber,card.fleftyeartwo,card.fbarcode,card.fbarcodestatus,card.fisrequisitioned,card.fisborrowing,card.fabstract,card.fpropertyvalueid,card.fcaldepstatus,  ");
                    bizSql.append(" temp.fbakid AS FFABAKCARDID, 4 FBILLTYPE FROM t_fa_facurcard card inner join ").append(idsTempTable).append(" temp on card.fid = temp.fid ");
                    bizSql.append("  ");
                    DbUtil.execute((Context)ctx, (String)bizSql.toString());
                    logger.error((Object)("--------439--------" + new Date()));
                    if (model == null || !model.getBoolean("forDAP")) break block18;
                    bakCardId = this._submitSelf(ctx, model);
                    if (pst == null) break block19;
                    SQLUtils.cleanup((Statement)pst, (Connection)conn);
                }
                return bakCardId;
            }
            try {
                PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(new PrcFaClearStrategy());
                ObjectUuidPK clearBPk = null;
                if (clearBill.getId() != null && clearBill.getId().toString().length() > 0) {
                    clearBPk = new ObjectUuidPK(clearBill.getId());
                }
                if (clearBPk != null && !this._exists(ctx, (IObjectPK)clearBPk)) {
                    clearBPk = null;
                }
                if (clearBill != null && clearBill.getBOSUuid("id") != null && clearBPk != null) {
                    prcFaCoreManager.getFaManageStrategy().checkForEdit(ctx, (IObjectValue)clearBill);
                } else {
                    BillBaseInfo billBaseInfo = (BillBaseInfo)model;
                    if (billBaseInfo.getCompany() != null && billBaseInfo.getCompany().getId() != null) {
                        prcFaCoreManager.getFaManageStrategy().checkUnAuditFaDep(ctx, prcFaCoreManager.getFaManageStrategy().getCurrentPeriod(ctx, billBaseInfo), billBaseInfo.getCompany());
                    }
                    FaLocalUtils.verifyForLastestPeriod(ctx, (IObjectValue)billBaseInfo, 3);
                }
                iObjectPK = prcFaCoreManager.getFaManageStrategy().submitBill(ctx, model);
                if (pst == null) break block20;
            }
            catch (Exception e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (pst != null) {
                        SQLUtils.cleanup(pst, conn);
                    }
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)pst, (Connection)conn);
        }
        return iObjectPK;
    }

    private String translate(Date value) {
        return " TO_DATE('" + new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(value) + "') ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String companyId = this.getCurrentCompany(ctx).getId().toString();
        boolean isUseCalDepNew = FaManageUtils.getFaParamValue(ctx, "FA_201", companyId);
        if (isUseCalDepNew && model.get("idSet") != null) {
            try {
                IObjectPK iObjectPK = this.addEntryAndSubmit(ctx, model);
                return iObjectPK;
            }
            finally {
                if (model.get("tempTable") != null) {
                    String tempTable = model.getString("tempTable");
                    TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
                }
                if (model.get("idsTempTable") != null) {
                    String idsTempTable = model.getString("idsTempTable");
                    TempTablePool.getInstance((Context)ctx).releaseTable(idsTempTable);
                }
            }
        }
        String pk = model.get("id") == null ? null : model.get("id").toString();
        this.checkDepBeforeClear(ctx);
        FaBillBizProcessor.lockTable(ctx, pk);
        this.checkBeforeSubmit(ctx, model);
        if (model != null && model.getBoolean("forDAP")) {
            return this._submitSelf(ctx, model);
        }
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(new PrcFaClearStrategy());
        FaClearBillInfo clearBill = (FaClearBillInfo)model;
        ObjectUuidPK clearBPk = null;
        if (clearBill.getId() != null && clearBill.getId().toString().length() > 0) {
            clearBPk = new ObjectUuidPK(clearBill.getId());
        }
        if (clearBPk != null && !this._exists(ctx, (IObjectPK)clearBPk)) {
            clearBPk = null;
        }
        if (clearBill != null && clearBill.getBOSUuid("id") != null && clearBPk != null) {
            prcFaCoreManager.getFaManageStrategy().checkForEdit(ctx, (IObjectValue)clearBill);
        } else {
            BillBaseInfo billBaseInfo = (BillBaseInfo)model;
            if (billBaseInfo.getCompany() != null && billBaseInfo.getCompany().getId() != null) {
                prcFaCoreManager.getFaManageStrategy().checkUnAuditFaDep(ctx, prcFaCoreManager.getFaManageStrategy().getCurrentPeriod(ctx, billBaseInfo), billBaseInfo.getCompany());
            }
            FaLocalUtils.verifyForLastestPeriod(ctx, (IObjectValue)billBaseInfo, 3);
        }
        this.checkBeforeSubmitMoveBack(ctx, clearBill);
        return prcFaCoreManager.getFaManageStrategy().submitBill(ctx, model);
    }

    private void checkDepBeforeClear(Context ctx) throws BOSException, EASBizException {
        String companyId = this.getCurrentCompany(ctx).getId().toString();
        boolean isCheckDepBeforeClear = FaManageUtils.getFaParamValue(ctx, "FA_078", companyId);
        if (isCheckDepBeforeClear) {
            String currentPeriodId = FaLocalUtils.getCurrentPeriod(ctx, companyId).getId().toString();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)currentPeriodId, CompareType.EQUALS));
            boolean isDep = FaDepreciationFactory.getLocalInstance(ctx).exists(filter);
            if (!isDep) {
                throw new FaClearBillException(new NumericExceptionSubItem("004", "CHECK_DEP_BEFORE_CLEAR"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        try {
            CompanyOrgUnitInfo comp = (CompanyOrgUnitInfo)model.get("company");
            this.setWorkflowServiceState(ctx, comp == null ? null : comp.getId().toString(), model.getId() == null ? null : model.getId().toString());
            IObjectPK iObjectPK = super.submit(ctx, model);
            return iObjectPK;
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String pk = model.get("id") == null ? null : model.get("id").toString();
        FaBillBizProcessor.lockTable(ctx, pk);
        this.checkBeforeSave(ctx, model);
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(new PrcFaClearStrategy());
        FaClearBillInfo clearBill = (FaClearBillInfo)model;
        if (clearBill != null && clearBill.getBOSUuid("id") != null) {
            prcFaCoreManager.getFaManageStrategy().checkForSave(ctx, (IObjectValue)clearBill);
        } else {
            BillBaseInfo billBaseInfo = (BillBaseInfo)model;
            if (billBaseInfo.getCompany() != null && billBaseInfo.getCompany().getId() != null) {
                prcFaCoreManager.getFaManageStrategy().checkUnAuditFaDep(ctx, prcFaCoreManager.getFaManageStrategy().getCurrentPeriod(ctx, billBaseInfo), billBaseInfo.getCompany());
            }
            FaLocalUtils.verifyForLastestPeriod(ctx, (IObjectValue)clearBill, 1);
        }
        return prcFaCoreManager.getFaManageStrategy().saveBill(ctx, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FaBillBizProcessor.lockTable(ctx, pk.toString());
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(new PrcFaClearStrategy());
        prcFaCoreManager.getFaManageStrategy().checkForDelete(ctx, pk);
        prcFaCoreManager.getFaManageStrategy().deleteBill(ctx, pk);
        new BillImageFacadeControllerBean().deleteRefInfoByBillID(ctx, pk.toString(), true, false, true);
    }

    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            this.setWorkflowServiceState(ctx, pk);
            super.delete(ctx, pk);
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    @Override
    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        FaClearBillInfo billInfo;
        FaBillBizProcessor.lockTable(ctx, pk.toString());
        if (model == null) {
            model = FaClearBillFactory.getLocalInstance(ctx).getFaClearBillInfo(pk, new SelectorItemCollection());
        }
        if ((billInfo = (FaClearBillInfo)model) == null) {
            throw new IllegalArgumentException();
        }
        SelectorItemCollection sicOfClearBill = new SelectorItemCollection();
        sicOfClearBill.add(new SelectorItemInfo("checkedStatus"));
        sicOfClearBill.add(new SelectorItemInfo("clearBillEntry.curCard.id"));
        sicOfClearBill.add(new SelectorItemInfo("clearBillEntry.curCard.assetAmt"));
        sicOfClearBill.add(new SelectorItemInfo("clearBillEntry.curCard.accuDepr"));
        sicOfClearBill.add(new SelectorItemInfo("clearBillEntry.curCard.lastEvalValue"));
        sicOfClearBill.add(new SelectorItemInfo("clearBillEntry.curCard.hasNew"));
        sicOfClearBill.add(new SelectorItemInfo("clearBillEntry.clrQty"));
        sicOfClearBill.add(new SelectorItemInfo("clearBillEntry.clrOriginal"));
        sicOfClearBill.add(new SelectorItemInfo("clearBillEntry.clrAddupDep"));
        sicOfClearBill.add(new SelectorItemInfo("clearBillEntry.clrDecPrep"));
        sicOfClearBill.add(new SelectorItemInfo("clearBillEntry.clrFare"));
        sicOfClearBill.add(new SelectorItemInfo("clearBillEntry.bizCard.id"));
        sicOfClearBill.add(new SelectorItemInfo("clearBillEntry.bizCard.number"));
        sicOfClearBill.add(new SelectorItemInfo("clearBillEntry.bizCard.assetCat.id"));
        sicOfClearBill.add(new SelectorItemInfo("clearBillEntry.bizCard.assetCat.prePureRate"));
        sicOfClearBill.add(new SelectorItemInfo("clearBillEntry.bizCard.company.id"));
        billInfo = FaClearBillFactory.getLocalInstance(ctx).getFaClearBillInfo((IObjectPK)new ObjectUuidPK(billInfo.getId()), sicOfClearBill);
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(new PrcFaClearStrategy());
        prcFaCoreManager.getFaManageStrategy().checkForAudit(ctx, pk);
        prcFaCoreManager.getFaManageStrategy().auditBill(ctx, (IObjectValue)billInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void passAudit(Context ctx, IObjectPK pk, BillBaseInfo model) throws BOSException, EASBizException {
        try {
            this.setWorkflowServiceState(ctx, pk);
            super.passAudit(ctx, pk, model);
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    @Override
    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        FaBillBizProcessor.lockTable(ctx, pk.toString());
        if (model == null) {
            model = FaClearBillFactory.getLocalInstance(ctx).getFaClearBillInfo(pk, new SelectorItemCollection());
        }
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(new PrcFaClearStrategy());
        prcFaCoreManager.getFaManageStrategy().checkForUnAudit(ctx, pk);
        prcFaCoreManager.getFaManageStrategy().unAuditBill(ctx, (IObjectValue)model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unpassAudit(Context ctx, IObjectPK pk, BillBaseInfo model) throws BOSException, EASBizException {
        try {
            this.setWorkflowServiceState(ctx, pk);
            super.unpassAudit(ctx, pk, model);
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    @Override
    public void _passAuditSelf(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        FaClearBillInfo billInfo = (FaClearBillInfo)model;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("checkedStatus"));
        selector.add(new SelectorItemInfo("auditor"));
        selector.add(new SelectorItemInfo("bizDate"));
        this.updatePartial(ctx, (CoreBaseInfo)billInfo, selector);
        FaLastPeriodChangeUtils.updateCardLastPeriodChange(ctx, ((FaClearBillInfo)model).getCompany().getId().toString(), pk.toString(), 4);
    }

    @Override
    public void _unpassAuditSelf(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        FaClearBillInfo billInfo = (FaClearBillInfo)model;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("checkedStatus"));
        selector.add(new SelectorItemInfo("auditor"));
        selector.add(new SelectorItemInfo("bizDate"));
        this.updatePartial(ctx, (CoreBaseInfo)billInfo, selector);
        FaLastPeriodChangeUtils.updateCardLastPeriodChange(ctx, ((FaClearBillInfo)model).getCompany().getId().toString(), pk.toString(), 5);
    }

    @Override
    public void _deleteSelf(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (!FaManageUtils.deleteBill(ctx, pk.toString())) {
            super._delete(ctx, pk);
        }
    }

    @Override
    public void _submitSelf(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    public IObjectPK _submitSelf(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._submit(ctx, model);
        FaLastPeriodChangeUtils.updateCardLastPeriodChange(ctx, ((FaClearBillInfo)model).getCompany().getId().toString(), pk.toString(), 3);
        return pk;
    }

    @Override
    public void _saveSelf(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    public IObjectPK _saveSelf(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._save(ctx, model);
        FaLastPeriodChangeUtils.updateCardLastPeriodChange(ctx, ((FaClearBillInfo)model).getCompany().getId().toString(), pk.toString(), 1);
        return pk;
    }

    @Override
    public void _deleteSelf(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
    }

    @Override
    protected boolean _isAlreadyDep(Context ctx) throws BOSException, EASBizException {
        return FaDepLocalUtils.ifAlreadyCal(ctx, FaDepLocalUtils.getCurrentPeriod(ctx));
    }

    @Override
    protected boolean _isAlreadyDepVoucher(Context ctx) throws BOSException, EASBizException {
        return FaDepLocalUtils.ifDepGenFV(ctx);
    }

    protected boolean _checkNumberDup(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        BillBaseInfo billBaseInfo = (BillBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)billBaseInfo.getString("number"), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (billBaseInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)billBaseInfo.getId().toString(), CompareType.NOTEQUALS));
        }
        if (billBaseInfo.getCompany() != null) {
            filter.getFilterItems().add(new FilterItemInfo("company", (Object)billBaseInfo.getCompany().getId().toString(), CompareType.EQUALS));
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            if (i != 0) {
                sb.append(" and #" + i);
                continue;
            }
            sb.append("#" + i);
        }
        filter.setMaskString(sb.toString());
        if (super._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{billBaseInfo.getString("number"), ""});
        }
        return true;
    }

    @Override
    protected IObjectPK _submitNoWorkFlow(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._submit(ctx, model);
    }

    protected DAPTransformResult _generateVoucher(Context ctx, IObjectCollection sourceBillCollection, IObjectPK botMappingPK) throws BOSException, EASBizException {
        DAPTransformResult dAPTransformResult;
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(new PrcFaClearStrategy());
        FaDAPClearBillStrategy dAPTransStrategy = new FaDAPClearBillStrategy();
        logger.error((Object)("---516----" + new Date()));
        int size = sourceBillCollection.size();
        for (int i = 0; i < size; ++i) {
            FaClearBillInfo info = (FaClearBillInfo)sourceBillCollection.getObject(i);
            if (info == null) continue;
            prcFaCoreManager.getFaManageStrategy().checkForOperate(ctx, info, 2);
            try {
                String sql = "select threadCount threadCount from t_fa_faThreadSize";
                IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql);
                int threadCount = 12;
                while (set.next()) {
                    threadCount = set.getInt("threadCount");
                }
                ExecutorService executor = Executors.newFixedThreadPool(threadCount);
                ArrayList<Future<String>> futureList = new ArrayList<Future<String>>();
                Future<String> future = null;
                for (int j = 0; j < info.getClearBillEntry().size(); ++j) {
                    FaClearBillEntryInfo entryInfo = info.getClearBillEntry().get(j);
                    InitCallable callable = new InitCallable(ctx, entryInfo);
                    future = executor.submit(callable);
                    futureList.add(future);
                }
                for (int x = 0; x < futureList.size(); ++x) {
                    ((Future)futureList.get(x)).get();
                }
                executor.shutdown();
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            sourceBillCollection.setObject(i, (IObjectValue)dAPTransStrategy.process4DAP((BillBaseInfo)info, ctx));
        }
        logger.error((Object)("---546----" + new Date()));
        sourceBillCollection = this.decideOnAssetVal(sourceBillCollection, ctx);
        HashSet<String> cardIdSet = new HashSet<String>();
        logger.error((Object)("---550----" + new Date()));
        this.getClearedFaCurCardIdSet(ctx, sourceBillCollection, cardIdSet);
        logger.error((Object)("---551----" + new Date()));
        String tempTableName = FaLocalUtils.batchSaveId2TempTable(ctx, cardIdSet);
        logger.error((Object)("-----tempTableName-----907:" + tempTableName));
        String accountIdTempTable = null;
        try {
            String inSql = null;
            if (cardIdSet.size() > 0) {
                inSql = FaLocalUtils.getFIDInTempTableSql(tempTableName);
            }
            FaClearBillInfo faClearBillInfo = (FaClearBillInfo)sourceBillCollection.getObject(0);
            logger.error((Object)("---552----" + new Date()));
            accountIdTempTable = this.insertFaCardSumData(ctx, faClearBillInfo, inSql);
            logger.error((Object)("---554----" + new Date()));
            FaCardDAPVoucherSumCollection cardSumCollection = this.getFaCardDAPVoucherSumInfo(ctx, faClearBillInfo);
            logger.error((Object)("---555----" + new Date()));
            faClearBillInfo.put("faClearBillSum", (Object)cardSumCollection);
            logger.error((Object)("---556----" + new Date()));
            logger.error((Object)("---557----" + new Date()));
            DAPTransformResult renturValue = super._generateVoucher(ctx, sourceBillCollection, botMappingPK);
            logger.error((Object)("---558----" + new Date()));
            dAPTransformResult = renturValue;
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                logger.error((Object)("-----tempTableName-----921:" + tempTableName));
                if (accountIdTempTable != null) {
                    TempTablePool.getInstance((Context)ctx).releaseTable(accountIdTempTable);
                    logger.error((Object)("-----accountIdTempTable-----924:" + accountIdTempTable));
                }
                if (tempTableName != null) {
                    TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
                    logger.error((Object)("-----tempTableName-----927:" + tempTableName));
                }
                throw throwable;
            }
        }
        logger.error((Object)("-----tempTableName-----921:" + tempTableName));
        if (accountIdTempTable != null) {
            TempTablePool.getInstance((Context)ctx).releaseTable(accountIdTempTable);
            logger.error((Object)("-----accountIdTempTable-----924:" + accountIdTempTable));
        }
        if (tempTableName != null) {
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
            logger.error((Object)("-----tempTableName-----927:" + tempTableName));
        }
        return dAPTransformResult;
    }

    private void getCardInfo(Context ctx, FaClearBillEntryInfo entryInfo) throws EASBizException, BOSException {
        if (entryInfo.getCurCard() != null) {
            String oql = "select id, seq, asstActLName, asstActItem.id, asstActType.id, accountView.id, remark, apportionScale, faCurCard.id, faCurAsstActComposit.id, faCurAsstActComposit.seq, faCurAsstActComposit.asstActType.id, faCurAsstActComposit.asstActItem.id, faCurAsstActComposit.faCurCostCenter.id where faCurCard.id='" + entryInfo.getCurCard().getId() + "'";
            entryInfo.getCurCard().put("faCurCostCenter", (Object)FaCurCostCenterFactory.getLocalInstance(ctx).getFaCurCostCenterCollection(oql));
            if (entryInfo.getBizCard() != null && entryInfo.getBizCard().getFaBakCard() != null) {
                oql = "select id, seq, asstActLName, asstActItem.id, asstActType.id, accountView.id, remark, apportionScale, faBizCard.id, faBizAsstActComposit.id, faBizAsstActComposit.seq, faBizAsstActComposit.asstActType.id, faBizAsstActComposit.asstActItem.id, faBizAsstActComposit.faBizCostCenter.id where faBizCard.id='" + entryInfo.getBizCard().getId() + "'";
                entryInfo.getBizCard().put("faBizCostCenter", (Object)FaBizCostCenterFactory.getLocalInstance(ctx).getFaBizCostCenterCollection(oql));
                oql = "select id, seq, asstActLName, asstActItem.id, asstActType.id, accountView.id, remark, apportionScale, faBakCard.id, faBakAsstActComposit.id, faBakAsstActComposit.seq, faBakAsstActComposit.asstActType.id, faBakAsstActComposit.asstActItem.id, faBakAsstActComposit.faBakCostCenter.id where faBakCard.id='" + entryInfo.getBizCard().getFaBakCard().getId() + "'";
                entryInfo.getBizCard().getFaBakCard().put("faBakCostCenter", (Object)FaBakCostCenterFactory.getLocalInstance(ctx).getFaBakCostCenterCollection(oql));
            }
        }
    }

    private IObjectCollection decideOnAssetVal(IObjectCollection sourceBillCollection, Context ctx) throws BOSException, EASBizException {
        HashSet<String> set = new HashSet<String>();
        logger.error((Object)("-----932-------:" + new Date()));
        for (int i = 0; i < sourceBillCollection.size(); ++i) {
            set.add(sourceBillCollection.getObject(i).get("id").toString());
        }
        CoreBillBaseCollection sorterSourceBillCollection = new CoreBillBaseCollection();
        EntityViewInfo v = new EntityViewInfo();
        v.getSelector().add(new SelectorItemInfo("id"));
        v.getSelector().add(new SelectorItemInfo("number"));
        FilterInfo f = new FilterInfo();
        v.setFilter(f);
        f.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("number"));
        v.setSorter(sorter);
        FaClearBillCollection clearCards = FaClearBillFactory.getLocalInstance(ctx).getFaClearBillCollection(v);
        logger.error((Object)("-----947-------:" + new Date()));
        FaCurCardInfo faCurCardInfo = null;
        FaCatInfo faCatInfo = null;
        IFaCurCard curCard = FaCurCardFactory.getLocalInstance(ctx);
        boolean canGenerate = true;
        Iterator iter = clearCards.iterator();
        block1: while (iter.hasNext()) {
            int i;
            FaClearBillInfo clearBillInfo = (FaClearBillInfo)iter.next();
            FaClearBillEntryCollection entrys = clearBillInfo.getClearBillEntry();
            logger.error((Object)("-----957-------:" + new Date()));
            Iterator entrysIter = entrys.iterator();
            while (entrysIter.hasNext()) {
                FaClearBillEntryInfo entryInfo = (FaClearBillEntryInfo)entrysIter.next();
                faCurCardInfo = (FaCurCardInfo)curCard.getValue("select assetValue,assetCat.calcuByEvaluate,isEvaledBefore where id='" + entryInfo.getCurCard().getId() + "'");
                BigDecimal assetVal = faCurCardInfo.getAssetValue();
                int compareRes = assetVal.compareTo(new BigDecimal("0.00"));
                faCatInfo = faCurCardInfo.getAssetCat();
                boolean isCalcuByEvaluate = faCatInfo.isCalcuByEvaluate();
                boolean isIsEvaledBefore = faCurCardInfo.isIsEvaledBefore();
                canGenerate = compareRes != 0 || isIsEvaledBefore && isCalcuByEvaluate;
                if (canGenerate) continue;
                entrysIter.remove();
            }
            logger.error((Object)("-----980-------:" + new Date()));
            if (entrys.size() == 0) {
                for (i = 0; i < sourceBillCollection.size(); ++i) {
                    if (!sourceBillCollection.getObject(i).get("id").toString().equals(clearBillInfo.getId().toString())) continue;
                    sourceBillCollection.removeObject(sourceBillCollection.getObject(i));
                    continue block1;
                }
                continue;
            }
            for (i = 0; i < sourceBillCollection.size(); ++i) {
                if (!sourceBillCollection.getObject(i).get("id").toString().equals(clearBillInfo.getId().toString())) continue;
                sorterSourceBillCollection.addObject(sourceBillCollection.getObject(i));
                continue block1;
            }
        }
        logger.error((Object)("-----999-------:" + new Date()));
        if (sourceBillCollection.size() == 0) {
            throw new NoClearBillToVoucherException(new NumericExceptionSubItem("001", "NO_CLEARBILL_TO_VOUCHER"));
        }
        return sorterSourceBillCollection;
    }

    protected HashMap gethmParam(Context ctx) throws BOSException, EASBizException {
        if (this.hmParam == null || this.hmParam.size() == 0) {
            this.hmParam = FaManageUtils.getFAParameter(this.getCurrentCompany(ctx).getId(), ctx);
        }
        return this.hmParam;
    }

    protected CompanyOrgUnitInfo getCurrentCompany(Context ctx) throws BOSException, EASBizException {
        if (this.currCompany == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            BOSUuid id = ContextUtil.getCurrentFIUnit((Context)ctx).getId();
            this.currCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(id), sic);
        }
        return this.currCompany;
    }

    protected void setWorkflowServiceState(Context ctx, IObjectPK objId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.id"));
        CompanyOrgUnitInfo comp = (CompanyOrgUnitInfo)this.getValue(ctx, objId, sic).get("company");
        this.setWorkflowServiceState(ctx, comp.getId().toString(), objId.toString());
    }

    protected void setWorkflowServiceState(Context ctx, String companyId, String objId) throws BOSException, EASBizException {
        boolean isUseWorkflow = FaManageUtils.isUseWorkflow(ctx, companyId, this.getClass());
        if (!isUseWorkflow && (objId == null || objId != null && !FaLocalUtils.isRunningWorkflow(ctx, objId))) {
            WfEventListenerStateManager.getInstance().disableEventListener();
        }
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        VoucherInfo voucher = FaLocalUtils.LookVoucherInfo(ctx, bOTRelationInfo);
        if (voucher != null && voucher.getId() != null) {
            if (bOTBillOperStateEnum == BOTBillOperStateEnum.ADDNEW) {
                DbUtil.execute((Context)ctx, (String)"update T_FA_ClearBill set FFiVouchered = 1, FVoucherID = ?, FVoucherNumber = ?, FAbstract = ? where fid = ?", (Object[])new Object[]{voucher.getId().toString(), voucher.getNumber(), voucher.getVoucherAbstract(), srcBillVO.get("id").toString()});
            } else if (bOTBillOperStateEnum == BOTBillOperStateEnum.EDIT) {
                DbUtil.execute((Context)ctx, (String)"update T_FA_ClearBill set FVoucherNumber = ?, FAbstract = ?  where fid = ?", (Object[])new Object[]{voucher.getNumber(), voucher.getVoucherAbstract(), srcBillVO.get("id").toString()});
            }
            if (bOTBillOperStateEnum == BOTBillOperStateEnum.DELETE) {
                DbUtil.execute((Context)ctx, (String)"update T_FA_ClearBill set FFiVouchered = 0 ,FVoucherID = null, FVoucherNumber = null, FAbstract = null where fid = ?", (Object[])new Object[]{srcBillVO.get("id").toString()});
            }
        } else {
            super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
        }
    }

    protected void checkBeforeSave(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaClearBillInfo clrBill = (FaClearBillInfo)model;
        FaClearBillEntryCollection clrEntries = clrBill.getClearBillEntry();
        int size = clrEntries.size();
        for (int i = 0; i < size; ++i) {
            FaClearBillEntryInfo clrEntry = clrEntries.get(i);
            String cardID = clrEntry.get("facurcard").toString();
            Timestamp lastUpdateTime = FaBillBizProcessor.lockCurCard(ctx, cardID);
            FaBillBizProcessor.checkFaCurCardVersion(ctx, cardID, lastUpdateTime);
        }
    }

    private void checkBeforeSubmit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaClearBillInfo clrBill = (FaClearBillInfo)model;
        FaClearBillEntryCollection clrEntries = clrBill.getClearBillEntry();
        int size = clrEntries.size();
        for (int i = 0; i < size; ++i) {
            FaClearBillEntryInfo clrEntry = clrEntries.get(i);
            String cardID = clrEntry.get("facurcard").toString();
            Timestamp lastUpdateTime = FaBillBizProcessor.lockCurCard(ctx, cardID);
            FaBillBizProcessor.checkFaCurCardVersion(ctx, cardID, lastUpdateTime);
        }
    }

    private String saveIds2TempTable(Context ctx, Map<String, Map<String, String>> idsMap) throws BOSException, EASBizException {
        String string;
        block8: {
            String tempTableName = null;
            PreparedStatement pst = null;
            Connection conn = null;
            try {
                conn = this.getConnection(ctx);
                String createTableSql = "create table t_temp_curBakBizIds ( FID varchar(44), FBakId varchar(44), FBizId varchar(44) )";
                tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(createTableSql);
                TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FID", false, false);
                TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FBakId", false, false);
                TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FBizId", false, false);
                String insertSql = "insert into " + tempTableName + " (FID, FBakId, FBizId) values( ?, ?, ? )";
                pst = conn.prepareStatement(insertSql);
                int j = 0;
                for (Map.Entry<String, Map<String, String>> entry : idsMap.entrySet()) {
                    String cardId = entry.getKey().toString();
                    String bakId = null;
                    String bizId = null;
                    Map<String, String> bakBizMap = entry.getValue();
                    Iterator<String> iterator = bakBizMap.keySet().iterator();
                    while (iterator.hasNext()) {
                        String key;
                        bakId = key = iterator.next();
                        bizId = bakBizMap.get(key);
                    }
                    pst.clearParameters();
                    pst.setString(1, cardId);
                    pst.setString(2, bakId);
                    pst.setString(3, bizId);
                    pst.addBatch();
                    if (++j % 5000 != 0) continue;
                    pst.executeBatch();
                    pst.clearBatch();
                    j = 0;
                }
                if (j > 0) {
                    pst.executeBatch();
                }
                string = tempTableName;
                if (pst == null) break block8;
            }
            catch (Exception e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (pst != null) {
                        SQLUtils.cleanup(pst, (Connection)conn);
                    }
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)pst, (Connection)conn);
        }
        return string;
    }

    protected void checkFaCurCardValid(Context ctx, FaCardInfo oldCard, FaCardInfo newCard) throws EASBizException, BOSException {
        if (newCard == null || oldCard == null) {
            throw new IllegalArgumentException();
        }
        this.checkFaCurCardValid(ctx, newCard);
        Timestamp oldDate = oldCard.getLastUpdateTime();
        Timestamp newDate = newCard.getLastUpdateTime();
        if (oldDate == null && newDate != null || oldDate == null && newDate != null || !((Date)oldDate).equals(newDate)) {
            throw new FaCardException(FaCardException.CARD_NOT_SYC, new String[]{newCard.getNumber() + "(" + newCard.getAssetName() + ")"});
        }
    }

    protected void checkFaCurCardValid(Context ctx, FaCardInfo curCard) throws EASBizException, BOSException {
        if (curCard == null) {
            throw new IllegalArgumentException();
        }
        if (curCard.getBizStatus() == null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)curCard.getId().toString()));
            view.setFilter(filter);
            view.getSelector().add(new SelectorItemInfo("bizStatus"));
            if (curCard instanceof FaCurCardInfo) {
                FaCurCardCollection infoCollection = FaCurCardFactory.getLocalInstance(ctx).getFaCurCardCollection(view);
                curCard.setBizStatus(FaBizStatusEnum.getEnum(infoCollection.get(0).get("bizstatus").toString()));
            } else if (curCard instanceof FaMonCardInfo) {
                FaMonCardCollection monCardCollection = FaMonCardFactory.getLocalInstance(ctx).getFaMonCardCollection(view);
                curCard.setBizStatus(FaBizStatusEnum.getEnum(monCardCollection.get(0).get("bizstatus").toString()));
            }
        }
        String strBizStatusAlias = curCard.getBizStatus().getAlias(ctx.getOriginLocale());
        String strBizStatusValue = curCard.getBizStatus().getValue();
        if (!(strBizStatusValue = strBizStatusValue.substring(2, 4)).equals(new String("99"))) {
            throw new FaCardException(FaCardException.CURCARD_NOTVALID, new String[]{curCard.getNumber() + "(" + curCard.getAssetName() + ") " + strBizStatusAlias});
        }
        if (FaLeaseStatusEnum.FINANCE_LEASE_OUT.equals((Object)curCard.getLeaseStatus()) || FaLeaseStatusEnum.WORKING_LEASE_OUT.equals((Object)curCard.getLeaseStatus())) {
            int leaseStatus = curCard.getLeaseStatus().getValue();
            throw new FaCardException(FaCardException.CARDHASLEASEOUT, new String[]{curCard.getNumber() + "(" + curCard.getAssetName() + ")", FaLeaseStatusEnum.getEnum(leaseStatus).getAlias(ctx.getOriginLocale())});
        }
    }

    private String batchSave2TempTable(Context ctx, Map<String, Integer> cardIdMap) throws BOSException, EASBizException {
        String string;
        block7: {
            String tempTableName = null;
            PreparedStatement pst = null;
            Connection conn = null;
            try {
                conn = this.getConnection(ctx);
                String createTableSql = "create table t_temp_batchIds ( FID varchar(44), FBillType INT )";
                tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(createTableSql);
                TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FID", false, false);
                String insertSql = "insert into " + tempTableName + " (FID, FBillType) values( ?, ? )";
                pst = conn.prepareStatement(insertSql);
                int j = 0;
                for (Map.Entry<String, Integer> entry : cardIdMap.entrySet()) {
                    String cardId = entry.getKey().toString();
                    int billType = entry.getValue();
                    pst.clearParameters();
                    pst.setString(1, cardId);
                    pst.setInt(2, billType);
                    pst.addBatch();
                    if (++j % 5000 != 0) continue;
                    pst.executeBatch();
                    pst.clearBatch();
                    j = 0;
                }
                if (j > 0) {
                    pst.executeBatch();
                }
                string = tempTableName;
                if (pst == null) break block7;
            }
            catch (Exception e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (pst != null) {
                        SQLUtils.cleanup(pst, (Connection)conn);
                    }
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)pst, (Connection)conn);
        }
        return string;
    }

    public static void lockCurCard(Context ctx, String fid) throws BOSException {
        try {
            DbUtil.execute((Context)ctx, (String)("update t_fa_facurcard set fcompanyid = fcompanyid where fid = '" + fid + "' "));
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void batchLockCurCard(Context ctx, String inSql) throws BOSException {
        try {
            DbUtil.execute((Context)ctx, (String)("update t_fa_facurcard set fcompanyid = fcompanyid where fid in " + inSql));
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void checkFaCurCardVersion(Context ctx, String pk, Timestamp updateTime) throws BOSException, EASBizException {
        if (pk == null || updateTime == null) {
            return;
        }
        String sql = "select fnumber, flastupdatetime from t_fa_facurcard where fid = ?";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{pk});
            while (rs.next()) {
                Timestamp time = rs.getTimestamp("flastupdatetime");
                if (time == null) continue;
                String number = rs.getString("fnumber");
                if (time.getTime() == updateTime.getTime()) continue;
                String faCardChanged = FaLocalUtils.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaCardResource", "FACARD_HASCHANGED");
                throw new EASBizException(new NumericExceptionSubItem("1", faCardChanged), (Object[])new String[]{number});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void getClearedFaCurCardIdSet(Context ctx, IObjectCollection sourceBillCollection, HashSet cardIdSet) {
        int size = sourceBillCollection.size();
        for (int i = 0; i < size; ++i) {
            FaClearBillInfo info = (FaClearBillInfo)sourceBillCollection.getObject(i);
            if (info == null) continue;
            for (int j = 0; j < info.getClearBillEntry().size(); ++j) {
                FaClearBillEntryInfo entryInfo = info.getClearBillEntry().get(j);
                if (entryInfo == null || entryInfo.getBizCard() == null) continue;
                cardIdSet.add(entryInfo.getBizCard().getId().toString());
            }
            info.put("faClearBillSum", null);
        }
    }

    private String insertFaCardSumData(Context ctx, FaClearBillInfo clearBillInfo, String inSql) throws BOSException, EASBizException {
        String accountIdTempTable = null;
        DbUtil.execute((Context)ctx, (String)("delete from t_fa_facarddapvouchersum where fclearbillid='" + clearBillInfo.getId().toString() + "'"));
        if (inSql != null) {
            String accountIdSetSql = "select FAccountAssetID as accountId from t_fa_fabizcard where fid in (" + inSql + ") union select FAccountAccuDeprID as accountId from t_fa_fabizcard where fid in (" + inSql + ") union select FAccountDecValueID as accountId from t_fa_fabizcard where fid in (" + inSql + ")  and FAccountDecValueID is not null ";
            IRowSet accountIdsRs = DbUtil.executeQuery((Context)ctx, (String)accountIdSetSql);
            logger.error((Object)("---1116----" + new Date()));
            HashSet<String> accountIdSet = new HashSet<String>();
            try {
                while (accountIdsRs.next()) {
                    accountIdSet.add(accountIdsRs.getString("accountId"));
                }
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage());
            }
            accountIdTempTable = FaLocalUtils.batchSaveId2TempTable_2(ctx, accountIdSet);
            logger.error((Object)("-----accountIdTempTable-----1535:" + accountIdTempTable));
            String accountIdInSql = FaLocalUtils.getFIDInTempTableSql(accountIdTempTable);
            HashMap accountMap = new HashMap();
            logger.error((Object)("---1127----" + new Date()));
            StringBuffer accountAsstSql = new StringBuffer();
            accountAsstSql.append("select accountview.fid, asstdetail.fasstacttypeID ");
            accountAsstSql.append("from T_BD_AccountView accountview inner join T_BD_AsstAccount asstaccount on accountview.fcaa = asstaccount.fid ");
            accountAsstSql.append("inner join T_BD_AsstActGroupDetail asstdetail on asstdetail.fasstaccountid = asstaccount.fid ");
            accountAsstSql.append("where accountview.fid in (");
            accountAsstSql.append(accountIdInSql);
            accountAsstSql.append(") ");
            accountAsstSql.append("order by accountview.fid");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)accountAsstSql.toString());
            logger.error((Object)("---1136----" + new Date()));
            String tempAccountViewId = "";
            try {
                while (rs.next()) {
                    String accountViewId = rs.getString("fid");
                    String asstActTypeId = rs.getString("fasstacttypeID");
                    if (!"".equals(tempAccountViewId.trim()) && accountViewId.equals(tempAccountViewId)) {
                        List oldList = (List)accountMap.get(accountViewId);
                        oldList.add(asstActTypeId);
                        continue;
                    }
                    ArrayList<String> newList = new ArrayList<String>();
                    newList.add(asstActTypeId);
                    accountMap.put(accountViewId, newList);
                    tempAccountViewId = accountViewId;
                }
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage());
            }
            logger.error((Object)("---1155----" + new Date()));
            List list = this.combineCardAssetItem(ctx, clearBillInfo, inSql, accountMap);
            CoreBaseCollection faCardSumCollection = new CoreBaseCollection();
            logger.error((Object)("---1159----" + new Date()));
            for (int count = 0; count < list.size(); ++count) {
                Map map = (Map)list.get(count);
                if (map == null || map.size() <= 0) continue;
                for (String key : map.keySet()) {
                    faCardSumCollection.add((CoreBaseInfo)((FaCardDAPVoucherSumInfo)map.get(key)));
                }
            }
            logger.error((Object)("---1169----" + new Date()));
            if (faCardSumCollection.size() > 0) {
                FaCardDAPVoucherSumFactory.getLocalInstance(ctx).save(faCardSumCollection);
            }
            logger.error((Object)("---1173----" + new Date()));
        }
        return accountIdTempTable;
    }

    private List combineCardAssetItem(Context ctx, FaClearBillInfo clearBillInfo, String cardIds, Map accountMap) throws BOSException, EASBizException {
        HashMap<String, FaCardDAPVoucherSumInfo> accoutAssetMap = new HashMap<String, FaCardDAPVoucherSumInfo>();
        HashMap<String, FaCardDAPVoucherSumInfo> accountAccuDeprMap = new HashMap<String, FaCardDAPVoucherSumInfo>();
        HashMap<String, FaCardDAPVoucherSumInfo> accountDecMap = new HashMap<String, FaCardDAPVoucherSumInfo>();
        int scal = 4;
        CompanyOrgUnitInfo companyInfo = clearBillInfo.getCompany();
        if (companyInfo.getBaseCurrency() != null) {
            scal = FaManageUtils.getCurrencyScale(companyInfo.getBaseCurrency().getId(), ctx);
        } else {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("baseCurrency.id"));
            sic.add(new SelectorItemInfo("baseCurrency.precision"));
            companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId()), sic);
            scal = companyInfo != null ? companyInfo.getBaseCurrency().getPrecision() : 4;
        }
        logger.error((Object)("---1207----" + new Date()));
        try {
            String isUseProfit;
            HashMap hmResult = FaManageUtils.getFAParameter(ctx, new String[]{"GL_111"}, clearBillInfo.getCompany().getId().toString());
            String string = isUseProfit = hmResult != null && hmResult.get("GL_111") != null ? (String)hmResult.get("GL_111") : "false";
            if ("true".equalsIgnoreCase(isUseProfit)) {
                this.canShowProfit = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select tempSum.* from (");
        if (!this.canShowProfit) {
            sql.append(this.getAccountViewDistributeSQL(1, scal, cardIds));
            sql.append(" union all\n");
            sql.append(this.getAccountViewDistributeSQL(2, scal, cardIds));
            sql.append(" union all\n");
            sql.append(this.getAccountViewDistributeSQL(3, scal, cardIds));
        } else {
            sql.append(this.getAccountViewDistributeSQL1(1, scal, cardIds));
            sql.append(" union all\n");
            sql.append(this.getAccountViewDistributeSQL1(2, scal, cardIds));
            sql.append(" union all\n");
            sql.append(this.getAccountViewDistributeSQL1(3, scal, cardIds));
        }
        sql.append(") as tempSum ");
        sql.append("order by tempSum.FAccountAssetID, tempSum.FAccountAccuDeprID, tempSum.FAccountDecValueID, tempSum.costcenterid, ");
        sql.append("  tempSum.fseq, tempSum.fasstacttype, tempSum.fasstactitem");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        logger.error((Object)("---1221----" + new Date()));
        String tempCostcenterId = "";
        String tempAccountAssetId = "";
        String tempAccountAccuDeprId = "";
        String tempAccountDecValueId = "";
        String tempAccountViewId = "";
        StringBuffer tempasstAct = new StringBuffer();
        StringBuffer tempdeprAct = new StringBuffer();
        StringBuffer tempdecAct = new StringBuffer();
        BigDecimal tempAmount = FaManageUtils.zero;
        String tempProfitcenterId = "";
        try {
            while (rowSet.next()) {
                FaCardDAPVoucherSumInfo decCardSumInfo;
                FaCardDAPVoucherSumInfo oldFaCardDecSumInfo;
                FaCardDAPVoucherSumInfo deprCardSumInfo;
                FaCardDAPVoucherSumInfo oldFaCardDeprSumInfo;
                ProfitCenterOrgUnitInfo profit;
                FaCardDAPVoucherSumInfo assetCardSumInfo;
                FaCardDAPVoucherSumInfo oldFaCardAsstSumInfo;
                String costcenterId = rowSet.getString("costcenterid");
                String accountAssetId = rowSet.getString("FAccountAssetID");
                String accountAccuDeprId = rowSet.getString("FAccountAccuDeprID");
                String accountDecValueId = rowSet.getString("FAccountDecValueID");
                String AccountViewId = accountAssetId + accountAccuDeprId + accountDecValueId;
                String asstacttypeId = rowSet.getString("fasstacttype");
                String asstactitemId = rowSet.getString("fasstactitem");
                String profitCenter = "";
                if (this.canShowProfit) {
                    profitCenter = rowSet.getString("profitcenter");
                }
                if (!("".equals(tempCostcenterId.trim()) || "".equals(tempAccountViewId.trim()) || AccountViewId.equals(tempAccountViewId) && (!AccountViewId.equals(tempAccountViewId) || costcenterId.equals(tempCostcenterId)))) {
                    if (tempAccountAssetId != null && !"".equals(tempAccountAssetId)) {
                        if (accoutAssetMap.get(tempAccountAssetId + tempasstAct + tempProfitcenterId) != null) {
                            oldFaCardAsstSumInfo = (FaCardDAPVoucherSumInfo)accoutAssetMap.get(tempAccountAssetId + tempasstAct + tempProfitcenterId);
                            oldFaCardAsstSumInfo.setAsstAmount(oldFaCardAsstSumInfo.getAsstAmount().add(tempAmount));
                        } else {
                            assetCardSumInfo = new FaCardDAPVoucherSumInfo();
                            assetCardSumInfo.setClearBill(clearBillInfo);
                            AccountViewInfo assetViewInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)tempAccountAssetId)));
                            assetCardSumInfo.setAccuAssetAcct(assetViewInfo);
                            assetCardSumInfo.setAsstItem(tempasstAct.toString());
                            assetCardSumInfo.setAsstAmount(tempAmount);
                            if (this.canShowProfit && tempProfitcenterId != null && !"".equals(tempProfitcenterId)) {
                                profit = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)tempProfitcenterId)));
                                assetCardSumInfo.setProfitCenter(profit);
                            }
                            accoutAssetMap.put(tempAccountAssetId + tempasstAct + tempProfitcenterId, assetCardSumInfo);
                        }
                    }
                    if (tempAccountAccuDeprId != null && !"".equals(tempAccountAccuDeprId)) {
                        if (accountAccuDeprMap.get(tempAccountAccuDeprId + tempdeprAct + tempProfitcenterId) != null) {
                            oldFaCardDeprSumInfo = (FaCardDAPVoucherSumInfo)accountAccuDeprMap.get(tempAccountAccuDeprId + tempdeprAct + tempProfitcenterId);
                            oldFaCardDeprSumInfo.setDeprAmount(oldFaCardDeprSumInfo.getDeprAmount().add(tempAmount));
                        } else {
                            deprCardSumInfo = new FaCardDAPVoucherSumInfo();
                            deprCardSumInfo.setClearBill(clearBillInfo);
                            AccountViewInfo deprViewInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)tempAccountAccuDeprId)));
                            deprCardSumInfo.setAccuDeprAcct(deprViewInfo);
                            deprCardSumInfo.setDeprAmount(tempAmount);
                            deprCardSumInfo.setAsstItem(tempdeprAct.toString());
                            if (tempProfitcenterId != null && !"".equals(tempProfitcenterId)) {
                                profit = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)tempProfitcenterId)));
                                deprCardSumInfo.setProfitCenter(profit);
                            }
                            accountAccuDeprMap.put(tempAccountAccuDeprId + tempdeprAct + tempProfitcenterId, deprCardSumInfo);
                        }
                    }
                    if (tempAccountDecValueId != null && !"".equals(tempAccountDecValueId)) {
                        if (accountDecMap.get(tempAccountDecValueId + tempdecAct + tempProfitcenterId) != null) {
                            oldFaCardDecSumInfo = (FaCardDAPVoucherSumInfo)accountDecMap.get(tempAccountDecValueId + tempdecAct + tempProfitcenterId);
                            oldFaCardDecSumInfo.setDecAmount(oldFaCardDecSumInfo.getDecAmount().add(tempAmount));
                        } else if (tempAccountDecValueId != null) {
                            decCardSumInfo = new FaCardDAPVoucherSumInfo();
                            decCardSumInfo.setClearBill(clearBillInfo);
                            AccountViewInfo decViewInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)tempAccountDecValueId)));
                            decCardSumInfo.setAccuDecAcct(decViewInfo);
                            decCardSumInfo.setDecAmount(tempAmount);
                            decCardSumInfo.setAsstItem(tempdecAct.toString());
                            if (tempProfitcenterId != null && !"".equals(tempProfitcenterId)) {
                                profit = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)tempProfitcenterId)));
                                decCardSumInfo.setProfitCenter(profit);
                            }
                            accountDecMap.put(tempAccountDecValueId + tempdecAct + tempProfitcenterId, decCardSumInfo);
                        }
                    }
                    tempasstAct = new StringBuffer();
                    tempdeprAct = new StringBuffer();
                    tempdecAct = new StringBuffer();
                    tempAmount = FaManageUtils.zero;
                    tempProfitcenterId = "";
                }
                if (accountMap.get(accountAssetId) != null) {
                    List assetAccountViewList = (List)accountMap.get(accountAssetId);
                    for (int j = 0; j < assetAccountViewList.size(); ++j) {
                        if (asstacttypeId == null || !asstacttypeId.equals(assetAccountViewList.get(j))) continue;
                        tempasstAct.append(asstacttypeId);
                        tempasstAct.append("::");
                        tempasstAct.append(asstactitemId);
                        tempasstAct.append(";;");
                        break;
                    }
                }
                if (accountMap.get(accountAccuDeprId) != null) {
                    List deprAccountViewList = (List)accountMap.get(accountAccuDeprId);
                    for (int k = 0; k < deprAccountViewList.size(); ++k) {
                        if (asstacttypeId == null || !asstacttypeId.equals(deprAccountViewList.get(k))) continue;
                        tempdeprAct.append(asstacttypeId);
                        tempdeprAct.append("::");
                        tempdeprAct.append(asstactitemId);
                        tempdeprAct.append(";;");
                        break;
                    }
                }
                if (accountDecValueId != null && accountMap.get(accountDecValueId) != null) {
                    List decAccountViewList = (List)accountMap.get(accountDecValueId);
                    for (int n = 0; n < decAccountViewList.size(); ++n) {
                        if (asstacttypeId == null || !asstacttypeId.equals(decAccountViewList.get(n))) continue;
                        tempdecAct.append(asstacttypeId);
                        tempdecAct.append("::");
                        tempdecAct.append(asstactitemId);
                        tempdecAct.append(";;");
                        break;
                    }
                }
                tempCostcenterId = costcenterId;
                tempAccountAssetId = accountAssetId;
                tempAccountAccuDeprId = accountAccuDeprId;
                tempAccountDecValueId = accountDecValueId;
                tempAccountViewId = accountAssetId + accountAccuDeprId + accountDecValueId;
                tempAmount = rowSet.getBigDecimal("amount");
                tempProfitcenterId = profitCenter;
                if (!rowSet.isLast()) continue;
                if (tempAccountAssetId != null && !"".equals(tempAccountAssetId)) {
                    if (accoutAssetMap.get(tempAccountAssetId + tempasstAct + tempProfitcenterId) != null) {
                        oldFaCardAsstSumInfo = (FaCardDAPVoucherSumInfo)accoutAssetMap.get(tempAccountAssetId + tempasstAct + tempProfitcenterId);
                        oldFaCardAsstSumInfo.setAsstAmount(oldFaCardAsstSumInfo.getAsstAmount().add(tempAmount));
                    } else {
                        assetCardSumInfo = new FaCardDAPVoucherSumInfo();
                        assetCardSumInfo.setClearBill(clearBillInfo);
                        AccountViewInfo assetViewInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)tempAccountAssetId)));
                        assetCardSumInfo.setAccuAssetAcct(assetViewInfo);
                        assetCardSumInfo.setAsstItem(tempasstAct.toString());
                        assetCardSumInfo.setAsstAmount(tempAmount);
                        if (tempProfitcenterId != null && !"".equals(tempProfitcenterId)) {
                            profit = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)tempProfitcenterId)));
                            assetCardSumInfo.setProfitCenter(profit);
                        }
                        accoutAssetMap.put(tempAccountAssetId + tempasstAct + tempProfitcenterId, assetCardSumInfo);
                    }
                }
                if (tempAccountAccuDeprId != null && !"".equals(tempAccountAccuDeprId)) {
                    if (accountAccuDeprMap.get(tempAccountAccuDeprId + tempdeprAct + tempProfitcenterId) != null) {
                        oldFaCardDeprSumInfo = (FaCardDAPVoucherSumInfo)accountAccuDeprMap.get(tempAccountAccuDeprId + tempdeprAct + tempProfitcenterId);
                        oldFaCardDeprSumInfo.setDeprAmount(oldFaCardDeprSumInfo.getDeprAmount().add(tempAmount));
                    } else {
                        deprCardSumInfo = new FaCardDAPVoucherSumInfo();
                        deprCardSumInfo.setClearBill(clearBillInfo);
                        AccountViewInfo deprViewInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)tempAccountAccuDeprId)));
                        deprCardSumInfo.setAccuDeprAcct(deprViewInfo);
                        deprCardSumInfo.setDeprAmount(tempAmount);
                        deprCardSumInfo.setAsstItem(tempdeprAct.toString());
                        if (tempProfitcenterId != null && !"".equals(tempProfitcenterId)) {
                            profit = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)tempProfitcenterId)));
                            deprCardSumInfo.setProfitCenter(profit);
                        }
                        accountAccuDeprMap.put(tempAccountAccuDeprId + tempdeprAct + tempProfitcenterId, deprCardSumInfo);
                    }
                }
                if (tempAccountDecValueId == null || "".equals(tempAccountDecValueId)) continue;
                if (accountDecMap.get(tempAccountDecValueId + tempdecAct + tempProfitcenterId) != null) {
                    oldFaCardDecSumInfo = (FaCardDAPVoucherSumInfo)accountDecMap.get(tempAccountDecValueId + tempdecAct + tempProfitcenterId);
                    oldFaCardDecSumInfo.setDecAmount(oldFaCardDecSumInfo.getDecAmount().add(tempAmount));
                    continue;
                }
                if (tempAccountDecValueId == null) continue;
                decCardSumInfo = new FaCardDAPVoucherSumInfo();
                decCardSumInfo.setClearBill(clearBillInfo);
                AccountViewInfo decViewInfo = null;
                decViewInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)tempAccountDecValueId)));
                decCardSumInfo.setAccuDecAcct(decViewInfo);
                decCardSumInfo.setDecAmount(tempAmount);
                decCardSumInfo.setAsstItem(tempdecAct.toString());
                if (tempProfitcenterId != null && !"".equals(tempProfitcenterId)) {
                    profit = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)tempProfitcenterId)));
                    decCardSumInfo.setProfitCenter(profit);
                }
                accountDecMap.put(tempAccountDecValueId + tempdecAct + tempProfitcenterId, decCardSumInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        ArrayList<HashMap<String, FaCardDAPVoucherSumInfo>> list = new ArrayList<HashMap<String, FaCardDAPVoucherSumInfo>>();
        list.add(accoutAssetMap);
        list.add(accountAccuDeprMap);
        list.add(accountDecMap);
        return list;
    }

    private StringBuffer getAccountViewDistributeSQL1(int accType, int baseCurPrecision, String cardIds) {
        StringBuffer result = new StringBuffer();
        String accountAssetID = "''";
        String accountAccuDeprID = "''";
        String accountDecValueID = "''";
        String amountValue = "";
        String groupAccountID = "";
        if (accType == 1) {
            accountAssetID = "card.FAccountAssetID";
            amountValue = "FClrOriginal";
            groupAccountID = accountAssetID;
        } else if (accType == 2) {
            accountAccuDeprID = "card.FAccountAccuDeprID";
            amountValue = "FClrAddupDep";
            groupAccountID = accountAccuDeprID;
        } else {
            accountDecValueID = "card.FAccountDecValueID";
            amountValue = "FClrDecPrep";
            groupAccountID = accountDecValueID;
        }
        result.append("SELECT card.fid AS fid,\n");
        result.append(accountAssetID + " AS FAccountAssetID,\n");
        result.append(accountAccuDeprID + " AS FAccountAccuDeprID,\n");
        result.append(accountDecValueID + " AS FAccountDecValueID,\n");
        result.append("costcenter.fseq AS fseq, \n");
        result.append("costcenter.faccountviewid AS accountview,\n");
        result.append("costcenter.FPROFITCENTERID AS profitcenter,\n");
        result.append("costcenter.fapportionscale AS fapportionscale,\n");
        result.append("costcenter.fid AS costcenterid,\n");
        result.append("composit.fasstacttype AS fasstacttype,\n");
        result.append("composit.fasstactitem AS fasstactitem,\n");
        result.append("\t\t\t   CASE\n");
        result.append("               WHEN (   x.countseq * x.maxscale = 100 AND costcenter.fseq = x.minseq\n");
        result.append("                     OR (x.countseq * x.maxscale != 100) AND (costcenter.fapportionscale = x.maxscale AND costcenter.fseq = x.minseqofmaxscale) \n");
        result.append("                    )\n");
        result.append("                  THEN ROUND (costcenter.fapportionscale * clearentry." + amountValue + " / 100, " + baseCurPrecision + ") + tempoffset.toffset\n");
        result.append("              ELSE ROUND (costcenter.fapportionscale * clearentry." + amountValue + " / 100, " + baseCurPrecision + ")\n");
        result.append("            END AS amount \n");
        result.append(" FROM t_fa_fabizcard card\n");
        result.append("INNER JOIN t_fa_clearbillentry clearentry ON clearentry.fbizcardid = card.fid\n");
        result.append("INNER JOIN t_fa_fabizcostcenter costcenter ON costcenter.ffabizcardid = card.fid\n");
        result.append("LEFT OUTER JOIN t_fa_fabizasstactcomposit composit on composit.FFaBizCostCenterID = costcenter.fid\n");
        result.append("INNER JOIN (\n");
        result.append("            SELECT   MIN (center.fseq) AS minseqofmaxscale, center.ffabizcardid AS ffabizcardid, tmpcenter.MAX AS maxscale, tmpcenter.MIN AS minseq,\n");
        result.append("                     tmpcenter.countseq AS countseq\n");
        result.append("                FROM t_fa_fabizcostcenter center INNER JOIN (SELECT   MAX (fapportionscale) AS MAX, MIN (fseq) AS MIN, ffabizcardid AS cardid,\n");
        result.append("                                                                      COUNT (fseq) AS countseq\n");
        result.append("                                                                 FROM t_fa_fabizcostcenter\n");
        result.append("                                                             GROUP BY ffabizcardid) tmpcenter ON center.ffabizcardid = tmpcenter.cardid\n");
        result.append("               WHERE center.fapportionscale = tmpcenter.MAX\n");
        result.append("                 AND center.ffabizcardid in (" + cardIds + ")\n");
        result.append("            GROUP BY center.ffabizcardid, tmpcenter.MAX, tmpcenter.MIN, tmpcenter.countseq\n");
        result.append("            ) x ON x.ffabizcardid = card.fid\n");
        result.append("INNER JOIN (" + this.getSumEntryAmount(amountValue, baseCurPrecision, cardIds) + ") tempoffset ON tempoffset.bizcardid = card.fid\n");
        result.append("WHERE card.fid in (" + cardIds + ")\n");
        result.append("GROUP BY card.fid, " + groupAccountID + ", \n");
        result.append(" clearentry." + amountValue + ", costcenter.faccountviewid, costcenter.FPROFITCENTERID, costcenter.fseq,\n");
        result.append(" costcenter.fapportionscale, costcenter.fid, composit.fasstacttype, composit.fasstactitem, \n");
        result.append(" tempoffset.toffset, x.countseq, x.maxscale, x.minseqofmaxscale, x.minseq\n");
        return result;
    }

    private StringBuffer getAccountViewDistributeSQL(int accType, int baseCurPrecision, String cardIds) {
        StringBuffer result = new StringBuffer();
        String accountAssetID = "''";
        String accountAccuDeprID = "''";
        String accountDecValueID = "''";
        String amountValue = "";
        String groupAccountID = "";
        if (accType == 1) {
            accountAssetID = "card.FAccountAssetID";
            amountValue = "FClrOriginal";
            groupAccountID = accountAssetID;
        } else if (accType == 2) {
            accountAccuDeprID = "card.FAccountAccuDeprID";
            amountValue = "FClrAddupDep";
            groupAccountID = accountAccuDeprID;
        } else {
            accountDecValueID = "card.FAccountDecValueID";
            amountValue = "FClrDecPrep";
            groupAccountID = accountDecValueID;
        }
        result.append("SELECT card.fid AS fid,\n");
        result.append(accountAssetID + " AS FAccountAssetID,\n");
        result.append(accountAccuDeprID + " AS FAccountAccuDeprID,\n");
        result.append(accountDecValueID + " AS FAccountDecValueID,\n");
        result.append("costcenter.fseq AS fseq, \n");
        result.append("costcenter.faccountviewid AS accountview,\n");
        result.append("costcenter.fapportionscale AS fapportionscale,\n");
        result.append("costcenter.fid AS costcenterid,\n");
        result.append("composit.fasstacttype AS fasstacttype,\n");
        result.append("composit.fasstactitem AS fasstactitem,\n");
        result.append("\t\t\t   CASE\n");
        result.append("               WHEN (   x.countseq * x.maxscale = 100 AND costcenter.fseq = x.minseq\n");
        result.append("                     OR (x.countseq * x.maxscale != 100) AND (costcenter.fapportionscale = x.maxscale AND costcenter.fseq = x.minseqofmaxscale) \n");
        result.append("                    )\n");
        result.append("                  THEN ROUND (costcenter.fapportionscale * clearentry." + amountValue + " / 100, " + baseCurPrecision + ") + tempoffset.toffset\n");
        result.append("              ELSE ROUND (costcenter.fapportionscale * clearentry." + amountValue + " / 100, " + baseCurPrecision + ")\n");
        result.append("            END AS amount \n");
        result.append(" FROM t_fa_fabizcard card\n");
        result.append("INNER JOIN t_fa_clearbillentry clearentry ON clearentry.fbizcardid = card.fid\n");
        result.append("INNER JOIN t_fa_fabizcostcenter costcenter ON costcenter.ffabizcardid = card.fid\n");
        result.append("LEFT OUTER JOIN t_fa_fabizasstactcomposit composit on composit.FFaBizCostCenterID = costcenter.fid\n");
        result.append("INNER JOIN (\n");
        result.append("            SELECT   MIN (center.fseq) AS minseqofmaxscale, center.ffabizcardid AS ffabizcardid, tmpcenter.MAX AS maxscale, tmpcenter.MIN AS minseq,\n");
        result.append("                     tmpcenter.countseq AS countseq\n");
        result.append("                FROM t_fa_fabizcostcenter center INNER JOIN (SELECT   MAX (fapportionscale) AS MAX, MIN (fseq) AS MIN, ffabizcardid AS cardid,\n");
        result.append("                                                                      COUNT (fseq) AS countseq\n");
        result.append("                                                                 FROM t_fa_fabizcostcenter\n");
        result.append("                                                             GROUP BY ffabizcardid) tmpcenter ON center.ffabizcardid = tmpcenter.cardid\n");
        result.append("               WHERE center.fapportionscale = tmpcenter.MAX\n");
        result.append("                 AND center.ffabizcardid in (" + cardIds + ")\n");
        result.append("            GROUP BY center.ffabizcardid, tmpcenter.MAX, tmpcenter.MIN, tmpcenter.countseq\n");
        result.append("            ) x ON x.ffabizcardid = card.fid\n");
        result.append("INNER JOIN (" + this.getSumEntryAmount(amountValue, baseCurPrecision, cardIds) + ") tempoffset ON tempoffset.bizcardid = card.fid\n");
        result.append("WHERE card.fid in (" + cardIds + ")\n");
        result.append("GROUP BY card.fid, " + groupAccountID + ", \n");
        result.append(" clearentry." + amountValue + ", costcenter.faccountviewid, costcenter.fseq,\n");
        result.append(" costcenter.fapportionscale, costcenter.fid, composit.fasstacttype, composit.fasstactitem, \n");
        result.append(" tempoffset.toffset, x.countseq, x.maxscale, x.minseqofmaxscale, x.minseq\n");
        return result;
    }

    private StringBuffer getSumEntryAmount(String amountValue, int baseCurPrecision, String cardIds) {
        StringBuffer result = new StringBuffer();
        result.append("SELECT\n");
        result.append("tempcal.fvalue - SUM (disamount) AS toffset,\n");
        result.append("tempcal.fvalue,\n");
        result.append("SUM (disamount) AS sumdisamount,\n");
        result.append("tempcal.ffabizcardid AS bizcardid\n");
        result.append("FROM (\n");
        result.append("SELECT entry." + amountValue + " AS fvalue, costcenter.fapportionscale,\n");
        result.append("ROUND (costcenter.fapportionscale * entry." + amountValue + " / 100, " + baseCurPrecision + ") AS disamount,\n");
        result.append("costcenter.ffabizcardid, costcenter.fseq\n");
        result.append("FROM t_fa_fabizcard card\n");
        result.append("INNER JOIN t_fa_clearbillentry entry ON entry.fbizcardid = card.fid\n");
        result.append("INNER JOIN t_fa_fabizcostcenter costcenter ON costcenter.ffabizcardid = card.fid\n");
        result.append("WHERE card.fid in (" + cardIds + ")\n");
        result.append(") tempcal\n");
        result.append("GROUP BY tempcal.ffabizcardid, tempcal.fvalue\n");
        return result;
    }

    protected FaCardDAPVoucherSumCollection getFaCardDAPVoucherSumInfo(Context ctx, FaClearBillInfo faClearBillInfo) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT vouchersum.FID AS FID,");
        sql.append(" vouchersum.FACCUASSETACCTID AS FACCUASSETACCTID,");
        sql.append(" vouchersum.FACCUDEPRACCTID AS FACCUDEPRACCTID,");
        sql.append(" vouchersum.FACCUDECACCTID AS FACCUDECACCTID,");
        sql.append(" vouchersum.FASSTITEM AS FASSTITEM,");
        sql.append(" isnull(vouchersum.FASSTAMOUNT, 0) AS FASSTAMOUNT,");
        sql.append(" isnull(vouchersum.FDEPRAMOUNT, 0) AS FDEPRAMOUNT,");
        sql.append(" isnull(vouchersum.FDECAMOUNT, 0) AS FDECAMOUNT,");
        sql.append(" vouchersum.FCLEARBILLID AS FCLEARBILLID ");
        sql.append("FROM T_FA_FACARDDAPVOUCHERSUM vouchersum ");
        sql.append("WHERE vouchersum.FCLEARBILLID = ?");
        Object[] sqlPara = new Object[]{faClearBillInfo.getId().toString()};
        FaCardDAPVoucherSumCollection cardSumCollection = new FaCardDAPVoucherSumCollection();
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])sqlPara);
            while (rowSet.next()) {
                FaCardDAPVoucherSumInfo voucherSumInfo = new FaCardDAPVoucherSumInfo();
                voucherSumInfo.setId(BOSUuid.read((String)rowSet.getString("FID")));
                String assetAcct = rowSet.getString("FACCUASSETACCTID");
                AccountViewInfo assetAcctInfo = new AccountViewInfo();
                if (assetAcct != null && !"".equals(assetAcct)) {
                    assetAcctInfo.setId(BOSUuid.read((String)assetAcct));
                } else {
                    assetAcctInfo = null;
                }
                voucherSumInfo.setAccuAssetAcct(assetAcctInfo);
                String accuDeprAcct = rowSet.getString("FACCUDEPRACCTID");
                AccountViewInfo accuDeprAcctInfo = new AccountViewInfo();
                if (accuDeprAcct != null && !"".equals(accuDeprAcct)) {
                    accuDeprAcctInfo.setId(BOSUuid.read((String)accuDeprAcct));
                } else {
                    accuDeprAcctInfo = null;
                }
                voucherSumInfo.setAccuDeprAcct(accuDeprAcctInfo);
                String decAcct = rowSet.getString("FACCUDECACCTID");
                AccountViewInfo decAcctInfo = new AccountViewInfo();
                if (decAcct != null && !"".equals(decAcct)) {
                    decAcctInfo.setId(BOSUuid.read((String)decAcct));
                } else {
                    decAcctInfo = null;
                }
                voucherSumInfo.setAccuDecAcct(decAcctInfo);
                voucherSumInfo.setAsstItem(rowSet.getString("FASSTITEM"));
                voucherSumInfo.setAsstAmount(rowSet.getBigDecimal("FASSTAMOUNT"));
                voucherSumInfo.setDeprAmount(rowSet.getBigDecimal("FDEPRAMOUNT"));
                voucherSumInfo.setDecAmount(rowSet.getBigDecimal("FDECAMOUNT"));
                String clearBillId = rowSet.getString("FCLEARBILLID");
                FaClearBillInfo clearInfo = new FaClearBillInfo();
                if (clearBillId != null && !"".equals(clearBillId)) {
                    clearInfo.setId(BOSUuid.read((String)clearBillId));
                }
                voucherSumInfo.setClearBill(clearInfo);
                cardSumCollection.add(voucherSumInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        return cardSumCollection;
    }

    @Override
    protected boolean _isAlreadyDepVoucher(Context ctx, String companyId) throws BOSException, EASBizException {
        return FaDepLocalUtils.ifDepGenFV(ctx, companyId);
    }

    private void checkForUseWorkFlow(Context ctx, FaClearBillInfo billInfo) throws FaCardException, EASBizException, BOSException {
        if (FaManageUtils.isUseWorkflow(ctx, billInfo.getCompany().getId().toString(), this.getClass())) {
            String msg = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"WORKFLOW_ENABLE", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{billInfo.getCompany().getName() + "\uff08" + billInfo.getCompany().getNumber() + "\uff09", billInfo.getNumber()});
            throw new EASBizException(new NumericExceptionSubItem("01", msg));
        }
    }

    private void checkAuditWithWorkFlow(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        FaClearBillInfo faClearBillInfo;
        if (model == null) {
            model = FaClearBillFactory.getLocalInstance(ctx).getFaClearBillInfo(pk, new SelectorItemCollection());
        }
        if ((faClearBillInfo = (FaClearBillInfo)model) == null) {
            throw new IllegalArgumentException();
        }
        SelectorItemCollection sicOfChangeBill = new SelectorItemCollection();
        sicOfChangeBill.add(new SelectorItemInfo("number"));
        sicOfChangeBill.add(new SelectorItemInfo("company.id"));
        sicOfChangeBill.add(new SelectorItemInfo("company.name"));
        sicOfChangeBill.add(new SelectorItemInfo("company.number"));
        faClearBillInfo = FaClearBillFactory.getLocalInstance(ctx).getFaClearBillInfo((IObjectPK)new ObjectUuidPK(faClearBillInfo.getId()), sicOfChangeBill);
        this.checkForUseWorkFlow(ctx, faClearBillInfo);
    }

    private void checkBeforeSubmitMoveBack(Context ctx, FaClearBillInfo clearBill) throws EASBizException, BOSException {
        if (clearBill.getClearMode() == null) {
            throw new EASBizException(new NumericExceptionSubItem("400", FaLocalUtils.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaCardResource", "FaClearBillEditUI_ClearModeIsNull")));
        }
        if (clearBill.getClearDate() == null) {
            throw new EASBizException(new NumericExceptionSubItem("400", FaLocalUtils.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaCardResource", "FaClearBillEditUI_ClearDateIsNull")));
        }
        Date clearDate = clearBill.getClearDate();
        PeriodInfo aPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)this.getCurrentCompany(ctx));
        if (aPeriodInfo != null && (DateTimeUtils.dayBefore((Date)clearDate, (Date)aPeriodInfo.getBeginDate()) || DateTimeUtils.dayAfter((Date)clearDate, (Date)aPeriodInfo.getEndDate()))) {
            throw new EASBizException(new NumericExceptionSubItem("400", FaLocalUtils.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaCardResource", "FaClearBillEditUI_ClearDateError")));
        }
        FaClearBillEntryCollection faClearBillEntryCollection = clearBill.getClearBillEntry();
        if (faClearBillEntryCollection != null && faClearBillEntryCollection.size() != 0) {
            String companyId = this.getCurrentCompany(ctx).getId().toString();
            String currentPeriodId = FaLocalUtils.getCurrentPeriod(ctx, companyId).getId().toString();
            int j = faClearBillEntryCollection.size();
            for (int i = 0; i < j; ++i) {
                boolean isNewNeedDepr;
                FaClearBillEntryInfo faClearBillEntryInfo = faClearBillEntryCollection.get(i);
                FaCurCardInfo curCardInfo = FaCurCardFactory.getLocalInstance(ctx).getFaCurCardInfo((IObjectPK)new ObjectUuidPK((String)faClearBillEntryInfo.get("facurcard")), this.getCurCardSelectors());
                String verifyBizStatus = this.verifyBizStatus(ctx, curCardInfo);
                if (verifyBizStatus.length() > 0) {
                    throw new EASBizException(new NumericExceptionSubItem("400", verifyBizStatus));
                }
                BigDecimal clrQty = faClearBillEntryInfo.getClrQty();
                if (clrQty == null || BigDecimal.ZERO.compareTo(clrQty) >= 0) {
                    throw new EASBizException(new NumericExceptionSubItem("400", "\u7f16\u7801\u4e3a\uff1a" + curCardInfo.getNumber() + "\u7684\u5361\u7247\u6e05\u7406\u8d44\u4ea7\u7684\u6e05\u7406\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0"));
                }
                if ((float)clrQty.intValue() != clrQty.floatValue() || clrQty.compareTo(curCardInfo.getAssetAmt()) > 0) {
                    throw new EASBizException(new NumericExceptionSubItem("400", "\u7f16\u7801\u4e3a\uff1a" + curCardInfo.getNumber() + "\u7684\u5361\u7247\u6e05\u7406\u8d44\u4ea7\u7684\u6570\u91cf\u5fc5\u987b\u662f\u6b63\u6574\u6570\uff0c\u4e14\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u88ab\u6e05\u7406\u5361\u7247\u7684\u8d44\u4ea7\u6570\u91cf"));
                }
                BigDecimal clrOriginal = faClearBillEntryInfo.getClrOriginal();
                if (clrOriginal == null || BigDecimal.ZERO.compareTo(clrOriginal) >= 0) {
                    throw new EASBizException(new NumericExceptionSubItem("400", "\u7f16\u7801\u4e3a\uff1a" + curCardInfo.getNumber() + "\u7684\u5361\u7247\u6e05\u7406\u8d44\u4ea7\u7684\u6e05\u7406\u539f\u503c\u5fc5\u987b\u5927\u4e8e0"));
                }
                BigDecimal clrFare = faClearBillEntryInfo.getClrFare();
                if (clrFare != null && BigDecimal.ZERO.compareTo(clrFare) > 0) {
                    throw new EASBizException(new NumericExceptionSubItem("400", "\u7f16\u7801\u4e3a\uff1a" + curCardInfo.getNumber() + "\u7684\u5361\u7247\u6e05\u7406\u8d44\u4ea7\u7684\u5f03\u7f6e\u8d39\u7528\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0"));
                }
                BigDecimal spilthMoveIn = faClearBillEntryInfo.getSpilthMoveIn();
                if (spilthMoveIn != null && BigDecimal.ZERO.compareTo(spilthMoveIn) > 0) {
                    throw new EASBizException(new NumericExceptionSubItem("400", "\u7f16\u7801\u4e3a\uff1a" + curCardInfo.getNumber() + "\u7684\u5361\u7247\u6e05\u7406\u8d44\u4ea7\u7684\u6b8b\u6599\u5165\u5e93\u6210\u672c\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0"));
                }
                BigDecimal price = faClearBillEntryInfo.getPrice();
                if (price != null && BigDecimal.ZERO.compareTo(price) > 0) {
                    throw new EASBizException(new NumericExceptionSubItem("400", "\u7f16\u7801\u4e3a\uff1a" + curCardInfo.getNumber() + "\u7684\u5361\u7247\u6e05\u7406\u8d44\u4ea7\u7684\u51fa\u552e\u91d1\u989d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0"));
                }
                BigDecimal spilthIncome = faClearBillEntryInfo.getSpilthIncome();
                if (spilthIncome != null && BigDecimal.ZERO.compareTo(spilthIncome) > 0) {
                    throw new EASBizException(new NumericExceptionSubItem("400", "\u7f16\u7801\u4e3a\uff1a" + curCardInfo.getNumber() + "\u7684\u5361\u7247\u6e05\u7406\u8d44\u4ea7\u7684\u6b8b\u6599\u6536\u5165\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0"));
                }
                if (clrOriginal.compareTo(curCardInfo.getAssetValue().multiply(clrQty).divide(curCardInfo.getAssetAmt(), curCardInfo.getCompany().getBaseCurrency().getPrecision(), 4)) != 0) {
                    throw new EASBizException(new NumericExceptionSubItem("400", "\u7f16\u7801\u4e3a\uff1a" + curCardInfo.getNumber() + "\u7684\u5361\u7247\u6e05\u7406\u8d44\u4ea7\u7684\u539f\u503c\u91d1\u989d\u5fc5\u987b\u7b49\u4e8e\u88ab\u6e05\u7406\u5361\u7247\u7684\u539f\u503c * \u88ab\u6e05\u7406\u6570\u91cf / \u6570\u91cf"));
                }
                boolean cellCanDoClear = true;
                try {
                    cellCanDoClear = FaClearBillControllerBean.checkDeprePolicy(curCardInfo, 0);
                }
                catch (Exception exception) {
                    throw new BOSException((Throwable)exception);
                }
                if (!cellCanDoClear && clrQty.compareTo(curCardInfo.getAssetAmt()) < 0) {
                    throw new EASBizException(new NumericExceptionSubItem("400", "\u7f16\u7801\u4e3a\uff1a" + curCardInfo.getNumber() + "\u7684\u5361\u7247" + FaLocalUtils.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaCardResource", "FaClearBillEditUI_CanNotPartClear")));
                }
                boolean isAlreadyDep = curCardInfo.getDeprTTerm().compareTo(ZERO) != 0 || curCardInfo.getEvalDeprTTerm() != null && curCardInfo.getEvalDeprTTerm().compareTo(ZERO) != 0;
                boolean isHasNew = curCardInfo.isHasNew();
                boolean isneed = this.isNeedReDepr(curCardInfo) && curCardInfo.getDeprMethod() != null && curCardInfo.getDeprMethod().getNumber().equalsIgnoreCase("002");
                BigDecimal accuDepr = curCardInfo.getAccuDepr();
                BigDecimal curCardAddUPDepForCacu = faClearBillEntryInfo.getClrAddupDep();
                BigDecimal calCardAddUPDepForCacu = curCardInfo.getAccuDepr();
                if ((!isHasNew || isneed && isHasNew) && curCardInfo.getDeprMethod() != null && !curCardInfo.getDeprMethod().getNumber().equals("006")) {
                    if (!isAlreadyDep && this.isNeedReDepr(curCardInfo)) {
                        HashMap map = FaDepCalFacadeFactory.getLocalInstance(ctx).calOneCardDep(curCardInfo.getId().toString());
                        BigDecimal prepareDeprTTerm = ZERO;
                        if (map != null && (BigDecimal)map.get(new Integer(1)) != null) {
                            prepareDeprTTerm = (BigDecimal)map.get(new Integer(1));
                        }
                        calCardAddUPDepForCacu = accuDepr.add(prepareDeprTTerm);
                    }
                    if (isAlreadyDep && this.isNeedReDepr(curCardInfo) && curCardInfo.isIsNeedReDepr()) {
                        throw new EASBizException(new NumericExceptionSubItem("400", "\u7f16\u7801\u4e3a\uff1a" + curCardInfo.getNumber() + "\u7684\u5361\u7247\u9700\u8981\u91cd\u63d0\u6298\u65e7\uff0c\u8bf7\u91cd\u63d0\u6298\u65e7\u540e\u8fdb\u884c\u6e05\u7406\uff01"));
                    }
                    if (isAlreadyDep && !this.isNeedReDepr(curCardInfo)) {
                        calCardAddUPDepForCacu = accuDepr.subtract(curCardInfo.getDeprTTerm() == null ? ZERO : curCardInfo.getDeprTTerm());
                    }
                }
                boolean bl = isNewNeedDepr = !this.isNeedReDepr(curCardInfo);
                if (isHasNew && isNewNeedDepr) {
                    calCardAddUPDepForCacu = accuDepr.subtract(curCardInfo.getDeprTTerm());
                }
                if (calCardAddUPDepForCacu != null && curCardAddUPDepForCacu.compareTo(calCardAddUPDepForCacu = calCardAddUPDepForCacu.multiply(clrQty).divide(curCardInfo.getAssetAmt(), curCardInfo.getCompany().getBaseCurrency().getPrecision(), 4)) != 0) {
                    throw new EASBizException(new NumericExceptionSubItem("400", "\u7f16\u7801\u4e3a\uff1a" + curCardInfo.getNumber() + "\u7684\u5361\u7247\u6e05\u7406\u6298\u65e7\u503c\u548c\u7cfb\u7edf\u8ba1\u7b97\u6e05\u7406\u7d2f\u8ba1\u503c\u4e0d\u5339\u914d\uff0c\u7cfb\u7edf\u8ba1\u7b97\u7684\u6e05\u7406\u7d2f\u8ba1\u6298\u65e7\u503c\u4e3a:" + calCardAddUPDepForCacu));
                }
                if (!isneed || !isAlreadyDep || !curCardInfo.isIsNeedReDepr()) continue;
                throw new EASBizException(new NumericExceptionSubItem("400", "\u7f16\u7801\u4e3a\uff1a" + curCardInfo.getNumber() + "\u7684\u5361\u7247\u9700\u8981\u91cd\u63d0\u6298\u65e7\uff0c\u8bf7\u91cd\u63d0\u6298\u65e7\u540e\u8fdb\u884c\u6e05\u7406\uff01"));
            }
        }
    }

    private SelectorItemCollection getCurCardSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("measureUnit.name"));
        sic.add(new SelectorItemInfo("assetCat.name"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.OldChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.TotalDeprChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.DevalueChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.LeaveValueChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.ChargeAccoutChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.UsedLifeChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.DeprMethodChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.EvaluateChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.CostCenterChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.UseStatusChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.TailDispose"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.StartDeprTime"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.DeprRule"));
        sic.add(new SelectorItemInfo("deprMethod.period"));
        sic.add(new SelectorItemInfo("deprMethod.isCustom"));
        sic.add(new SelectorItemInfo("deprMethod.depValuePolicy"));
        sic.add(new SelectorItemInfo("deprMethod.isWorkload"));
        sic.add(new SelectorItemInfo("deprMethod.id"));
        sic.add(new SelectorItemInfo("deprMethod.name"));
        sic.add(new SelectorItemInfo("deprMethod.number"));
        sic.add(new SelectorItemInfo("useStatus.isDepreciation"));
        sic.add(new SelectorItemInfo("assetCat.calcuByEvaluate"));
        sic.add(new SelectorItemInfo("evalDeprMode.period"));
        sic.add(new SelectorItemInfo("evalDeprMode.number"));
        sic.add(new SelectorItemInfo("evalDeprMode.name"));
        sic.add(new SelectorItemInfo("evalDeprMode.depValuePolicy"));
        sic.add(new SelectorItemInfo("evalDeprMode.isWorkload"));
        sic.add(new SelectorItemInfo("evalDeprMode.isCustom"));
        sic.add(new SelectorItemInfo("evalDeprMode.id"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.baseCurrency.precision"));
        return sic;
    }

    private String verifyBizStatus(Context ctx, FaCardInfo faCardInfo) throws BOSException, EASBizException {
        if (faCardInfo == null || faCardInfo.getId() == null) {
            return "";
        }
        String verifyBizStatusValue = "";
        FaCurCardInfo curCardInfo = FaCurCardFactory.getLocalInstance(ctx).getFaCurCardInfo("select id, number, bizStatus, checkedStatus, deletedStatus, hasDisabled, leaseStatus where id = '" + faCardInfo.getId().toString() + "'");
        FaBizStatusEnum faBizStatusEnum = curCardInfo.getBizStatus();
        if (faBizStatusEnum.getValue().endsWith("01") && FaBizStatusEnum.FULL_CLEANING != faBizStatusEnum && FaBizStatusEnum.PART_CLEANING != faBizStatusEnum) {
            verifyBizStatusValue = "\u5361\u7247\u7f16\u7801\uff1a" + faCardInfo.getNumber() + "\u5f53\u524d\u72b6\u6001\u4e3a\uff1a" + faBizStatusEnum.getAlias() + "\uff0c\u5361\u7247\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u505a\u6e05\u7406 \n";
        }
        if (FaBizStatusEnum.HAVE_FULL_CLEANED == faBizStatusEnum) {
            verifyBizStatusValue = "\u5361\u7247\u7f16\u7801\uff1a" + faCardInfo.getNumber() + "\u5f53\u524d\u72b6\u6001\u4e3a\uff1a" + faBizStatusEnum.getAlias() + "\uff0c\u5361\u7247\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u505a\u6e05\u7406 \n";
        }
        if (CheckedStatusEnum.UNAUDITED == curCardInfo.getCheckedStatus()) {
            verifyBizStatusValue = "\u5361\u7247\u7f16\u7801\uff1a" + faCardInfo.getNumber() + "\u5f53\u524d\u72b6\u6001\u4e3a\uff1a" + CheckedStatusEnum.UNAUDITED.getAlias() + "\uff0c\u5361\u7247\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u505a\u6e05\u7406 \n";
        }
        if (curCardInfo.isHasDisabled() || DeletedStatusEnum.DELETED == curCardInfo.getDeletedStatus()) {
            verifyBizStatusValue = "\u5361\u7247\u7f16\u7801\uff1a" + faCardInfo.getNumber() + "\u5f53\u524d\u72b6\u6001\u4e3a\uff1a" + DeletedStatusEnum.DELETED.getAlias() + "\uff0c\u5361\u7247\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u505a\u6e05\u7406 \n";
        }
        if (FaLeaseStatusEnum.WORKING_LEASE_OUT == curCardInfo.getLeaseStatus() || FaLeaseStatusEnum.FINANCE_LEASE_OUT == curCardInfo.getLeaseStatus()) {
            verifyBizStatusValue = "\u5361\u7247\u7f16\u7801\uff1a" + faCardInfo.getNumber() + "\u5f53\u524d\u72b6\u6001\u4e3a\uff1a" + curCardInfo.getLeaseStatus().getAlias() + "\uff0c\u5361\u7247\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u505a\u6e05\u7406 \n";
        }
        return verifyBizStatusValue;
    }

    public static boolean checkDeprePolicy(FaCurCardInfo curCard, int queryType) throws Exception {
        boolean policy;
        boolean result = false;
        boolean oldChange = curCard.getAssetCat().getDepreciationPolicy().isOldChange();
        boolean totalDeprChange = curCard.getAssetCat().getDepreciationPolicy().isTotalDeprChange();
        boolean devalueChange = curCard.getAssetCat().getDepreciationPolicy().isDevalueChange();
        boolean leaveValueChange = curCard.getAssetCat().getDepreciationPolicy().isLeaveValueChange();
        boolean usedLifeChange = curCard.getAssetCat().getDepreciationPolicy().isUsedLifeChange();
        boolean deprMethodChange = curCard.getAssetCat().getDepreciationPolicy().isDeprMethodChange();
        boolean evaluateChange = curCard.getAssetCat().getDepreciationPolicy().isEvaluateChange();
        boolean costCenterChange = curCard.getAssetCat().getDepreciationPolicy().isCostCenterChange();
        boolean useStatusChange = curCard.getAssetCat().getDepreciationPolicy().isUseStatusChange();
        boolean startDeprTime = curCard.getAssetCat().getDepreciationPolicy().getStartDeprTime().getValue() != 0;
        boolean hasChanged = curCard.getHasChanged() != FaChangeStatusEnmu.HasNotChanged;
        FaClearStatusEnum hasCleared = curCard.getHasCleared();
        boolean bl = policy = !oldChange && !totalDeprChange && !devalueChange && !leaveValueChange && !useStatusChange && !usedLifeChange && !deprMethodChange && !evaluateChange && !costCenterChange && startDeprTime;
        if (policy) {
            result = true;
        } else {
            if (queryType == 1) {
                boolean bl2 = result = hasCleared != FaClearStatusEnum.HasAllCleared;
            }
            if (queryType == 0) {
                result = !hasChanged;
            }
        }
        return result;
    }

    protected void invokeServiceBefore(ServiceContext svcCtx) throws BOSException {
        FaRPCMethodMappingUtils.invokeRPCMethodEventListener(svcCtx, FaAppLogForBusinessTypeEnum.FA_CLEAR, FaMethodCalcOrderEnum.BEFORE);
        super.invokeServiceBefore(svcCtx);
    }

    protected void invokeServiceAfter(ServiceContext svcCtx) throws BOSException {
        FaRPCMethodMappingUtils.invokeRPCMethodEventListener(svcCtx, FaAppLogForBusinessTypeEnum.FA_CLEAR, FaMethodCalcOrderEnum.AFTER);
        super.invokeServiceAfter(svcCtx);
    }

    class InitCallable
    implements Callable<String> {
        private Context ctx;
        private FaClearBillEntryInfo entryInfo;

        public InitCallable(Context ctx, FaClearBillEntryInfo entryInfo) {
            this.ctx = ctx;
            this.entryInfo = entryInfo;
        }

        @Override
        public String call() throws Exception {
            FaClearBillControllerBean.this.getCardInfo(this.ctx, this.entryInfo);
            return "success";
        }
    }
}

