/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.books.AcountSchemeFactory;
import com.kingdee.eas.fi.books.AcountSchemeInfo;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.fi.fa.manage.FaAppLogForBusinessTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaPeriodCloseFacadeFactory;
import com.kingdee.eas.fi.fa.manage.FaTransCardToBookException;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaCurInitFacadeControllerBean;
import com.kingdee.eas.fi.fa.manage.app.CardForMulBook;
import com.kingdee.eas.fi.fa.manage.app.FaLastPeriodChangeUtils;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.dataimp.FaDataImportUtils;
import com.kingdee.eas.fi.fa.manage.app.falog.event.FaMethodCalcOrderEnum;
import com.kingdee.eas.fi.fa.manage.app.falog.utils.FaRPCMethodMappingUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FaCurInitFacadeControllerBean
extends AbstractFaCurInitFacadeControllerBean {
    private static final long serialVersionUID = -1447959576032062973L;
    private static final Logger logger = Logger.getLogger(FaCurInitFacadeControllerBean.class);
    private PeriodInfo periodInfo = null;

    @Override
    protected boolean _finishInit(Context ctx) throws BOSException, EASBizException {
        FaDataImportUtils.verfyBeforeEndInit(ctx);
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        if (aCompanyOrgUnitInfo == null) {
            return false;
        }
        String strCompanyID = aCompanyOrgUnitInfo.getId().toString();
        this.periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
        String periodID = this.periodInfo.getId().toString();
        if (periodID == null) {
            return false;
        }
        this.checkMoncardBalance(ctx, strCompanyID, periodID);
        this.checkBooksPeriod(ctx, strCompanyID, periodID, false);
        FaLastPeriodChangeUtils.updateCardLastPeriodChange(ctx, strCompanyID);
        FaLocalUtils.deleteUseLessCurCard(strCompanyID, ctx, null);
        StringBuffer deleteSql = new StringBuffer();
        deleteSql.append(" delete from t_fa_fadepreciationentry where FLnkFaDepreEntry  \n");
        deleteSql.append(" in (select fid from t_fa_fadepreciation where fcompanyid='" + strCompanyID + "') \n");
        deleteSql.append(" and ffacurcardid not in (select fid from t_fa_facurcard where fcompanyid='" + strCompanyID + "') \n");
        DbUtil.execute((Context)ctx, (String)deleteSql.toString());
        String sql = "update T_FA_FaMonCard set FBizStatus = ? where ForiginFlag = ? and FCompanyID = ? and FFaPeriodID is null";
        Object[] params = new Object[]{"9999", new Integer(0), strCompanyID};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        String attchAssoBosType = new BoAttchAssoInfo().getBOSType().toString();
        sql = "INSERT INTO T_BAS_BoAttchAsso(FID, FBoID, FAssoType_L1, FAssoType_L2, FAssoType_L3, FAttachMentID, FAssoBusObjType) (SELECT distinct " + FaLocalUtils.newBosID(ctx, attchAssoBosType) + ", t2.FFaCurCardID, t1.Fassotype_L1, t1.Fassotype_L2,t1.Fassotype_L3, t1.FAttachmentID, t1.FAssoBusObjType  FROM T_BAS_BoAttchAsso t1, T_FA_FAMonCard t2 WHERE t1.FBoID = t2.FID AND t2.fperiodid is null AND t2.FCompanyID = ? and t2.FFaCurCardID not in (select distinct FBoID from T_BAS_BoAttchAsso))";
        params = new String[]{strCompanyID};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        SystemStatusCtrolFactory.getLocalInstance((Context)ctx).start(SystemEnum.FIXEDASSETS, aCompanyOrgUnitInfo, true);
        return true;
    }

    private void checkMoncardBalance(Context ctx, String strCompanyID, String periodID) throws BOSException, EASBizException {
        String sql = new String();
        sql = "select fperiodid as faperiodid from t_fa_facurcard where fid in(select ffacurcardid from t_fa_famoncard where fcompanyid='" + strCompanyID + "' and fperiodid is null and fdeletedstatus = 1)";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        String prePeriodId = "";
        try {
            if (rowSet != null && rowSet.next()) {
                prePeriodId = rowSet.getString("faperiodid");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        if (prePeriodId != null && !"".equals(prePeriodId)) {
            PeriodInfo preStartPeriod = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)prePeriodId)));
            PeriodInfo curStartPeriod = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)periodID)));
            int compareResult = this.periodCompare(ctx, curStartPeriod, preStartPeriod);
            if (compareResult != 0) {
                throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"ChangesDuringOpening", (Locale)ctx.getOriginLocale())));
            }
        }
    }

    private void updateLastPeriodChangeCard(Context ctx, String companyId) throws EASBizException, BOSException {
        StringBuffer deleteAttachSql = new StringBuffer("");
        deleteAttachSql.append("delete from T_BAS_Attachment where fid in  ");
        deleteAttachSql.append("( select att.fid from T_BAS_Attachment att ");
        deleteAttachSql.append("inner join T_BAS_BoAttchAsso asso on att.fid = asso.FAttachmentID ");
        deleteAttachSql.append("inner join T_FA_FaMonCard mon on asso.FBoID = mon.ffacurCardId ");
        deleteAttachSql.append("where mon.fcompanyId = '" + companyId + "' and mon.FOriginFlag = 0 ");
        deleteAttachSql.append("and mon.flastPeriodChange = 1 and mon.FFaPeriodID is null   )");
        DbUtil.execute((Context)ctx, (String)deleteAttachSql.toString());
        StringBuffer deleteAttachNoSql = new StringBuffer("");
        deleteAttachNoSql.append("delete from T_BAS_BoAttchAsso where fid in  ");
        deleteAttachNoSql.append("( select asso.fid from T_BAS_BoAttchAsso asso ");
        deleteAttachNoSql.append("inner join T_FA_FaMonCard mon on asso.FBoID = mon.ffacurCardId ");
        deleteAttachNoSql.append("where mon.fcompanyId = '" + companyId + "' and mon.FOriginFlag = 0 ");
        deleteAttachNoSql.append("and mon.flastPeriodChange = 1 and mon.FFaPeriodID is null   )");
        DbUtil.execute((Context)ctx, (String)deleteAttachNoSql.toString());
        StringBuffer curCardIdSql = new StringBuffer("");
        curCardIdSql.append("select ffacurCardId from T_fa_FaMonCard ");
        curCardIdSql.append("where fcompanyId = '" + companyId + "' and foriginFlag = 0 and flastPeriodChange = 1 and FFaPeriodID is null ");
        FaLocalUtils.deleteLaterPeriodData(ctx, FaLocalUtils.getCurrentPeriod(ctx, companyId), curCardIdSql.toString(), "'" + companyId + "'", true);
        StringBuffer monCardIdSql = new StringBuffer("");
        monCardIdSql.append("select fid from T_fa_FaMonCard ");
        monCardIdSql.append("where fcompanyId = '" + companyId + "' and foriginFlag = 0 and flastPeriodChange = 1 and FFaPeriodID is null ");
        DbUtil.execute((Context)ctx, (String)("update t_fa_famoncard set FLastPeriodChange=0 where fid in (" + monCardIdSql.toString() + " )"));
        PeriodInfo[] p = FaPeriodCloseFacadeFactory.getLocalInstance(ctx).getLastestPeriod(companyId);
        FaLocalUtils.updateRedeprIdentifyCard(ctx, p[1], "'" + companyId + "'");
        if (p[0].getId().toString().equals(p[1].getId().toString())) {
            DbUtil.execute((Context)ctx, (String)("update t_fa_facurcard set FLastPeriodChange=0,flastupdatetime = GETDATE() where FCompanyID = '" + companyId + "'"));
        }
        FaLocalUtils.updateCardLaterDataIdentity(ctx, p[1], "'" + companyId + "'");
    }

    @Override
    protected String _getPlan(Context ctx) throws BOSException, EASBizException {
        String strResut = null;
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        String strCompanyID = aCompanyOrgUnitInfo.getId().toString();
        if (strCompanyID == null || strCompanyID.length() == 0) {
            return strResut;
        }
        Connection conn = null;
        PreparedStatement pst = null;
        try {
            conn = this.getConnection(ctx);
            String sql = "select count(*) as monNumber from T_FA_FaMonCard where ForiginFlag = 0 and FCompanyID = ? and FFaPeriodID is null";
            pst = conn.prepareStatement(sql);
            pst.setString(1, strCompanyID.toString());
            ResultSet rs1 = pst.executeQuery();
            int monNumber = 0;
            if (rs1.next()) {
                monNumber = rs1.getInt("monNumber");
            }
            sql = "select count(*) as curNumber from T_FA_FaCurCard where ForiginFlag = 0 and FCompanyID = ? ";
            pst.clearParameters();
            pst = conn.prepareStatement(sql);
            pst.setString(1, strCompanyID.toString());
            ResultSet rs2 = pst.executeQuery();
            int curNumber = 0;
            if (rs2.next()) {
                curNumber = rs2.getInt("curNumber");
            }
            strResut = curNumber + "/" + monNumber;
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pst, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pst, (Connection)conn);
        return strResut;
    }

    @Override
    protected boolean _unFinishInit(Context ctx) throws BOSException, EASBizException {
        String companyId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyId)));
        this.periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
        String periodID = this.periodInfo.getId().toString();
        if (periodID == null) {
            return false;
        }
        this.checkBooksPeriod(ctx, companyId, periodID, true);
        Object[] param = null;
        StringBuffer sql = new StringBuffer();
        sql.append("update T_Fa_FaMonCard                                 \r\n");
        sql.append("  set FBizStatus = '").append("0099").append("'");
        sql.append(" where FCompanyID = ? and  foriginFlag = ? and FFaPeriodID is null");
        param = new Object[]{companyId, new Integer(0)};
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])param);
        SystemStatusCtrolFactory.getLocalInstance((Context)ctx).start(SystemEnum.FIXEDASSETS, aCompanyOrgUnitInfo, false);
        return true;
    }

    public static String getPeriodInfo(Context ctx, String bookid) throws EASBizException, BOSException {
        String sql = "select s.fid from t_bd_systemstatus a \t\t\tinner join t_bd_systemstatusctrol b on a.fid=b.fsystemstatusid\t\t\t\t\tinner join t_bd_period  s on s.fid=b.fstartperiodid\t\t\t\t\tinner join t_org_company c on c.fid=b.fcompanyid where c.faccountschemeid=?\t";
        String startPeriod = null;
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{bookid});
        try {
            if (set == null || !set.next()) {
                return null;
            }
            startPeriod = set.getString("fid");
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return startPeriod;
    }

    public void checkBooksPeriod(Context ctx, String orgUnitId, String curPeriodID, boolean unClose) throws BOSException, EASBizException {
        String masterOrg;
        PeriodInfo startPeriod;
        if (unClose && BooksUtil.isMasterBook((Context)ctx)) {
            Map bookList = CardForMulBook._getBookList(ctx, orgUnitId);
            Set keys = bookList.keySet();
            for (String transferOrg : keys) {
                PeriodInfo startPeriod2 = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (IObjectPK)new ObjectUuidPK(transferOrg));
                PeriodInfo currentPeriod = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(curPeriodID));
                if (startPeriod2 == null || this.periodCompare(ctx, startPeriod2, currentPeriod) != 1) continue;
                String bookid = (String)bookList.get(transferOrg);
                AcountSchemeInfo book = (AcountSchemeInfo)AcountSchemeFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(bookid));
                throw new FaTransCardToBookException(FaTransCardToBookException.OTHERBOOKSPERIOD, new Object[]{book.getName()});
            }
        }
        if (!unClose && !BooksUtil.isMasterBook((Context)ctx) && (startPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (IObjectPK)new ObjectUuidPK(masterOrg = BooksUtil.getCurrentMasterCompanyID((Context)ctx)))) != null && this.periodInfo != null && this.periodCompare(ctx, this.periodInfo, startPeriod) == 1) {
            throw new FaTransCardToBookException(FaTransCardToBookException.MASTERNOTINITEPERIOD);
        }
    }

    private int periodCompare(Context ctx, PeriodInfo sourceperiodInfo, PeriodInfo targetperiodInfo) {
        if (sourceperiodInfo.getEndDate().getTime() > targetperiodInfo.getEndDate().getTime()) {
            return 1;
        }
        if (sourceperiodInfo.getEndDate().getTime() == targetperiodInfo.getEndDate().getTime()) {
            return 0;
        }
        return -1;
    }

    @Override
    protected boolean _updateAccuDeprTYearToZero(Context ctx) throws BOSException, EASBizException {
        String tempTableName = null;
        try {
            String one = "1";
            String periodNumber = "periodnumber";
            CompanyOrgUnitInfo aCompanyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
            PeriodInfo periodInfo = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
            if ("1".equals(periodInfo.get("periodnumber").toString())) {
                String sql = "update T_FA_FaMonCard set FAccuDeprTYear = ? where FCompanyID = ? and  FOriginFlag = ?";
                Object[] params = new Object[]{new Double(0.0), aCompanyOrgUnitInfo.getId().toString(), new Integer(0)};
                DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
                String selectSql = "select FFACURCARDID from T_FA_FaMonCard where FCompanyID = ? and  FOriginFlag = ?";
                Object[] selectParams = new Object[]{aCompanyOrgUnitInfo.getId().toString(), new Integer(0)};
                IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)selectSql, (Object[])selectParams);
                StringBuffer stringBuffer = new StringBuffer();
                try {
                    while (iRowSet.next()) {
                        stringBuffer.append(iRowSet.getString("FFACURCARDID"));
                        stringBuffer.append(",");
                    }
                }
                catch (SQLException throwables) {
                    throwables.printStackTrace();
                    throw new BOSException((Throwable)throwables);
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                }
                Map inSqlMap = FaManageUtils.getInSql(ctx, stringBuffer.toString());
                String inClause = (String)inSqlMap.get("inClause");
                tempTableName = (String)inSqlMap.get("tempTableName");
                if (stringBuffer.length() != 0) {
                    StringBuffer updateSql = new StringBuffer();
                    updateSql.append("update T_FA_FaCurCard set FAccuDeprTYear = ? where fid in (" + inClause + ") ");
                    Object[] updateParams = new Object[]{new Double(0.0)};
                    DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])updateParams);
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (tempTableName != null) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
            }
        }
    }

    protected void invokeServiceBefore(ServiceContext svcCtx) throws BOSException {
        FaRPCMethodMappingUtils.invokeRPCMethodEventListener(svcCtx, FaAppLogForBusinessTypeEnum.FA_CARD_INIT, FaMethodCalcOrderEnum.BEFORE);
        super.invokeServiceBefore(svcCtx);
    }

    protected void invokeServiceAfter(ServiceContext svcCtx) throws BOSException {
        FaRPCMethodMappingUtils.invokeRPCMethodEventListener(svcCtx, FaAppLogForBusinessTypeEnum.FA_CARD_INIT, FaMethodCalcOrderEnum.AFTER);
        super.invokeServiceAfter(svcCtx);
    }
}

