/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaDpreCalcException;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaDepCalStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaDepLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.FaDepreCalculator;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;

public class FaDepCalAveUsingAgeStrategy
extends AbstractFaDepCalStrategy {
    @Override
    public HashMap calcuatePeriodDepreResultDynamic(Context ctx, FaCurCardInfo faCardInfo, PeriodInfo periodInfo) throws BOSException, EASBizException {
        boolean isFromSimulateDepr;
        HashMap<Integer, BigDecimal> returnValue = new HashMap<Integer, BigDecimal>();
        int baseCurPrecision = this.getBaseCurrencyPrecision(ctx, faCardInfo.getCompany());
        int depreRatePrecision = this.getDeprRatePrecision();
        BigDecimal yearDepreAmount = null;
        BigDecimal periodDepreAmount = null;
        BigDecimal yearDepreRate = null;
        BigDecimal periodDepreRate = null;
        BigDecimal assetValue = faCardInfo.getAssetValue() == null ? new BigDecimal("0") : faCardInfo.getAssetValue();
        BigDecimal leftAmount = this.getLeftAmount(faCardInfo);
        BigDecimal leftPeriod = this.getLeftLife(faCardInfo);
        if (leftAmount.compareTo(zero) <= 0 || leftPeriod.compareTo(zero) <= 0) {
            return null;
        }
        if (this.isYearDep(faCardInfo)) {
            yearDepreAmount = leftAmount.divide(new BigDecimal(this.getRemainderYear(ctx, faCardInfo, periodInfo)), baseCurPrecision, 4);
            yearDepreRate = yearDepreAmount.multiply(new BigDecimal("100")).divide(assetValue, depreRatePrecision, 4);
            returnValue.put(FaDepreCalculator.FA_DEP_AMOUNT, yearDepreAmount);
            returnValue.put(FaDepreCalculator.FA_DEP_RATE, yearDepreRate);
        } else {
            periodDepreAmount = leftAmount.divide(leftPeriod, baseCurPrecision, 4);
            periodDepreRate = periodDepreAmount.multiply(new BigDecimal("100")).divide(assetValue, depreRatePrecision, 4);
            periodDepreAmount = this.dealPeriodAmount(faCardInfo, periodDepreAmount);
            returnValue.put(FaDepreCalculator.FA_DEP_AMOUNT, periodDepreAmount);
            returnValue.put(FaDepreCalculator.FA_DEP_RATE, periodDepreRate);
        }
        boolean bl = isFromSimulateDepr = ctx.get((Object)"isFromFaSimulateDepr") == null ? false : (Boolean)ctx.get((Object)"isFromFaSimulateDepr");
        if (!isFromSimulateDepr && faCardInfo != null && faCardInfo.getId() != null && CheckedStatusEnum.AUDITED.equals((Object)faCardInfo.getCheckedStatus())) {
            StringBuffer sql = new StringBuffer();
            String companyID = faCardInfo.getCompany().getId().toString();
            String curPeriodID = FaDepLocalUtils.getCurrentPeriod(ctx, companyID).getId().toString();
            PeriodInfo prePeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (IObjectPK)new ObjectUuidPK(curPeriodID));
            if (prePeriod != null && prePeriod.isIsAdjustPeriod()) {
                prePeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (IObjectPK)new ObjectUuidPK(prePeriod.getId().toString()));
            }
            if (prePeriod != null && prePeriod.getId() != null) {
                sql = FaDepCalAveUsingAgeStrategy.getUpdateLastDepCard(ctx, curPeriodID, prePeriod.getId().toString(), companyID, FaLocalUtils.getMethodID(ctx, "001"), faCardInfo);
                try {
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    if (rowSet.next()) {
                        BigDecimal deprerate = rowSet.getBigDecimal("fmonthdeprerate");
                        BigDecimal depreciation = rowSet.getBigDecimal("fdepreciation");
                        BigDecimal shoulddepre = rowSet.getBigDecimal("fshoulddepre");
                        returnValue.put(FaDepreCalculator.FA_DEP_AMOUNT, depreciation);
                        returnValue.put(FaDepreCalculator.FA_DEP_RATE, deprerate);
                        returnValue.put(FaDepreCalculator.FA_DEP_SHOULDAMT, shoulddepre);
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        return returnValue;
    }

    private static StringBuffer getUpdateLastDepCard(Context ctx, String curPeriodID, String prePeriodID, String companyID, String depmethodID, FaCurCardInfo facardInfo) {
        StringBuffer result = new StringBuffer();
        result.append("SELECT depentry.fmonthdeprerate AS fmonthdeprerate, depentry.FDepreciation AS fdepreciation, curcard.fid AS curcardid,\n");
        result.append("       depentry.fshoulddepre AS fshoulddepre,\n");
        result.append("       curcard.fneatamt - depentry.FDepreciation - curcard.fneatremvalue AS fnotdepre,\n");
        result.append("       depentry.FDepreciation + balance.faddupyeardepre AS fyearaddupdep,\n");
        result.append("       depentry.FDepreciation + curcard.faccudepr AS fenddepre\n");
        result.append("  FROM t_fa_famoncard moncard INNER JOIN t_fa_faaccountbalance balance ON moncard.ffacurcardid = balance.ffacurcardid\n");
        result.append("       INNER JOIN t_fa_facurcard curcard ON moncard.ffacurcardid = curcard.fid\n");
        result.append("       INNER JOIN t_fa_cat t1 ON curcard.fassetcatid = t1.fid\n");
        result.append("       INNER JOIN t_fa_depreciationpolicy t2 ON t1.fdepreciationpolicyid = t2.fid\n");
        result.append("       INNER JOIN t_fa_fadepreciationentry depentry ON depentry.ffacurcardid = moncard.ffacurcardid\n");
        result.append("       INNER JOIN t_fa_fadepreciation dep ON dep.fid = depentry.flnkfadepreentry\n");
        result.append("       LEFT OUTER JOIN (SELECT faccudepr, fdeprtermcount, ffacurcardid FROM t_fa_famoncard WHERE ffaperiodid IS NULL AND fcompanyid = '" + companyID + "') initcard ON moncard.ffacurcardid = initcard.ffacurcardid\n");
        result.append(" WHERE moncard.fcompanyid = '" + companyID + "'\n");
        result.append("   AND moncard.ffaperiodid = '" + prePeriodID + "'\n");
        result.append("   AND moncard.fhaschanged != 2\n");
        result.append("   AND moncard.fhascleared = 0\n");
        result.append("   AND dep.fperiod = moncard.ffaperiodid\n");
        result.append("   AND balance.fperiodid = '" + curPeriodID + "'\n");
        result.append("   AND curcard.fdeprmethodid = '" + depmethodID + "'\n");
        result.append("   AND (curcard.fhaschanged = 3 OR curcard.fhaschanged = 0  OR  curcard.fhaschanged = 2 )\n");
        result.append("   AND (curcard.fhascleared = 0 OR (t2.fstartdeprtime = 1 AND curcard.fhascleared != 0))\n");
        result.append("   AND NOT (    curcard.foriginflag = 0\n");
        result.append("            AND curcard.fisinitchange != 1\n");
        result.append("            AND t2.finitoldasset != 1\n");
        result.append("            AND (initcard.fdeprtermcount != 0 OR initcard.faccudepr != 0)\n");
        result.append("            )\n");
        result.append("   AND (   (moncard.fusetermcount - moncard.fdeprtermcount > 1)\n");
        result.append("      OR ((moncard.fusetermcount - moncard.fdeprtermcount <= 1) AND t2.ftaildispose = 0)\n");
        result.append("       )\n");
        result.append("   AND (moncard.fassetvalue - moncard.faccudepr - moncard.fdecvalue - moncard.fneatremvalue - depentry.FDepreciation >= 0\n");
        result.append("       )");
        result.append(" and curcard.fid='" + facardInfo.getId().toString() + "'");
        return result;
    }

    private int getRemainderYear(Context ctx, FaCurCardInfo faCardInfo, PeriodInfo periodInfo) throws BOSException, EASBizException {
        BigDecimal remainderPeriod = this.getLeftLife(faCardInfo);
        BigDecimal periodCountofYear = null;
        periodCountofYear = new BigDecimal(this.getValidPeriodCountofYear(ctx, periodInfo));
        BigDecimal remainderYear = null;
        if (periodCountofYear.compareTo(new BigDecimal("0")) < 0) {
            throw new FaDpreCalcException(FaDpreCalcException.EXP_USE_YEAR_ISZERO);
        }
        remainderYear = remainderPeriod.divide(periodCountofYear, 0, 0);
        return remainderYear.intValue();
    }

    @Override
    public HashMap getCalParameter(Context ctx, FaDepreciationModeInfo mode) {
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put("assetValue", "");
        hm.put("accuDepr", "");
        hm.put("decValue", "");
        hm.put("neatRemValue", "");
        hm.put("useTermCount", "");
        return hm;
    }

    @Override
    public HashMap calcuatePeriodDepreResultStatic(Context ctx, FaCurCardInfo faCardInfo, PeriodInfo period) throws BOSException, EASBizException {
        HashMap<Integer, BigDecimal> returnValue = new HashMap<Integer, BigDecimal>();
        int baseCurPrecision = this.getBaseCurrencyPrecision(ctx, faCardInfo.getCompany());
        int depreRatePrecision = this.getDeprRatePrecision();
        BigDecimal yearDepreAmount = null;
        BigDecimal periodDepreAmount = null;
        BigDecimal yearDepreRate = null;
        BigDecimal periodDepreRate = null;
        BigDecimal percent = new BigDecimal("100");
        BigDecimal assetValue = faCardInfo.getAssetValue() == null ? zero : faCardInfo.getAssetValue();
        BigDecimal neatRemValue = faCardInfo.getNeatRemValue() == null ? zero : faCardInfo.getNeatRemValue();
        BigDecimal useTermCount = faCardInfo.getUseTermCount() == null ? zero : faCardInfo.getUseTermCount();
        BigDecimal deprTermCount = faCardInfo.getDeprTermCount() == null ? zero : faCardInfo.getDeprTermCount();
        BigDecimal leftAmount = this.getLeftAmount(faCardInfo);
        BigDecimal leftTermCount = this.getLeftLife(faCardInfo);
        if (leftAmount.compareTo(zero) <= 0 || leftTermCount.compareTo(zero) <= 0) {
            return null;
        }
        if (this.isYearDep(faCardInfo)) {
            yearDepreAmount = assetValue.subtract(neatRemValue).divide(faCardInfo.getUseYears(), baseCurPrecision, 4);
            yearDepreRate = yearDepreAmount.multiply(percent).divide(assetValue, depreRatePrecision, 4);
            returnValue.put(FaDepreCalculator.FA_DEP_AMOUNT, yearDepreAmount);
            returnValue.put(FaDepreCalculator.FA_DEP_RATE, yearDepreRate);
        } else {
            periodDepreAmount = assetValue.subtract(neatRemValue).divide(useTermCount, baseCurPrecision, 4);
            periodDepreRate = periodDepreAmount.multiply(percent).divide(assetValue, depreRatePrecision, 4);
            periodDepreAmount = this.dealPeriodAmount(faCardInfo, periodDepreAmount);
            returnValue.put(FaDepreCalculator.FA_DEP_AMOUNT, periodDepreAmount);
            returnValue.put(FaDepreCalculator.FA_DEP_RATE, periodDepreRate);
        }
        return returnValue;
    }
}

