/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaDepCalStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaDepreCalculator;
import java.math.BigDecimal;
import java.util.HashMap;

public class FaDepCalDoubleSubtractDynamicStrategy
extends AbstractFaDepCalStrategy {
    @Override
    public HashMap calcuatePeriodDepreResultDynamic(Context ctx, FaCurCardInfo faCardInfo, PeriodInfo period) throws BOSException, EASBizException {
        HashMap returnValue = new HashMap();
        this.calcuateReturnValueNew(faCardInfo, period, returnValue, ctx);
        return returnValue;
    }

    public void calcuateReturnValueNew(FaCurCardInfo faCardInfo, PeriodInfo period, HashMap returnValue, Context ctx) throws BOSException, EASBizException {
        int baseCurPrecision = this.getBaseCurrencyPrecision(ctx, faCardInfo.getCompany());
        int depreRatePrecision = this.getDeprRatePrecision();
        BigDecimal yearDepreAmount = null;
        BigDecimal periodDepreAmount = null;
        BigDecimal yearDepreRate = null;
        BigDecimal periodDepreRate = null;
        BigDecimal assetValue = faCardInfo.getAssetValue() == null ? new BigDecimal("0") : faCardInfo.getAssetValue();
        BigDecimal accuDepr = this.getCalDepAmount(faCardInfo, ctx, period);
        BigDecimal decValue = faCardInfo.getDecValue() == null ? new BigDecimal("0") : faCardInfo.getDecValue();
        BigDecimal percent = new BigDecimal("100");
        int depCount = this.getDepCount(ctx, faCardInfo, period);
        if (!this.isLastTwoYear(faCardInfo)) {
            BigDecimal useTermCount = faCardInfo.getUseTermCount();
            String periodCount = String.valueOf(this.getPeriodCount());
            yearDepreRate = new BigDecimal("2").multiply(percent).multiply(new BigDecimal(periodCount)).divide(useTermCount, depreRatePrecision, 4);
            BigDecimal temp1 = assetValue.subtract(decValue).subtract(accuDepr);
            yearDepreAmount = temp1.multiply(yearDepreRate).divide(percent, baseCurPrecision, 4);
            periodDepreRate = yearDepreRate.divide(new BigDecimal(periodCount), depreRatePrecision, 4);
            periodDepreAmount = yearDepreAmount.divide(new BigDecimal(periodCount), baseCurPrecision, 4);
            depCount = depCount >= this.getValidPeriodCountofYear(ctx, period) ? 1 : ++depCount;
            BigDecimal useYear = this.getDownLeftYear(ctx, faCardInfo, period, baseCurPrecision);
            returnValue.put(FaDepreCalculator.FA_DEP_AMOUNT, periodDepreAmount);
            returnValue.put(FaDepreCalculator.FA_DEP_RATE, periodDepreRate);
            returnValue.put(FaDepreCalculator.FA_DEP_LEFTYEAR, useYear);
            returnValue.put(FaDepreCalculator.FA_DEP_LEFTYEARTWO, useYear);
            returnValue.put(FaDepreCalculator.FA_DEP_CALDEPAMOUNT, accuDepr);
            returnValue.put(FaDepreCalculator.FA_DEP_DEPCOUNT, new Integer(depCount));
        } else {
            BigDecimal leftAmount = this.getLastTwoYearDepr(faCardInfo);
            BigDecimal leftPeriod = this.getLeftLife(faCardInfo);
            boolean hasChanged = this.hasChanged(faCardInfo);
            if (hasChanged) {
                leftAmount = this.getLeftAmount(faCardInfo);
            }
            periodDepreAmount = leftAmount.divide(leftPeriod, baseCurPrecision, 4);
            periodDepreRate = periodDepreAmount.multiply(new BigDecimal("100")).divide(assetValue, depreRatePrecision, 4);
            if (this.isFinalyDepCal(faCardInfo)) {
                periodDepreAmount = this.getLeftAmount(faCardInfo);
            }
            returnValue.put(FaDepreCalculator.FA_DEP_AMOUNT, periodDepreAmount);
            returnValue.put(FaDepreCalculator.FA_DEP_RATE, periodDepreRate);
            returnValue.put(FaDepreCalculator.FA_DEP_CALDEPAMOUNT, leftAmount);
            returnValue.put(FaDepreCalculator.FA_DEP_LEFTYEARUP, hasChanged ? new BigDecimal("1") : new BigDecimal("0"));
        }
    }

    @Override
    public HashMap calcuatePeriodDepreResultStatic(Context ctx, FaCurCardInfo faCardInfo, PeriodInfo period) throws BOSException, EASBizException {
        return this.calcuatePeriodDepreResultDynamic(ctx, faCardInfo, period);
    }

    @Override
    public HashMap getCalParameter(Context ctx, FaDepreciationModeInfo mode) throws BOSException, EASBizException {
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put("assetValue", "");
        hm.put("accuDepr", "");
        hm.put("decValue", "");
        hm.put("useTermCount", "");
        hm.put("useYears", "");
        hm.put("neatRemValue", "");
        return hm;
    }

    private int getDepCount(Context ctx, FaCurCardInfo card, PeriodInfo period) throws BOSException {
        HashMap hm = (HashMap)this.getUserObject();
        if (hm != null && hm.get(FaDepreCalculator.FA_DEP_DEPCOUNT) != null) {
            Integer depCount = (Integer)hm.get(FaDepreCalculator.FA_DEP_DEPCOUNT);
            return depCount;
        }
        return 0;
    }

    private BigDecimal getDownLeftYear(Context ctx, FaCurCardInfo card, PeriodInfo period, int baseCurPrecision) throws BOSException {
        BigDecimal leftYear;
        HashMap hm = (HashMap)this.getUserObject();
        if (hm != null && hm.get(FaDepreCalculator.FA_DEP_LEFTYEARTWO) != null && (leftYear = (BigDecimal)hm.get(FaDepreCalculator.FA_DEP_LEFTYEARTWO)).compareTo(new BigDecimal("0")) > 0) {
            return leftYear;
        }
        int periodCount = this.getValidPeriodCountofYear(ctx, period);
        BigDecimal remainderPeriod = this.getLeftLife(card);
        BigDecimal remainderYear = remainderPeriod.divide(new BigDecimal(periodCount), baseCurPrecision, 4);
        if (remainderYear.doubleValue() < 1.0) {
            remainderYear = remainderPeriod.divide(new BigDecimal(periodCount), 10, 4);
        }
        return remainderYear;
    }

    private BigDecimal getCalDepAmount(FaCurCardInfo faCardInfo, Context ctx, PeriodInfo period) throws BOSException {
        HashMap hm = (HashMap)this.getUserObject();
        BigDecimal accuDepr = new BigDecimal("0");
        accuDepr = hm != null && hm.get(FaDepreCalculator.FA_DEP_CALDEPAMOUNT) != null && hm.get(FaDepreCalculator.FA_DEP_DEPCOUNT) != null && (Integer)hm.get(FaDepreCalculator.FA_DEP_DEPCOUNT) < this.getValidPeriodCountofYear(ctx, period) ? (BigDecimal)hm.get(FaDepreCalculator.FA_DEP_CALDEPAMOUNT) : (faCardInfo.getAccuDepr() == null ? new BigDecimal("0") : faCardInfo.getAccuDepr());
        return accuDepr;
    }

    private boolean isLastTwoYear(FaCurCardInfo card) throws BOSException {
        BigDecimal depTermCount;
        BigDecimal useTermCount = card.getUseTermCount();
        BigDecimal temp = useTermCount.subtract(depTermCount = card.getDeprTermCount() == null ? new BigDecimal(0) : card.getDeprTermCount());
        return temp.compareTo(new BigDecimal(24)) <= 0;
    }

    private boolean hasChanged(FaCurCardInfo card) throws BOSException {
        HashMap hm = (HashMap)this.getUserObject();
        if (hm != null && hm.get(FaDepreCalculator.FA_DEP_LEFTYEARUP) != null) {
            Integer depCount = (Integer)hm.get(FaDepreCalculator.FA_DEP_LEFTYEARUP);
            return depCount == 1;
        }
        return false;
    }

    private BigDecimal getLastTwoYearDepr(FaCurCardInfo faCardInfo) {
        HashMap hm = (HashMap)this.getUserObject();
        if (hm != null && hm.get(FaDepreCalculator.FA_DEP_CALDEPAMOUNT) != null) {
            BigDecimal depTermCount;
            BigDecimal lastTwoYearDepr = (BigDecimal)hm.get(FaDepreCalculator.FA_DEP_CALDEPAMOUNT);
            BigDecimal useTermCount = faCardInfo.getUseTermCount();
            BigDecimal temp = useTermCount.subtract(depTermCount = faCardInfo.getDeprTermCount() == null ? new BigDecimal(0) : faCardInfo.getDeprTermCount());
            if (temp.compareTo(new BigDecimal(24)) <= 0) {
                return this.getLeftAmount(faCardInfo);
            }
            return lastTwoYearDepr;
        }
        return this.getLeftAmount(faCardInfo);
    }

    private boolean isFirstYear(FaCurCardInfo faCurCardInfo) {
        BigDecimal depTermCount;
        BigDecimal bigDecimal = depTermCount = faCurCardInfo.getDeprTermCount() == null ? new BigDecimal("0") : faCurCardInfo.getDeprTermCount();
        return depTermCount.compareTo(new BigDecimal("12")) <= 0;
    }
}

