/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaDeprRateEntryCollection;
import com.kingdee.eas.fi.fa.basedata.FaDeprRateEntryFactory;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaDpreCalcException;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Locale;

public class FaDepCalRateCode {
    public BigDecimal getDeprRate(Context ctx, FaCurCardInfo faCardInfo, int count, FaDepreciationModeInfo mode, boolean isEval, int roundingmode) throws BOSException, EASBizException {
        Object deprModes = null;
        if (isEval) {
            int evalUseTermCount = faCardInfo.getEvalUseTermCount().intValue();
            int useYears = evalUseTermCount / count;
            if (useYears == 0 || count * useYears != evalUseTermCount) {
                throw new FaDpreCalcException(FaDpreCalcException.CARDTAXDEPRMESSAGE_ERROR, new Object[]{faCardInfo.getNumber(), ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"93_FaDepCalRateCode", (Locale)ctx.getOriginLocale())});
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("deprRateParent.id", (Object)mode.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("useYears", (Object)String.valueOf(useYears)));
            view.setFilter(filter);
            FaDeprRateEntryCollection rateInfoColl = FaDeprRateEntryFactory.getLocalInstance((Context)ctx).getFaDeprRateEntryCollection(view);
            if (rateInfoColl.isEmpty()) {
                String strError = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"94_FaDepCalRateCode", (Locale)ctx.getOriginLocale());
                throw new FaDpreCalcException(FaDpreCalcException.CARDTAXDEPRMESSAGE_ERROR, new Object[]{faCardInfo.getNumber(), strError});
            }
            if (!rateInfoColl.isEmpty()) {
                double deprTermCount = Double.parseDouble(faCardInfo.getEvalDeprPeriodNum().toString());
                double deprUseYear = deprTermCount / (double)count;
                int dpUseYear = 0;
                int temp = rateInfoColl.get(0).getInt("useYears");
                for (int i = 0; i < temp; ++i) {
                    if (!(deprUseYear >= (double)i) || !(deprUseYear < (double)(i + 1))) continue;
                    dpUseYear = i + 1;
                    break;
                }
                BigDecimal monthDeprRate = rateInfoColl.get(0).getBigDecimal("year" + dpUseYear);
                monthDeprRate = monthDeprRate.divide(new BigDecimal(String.valueOf(count * 100)), roundingmode, 4);
                return monthDeprRate;
            }
            return new BigDecimal("0");
        }
        int useYears = faCardInfo.getUseYears().intValue();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("deprRateParent.id", (Object)mode.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("useYears", (Object)String.valueOf(useYears)));
        view.setFilter(filter);
        FaDeprRateEntryCollection rateInfoColl = FaDeprRateEntryFactory.getLocalInstance((Context)ctx).getFaDeprRateEntryCollection(view);
        if (rateInfoColl.isEmpty()) {
            String strError = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"95_FaDepCalRateCode", (Locale)ctx.getOriginLocale());
            throw new FaDpreCalcException(FaDpreCalcException.CARDDEPRMESSAGE_ERROR, new Object[]{faCardInfo.getNumber(), strError});
        }
        if (!rateInfoColl.isEmpty()) {
            double deprTermCount = Double.parseDouble(faCardInfo.getDeprTermCount().toString());
            double deprUseYear = deprTermCount / (double)count;
            int dpUseYear = 0;
            int temp = rateInfoColl.get(0).getInt("useYears");
            for (int i = 0; i < temp; ++i) {
                if (!(deprUseYear >= (double)i) || !(deprUseYear < (double)(i + 1))) continue;
                dpUseYear = i + 1;
                break;
            }
            BigDecimal monthDeprRate = rateInfoColl.get(0).getBigDecimal("year" + dpUseYear);
            monthDeprRate = monthDeprRate.divide(new BigDecimal(String.valueOf(count * 100)), roundingmode, 4);
            return monthDeprRate;
        }
        return new BigDecimal("0");
    }

    public int getDeprRate(Context ctx) throws EASBizException, BOSException {
        String depreRate = (String)this.gethmParam(ctx).get("FA_007");
        return Integer.parseInt(depreRate);
    }

    protected HashMap gethmParam(Context ctx) throws BOSException, EASBizException {
        HashMap hmParam = new HashMap();
        if (hmParam == null || hmParam.size() == 0) {
            hmParam = FaManageUtils.getFAParameter(this.getCurrentCompany(ctx).getId(), ctx);
        }
        return hmParam;
    }

    protected CompanyOrgUnitInfo getCurrentCompany(Context ctx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo currCompany = null;
        if (currCompany == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            BOSUuid id = ContextUtil.getCurrentFIUnit((Context)ctx).getId();
            currCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(id), sic);
        }
        return currCompany;
    }
}

