/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaDpreCalcException;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaDepCalStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaDepreCalculator;
import java.math.BigDecimal;
import java.util.HashMap;

public class FaDepCalSelfUsePropertyStrategy
extends AbstractFaDepCalStrategy {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public HashMap calcuatePeriodDepreResultDynamic(Context ctx, FaCurCardInfo faCardInfo, PeriodInfo periodInfo) throws BOSException, EASBizException {
        BigDecimal leftAmtForDep;
        HashMap<Integer, BigDecimal> returnValue = new HashMap<Integer, BigDecimal>();
        int baseCurPrecision = this.getBaseCurrencyPrecision(ctx, faCardInfo.getCompany());
        int depreRatePrecision = this.getDeprRatePrecision();
        BigDecimal periodDepreAmount = null;
        BigDecimal periodDepreRate = null;
        BigDecimal thisEvaValue = null;
        if (faCardInfo.getInitEvalValue() == null || faCardInfo.getInitEvalValue().compareTo(new BigDecimal("0")) < 1) {
            if (faCardInfo.getAssetValue() == null || faCardInfo.getAssetValue().compareTo(new BigDecimal("0")) != 1) throw new FaDpreCalcException(FaDpreCalcException.LOCAL_AMOUNT_ISZERO_OR_ISNULL);
            thisEvaValue = faCardInfo.getAssetValue();
        } else {
            thisEvaValue = faCardInfo.getInitEvalValue();
        }
        if (faCardInfo.getEvalLeftPeriod().compareTo(new BigDecimal("0")) != 1) throw new FaDpreCalcException(FaDpreCalcException.EVA_LEFT_PERIOD_ISNOTPOSITIVE);
        periodDepreAmount = thisEvaValue.divide(faCardInfo.getEvalLeftPeriod(), baseCurPrecision, 4);
        if (periodDepreAmount.compareTo(leftAmtForDep = thisEvaValue.subtract(faCardInfo.getAccuDepr()).subtract(faCardInfo.getDecValue()).subtract(faCardInfo.getNeatRemValue())) > 0) {
            periodDepreAmount = leftAmtForDep;
        }
        periodDepreRate = periodDepreAmount.multiply(new BigDecimal("100")).divide(thisEvaValue, depreRatePrecision, 4);
        returnValue.put(FaDepreCalculator.FA_DEP_AMOUNT, periodDepreAmount);
        returnValue.put(FaDepreCalculator.FA_DEP_RATE, periodDepreRate);
        return returnValue;
    }

    @Override
    public HashMap getCalParameter(Context ctx, FaDepreciationModeInfo mode) {
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put("initEvalValue", "");
        hm.put("evalLeftPeriod", "");
        return hm;
    }

    @Override
    public boolean haveAmountForDep(FaCurCardInfo faCardInfo, Context ctx) {
        BigDecimal initEvalValue = faCardInfo.getInitEvalValue();
        if (initEvalValue == null || initEvalValue.compareTo(new BigDecimal("0")) <= 0) {
            return false;
        }
        BigDecimal accuDepr = faCardInfo.getAccuDepr() == null ? new BigDecimal("0") : faCardInfo.getAccuDepr();
        BigDecimal decValue = faCardInfo.getDecValue() == null ? new BigDecimal("0") : faCardInfo.getDecValue();
        BigDecimal neatRemValue = faCardInfo.getNeatRemValue() == null ? new BigDecimal("0") : faCardInfo.getNeatRemValue();
        BigDecimal result = initEvalValue.subtract(accuDepr).subtract(decValue).subtract(neatRemValue);
        return result.compareTo(new BigDecimal("0")) > 0;
    }

    @Override
    public boolean haveLifeForDep(FaCurCardInfo faCardInfo, Context ctx) {
        BigDecimal leftPeriod = faCardInfo.getEvalLeftPeriod();
        return leftPeriod.compareTo(new BigDecimal("0")) > 0;
    }

    @Override
    public HashMap calcuatePeriodDepreResultStatic(Context ctx, FaCurCardInfo faCardInfo, PeriodInfo period) throws BOSException, EASBizException {
        return this.calcuatePeriodDepreResultDynamic(ctx, faCardInfo, period);
    }
}

