/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaDepCalStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaDepreCalculator;
import java.math.BigDecimal;
import java.util.HashMap;

public class FaDepCalStraightAccountStrategy
extends AbstractFaDepCalStrategy {
    @Override
    public HashMap calcuatePeriodDepreResultDynamic(Context ctx, FaCurCardInfo faCardInfo, PeriodInfo period) throws BOSException, EASBizException {
        BigDecimal monthDepRate;
        HashMap<Integer, BigDecimal> returnValue = new HashMap<Integer, BigDecimal>();
        int baseCurPrecision = this.getBaseCurrencyPrecision(ctx, faCardInfo.getCompany());
        int depreRatePrecision = this.getDeprRatePrecision();
        BigDecimal periodDepreAmount = null;
        BigDecimal periodDepreRate = null;
        BigDecimal assetValue = faCardInfo.getAssetValue() == null ? new BigDecimal("0") : faCardInfo.getAssetValue();
        BigDecimal leftAmount = this.getLeftAmount(faCardInfo);
        if (leftAmount.compareTo(zero) <= 0) {
            return null;
        }
        BigDecimal bigDecimal = monthDepRate = faCardInfo.getMonthDepreRate() == null ? new BigDecimal("0") : faCardInfo.getMonthDepreRate();
        if (monthDepRate.compareTo(zero) == 0) {
            return null;
        }
        boolean isTailDispose = faCardInfo.getAssetCat().getDepreciationPolicy().isTailDispose();
        BigDecimal deprTermCount = faCardInfo.getDeprTermCount() == null ? new BigDecimal("0") : faCardInfo.getDeprTermCount();
        BigDecimal useTermCount = faCardInfo.getUseTermCount() == null ? new BigDecimal("0") : faCardInfo.getUseTermCount();
        boolean isLastPeriod = useTermCount.subtract(deprTermCount.add(new BigDecimal("1"))).compareTo(zero) == 0;
        periodDepreAmount = isTailDispose && isLastPeriod ? leftAmount : assetValue.multiply(monthDepRate).divide(new BigDecimal("100"), baseCurPrecision, 4);
        periodDepreRate = monthDepRate.setScale(depreRatePrecision, 4);
        periodDepreAmount = this.dealPeriodAmount(faCardInfo, periodDepreAmount);
        returnValue.put(FaDepreCalculator.FA_DEP_AMOUNT, periodDepreAmount);
        returnValue.put(FaDepreCalculator.FA_DEP_RATE, periodDepreRate);
        return returnValue;
    }

    @Override
    public HashMap calcuatePeriodDepreResultStatic(Context ctx, FaCurCardInfo faCardInfo, PeriodInfo period) throws BOSException, EASBizException {
        return this.calcuatePeriodDepreResultDynamic(ctx, faCardInfo, period);
    }

    @Override
    public HashMap getCalParameter(Context ctx, FaDepreciationModeInfo mode) {
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put("assetValue", "");
        hm.put("monthDepreRate", "");
        hm.put("neatRemValue", "");
        hm.put("accuDepr", "");
        hm.put("decValue", "");
        return hm;
    }

    @Override
    public boolean haveLifeForDep(FaCurCardInfo faCardInfo, Context ctx) {
        return true;
    }

    @Override
    protected BigDecimal dealPeriodAmount(FaCurCardInfo faCardInfo, BigDecimal oldAmount) throws BOSException {
        BigDecimal leftAmount = this.getLeftAmount(faCardInfo);
        if (oldAmount.compareTo(leftAmount) > 0) {
            oldAmount = leftAmount;
        }
        return oldAmount;
    }
}

