/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaDepCalStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaDepreCalculator;
import java.math.BigDecimal;
import java.util.HashMap;

public class FaDepCalTotalYearDynStrategy
extends AbstractFaDepCalStrategy {
    @Override
    public HashMap calcuatePeriodDepreResultDynamic(Context ctx, FaCurCardInfo faCardInfo, PeriodInfo period) throws BOSException, EASBizException {
        HashMap<Integer, Number> returnValue = new HashMap<Integer, Number>();
        int baseCurPrecision = this.getBaseCurrencyPrecision(ctx, faCardInfo.getCompany());
        int depreRatePrecision = this.getDeprRatePrecision();
        BigDecimal yearDepreAmount = null;
        BigDecimal periodDepreAmount = null;
        BigDecimal yearDepreRate = null;
        BigDecimal periodDepreRate = null;
        BigDecimal percent = new BigDecimal(100);
        BigDecimal downLeftYear = this.getDownLeftYear(ctx, faCardInfo, period);
        int depCount = this.getDepCount(ctx, faCardInfo, period);
        BigDecimal temp1 = downLeftYear.multiply(downLeftYear.add(new BigDecimal("1"))).divide(new BigDecimal("2"), depreRatePrecision, 4);
        BigDecimal temp2 = this.getUpLeftYear(ctx, faCardInfo, period);
        if (depCount >= this.getValidPeriodCountofYear(ctx, period)) {
            depCount = 1;
            temp2 = temp2.subtract(new BigDecimal(1));
        } else {
            ++depCount;
        }
        BigDecimal leftAmount = this.getCalAmount(faCardInfo);
        BigDecimal periodCount = new BigDecimal("0");
        if (temp2.compareTo(new BigDecimal("1")) <= 0) {
            yearDepreAmount = this.getLeftAmount(faCardInfo);
            BigDecimal depTermCount = faCardInfo.getDeprTermCount() == null ? new BigDecimal("0") : faCardInfo.getDeprTermCount();
            periodCount = faCardInfo.getUseTermCount().subtract(depTermCount);
            periodDepreAmount = yearDepreAmount.divide(periodCount, baseCurPrecision, 4);
            periodDepreRate = periodDepreAmount.multiply(percent).divide(leftAmount, depreRatePrecision, 4);
            periodDepreAmount = this.dealPeriodAmount(faCardInfo, periodDepreAmount);
        } else {
            yearDepreRate = temp2.multiply(percent).divide(temp1, depreRatePrecision, 4);
            yearDepreAmount = leftAmount.multiply(temp2).divide(temp1, baseCurPrecision, 4);
            periodCount = new BigDecimal(this.getValidPeriodCountofYear(ctx, period));
            periodDepreRate = yearDepreRate.divide(periodCount, depreRatePrecision, 4);
            periodDepreAmount = yearDepreAmount.divide(periodCount, baseCurPrecision, 4);
        }
        returnValue.put(FaDepreCalculator.FA_DEP_AMOUNT, periodDepreAmount);
        returnValue.put(FaDepreCalculator.FA_DEP_RATE, periodDepreRate);
        returnValue.put(FaDepreCalculator.FA_DEP_LEFTYEAR, downLeftYear);
        returnValue.put(FaDepreCalculator.FA_DEP_LEFTYEARUP, temp2);
        returnValue.put(FaDepreCalculator.FA_DEP_DEPCOUNT, new Integer(depCount));
        returnValue.put(FaDepreCalculator.FA_DEP_CALDEPAMOUNT, this.getCalDepAmount(faCardInfo));
        return returnValue;
    }

    private int getDepCount(Context ctx, FaCurCardInfo card, PeriodInfo period) throws BOSException {
        HashMap hm = (HashMap)this.getUserObject();
        if (hm != null && hm.get(FaDepreCalculator.FA_DEP_DEPCOUNT) != null) {
            Integer depCount = (Integer)hm.get(FaDepreCalculator.FA_DEP_DEPCOUNT);
            return depCount;
        }
        return 0;
    }

    private int getLastPeriodCount(Context ctx, FaCurCardInfo card, PeriodInfo period) throws BOSException {
        HashMap hm = (HashMap)this.getUserObject();
        if (hm != null && hm.get(FaDepreCalculator.FA_DEP_LASTPERIODCOUNT) != null && (Integer)hm.get(FaDepreCalculator.FA_DEP_LASTPERIODCOUNT) > 0) {
            Integer lastPeriodCount = (Integer)hm.get(FaDepreCalculator.FA_DEP_LASTPERIODCOUNT);
            return lastPeriodCount;
        }
        BigDecimal depTermCount = card.getDeprTermCount() == null ? new BigDecimal("0") : card.getDeprTermCount();
        BigDecimal periodCount = card.getUseTermCount().subtract(depTermCount);
        return periodCount.intValue();
    }

    private BigDecimal getDownLeftYear(Context ctx, FaCurCardInfo card, PeriodInfo period) throws BOSException {
        Integer leftYear;
        HashMap hm = (HashMap)this.getUserObject();
        if (hm != null && hm.get(FaDepreCalculator.FA_DEP_LEFTYEAR) != null && (leftYear = (Integer)hm.get(FaDepreCalculator.FA_DEP_LEFTYEAR)) > 0) {
            return new BigDecimal(leftYear.toString());
        }
        int periodCount = this.getValidPeriodCountofYear(ctx, period);
        BigDecimal remainderPeriod = this.getLeftLife(card);
        BigDecimal remainderYear = remainderPeriod.divide(new BigDecimal(periodCount), 2, 4);
        if (remainderYear.compareTo(new BigDecimal(new Integer(remainderYear.intValue()).toString())) != 0) {
            int newRemainderYear = remainderYear.intValue() + 1;
            remainderYear = new BigDecimal(new Integer(newRemainderYear).toString());
        }
        return remainderYear;
    }

    private BigDecimal getUpLeftYear(Context ctx, FaCurCardInfo card, PeriodInfo period) throws BOSException {
        Integer leftYearUp;
        HashMap hm = (HashMap)this.getUserObject();
        if (hm != null && hm.get(FaDepreCalculator.FA_DEP_LEFTYEARUP) != null && (leftYearUp = (Integer)hm.get(FaDepreCalculator.FA_DEP_LEFTYEARUP)) > 0) {
            return new BigDecimal(leftYearUp.toString());
        }
        int periodCount = this.getValidPeriodCountofYear(ctx, period);
        BigDecimal remainderPeriod = this.getLeftLife(card);
        BigDecimal remainderYear = remainderPeriod.divide(new BigDecimal(periodCount), 2, 4);
        if (remainderYear.compareTo(new BigDecimal(new Integer(remainderYear.intValue()).toString())) != 0) {
            int newRemainderYear = remainderYear.intValue() + 1;
            remainderYear = new BigDecimal(new Integer(newRemainderYear).toString());
        }
        return remainderYear;
    }

    @Override
    public HashMap getCalParameter(Context ctx, FaDepreciationModeInfo mode) {
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put("assetValue", "");
        hm.put("decValue", "");
        hm.put("neatRemValue", "");
        hm.put("useTermCount", "");
        hm.put("useYears", "");
        return hm;
    }

    private BigDecimal getCalDepAmount(FaCurCardInfo faCardInfo) {
        HashMap hm = (HashMap)this.getUserObject();
        BigDecimal accuDepr = new BigDecimal("0");
        accuDepr = hm != null && hm.get(FaDepreCalculator.FA_DEP_CALDEPAMOUNT) != null ? (BigDecimal)hm.get(FaDepreCalculator.FA_DEP_CALDEPAMOUNT) : (faCardInfo.getAccuDepr() == null ? new BigDecimal("0") : faCardInfo.getAccuDepr());
        return accuDepr;
    }

    protected BigDecimal getCalAmount(FaCurCardInfo faCardInfo) {
        BigDecimal assetValue = faCardInfo.getAssetValue();
        if (assetValue == null || assetValue.compareTo(new BigDecimal("0")) <= 0) {
            return new BigDecimal("0");
        }
        BigDecimal accuDepr = this.getCalDepAmount(faCardInfo);
        BigDecimal decValue = faCardInfo.getDecValue() == null ? new BigDecimal("0") : faCardInfo.getDecValue();
        BigDecimal neatRemValue = faCardInfo.getNeatRemValue() == null ? new BigDecimal("0") : faCardInfo.getNeatRemValue();
        BigDecimal result = assetValue.subtract(accuDepr).subtract(decValue).subtract(neatRemValue);
        if (result.compareTo(new BigDecimal("0")) > 0) {
            return result;
        }
        return new BigDecimal("0");
    }

    @Override
    public HashMap calcuatePeriodDepreResultStatic(Context ctx, FaCurCardInfo faCardInfo, PeriodInfo period) throws BOSException, EASBizException {
        return this.calcuatePeriodDepreResultDynamic(ctx, faCardInfo, period);
    }
}

