/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaAccountBalanceCollection;
import com.kingdee.eas.fi.fa.manage.FaAccountBalanceInfo;
import com.kingdee.eas.fi.fa.manage.FaBakCardCollection;
import com.kingdee.eas.fi.fa.manage.FaBakCardFactory;
import com.kingdee.eas.fi.fa.manage.FaBakCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCardOriginEnum;
import com.kingdee.eas.fi.fa.manage.FaChangeBillFactory;
import com.kingdee.eas.fi.fa.manage.FaClearBillFactory;
import com.kingdee.eas.fi.fa.manage.FaCurAsstActCompositCollection;
import com.kingdee.eas.fi.fa.manage.FaCurAsstActCompositInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCostCenterCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCostCenterInfo;
import com.kingdee.eas.fi.fa.manage.FaDepAsstActCompositInfo;
import com.kingdee.eas.fi.fa.manage.FaDepDistributeInfo;
import com.kingdee.eas.fi.fa.manage.FaDepEntryStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaDepType;
import com.kingdee.eas.fi.fa.manage.FaDepreciationCollection;
import com.kingdee.eas.fi.fa.manage.FaDepreciationEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaDepreciationEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaDepreciationFactory;
import com.kingdee.eas.fi.fa.manage.FaDepreciationInfo;
import com.kingdee.eas.fi.fa.manage.FaPeriodCloseFacadeFactory;
import com.kingdee.eas.fi.fa.manage.IFaBakCard;
import com.kingdee.eas.fi.fa.manage.IFaBillBase;
import com.kingdee.eas.fi.fa.manage.IFaChangeBill;
import com.kingdee.eas.fi.fa.manage.IFaClearBill;
import com.kingdee.eas.fi.fa.manage.IFaCurCard;
import com.kingdee.eas.fi.fa.manage.IFaDepreciation;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaDepCalcForCoalFacadeControllerBean;
import com.kingdee.eas.fi.fa.manage.app.FaDepCalExecutor;
import com.kingdee.eas.fi.fa.manage.app.FaDepLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.FaDepORMapping;
import com.kingdee.eas.fi.fa.manage.app.FaDepreCalculator;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class FaDepCalcForCoalFacadeControllerBean
extends AbstractFaDepCalcForCoalFacadeControllerBean {
    protected static final BigDecimal zeroValue = new BigDecimal("0");
    private static Logger logger = Logger.getLogger(FaDepCalcForCoalFacadeControllerBean.class);
    private static int OPERATE_DODEP = 0;
    private static int OPERATE_AUDIT = 1;
    private static int OPERATE_BUILDINFO = 2;
    private static int OPERATE_PERIODFORWARD = 3;
    protected static final String FAMAINTAINRESOURCE = "com.kingdee.eas.fi.fa.manage.FaDepreciationResource";

    @Override
    protected void _auditBill(Context ctx, String objectID) throws BOSException, EASBizException {
        PeriodInfo period = FaDepLocalUtils.getCurrentPeriod(ctx);
        String companyID = this.getCurCompanyID(ctx);
        this.checkGenFV(ctx, period, companyID);
        this.checkPeriod(ctx, companyID);
        FaDepreciationInfo depInfo = (FaDepreciationInfo)this.getDepCollection(ctx, period, companyID);
        this.auditBill(ctx, companyID, depInfo, period);
    }

    private void auditBill(Context ctx, String companyID, FaDepreciationInfo depInfo, PeriodInfo period) throws BOSException, EASBizException {
        FaDepreciationEntryCollection depEntryCollection = depInfo.getLnkFaDepreEntry();
        if (depInfo == null || depInfo.getId() == null || depEntryCollection == null || depEntryCollection.size() == 0) {
            return;
        }
        HashSet<BOSUuid> cardId = new HashSet<BOSUuid>();
        HashMap<BOSUuid, FaDepreciationEntryInfo> depResult = new HashMap<BOSUuid, FaDepreciationEntryInfo>();
        Iterator it = depEntryCollection.iterator();
        while (it.hasNext()) {
            FaDepreciationEntryInfo depEntry = (FaDepreciationEntryInfo)it.next();
            if (depEntry.getState() == FaDepEntryStatusEnum.YAUDIT_NMODIFY) continue;
            depEntry.setState(FaDepEntryStatusEnum.YAUDIT_NMODIFY);
            cardId.add(depEntry.getFaCurCard().getId());
            depResult.put(depEntry.getFaCurCard().getId(), depEntry);
        }
        if (cardId.size() == 0) {
            throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, FAMAINTAINRESOURCE, "FaDepCalForCoal_NoAuditEntry")));
        }
        FaDepORMapping.undoDepForBalance(ctx, (IObjectValue)period, companyID, depInfo.getId().toString(), true);
        FaDepORMapping.undoDepForCoalCard((IObjectValue)period, companyID, ctx, depInfo.getId().toString(), true);
        FaDepORMapping.undoDeprCountForCoalCard(this.getConnection(ctx), (IObjectValue)period, companyID, ctx, depInfo.getId().toString(), true);
        HashMap<String, Cloneable> param = new HashMap<String, Cloneable>();
        param.put("0", cardId);
        param.put("1", (Cloneable)period);
        param.put("2", depResult);
        this.splitOperation(ctx, OPERATE_AUDIT, true, false, param, cardId.toArray());
        param.clear();
        depInfo.setCheckedStatus(CheckedStatusEnum.AUDITED);
        IFaDepreciation iFaDepreciation = FaDepreciationFactory.getLocalInstance(ctx);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("checkedStatus"));
        iFaDepreciation.submit((CoreBaseInfo)depInfo);
        logger.debug((Object)"auditBill complete");
    }

    private void auditBill(Context ctx, FaCurCardCollection cardCollection, HashMap param) throws BOSException, EASBizException {
        Set cardId = (Set)param.get("0");
        PeriodInfo period = (PeriodInfo)param.get("1");
        HashMap depResult = (HashMap)param.get("2");
        FaAccountBalanceCollection balanceCollection = new FaAccountBalanceCollection();
        HashMap balanceMap = this.getBalanceCollection(ctx, cardId, period);
        Iterator it = cardCollection.iterator();
        while (it.hasNext()) {
            FaCurCardInfo card = (FaCurCardInfo)it.next();
            FaAccountBalanceInfo balance = (FaAccountBalanceInfo)balanceMap.get(card.getId());
            FaDepreciationEntryInfo depEntry = (FaDepreciationEntryInfo)depResult.get(card.getId());
            FaDepLocalUtils.updateCardDep(card, depEntry);
            FaDepLocalUtils.updateBalance(balance, depEntry);
            balanceCollection.add(balance);
        }
        FaDepORMapping.batchUpdateDepForCard(this.getConnection(ctx), (IObjectCollection)cardCollection, true);
        FaDepORMapping.batchUpdateDepForBalance(this.getConnection(ctx), (IObjectCollection)balanceCollection);
    }

    private BigDecimal getPreWellCost(FaDepreciationEntryCollection depEntryCollection, String cardId) {
        BigDecimal result = zeroValue;
        if (depEntryCollection == null || depEntryCollection.size() == 0) {
            return result;
        }
        for (int i = 0; i < depEntryCollection.size(); ++i) {
            FaDepreciationEntryInfo depEntry = depEntryCollection.get(i);
            if (depEntry.getFaCurCard().getId() == null || !depEntry.getFaCurCard().getId().toString().equals(cardId)) continue;
            result = depEntry.getWellCost();
        }
        return result;
    }

    @Override
    protected IObjectValue _calDep(Context ctx, String companyID, PeriodInfo period, BigDecimal fixRatio, BigDecimal workload) throws BOSException, EASBizException {
        boolean alreadyCal;
        FaDepreciationInfo depInfo;
        boolean isAlradyInit = this._isAlreadyInit(ctx, companyID);
        if (!isAlradyInit) {
            IFaDepreciation iFaDepreciation = FaDepreciationFactory.getLocalInstance(ctx);
            depInfo = this.getEmptyDepInfo(ctx, companyID);
            depInfo.setCheckedStatus(CheckedStatusEnum.AUDITED);
            iFaDepreciation.submit((CoreBaseInfo)depInfo);
        }
        if (alreadyCal = this._isAlreadyDep(ctx, companyID, period = FaLocalUtils.getCurrentPeriod(ctx))) {
            this.undoDep(ctx, period, companyID);
        }
        depInfo = this.genNewDepInfo(ctx, period, fixRatio, workload);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("0", fixRatio);
        param.put("1", workload);
        param.put("2", period);
        param.put("3", companyID);
        param.put("4", depInfo);
        boolean flag = this.splitOperation(ctx, OPERATE_DODEP, true, alreadyCal, param, this.getDepCardIds(ctx, true, alreadyCal, companyID));
        param.clear();
        if (!flag) {
            throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, FAMAINTAINRESOURCE, "FaDepCalForCoal_NoCard")));
        }
        return this.getDepCollection(ctx, period, companyID);
    }

    protected boolean splitOperation(Context ctx, int operate, boolean useStatus, boolean alreadyCal, HashMap param, Object[] idSet) throws BOSException, EASBizException {
        boolean result = false;
        if (idSet == null || idSet.length == 0) {
            return result;
        }
        HashSet<Object> set = new HashSet<Object>();
        int aLength = 500;
        EntityViewInfo entityViewInfo = FaDepCalcForCoalFacadeControllerBean.getCoalDepView(ctx, useStatus, alreadyCal);
        FilterInfo filterInfo = new FilterInfo();
        FaCurCardCollection allCardCollection = new FaCurCardCollection();
        for (int i = 0; i < idSet.length / aLength + 1; ++i) {
            set.clear();
            for (int j = 0; j < aLength && i * aLength + j < idSet.length; ++j) {
                set.add(idSet[i * aLength + j]);
            }
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            entityViewInfo.setFilter(filterInfo);
            FaCurCardCollection cardCollection = this.getCardCollection(ctx, alreadyCal, entityViewInfo);
            if (cardCollection == null || cardCollection.size() <= 0) continue;
            if (!result) {
                // empty if block
            }
            result = true;
            if (operate == OPERATE_DODEP) {
                PeriodInfo period = (PeriodInfo)param.get("2");
                allCardCollection.addCollection(cardCollection);
                HashSet<BOSUuid> cardId = new HashSet<BOSUuid>();
                Iterator it = cardCollection.iterator();
                while (it.hasNext()) {
                    FaCurCardInfo curCardInfo = (FaCurCardInfo)it.next();
                    cardId.add(curCardInfo.getId());
                }
                HashMap balanceCollection = this.getBalanceCollection(ctx, cardId, period);
                HashMap bakCardCollection = this.getBakCardCollection(ctx, cardId);
                if (param.get("5") == null) {
                    param.put("5", balanceCollection);
                } else {
                    ((HashMap)param.get("5")).putAll(balanceCollection);
                }
                if (param.get("6") == null) {
                    param.put("6", bakCardCollection);
                } else {
                    ((HashMap)param.get("6")).putAll(bakCardCollection);
                }
            }
            if (operate == OPERATE_AUDIT) {
                this.auditBill(ctx, cardCollection, param);
            }
            if (operate == OPERATE_BUILDINFO) {
                this.getEmptyDepInfo(ctx, cardCollection, param);
            }
            if (operate != OPERATE_PERIODFORWARD) continue;
            result = this.isTiZu(ctx, cardCollection);
        }
        if (result && operate == OPERATE_DODEP) {
            this.doDep(ctx, allCardCollection, param);
        }
        return result;
    }

    protected IObjectPK[] getDepCardIds(Context ctx, boolean useStatus, boolean redoDep, String companyId) throws BOSException, EASBizException {
        IFaCurCard iCurCard = FaCurCardFactory.getLocalInstance(ctx);
        return iCurCard.getPKList(FaDepCalcForCoalFacadeControllerBean.getCoalDepFilter(ctx, useStatus, redoDep, companyId), null);
    }

    @Override
    protected boolean _checkBeforeDep(Context ctx) throws BOSException, EASBizException {
        PeriodInfo period = FaDepLocalUtils.getCurrentPeriod(ctx);
        String companyID = this.getCurCompanyID(ctx);
        this.checkAssetInit(ctx, companyID);
        this.checkAllAudited(ctx, period);
        if (period.isIsAdjustPeriod()) {
            throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"81_FaDepCalExecutor", (Locale)ctx.getOriginLocale())));
        }
        this.checkPeriod(ctx, companyID);
        boolean ifCal = this._isAlreadyDep(ctx, companyID, period);
        if (ifCal) {
            this.checkGenFV(ctx, period, companyID);
        }
        return ifCal;
    }

    @Override
    protected boolean _isAlreadyDep(Context ctx) throws BOSException, EASBizException {
        PeriodInfo period = FaDepLocalUtils.getCurrentPeriod(ctx);
        return this._isAlreadyDep(ctx, this.getCurCompanyID(ctx), period);
    }

    @Override
    protected boolean _isAlreadyDep(Context ctx, String companyID, PeriodInfo periodInfo) throws BOSException, EASBizException {
        if (companyID == null) {
            throw new BOSException("companyID is null");
        }
        IFaDepreciation iDep = FaDepreciationFactory.getLocalInstance(ctx);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("period", (Object)(periodInfo == null ? null : periodInfo.getId().toString()), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("company", (Object)companyID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("depType", (Object)new Integer(1), CompareType.EQUALS));
        return iDep.exists(filterInfo);
    }

    protected boolean _isAlreadyDep(Context ctx, String companyID) throws BOSException, EASBizException {
        if (companyID == null) {
            throw new BOSException("companyID is null");
        }
        IFaDepreciation iDep = FaDepreciationFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("period", null, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)companyID));
        filter.getFilterItems().add(new FilterItemInfo("depType", (Object)new Integer(1)));
        return iDep.exists(filter);
    }

    private HashMap calcDepValue(Context ctx, FaCurCardInfo curCardInfo, BigDecimal depTerm, String quantityScale) throws BOSException, EASBizException {
        BigDecimal wellCost;
        HashMap<Object, BigDecimal> result = new HashMap<Object, BigDecimal>();
        BigDecimal assetValue = curCardInfo.getAssetValue() == null ? zeroValue : curCardInfo.getAssetValue();
        BigDecimal accuDepr = curCardInfo.getAccuDepr() == null ? zeroValue : curCardInfo.getAccuDepr();
        BigDecimal decValue = curCardInfo.getDecValue() == null ? zeroValue : curCardInfo.getDecValue();
        BigDecimal remValue = curCardInfo.getNeatRemValue() == null ? zeroValue : curCardInfo.getNeatRemValue();
        BigDecimal canDepValue = assetValue.subtract(accuDepr).subtract(decValue).subtract(remValue);
        if (canDepValue.compareTo(depTerm) == -1 && canDepValue.compareTo(zeroValue) != -1 && canDepValue.compareTo(zeroValue) != 0) {
            wellCost = depTerm.subtract(canDepValue);
            BigDecimal deprTerm = canDepValue;
            result.put(FaDepreCalculator.FA_DEP_AMOUNT, deprTerm);
            result.put("FWellCost", wellCost);
        } else if (canDepValue.compareTo(zeroValue) == -1 || canDepValue.compareTo(zeroValue) == 0) {
            wellCost = depTerm;
            BigDecimal deprTerm = zeroValue;
            result.put(FaDepreCalculator.FA_DEP_AMOUNT, deprTerm);
            result.put("FWellCost", wellCost);
        } else {
            BigDecimal deprTerm = depTerm;
            BigDecimal wellCost2 = zeroValue;
            result.put(FaDepreCalculator.FA_DEP_AMOUNT, deprTerm);
            result.put("FWellCost", wellCost2);
        }
        BigDecimal depRate = (canDepValue.compareTo(depTerm) == -1 ? canDepValue : depTerm).multiply(new BigDecimal("100.00")).divide(assetValue, Integer.parseInt(quantityScale), 4);
        result.put(FaDepreCalculator.FA_DEP_RATE, depRate);
        return result;
    }

    private void checkAllAudited(Context ctx, PeriodInfo period) throws BOSException, EASBizException {
        FaDepCalExecutor executor = new FaDepCalExecutor();
        if (executor.hasCardNotAudit(ctx, period)) {
            throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, FAMAINTAINRESOURCE, "FaDepCalForCoal_HasNewCardNotAudit")));
        }
        if (executor.hasChangeNotAudit(ctx, period)) {
            throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, FAMAINTAINRESOURCE, "FaDepCalForCoal_HasChgCardNotAudit")));
        }
        if (executor.hasCleanNotAudit(ctx, period)) {
            throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, FAMAINTAINRESOURCE, "FaDepCalForCoal_HasCLrCardNotAudit")));
        }
        FaLocalUtils.hasFANewBiz(ctx, period, false, this.getCurCompanyID(ctx));
    }

    private void checkAssetInit(Context ctx, String companyID) throws BOSException, EASBizException {
        CompanyOrgUnitInfo currentCompany = new CompanyOrgUnitInfo();
        currentCompany.setId(BOSUuid.read((String)companyID));
        boolean isInitEnd = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)currentCompany);
        if (!isInitEnd) {
            throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, FAMAINTAINRESOURCE, "FaDepCal_NotInit")));
        }
    }

    private void checkGenFV(Context ctx, PeriodInfo periodInfo, String companyID) throws BOSException, EASBizException {
        if (periodInfo == null) {
            throw new BOSException("period is null");
        }
        IFaDepreciation iDep = FaDepreciationFactory.getLocalInstance(ctx);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("period", (Object)periodInfo.getId(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("company", (Object)companyID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("depType", (Object)new Integer(1), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("fiVouchered", (Object)"1", CompareType.EQUALS));
        boolean flag = iDep.exists(filterInfo);
        if (flag) {
            throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, FAMAINTAINRESOURCE, "FaDepCal_AlreadyGenVoucher")));
        }
    }

    private Vector distributeDep(FaCurCardInfo card, BigDecimal bDep) {
        int amountScale = 2;
        BigDecimal percent = new BigDecimal("100");
        BigDecimal total = new BigDecimal("0.00");
        Vector<FaDepDistributeInfo> vecReturn = new Vector<FaDepDistributeInfo>();
        FaCurCostCenterCollection costCenterCollection = card.getFaCurCostCenter();
        if (costCenterCollection.size() == 0) {
            return new Vector(0);
        }
        boolean samePercent = true;
        int maxPercentindex = -1;
        int mixSeqIndex = -1;
        Vector<BigDecimal> vecPercent = new Vector<BigDecimal>();
        for (int i = 0; i < costCenterCollection.size(); ++i) {
            FaCurCostCenterInfo costCenterInfo = costCenterCollection.get(i);
            FaDepDistributeInfo distribute = new FaDepDistributeInfo();
            distribute.setId(BOSUuid.create((BOSObjectType)distribute.getBOSType()));
            distribute.setSeq(costCenterInfo.getSeq());
            distribute.setApportionScale(costCenterInfo.getApportionScale());
            distribute.setAccountView(costCenterInfo.getAccountView());
            BigDecimal currentPercent = costCenterInfo.getApportionScale();
            vecPercent.add(currentPercent);
            if (i == 0) {
                maxPercentindex = 0;
                mixSeqIndex = 0;
            } else {
                boolean bl = samePercent = samePercent && currentPercent.compareTo((BigDecimal)vecPercent.get(i - 1)) == 0;
                if (currentPercent.compareTo((BigDecimal)vecPercent.get(maxPercentindex)) == 1) {
                    maxPercentindex = i;
                }
                if (costCenterInfo.getSeq() < costCenterCollection.get(mixSeqIndex).getSeq()) {
                    mixSeqIndex = i;
                }
            }
            BigDecimal amount = bDep.multiply(currentPercent).divide(percent, amountScale, 4);
            distribute.setAmount(amount);
            total = total.add(amount);
            vecReturn.add(distribute);
        }
        if (costCenterCollection.size() == 1) {
            return vecReturn;
        }
        if (total.compareTo(bDep) == 0) {
            return vecReturn;
        }
        if (samePercent) {
            FaDepDistributeInfo distribute = (FaDepDistributeInfo)vecReturn.get(mixSeqIndex);
            distribute.setAmount(bDep.subtract(total.subtract(distribute.getAmount())).setScale(2, 4));
        } else {
            FaDepDistributeInfo distribute = (FaDepDistributeInfo)vecReturn.get(maxPercentindex);
            distribute.setAmount(bDep.subtract(total.subtract(distribute.getAmount())).setScale(2, 4));
        }
        return vecReturn;
    }

    private void doDep(Context ctx, FaCurCardCollection cardCollection, HashMap param) throws BOSException, EASBizException {
        BigDecimal fixRatio = (BigDecimal)param.get("0");
        BigDecimal workload = (BigDecimal)param.get("1");
        PeriodInfo period = (PeriodInfo)param.get("2");
        String companyID = (String)param.get("3");
        FaDepreciationInfo depInfo = (FaDepreciationInfo)param.get("4");
        HashMap balanceCollection = (HashMap)param.get("5");
        HashMap bakCardCollection = (HashMap)param.get("6");
        this.doDep(ctx, fixRatio, workload, cardCollection, period, companyID, depInfo, balanceCollection, bakCardCollection);
    }

    private void filtCardByDepValue(Context ctx, FaCurCardCollection cardCollection) {
        Iterator it1 = cardCollection.iterator();
        while (it1.hasNext()) {
            FaCurCardInfo curCardInfo1 = (FaCurCardInfo)it1.next();
            BigDecimal assetValue = curCardInfo1.getAssetValue() == null ? zeroValue : curCardInfo1.getAssetValue();
            BigDecimal accuDepr = curCardInfo1.getAccuDepr() == null ? zeroValue : curCardInfo1.getAccuDepr();
            BigDecimal decValue = curCardInfo1.getDecValue() == null ? zeroValue : curCardInfo1.getDecValue();
            BigDecimal remValue = curCardInfo1.getNeatRemValue() == null ? zeroValue : curCardInfo1.getNeatRemValue();
            BigDecimal canDepValue = assetValue.subtract(accuDepr).subtract(decValue).subtract(remValue);
            if (canDepValue.compareTo(zeroValue) != 0 && canDepValue.compareTo(zeroValue) != -1) continue;
            it1.remove();
        }
    }

    private BigDecimal ReCalCardNeatValue(Context ctx, FaCurCardCollection cardCollection) {
        Iterator it = cardCollection.iterator();
        BigDecimal totalNeatValue = zeroValue;
        while (it.hasNext()) {
            FaCurCardInfo curCardInfo = (FaCurCardInfo)it.next();
            totalNeatValue = totalNeatValue.add((curCardInfo.getNeatAmt() == null ? zeroValue : curCardInfo.getNeatAmt()).subtract(curCardInfo.getNeatRemValue() == null ? zeroValue : curCardInfo.getNeatRemValue()));
        }
        return totalNeatValue;
    }

    private void doDep(Context ctx, BigDecimal fixRatio, BigDecimal workload, FaCurCardCollection cardCollection, PeriodInfo period, String companyID, FaDepreciationInfo depInfo, HashMap balanceCollection, HashMap bakCardCollection) throws BOSException, EASBizException {
        int depType;
        PeriodInfo prePeriod;
        BigDecimal totalAssetValue = zeroValue;
        BigDecimal assetRatioTotal = zeroValue;
        BigDecimal assetRatio = zeroValue;
        BigDecimal totalNeatValue = zeroValue;
        BigDecimal depTermTotal = zeroValue;
        BigDecimal depTerm = zeroValue;
        Iterator it = cardCollection.iterator();
        while (it.hasNext()) {
            FaCurCardInfo curCardInfo = (FaCurCardInfo)it.next();
            totalAssetValue = totalAssetValue.add(curCardInfo.getAssetValue() == null ? zeroValue : curCardInfo.getAssetValue());
            if ((curCardInfo.getNeatAmt() == null ? zeroValue : curCardInfo.getNeatAmt()).subtract(curCardInfo.getNeatRemValue() == null ? zeroValue : curCardInfo.getNeatRemValue()).compareTo(zeroValue) == -1) continue;
            totalNeatValue = totalNeatValue.add((curCardInfo.getNeatAmt() == null ? zeroValue : curCardInfo.getNeatAmt()).subtract(curCardInfo.getNeatRemValue() == null ? zeroValue : curCardInfo.getNeatRemValue()));
        }
        if (totalNeatValue.compareTo(zeroValue) == 1) {
            this.filtCardByDepValue(ctx, cardCollection);
            totalNeatValue = this.ReCalCardNeatValue(ctx, cardCollection);
        }
        BigDecimal totalCalValue = fixRatio.multiply(workload);
        BigDecimal dispatchAssetValue = zeroValue;
        BigDecimal dispatchNeatValue = zeroValue;
        if (totalNeatValue.compareTo(zeroValue) > 0 && totalCalValue.compareTo(zeroValue) > 0) {
            dispatchAssetValue = zeroValue;
            dispatchNeatValue = totalCalValue;
        } else if (totalNeatValue.compareTo(zeroValue) == 0 || totalNeatValue.compareTo(zeroValue) == -1) {
            dispatchAssetValue = totalCalValue;
            dispatchNeatValue = zeroValue;
        }
        PeriodInfo startPeriod = this.getStartPeriod(ctx, (IObjectPK)new ObjectUuidPK(companyID));
        if (period != null && period.getId() != null && period.getId().equals((Object)startPeriod.getId()) || !this._isAlreadyDep(ctx, companyID)) {
            prePeriod = null;
            depType = 2;
        } else {
            prePeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)period);
            depType = 1;
        }
        FaDepreciationInfo depInfoPrePeriod = (FaDepreciationInfo)this.getDepCollection(ctx, prePeriod, companyID, depType);
        FaDepreciationEntryCollection depEntryCollectionPrePeriod = depInfoPrePeriod.getLnkFaDepreEntry();
        ObjectUuidPK pk = new ObjectUuidPK(this.getCurCompanyID(ctx));
        String quantityScale = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)pk, "FA_007");
        if (quantityScale == null || quantityScale.trim().length() == 0) {
            quantityScale = "6";
        }
        if (depInfo.getLnkFaDepreEntry() != null && depInfo.getLnkFaDepreEntry().size() != 0) {
            depInfo.getLnkFaDepreEntry().clear();
        }
        for (int i = 0; i < cardCollection.size(); ++i) {
            FaCurCardInfo curCardInfo = cardCollection.get(i);
            FaAccountBalanceInfo accountInfo = (FaAccountBalanceInfo)balanceCollection.get(curCardInfo.getId());
            FaBakCardInfo bakCardInfo = (FaBakCardInfo)bakCardCollection.get(curCardInfo.getId());
            if (i == cardCollection.size() - 1) {
                assetRatio = new BigDecimal("1.00").subtract(assetRatioTotal);
                depTerm = dispatchAssetValue.compareTo(zeroValue) > 0 ? totalCalValue.subtract(depTermTotal) : totalCalValue.subtract(depTermTotal);
            } else {
                assetRatio = (curCardInfo.getAssetValue() == null ? zeroValue : curCardInfo.getAssetValue().divide(totalAssetValue, 6, 4)).setScale(4, 4);
                assetRatioTotal = assetRatioTotal.add(assetRatio).setScale(4, 4);
                depTerm = dispatchAssetValue.multiply(curCardInfo.getAssetValue() == null ? zeroValue : curCardInfo.getAssetValue()).divide(totalAssetValue, 6, 4).add(totalNeatValue.compareTo(zeroValue) == 0 ? zeroValue : dispatchNeatValue.multiply((curCardInfo.getNeatAmt() == null ? zeroValue : curCardInfo.getNeatAmt()).subtract(curCardInfo.getNeatRemValue() == null ? zeroValue : curCardInfo.getNeatRemValue())).divide(totalNeatValue, 6, 4)).setScale(2, 4);
                depTermTotal = depTermTotal.add(depTerm);
            }
            HashMap depResult = this.calcDepValue(ctx, curCardInfo, depTerm, quantityScale);
            FaDepreciationEntryInfo entry = this.genNewDepEntryInfo(curCardInfo, depResult, accountInfo);
            entry.setBeginWellCost(this.getPreWellCost(depEntryCollectionPrePeriod, curCardInfo.getId().toString()));
            entry.setAssetRatio(assetRatio.multiply(new BigDecimal("100.00")));
            BigDecimal accuDepr = !curCardInfo.isHasNew() ? accountInfo.getDepreBeginBalanceFor() : bakCardInfo.getAccuDepr();
            accuDepr = accuDepr == null ? zeroValue : accuDepr;
            entry.setEndDepre(accuDepr.add(depResult.get(FaDepreCalculator.FA_DEP_AMOUNT) == null ? zeroValue : (BigDecimal)depResult.get(FaDepreCalculator.FA_DEP_AMOUNT)));
            if (entry != null) {
                entry.setLnkFaDepreEntry(depInfo);
                depInfo.getLnkFaDepreEntry().add(entry);
            }
            Enumeration keys = entry.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if ("monthDepreRate".equalsIgnoreCase(key) || !(entry.get(key) instanceof BigDecimal)) continue;
                if (((BigDecimal)entry.get(key)).compareTo(new BigDecimal("1000000000000000000")) >= 0) {
                    throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, FAMAINTAINRESOURCE, "FaDepCal_NumberTooBig")));
                }
                entry.put(key, ((BigDecimal)entry.get(key)).setScale(2, 4));
            }
        }
        if (depInfo != null && depInfo.getId() != null) {
            this.saveDepInfo(ctx, depInfo);
        } else {
            IFaDepreciation iDep = FaDepreciationFactory.getLocalInstance(ctx);
            iDep.submitSelf((CoreBaseInfo)depInfo);
        }
    }

    private void saveDepInfo(Context ctx, FaDepreciationInfo depInfo) throws BOSException, EASBizException {
        String insertDepHead = "INSERT INTO T_FA_FaDepreciation (FID,FCompanyID,FEffectedStatus,FCheckedStatus,Fperiod,FFiVouchered,FControlUnitID,FFixRatio,FWorkLoad,FDepType) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        String insertLine = "INSERT INTO T_FA_FaDepDistribute (faccountviewid, fseq, fid, fdepentryid, famount,FApportionScale) VALUES (?, ?, ?, ?, ?, ?, ?,?)";
        String insertLineNoAcct = "INSERT INTO T_FA_FaDepDistribute (fseq, fid, fdepentryid, famount) VALUES (?, ?, ?, ?, ?, ?)";
        String insertHead = "INSERT INTO T_FA_FaDepreciationEntry (ffacurcardid, fbegindepre, flnkfadepreentry, fmonthdeprerate, fenddepre, fyearaddupdep, fshoulddepre, fseq, fid, fnotdepre, fdepreciation,fwellCost,FBeginWellCost, fstate,FAssetRatio) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? , ?, ?, ?, ?)";
        String insertAssetActComLine = "INSERT INTO T_FA_FaDepAsstActComposit (fid,fbillid,fseq,FAsstActTypeID,FAsstActItem) VALUES (?,?,?,?,?)";
        ArrayList<Object> depCompPara = new ArrayList<Object>();
        ArrayList<Object> depHeadPara = new ArrayList<Object>();
        ArrayList<Object> linePara = new ArrayList<Object>();
        ArrayList<Object> headPara = new ArrayList<Object>();
        if (depInfo.getId() == null) {
            depInfo.setId(BOSUuid.create((BOSObjectType)depInfo.getBOSType()));
            depHeadPara.add(depInfo.getId().toString());
            depHeadPara.add(depInfo.getCompany().getId().toString());
            depHeadPara.add(new Integer(depInfo.getEffectedStatus().getValue()));
            depHeadPara.add(new Integer(depInfo.getCheckedStatus().getValue()));
            depHeadPara.add(depInfo.getPeriod().getId().toString());
            depHeadPara.add(new Integer(depInfo.isFiVouchered() ? 1 : 0));
            depHeadPara.add(depInfo.getCompany().getId().toString());
            depHeadPara.add(depInfo.getFixRatio());
            depHeadPara.add(depInfo.getWorkLoad());
            depHeadPara.add(new Integer(depInfo.getDepType().getValue()));
            DbUtil.execute((Context)ctx, (String)insertDepHead, (Object[])depHeadPara.toArray());
        }
        int size1 = depInfo.getLnkFaDepreEntry().size();
        for (int i = 0; i < size1; ++i) {
            headPara.clear();
            FaDepreciationEntryInfo depEntry = depInfo.getLnkFaDepreEntry().get(i);
            depEntry.setId(BOSUuid.create((BOSObjectType)depEntry.getBOSType()));
            headPara.add(depEntry.getFaCurCard().getId().toString());
            headPara.add(depEntry.getBeginDepre());
            headPara.add(depInfo.getId().toString());
            headPara.add(depEntry.getMonthDepreRate());
            headPara.add(depEntry.getEndDepre());
            headPara.add(depEntry.getYearAddUpDep());
            headPara.add(depEntry.getShouldDepre());
            headPara.add(new Integer(depEntry.getSeq()));
            headPara.add(depEntry.getId().toString());
            headPara.add(depEntry.getNotDepre());
            headPara.add(depEntry.getDepreciation());
            headPara.add(depEntry.getWellCost());
            headPara.add(depEntry.getBeginWellCost());
            headPara.add(new Integer(depEntry.getState().getValue()));
            headPara.add(depEntry.getAssetRatio());
            DbUtil.execute((Context)ctx, (String)insertHead, (Object[])headPara.toArray());
            int size2 = depEntry.getDepDistribute().size();
            for (int j = 0; j < size2; ++j) {
                linePara.clear();
                FaDepDistributeInfo distribute = depEntry.getDepDistribute().get(j);
                distribute.setId(BOSUuid.create((BOSObjectType)distribute.getBOSType()));
                if (distribute.getAccountView() != null) {
                    linePara.add(distribute.getAccountView().getId().toString());
                }
                linePara.add(new Integer(distribute.getSeq()));
                linePara.add(distribute.getId().toString());
                linePara.add(depEntry.getId().toString());
                linePara.add(distribute.getAmount());
                linePara.add(distribute.getApportionScale());
                DbUtil.execute((Context)ctx, (String)(distribute.getAccountView() != null ? insertLine : insertLineNoAcct), (Object[])linePara.toArray());
                int size3 = distribute.getDepAsstActComposit().size();
                for (int k = 0; k < size3; ++k) {
                    depCompPara.clear();
                    FaDepAsstActCompositInfo actCompositInfo = distribute.getDepAsstActComposit().get(k);
                    depCompPara.add(BOSUuid.create((BOSObjectType)actCompositInfo.getBOSType()).toString());
                    depCompPara.add(distribute.getId().toString());
                    depCompPara.add(new Integer(actCompositInfo.getSeq()));
                    depCompPara.add(actCompositInfo.getAsstActType().getId().toString());
                    depCompPara.add(actCompositInfo.getAsstActItem());
                    DbUtil.execute((Context)ctx, (String)insertAssetActComLine, (Object[])depCompPara.toArray());
                }
            }
        }
    }

    private FaDepreciationEntryInfo genNewDepEntryInfo(FaCurCardInfo card, HashMap depResult, FaAccountBalanceInfo accountInfo) throws BOSException {
        FaDepreciationEntryInfo detail = new FaDepreciationEntryInfo();
        if (accountInfo == null) {
            throw new IllegalArgumentException("specify FaAccountBalanceInfo was null");
        }
        detail.setWellCost(depResult.get("FWellCost") != null ? (BigDecimal)depResult.get("FWellCost") : zeroValue);
        detail.setFaCurCard(card);
        detail.setBeginDepre(accountInfo.getDepreBeginBalanceFor());
        detail.setShouldDepre(detail.getWellCost().add(depResult.get(FaDepreCalculator.FA_DEP_AMOUNT) == null ? zeroValue : (BigDecimal)depResult.get(FaDepreCalculator.FA_DEP_AMOUNT)));
        detail.setDepreciation(detail.getShouldDepre());
        BigDecimal accuDepr = accountInfo.getDepreBeginBalanceFor() == null ? zeroValue : accountInfo.getDepreBeginBalanceFor();
        detail.setEndDepre(accuDepr.add(depResult.get(FaDepreCalculator.FA_DEP_AMOUNT) == null ? zeroValue : (BigDecimal)depResult.get(FaDepreCalculator.FA_DEP_AMOUNT)));
        BigDecimal neatAmt = card.getNeatAmt() == null ? zeroValue : card.getNeatAmt();
        BigDecimal neatRemValue = card.getNeatRemValue() == null ? zeroValue : card.getNeatRemValue();
        detail.setNotDepre(neatAmt.subtract(neatRemValue).subtract(depResult.get(FaDepreCalculator.FA_DEP_AMOUNT) == null ? zeroValue : (BigDecimal)depResult.get(FaDepreCalculator.FA_DEP_AMOUNT)));
        BigDecimal yearDep = accountInfo.getAddUpYearDepre() == null ? zeroValue : accountInfo.getAddUpYearDepre();
        detail.setYearAddUpDep(yearDep.add(detail.getDepreciation()));
        detail.setMonthDepreRate(depResult.get(FaDepreCalculator.FA_DEP_RATE) == null ? zeroValue : depResult.get(FaDepreCalculator.FA_DEP_RATE));
        Vector vec = detail.getDepreciation().subtract(detail.getWellCost()).compareTo(zeroValue) == 0 ? new Vector() : this.distributeDep(card, detail.getDepreciation().subtract(detail.getWellCost()));
        detail.setState(FaDepEntryStatusEnum.NAUDIT_NMODIFY);
        for (int i = 0; i < vec.size(); ++i) {
            FaDepDistributeInfo distribute = (FaDepDistributeInfo)vec.get(i);
            distribute.setDepEntry(detail);
            detail.getDepDistribute().add(distribute);
            Vector vec2 = this.distributeDep(card, distribute);
            for (int j = 0; j < vec2.size(); ++j) {
                FaDepAsstActCompositInfo compositInfo = (FaDepAsstActCompositInfo)vec2.get(j);
                compositInfo.setBillid(distribute);
                distribute.getDepAsstActComposit().add(compositInfo);
            }
        }
        return detail;
    }

    private Vector distributeDep(FaCurCardInfo card, FaDepDistributeInfo dis) {
        Vector<FaDepAsstActCompositInfo> vecReturn = new Vector<FaDepAsstActCompositInfo>();
        FaCurCostCenterCollection costCenterCollection = card.getFaCurCostCenter();
        if (costCenterCollection.size() == 0) {
            return new Vector(0);
        }
        for (int i = 0; i < costCenterCollection.size(); ++i) {
            FaCurCostCenterInfo costCenterInfo = costCenterCollection.get(i);
            if (dis.getAccountView() == null || costCenterInfo.getAccountView() == null || !dis.getAccountView().getId().equals((Object)costCenterInfo.getAccountView().getId()) || dis.getSeq() != costCenterInfo.getSeq()) continue;
            FaCurAsstActCompositCollection asstActCompositCollection = costCenterInfo.getFaCurAsstActComposit();
            for (int j = 0; j < asstActCompositCollection.size(); ++j) {
                FaCurAsstActCompositInfo asstActCompositInfo = asstActCompositCollection.get(j);
                FaDepAsstActCompositInfo distribute = new FaDepAsstActCompositInfo();
                distribute.setId(BOSUuid.create((BOSObjectType)distribute.getBOSType()));
                distribute.setSeq(asstActCompositInfo.getSeq());
                distribute.setAsstActType(asstActCompositInfo.getAsstActType());
                distribute.setAsstActItem(asstActCompositInfo.getAsstActItem().getId().toString());
                vecReturn.add(distribute);
            }
        }
        return vecReturn;
    }

    private FaDepreciationInfo genNewDepInfo(Context ctx, PeriodInfo period, BigDecimal fixRatio, BigDecimal workload) throws BOSException, EASBizException {
        FaDepreciationInfo depInfo = null;
        depInfo = new FaDepreciationInfo();
        depInfo.setPeriod(period);
        depInfo.setCompany(ContextUtil.getCurrentFIUnit((Context)ctx));
        depInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        depInfo.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        depInfo.setFiVouchered(false);
        depInfo.setDepType(FaDepType.Dep_Coal);
        depInfo.setFixRatio(fixRatio);
        depInfo.setWorkLoad(workload);
        depInfo.setBizDate(FaLocalUtils.getBizDate(ctx, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString()));
        return depInfo;
    }

    private HashMap getBalanceCollection(Context ctx, Set cardCollection, PeriodInfo period) throws BOSException, EASBizException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().add(new SelectorItemInfo("*"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("faCurCard.id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)period.getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("faCurCard", (Object)cardCollection, CompareType.INCLUDE));
        entityViewInfo.setFilter(filter);
        FaAccountBalanceCollection balanceCollection = FaDepLocalUtils.getBalanceCollection(ctx, entityViewInfo);
        Iterator itBalance = balanceCollection.iterator();
        HashMap<BOSUuid, FaAccountBalanceInfo> hmBalance = new HashMap<BOSUuid, FaAccountBalanceInfo>();
        while (itBalance.hasNext()) {
            FaAccountBalanceInfo balance = (FaAccountBalanceInfo)itBalance.next();
            hmBalance.put(balance.getFaCurCard().getId(), balance);
        }
        return hmBalance;
    }

    private HashMap getBakCardCollection(Context ctx, Set cardCollection) throws BOSException, EASBizException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().add(new SelectorItemInfo("accuDepr"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("faCurCard.id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billType", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("faCurCard", (Object)cardCollection, CompareType.INCLUDE));
        entityViewInfo.setFilter(filter);
        IFaBakCard bakCard = FaBakCardFactory.getLocalInstance(ctx);
        FaBakCardCollection bakCardCollection = bakCard.getFaBakCardCollection(entityViewInfo);
        Iterator itBalance = bakCardCollection.iterator();
        HashMap<BOSUuid, FaBakCardInfo> hmBalance = new HashMap<BOSUuid, FaBakCardInfo>();
        while (itBalance.hasNext()) {
            FaBakCardInfo balance = (FaBakCardInfo)itBalance.next();
            hmBalance.put(balance.getFaCurCard().getId(), balance);
        }
        return hmBalance;
    }

    private static FilterInfo getCoalDepFilter(Context ctx, boolean useStatus, boolean redoDep, String strCompanyOrgUnitInfoID) throws EASBizException, BOSException {
        FilterInfo filterInfo = FaDepLocalUtils.getDepCardFilter(ctx, false, strCompanyOrgUnitInfoID);
        for (int i = filterInfo.getFilterItems().size() - 1; i >= 0; --i) {
            String tmpStr = filterInfo.getFilterItems().get(i).getPropertyName();
            if ((useStatus || !tmpStr.equalsIgnoreCase("useStatus.isDepreciation")) && !tmpStr.equalsIgnoreCase("assetCat.DepreciationPolicy.DeprRule")) continue;
            filterInfo.getFilterItems().removeObject(i);
        }
        String mask = "";
        for (int i = 0; i < filterInfo.getFilterItems().size() - 4; ++i) {
            mask = mask + (i == 0 ? "#0" : " and #" + i);
        }
        mask = mask + " and (#" + (filterInfo.getFilterItems().size() - 4) + " or (#" + (filterInfo.getFilterItems().size() - 3) + " and #" + (filterInfo.getFilterItems().size() - 2) + "))";
        mask = mask + " and (#" + (filterInfo.getFilterItems().size() - 1) + ")";
        filterInfo.getFilterItems().add(new FilterItemInfo("deprMethod.number", (Object)"006"));
        filterInfo.setMaskString(mask + " and #" + (filterInfo.getFilterItems().size() - 1));
        return filterInfo;
    }

    private static EntityViewInfo getCoalDepView(Context ctx, boolean useStatus, boolean redoDep) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().addObjectCollection((IObjectCollection)FaDepLocalUtils.getDepCardSelector());
        entityViewInfo.getSelector().add(new SelectorItemInfo("specs"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("deletedStatus"));
        return entityViewInfo;
    }

    private FaCurCardCollection getCardCollection(Context ctx, boolean redoDep, EntityViewInfo entityViewInfo) throws BOSException, EASBizException {
        IFaCurCard iCurCard = FaCurCardFactory.getLocalInstance(ctx);
        FaCurCardCollection cardCollection = iCurCard.getFaCurCardCollection(entityViewInfo);
        if (cardCollection == null || cardCollection.size() == 0) {
            return new FaCurCardCollection();
        }
        this.filteCard(ctx, cardCollection, redoDep);
        return cardCollection;
    }

    private void filteCard(Context ctx, FaCurCardCollection cardCollection, boolean redoDep) throws BOSException, EASBizException {
        for (int i = cardCollection.size() - 1; i >= 0; --i) {
            FaCurCardInfo card = cardCollection.get(i);
            if (card.getLeaseStatus().getValue() == 2) {
                cardCollection.removeObject(i);
                continue;
            }
            if (card.getHasCleared().getValue() == 2) {
                cardCollection.removeObject(i);
                continue;
            }
            if (card.getDeletedStatus() == DeletedStatusEnum.NORMAL) continue;
            cardCollection.removeObject(i);
        }
    }

    private String getCurCompanyID(Context ctx) {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        String strCompanyID = aCompanyOrgUnitInfo.getId().toString();
        return strCompanyID != null && !"".equals(strCompanyID) ? strCompanyID : "";
    }

    private IObjectValue getDepCollection(Context ctx, PeriodInfo periodInfo, String companyID) throws BOSException, EASBizException {
        return this.getDepCollection(ctx, periodInfo, companyID, FaDepCalcForCoalFacadeControllerBean.getDepFullSelector());
    }

    private IObjectValue getDepCollection(Context ctx, PeriodInfo periodInfo, String companyID, int depType) throws BOSException, EASBizException {
        return this.getDepCollection(ctx, periodInfo, companyID, FaDepCalcForCoalFacadeControllerBean.getDepFullSelector(), depType);
    }

    private static SelectorItemCollection getDepDefaultSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("lnkFaDepreEntry.*"));
        return sic;
    }

    private static SelectorItemCollection getDepFullSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("lnkFaDepreEntry.*"));
        sic.add(new SelectorItemInfo("period.*"));
        sic.add(new SelectorItemInfo("lnkFaDepreEntry.depDistribute.*"));
        sic.add(new SelectorItemInfo("lnkFaDepreEntry.depDistribute.accountView.*"));
        sic.add(new SelectorItemInfo("lnkFaDepreEntry.faCurCard.*"));
        sic.add(new SelectorItemInfo("lnkFaDepreEntry.faCurCard.assetCat.*"));
        sic.add(new SelectorItemInfo("lnkFaDepreEntry.faCurCard.deprMethod.*"));
        return sic;
    }

    private IObjectValue getDepCollection(Context ctx, PeriodInfo periodInfo, String companyID, SelectorItemCollection sic) throws BOSException, EASBizException {
        return this.getDepCollection(ctx, periodInfo, companyID, sic, 1);
    }

    private IObjectValue getDepCollection(Context ctx, PeriodInfo periodInfo, String companyID, SelectorItemCollection sic, int depType) throws BOSException, EASBizException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().addObjectCollection((IObjectCollection)sic);
        FilterInfo filterInfo = new FilterInfo();
        if (periodInfo != null && periodInfo.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("period", (Object)periodInfo.getId().toString(), CompareType.EQUALS));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("company", (Object)companyID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("depType", (Object)new Integer(depType), CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        IFaDepreciation iFaDepreciation = FaDepreciationFactory.getLocalInstance(ctx);
        FaDepreciationCollection depCollection = iFaDepreciation.getFaDepreciationCollection(entityViewInfo);
        if (depCollection == null || depCollection.get(0) == null) {
            return new FaDepreciationInfo();
        }
        return depCollection.get(0);
    }

    private String getResource(Context ctx, String s1, String s2) {
        Locale l = ctx.getOriginLocale();
        return ResourceBase.getString((String)s1, (String)s2, (Locale)l);
    }

    private void undoDep(Context ctx, PeriodInfo periodInfo, String companyID) throws BOSException, EASBizException {
        FaDepreciationInfo depInfo = (FaDepreciationInfo)this.getDepCollection(ctx, periodInfo, companyID, FaDepCalcForCoalFacadeControllerBean.getDepDefaultSelector());
        this.undoDep(ctx, periodInfo, companyID, depInfo, 1);
    }

    @Override
    protected void _undoDep(Context ctx, String companyID) throws BOSException, EASBizException {
        FaDepreciationInfo initDepInfo;
        PeriodInfo periodInfo = FaDepLocalUtils.getCurrentPeriod(ctx);
        FaDepreciationInfo depInfo = (FaDepreciationInfo)this.getDepCollection(ctx, periodInfo, companyID, FaDepCalcForCoalFacadeControllerBean.getDepDefaultSelector());
        this.undoDep(ctx, periodInfo, companyID, depInfo, 1);
        if (!this._isAlreadyDep(ctx, companyID) && (initDepInfo = (FaDepreciationInfo)this.getDepCollection(ctx, null, companyID, FaDepCalcForCoalFacadeControllerBean.getDepDefaultSelector(), 2)).getPeriod() != null && initDepInfo.getPeriod().getId().equals((Object)periodInfo.getId())) {
            this.deleteDepInfo(ctx, initDepInfo);
        }
    }

    private void undoDep(Context ctx, PeriodInfo periodInfo, String companyID, FaDepreciationInfo depInfo, int type) throws BOSException, EASBizException {
        if (depInfo == null || depInfo.getId() == null) {
            return;
        }
        if (depInfo.isFiVouchered()) {
            throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, FAMAINTAINRESOURCE, "FaUndoDepCal_AlreadyGenVoucher")));
        }
        if (type == 1) {
            FaDepORMapping.undoDepForBalance(ctx, (IObjectValue)periodInfo, companyID, depInfo.getId().toString(), false);
            FaDepORMapping.undoDepForCoalCard((IObjectValue)periodInfo, companyID, ctx, depInfo.getId().toString(), false);
            FaDepORMapping.undoDeprCountForCoalCard(this.getConnection(ctx), (IObjectValue)periodInfo, companyID, ctx, depInfo.getId().toString(), false);
        }
        this.deleteDepInfo(ctx, depInfo);
    }

    protected void deleteDepInfo(Context ctx, FaDepreciationInfo depInfo) throws BOSException, EASBizException {
        String deleteHead = "delete from t_fa_fadepreciation where fid ='" + depInfo.getId().toString() + "'";
        String deleteLine = "delete from t_fa_fadepreciationentry where flnkfadepreentry='" + depInfo.getId().toString() + "'";
        String deleteLineLine = "delete from T_FA_FaDepDistribute where fdepentryid in (select fid from t_fa_fadepreciationentry where flnkfadepreentry='" + depInfo.getId().toString() + "')";
        String deleteLineDepComposit = "delete from T_FA_FaDepAsstActComposit where fbillid  in ( select fid from T_FA_FaDepDistribute where fdepentryid in (select fid from t_fa_fadepreciationentry where flnkfadepreentry='" + depInfo.getId().toString() + "'))";
        DbUtil.execute((Context)ctx, (String)deleteLineDepComposit);
        DbUtil.execute((Context)ctx, (String)deleteLineLine);
        DbUtil.execute((Context)ctx, (String)deleteLine);
        DbUtil.execute((Context)ctx, (String)deleteHead);
    }

    @Override
    protected boolean _checkBeforePeriodForward(Context ctx, String companyID) throws BOSException, EASBizException {
        FaDepreciationInfo depInfo;
        PeriodInfo periodInfo = FaLocalUtils.getCurrentPeriod(ctx, companyID);
        if (periodInfo.isIsAdjustPeriod()) {
            return false;
        }
        if (periodInfo != null) {
            String initSQL = "SELECT count(fid) as COUNT FROM t_fa_fadepreciation WHERE fcheckedstatus != ? AND fdeptype = ? AND fcompanyid = ? AND fperiod = ?";
            Object[] sqlPara = new Object[]{new Integer(2), new Integer(2), companyID, periodInfo.getId().toString()};
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)initSQL, (Object[])sqlPara);
                if (rowSet.next() && rowSet.getInt("COUNT") > 0) {
                    throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, FAMAINTAINRESOURCE, "FaDepCalForCoal_SaveNoInit")));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if ((depInfo = (FaDepreciationInfo)this.getDepCollection(ctx, periodInfo, companyID, FaDepCalcForCoalFacadeControllerBean.getDepDefaultSelector())) == null || depInfo.getId() == null) {
            boolean flag = this.splitOperation(ctx, OPERATE_PERIODFORWARD, true, false, null, this.getDepCardIds(ctx, true, false, companyID));
            if (flag) {
                throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, FAMAINTAINRESOURCE, "FaDepCalForCoal_NoDep")));
            }
            return false;
        }
        FaDepreciationEntryCollection entryCol = depInfo.getLnkFaDepreEntry();
        for (int i = 0; i < entryCol.size(); ++i) {
            FaDepreciationEntryInfo depEntry = entryCol.get(i);
            if (depEntry.getState() == FaDepEntryStatusEnum.YAUDIT_NMODIFY) continue;
            throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, FAMAINTAINRESOURCE, "FaDepCalForCoal_NoAudit")));
        }
        return true;
    }

    @Override
    protected boolean _checkBeforePeriodBack(Context ctx, String companyID) throws BOSException, EASBizException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IObjectCollection _getDeprCollection(Context ctx, String bosType, EntityViewInfo view) throws BOSException, EASBizException {
        Connection cn = super.getConnection(ctx);
        try {
            IObjectCollection billObjectColl;
            BOSObjectType bosObjectType = new BOSObjectType(bosType);
            ORMappingDAO ormappingDAO = new ORMappingDAO(bosObjectType, ctx, cn);
            IObjectCollection iObjectCollection = billObjectColl = ormappingDAO.getCollection(view);
            return iObjectCollection;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    @Override
    protected void _doInit(Context ctx) throws BOSException, EASBizException {
        String companyID = this.getCurCompanyID(ctx);
        this._hasNewBiz(ctx, companyID);
        FaDepreciationInfo depInfo = (FaDepreciationInfo)this.getDepCollection(ctx, null, companyID, FaDepCalcForCoalFacadeControllerBean.getDepDefaultSelector(), 2);
        depInfo.setCheckedStatus(CheckedStatusEnum.AUDITED);
        depInfo.setPeriod(FaDepLocalUtils.getCurrentPeriod(ctx));
        IFaDepreciation iFaDepreciation = FaDepreciationFactory.getLocalInstance(ctx);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("checkedStatus"));
        selector.add(new SelectorItemInfo("period"));
        if (depInfo.getId() == null) {
            IObjectPK pk = iFaDepreciation.addnew((CoreBaseInfo)depInfo);
            depInfo.setId(BOSUuid.read((String)pk.toString()));
        }
        iFaDepreciation.updatePartial((CoreBaseInfo)depInfo, selector);
    }

    @Override
    protected void _undoInit(Context ctx) throws BOSException, EASBizException {
        String companyID = this.getCurCompanyID(ctx);
        this._hasNewBiz(ctx, companyID);
        PeriodInfo curPeriod = FaDepLocalUtils.getCurrentPeriod(ctx);
        FaDepreciationInfo depInfo = (FaDepreciationInfo)this.getDepCollection(ctx, null, companyID, FaDepCalcForCoalFacadeControllerBean.getDepDefaultSelector(), 2);
        if (depInfo == null || depInfo.getId() == null) {
            throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, FAMAINTAINRESOURCE, "FaDepInitForCoal_NoInitForUnInit")));
        }
        if (depInfo.getPeriod() != null && !depInfo.getPeriod().getId().equals((Object)curPeriod.getId())) {
            throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, FAMAINTAINRESOURCE, "FaDepInitForCoal_PeriodErrorForUnInit")));
        }
        depInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        IFaDepreciation iFaDepreciation = FaDepreciationFactory.getLocalInstance(ctx);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("checkedStatus"));
        iFaDepreciation.updatePartial((CoreBaseInfo)depInfo, selector);
    }

    @Override
    protected boolean _isAlreadyInit(Context ctx, String companyID) throws BOSException, EASBizException {
        if (companyID == null) {
            throw new BOSException("companyID is null");
        }
        IFaDepreciation iDep = FaDepreciationFactory.getLocalInstance(ctx);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("company", (Object)companyID));
        filterInfo.getFilterItems().add(new FilterItemInfo("depType", (Object)new Integer(2)));
        return iDep.exists(filterInfo);
    }

    @Override
    protected boolean _isNeedInit(Context ctx, String companyID) throws BOSException, EASBizException {
        boolean isAlreadyAudit = false;
        if (companyID == null) {
            throw new BOSException("companyID is null");
        }
        IFaDepreciation iDep = FaDepreciationFactory.getLocalInstance(ctx);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("company", (Object)companyID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("depType", (Object)new Integer(2), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)CheckedStatusEnum.AUDITED, CompareType.EQUALS));
        isAlreadyAudit = iDep.exists(filterInfo);
        return !isAlreadyAudit && this.hasDepFullCard(ctx, companyID);
    }

    private boolean hasDepFullCard(Context ctx, String companyID) throws BOSException, EASBizException {
        boolean result = false;
        StringBuffer sql = new StringBuffer("SELECT * FROM T_FA_FACURCARD FACURCARD INNER JOIN T_FA_DepreciationMode DEPRMETHOD ON FACURCARD.FDeprMethodID = DEPRMETHOD.FID INNER JOIN T_FA_Cat ASSETCAT ON FACURCARD.FAssetCatID = ASSETCAT.FID INNER JOIN T_FA_UseStatus USESTATUS ON FACURCARD.FUseStatusID = USESTATUS.FID INNER JOIN T_FA_DepreciationPolicy DEPRECIATIONPOLICY ON ASSETCAT.FDepreciationPolicyID = DEPRECIATIONPOLICY.FID");
        sql.append(" WHERE (FACURCARD.FAssetValue - FACURCARD.FAccuDepr - FACURCARD.FNeatRemValue - FACURCARD.FDecValue)=0 ");
        sql.append("AND FACURCARD.FEffectedStatus=2 AND FACURCARD.FHasDisabled=0 AND FACURCARD.FCheckedStatus=2 ");
        sql.append("AND FACURCARD.FBlockedStatus=1 AND FACURCARD.FDeprMethodID IS NOT NULL ");
        sql.append("AND (DEPRECIATIONPOLICY.FDeprRule=0 OR (DEPRECIATIONPOLICY.FDeprRule=1 AND USESTATUS.FIsDepreciation=1)) ");
        sql.append("AND DEPRMETHOD.FNumber='006' AND USESTATUS.FIsDepreciation=1 AND FACURCARD.FCOMPANYID='" + companyID + "' ");
        sql.append("AND (FACURCARD.FOriginFlag=0 OR FACURCARD.FHASNEW=0) ");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet.next()) {
                return true;
            }
            logger.debug((Object)sql.toString());
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private PeriodInfo getStartPeriod(Context ctx, IObjectPK companyPK) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = null;
        PeriodInfo startPeriod = null;
        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        ISystemStatusCtrol ictrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        company = iCompanyOrgUnit.getCompanyOrgUnitInfo(companyPK);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("systemStatus.name", (Object)new Integer(SystemEnum.FIXEDASSETS.getValue())));
        fic.add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("startPeriod.periodYear"));
        sic.add(new SelectorItemInfo("startPeriod.periodNumber"));
        sic.add(new SelectorItemInfo("startPeriod.beginDate"));
        sic.add(new SelectorItemInfo("startPeriod.endDate"));
        sic.add(new SelectorItemInfo("startPeriod.periodType.*"));
        SystemStatusCtrolCollection col = ictrol.getSystemStatusCtrolCollection(view);
        startPeriod = col.size() > 0 ? col.get(0).getStartPeriod() : null;
        return startPeriod;
    }

    public static boolean hasNewCard(Context ctx, PeriodInfo period, String companyID) throws BOSException, EASBizException {
        IFaCurCard icard = FaCurCardFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)period.getId()));
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)companyID));
        filter.getFilterItems().add(new FilterItemInfo("originFlag", (Object)FaCardOriginEnum.INITIAL, CompareType.NOTEQUALS));
        return icard.exists(filter);
    }

    public boolean hasChangeCard(Context ctx, PeriodInfo period, String companyID) throws BOSException, EASBizException {
        IFaChangeBill ichange = FaChangeBillFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)period.getId()));
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)companyID));
        return ichange.exists(filter);
    }

    public boolean hasCleanCard(Context ctx, PeriodInfo period, String companyID) throws BOSException, EASBizException {
        IFaClearBill iclean = FaClearBillFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)period.getId()));
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)companyID));
        return iclean.exists(filter);
    }

    public boolean hasFABiz(Context ctx, PeriodInfo period, String companyID) throws BOSException, EASBizException {
        IFaBillBase[] faBizInterface = FaLocalUtils.getFABizInterface(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)period.getId()));
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)companyID));
        int size = faBizInterface.length;
        for (int i = 0; i < size; ++i) {
            if (faBizInterface[i] == null || !faBizInterface[i].exists(filter)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void _hasNewBiz(Context ctx, String companyID) throws BOSException, EASBizException {
        PeriodInfo curPeriod = FaDepLocalUtils.getCurrentPeriod(ctx);
        if (this._isAlreadyDep(ctx, companyID)) {
            throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, FAMAINTAINRESOURCE, "FaDepInitForCoal_DepAlready")));
        }
        if (FaDepCalcForCoalFacadeControllerBean.hasNewCard(ctx, curPeriod, companyID) || this.hasChangeCard(ctx, curPeriod, companyID) || this.hasCleanCard(ctx, curPeriod, companyID) || this.hasFABiz(ctx, curPeriod, companyID)) {
            throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, FAMAINTAINRESOURCE, "FaDepInitForCoal_HasBiz")));
        }
    }

    @Override
    protected FaDepreciationInfo _getInitDepInfo(Context ctx, String companyID, boolean isInit) throws BOSException, EASBizException {
        return isInit ? this.getSavedDepInfo(ctx, companyID) : this.getEmptyDepInfo(ctx, companyID);
    }

    protected FaDepreciationInfo getSavedDepInfo(Context ctx, String companyID) throws BOSException, EASBizException {
        return (FaDepreciationInfo)this.getDepCollection(ctx, null, companyID, 2);
    }

    protected FaDepreciationInfo getEmptyDepInfo(Context ctx, String companyID) throws BOSException, EASBizException {
        FaDepreciationInfo depInfo = new FaDepreciationInfo();
        depInfo.setPeriod(FaDepLocalUtils.getCurrentPeriod(ctx));
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyID));
        depInfo.setCompany(company);
        depInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        depInfo.setFiVouchered(true);
        depInfo.setDepType(FaDepType.Dep_CoalInit);
        depInfo.setFixRatio(zeroValue);
        depInfo.setWorkLoad(zeroValue);
        depInfo.setBizDate(FaLocalUtils.getBizDate(ctx, companyID));
        HashMap<String, FaDepreciationInfo> param = new HashMap<String, FaDepreciationInfo>();
        param.put("0", depInfo);
        this.splitOperation(ctx, OPERATE_BUILDINFO, false, false, param, this.getDepCardIds(ctx, false, false, companyID));
        param.clear();
        return depInfo;
    }

    protected void getEmptyDepInfo(Context ctx, FaCurCardCollection cardCollection, HashMap param) throws BOSException, EASBizException {
        FaDepreciationInfo depInfo = (FaDepreciationInfo)param.get("0");
        for (int i = 0; i < cardCollection.size(); ++i) {
            FaDepreciationEntryInfo entry;
            FaCurCardInfo curCardInfo = cardCollection.get(i);
            if (curCardInfo.isHasNew() || (entry = this.genNewDepEntryInfo(curCardInfo)) == null) continue;
            entry.setLnkFaDepreEntry(depInfo);
            depInfo.getLnkFaDepreEntry().add(entry);
        }
    }

    protected Boolean isTiZu(Context ctx, FaCurCardCollection cardCollection) throws BOSException, EASBizException {
        boolean result = false;
        for (int i = 0; i < cardCollection.size(); ++i) {
            FaCurCardInfo curCardInfo = cardCollection.get(i);
            BigDecimal assetValue = curCardInfo.getAssetValue() == null ? zeroValue : curCardInfo.getAssetValue();
            BigDecimal accuDepr = curCardInfo.getAccuDepr() == null ? zeroValue : curCardInfo.getAccuDepr();
            BigDecimal decValue = curCardInfo.getDecValue() == null ? zeroValue : curCardInfo.getDecValue();
            BigDecimal remValue = curCardInfo.getNeatRemValue() == null ? zeroValue : curCardInfo.getNeatRemValue();
            BigDecimal canDepValue = assetValue.subtract(accuDepr).subtract(decValue).subtract(remValue);
            if (canDepValue.compareTo(zeroValue) != 0) {
                result = true;
                break;
            }
            result = false;
        }
        return result;
    }

    private FaDepreciationEntryInfo genNewDepEntryInfo(FaCurCardInfo card) throws BOSException, EASBizException {
        FaDepreciationEntryInfo detail = new FaDepreciationEntryInfo();
        detail.setWellCost(zeroValue);
        detail.setBeginWellCost(zeroValue);
        detail.setFaCurCard(card);
        detail.setBeginDepre(card.getAccuDepr());
        detail.setShouldDepre(zeroValue);
        detail.setDepreciation(zeroValue);
        detail.setEndDepre(card.getAccuDepr());
        detail.setNotDepre(zeroValue);
        detail.setYearAddUpDep(card.getAccuDeprTYear());
        detail.setMonthDepreRate(zeroValue);
        detail.setState(FaDepEntryStatusEnum.NAUDIT_NMODIFY);
        return detail;
    }

    @Override
    protected void _checkBeforeSubmit(Context ctx, String periodID, IObjectCollection cardCollection) throws BOSException, EASBizException {
        if (periodID == null || cardCollection == null || cardCollection.size() == 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT COUNT (a.fid) AS COUNT, 'CLEARBILL' AS BillType\n");
        sb.append("  FROM t_fa_clearbill a INNER JOIN t_fa_clearbillentry c ON c.fentryid = a.fid\n");
        sb.append(" WHERE a.fperiodid = '" + periodID + "' AND c.fcurcardid " + FaLocalUtils.handleIdArray(cardCollection) + "\n");
        sb.append("UNION ALL\n");
        sb.append("SELECT COUNT (a.fid) AS COUNT, 'CHANGEBILL' AS BillType\n");
        sb.append("  FROM t_fa_fachangebill a INNER JOIN t_fa_fachangebillentry c ON c.fchangebillid = a.fid\n");
        sb.append(" WHERE a.fperiodid = '" + periodID + "' AND c.fcurcardid " + FaLocalUtils.handleIdArray(cardCollection) + "\n");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            String popMsg = "";
            while (rowSet.next()) {
                if (rowSet.getInt("COUNT") > 0 && rowSet.getString("BillType").equals("CLEARBILL")) {
                    popMsg = popMsg + ResourceBase.getString((String)FAMAINTAINRESOURCE, (String)"clear", (Locale)ctx.getOriginLocale());
                }
                if (rowSet.getInt("COUNT") <= 0 || !rowSet.getString("BillType").equals("CHANGEBILL")) continue;
                popMsg = popMsg + ResourceBase.getString((String)FAMAINTAINRESOURCE, (String)"change", (Locale)ctx.getOriginLocale());
            }
            if (popMsg.length() > 0) {
                throw new EASBizException(new NumericExceptionSubItem("1", MessageFormat.format(ResourceBase.getString((String)FAMAINTAINRESOURCE, (String)"coalHasBusiness", (Locale)ctx.getOriginLocale()), popMsg)));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void checkPeriod(Context ctx, String companyId) throws EASBizException, BOSException {
        PeriodInfo[] periods = FaPeriodCloseFacadeFactory.getLocalInstance(ctx).getLastestPeriod(companyId);
    }
}

