/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaAccountBalanceInfo;
import com.kingdee.eas.fi.fa.manage.FaCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaDepType;
import com.kingdee.eas.fi.fa.manage.FaDepreciationInfo;
import com.kingdee.eas.fi.fa.manage.FaEvalDepreciationEntryInfo;
import com.kingdee.eas.fi.fa.manage.app.FaDepCalHelper;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.gl.common.RptServerUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class FaDepORMapping {
    private static Logger logger = Logger.getLogger(FaDepORMapping.class);

    static void partUndoDepForBalance(Connection conn, IObjectValue period, IObjectCollection cardCollection) throws BOSException, EASBizException {
        PreparedStatement pst = null;
        try {
            if (period == null) {
                return;
            }
            PeriodInfo periodInfo = (PeriodInfo)period;
            StringBuffer sql = new StringBuffer("update T_FA_FaAccountBalance set FDepreCreditFor = FDepreCreditFor-FDepreTerm,FDepreEndBalanceFor = FDepreEndBalanceFor-FDepreTerm,FAddUpYearDepre=FAddUpYearDepre-FDepreTerm,FDepreTerm=0 ");
            sql.append(" where FPeriodID = ? and FFaCurCardID ");
            sql.append(FaLocalUtils.handleIdArray(cardCollection));
            pst = conn.prepareStatement(sql.toString());
            pst.setString(1, periodInfo.getId().toString());
            pst.executeUpdate();
            logger.debug((Object)("Execute sql:" + sql.toString()));
            SQLUtils.cleanup((Statement)pst, (Connection)conn);
        }
        catch (Exception e) {
            logger.error((Object)"bactch update error!");
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(pst, (Connection)conn);
        }
    }

    static void partUndoDepForCard(Connection conn, IObjectValue period, IObjectCollection cardCollection, String company, boolean needUpdateCalDep, Context ctx) throws BOSException, EASBizException {
        Statement st = null;
        ResultSet rs = null;
        PreparedStatement pst = null;
        try {
            StringBuffer sql;
            if (period == null) {
                return;
            }
            String strWorkLoadId = FaLocalUtils.getWorkloadMethodID(ctx);
            st = conn.createStatement();
            if (strWorkLoadId != null && strWorkLoadId.length() != 0) {
                sql = new StringBuffer("update T_Fa_FaCurCard set FDeprTermCount = FDeprTermCount-1,fisoveraged = (CASE WHEN fusetermcount > fdeprtermcount-1 THEN 0 ELSE 1 END) where FDeprTTerm>0 and ");
                sql.append("(FTempDeprMethod IS null or FTempDeprMethod = '') and FDeprMethodID not in (" + strWorkLoadId + ") and fid ");
                sql.append(FaLocalUtils.handleIdArray(cardCollection));
                st.execute(sql.toString());
                logger.debug((Object)("Execute sql:" + sql.toString()));
                sql = new StringBuffer("update T_Fa_FaCurCard set FTempDeprTermCount = FTempDeprTermCount-1 where FDeprTTerm>0 and ");
                sql.append("(FTempDeprMethod IS NOT null and FTempDeprMethod <> '') and FTempDeprMethod not in (" + strWorkLoadId + ") and fid ");
                sql.append(FaLocalUtils.handleIdArray(cardCollection));
                st.execute(sql.toString());
                logger.debug((Object)("Execute sql:" + sql.toString()));
                sql = new StringBuffer("update T_Fa_FaCurCard set FDeprTermCount = 0 where FDeprTermCount < 0 and  FDeprMethodID not in (" + strWorkLoadId + ") and fid ");
                sql.append(FaLocalUtils.handleIdArray(cardCollection));
                st.execute(sql.toString());
                logger.debug((Object)("Execute sql:" + sql.toString()));
                sql = new StringBuffer("update T_Fa_FaCurCard set FTempDeprTermCount = 0 where FTempDeprTermCount < 0 and  FTempDeprMethod not in (" + strWorkLoadId + ") and fid ");
                sql.append(FaLocalUtils.handleIdArray(cardCollection));
                st.execute(sql.toString());
                logger.debug((Object)("Execute sql:" + sql.toString()));
            }
            String methodid_007 = FaLocalUtils.getMethodID(ctx, "007");
            sql = new StringBuffer("update T_FA_FaCurCard set FNeatAmt = FNeatAmt+FDeprTTerm,FNeatValue=FNeatValue+FDeprTTerm,FAccuDeprAll=FAccuDeprAll-FDeprTTerm,FAccuDeprTYear=FAccuDeprTYear-FDeprTTerm,FAccuDepr=FAccuDepr-FDeprTTerm,FDeprTTerm=0,fmonthdeprerate=(case when FDeprMethodID = ? then fmonthdeprerate else 0 end), flastupdatetime = GETDATE()");
            if (needUpdateCalDep) {
                sql.append(",FDeprCount= (CASE WHEN FDeprCount = 0 THEN 0 ELSE FDeprCount -1 END) ");
            }
            sql.append(" where fid ");
            sql.append(FaLocalUtils.handleIdArray(cardCollection));
            sql.append(" and FDeprTTerm>0 ");
            pst = conn.prepareStatement(sql.toString());
            pst.setString(1, methodid_007.toString());
            pst.executeUpdate();
            logger.debug((Object)("Execute sql:" + sql.toString()));
            String methodid_008 = FaLocalUtils.getMethodID(ctx, "008");
            sql = new StringBuffer("update T_FA_FaCurCard set FEvalNeatAmt = FEvalNeatAmt+FEvalDeprTTerm,FEvalNeatValue=FEvalNeatValue+FEvalDeprTTerm,FEvalYearDepr=FEvalYearDepr-FEvalDeprTTerm,FEvalAddDepr=FEvalAddDepr-FEvalDeprTTerm,FEvalDeprTTerm=0,FEvalMonthRate=(case when FEvalDeprModeID =? then FEvalMonthRate else 0 end), flastupdatetime = GETDATE()");
            if (needUpdateCalDep) {
                sql.append(",FEvalTaxLeftPeriod= (case when FEvalDeprModeID in(" + strWorkLoadId + ") then FEvalTaxLeftPeriod else FEvalTaxLeftPeriod+1 end) ");
                sql.append(",FEvalDeprPeriodNum= (case when FEvalDeprModeID in(" + strWorkLoadId + ") then FEvalDeprPeriodNum else FEvalDeprPeriodNum-1 end)");
            }
            sql.append(" where fid ");
            sql.append(FaLocalUtils.handleIdArray(cardCollection));
            sql.append(" and FEvalAssetValue is not null and FEvalDeprTTerm>0 ");
            pst.clearParameters();
            pst = conn.prepareStatement(sql.toString());
            pst.setString(1, methodid_008.toString());
            pst.executeUpdate();
            SQLUtils.cleanup(rs, (Statement)st, (Connection)conn);
        }
        catch (Exception e) {
            logger.error((Object)"bactch update error!");
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rs, st, (Connection)conn);
        }
    }

    static void batchUpdateDepForBalance(Connection conn, IObjectCollection balanceCollection) throws BOSException, EASBizException {
        Statement st = null;
        try {
            if (balanceCollection == null || balanceCollection.size() == 0) {
                return;
            }
            st = conn.createStatement();
            for (FaAccountBalanceInfo balanceInfo : balanceCollection) {
                String id = balanceInfo.getId().toString();
                BigDecimal depreCreditFor = balanceInfo.getDepreCreditFor();
                BigDecimal depreEndBalanceFor = balanceInfo.getDepreEndBalanceFor();
                BigDecimal addUpYearDepre = balanceInfo.getAddUpYearDepre();
                BigDecimal depreTerm = balanceInfo.getDepreTerm();
                StringBuffer sql = new StringBuffer("update T_FA_FaAccountBalance set FDepreCreditFor =");
                sql.append(RptServerUtil.bigdecimalToString((BigDecimal)depreCreditFor));
                sql.append(",FDepreEndBalanceFor=");
                sql.append(RptServerUtil.bigdecimalToString((BigDecimal)depreEndBalanceFor));
                sql.append(",FAddUpYearDepre=");
                sql.append(RptServerUtil.bigdecimalToString((BigDecimal)addUpYearDepre));
                sql.append(",FDepreTerm=");
                sql.append(RptServerUtil.bigdecimalToString((BigDecimal)depreTerm));
                sql.append(" where FID='" + id + "'");
                st.addBatch(sql.toString());
                logger.debug((Object)("Execute sql:" + sql.toString()));
            }
            st.executeBatch();
            SQLUtils.cleanup((Statement)st, (Connection)conn);
        }
        catch (Exception e) {
            logger.error((Object)"bactch update error!");
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(st, (Connection)conn);
        }
    }

    static void undoDepForBalance(Connection conn, IObjectValue period, String company) throws BOSException, EASBizException {
        PreparedStatement pst = null;
        try {
            if (period == null) {
                return;
            }
            PeriodInfo periodInfo = (PeriodInfo)period;
            StringBuffer sql = new StringBuffer("update T_FA_FaAccountBalance set FDepreCreditFor = FDepreCreditFor-FDepreTerm,FDepreEndBalanceFor = FDepreEndBalanceFor-FDepreTerm,FAddUpYearDepre=FAddUpYearDepre-FDepreTerm,FDepreTerm=0");
            sql.append(" where FPeriodID = ? ");
            sql.append(" and FFaCurCardID in (select FFaCurCardID from T_FA_FaDepreciationEntry where FLnkFaDepreEntry = (select Fid from T_FA_FaDepreciation where Fperiod = ? ");
            sql.append(" and FCompanyId = ? and FDepType=0))");
            pst = conn.prepareStatement(sql.toString());
            pst.setString(1, periodInfo.getId().toString());
            pst.setString(2, periodInfo.getId().toString());
            pst.setString(3, company.toString());
            pst.executeUpdate();
            logger.debug((Object)("Execute sql:" + sql.toString()));
            SQLUtils.cleanup((Statement)pst, (Connection)conn);
        }
        catch (Exception e) {
            logger.error((Object)"bactch update error!");
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(pst, (Connection)conn);
        }
    }

    static void undoDepForBalance(Context ctx, IObjectValue period, String company, String depInfoID, boolean auditFlag) throws BOSException, EASBizException {
        if (period == null) {
            return;
        }
        PeriodInfo periodInfo = (PeriodInfo)period;
        IRowSet rs = null;
        try {
            StringBuffer sql = new StringBuffer("select A.Fid,A.FWellDeprValue,B.FWellCost,B.FDepreciation from T_FA_FaCurCard A,T_FA_FaDepreciationEntry B where B.FLnkFaDepreEntry='" + depInfoID + "' and B.FFaCurCardID=A.Fid and A.FDeprTTerm>0 " + (auditFlag ? " and B.FState <> 3" : ""));
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                BigDecimal updateDeprValue = rs.getBigDecimal(2);
                sql = new StringBuffer("update T_FA_FaAccountBalance set FDepreCreditFor = FDepreCreditFor-" + updateDeprValue + ",FDepreEndBalanceFor = FDepreEndBalanceFor-" + updateDeprValue + ",FAddUpYearDepre=FAddUpYearDepre-" + updateDeprValue + ",FDepreTerm=0");
                sql.append(" where FPeriodID = '");
                sql.append(periodInfo.getId());
                sql.append("' and FFaCurCardID ='" + rs.getString(1) + "'");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
            logger.debug((Object)("Execute sql:" + sql.toString()));
        }
        catch (Exception e) {
            logger.error((Object)"bactch update error!");
            throw new BOSException((Throwable)e);
        }
    }

    static void partUndoDepForBalance(Context ctx, IObjectValue period, IObjectCollection cardCollection) throws BOSException, EASBizException {
        if (period == null) {
            return;
        }
        PeriodInfo periodInfo = (PeriodInfo)period;
        IRowSet rs = null;
        try {
            StringBuffer sql = new StringBuffer("select Fid,FWellDeprValue from T_FA_FaCurCard  where Fid " + FaLocalUtils.handleIdArray(cardCollection));
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                BigDecimal updateDeprValue = rs.getBigDecimal(2);
                sql = new StringBuffer("update T_FA_FaAccountBalance set FDepreCreditFor = FDepreCreditFor-" + updateDeprValue + ",FDepreEndBalanceFor = FDepreEndBalanceFor-" + updateDeprValue + ",FAddUpYearDepre=FAddUpYearDepre-" + updateDeprValue + ",FDepreTerm=0");
                sql.append(" where FPeriodID = '");
                sql.append(periodInfo.getId());
                sql.append("' and FFaCurCardID ='" + rs.getString(1) + "'");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
            logger.debug((Object)("Execute sql:" + sql.toString()));
        }
        catch (Exception e) {
            logger.error((Object)"bactch update error!");
            throw new BOSException((Throwable)e);
        }
    }

    static void batchUpdateDepForCard(Connection conn, IObjectCollection faCurCardCollection, boolean needUpdateCalDep) throws BOSException {
        Statement st = null;
        try {
            if (faCurCardCollection == null || faCurCardCollection.size() == 0) {
                return;
            }
            st = conn.createStatement();
            for (FaCurCardInfo card : faCurCardCollection) {
                String id = card.getId().toString();
                BigDecimal bdDep = card.getDeprTTerm();
                BigDecimal accuDepr = card.getAccuDepr();
                BigDecimal accuDeprYear = card.getAccuDeprTYear();
                BigDecimal accuDeprAll = card.getAccuDeprAll();
                BigDecimal neatValue = card.getNeatValue();
                BigDecimal neatAmt = card.getNeatAmt();
                BigDecimal deprTermCount = card.getDeprTermCount();
                deprTermCount = FaDepORMapping.formatDecimal(deprTermCount);
                BigDecimal wellDeprValue = card.getWellDeprValue();
                int leftYear = card.getLeftYear();
                int leftYearUp = card.getLeftYearUp();
                int depCount = card.getDeprCount();
                BigDecimal calDep = card.getAccuDeprForCal();
                BigDecimal leftyearTwo = card.getLeftYearTwo();
                int lastPeriodCount = card.getLastPeriodCount();
                BigDecimal monthDeprRate = card.getMonthDepreRate();
                BigDecimal bZero = new BigDecimal("0");
                StringBuffer sql = new StringBuffer("update T_FA_FaCurCard set FDeprTTerm =");
                sql.append(bdDep == null ? bZero : bdDep);
                sql.append(",FAccuDepr=");
                sql.append(accuDepr == null ? "0" : RptServerUtil.bigdecimalToString((BigDecimal)accuDepr));
                sql.append(",FAccuDeprTYear=");
                sql.append(accuDeprYear == null ? "0" : RptServerUtil.bigdecimalToString((BigDecimal)accuDeprYear));
                sql.append(",FAccuDeprAll=");
                sql.append(accuDeprAll == null ? "0" : RptServerUtil.bigdecimalToString((BigDecimal)accuDeprAll));
                sql.append(",FNeatValue=");
                sql.append(neatValue == null ? "0" : RptServerUtil.bigdecimalToString((BigDecimal)neatValue));
                sql.append(",FNeatAmt=");
                sql.append(neatAmt == null ? "0" : RptServerUtil.bigdecimalToString((BigDecimal)neatAmt));
                sql.append(",fmonthdeprerate=");
                sql.append(monthDeprRate == null ? "0" : RptServerUtil.bigdecimalToString((BigDecimal)monthDeprRate));
                if (card.getTempDeprMethod() == null || card.getTempDeprMethod().length() == 0) {
                    sql.append(",FDeprTermCount=");
                } else {
                    sql.append(",FTempDeprTermCount=");
                }
                sql.append(deprTermCount);
                sql.append(",FWellDeprValue=");
                sql.append(wellDeprValue == null ? bZero : wellDeprValue);
                sql.append(",fisoveraged = (CASE WHEN fusetermcount <= " + deprTermCount + " THEN 1 ELSE 0 END)");
                if (needUpdateCalDep) {
                    sql.append(",FAccuDeprForCal=" + RptServerUtil.bigdecimalToString((BigDecimal)calDep));
                    sql.append(",FLeftYear=" + leftYear);
                    sql.append(",FLeftYearTwo=" + RptServerUtil.bigdecimalToString((BigDecimal)leftyearTwo));
                    sql.append(",FLeftYearUp=" + leftYearUp);
                    sql.append(",FDeprCount= " + depCount);
                    sql.append(",FLastPeriodCount= " + lastPeriodCount);
                }
                sql.append(",flastupdatetime = GETDATE()");
                sql.append(" where FID='" + id + "'");
                st.addBatch(sql.toString());
                logger.debug((Object)("Execute sql:" + sql.toString()));
            }
            st.executeBatch();
            SQLUtils.cleanup((Statement)st, (Connection)conn);
        }
        catch (Exception e) {
            logger.error((Object)"bactch update error!");
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(st, (Connection)conn);
        }
    }

    private static BigDecimal formatDecimal(BigDecimal deprTermCount) {
        BigDecimal bZero = new BigDecimal("0");
        deprTermCount = deprTermCount == null || deprTermCount.compareTo(bZero) == 0 ? bZero : deprTermCount;
        return deprTermCount;
    }

    static void batchUpdateEvalDepForCard(Connection conn, IObjectCollection faCurCardCollection) throws BOSException {
        Statement st = null;
        try {
            if (faCurCardCollection == null || faCurCardCollection.size() == 0) {
                return;
            }
            st = conn.createStatement();
            for (FaCurCardInfo card : faCurCardCollection) {
                String id = card.getId().toString();
                BigDecimal bdDep = card.getEvalDeprTTerm();
                BigDecimal accuDepr = card.getEvalAddDepr();
                BigDecimal accuDeprYear = card.getEvalYearDepr();
                BigDecimal neatValue = card.getEvalNeatValue();
                BigDecimal neatAmt = card.getEvalNeatAmt();
                BigDecimal deprTermCount = card.getEvalDeprPeriodNum();
                BigDecimal leftTermCount = card.getEvalTaxLeftPeriod();
                BigDecimal monthDeprRate = card.getEvalMonthRate();
                StringBuffer sql = new StringBuffer("update T_FA_FaCurCard set FEvalDeprTTerm =");
                sql.append(bdDep == null ? "0" : RptServerUtil.bigdecimalToString((BigDecimal)bdDep));
                sql.append(",FEvalAddDepr=" + (accuDepr == null ? "0" : RptServerUtil.bigdecimalToString((BigDecimal)accuDepr)));
                sql.append(",FEvalYearDepr=" + (accuDeprYear == null ? "0" : RptServerUtil.bigdecimalToString((BigDecimal)accuDeprYear)));
                sql.append(",FEvalNeatValue=" + (neatValue == null ? "0" : RptServerUtil.bigdecimalToString((BigDecimal)neatValue)));
                sql.append(",FEvalNeatAmt=" + (neatAmt == null ? "0" : RptServerUtil.bigdecimalToString((BigDecimal)neatAmt)));
                sql.append(",FEvalMonthRate=" + (monthDeprRate == null ? "0" : RptServerUtil.bigdecimalToString((BigDecimal)monthDeprRate)));
                sql.append(",FEvalDeprPeriodNum=" + (deprTermCount == null ? "0" : RptServerUtil.bigdecimalToString((BigDecimal)deprTermCount)));
                sql.append(",FEvalTaxLeftPeriod=" + (leftTermCount == null ? "0" : RptServerUtil.bigdecimalToString((BigDecimal)leftTermCount)));
                sql.append(",flastupdatetime = GETDATE()");
                sql.append(",fisneedredepr = 0 ");
                sql.append(" where FID='" + id + "'");
                st.addBatch(sql.toString());
            }
            st.executeBatch();
            SQLUtils.cleanup((Statement)st, (Connection)conn);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(st, (Connection)conn);
        }
    }

    static void undoDepForCard(Connection conn, IObjectValue period, String company, Context ctx) throws BOSException, EASBizException {
        ResultSet rs = null;
        PreparedStatement pst = null;
        try {
            if (period == null) {
                return;
            }
            PeriodInfo periodInfo = (PeriodInfo)period;
            String strWorkLoadId = FaLocalUtils.getWorkloadMethodID(ctx);
            StringBuffer sql = null;
            if (strWorkLoadId != null && strWorkLoadId.length() != 0) {
                sql = new StringBuffer("update T_Fa_FaCurCard set FDeprTermCount = FDeprTermCount-1, fisoveraged = (CASE WHEN fusetermcount > fdeprtermcount-1 THEN 0 ELSE 1 END) where FDeprTTerm>0 and FDeprMethodID not in (" + strWorkLoadId + ") and ");
                sql.append("(FTempDeprMethod IS null or FTempDeprMethod = '') and ");
                sql.append(" fid in (select FFaCurCardID from T_FA_FaDepreciationEntry where FLnkFaDepreEntry = (select Fid from T_FA_FaDepreciation ");
                sql.append(" where Fperiod = ? and FCompanyId = ? and FDepType=0))");
                pst = conn.prepareStatement(sql.toString());
                pst.setString(1, periodInfo.getId().toString());
                pst.setString(2, company.toString());
                pst.executeUpdate();
                logger.debug((Object)("Execute sql:" + sql.toString()));
                sql = new StringBuffer("update T_Fa_FaCurCard set FTempDeprTermCount = FTempDeprTermCount-1 where FDeprTTerm>0 and FTempDeprMethod not in (" + strWorkLoadId + ") and ");
                sql.append("(FTempDeprMethod IS NOT null and FTempDeprMethod <> '') and ");
                sql.append(" fid in (select FFaCurCardID from T_FA_FaDepreciationEntry where FLnkFaDepreEntry = (select Fid from T_FA_FaDepreciation ");
                sql.append(" where Fperiod = ? and FCompanyId = ? and FDepType=0))");
                pst.clearParameters();
                pst = conn.prepareStatement(sql.toString());
                pst.setString(1, periodInfo.getId().toString());
                pst.setString(2, company.toString());
                pst.executeUpdate();
                logger.debug((Object)("Execute sql:" + sql.toString()));
                sql = new StringBuffer("update T_Fa_FaCurCard set FDeprTermCount = 0 where FDeprTermCount < 0 and  FDeprMethodID not in (" + strWorkLoadId + ") and ");
                sql.append(" fid in (select FFaCurCardID from T_FA_FaDepreciationEntry where FLnkFaDepreEntry = (select Fid from T_FA_FaDepreciation ");
                sql.append(" where Fperiod = ? and FCompanyId = ? and FDepType=0))");
                pst.clearParameters();
                pst = conn.prepareStatement(sql.toString());
                pst.setString(1, periodInfo.getId().toString());
                pst.setString(2, company.toString());
                pst.executeUpdate();
                logger.debug((Object)("Execute sql:" + sql.toString()));
                sql = new StringBuffer("update T_Fa_FaCurCard set FTempDeprTermCount = 0 where FTempDeprTermCount < 0 and  FTempDeprMethod not in (" + strWorkLoadId + ") and ");
                sql.append(" fid in (select FFaCurCardID from T_FA_FaDepreciationEntry where FLnkFaDepreEntry = (select Fid from T_FA_FaDepreciation ");
                sql.append(" where Fperiod = ? and FCompanyId = ? and FDepType=0))");
                pst.clearParameters();
                pst = conn.prepareStatement(sql.toString());
                pst.setString(1, periodInfo.getId().toString());
                pst.setString(2, company.toString());
                pst.executeUpdate();
                logger.debug((Object)("Execute sql:" + sql.toString()));
            }
            String methodid_007 = FaLocalUtils.getMethodID(ctx, "007");
            sql = new StringBuffer("update T_FA_FaCurCard set FNeatAmt = FNeatAmt+FDeprTTerm,FNeatValue=FNeatValue+FDeprTTerm,FAccuDeprAll=FAccuDeprAll-FDeprTTerm,FAccuDeprTYear=FAccuDeprTYear-FDeprTTerm,FAccuDepr=FAccuDepr-FDeprTTerm,FDeprTTerm=0,fmonthdeprerate=(case when FDeprMethodID = ? then fmonthdeprerate else 0 end),flastupdatetime = GETDATE()");
            sql.append(",FDeprCount= (CASE WHEN FDeprCount = 0 THEN 0 ELSE FDeprCount -1 END) ");
            sql.append(" where fid in (select FFaCurCardID from T_FA_FaDepreciationEntry where FLnkFaDepreEntry = (select Fid from T_FA_FaDepreciation ");
            sql.append(" where Fperiod = ? and FCompanyId = ? and FDepType=0)) and FDeprTTerm>0 ");
            pst.clearParameters();
            pst = conn.prepareStatement(sql.toString());
            pst.setString(1, methodid_007.toString());
            pst.setString(2, periodInfo.getId().toString());
            pst.setString(3, company.toString());
            pst.executeUpdate();
            logger.debug((Object)("Execute sql:" + sql.toString()));
            String methodid_008 = FaLocalUtils.getMethodID(ctx, "008");
            sql = new StringBuffer("update T_FA_FaCurCard set FEvalNeatAmt = FEvalNeatAmt+FEvalDeprTTerm,FEvalNeatValue=FEvalNeatValue+FEvalDeprTTerm,FEvalYearDepr=FEvalYearDepr-FEvalDeprTTerm,FEvalAddDepr=FEvalAddDepr-FEvalDeprTTerm,FEvalDeprTTerm=0,FEvalMonthRate=(case when FEvalDeprModeID = ? then FEvalMonthRate else 0 end), flastupdatetime = GETDATE()");
            sql.append(",FEvalTaxLeftPeriod= (case when FEvalDeprModeID in(" + strWorkLoadId + ") then FEvalTaxLeftPeriod else FEvalTaxLeftPeriod+1 end) ");
            sql.append(",FEvalDeprPeriodNum= (case when FEvalDeprModeID in(" + strWorkLoadId + ") then FEvalDeprPeriodNum else FEvalDeprPeriodNum-1 end)");
            sql.append(" where fid in (select FFaCurCardID from T_FA_FaEvalDepreciationEntry where FLnkFaDepreEntry = (select Fid from T_FA_FaEvalDepreciation ");
            sql.append("where Fperiod = ? and FCompanyId = ? ) ) and FEvalDeprTTerm>0 ");
            pst.clearParameters();
            pst = conn.prepareStatement(sql.toString());
            pst.setString(1, methodid_008.toString());
            pst.setString(2, periodInfo.getId().toString());
            pst.setString(3, company.toString());
            pst.executeUpdate();
            SQLUtils.cleanup(rs, (Statement)pst, (Connection)conn);
        }
        catch (Exception e) {
            logger.error((Object)"bactch update error!");
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rs, pst, (Connection)conn);
        }
    }

    static void undoDepForCardOther(Connection conn, IObjectValue period, String company, Context ctx) throws BOSException, EASBizException {
        ResultSet rs = null;
        PreparedStatement pst = null;
        try {
            if (period == null) {
                return;
            }
            PeriodInfo periodInfo = (PeriodInfo)period;
            String strWorkLoadId = FaLocalUtils.getWorkloadMethodID(ctx);
            StringBuffer sql = null;
            if (strWorkLoadId != null && strWorkLoadId.length() != 0) {
                sql = new StringBuffer("update T_Fa_FaCurCard set FDeprTermCount = FDeprTermCount-1, fisoveraged = (CASE WHEN fusetermcount > fdeprtermcount-1 THEN 0 ELSE 1 END) where FDeprTTerm=0 and FDeprMethodID not in (" + strWorkLoadId + ") and ");
                sql.append("(FTempDeprMethod IS null or FTempDeprMethod = '') and ");
                sql.append(" fid in (select FFaCurCardID from T_FA_FaDepreciationEntry where FLnkFaDepreEntry = (select Fid from T_FA_FaDepreciation ");
                sql.append(" where Fperiod = ? and FCompanyId = ? and FDepType=0) and FDEPRECIATION =0)");
                pst = conn.prepareStatement(sql.toString());
                pst.setString(1, periodInfo.getId().toString());
                pst.setString(2, company.toString());
                pst.executeUpdate();
                logger.debug((Object)("Execute sql:" + sql.toString()));
                sql = new StringBuffer("update T_Fa_FaCurCard set FTempDeprTermCount = FTempDeprTermCount-1 where FDeprTTerm=0 and FTempDeprMethod not in (" + strWorkLoadId + ") and ");
                sql.append("(FTempDeprMethod IS NOT null and FTempDeprMethod <> '') and ");
                sql.append(" fid in (select FFaCurCardID from T_FA_FaDepreciationEntry where FLnkFaDepreEntry = (select Fid from T_FA_FaDepreciation ");
                sql.append(" where Fperiod = ? and FCompanyId = ? and FDepType=0) and FDEPRECIATION =0)");
                pst.clearParameters();
                pst = conn.prepareStatement(sql.toString());
                pst.setString(1, periodInfo.getId().toString());
                pst.setString(2, company.toString());
                pst.executeUpdate();
                logger.debug((Object)("Execute sql:" + sql.toString()));
                sql = new StringBuffer("update T_Fa_FaCurCard set FDeprTermCount = 0 where FDeprTermCount < 0 and  FDeprMethodID not in (" + strWorkLoadId + ") and ");
                sql.append(" fid in (select FFaCurCardID from T_FA_FaDepreciationEntry where FLnkFaDepreEntry = (select Fid from T_FA_FaDepreciation ");
                sql.append(" where Fperiod = ? and FCompanyId = ? and FDepType=0) and FDEPRECIATION =0)");
                pst.clearParameters();
                pst = conn.prepareStatement(sql.toString());
                pst.setString(1, periodInfo.getId().toString());
                pst.setString(2, company.toString());
                pst.executeUpdate();
                logger.debug((Object)("Execute sql:" + sql.toString()));
                sql = new StringBuffer("update T_Fa_FaCurCard set FTempDeprTermCount = 0 where FTempDeprTermCount < 0 and  FTempDeprMethod not in (" + strWorkLoadId + ") and ");
                sql.append(" fid in (select FFaCurCardID from T_FA_FaDepreciationEntry where FLnkFaDepreEntry = (select Fid from T_FA_FaDepreciation ");
                sql.append(" where Fperiod = ? and FCompanyId = ? and FDepType=0) and FDEPRECIATION =0)");
                pst.clearParameters();
                pst = conn.prepareStatement(sql.toString());
                pst.setString(1, periodInfo.getId().toString());
                pst.setString(2, company.toString());
                pst.executeUpdate();
                logger.debug((Object)("Execute sql:" + sql.toString()));
            }
            String methodid_007 = FaLocalUtils.getMethodID(ctx, "007");
            sql = new StringBuffer("update T_FA_FaCurCard set FNeatAmt = FNeatAmt+FDeprTTerm,FNeatValue=FNeatValue+FDeprTTerm,FAccuDeprAll=FAccuDeprAll-FDeprTTerm,FAccuDeprTYear=FAccuDeprTYear-FDeprTTerm,FAccuDepr=FAccuDepr-FDeprTTerm,FDeprTTerm=0,fmonthdeprerate=(case when FDeprMethodID = ? then fmonthdeprerate else 0 end),flastupdatetime = GETDATE()");
            sql.append(",FDeprCount= (CASE WHEN FDeprCount = 0 THEN 0 ELSE FDeprCount -1 END) ");
            sql.append(" where fid in (select FFaCurCardID from T_FA_FaDepreciationEntry where FLnkFaDepreEntry = (select Fid from T_FA_FaDepreciation ");
            sql.append(" where Fperiod = ? and FCompanyId = ? and FDepType=0) and FDEPRECIATION =0) and FDeprTTerm=0 ");
            pst.clearParameters();
            pst = conn.prepareStatement(sql.toString());
            pst.setString(1, methodid_007.toString());
            pst.setString(2, periodInfo.getId().toString());
            pst.setString(3, company.toString());
            pst.executeUpdate();
            logger.debug((Object)("Execute sql:" + sql.toString()));
            String methodid_008 = FaLocalUtils.getMethodID(ctx, "008");
            sql = new StringBuffer("update T_FA_FaCurCard set FEvalNeatAmt = FEvalNeatAmt+FEvalDeprTTerm,FEvalNeatValue=FEvalNeatValue+FEvalDeprTTerm,FEvalYearDepr=FEvalYearDepr-FEvalDeprTTerm,FEvalAddDepr=FEvalAddDepr-FEvalDeprTTerm,FEvalDeprTTerm=0,FEvalMonthRate=(case when FEvalDeprModeID = ? then FEvalMonthRate else 0 end), flastupdatetime = GETDATE()");
            sql.append(",FEvalTaxLeftPeriod= (case when FEvalDeprModeID in(" + strWorkLoadId + ") then FEvalTaxLeftPeriod else FEvalTaxLeftPeriod+1 end) ");
            sql.append(",FEvalDeprPeriodNum= (case when FEvalDeprModeID in(" + strWorkLoadId + ") then FEvalDeprPeriodNum else FEvalDeprPeriodNum-1 end)");
            sql.append(" where fid in (select FFaCurCardID from T_FA_FaEvalDepreciationEntry where FLnkFaDepreEntry = (select Fid from T_FA_FaEvalDepreciation ");
            sql.append("where Fperiod = ? and FCompanyId = ? ) and FDEPRECIATION =0) and FEvalDeprTTerm=0 ");
            pst.clearParameters();
            pst = conn.prepareStatement(sql.toString());
            pst.setString(1, methodid_008.toString());
            pst.setString(2, periodInfo.getId().toString());
            pst.setString(3, company.toString());
            pst.executeUpdate();
            SQLUtils.cleanup(rs, (Statement)pst, (Connection)conn);
        }
        catch (Exception e) {
            logger.error((Object)"bactch update error!");
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rs, pst, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void restoreMonCard(Context ctx, Connection conn, PeriodInfo strPeriodId, String companyId) throws BOSException {
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("update T_Fa_FaMonCard set (");
            sql.append(FaLocalUtils.getQueryColumn(ctx, (CoreBaseInfo)new FaCardInfo(), new String[]{"fid", "ffiVouchered", "FVoucher", "FPropertyValueID"}, "") + "\r\n");
            sql.append(" ) = ( Select ");
            sql.append(FaLocalUtils.getQueryColumn(ctx, (CoreBaseInfo)new FaCardInfo(), new String[]{"fid", "ffiVouchered", "FVoucher", "FPropertyValueID"}, "cur") + "\r\n");
            sql.append(" From T_Fa_FaCurCard cur Where T_Fa_FaMonCard.FFaCurCardID = cur.FID  \r\n");
            sql.append(" And T_Fa_FaMonCard.FFaPeriodID = '" + strPeriodId.getId().toString() + "' And T_Fa_FaMonCard.FCompanyID in ('" + companyId + "'))");
            sql.append(" where T_Fa_FaMonCard.FFaPeriodID = '" + strPeriodId.getId().toString() + "' And T_Fa_FaMonCard.FCompanyID in ('" + companyId + "') \r\n");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    static void undoDepForCoalCard(IObjectValue period, String company, Context ctx, String depInfoID, boolean auditFlag) throws BOSException, EASBizException {
        if (period == null) {
            return;
        }
        try {
            StringBuffer sql = null;
            String strWorkLoadId = FaLocalUtils.getWorkloadMethodID(ctx);
            if (strWorkLoadId != null && strWorkLoadId.length() != 0) {
                sql = new StringBuffer("update T_Fa_FaCurCard set FDeprTermCount = FDeprTermCount-1, fisoveraged = (CASE WHEN fusetermcount > fdeprtermcount-1 THEN 0 ELSE 1 END)");
                sql.append(" where " + (auditFlag ? " FDeprTTerm>0 and " : "") + "FDeprMethodID not in (" + strWorkLoadId + ") and ");
                sql.append("fid in (select FFaCurCardID from T_FA_FaDepreciationEntry where FLnkFaDepreEntry = '" + depInfoID + (auditFlag ? "' and FState <> 3)" : "')"));
                DbUtil.execute((Context)ctx, (String)sql.toString());
                logger.debug((Object)("Execute sql:" + sql.toString()));
                sql = new StringBuffer("update T_Fa_FaCurCard set FDeprTermCount = 0 where FDeprTermCount < 0 and  FDeprMethodID not in (" + strWorkLoadId + ") and ");
                sql.append("fid in (select FFaCurCardID from T_FA_FaDepreciationEntry where FLnkFaDepreEntry = '" + depInfoID + (auditFlag ? "' and FState <> 3)" : "')"));
                DbUtil.execute((Context)ctx, (String)sql.toString());
                logger.debug((Object)("Execute sql:" + sql.toString()));
            }
            sql = new StringBuffer("update T_FA_FaCurCard  set FAccuDepr = FAccuDepr - FWellDeprValue,FDeprTTerm = 0,fmonthdeprerate = 0,FAccuDeprTYear = FAccuDeprTYear- FWellDeprValue,FAccuDeprAll = FAccuDeprAll- FWellDeprValue,FNeatValue = FNeatValue+ FWellDeprValue,FNeatAmt = FNeatAmt+ FWellDeprValue,FDeprCount = (CASE WHEN FDeprCount = 0 THEN 0 ELSE FDeprCount -1 END),FWellDeprValue=0,flastupdatetime = GETDATE() where FDeprTTerm>0 and Fid in (select FFaCurCardID from T_FA_FaDepreciationEntry where FLnkFaDepreEntry = '" + depInfoID + (auditFlag ? "' and FState <> 3)" : "')"));
            DbUtil.execute((Context)ctx, (String)sql.toString());
            logger.debug((Object)("Execute sql:" + sql.toString()));
        }
        catch (Exception e) {
            logger.error((Object)"bactch update error!");
            throw new BOSException((Throwable)e);
        }
    }

    static void partUndoDepForCoalCard(IObjectValue period, IObjectCollection cardCollection, String company, boolean needUpdateCalDep, Context ctx) throws BOSException, EASBizException {
        try {
            StringBuffer sql = null;
            String idArray = FaLocalUtils.handleIdArray(cardCollection);
            String strWorkLoadId = FaLocalUtils.getWorkloadMethodID(ctx);
            if (strWorkLoadId != null && strWorkLoadId.length() != 0) {
                sql = new StringBuffer("update T_Fa_FaCurCard set FDeprTermCount = FDeprTermCount-1, fisoveraged = (CASE WHEN fusetermcount > fdeprtermcount-1 THEN 0 ELSE 1 END) where FDeprTTerm>0 and FDeprMethodID not in (" + strWorkLoadId + ") and ");
                sql.append("fid " + idArray);
                DbUtil.execute((Context)ctx, (String)sql.toString());
                logger.debug((Object)("Execute sql:" + sql.toString()));
                sql = new StringBuffer("update T_Fa_FaCurCard set FDeprTermCount = 0 where FDeprTermCount < 0 and  FDeprMethodID not in (" + strWorkLoadId + ") and ");
                sql.append("fid " + idArray);
                DbUtil.execute((Context)ctx, (String)sql.toString());
                logger.debug((Object)("Execute sql:" + sql.toString()));
            }
            sql = new StringBuffer("update T_FA_FaCurCard  set FAccuDepr = FAccuDepr - FWellDeprValue,FDeprTTerm = 0,fmonthdeprerate = 0, FAccuDeprTYear = FAccuDeprTYear- FWellDeprValue,FAccuDeprAll = FAccuDeprAll- FWellDeprValue,FNeatValue = FNeatValue+ FWellDeprValue,FNeatAmt = FNeatAmt+ FWellDeprValue,FDeprCount = (CASE WHEN FDeprCount = 0 THEN 0 ELSE FDeprCount -1 END),FWellDeprValue = 0,flastupdatetime = GETDATE() where Fid " + idArray);
            DbUtil.execute((Context)ctx, (String)sql.toString());
            logger.debug((Object)("Execute sql:" + sql.toString()));
        }
        catch (Exception e) {
            logger.error((Object)"bactch update error!");
            throw new BOSException((Throwable)e);
        }
    }

    static void clearReDepFlag(Connection conn, String company, FaDepreciationInfo depInfo) throws BOSException, EASBizException {
        PreparedStatement pst = null;
        try {
            StringBuffer sql = new StringBuffer("update T_FA_FaCurCard set FIsNeedReDepr = 0");
            sql.append(" where FCompanyId = ? and FIsNeedReDepr = 1");
            if (depInfo != null && depInfo.getId() != null) {
                sql.append(" and fid in ( select entry.ffacurcardid from t_fa_fadepreciation bill \n");
                sql.append(" inner join t_fa_fadepreciationentry entry on bill.fid = entry.FLnkFaDepreEntry \n");
                sql.append(" where bill.fid=? ) \n");
            }
            pst = conn.prepareStatement(sql.toString());
            pst.setString(1, company.toString());
            if (depInfo != null && depInfo.getId() != null) {
                pst.setString(2, depInfo.getId().toString());
            }
            pst.executeUpdate();
            logger.debug((Object)("Execute sql:" + sql.toString()));
        }
        catch (Exception e) {
            try {
                logger.error((Object)"bactch update error!");
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pst, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pst, (Connection)conn);
    }

    static void clearReDepFlag(Connection conn, String company, String evalDepID) throws BOSException, EASBizException {
        PreparedStatement pst = null;
        try {
            StringBuffer sql = new StringBuffer("update T_FA_FaCurCard set FIsNeedReDepr = 0");
            sql.append(" where FCompanyId = ? and FIsNeedReDepr = 1");
            if (evalDepID != null) {
                sql.append(" and fid in ( select entry.ffacurcardid from t_fa_faevaldepreciation bill \n");
                sql.append(" inner join t_fa_faevaldepreciationentry entry on bill.fid = entry.FLnkFaDepreEntry \n");
                sql.append(" where bill.fid = ? ) \n");
            }
            pst = conn.prepareStatement(sql.toString());
            pst.setString(1, company.toString());
            if (evalDepID != null) {
                pst.setString(2, evalDepID);
            }
            pst.executeUpdate();
            logger.debug((Object)("Execute sql:" + sql.toString()));
        }
        catch (Exception e) {
            try {
                logger.error((Object)"bactch update error!");
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pst, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pst, (Connection)conn);
    }

    static void undoDeprCountForCard(Connection conn, IObjectValue period, String company, Context ctx) throws BOSException, EASBizException {
        PreparedStatement pst = null;
        try {
            int yearCount = FaLocalUtils.getValidPeriodCountofYear(ctx, (PeriodInfo)period, false);
            StringBuffer sql = new StringBuffer("update T_fa_facurcard set fdeprcount = ? , fLeftYearUp = fLeftYearUp + 1 ");
            sql.append(", fLastPeriodCount = null ");
            sql.append(" where fid in (select distinct fFaCurCardId from T_Fa_FaDepreciationentry as a, T_Fa_FaDepreciation as b where a.FLnkFaDepreEntry = b.fid and b.fcompanyid= ? ");
            sql.append(" and b.FDepType=0) and fDeprCount = 0 and FDeprTTerm>0 ");
            sql.append(" and fcompanyid= ? ");
            pst = conn.prepareStatement(sql.toString());
            pst.setInt(1, yearCount);
            pst.setString(2, company.toString());
            pst.setString(3, company.toString());
            pst.executeUpdate();
            logger.debug((Object)("Execute sql:" + sql.toString()));
        }
        catch (Exception e) {
            try {
                logger.error((Object)"bactch update error!");
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pst, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pst, (Connection)conn);
    }

    static void partUndoDeprCountForCard(Connection conn, IObjectValue period, IObjectCollection cardCollection, String company, Context ctx) throws BOSException, EASBizException {
        PreparedStatement pst = null;
        try {
            int yearCount = FaLocalUtils.getValidPeriodCountofYear(ctx, (PeriodInfo)period, false);
            String ids = FaLocalUtils.handleIdArray(cardCollection);
            StringBuffer sql = new StringBuffer("update T_fa_facurcard set fdeprcount = ? , fLeftYearUp = fLeftYearUp + 1 ");
            sql.append(", fLastPeriodCount = null ");
            sql.append(" where fid in (select distinct fFaCurCardId from T_Fa_FaDepreciationentry as a, T_Fa_FaDepreciation as b where a.FLnkFaDepreEntry = b.fid and b.fcompanyid= ? ");
            sql.append(" and b.FDepType=0) and fDeprCount = 0 and FDeprTTerm>0 ");
            sql.append(" and fcompanyid= ?  and fid " + ids);
            pst = conn.prepareStatement(sql.toString());
            pst.setInt(1, yearCount);
            pst.setString(2, company.toString());
            pst.setString(3, company.toString());
            pst.executeUpdate();
            logger.debug((Object)("Execute sql:" + sql.toString()));
        }
        catch (Exception e) {
            try {
                logger.error((Object)"bactch update error!");
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pst, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pst, (Connection)conn);
    }

    static void undoDeprCountForCoalCard(Connection conn, IObjectValue period, String company, Context ctx, String depInfoID, boolean auditFlag) throws BOSException, EASBizException {
        PreparedStatement pst = null;
        try {
            StringBuffer sql = new StringBuffer("update T_fa_facurcard set fdeprcount = ? , fLeftYearUp = fLeftYearUp + 1 ");
            sql.append(", fLastPeriodCount = null ");
            sql.append(" where fid in (select distinct fFaCurCardId from T_Fa_FaDepreciationentry as a, T_Fa_FaDepreciation as b ");
            sql.append(" where a.FLnkFaDepreEntry = b.fid and b.fid= ?  ");
            sql.append(" and b.fcompanyid= ? " + (auditFlag ? " and FState <> 3 " : " ") + ") and fDeprCount = 0 and FDeprTTerm>0");
            sql.append(" and fcompanyid= ? ");
            pst = conn.prepareStatement(sql.toString());
            pst.setInt(1, FaLocalUtils.getValidPeriodCountofYear(ctx, (PeriodInfo)period, false));
            pst.setString(2, depInfoID.toString());
            pst.setString(3, company.toString());
            pst.setString(4, company.toString());
            pst.executeUpdate();
            logger.debug((Object)("Execute sql:" + sql.toString()));
        }
        catch (Exception e) {
            try {
                logger.error((Object)"bactch update error!");
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pst, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pst, (Connection)conn);
    }

    static void undoDeprCountForCoalCard(IObjectValue period, IObjectCollection cardCollection, String company, Context ctx) throws BOSException, EASBizException {
        try {
            PeriodInfo currentPeriod = null;
            ISystemStatusCtrol ictrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("systemStatus.name", (Object)new Integer(SystemEnum.FIXEDASSETS.getValue())));
            fic.add(new FilterItemInfo("company.id", (Object)company));
            SelectorItemCollection sic = view.getSelector();
            sic.add(new SelectorItemInfo("currentPeriod.periodYear"));
            sic.add(new SelectorItemInfo("currentPeriod.periodNumber"));
            sic.add(new SelectorItemInfo("currentPeriod.beginDate"));
            sic.add(new SelectorItemInfo("currentPeriod.endDate"));
            sic.add(new SelectorItemInfo("currentPeriod.periodType.*"));
            SystemStatusCtrolCollection col = ictrol.getSystemStatusCtrolCollection(view);
            if (col.size() > 0) {
                currentPeriod = col.get(0).getCurrentPeriod();
            }
            StringBuffer sql = new StringBuffer("update T_fa_facurcard set fdeprcount = ");
            sql.append(FaLocalUtils.getValidPeriodCountofYear(ctx, currentPeriod, false));
            sql.append(", fLeftYearUp = fLeftYearUp + 1 ");
            sql.append(", fLastPeriodCount = null ");
            sql.append("where fid " + FaLocalUtils.handleIdArray(cardCollection) + " and fDeprCount = 0 and FDeprTTerm>0 ");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            logger.debug((Object)("Execute sql:" + sql.toString()));
        }
        catch (Exception e) {
            logger.error((Object)"bactch update error!");
            throw new BOSException((Throwable)e);
        }
    }

    private static void updateCurcardSQLByDepID(Context ctx, String curPeriodID, String companyID, String depID, String evalDepID, IObjectCollection cards) throws BOSException {
        String ids;
        StringBuffer result;
        if (depID != null) {
            result = new StringBuffer();
            result.append("UPDATE t_fa_facurcard\n");
            result.append("   SET (fdeprtterm, fmonthdeprerate, faccudepr, faccudeprtyear, faccudeprall, fneatvalue, fneatamt, fdeprtermcount, fisneedredepr, fdeprcount, flastupdatetime, fisoveraged) =\n");
            result.append("          (SELECT depentry.fdepreciation, depentry.fmonthdeprerate, t_fa_facurcard.faccudepr + depentry.fdepreciation,\n");
            result.append("                  t_fa_facurcard.faccudeprtyear + depentry.fdepreciation, t_fa_facurcard.faccudeprall + depentry.fdepreciation,\n");
            result.append("                  t_fa_facurcard.fneatvalue - depentry.fdepreciation, t_fa_facurcard.fneatamt - depentry.fdepreciation,\n");
            result.append("                  CASE WHEN Depmode.FIsWorkLoad=1 THEN T_fa_facurcard.Fdeprtermcount ELSE T_fa_facurcard.Fdeprtermcount + 1 END,\n");
            result.append("                  0, t_fa_facurcard.fdeprcount + 1, GETDATE(), CASE WHEN Depmode.FIsWorkLoad!=1 AND t_fa_facurcard.fusetermcount <= t_fa_facurcard.fdeprtermcount + 1 THEN 1 ELSE t_fa_facurcard.fisoveraged END\n");
            result.append("             FROM t_fa_fadepreciationentry depentry ,t_fa_fadepreciation dep,T_fa_depreciationmode Depmode where depentry.flnkfadepreentry = dep.fid\n");
            result.append("        \t\tand t_fa_facurcard.fdeprmethodid = Depmode.Fid\n");
            result.append("             and depentry.ffacurcardid = t_fa_facurcard.fid\n");
            result.append("              AND dep.fid = '" + depID + "')\n");
            result.append(" WHERE t_fa_facurcard.fcompanyid = '" + companyID + "'\n");
            if (cards != null && cards.size() > 0) {
                ids = FaLocalUtils.handleIdArray(cards);
                result.append(" and t_fa_facurcard.fid " + ids);
            }
            DbUtil.execute((Context)ctx, (String)result.toString());
        }
        if (evalDepID != null) {
            result = new StringBuffer();
            result.append("UPDATE t_fa_facurcard\n");
            result.append("   SET (FEvalDeprTTerm, FEvalMonthRate, FEvalAddDepr, FEvalYearDepr, FEvalNeatValue, FEvalNeatAmt, FEvalDeprPeriodNum, FEvalTaxLeftPeriod, fisneedredepr, flastupdatetime) =\n");
            result.append("          (SELECT depentry.fdepreciation, depentry.fmonthdeprerate, t_fa_facurcard.FEvalAddDepr + depentry.fdepreciation,\n");
            result.append("                  t_fa_facurcard.FEvalYearDepr + depentry.fdepreciation,\n");
            result.append("                  t_fa_facurcard.FEvalNeatValue - depentry.fdepreciation, t_fa_facurcard.FEvalNeatAmt - depentry.fdepreciation,\n");
            result.append("                  CASE WHEN Depmode.FIsWorkLoad=1 THEN T_fa_facurcard.FEvalDeprPeriodNum ELSE T_fa_facurcard.FEvalDeprPeriodNum + 1 END,\n");
            result.append("                  CASE WHEN Depmode.FIsWorkLoad=1 THEN T_fa_facurcard.FEvalTaxLeftPeriod ELSE T_fa_facurcard.FEvalTaxLeftPeriod - 1 END,\n");
            result.append("                  0, GETDATE()\n");
            result.append("             FROM t_fa_faevaldepreciationentry depentry ,t_fa_faevaldepreciation dep,T_fa_depreciationmode Depmode where depentry.flnkfadepreentry = dep.fid\n");
            result.append("             and t_fa_facurcard.FEvalDeprModeID = Depmode.Fid\n");
            result.append("             and depentry.ffacurcardid = t_fa_facurcard.fid\n");
            result.append("              AND dep.fid = '" + evalDepID + "')\n");
            result.append(" WHERE t_fa_facurcard.fcompanyid = '" + companyID + "'\n");
            if (cards != null && cards.size() > 0) {
                ids = FaLocalUtils.handleIdArray(cards);
                result.append(" and t_fa_facurcard.fid " + ids);
            }
            DbUtil.execute((Context)ctx, (String)result.toString());
        }
    }

    private static void updateBalanceSQLByDepID(Context ctx, String curPeriodID, String companyID, String depID, IObjectCollection cards) throws BOSException {
        if (depID == null) {
            return;
        }
        StringBuffer result = new StringBuffer();
        result.append("UPDATE t_fa_faaccountbalance\n");
        result.append("   SET (fdeprecreditfor, fdepreendbalancefor, faddupyeardepre, fdepreterm) =\n");
        result.append("          (SELECT t_fa_faaccountbalance.fdeprecreditfor + depentry.fdepreciation,\n");
        result.append("                  t_fa_faaccountbalance.fdepreendbalancefor + depentry.fdepreciation,\n");
        result.append("                  t_fa_faaccountbalance.faddupyeardepre + depentry.fdepreciation, depentry.fdepreciation\n");
        result.append("             FROM t_fa_fadepreciationentry depentry INNER JOIN t_fa_fadepreciation dep ON depentry.flnkfadepreentry = dep.fid\n");
        result.append("                  INNER JOIN t_fa_facurcard curcard ON depentry.ffacurcardid = curcard.fid\n");
        result.append("                  INNER JOIN t_fa_depreciationmode t4 ON curcard.fdeprmethodid = t4.fid\n");
        result.append("            WHERE depentry.ffacurcardid = t_fa_faaccountbalance.ffacurcardid\n");
        result.append("              AND dep.fid = '" + depID + "')\n");
        result.append(" WHERE t_fa_faaccountbalance.fperiodid = '" + curPeriodID + "' AND t_fa_faaccountbalance.fcompanyorgunitid = '" + companyID + "'");
        if (cards != null && cards.size() > 0) {
            String ids = FaLocalUtils.handleIdArray(cards);
            result.append(" and t_fa_faaccountbalance.FFaCurCardID " + ids);
        }
        DbUtil.execute((Context)ctx, (String)result.toString());
    }

    static void updateCardForAudit(Context ctx, String curPeriodID, String companyID, String depID, String evalDepInfoID, IObjectCollection cards) throws EASBizException, BOSException {
        FaDepORMapping.updateCurcardSQLByDepID(ctx, curPeriodID, companyID, depID, evalDepInfoID, cards);
        FaDepORMapping.updateBalanceSQLByDepID(ctx, curPeriodID, companyID, depID, cards);
    }

    static void updateDepEntry(Context ctx, String depID, String evalDepInfoID) throws EASBizException, BOSException {
        Object[] sqlPara;
        StringBuffer result;
        if (depID != null) {
            result = new StringBuffer();
            result.append("UPDATE t_fa_fadepreciationentry \n");
            result.append("   SET fstate = 3 \n");
            result.append(" WHERE fstate <> 3 AND flnkfadepreentry = ? \n");
            sqlPara = new Object[]{depID};
            DbUtil.execute((Context)ctx, (String)result.toString(), (Object[])sqlPara);
        }
        if (evalDepInfoID != null) {
            result = new StringBuffer();
            result.append("UPDATE t_fa_faevaldepreciationentry \n");
            result.append("   SET fstate = 3 \n");
            result.append(" WHERE fstate <> 3 AND flnkfadepreentry = ? \n");
            sqlPara = new Object[]{evalDepInfoID};
            DbUtil.execute((Context)ctx, (String)result.toString(), (Object[])sqlPara);
        }
    }

    static int queryNoAudit(Context ctx, String depID, String periodID, String companyID) throws EASBizException, BOSException {
        int result = 0;
        StringBuffer sql = new StringBuffer();
        try {
            IRowSet rowSet;
            if (depID != null) {
                sql.append("SELECT count(ffacurcardid) AS COUNT \n");
                sql.append("  FROM t_fa_fadepreciationentry \n");
                sql.append(" WHERE fstate <> 3 AND flnkfadepreentry = ? \n");
                Object[] sqlPara = new Object[]{depID};
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])sqlPara);
                if (rowSet.next()) {
                    result = rowSet.getInt("COUNT");
                }
            }
            if (result < 1) {
                sql = new StringBuffer();
                sql.append("SELECT count(e.ffacurcardid) AS COUNT \n");
                sql.append("  FROM t_fa_faevaldepreciationentry e inner join t_fa_faevaldepreciation b on b.fid=e.flnkfadepreentry\n");
                sql.append(" WHERE e.fstate <> 3 AND b.fperiod = ? and b.fcompanyid=?\n");
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{periodID, companyID});
                if (rowSet.next()) {
                    result = rowSet.getInt("COUNT");
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    public static boolean hasNoAudit(Context ctx, int periodYear, int periodNumber, String companyID) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT COUNT (line.fid) AS COUNT \n");
        sql.append("  FROM t_fa_fadepreciationentry line INNER JOIN t_fa_fadepreciation head ON line.flnkfadepreentry = head.fid \n");
        sql.append("  INNER JOIN t_bd_period period ON head.fperiod = period.fid \n");
        sql.append(" WHERE period.fperiodyear = ? AND period.fperiodnumber = ? AND head.fcompanyid = ? AND (head.fdeptype = 0 OR head.fdeptype = 1) AND line.fstate <> 3 \n");
        Object[] sqlPara = new Object[]{new Integer(periodYear), new Integer(periodNumber), companyID};
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])sqlPara);
            if (rowSet.next() && rowSet.getInt("COUNT") > 0) {
                return true;
            }
            sql = new StringBuffer();
            sql.append("SELECT COUNT (line.fid) AS COUNT \n");
            sql.append("  FROM t_fa_faevaldepreciationentry line INNER JOIN t_fa_faevaldepreciation head ON line.flnkfadepreentry = head.fid \n");
            sql.append("  INNER JOIN t_bd_period period ON head.fperiod = period.fid \n");
            sql.append(" WHERE period.fperiodyear = ? AND period.fperiodnumber = ? AND head.fcompanyid = ? AND line.fstate <> 3 \n");
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])sqlPara);
            if (rowSet.next() && rowSet.getInt("COUNT") > 0) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    static boolean hasNoAudit(Context ctx, int periodYear, int periodNumber, String companyID, FaDepType depType) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT COUNT (line.fid) AS COUNT \n");
        sql.append("  FROM t_fa_fadepreciationentry line INNER JOIN t_fa_fadepreciation head ON line.flnkfadepreentry = head.fid \n");
        sql.append("  INNER JOIN t_bd_period period ON head.fperiod = period.fid \n");
        sql.append(" WHERE period.fperiodyear = ? AND period.fperiodnumber = ? AND head.fcompanyid = ? AND head.fdeptype = " + depType.getValue() + " AND line.fstate <> " + 3 + " \n");
        Object[] sqlPara = new Object[]{new Integer(periodYear), new Integer(periodNumber), companyID};
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])sqlPara);
            if (rowSet.next() && rowSet.getInt("COUNT") > 0) {
                return true;
            }
            if (depType.getValue() != 0) {
                return false;
            }
            sql = new StringBuffer();
            sql.append("SELECT COUNT (line.fid) AS COUNT \n");
            sql.append("  FROM t_fa_faevaldepreciationentry line INNER JOIN t_fa_faevaldepreciation head ON line.flnkfadepreentry = head.fid \n");
            sql.append("  INNER JOIN t_bd_period period ON head.fperiod = period.fid \n");
            sql.append(" WHERE period.fperiodyear = ? AND period.fperiodnumber = ? AND head.fcompanyid = ? AND line.fstate <> 3 \n");
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])sqlPara);
            if (rowSet.next() && rowSet.getInt("COUNT") > 0) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    static boolean isDynamicCalDep(Context ctx, String curcardID) throws EASBizException, BOSException {
        boolean result = true;
        String sql = "select COUNT(fid) AS COUNT from t_fa_famoncard where ffaperiodid is null and ffacurcardid = ? and (faccudepr != 0 or fdeprtermcount != 0)";
        Object[] sqlPara = new Object[]{curcardID};
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])sqlPara);
            if (rowSet.next() && rowSet.getInt("COUNT") > 0) {
                return false;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private static void updateCurcardForCoal(Context ctx, String curPeriodID, String companyID, IObjectCollection cardCollection) throws EASBizException, BOSException {
        StringBuffer result = new StringBuffer();
        result.append("UPDATE t_fa_facurcard\n");
        result.append("   SET (fwelldeprvalue, fdeprtterm, fmonthdeprerate, faccudepr, faccudeprtyear, faccudeprall, fneatvalue, fneatamt, flastupdatetime, fdeprtermcount, fisoveraged) =\n");
        result.append("          (SELECT depentry.fdepreciation - depentry.fwellcost, depentry.fdepreciation, depentry.fmonthdeprerate,\n");
        result.append("                  t_fa_facurcard.faccudepr + (depentry.fdepreciation - depentry.fwellcost),\n");
        result.append("                  t_fa_facurcard.faccudeprtyear + (depentry.fdepreciation - depentry.fwellcost),\n");
        result.append("                  t_fa_facurcard.faccudeprall + (depentry.fdepreciation - depentry.fwellcost),\n");
        result.append("                  t_fa_facurcard.fneatvalue - (depentry.fdepreciation - depentry.fwellcost),\n");
        result.append("                  t_fa_facurcard.fneatamt - (depentry.fdepreciation - depentry.fwellcost),GETDATE(),t_fa_facurcard.fdeprtermcount + 1,\n");
        result.append("                  CASE WHEN t_fa_facurcard.fusetermcount <= t_fa_facurcard.fdeprtermcount + 1 THEN 1 ELSE 0 END\n");
        result.append("             FROM t_fa_fadepreciationentry depentry INNER JOIN t_fa_fadepreciation dep ON depentry.flnkfadepreentry = dep.fid\n");
        result.append("            WHERE depentry.ffacurcardid = t_fa_facurcard.fid\n");
        result.append("              AND dep.fperiod = '" + curPeriodID + "'\n");
        result.append("              AND dep.fcompanyid = '" + companyID + "'\n");
        result.append("              AND dep.fdeptype = 1)\n");
        result.append(" WHERE t_fa_facurcard.fid " + FaLocalUtils.handleIdArray(cardCollection) + "\n");
        DbUtil.execute((Context)ctx, (String)result.toString());
    }

    private static void updateBalanceForCoal(Context ctx, String curPeriodID, String companyID, IObjectCollection cardCollection) throws EASBizException, BOSException {
        StringBuffer result = new StringBuffer();
        result.append("UPDATE t_fa_faaccountbalance\n");
        result.append("   SET (fdeprecreditfor, fdepreendbalancefor, faddupyeardepre, fdepreterm) =\n");
        result.append("          (SELECT t_fa_faaccountbalance.fdeprecreditfor + (depentry.fdepreciation - depentry.fwellcost),\n");
        result.append("                  t_fa_faaccountbalance.fdepreendbalancefor + (depentry.fdepreciation - depentry.fwellcost),\n");
        result.append("                  t_fa_faaccountbalance.faddupyeardepre + (depentry.fdepreciation - depentry.fwellcost), depentry.fdepreciation\n");
        result.append("             FROM t_fa_fadepreciationentry depentry INNER JOIN t_fa_fadepreciation dep ON depentry.flnkfadepreentry = dep.fid\n");
        result.append("                  INNER JOIN t_fa_facurcard curcard ON depentry.ffacurcardid = curcard.fid\n");
        result.append("                  INNER JOIN t_fa_depreciationmode t4 ON curcard.fdeprmethodid = t4.fid\n");
        result.append("            WHERE depentry.ffacurcardid = t_fa_faaccountbalance.ffacurcardid\n");
        result.append("              AND dep.fperiod = '" + curPeriodID + "'\n");
        result.append("              AND dep.fcompanyid = '" + companyID + "'\n");
        result.append("              AND dep.fdeptype = 1)\n");
        result.append(" WHERE t_fa_faaccountbalance.fperiodid = '" + curPeriodID + "' AND t_fa_faaccountbalance.ffacurcardid " + FaLocalUtils.handleIdArray(cardCollection));
        DbUtil.execute((Context)ctx, (String)result.toString());
    }

    static void updateDepForCoal(Context ctx, PeriodInfo periodInfo, String companyID, IObjectCollection cardCollection) throws EASBizException, BOSException {
        if (periodInfo == null || periodInfo.getId() == null || cardCollection.size() < 1) {
            return;
        }
        FaDepORMapping.partUndoDepForBalance(ctx, (IObjectValue)periodInfo, cardCollection);
        FaDepORMapping.partUndoDepForCoalCard((IObjectValue)periodInfo, cardCollection, companyID, true, ctx);
        FaDepORMapping.updateCurcardForCoal(ctx, periodInfo.getId().toString(), companyID, cardCollection);
        FaDepORMapping.updateBalanceForCoal(ctx, periodInfo.getId().toString(), companyID, cardCollection);
    }

    static int bakCardHasDepValue(Context ctx, String periodID, String companyID) throws BOSException, EASBizException {
        int billType = -1;
        String clearBill = " SELECT CASE WHEN e.fassetamt = b.fclrqty THEN 4 ELSE 3 END billtype, a.fnumber billnumber, a.fid billid, e.fdeprtterm FROM t_fa_clearbill a LEFT OUTER JOIN t_fa_clearbillentry b ON a.fid = b.fentryid ";
        String changeBill = " SELECT 2 billtype, a.fnumber billnumber, a.fid billid, e.fdeprtterm FROM t_fa_fachangebill a LEFT OUTER JOIN t_fa_fachangebillentry b ON a.fid = b.fchangebillid ";
        String evaBill = " SELECT 6 billtype, a.fnumber billnumber, a.fid billid, e.fdeprtterm FROM t_fa_faevaluatebill a LEFT JOIN t_fa_faevaluatebillentry b ON b.ffaevaluatebillid = a.fid ";
        String splitBill = " SELECT 5 billtype, a.fnumber billnumber, a.fid billid, e.fdeprtterm FROM t_fa_fasplitbill a LEFT OUTER JOIN t_fa_fabizcard c ON a.FFaBizCardID = c.fid LEFT OUTER JOIN t_fa_fabakcard e ON c.ffabakcardid = e.fid WHERE a.fperiodid = ? AND a.fcompanyid = ? AND e.fdeprtterm != 0  ";
        String combinBill = " SELECT 8 billtype, a.fnumber billnumber, a.fid billid, e.fdeprtterm FROM t_fa_facombinbill a LEFT JOIN t_fa_facombinbillentry b ON b.FFaCombinBill = a.fid ";
        String dispatchBill = " SELECT 9 billtype, a.fnumber billnumber, a.fid billid, e.fdeprtterm FROM t_fa_fadispatchbill a LEFT JOIN t_fa_fadispatchbillentry b ON b.FFaDispatchBillID = a.fid ";
        String parameter = " LEFT OUTER JOIN t_fa_fabizcard c ON b.fbizcardid = c.fid LEFT OUTER JOIN t_fa_fabakcard e ON c.ffabakcardid = e.fid INNER JOIN t_fa_depreciationmode f ON e.fdeprmethodid = f.fid WHERE a.fperiodid = ? AND a.fcompanyid = ? AND (e.fdeprtterm != 0 or e.FEvalDeprTTerm != 0) AND f.fnumber != '006'";
        StringBuffer result = new StringBuffer();
        result.append(" SELECT TOP 1 * FROM ( ");
        result.append(clearBill + parameter);
        result.append(" UNION ALL \n");
        result.append(changeBill + parameter);
        result.append(" UNION ALL \n");
        result.append(evaBill + parameter);
        result.append(" UNION ALL \n");
        result.append(splitBill);
        result.append(" UNION ALL \n");
        result.append(combinBill + parameter);
        result.append(" UNION ALL \n");
        result.append(dispatchBill + parameter + " and a.FDispatchDirection=1 ");
        result.append(") A Order By A.billnumber");
        Object[] sqlPara = new Object[]{periodID, companyID, periodID, companyID, periodID, companyID, periodID, companyID, periodID, companyID, periodID, companyID};
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)result.toString(), (Object[])sqlPara);
            logger.debug((Object)result.toString());
            if (rowSet.next()) {
                billType = rowSet.getInt(1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"error!");
            throw new BOSException((Throwable)e);
        }
        return billType;
    }

    static void updateDepForUnAudit(Context ctx, PeriodInfo periodInfo, String companyID, IObjectCollection cardCollection, IObjectCollection bakcardCollection) throws EASBizException, BOSException {
        if (periodInfo == null || periodInfo.getId() == null || bakcardCollection.size() < 1 || cardCollection.size() < 1) {
            return;
        }
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select baseCurrency.precision where id = '" + companyID + "'");
        int baseCurPrecision = company.getBaseCurrency() == null ? 2 : company.getBaseCurrency().getPrecision();
        Object[] sqlParaCalDepDistribute = new Object[]{periodInfo.getId().toString(), companyID, companyID, periodInfo.getId().toString()};
        String deleteLineLineLine = "delete from T_FA_FaDepAsstActComposit where fbillid in (select fid from T_FA_FaDepDistribute where fdepentryid in  (select fid from t_fa_fadepreciationentry where flnkfadepreentry = (SELECT fid FROM t_fa_fadepreciation WHERE fperiod = '" + periodInfo.getId().toString() + "' AND fcompanyid = '" + companyID + "' AND fdeptype = " + 0 + ") and ffacurcardid " + FaLocalUtils.handleIdArray(cardCollection) + "))";
        String deleteLineLine = "delete from T_FA_FaDepDistribute where fdepentryid in  (select fid from t_fa_fadepreciationentry where flnkfadepreentry = (SELECT fid FROM t_fa_fadepreciation WHERE fperiod = '" + periodInfo.getId().toString() + "' AND fcompanyid = '" + companyID + "' AND fdeptype = " + 0 + ") and ffacurcardid " + FaLocalUtils.handleIdArray(cardCollection) + ")";
        String deleteLine = "delete from t_fa_fadepreciationentry where flnkfadepreentry = (SELECT fid FROM t_fa_fadepreciation WHERE fperiod = '" + periodInfo.getId().toString() + "' AND fcompanyid = '" + companyID + "' AND fdeptype = " + 0 + ") and ffacurcardid " + FaLocalUtils.handleIdArray(cardCollection);
        try {
            FaDepORMapping.partUndoDepForBalance(EJBFactory.getConnection((Context)ctx), (IObjectValue)periodInfo, cardCollection);
        }
        catch (SQLException e) {
            new BOSException(e.getMessage());
        }
        StringBuffer sql = new StringBuffer();
        String tableDesc = "T_FA_DEPR";
        String craeteTable = "CREATE TABLE " + tableDesc + " ( FFacurcardid varchar (44) NOT NULL,FShouldDepre  NUMERIC(19,4),FIsEval int)";
        String tempateTable = null;
        try {
            tempateTable = TempTablePool.getInstance((Context)ctx).createTempTable(craeteTable);
            TempTablePool.getInstance((Context)ctx).createIndex(tempateTable, "FFacurcardid", false, false);
        }
        catch (Exception e) {
            new BOSException((Throwable)e);
        }
        sql.append("insert into ").append(tempateTable);
        sql.append(" select e.ffacurcardid,e.FShouldDepre,0 from t_fa_fadepreciation b inner join t_fa_fadepreciationentry e on b.fid=e.flnkfadepreentry where b.fperiod=? and b.fcompanyid=? AND fdeptype = 0");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{periodInfo.getId().toString(), companyID});
        sql = new StringBuffer();
        sql.append("insert into " + tempateTable);
        sql.append(" select e.ffacurcardid,e.FShouldDepre,1 from t_fa_faevaldepreciation b inner join t_fa_faevaldepreciationentry e on b.fid=e.flnkfadepreentry where b.fperiod=? and b.fcompanyid=?");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{periodInfo.getId().toString(), companyID});
        DbUtil.execute((Context)ctx, (String)deleteLineLineLine);
        DbUtil.execute((Context)ctx, (String)deleteLineLine);
        DbUtil.execute((Context)ctx, (String)deleteLine);
        DbUtil.execute((Context)ctx, (String)("delete from t_fa_faevaldepreciationentry where flnkfadepreentry = (SELECT fid FROM t_fa_faevaldepreciation WHERE fperiod = '" + periodInfo.getId().toString() + "' AND fcompanyid = '" + companyID + "') and ffacurcardid " + FaLocalUtils.handleIdArray(cardCollection)));
        FaDepORMapping.updateDepFromBakCard(ctx, periodInfo.getId().toString(), companyID, bakcardCollection);
        DbUtil.execute((Context)ctx, (String)FaDepORMapping.insertCalDepDisFromCard(ctx, baseCurPrecision, cardCollection).toString(), (Object[])sqlParaCalDepDistribute);
        Object[] sqlParaCalDepDistribute1 = new Object[]{companyID, periodInfo.getId().toString()};
        DbUtil.execute((Context)ctx, (String)FaDepORMapping.insertCalDepDisCompositeFromCard(ctx, baseCurPrecision, cardCollection).toString(), (Object[])sqlParaCalDepDistribute1);
        DbUtil.execute((Context)ctx, (String)FaDepORMapping.updateBalanceFromCard(ctx, periodInfo.getId().toString(), companyID, cardCollection).toString());
        String restoreShouldDepr = "update t_fa_fadepreciationentry set FShouldDepre=(select tmp.FShouldDepre from " + tempateTable + " tmp where tmp.ffacurcardid=t_fa_fadepreciationentry.ffacurcardid and tmp.FIsEval=0) where flnkfadepreentry = (SELECT fid FROM t_fa_fadepreciation WHERE fperiod = '" + periodInfo.getId().toString() + "' AND fcompanyid = '" + companyID + "' AND fdeptype = " + 0 + ") and ffacurcardid " + FaLocalUtils.handleIdArray(cardCollection);
        DbUtil.execute((Context)ctx, (String)restoreShouldDepr);
        restoreShouldDepr = "update t_fa_faevaldepreciationentry set FShouldDepre=(select tmp.FShouldDepre from " + tempateTable + " tmp where tmp.ffacurcardid=t_fa_faevaldepreciationentry.ffacurcardid and tmp.FIsEval=1) where flnkfadepreentry = (SELECT fid FROM t_fa_faevaldepreciation WHERE fperiod = '" + periodInfo.getId().toString() + "' AND fcompanyid = '" + companyID + "' ) and ffacurcardid " + FaLocalUtils.handleIdArray(cardCollection);
        DbUtil.execute((Context)ctx, (String)restoreShouldDepr);
        TempTablePool.getInstance((Context)ctx).releaseTable(tempateTable);
    }

    private static StringBuffer insertCalDepDisFromCard(Context ctx, int baseCurPrecision, IObjectCollection curcardCollection) {
        StringBuffer distributeSQL = FaDepCalHelper.getCalDepDistributeSQL(ctx, baseCurPrecision);
        String noWhere = distributeSQL.substring(0, distributeSQL.lastIndexOf("WHERE"));
        StringBuffer result = new StringBuffer(noWhere);
        result.append("WHERE curcard.fid " + FaLocalUtils.handleIdArray(curcardCollection));
        result.append("AND dep.fdeptype = 0 \n");
        result.append("AND dep.fcompanyid = ? \n");
        result.append("AND dep.fperiod = ? \n");
        result.append("GROUP BY depentry.fid,\n");
        result.append("      costcenter.fapportionscale,\n");
        result.append("      costcenter.fseq,\n");
        result.append("      costcenter.fasstacttypeid,\n");
        result.append("      costcenter.fasstactitem,\n");
        result.append("      costcenter.faccountviewid,\n");
        result.append("      costcenter.FProfitCenterID,\n");
        result.append("      depentry.fdepreciation,\n");
        result.append("      tempoffset.toffset,");
        result.append("      x.countseq,");
        result.append("      x.maxscale,");
        result.append("      x.minseqofmaxscale,");
        result.append("      x.minseq");
        return result;
    }

    private static StringBuffer insertCalDepDisCompositeFromCard(Context ctx, int baseCurPrecision, IObjectCollection curcardCollection) {
        StringBuffer distributeSQL = FaDepCalHelper.getCalDepComDistributeSQL(ctx, baseCurPrecision);
        String noWhere = distributeSQL.substring(0, distributeSQL.lastIndexOf("WHERE"));
        StringBuffer result = new StringBuffer(noWhere);
        result.append("WHERE curcard.fid " + FaLocalUtils.handleIdArray(curcardCollection));
        result.append("AND dep.fdeptype = 0 \n");
        result.append("AND dep.fcompanyid = ? \n");
        result.append("AND dep.fperiod = ? \n");
        return result;
    }

    private static void updateDepFromBakCard(Context ctx, String periodID, String companyID, IObjectCollection bakcardCollection) throws EASBizException, BOSException {
        StringBuffer result = new StringBuffer();
        result.append("INSERT INTO t_fa_fadepreciationentry\n");
        result.append("            (fid, fmonthdeprerate, fbegindepre, fdepreciation, fshoulddepre, fnotdepre, fyearaddupdep, fenddepre, flnkfadepreentry,\n");
        result.append("             ffacurcardid, fstate)\n");
        result.append("   SELECT " + FaLocalUtils.newBosID(ctx, "3EB04861", true) + " AS fid, bakcard.fmonthdeprerate AS fmonthdeprerate, balance.fdeprebeginbalancefor AS fbegindepre,\n");
        result.append("          bakcard.fdeprtterm AS fdepreciation, bakcard.fdeprtterm AS fshoulddepre, bakcard.fneatamt - bakcard.fneatremvalue AS fnotdepre,\n");
        result.append("          bakcard.fdeprtterm + balance.faddupyeardepre AS fyearaddupdep, bakcard.faccudepr AS fenddepre,\n");
        result.append("          (SELECT fid\n");
        result.append("             FROM t_fa_fadepreciation\n");
        result.append("            WHERE fperiod = '" + periodID + "'\n");
        result.append("              AND fcompanyid = '" + companyID + "'\n");
        result.append("              AND fdeptype = 0) AS flnkfadepreentry,\n");
        result.append("          bakcard.ffacurcardid, 3 AS state\n");
        result.append(" FROM t_fa_fabakcard bakcard INNER JOIN t_fa_faaccountbalance balance ON bakcard.ffacurcardid = balance.ffacurcardid\n");
        result.append("      INNER JOIN t_bd_period t5 ON balance.fperiodid = t5.fid\n");
        result.append("WHERE bakcard.fid " + FaLocalUtils.handleIdArray(bakcardCollection) + " AND balance.fperiodid = '" + periodID + "' and bakcard.fdeprtterm >0 \n");
        DbUtil.execute((Context)ctx, (String)result.toString());
        result = new StringBuffer();
        result.append("INSERT INTO t_fa_faevaldepreciationentry\n");
        result.append("            (fid, fmonthdeprerate, fbegindepre, fdepreciation, fshoulddepre, fnotdepre, fyearaddupdep, fenddepre, flnkfadepreentry,\n");
        result.append("             ffacurcardid, fstate)\n");
        result.append("   SELECT " + FaLocalUtils.newBosID(ctx, new FaEvalDepreciationEntryInfo().getBOSType().toString(), true) + " AS fid, bakcard.FEvalMonthRate AS fmonthdeprerate, bakcard.FEvalAddDepr-bakcard.FEvalDeprTTerm AS fbegindepre,\n");
        result.append("          bakcard.FEvalDeprTTerm AS fdepreciation, bakcard.FEvalDeprTTerm AS fshoulddepre, bakcard.FEvalNeatAmt - bakcard.FEvalRemValue AS fnotdepre,\n");
        result.append("          bakcard.FEvalYearDepr AS fyearaddupdep, bakcard.FEvalAddDepr AS fenddepre,\n");
        result.append("          (SELECT fid\n");
        result.append("             FROM t_fa_faevaldepreciation\n");
        result.append("            WHERE fperiod = '" + periodID + "'\n");
        result.append("              AND fcompanyid = '" + companyID + "') AS flnkfadepreentry,\n");
        result.append("          bakcard.ffacurcardid, 3 AS state\n");
        result.append(" FROM t_fa_fabakcard bakcard \n");
        result.append("WHERE bakcard.fid " + FaLocalUtils.handleIdArray(bakcardCollection) + " AND bakcard.FEvalDeprTTerm > 0");
        DbUtil.execute((Context)ctx, (String)result.toString());
    }

    private static StringBuffer updateBalanceFromCard(Context ctx, String curPeriodID, String companyID, IObjectCollection curcardCollection) {
        StringBuffer result = new StringBuffer();
        result.append("UPDATE t_fa_faaccountbalance\n");
        result.append("   SET (fdeprecreditfor, fdepreendbalancefor, faddupyeardepre, fdepreterm) =\n");
        result.append("          (SELECT t_fa_faaccountbalance.fdeprecreditfor + depentry.fdepreciation,\n");
        result.append("                  t_fa_faaccountbalance.fdepreendbalancefor + depentry.fdepreciation,\n");
        result.append("                  t_fa_faaccountbalance.faddupyeardepre + depentry.fdepreciation, depentry.fdepreciation\n");
        result.append("             FROM t_fa_fadepreciationentry depentry INNER JOIN t_fa_fadepreciation dep ON depentry.flnkfadepreentry = dep.fid\n");
        result.append("                  INNER JOIN t_fa_facurcard curcard ON depentry.ffacurcardid = curcard.fid\n");
        result.append("                  INNER JOIN t_fa_depreciationmode t4 ON curcard.fdeprmethodid = t4.fid\n");
        result.append("            WHERE depentry.ffacurcardid = t_fa_faaccountbalance.ffacurcardid\n");
        result.append("              AND dep.fperiod = '" + curPeriodID + "'\n");
        result.append("              AND dep.fcompanyid = '" + companyID + "'\n");
        result.append("              AND dep.fdeptype = 0)\n");
        result.append(" WHERE t_fa_faaccountbalance.fperiodid = '" + curPeriodID + "' AND t_fa_faaccountbalance.ffacurcardid " + FaLocalUtils.handleIdArray(curcardCollection));
        return result;
    }

    static void updateRedepr(Context ctx, boolean isNeedRedepr, IObjectCollection curcardCollection) throws EASBizException, BOSException {
        if (curcardCollection == null || curcardCollection.size() < 1) {
            return;
        }
        String result = "UPDATE t_fa_facurcard SET fisneedredepr = " + (isNeedRedepr ? "1" : "0") + " WHERE fid " + FaLocalUtils.handleIdArray(curcardCollection);
        DbUtil.execute((Context)ctx, (String)result);
    }

    static void batchUpdateLastPeriodChangeForCard(Connection conn, IObjectCollection faCurCardCollection) throws BOSException {
        Statement st = null;
        try {
            if (faCurCardCollection == null || faCurCardCollection.size() == 0) {
                return;
            }
            st = conn.createStatement();
            for (FaCurCardInfo card : faCurCardCollection) {
                String id = card.getId().toString();
                StringBuffer sql = new StringBuffer();
                sql.append(" update T_FA_FaCurCard set FLastPeriodChange = 1 ");
                sql.append(" where FID = '" + id + "'");
                st.addBatch(sql.toString());
                logger.debug((Object)("Execute sql:" + sql.toString()));
            }
            st.executeBatch();
            SQLUtils.cleanup((Statement)st, (Connection)conn);
        }
        catch (Exception e) {
            logger.error((Object)"bactch update FLastPeriodChange error!");
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(st, (Connection)conn);
        }
    }
}

