/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.permission.ContextUtils;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.KAClassficationFactory;
import com.kingdee.eas.basedata.assistant.KAClassficationInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaCatInfo;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.fa.def.FaDefPropertyValueInfo;
import com.kingdee.eas.fi.fa.manage.DispatchCardItemServiceImp;
import com.kingdee.eas.fi.fa.manage.FaAppLogForBusinessTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaBillBizProcessor;
import com.kingdee.eas.fi.fa.manage.FaBillOriginEnum;
import com.kingdee.eas.fi.fa.manage.FaBizStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.FaCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCardOriginEnum;
import com.kingdee.eas.fi.fa.manage.FaChangeStatusEnmu;
import com.kingdee.eas.fi.fa.manage.FaClearBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaClearBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaClearBillFactory;
import com.kingdee.eas.fi.fa.manage.FaClearBillInfo;
import com.kingdee.eas.fi.fa.manage.FaClearStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCostCenterCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCostCenterInfo;
import com.kingdee.eas.fi.fa.manage.FaCurDepartmentCollection;
import com.kingdee.eas.fi.fa.manage.FaCurFacilityCollection;
import com.kingdee.eas.fi.fa.manage.FaCurInitDataCollection;
import com.kingdee.eas.fi.fa.manage.FaDepreciationEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaDispatchBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaDispatchBillEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaDispatchBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaDispatchBillException;
import com.kingdee.eas.fi.fa.manage.FaDispatchBillFactory;
import com.kingdee.eas.fi.fa.manage.FaDispatchBillInfo;
import com.kingdee.eas.fi.fa.manage.FaDispatchDirectionEnum;
import com.kingdee.eas.fi.fa.manage.FaEvalDepreciationEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaFromUnitCatEnum;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.IFaClearBill;
import com.kingdee.eas.fi.fa.manage.IFaCurCard;
import com.kingdee.eas.fi.fa.manage.IFaDispatchBill;
import com.kingdee.eas.fi.fa.manage.IFaDispatchBillEntry;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaDispatchBillControllerBean;
import com.kingdee.eas.fi.fa.manage.app.AbstractPrcFaManageStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaCardDefPropertyPersist;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.PrcFaAddStrategy;
import com.kingdee.eas.fi.fa.manage.app.PrcFaClearStrategy;
import com.kingdee.eas.fi.fa.manage.app.PrcFaCoreManager;
import com.kingdee.eas.fi.fa.manage.app.PrcFaDispatchStrategy;
import com.kingdee.eas.fi.fa.manage.app.falog.event.FaMethodCalcOrderEnum;
import com.kingdee.eas.fi.fa.manage.app.falog.utils.FaRPCMethodMappingUtils;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class FaDispatchBillControllerBean
extends AbstractFaDispatchBillControllerBean {
    private static final String RES_PATH_CARD = "com.kingdee.eas.fi.fa.manage.FaCardResource";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean _affirm(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FaBillBizProcessor.lockTable(ctx, pk.toString());
        FaDispatchBillInfo inBillInfo = this.getFaDispatchBillInfo(ctx, pk, this.getAffirmSelector());
        if (inBillInfo == null) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        FaLocalUtils.checkPeriodConsistent(ctx, inBillInfo.getCompany(), inBillInfo.getPeriod(), true);
        if (inBillInfo.getDispatchDirection() == FaDispatchDirectionEnum.OUT) {
            throw new FaDispatchBillException(FaDispatchBillException.COMPANYNOTMATCH);
        }
        if (inBillInfo.isHasAffirmed()) {
            throw new FaDispatchBillException(FaDispatchBillException.BILLHASCONFIRMED);
        }
        boolean isInitEnd = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)inBillInfo.getCompany());
        if (!isInitEnd) {
            throw new FaCardException(FaCardException.DISPATCH_INCOMPANY_NOT_INITED);
        }
        String outBillInfoId = inBillInfo.getRefBillUuid();
        FaDispatchBillInfo outBillInfo = this.getFaDispatchBillInfo(ctx, (IObjectPK)new ObjectUuidPK(outBillInfoId), this.getAffirmSelector());
        PeriodInfo periodOut = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)outBillInfo.getOutCompany());
        PeriodInfo periodIn = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)outBillInfo.getInCompany());
        if (periodOut.getPeriodYear() != periodIn.getPeriodYear() || periodOut.getPeriodNumber() != periodIn.getPeriodNumber()) {
            throw new FaDispatchBillException(FaDispatchBillException.DISPATCHPERIODNOTEQUAL, new Object[]{String.valueOf(periodOut.getPeriodYear()), String.valueOf(periodOut.getPeriodNumber()), String.valueOf(periodIn.getPeriodYear()), String.valueOf(periodIn.getPeriodNumber())});
        }
        outBillInfo.setFaClearBill(null);
        FaClearBillInfo faClearBillInfo = outBillInfo.getFaClearBill();
        FaDispatchBillEntryCollection outBillEnties = outBillInfo.getFaDispatchBillEntry();
        IFaCurCard iFaCurCard = FaCurCardFactory.getLocalInstance(ctx);
        IFaDispatchBillEntry iDispatchBillEntry = FaDispatchBillEntryFactory.getLocalInstance(ctx);
        if (faClearBillInfo == null) {
            UserInfo userInfo = new PrcFaDispatchStrategy().chkPermittedUser(ctx, outBillInfo.getOutCompany().getId(), outBillInfo.getOutPrincipal(), true);
            Context newCtx = new Context((IObjectPK)new ObjectUuidPK(userInfo.getId().toString()), ctx.getSolution(), ctx.getAIS(), ctx.getOriginLocale());
            ContextUtils.loadUserContext((Context)newCtx);
            ContextUtil.setCurrentFIUnit((Context)newCtx, (CompanyOrgUnitInfo)outBillInfo.getOutCompany());
            ContextUtil.setCurrentOrgUnit((Context)newCtx, (OrgUnitInfo)outBillInfo.getOutCompany());
            newCtx.setClientHostIP(ctx.getClientHostIP());
            newCtx.setClientHostName(ctx.getClientHostName());
            newCtx.setCaller(ctx.getCaller());
            IFaClearBill iClearBill = FaClearBillFactory.getLocalInstance(newCtx);
            this.batchUpdateCurCard(ctx, outBillInfoId, outBillInfo, "0699", 1);
            faClearBillInfo = new FaClearBillInfo();
            faClearBillInfo.setClearMode(outBillInfo.getDispatchMethod());
            faClearBillInfo.setCompany(outBillInfo.getCompany());
            PeriodInfo outPeriodInfo = FaLocalUtils.getFACurrentPeriod(outBillInfo.getCompany().getId().toString(), newCtx);
            faClearBillInfo.setPeriod(outPeriodInfo);
            faClearBillInfo.setBillType(FaBillOriginEnum.FROM_DISPATCH);
            faClearBillInfo.setDescription(FaResUtil.getRes((String)"allocateClean", (Locale)newCtx.getOriginLocale()));
            faClearBillInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
            faClearBillInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
            faClearBillInfo.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
            faClearBillInfo.setClearDate(this.getClearDate(outPeriodInfo));
            faClearBillInfo.setSourceBillId(outBillInfo.getId().toString());
            faClearBillInfo.setHandler(ContextUtil.getCurrentUserInfo((Context)newCtx));
            faClearBillInfo.setBizDate(DateTimeUtils.truncateDate((Date)outPeriodInfo.getEndDate()));
            FaClearBillEntryCollection faClearBillEntryCollection = faClearBillInfo.getClearBillEntry();
            int size = outBillEnties.size();
            for (int i = 0; i < size; ++i) {
                FaDispatchBillEntryInfo outBillEntry = outBillEnties.get(i);
                FaCurCardInfo curcard = outBillEntry.getFaCurCard();
                FaClearBillEntryInfo faClearBillEntryInfo = new FaClearBillEntryInfo();
                faClearBillEntryInfo.setClrQty(outBillEntry.getQuantity());
                faClearBillEntryInfo.setClrOriginal(outBillEntry.getAssetValue());
                faClearBillEntryInfo.setComment(FaResUtil.getRes((String)"allocateClean", (Locale)ctx.getOriginLocale()));
                faClearBillEntryInfo.put("faCurCard", outBillEntry.getFaCurCard().getId().toString());
                faClearBillEntryInfo.setClrAddupDep(outBillEntry.getAccuDepr());
                faClearBillEntryInfo.setClrEvalValue(outBillEntry.getEvaluateValue() == null ? new BigDecimal("0") : outBillEntry.getEvaluateValue());
                faClearBillEntryInfo.setClrDecPrep(curcard.getDecValue().multiply(outBillEntry.getQuantity()).divide(curcard.getAssetAmt(), 4, 4));
                faClearBillEntryInfo.put("cardUpdateTime", curcard.getLastUpdateTime());
                faClearBillEntryCollection.add(faClearBillEntryInfo);
            }
            boolean isWfEnabled = WfEventListenerStateManager.getInstance().isEnable();
            try {
                if (!isWfEnabled) {
                    WfEventListenerStateManager.getInstance().enableEventListener();
                }
                AbstractPrcFaManageStrategy.setBillInfoNumber(newCtx, faClearBillInfo, FaClearBillFactory.getLocalInstance(newCtx));
                iClearBill.submit((CoreBaseInfo)faClearBillInfo);
            }
            finally {
                if (!isWfEnabled) {
                    WfEventListenerStateManager.getInstance().disableEventListener();
                }
            }
            outBillInfo.setFaClearBill(faClearBillInfo);
        }
        outBillInfo.setHasAffirmed(true);
        outBillInfo.setAffirmDate(new Date());
        outBillInfo.setInAffirmHandler(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson());
        this._update(ctx, (IObjectPK)new ObjectUuidPK(outBillInfoId), (IObjectValue)outBillInfo);
        inBillInfo.setHasAffirmed(true);
        inBillInfo.setAffirmDate(new Date());
        inBillInfo.setInAffirmHandler(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson());
        FaDispatchBillEntryCollection inBillEnties = inBillInfo.getFaDispatchBillEntry();
        AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
        CurrencyInfo inBaseCurrency = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select baseCurrency.precision where id ='" + inBillInfo.getCompany().getId() + "'").getBaseCurrency();
        FaClearBillInfo clearBill = FaClearBillFactory.getLocalInstance(ctx).getFaClearBillInfo("select id ,clearBillEntry.id ,clearBillEntry.curCard.id ,clearBillEntry.clrQty ,clearBillEntry.clrAddupDep ,clearBillEntry.clrOriginal ,clearBillEntry.clrDecPrep where sourceBillId = '" + outBillInfo.getId() + "'");
        HashMap<String, FaClearBillEntryInfo> clearEntryMap = new HashMap<String, FaClearBillEntryInfo>();
        HashMap faParameter = FaManageUtils.getFAParameter(outBillInfo.getInCompany().getId(), ctx);
        int size = clearBill.getClearBillEntry().size();
        for (int i = 0; i < size; ++i) {
            FaClearBillEntryInfo clearEntry = clearBill.getClearBillEntry().get(i);
            clearEntryMap.put(clearEntry.getCurCard().getId().toString(), clearEntry);
        }
        PeriodInfo inPeriod = FaLocalUtils.getFACurrentPeriod(inBillInfo.getInCompany().getId().toString(), ctx);
        int size2 = inBillEnties.size();
        for (int i = 0; i < size2; ++i) {
            boolean isAutoCode;
            FaCatInfo assetCat;
            FaDispatchBillEntryInfo inBillEntry = inBillEnties.get(i);
            FaCurCardInfo srcCard = inBillEntry.getFaCurCard();
            FaCurCardInfo oldCardInfo = (FaCurCardInfo)inBillEntry.getFaCurCard().clone();
            FaCurCardInfo curCardInfo = FaCurCardFactory.getLocalInstance(ctx).getFaCurCardInfo((IObjectPK)new ObjectUuidPK(oldCardInfo.getId()), this.getCurCardSelectors(0));
            FaDefPropertyValueInfo tempDefPropertyValue = curCardInfo.getPropertyValue();
            if (tempDefPropertyValue != null) {
                FaDefPropertyValueInfo defPropertyValue = (FaDefPropertyValueInfo)tempDefPropertyValue.clone();
                defPropertyValue.setId(null);
                curCardInfo.setPropertyValue(defPropertyValue);
            }
            curCardInfo.setVoucher(null);
            curCardInfo.setVoucherAbstract(null);
            curCardInfo.setVoucherNumber(null);
            curCardInfo.put("faCurCardSum", null);
            boolean isStartDeprTime = curCardInfo.getAssetCat().getDepreciationPolicy().getStartDeprTime().getValue() != 0;
            boolean isDep = FaDepreciationEntryFactory.getLocalInstance(ctx).exists("select fid where LnkFaDepreEntry.period.id='" + periodIn.getId().toString() + "' and LnkFaDepreEntry.company.id='" + curCardInfo.getCompany().getId().toString() + "' and faCurCard.id='" + curCardInfo.getId().toString() + "'");
            if (!isDep) {
                isDep = FaEvalDepreciationEntryFactory.getLocalInstance(ctx).exists("select fid where LnkFaDepreEntry.period.id='" + periodIn.getId().toString() + "' and LnkFaDepreEntry.company.id='" + curCardInfo.getCompany().getId().toString() + "' and faCurCard.id='" + curCardInfo.getId().toString() + "'");
            }
            if (isDep && !isStartDeprTime) {
                BigDecimal zero = new BigDecimal("0");
                BigDecimal one = new BigDecimal("1");
                BigDecimal termDepr = curCardInfo.getDeprTTerm() == null ? zero : curCardInfo.getDeprTTerm();
                BigDecimal deprCount = curCardInfo.getDeprTermCount();
                if (termDepr.compareTo(zero) > 0) {
                    curCardInfo.setDeprTermCount(deprCount.subtract(one));
                    curCardInfo.setDeprTTerm(zero);
                    curCardInfo.setMonthDepreRate(zero);
                    curCardInfo.setAccuDepr(curCardInfo.getAccuDepr().subtract(termDepr));
                    curCardInfo.setAccuDeprTYear(curCardInfo.getAccuDeprTYear().subtract(termDepr));
                    curCardInfo.setAccuDeprAll(curCardInfo.getAccuDeprAll().subtract(termDepr));
                    curCardInfo.setNeatValue(curCardInfo.getNeatValue().add(termDepr));
                    curCardInfo.setNeatAmt(curCardInfo.getNeatAmt().add(termDepr));
                }
                BigDecimal EvalTermDepr = curCardInfo.getEvalDeprTTerm() == null ? zero : curCardInfo.getEvalDeprTTerm();
                BigDecimal EvalDeprCount = curCardInfo.getEvalDeprPeriodNum();
                if (EvalTermDepr.compareTo(zero) > 0) {
                    curCardInfo.setEvalDeprPeriodNum(EvalDeprCount.subtract(one));
                    curCardInfo.setEvalTaxLeftPeriod(curCardInfo.getEvalTaxLeftPeriod().add(one));
                    curCardInfo.setEvalMonthRate(zero);
                    curCardInfo.setEvalAddDepr(curCardInfo.getEvalAddDepr().subtract(EvalTermDepr));
                    curCardInfo.setEvalYearDepr(curCardInfo.getEvalYearDepr().subtract(EvalTermDepr));
                    curCardInfo.setEvalDeprTTerm(zero);
                    curCardInfo.setEvalNeatValue(curCardInfo.getEvalNeatValue().add(EvalTermDepr));
                    curCardInfo.setEvalNeatAmt(curCardInfo.getNeatAmt().add(EvalTermDepr));
                }
            }
            if ((assetCat = srcCard.getAssetCat()) != null && assetCat.getClassfication() != null) {
                KAClassficationInfo kaClassficationInfo = KAClassficationFactory.getLocalInstance((Context)ctx).getKAClassficationInfo((IObjectPK)new ObjectUuidPK(assetCat.getClassfication().getId()));
                BOSUuid accountTableId = kaClassficationInfo.getAccountTableId().getId();
                CompanyOrgUnitInfo inCompanyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(inBillInfo.getCompany().getId()));
                BOSUuid accountTableIdFromCompany = inCompanyInfo.getAccountTable().getId();
                if (!accountTableIdFromCompany.equals((Object)accountTableId)) {
                    curCardInfo.setAssetCat(null);
                    srcCard.setAssetCat(null);
                }
            }
            curCardInfo.setOriginUnit(outBillInfo.getOutCompany().getId().toString());
            curCardInfo.setPeriod(inPeriod);
            curCardInfo.setSourceBillId(inBillInfo.getId().toString());
            curCardInfo.setCompany(inBillInfo.getCompany());
            curCardInfo.setOriginType(FaFromUnitCatEnum.INNER_COMPANY);
            curCardInfo.setOriginUnit(inBillInfo.getOutCompany().getId().toString());
            curCardInfo.setLastPeriodChange(false);
            curCardInfo.setNeatValue(inBillEntry.getNeatValue());
            boolean isFullClear = inBillEntry.getFaCurCard().getAssetAmt().compareTo(inBillEntry.getQuantity()) == 0;
            boolean isEvalWithAssetValue = inBillInfo.isIsDspWithEvalValue();
            this.initCurCardProp(ctx, curCardInfo, isFullClear, clearEntryMap, inBaseCurrency, faParameter.get("FA_008"), isEvalWithAssetValue, inBillEntry);
            this.addjustDispatchCardItem(ctx, srcCard, curCardInfo, inBillInfo.getInCompany().getId().toString());
            curCardInfo.setBizDate(DateTimeUtils.truncateDate((Date)inPeriod.getEndDate()));
            boolean bl = isAutoCode = faParameter.get("FA_001") != null ? "true".equalsIgnoreCase(faParameter.get("FA_001").toString()) : true;
            if (!isAutoCode) {
                curCardInfo.setNumber("");
            }
            if (curCardInfo.getFaCurFacility() == null) {
                curCardInfo.put("faCurFacility", (Object)new FaCurFacilityCollection());
            }
            if (curCardInfo.getFaCurInitData() == null) {
                curCardInfo.put("faCurInitData", (Object)new FaCurInitDataCollection());
            }
            if (curCardInfo.getFaCurCostCenter() == null) {
                curCardInfo.put("faCurCostCenter", (Object)new FaCurCostCenterCollection());
            }
            if (curCardInfo.getFaCurDepartment() == null) {
                curCardInfo.put("faCurDepartment", (Object)new FaCurDepartmentCollection());
            }
            curCardInfo.setVoucher(null);
            curCardInfo.setVoucherNumber(null);
            curCardInfo.setVoucherAbstract(null);
            curCardInfo.setBarCode(null);
            SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
            selectorItemCollection.add("accountTable.id");
            CompanyOrgUnitInfo companyTmp = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(curCardInfo.getCompany().getId().toString()), selectorItemCollection);
            String accountTableID = companyTmp.getAccountTable() == null ? "" : companyTmp.getAccountTable().getId().toString();
            AccountViewInfo accountAssetOld = curCardInfo.getAccountAsset();
            if (accountAssetOld != null && AccountViewFactory.getLocalInstance((Context)ctx).exists("where companyID = '" + curCardInfo.getCompany().getId().toString() + "' and number = '" + accountAssetOld.getNumber() + "' and accountTableID = '" + accountTableID + "'")) {
                curCardInfo.setAccountAsset(AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo("where companyID = '" + curCardInfo.getCompany().getId().toString() + "' and number = '" + accountAssetOld.getNumber() + "' and accountTableID = '" + accountTableID + "'"));
            } else {
                curCardInfo.setAccountAsset(null);
            }
            AccountViewInfo accountAccuDeprOld = curCardInfo.getAccountAccuDepr();
            if (accountAccuDeprOld != null && AccountViewFactory.getLocalInstance((Context)ctx).exists("where companyID = '" + curCardInfo.getCompany().getId().toString() + "' and number = '" + accountAccuDeprOld.getNumber() + "' and accountTableID = '" + accountTableID + "'")) {
                curCardInfo.setAccountAccuDepr(AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo("where companyID = '" + curCardInfo.getCompany().getId().toString() + "' and number = '" + accountAccuDeprOld.getNumber() + "' and accountTableID = '" + accountTableID + "'"));
            } else {
                curCardInfo.setAccountAccuDepr(null);
            }
            AccountViewInfo accountDecValueOld = curCardInfo.getAccountDecValue();
            if (accountDecValueOld != null && AccountViewFactory.getLocalInstance((Context)ctx).exists("where companyID = '" + curCardInfo.getCompany().getId().toString() + "' and number = '" + accountDecValueOld.getNumber() + "' and accountTableID = '" + accountTableID + "'")) {
                curCardInfo.setAccountDecValue(AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo("where companyID = '" + curCardInfo.getCompany().getId().toString() + "' and number = '" + accountDecValueOld.getNumber() + "' and accountTableID = '" + accountTableID + "'"));
            } else {
                curCardInfo.setAccountDecValue(null);
            }
            FaCurCostCenterCollection faCurCostCenterCollection = curCardInfo.getFaCurCostCenter();
            int m = faCurCostCenterCollection.size();
            for (int n = 0; n < m; ++n) {
                FaCurCostCenterInfo faCurCostCenterInfo = faCurCostCenterCollection.get(n);
                AccountViewInfo account = faCurCostCenterInfo.getAccountView();
                if (account != null) {
                    account = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(account.getId()));
                }
                if (account != null && AccountViewFactory.getLocalInstance((Context)ctx).exists("where companyID = '" + curCardInfo.getCompany().getId().toString() + "' and number = '" + account.getNumber() + "' and accountTableID = '" + accountTableID + "'")) {
                    faCurCostCenterInfo.setAccountView(AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo("where companyID = '" + curCardInfo.getCompany().getId().toString() + "' and number = '" + account.getNumber() + "' and accountTableID = '" + accountTableID + "'"));
                    continue;
                }
                faCurCostCenterInfo.setAccountView(null);
            }
            String strPK = iFaCurCard.save((CoreBaseInfo)curCardInfo).toString();
            asm.copyBizAttachmentFiles(inBillEntry.getFaCurCard().getId().toString(), strPK);
            inBillEntry.setNewCard(curCardInfo);
            iDispatchBillEntry.update((IObjectPK)new ObjectUuidPK(inBillEntry.getId()), (CoreBaseInfo)inBillEntry);
        }
        this._update(ctx, pk, (IObjectValue)inBillInfo);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean affirm(Context ctx, IObjectPK billID) throws BOSException, EASBizException {
        try {
            this.setWorkflowServiceState(ctx, billID);
            boolean bl = super.affirm(ctx, billID);
            return bl;
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    private Date getClearDate(PeriodInfo periodInfo) throws EASBizException, BOSException {
        Date today = new Date(System.currentTimeMillis());
        if (periodInfo == null) {
            return today;
        }
        if (today.before(periodInfo.getBeginDate())) {
            today = periodInfo.getBeginDate();
        }
        if (today.after(periodInfo.getEndDate())) {
            today = periodInfo.getEndDate();
        }
        return today;
    }

    private void initCurCardProp(Context ctx, FaCurCardInfo curCardInfo, boolean isFullClear, Map clearEntryMap, CurrencyInfo baseCurrency, Object quantityScale, boolean isEvalWithAssetValue, FaDispatchBillEntryInfo inBillEntry) throws EASBizException, BOSException {
        String tempId = curCardInfo.getId().toString();
        curCardInfo.setId(null);
        curCardInfo.setAssetCat(null);
        curCardInfo.setOriginMethod(null);
        curCardInfo.setUseStatus(null);
        curCardInfo.setStoreCity(null);
        curCardInfo.setKeeper(null);
        curCardInfo.setDept(null);
        curCardInfo.setDeprMethod(null);
        curCardInfo.setAccountAsset(null);
        curCardInfo.setAccountAccuDepr(null);
        curCardInfo.setAccountDecValue(null);
        curCardInfo.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        curCardInfo.getFaCurCostCenter().clear();
        for (int i = 0; i < curCardInfo.getFaCurFacility().size(); ++i) {
            curCardInfo.getFaCurFacility().get(i).setId(null);
            curCardInfo.getFaCurFacility().get(i).setStorePlace(null);
        }
        curCardInfo.getFaCurInitData().clear();
        curCardInfo.getFaCurDepartment().clear();
        curCardInfo.put("faCurCostCenter", null);
        curCardInfo.put("faCurInitData", null);
        curCardInfo.put("faCurDepartment", null);
        curCardInfo.put("faCurFacility", null);
        curCardInfo.setHasDisabled(false);
        curCardInfo.setBizStatus(FaBizStatusEnum.ADDING);
        curCardInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        curCardInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
        curCardInfo.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        curCardInfo.setOriginFlag(FaCardOriginEnum.ADDNEW);
        curCardInfo.setHasCleared(FaClearStatusEnum.HasNotCleared);
        curCardInfo.setFiVouchered(false);
        curCardInfo.setIsNeedReDepr(false);
        curCardInfo.setLastBillID(null);
        curCardInfo.setHasDisabled(false);
        curCardInfo.setHasSplited(false);
        curCardInfo.setHasEvaled(false);
        curCardInfo.setHasChanged(FaChangeStatusEnmu.HasNotChanged);
        Date bizDate = DateTimeUtils.truncateDate((Date)new Date());
        if (bizDate.before(curCardInfo.getPeriod().getBeginDate())) {
            bizDate = curCardInfo.getPeriod().getBeginDate();
        } else if (bizDate.after(curCardInfo.getPeriod().getEndDate())) {
            bizDate = curCardInfo.getPeriod().getEndDate();
        }
        curCardInfo.setAccountDate(bizDate);
        curCardInfo.setFiAccountDate(bizDate);
        curCardInfo.setOriginFlag(FaCardOriginEnum.DISPATCH);
        curCardInfo.setHandler(ContextUtil.getCurrentUserInfo((Context)ctx));
        curCardInfo.setAuditor(null);
        curCardInfo.setBizDate(null);
        curCardInfo.setHasNew(true);
        curCardInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
        curCardInfo.setRemark(FaResUtil.getRes((String)"produceByAllocateBill", (Locale)ctx.getOriginLocale()));
        curCardInfo.setCU(null);
        curCardInfo.getCompany().setBaseCurrency(baseCurrency);
        this.calculateBizCardValue(curCardInfo, (FaClearBillEntryInfo)clearEntryMap.get(tempId), quantityScale, isFullClear, isEvalWithAssetValue, inBillEntry);
    }

    @Override
    protected boolean _unAffirm(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FaBillBizProcessor.lockTable(ctx, pk.toString());
        FaDispatchBillInfo inBillInfo = this.getFaDispatchBillInfo(ctx, pk, this.getUnAffirmSelector());
        FaLocalUtils.checkPeriodConsistent(ctx, inBillInfo.getCompany(), inBillInfo.getPeriod(), true);
        String outBillInfoId = inBillInfo.getRefBillUuid();
        FaDispatchBillInfo outBillInfo = this.getFaDispatchBillInfo(ctx, (IObjectPK)new ObjectUuidPK(outBillInfoId));
        FaDispatchBillEntryCollection inBillEnties = inBillInfo.getFaDispatchBillEntry();
        IFaDispatchBillEntry iDispatchBillEntry = FaDispatchBillEntryFactory.getLocalInstance(ctx);
        IFaDispatchBill iDispatchBill = FaDispatchBillFactory.getLocalInstance(ctx);
        PrcFaCoreManager prcFaCoreManager1 = new PrcFaCoreManager(new PrcFaAddStrategy());
        prcFaCoreManager1.getFaManageStrategy().getTempParam().put("FROM_SOURCE", "true");
        int size = inBillEnties.size();
        for (int i = 0; i < size; ++i) {
            FaDispatchBillEntryInfo inBillEntry = inBillEnties.get(i);
            FaCurCardInfo newCard = inBillEntry.getNewCard();
            inBillEntry.setNewCard(null);
            iDispatchBillEntry.update((IObjectPK)new ObjectUuidPK(inBillEntry.getId()), (CoreBaseInfo)inBillEntry);
            FaLocalUtils.abortWfProcessByObjId(ctx, newCard.getId().toString());
            prcFaCoreManager1.getFaManageStrategy().checkForDelete(ctx, (IObjectPK)new ObjectUuidPK(newCard.getId()));
            prcFaCoreManager1.getFaManageStrategy().deleteBill(ctx, (IObjectPK)new ObjectUuidPK(newCard.getId()));
        }
        FaClearBillInfo clearBill = outBillInfo.getFaClearBill();
        PrcFaCoreManager prcFaCoreManager2 = new PrcFaCoreManager(new PrcFaClearStrategy());
        prcFaCoreManager2.getFaManageStrategy().getTempParam().put("FROM_SOURCE", "true");
        FaLocalUtils.abortWfProcessByObjId(ctx, clearBill.getId().toString());
        prcFaCoreManager2.getFaManageStrategy().checkForDelete(ctx, (IObjectPK)new ObjectUuidPK(clearBill.getId()));
        prcFaCoreManager2.getFaManageStrategy().deleteBill(ctx, (IObjectPK)new ObjectUuidPK(clearBill.getId()));
        int size2 = inBillEnties.size();
        for (int i = 0; i < size2; ++i) {
            FaDispatchBillEntryInfo inBillEntry = inBillEnties.get(i);
            FaCurCardInfo oldCard = inBillEntry.getFaCurCard();
            String adjSql = "UPDATE T_FA_FaCurCard SET FBIZSTATUS = ? WHERE FID = ?";
            DbUtil.execute((Context)ctx, (String)adjSql, (Object[])new Object[]{"0701", oldCard.getId().toString()});
        }
        inBillInfo.setHasAffirmed(false);
        inBillInfo.setAffirmDate(null);
        inBillInfo.setInAffirmHandler(null);
        iDispatchBill.update(pk, (CoreBaseInfo)inBillInfo);
        outBillInfo.setHasAffirmed(false);
        outBillInfo.setAffirmDate(null);
        outBillInfo.setInAffirmHandler(null);
        outBillInfo.setFaClearBill(null);
        iDispatchBill.update((IObjectPK)new ObjectUuidPK(outBillInfoId), (CoreBaseInfo)outBillInfo);
        return true;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FaBillBizProcessor.lockTable(ctx, pk.toString());
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(this.getBillStrategy());
        prcFaCoreManager.getFaManageStrategy().checkForDelete(ctx, pk);
        prcFaCoreManager.getFaManageStrategy().deleteBill(ctx, pk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unAffirm(Context ctx, IObjectPK billID) throws BOSException, EASBizException {
        try {
            this.setWorkflowServiceState(ctx, billID);
            boolean bl = super.unAffirm(ctx, billID);
            return bl;
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    @Override
    protected void _passAudit(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        super._passAudit(ctx, pk);
        FaDispatchBillInfo outBillInfo = this.getFaDispatchBillInfo(ctx, pk, this.getPassAuditSelector());
        if (outBillInfo == null) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        if (outBillInfo.getDispatchDirection() == FaDispatchDirectionEnum.IN) {
            throw new FaDispatchBillException(FaDispatchBillException.COMPANYNOTMATCH);
        }
        FaDispatchBillEntryCollection outBillEnties = outBillInfo.getFaDispatchBillEntry();
        this.batchUpdateCurCard(ctx, pk.toString(), outBillInfo, "0701", 1);
        this.passAuditSelf(ctx, pk, outBillInfo);
        outBillInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        outBillInfo.setCheckedStatus(CheckedStatusEnum.AUDITED);
        outBillInfo.setAuditTime(new Date());
        outBillInfo.setBizDate(new Date());
        FaDispatchBillInfo inBillInfo = (FaDispatchBillInfo)outBillInfo.clone();
        inBillInfo.setCU(inBillInfo.getInCompany().getCU());
        inBillInfo.setCompany(inBillInfo.getInCompany());
        inBillInfo.setDispatchDirection(FaDispatchDirectionEnum.IN);
        inBillInfo.setRefBillUuid(pk.toString());
        inBillInfo.setId(null);
        inBillInfo.setVoucher(null);
        inBillInfo.setPeriod(FaLocalUtils.getFACurrentPeriod(inBillInfo.getCompany().getId().toString(), ctx));
        inBillInfo.getFaDispatchBillEntry().clear();
        int billEntryCnt = outBillEnties.size();
        for (int i = 0; i < billEntryCnt; ++i) {
            FaDispatchBillEntryInfo inBillEntry = (FaDispatchBillEntryInfo)outBillEnties.get(i).clone();
            inBillEntry.setId(null);
            inBillEntry.setFaDispatchBill(inBillInfo);
            inBillInfo.getFaDispatchBillEntry().add(inBillEntry);
        }
        IObjectPK inBillInfoPk = this.innerAddnew(ctx, (IObjectValue)inBillInfo);
        outBillInfo.setRefBillUuid(inBillInfoPk.toString());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("refBillUuid"));
        this._updatePartial(ctx, (IObjectValue)outBillInfo, sic);
        AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
        asm.copyBizAttachmentFiles(pk.toString(), inBillInfoPk.toString());
    }

    @Override
    protected void _unpassAudit(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        super._unpassAudit(ctx, pk);
        FaDispatchBillInfo outBillInfo = this.getFaDispatchBillInfo(ctx, pk, this.getUnPassAuditSelector());
        if (outBillInfo == null) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        if (outBillInfo.getDispatchDirection() == FaDispatchDirectionEnum.IN) {
            throw new FaDispatchBillException(FaDispatchBillException.COMPANYNOTMATCH);
        }
        boolean canUnAudit = true;
        NumericExceptionSubItem dispExption = null;
        if (outBillInfo.isHasAffirmed()) {
            dispExption = FaDispatchBillException.DISPATCHBILLHASCONFIRMED;
            canUnAudit = false;
        }
        if (outBillInfo.getFaClearBill() != null && outBillInfo.getFaClearBill().getCheckedStatus() == CheckedStatusEnum.AUDITED) {
            canUnAudit = false;
            dispExption = FaDispatchBillException.CLEARBILLHASCONFIRM;
        }
        if (!canUnAudit) {
            throw new FaDispatchBillException(dispExption);
        }
        IFaDispatchBill iDispatchBill = FaDispatchBillFactory.getLocalInstance(ctx);
        outBillInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        String inBillInfoPk = outBillInfo.getRefBillUuid();
        outBillInfo.setRefBillUuid(null);
        iDispatchBill.update(pk, (CoreBaseInfo)outBillInfo);
        this.batchUpdateCurCard(ctx, null, outBillInfo, "0601", 1);
        if (inBillInfoPk != null && inBillInfoPk.trim().length() > 0) {
            iDispatchBill.deleteSelf((IObjectPK)new ObjectUuidPK(inBillInfoPk));
        }
        this.unpassAuditSelf(ctx, pk, outBillInfo);
    }

    private void batchUpdateCurCard(Context ctx, String pk, FaDispatchBillInfo outBillInfo, String status, int blockedStatus) throws BOSException {
        FaDispatchBillEntryCollection outBillEnties = outBillInfo.getFaDispatchBillEntry();
        int billEntryCnt = outBillEnties.size();
        String[] outBillEntryPks = new String[billEntryCnt];
        for (int i = 0; i < billEntryCnt; ++i) {
            outBillEntryPks[i] = outBillEnties.get(i).getFaCurCard().getId().toString();
        }
        if (billEntryCnt > 0) {
            String[] columns = new String[]{"fbizStatus", "flastBillID", "fBlockedstatus"};
            Object[] values = new Object[]{status, pk, new Integer(blockedStatus)};
            StringBuffer sql = null;
            int size1 = outBillEntryPks.length;
            for (int i = 0; i < size1; ++i) {
                ArrayList<Object> cloneValues = new ArrayList<Object>();
                sql = new StringBuffer("UPDATE T_FA_FACURCARD SET ");
                int size2 = columns.length;
                for (int j = 0; j < size2; ++j) {
                    if (values[j] == null) {
                        sql.append(columns[j] + " = null , ");
                        continue;
                    }
                    sql.append(columns[j] + " = ? , ");
                    cloneValues.add(values[j]);
                }
                String execSql = sql.substring(0, sql.length() - ", ".length()) + " WHERE FID = '" + outBillEntryPks[i] + "'";
                DbUtil.execute((Context)ctx, (String)execSql, (Object[])cloneValues.toArray());
            }
        }
    }

    @Override
    protected AbstractPrcFaManageStrategy getBillStrategy() {
        return new PrcFaDispatchStrategy();
    }

    private void addjustDispatchCardItem(Context ctx, FaCurCardInfo srcCard, FaCurCardInfo destCard, String curCompanyId) throws BOSException {
        int i;
        DispatchCardItemServiceImp service = new DispatchCardItemServiceImp();
        List dispatchItem = service.getDispatchCardItemList(curCompanyId, ctx, true);
        if (dispatchItem == null) {
            dispatchItem = Arrays.asList((Object[])FaManageUtils.getDispatchByCardItemDefault());
        }
        if (srcCard.getPropertyValue() != null) {
            ArrayList<String> defList = new ArrayList<String>();
            int n = dispatchItem.size();
            for (int i2 = 0; i2 < n; ++i2) {
                String item = (String)dispatchItem.get(i2);
                if (!item.startsWith("def_")) continue;
                defList.add(item.substring(4));
            }
            if (defList.size() > 0) {
                FaDefPropertyValueInfo srcDef = FaCardDefPropertyPersist.getById(srcCard.getPropertyValue().getId(), ctx);
                FaDefPropertyValueInfo pv = new FaDefPropertyValueInfo();
                for (int i3 = 0; i3 < defList.size(); ++i3) {
                    String key = (String)defList.get(i3);
                    pv.put(key, srcDef.get(key));
                }
                pv = FaCardDefPropertyPersist.save(pv, ctx);
                destCard.setPropertyValue(pv);
            } else {
                destCard.setPropertyValue(null);
            }
        }
        List ouList = Arrays.asList((Object[])FaManageUtils.getOuIsolateItem());
        List allItem = Arrays.asList((Object[])FaManageUtils.getDispatchByCardItem());
        ArrayList needTransfor = new ArrayList();
        ArrayList addjustItem = new ArrayList();
        List notDispatchItem = new ArrayList();
        notDispatchItem = service.getDispatchCardItemList(curCompanyId, ctx, false);
        if (notDispatchItem != null) {
            for (i = 0; i < allItem.size(); ++i) {
                if (dispatchItem.contains(allItem.get(i))) continue;
                notDispatchItem.add(allItem.get(i));
            }
        }
        if (notDispatchItem != null) {
            for (i = 0; i < notDispatchItem.size(); ++i) {
                String key = notDispatchItem.get(i).toString();
                if (destCard.get(key) == null) continue;
                destCard.put(key, null);
            }
        }
        for (i = 0; i < dispatchItem.size(); ++i) {
            if (srcCard.get(dispatchItem.get(i).toString()) == null || destCard.get(dispatchItem.get(i).toString()) != null) continue;
            if (ouList.contains(dispatchItem.get(i))) {
                needTransfor.add(dispatchItem.get(i));
                continue;
            }
            addjustItem.add(dispatchItem.get(i));
        }
        try {
            FaCurFacilityCollection facility;
            FaCurDepartmentCollection dept = srcCard.getFaCurDepartment();
            if (dept != null) {
                for (int i4 = 0; i4 < dept.size(); ++i4) {
                    dept.get(i4).setId(null);
                }
            }
            if ((facility = srcCard.getFaCurFacility()) != null) {
                for (int i5 = 0; i5 < facility.size(); ++i5) {
                    facility.get(i5).setId(null);
                }
            }
            FaManageUtils.copyItemBetweenCard(srcCard, destCard, false, addjustItem);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        for (int i6 = 0; i6 < needTransfor.size(); ++i6) {
            String key = (String)needTransfor.get(i6);
            IObjectValue objVlue = this.getValueInCurComapny(ctx, (CoreBaseInfo)srcCard.get(key), curCompanyId);
            destCard.put(key, objVlue);
        }
    }

    private IObjectValue getValueInCurComapny(Context ctx, CoreBaseInfo info, String curCompanyId) throws BOSException {
        BOSObjectType type = BOSUuid.read((String)info.getId().toString()).getType();
        String oql = "SELECT id WHERE NUMBER = '" + info.get("number") + "' AND NAME = '" + info.get("name") + "' AND company.id = '" + curCompanyId + "'";
        try {
            return DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(type, oql);
        }
        catch (ObjectNotFoundException obje) {
            return null;
        }
    }

    @Override
    protected SelectorItemCollection getSelfSelctor() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("company"));
        sic.add(new SelectorItemInfo("FaDispatchBillEntry"));
        sic.add(new SelectorItemInfo("FaDispatchBillEntry.quantity"));
        sic.add(new SelectorItemInfo("FaDispatchBillEntry.assetValue"));
        sic.add(new SelectorItemInfo("FaDispatchBillEntry.neatValue"));
        sic.add(new SelectorItemInfo("FaDispatchBillEntry.evaluateValue"));
        sic.add(new SelectorItemInfo("FaDispatchBillEntry.accuDepr"));
        sic.add(new SelectorItemInfo("FaDispatchBillEntry.faBizCard"));
        sic.add(new SelectorItemInfo("FaDispatchBillEntry.faCurCard.*"));
        return sic;
    }

    private SelectorItemCollection getAffirmSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("period.id"));
        sic.add(new SelectorItemInfo("dispatchDirection"));
        sic.add(new SelectorItemInfo("hasAffirmed"));
        sic.add(new SelectorItemInfo("refBillUuid"));
        sic.add(new SelectorItemInfo("affirmDate"));
        sic.add(new SelectorItemInfo("inCompany.id"));
        sic.add(new SelectorItemInfo("inPrincipal.name"));
        sic.add(new SelectorItemInfo("inPrincipal.id"));
        sic.add(new SelectorItemInfo("outCompany.id"));
        sic.add(new SelectorItemInfo("outPrincipal.name"));
        sic.add(new SelectorItemInfo("outPrincipal.id"));
        sic.add(new SelectorItemInfo("isDspWithEvalValue"));
        sic.add(new SelectorItemInfo("faClearBill.id"));
        sic.add(new SelectorItemInfo("dispatchMethod.id"));
        sic.add(new SelectorItemInfo("FaDispatchBillEntry.id"));
        sic.add(new SelectorItemInfo("FaDispatchBillEntry.seq"));
        sic.add(new SelectorItemInfo("FaDispatchBillEntry.faCurCard.id"));
        sic.add(new SelectorItemInfo("FaDispatchBillEntry.faBizCard.id"));
        sic.add(new SelectorItemInfo("FaDispatchBillEntry.faDispatchBill.id"));
        sic.add(new SelectorItemInfo("FaDispatchBillEntry.quantity"));
        sic.add(new SelectorItemInfo("FaDispatchBillEntry.assetValue"));
        sic.add(new SelectorItemInfo("FaDispatchBillEntry.neatValue"));
        sic.add(new SelectorItemInfo("FaDispatchBillEntry.evaluateValue"));
        sic.add(new SelectorItemInfo("FaDispatchBillEntry.accuDepr"));
        sic.add(new SelectorItemInfo("FaDispatchBillEntry.faCurCard.currency.precision"));
        sic.add(new SelectorItemInfo("FaDispatchBillEntry.faCurCard.lastUpdateTime"));
        for (int i = 0; i < FaManageUtils.getDispatchByCardselector().length; ++i) {
            sic.add(new SelectorItemInfo("FaDispatchBillEntry.faCurCard." + FaManageUtils.getDispatchByCardselector()[i]));
        }
        return sic;
    }

    private SelectorItemCollection getUnAffirmSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("FaDispatchBillEntry.*"));
        sic.add(new SelectorItemInfo("FaDispatchBillEntry.newCard.*"));
        return sic;
    }

    private SelectorItemCollection getPassAuditSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("FaDispatchBillEntry.*"));
        sic.add(new SelectorItemInfo("FaDispatchBillEntry.faBizCard.*"));
        sic.add(new SelectorItemInfo("FaDispatchBillEntry.faCurCard.*"));
        sic.add(new SelectorItemInfo("inCompany.CU.id"));
        return sic;
    }

    private SelectorItemCollection getUnPassAuditSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("FaDispatchBillEntry.*"));
        sic.add(new SelectorItemInfo("faClearBill.*"));
        return sic;
    }

    @Override
    public String getMasterTable() {
        return "T_FA_FaDispatchBill";
    }

    private void calculateBizCardValue(FaCardInfo cardInfo, FaClearBillEntryInfo clearBillEntry, Object qtyScale, boolean isFullClear, boolean isEvalWithAssetValue, FaDispatchBillEntryInfo inBillEntry) {
        BigDecimal ZERO = new BigDecimal("0");
        FaCardInfo clearedCard = (FaCardInfo)cardInfo.clone();
        int baseCurrencyScale = clearedCard.getCompany().getBaseCurrency().getPrecision();
        int currencyScale = clearedCard.getCurrency().getPrecision();
        if (!isFullClear) {
            BigDecimal clrQty = clearBillEntry.getClrQty();
            BigDecimal assetAmt = clearedCard.getAssetAmt();
            BigDecimal clearRadio = new BigDecimal("1").subtract(clrQty.divide(clearedCard.getAssetAmt(), 4, 4));
            BigDecimal deprPrepare = clearBillEntry.getClrAddupDep().subtract(clearedCard.getAccuDepr().multiply(clrQty).divide(clearedCard.getAssetAmt(), baseCurrencyScale, 4));
            clearedCard.setAssetAmt(clearedCard.getAssetAmt().subtract(clrQty));
            cardInfo.setAssetAmt(cardInfo.getAssetAmt().subtract(clearedCard.getAssetAmt()));
            clearedCard.setAssetValue(clearedCard.getAssetValue().subtract(clearBillEntry.getClrOriginal()));
            cardInfo.setAssetValue(cardInfo.getAssetValue().subtract(clearedCard.getAssetValue()));
            BigDecimal addons = cardInfo.getAddons() == null ? new BigDecimal("0") : cardInfo.getAddons();
            cardInfo.setAddons(addons.multiply(clrQty).divide(assetAmt, baseCurrencyScale, 4));
            BigDecimal addonFare = cardInfo.getAddonFare() == null ? new BigDecimal("0") : cardInfo.getAddonFare();
            cardInfo.setAddonFare(addonFare.multiply(clrQty).divide(assetAmt, baseCurrencyScale, 4));
            cardInfo.setOriginAmt(cardInfo.getAssetValue().subtract(cardInfo.getAddonFare()).subtract(cardInfo.getAddons()).divide(cardInfo.getExRate(), baseCurrencyScale, 4));
            clearedCard.setAccuDepr(clearedCard.getAccuDepr().subtract(clearBillEntry.getClrAddupDep()));
            cardInfo.setAccuDepr(cardInfo.getAccuDepr().subtract(clearedCard.getAccuDepr()));
            clearedCard.setAccuDeprTYear(clearedCard.getAccuDeprTYear().multiply(clearRadio).subtract(deprPrepare));
            cardInfo.setAccuDeprTYear(cardInfo.getAccuDeprTYear().subtract(clearedCard.getAccuDeprTYear()));
            if (cardInfo.getAccuDeprTYear().compareTo(cardInfo.getAccuDepr()) > 0) {
                cardInfo.setAccuDeprTYear(cardInfo.getAccuDepr());
            }
            clearedCard.setDecValue(clearedCard.getDecValue().subtract(clearBillEntry.getClrDecPrep()));
            cardInfo.setDecValue(cardInfo.getDecValue().subtract(clearedCard.getDecValue()));
            cardInfo.setNeatRemValue(cardInfo.getNeatRemValue().multiply(clrQty).divide(assetAmt, baseCurrencyScale, 4));
            cardInfo.setInitEvalValue(cardInfo.getInitEvalValue().multiply(clrQty).divide(assetAmt, baseCurrencyScale, 4));
            cardInfo.setLastEvalValue(cardInfo.getLastEvalValue().multiply(clrQty).divide(assetAmt, baseCurrencyScale, 4));
            cardInfo.setNeatAmt(cardInfo.getNeatValue().subtract(cardInfo.getDecValue()));
            cardInfo.setAccuDeprAll(cardInfo.getAccuDeprAll().multiply(clrQty).divide(assetAmt, baseCurrencyScale, 4));
        }
        if (isEvalWithAssetValue && cardInfo.getInitEvalValue() != null) {
            cardInfo.setAssetValue(cardInfo.getInitEvalValue());
            BigDecimal addons = cardInfo.getAddons() == null ? new BigDecimal("0") : cardInfo.getAddons();
            BigDecimal addonFare = cardInfo.getAddonFare() == null ? new BigDecimal("0") : cardInfo.getAddonFare();
            cardInfo.setOriginAmt(cardInfo.getAssetValue().subtract(addonFare).subtract(addons).divide(cardInfo.getExRate(), currencyScale, 4));
        }
        cardInfo.setOriginDif(cardInfo.getAssetValue());
        cardInfo.setOriginAccuDif(cardInfo.getAssetValue());
        cardInfo.setAccuDeprChg(cardInfo.getAccuDepr());
        cardInfo.setAccuDeprAccuChg(cardInfo.getAccuDepr());
        cardInfo.setAccuDeprChgTYear(cardInfo.getAccuDeprTYear());
        cardInfo.setAccuDeprAccuChgTYear(cardInfo.getAccuDeprTYear());
        cardInfo.setDecValueChg(cardInfo.getDecValue());
        cardInfo.setDecValueAccuChg(cardInfo.getDecValue());
        cardInfo.setDeprTTerm(ZERO.setScale(baseCurrencyScale, 4));
        cardInfo.setAccuDeprAccuClean(ZERO.setScale(baseCurrencyScale, 4));
        cardInfo.setAccuDeprAccuCleanTYear(ZERO.setScale(baseCurrencyScale, 4));
        cardInfo.setAccuDeprForCal(null);
        cardInfo.setLeftYear(0);
        cardInfo.setLeftYearUp(0);
        cardInfo.setDeprCount(0);
        cardInfo.setLastPeriodCount(0);
    }

    @Override
    protected void _checkBeforePeriodClose(Context ctx, String periodID, String companyID) throws BOSException, EASBizException {
        super._checkBeforePeriodClose(ctx, periodID, companyID);
        FilterInfo dispatchFilter = new FilterInfo();
        dispatchFilter.getFilterItems().add(new FilterItemInfo("period", (Object)periodID));
        dispatchFilter.getFilterItems().add(new FilterItemInfo("company", (Object)companyID));
        dispatchFilter.getFilterItems().add(new FilterItemInfo("hasAffirmed", (Object)Boolean.FALSE));
        dispatchFilter.setMaskString("#0 and #1 and #2");
        if (this.exists(ctx, dispatchFilter)) {
            throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"forward_HasNewBiz_NoConfirm", (Locale)ctx.getOriginLocale())));
        }
    }

    public SelectorItemCollection getCurCardSelectors(int cardType) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("assetCat.id"));
        sic.add(new SelectorItemInfo("assetCat.number"));
        sic.add(new SelectorItemInfo("assetCat.name"));
        sic.add(new SelectorItemInfo("assetCat.useLimit"));
        sic.add(new SelectorItemInfo("assetCat.prePureRate"));
        sic.add(new SelectorItemInfo("assetCat.depreRule"));
        sic.add(new SelectorItemInfo("assetCat.isLeaf"));
        sic.add(new SelectorItemInfo("assetCat.numberRule"));
        sic.add(new SelectorItemInfo("assetCat.calcuByEvaluate"));
        sic.add(new SelectorItemInfo("assetCat.displayName"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.OldChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.TotalDeprChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.DevalueChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.LeaveValueChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.ChargeAccoutChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.UsedLifeChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.DeprMethodChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.EvaluateChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.CostCenterChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.UseStatusChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.TailDispose"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.StartDeprTime"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.DeprRule"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.StartDeprTime"));
        sic.add(new SelectorItemInfo("measureUnit.id"));
        sic.add(new SelectorItemInfo("measureUnit.name"));
        sic.add(new SelectorItemInfo("measureUnit.number"));
        sic.add(new SelectorItemInfo("storeCity.id"));
        sic.add(new SelectorItemInfo("storeCity.name"));
        sic.add(new SelectorItemInfo("storeCity.number"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("dept.id"));
        sic.add(new SelectorItemInfo("dept.name"));
        sic.add(new SelectorItemInfo("dept.number"));
        sic.add(new SelectorItemInfo("keeper.id"));
        sic.add(new SelectorItemInfo("keeper.name"));
        sic.add(new SelectorItemInfo("keeper.number"));
        sic.add(new SelectorItemInfo("originType"));
        sic.add(new SelectorItemInfo("originMethod.id"));
        sic.add(new SelectorItemInfo("originMethod.name"));
        sic.add(new SelectorItemInfo("originMethod.number"));
        sic.add(new SelectorItemInfo("originMethod.isLeaf"));
        sic.add(new SelectorItemInfo("useStatus.id"));
        sic.add(new SelectorItemInfo("useStatus.name"));
        sic.add(new SelectorItemInfo("useStatus.number"));
        sic.add(new SelectorItemInfo("useStatus.isLeaf"));
        sic.add(new SelectorItemInfo("useStatus.isDepreciation"));
        sic.add(new SelectorItemInfo("economicPurp.id"));
        sic.add(new SelectorItemInfo("economicPurp.name"));
        sic.add(new SelectorItemInfo("economicPurp.number"));
        sic.add(new SelectorItemInfo("economicPurp.isLeaf"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.isoCode"));
        sic.add(new SelectorItemInfo("currency.sign"));
        sic.add(new SelectorItemInfo("currency.baseUnit"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("deprMethod.*"));
        sic.add(new SelectorItemInfo("measureUnitWL.id"));
        sic.add(new SelectorItemInfo("measureUnitWL.name"));
        sic.add(new SelectorItemInfo("measureUnitWL.number"));
        sic.add(new SelectorItemInfo("accountAsset.id"));
        sic.add(new SelectorItemInfo("accountAsset.name"));
        sic.add(new SelectorItemInfo("accountAsset.number"));
        sic.add(new SelectorItemInfo("accountAsset.isLeaf"));
        sic.add(new SelectorItemInfo("accountAccuDepr.id"));
        sic.add(new SelectorItemInfo("accountAccuDepr.name"));
        sic.add(new SelectorItemInfo("accountAccuDepr.number"));
        sic.add(new SelectorItemInfo("accountAccuDepr.isLeaf"));
        sic.add(new SelectorItemInfo("accountDecValue.id"));
        sic.add(new SelectorItemInfo("accountDecValue.name"));
        sic.add(new SelectorItemInfo("accountDecValue.number"));
        sic.add(new SelectorItemInfo("accountDecValue.isLeaf"));
        sic.add(new SelectorItemInfo("company.baseCurrency.*"));
        sic.add(new SelectorItemInfo("accountAsset.longName"));
        sic.add(new SelectorItemInfo("accountAccuDepr.longName"));
        sic.add(new SelectorItemInfo("accountDecValue.longName"));
        sic.add(new SelectorItemInfo("period.beginDate"));
        sic.add(new SelectorItemInfo("period.endDate"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("evalDeprMode.number"));
        sic.add(new SelectorItemInfo("evalDeprMode.name"));
        sic.add(new SelectorItemInfo("evalDeprMode.isWorkload"));
        sic.add(new SelectorItemInfo("evalDeprMode.isCustom"));
        sic.add(new SelectorItemInfo("evalDeprMode.depValuePolicy"));
        sic.add(new SelectorItemInfo("evalDeprMode.id"));
        sic.add(new SelectorItemInfo("evalDeprMode.period"));
        sic.add(new SelectorItemInfo("evalDeprPeriodNum"));
        sic.add(new SelectorItemInfo("evalMonthRate"));
        sic.add(new SelectorItemInfo("evalAddDepr"));
        sic.add(new SelectorItemInfo("evalRemValue"));
        sic.add(new SelectorItemInfo("evalYearDepr"));
        sic.add(new SelectorItemInfo("evalDecValue"));
        sic.add(new SelectorItemInfo("evalUseTermCount"));
        sic.add(new SelectorItemInfo("evalNeatValue"));
        sic.add(new SelectorItemInfo("evalNeatAmt"));
        sic.add(new SelectorItemInfo("evalAssetValue"));
        sic.add(new SelectorItemInfo("evalTaxLeftPeriod"));
        sic.add(new SelectorItemInfo("evalDeprTTerm"));
        sic.add(new SelectorItemInfo("evalNeatLeftRate"));
        sic.add(new SelectorItemInfo("propertyValue.*"));
        String card = cardType == 0 ? "faCur" : (cardType == 1 ? "faBiz" : "faBak");
        sic.add(card + "Facility.id");
        sic.add(card + "Facility.seq");
        sic.add(card + "Facility.facilityNumber");
        sic.add(card + "Facility.facilityName");
        sic.add(card + "Facility.facilityModel");
        sic.add(card + "Facility.registerDate");
        sic.add(card + "Facility.quantity");
        sic.add(card + "Facility.amount");
        sic.add(card + "Facility.remark");
        sic.add(card + "Facility.measureUnit.id");
        sic.add(card + "Facility.measureUnit.number");
        sic.add(card + "Facility.measureUnit.name");
        sic.add(card + "Facility.storePlace.id");
        sic.add(card + "Facility.storePlace.name");
        sic.add(card + "Facility.storePlace.number");
        sic.add(card + "Facility.keeper.name");
        sic.add(card + "Facility.keeper.number");
        sic.add(card + "CostCenter.id");
        sic.add(card + "CostCenter.apportionScale");
        sic.add(card + "CostCenter.accountView.name");
        sic.add(card + "CostCenter.accountView.number");
        sic.add(card + "CostCenter.accountView.isLeaf");
        sic.add(card + "CostCenter." + card + "AsstActComposit.seq");
        sic.add(card + "CostCenter." + card + "AsstActComposit.asstActType.*");
        sic.add(card + "CostCenter." + card + "AsstActComposit.asstActItem.*");
        sic.add(card + "CostCenter.asstActType.*");
        sic.add(card + "CostCenter.asstActItem.*");
        sic.add(card + "CostCenter.seq");
        sic.add(card + "CostCenter.remark");
        sic.add(card + "CostCenter.accountView.longName");
        sic.add(card + "Department.id");
        sic.add(card + "Department.usage");
        sic.add(card + "Department.remark");
        sic.add(card + "Department.useDepartment.id");
        sic.add(card + "Department.useDepartment.name");
        sic.add(card + "Department.useDepartment.number");
        sic.add(card + "Department.useDepartment.displayName");
        sic.add(card + "Department.usePerson.id");
        sic.add(card + "Department.usePerson.name");
        sic.add(card + "Department.usePerson.name");
        sic.add(card + "Department.usePerson.number");
        return sic;
    }

    @Override
    protected void checkBeforeSave(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaDispatchBillInfo dispatchBill = (FaDispatchBillInfo)model;
        FaDispatchBillEntryCollection entryColl = dispatchBill.getFaDispatchBillEntry();
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            FaCurCardInfo card = entryColl.get(i).getFaCurCard();
            if (card == null || card.getId() == null || card.getLastUpdateTime() == null) continue;
            FaBillBizProcessor.lockFaCurCard(ctx, card.getId().toString());
            FaBillBizProcessor.checkFaCurCardVersion(ctx, card.getId().toString(), card.getLastUpdateTime());
        }
    }

    @Override
    protected void checkBeforeSubmit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaDispatchBillInfo dispatchBill = (FaDispatchBillInfo)model;
        FaDispatchBillEntryCollection entryColl = dispatchBill.getFaDispatchBillEntry();
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            FaCurCardInfo card = entryColl.get(i).getFaCurCard();
            if (card == null || card.getId() == null || card.getLastUpdateTime() == null) continue;
            FaBillBizProcessor.lockFaCurCard(ctx, card.getId().toString());
            FaBillBizProcessor.checkFaCurCardVersion(ctx, card.getId().toString(), card.getLastUpdateTime());
        }
    }

    @Override
    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        this.createBizBakTempTable(ctx, model);
        return super.submit(ctx, model);
    }

    public IObjectPK save(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        this.createBizBakTempTable(ctx, model);
        return super.save(ctx, model);
    }

    private void createBizBakTempTable(Context ctx, CoreBaseInfo model) throws BOSException {
        Map tempTableNames = AbstractPrcFaManageStrategy.createBizBakTempTable(ctx);
        model.put("tempTableNames", (Object)tempTableNames);
    }

    protected void invokeServiceBefore(ServiceContext svcCtx) throws BOSException {
        FaRPCMethodMappingUtils.invokeRPCMethodEventListener(svcCtx, FaAppLogForBusinessTypeEnum.FA_DISPATCH, FaMethodCalcOrderEnum.BEFORE);
        super.invokeServiceBefore(svcCtx);
    }

    protected void invokeServiceAfter(ServiceContext svcCtx) throws BOSException {
        FaRPCMethodMappingUtils.invokeRPCMethodEventListener(svcCtx, FaAppLogForBusinessTypeEnum.FA_DISPATCH, FaMethodCalcOrderEnum.AFTER);
        super.invokeServiceAfter(svcCtx);
    }
}

