/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaEvalDepreciationEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaEvalDepreciationEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaEvalDepreciationEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaPeriodCloseFacadeFactory;
import com.kingdee.eas.fi.fa.manage.IFaEvalDepreciationEntry;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaEvalDepreciationControllerBean;
import com.kingdee.eas.fi.fa.manage.app.FaDepLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.FaLastPeriodChangeUtils;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.math.BigDecimal;
import java.util.HashSet;

public class FaEvalDepreciationControllerBean
extends AbstractFaEvalDepreciationControllerBean {
    @Override
    protected void _updateEntryCollection(Context ctx, IObjectValue period, IObjectCollection entryCollection) throws BOSException, EASBizException {
        FaEvalDepreciationEntryCollection evalDepEntry = (FaEvalDepreciationEntryCollection)entryCollection;
        IFaEvalDepreciationEntry iEntry = FaEvalDepreciationEntryFactory.getLocalInstance(ctx);
        String companyID = FaDepLocalUtils.getCurrentCompanyId(ctx);
        PeriodInfo[] periods = FaPeriodCloseFacadeFactory.getLocalInstance(ctx).getLastestPeriod(companyID);
        if (!periods[0].getId().toString().equals(periods[1].getId().toString())) {
            HashSet cardSet = FaLastPeriodChangeUtils.getLastPeriodChangeCard(ctx, evalDepEntry);
            HashSet periodSet = FaLocalUtils.getLaterPeriodIdSet(ctx, periods[1].getId().toString());
            if (cardSet.size() > 0) {
                FaLocalUtils.hasLaterPeriodDep(ctx, companyID, periodSet, cardSet);
                FaLocalUtils.hasFANewBiz(ctx, periodSet, cardSet, companyID);
                String ids = FaLocalUtils.handleIdArray(cardSet);
                FaLastPeriodChangeUtils.updateCurCardLastPeriodChange(ctx, ids);
            }
        }
        for (int i = 0; i < evalDepEntry.size(); ++i) {
            FaEvalDepreciationEntryInfo entryInfo = evalDepEntry.get(i);
            Boolean bNeedReCalRate = (Boolean)entryInfo.get("needReCalRate");
            if (bNeedReCalRate != null && bNeedReCalRate.booleanValue()) {
                BigDecimal assetValue = entryInfo.getFaCurCard().getAssetValue();
                BigDecimal newDep = entryInfo.getDepreciation();
                BigDecimal newRate = newDep.multiply(new BigDecimal("100")).divide(assetValue, FaDepLocalUtils.getDeprRatePrecision(ctx, FaLocalUtils.getCurrentCompanyId(ctx)), 4);
                entryInfo.setMonthDepreRate(newRate);
            }
            iEntry.update((IObjectPK)new ObjectUuidPK(entryInfo.getId()), (CoreBaseInfo)entryInfo);
        }
    }

    private HashSet getLastPeriodChangeCard(Context ctx, FaEvalDepreciationEntryCollection depEntry) throws BOSException {
        HashSet<String> cardSet = new HashSet<String>();
        for (int i = 0; i < depEntry.size(); ++i) {
            FaEvalDepreciationEntryInfo entryInfo = depEntry.get(i);
            cardSet.add(entryInfo.getFaCurCard().getId().toString());
        }
        EntityViewInfo v = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        v.setFilter(f);
        v.getSelector().add(new SelectorItemInfo("id"));
        f.getFilterItems().add(new FilterItemInfo("id", cardSet, CompareType.INCLUDE));
        f.getFilterItems().add(new FilterItemInfo("lastPeriodChange", (Object)new Integer(0)));
        FaCurCardCollection cards = FaCurCardFactory.getLocalInstance(ctx).getFaCurCardCollection(v);
        cardSet.clear();
        for (int i = 0; i < cards.size(); ++i) {
            cardSet.add(cards.get(i).getId().toString());
        }
        return cardSet;
    }
}

