/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaBizCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaDepreciationEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaDepreciationEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaEvalDepreciationEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaEvalDepreciationEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaPeriodCloseFacadeFactory;
import com.kingdee.eas.fi.fa.manage.FaPeriodCloseJobInfo;
import com.kingdee.eas.fi.fa.manage.IFaChangeBill;
import com.kingdee.eas.fi.fa.manage.IFaClearBill;
import com.kingdee.eas.fi.fa.manage.IFaCurCard;
import com.kingdee.eas.fi.fa.manage.IFaSplitBill;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.framework.BillEntryBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.IBillBase;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.report.util.DBUtilx;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class FaLastPeriodChangeUtils
extends FaLocalUtils {
    private static final Logger logger = Logger.getLogger(FaLastPeriodChangeUtils.class);

    public static void updateCardLastPeriodChange(Context ctx, String companyId, String pk, int operType) throws EASBizException, BOSException {
        PeriodInfo[] periods = FaPeriodCloseFacadeFactory.getLocalInstance(ctx).getLastestPeriod(companyId);
        PeriodInfo lastestPeriod = periods[0];
        PeriodInfo curPeriod = periods[1];
        BOSObjectType bostype = BOSUuid.read((String)pk).getType();
        if (bostype.toString().equals(FASTOCKTAKINGTASK_BOSTYPE)) {
            return;
        }
        IBillBase ibill = (IBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bostype);
        if (lastestPeriod.getId().toString().equals(curPeriod.getId().toString())) {
            if (ibill instanceof IFaCurCard && operType == 0) {
                FaLastPeriodChangeUtils.deleteLaterPeriodData(ctx, curPeriod, "'" + pk + "'", "'" + companyId + "'", false);
            }
            return;
        }
        if (!(ibill instanceof IFaCurCard)) {
            CoreBaseInfo billInfo;
            IObjectCollection entries;
            String entryKey = FaManageUtils.getBillHeadEntryRelName(bostype.toString(), true);
            String cardKey = ibill instanceof IFaChangeBill || ibill instanceof IFaClearBill ? "curCard" : "faCurCard";
            String bizcardKey = ibill instanceof IFaChangeBill || ibill instanceof IFaClearBill ? "bizCard" : "faBizCard";
            String _card = entryKey + "." + cardKey;
            String _bakcard = entryKey + "." + bizcardKey + ".faBakCard";
            if (ibill instanceof IFaSplitBill) {
                String cardId = ((FaCurCardInfo)ibill.getBillBaseInfo((IObjectPK)new ObjectUuidPK(pk)).get("faCurCard")).getId().toString();
                DbUtil.execute((Context)ctx, (String)"update t_fa_facurcard set FLastPeriodChange=1,flastupdatetime = GETDATE() where fid=?", (Object[])new Object[]{cardId});
            }
            if ((entries = (IObjectCollection)(billInfo = ibill.getValue("select id," + _card + ".id," + _card + ".bizStatus," + _card + ".lastPeriodChange," + _bakcard + ".id where id='" + pk + "'")).get(entryKey)).size() == 0) {
                return;
            }
            for (int i = 0; i < entries.size(); ++i) {
                FaCurCardInfo curcard = (FaCurCardInfo)entries.getObject(i).getObjectValue(cardKey);
                FaBizCardInfo bizcard = (FaBizCardInfo)entries.getObject(i).getObjectValue(bizcardKey);
                if (curcard == null || bizcard == null) continue;
                if (operType == 5) {
                    if (curcard.isLastPeriodChange()) continue;
                    DbUtil.execute((Context)ctx, (String)"update t_fa_facurcard set FLastPeriodChange=1,flastupdatetime = GETDATE() where fid=?", (Object[])new Object[]{curcard.getId().toString()});
                    DbUtil.execute((Context)ctx, (String)"update t_fa_fabakcard set FLastPeriodChange=1 where fid=?", (Object[])new Object[]{bizcard.getFaBakCard().getId().toString()});
                    continue;
                }
                if (operType == 1 || operType == 3) {
                    if (!curcard.getBizStatus().getValue().endsWith("99")) continue;
                    if (!curcard.isLastPeriodChange()) {
                        DbUtil.execute((Context)ctx, (String)"update t_fa_facurcard set FLastPeriodChange=1,flastupdatetime = GETDATE() where fid=?", (Object[])new Object[]{curcard.getId().toString()});
                        continue;
                    }
                    if (bizcard == null) continue;
                    try {
                        DBUtilx.executeUpdate((String)"update t_fa_fabakcard set FLastPeriodChange=1  where fid=(select c.fid from t_fa_fabakcard c inner join t_fa_fabizcard b on c.fid=b.ffabakcardid where b.fid=?)", (SqlParams)new SqlParams().addString(bizcard.getId().toString()), (Context)ctx);
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                    continue;
                }
                if (operType != 4) continue;
                DbUtil.execute((Context)ctx, (String)"update t_fa_facurcard set FLastPeriodChange=1,flastupdatetime = GETDATE() where fid=?", (Object[])new Object[]{curcard.getId().toString()});
            }
        } else if (operType != 0) {
            DbUtil.execute((Context)ctx, (String)"update t_fa_facurcard set FLastPeriodChange=1,flastupdatetime = GETDATE() where fid=?", (Object[])new Object[]{pk.toString()});
        } else {
            FaLastPeriodChangeUtils.deleteLaterPeriodData(ctx, curPeriod, "'" + pk + "'", "'" + companyId + "'", false);
        }
    }

    public static void deleteLaterPeriodData(Context ctx, PeriodInfo currPeriod, String cardIdSql, String companyId, boolean isFromInitCard) throws BOSException {
        if (companyId.indexOf("'") == -1) {
            throw new IllegalArgumentException(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"83_FaLocalUtils", (Locale)ctx.getOriginLocale()));
        }
        String includeCurrPeriodSql = "select fid from t_bd_period where fperiodyear>" + currPeriod.getPeriodYear() + " or fperiodyear=" + currPeriod.getPeriodYear() + " and fperiodnumber>=" + currPeriod.getPeriodNumber();
        String includeLaterPeriodSql = "select fid from t_bd_period where fperiodyear>" + currPeriod.getPeriodYear() + " or fperiodyear=" + currPeriod.getPeriodYear() + " and fperiodnumber>" + currPeriod.getPeriodNumber();
        String depPeriodSql = null;
        depPeriodSql = isFromInitCard ? includeCurrPeriodSql : includeLaterPeriodSql;
        DbUtil.execute((Context)ctx, (String)("delete from t_fa_faevaldepreciationentry where FFaCurCardID in(" + cardIdSql + ") and FLnkFaDepreEntry in(select fid from t_fa_faevaldepreciation where Fperiod in(" + depPeriodSql + "))"));
        DbUtil.execute((Context)ctx, (String)("delete from t_fa_faevaldepreciation where fcompanyid in(" + companyId + ") and fid not in(select FLnkFaDepreEntry from t_fa_faevaldepreciationentry)"));
        DbUtil.execute((Context)ctx, (String)("delete from t_fa_fadepreciationentry where FFaCurCardID in(" + cardIdSql + ") and FLnkFaDepreEntry in(select fid from t_fa_fadepreciation where Fperiod in(" + depPeriodSql + "))"));
        DbUtil.execute((Context)ctx, (String)("delete from t_fa_fadepreciation where fcompanyid in(" + companyId + ") and fdeptype <> " + 2 + " and fid not in(select FLnkFaDepreEntry from t_fa_fadepreciationentry)"));
        DbUtil.execute((Context)ctx, (String)("delete from T_FA_FaWorkLoad where FCurCardID in(" + cardIdSql + ") and FPeriodID in(" + depPeriodSql + ")"));
        DbUtil.execute((Context)ctx, (String)("delete from t_fa_faaccountbalance where FFaCurCardID in(" + cardIdSql + ") and FPeriodID in (" + includeLaterPeriodSql + ")"));
        String selectMonCard = "select fid from t_fa_famoncard where ffacurcardid in(" + cardIdSql + ") and ffaperiodid in (" + includeCurrPeriodSql + ")";
        DbUtil.execute((Context)ctx, (String)("delete from t_fa_famoninitdata where ffamoncardid in (" + selectMonCard + ")"));
        DbUtil.execute((Context)ctx, (String)("delete from t_fa_famonfacility where ffamoncardid in (" + selectMonCard + ")"));
        DbUtil.execute((Context)ctx, (String)("delete from t_fa_famoncostcenter where ffamoncardid in (" + selectMonCard + ")"));
        DbUtil.execute((Context)ctx, (String)("delete from t_fa_famondepartment where ffamoncardid in (" + selectMonCard + ")"));
        DbUtil.execute((Context)ctx, (String)("delete from t_fa_famoncard where fid in (" + selectMonCard + ")"));
    }

    public static String getLastPeriodChangeCardId(Context ctx, String companyId, PeriodInfo period) throws BOSException {
        if (companyId.indexOf("'") == -1) {
            throw new IllegalArgumentException(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"83_FaLocalUtils", (Locale)ctx.getOriginLocale()));
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select curcard.fid from t_fa_facurcard curcard \t\t\t\t\r\n");
        sql.append(" inner join t_bd_period pd on pd.fid = curcard.fperiodid \t\r\n");
        sql.append(" where curcard.fcompanyid in(" + companyId + ") \t\t\t\r\n");
        sql.append("   and pd.fnumber <= " + period.getNumber() + "\t\t\t\t\r\n");
        sql.append("   and curcard.FLastPeriodChange = 1\t\t\t\t\t\t\r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        StringBuffer idBuff = new StringBuffer();
        try {
            while (rs.next()) {
                idBuff.append("'").append(rs.getString(1)).append("',");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return idBuff.length() == 0 ? "" : idBuff.substring(0, idBuff.length() - 1);
    }

    public static String getLastPeriodChangeCardSql(Context ctx, String companyId, PeriodInfo period, String tempTable) throws BOSException {
        if (companyId.indexOf("'") == -1) {
            throw new IllegalArgumentException(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"83_FaLocalUtils", (Locale)ctx.getOriginLocale()));
        }
        StringBuffer sqlBuff = new StringBuffer();
        sqlBuff.append("select count(cur.fid) from t_fa_facurcard cur \t\t\t\t\r\n");
        sqlBuff.append(" inner join t_bd_period pd on pd.fid = cur.fperiodid \t\t\r\n");
        sqlBuff.append(" where cur.fcompanyid in(" + companyId + ") \t\t\t\t\r\n");
        sqlBuff.append("   and pd.fnumber <= " + period.getNumber() + "\t\t\t\t\r\n");
        sqlBuff.append("   and cur.FLastPeriodChange = 1\t\t\t\t\t\t\t\r\n");
        sqlBuff.append(" union \n");
        sqlBuff.append(" select count(fid) from ( SELECT cur.fid, mon.FLASTBILLID monLASTBILLID,cur.FLASTBILLID curLASTBILLID FROM T_FA_FACURCARD cur \n");
        sqlBuff.append(" INNER JOIN T_FA_FAMONCARD mon on cur.fid = mon.FFACURCARDID and  mon.FFAPERIODID = '" + period.getId().toString() + "' \n");
        sqlBuff.append(" where  mon.FCOMPANYID  = " + companyId + " ) a \n");
        sqlBuff.append(" where monLASTBILLID is null and curLASTBILLID is not null or monLASTBILLID is not null and curLASTBILLID is null or monLASTBILLID <> curLASTBILLID \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString());
        String sql = "";
        try {
            int num = 0;
            while (rs.next()) {
                num += rs.getInt(1);
            }
            if (num > 0) {
                sql = sqlBuff.toString().replace("count(cur.fid)", "cur.fid");
                sql = sql.replace("count(fid)", "fid");
                String executeSql = "insert into " + tempTable + " " + sql.toString();
                DbUtil.execute((Context)ctx, (String)executeSql);
                return "select FFaCurCardID from " + tempTable;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return sql;
    }

    protected static HashSet getLastPeriodChangeCard(Context ctx, FaDepreciationEntryCollection depEntry) throws BOSException {
        HashSet<String> cardSet = new HashSet<String>();
        for (int i = 0; i < depEntry.size(); ++i) {
            FaDepreciationEntryInfo entryInfo = depEntry.get(i);
            cardSet.add(entryInfo.getFaCurCard().getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        filter.getFilterItems().add(new FilterItemInfo("id", cardSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("lastPeriodChange", (Object)new Integer(0)));
        FaCurCardCollection cards = FaCurCardFactory.getLocalInstance(ctx).getFaCurCardCollection(view);
        cardSet.clear();
        for (int i = 0; i < cards.size(); ++i) {
            cardSet.add(cards.get(i).getId().toString());
        }
        return cardSet;
    }

    protected static HashSet getLastPeriodChangeCard(Context ctx, FaEvalDepreciationEntryCollection evalDepEntry) throws BOSException {
        HashSet<String> cardSet = new HashSet<String>();
        for (int i = 0; i < evalDepEntry.size(); ++i) {
            FaEvalDepreciationEntryInfo entryInfo = evalDepEntry.get(i);
            cardSet.add(entryInfo.getFaCurCard().getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        filter.getFilterItems().add(new FilterItemInfo("id", cardSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("lastPeriodChange", (Object)new Integer(0)));
        FaCurCardCollection cards = FaCurCardFactory.getLocalInstance(ctx).getFaCurCardCollection(view);
        cardSet.clear();
        for (int i = 0; i < cards.size(); ++i) {
            cardSet.add(cards.get(i).getId().toString());
        }
        return cardSet;
    }

    public static void updateCardLastPeriodChange(Context ctx, IObjectPK pk) throws BOSException {
        DbUtil.execute((Context)ctx, (String)"update t_fa_famoncard set FLastPeriodChange =1 where fid =?", (Object[])new Object[]{pk.toString()});
        DbUtil.execute((Context)ctx, (String)"update t_fa_facurcard set FLastPeriodChange =1 where fid =(select FFaCurCardID from t_fa_famoncard where fid=?)", (Object[])new Object[]{pk.toString()});
    }

    public static void updateCurCardLastPeriodChange(Context ctx, String ids) throws BOSException {
        DbUtil.execute((Context)ctx, (String)("update t_fa_facurcard set FlastPeriodChange=1,flastupdatetime = GETDATE() where fid " + ids));
    }

    public static void updateCurCardLastPeriodChangeForImport(Context ctx, String cardId) throws BOSException {
        DbUtil.execute((Context)ctx, (String)"update t_fa_facurcard set FLastPeriodChange=1,flastupdatetime = GETDATE() where fid=?", (Object[])new Object[]{cardId});
    }

    public static void updateMonCardLastPeriodChangeForImoport(Context ctx, String[] cardIds) throws BOSException {
        DbUtil.execute((Context)ctx, (String)"update t_fa_facurcard set FLastPeriodChange=1,flastupdatetime = GETDATE() where fid=?", (Object[])new Object[]{cardIds[0]});
        DbUtil.execute((Context)ctx, (String)"update t_fa_famoncard set FLastPeriodChange=1 where fid=?", (Object[])new Object[]{cardIds[1]});
    }

    public static void updateCardLastPeriodChange(Context ctx, String companyId) throws EASBizException, BOSException {
        StringBuffer deleteAttachSql = new StringBuffer("");
        deleteAttachSql.append("delete from T_BAS_Attachment where fid in  ");
        deleteAttachSql.append("( select att.fid from T_BAS_Attachment att ");
        deleteAttachSql.append("inner join T_BAS_BoAttchAsso asso on att.fid = asso.FAttachmentID ");
        deleteAttachSql.append("inner join T_FA_FaMonCard mon on asso.FBoID = mon.ffacurCardId ");
        deleteAttachSql.append("where mon.fcompanyId = '" + companyId + "' and mon.FOriginFlag = 0 ");
        deleteAttachSql.append("and mon.flastPeriodChange = 1 and mon.FFaPeriodID is null   )");
        DbUtil.execute((Context)ctx, (String)deleteAttachSql.toString());
        StringBuffer deleteAttachNoSql = new StringBuffer("");
        deleteAttachNoSql.append("delete from T_BAS_BoAttchAsso where fid in  ");
        deleteAttachNoSql.append("( select asso.fid from T_BAS_BoAttchAsso asso ");
        deleteAttachNoSql.append("inner join T_FA_FaMonCard mon on asso.FBoID = mon.ffacurCardId ");
        deleteAttachNoSql.append("where mon.fcompanyId = '" + companyId + "' and mon.FOriginFlag = 0 ");
        deleteAttachNoSql.append("and mon.flastPeriodChange = 1 and mon.FFaPeriodID is null   )");
        DbUtil.execute((Context)ctx, (String)deleteAttachNoSql.toString());
        StringBuffer curCardIdSql = new StringBuffer("");
        curCardIdSql.append("select ffacurCardId from T_fa_FaMonCard ");
        curCardIdSql.append("where fcompanyId = '" + companyId + "' and foriginFlag = 0 and flastPeriodChange = 1 and FFaPeriodID is null ");
        FaLastPeriodChangeUtils.deleteLaterPeriodData(ctx, FaLocalUtils.getCurrentPeriod(ctx, companyId), curCardIdSql.toString(), "'" + companyId + "'", true);
        StringBuffer monCardIdSql = new StringBuffer("");
        monCardIdSql.append("select fid from T_fa_FaMonCard ");
        monCardIdSql.append("where fcompanyId = '" + companyId + "' and foriginFlag = 0 and flastPeriodChange = 1 and FFaPeriodID is null ");
        DbUtil.execute((Context)ctx, (String)("update t_fa_famoncard set FLastPeriodChange=0 where fid in (" + monCardIdSql.toString() + " )"));
        PeriodInfo[] p = FaPeriodCloseFacadeFactory.getLocalInstance(ctx).getLastestPeriod(companyId);
        FaLocalUtils.updateRedeprIdentifyCard(ctx, p[1], "'" + companyId + "'");
        if (p[0].getId().toString().equals(p[1].getId().toString())) {
            DbUtil.execute((Context)ctx, (String)("update t_fa_facurcard set FLastPeriodChange=0,flastupdatetime = GETDATE() where FCompanyID = '" + companyId + "'"));
        }
        FaLocalUtils.updateCardLaterDataIdentity(ctx, p[1], "'" + companyId + "'");
    }

    protected static void restoreBakAndCleanUp(Context ctx, CoreBaseInfo info, String[] includes, String[] ignores) throws EASBizException, BOSException {
        if (info.getId() == null) {
            return;
        }
        String entryName = FaManageUtils.getBillHeadEntryRelName(info.getBOSType().toString(), true);
        String getBakIdSql = "select id," + entryName + "." + FaLastPeriodChangeUtils.getCurCardFieldName() + ".id," + entryName + "." + FaLastPeriodChangeUtils.getBizCardFieldName() + ".id," + entryName + "." + FaLastPeriodChangeUtils.getBizCardFieldName() + ".faBakCard.id where id ='" + info.getId() + "'";
        ICoreBase icorebase = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)info.getBOSType());
        CoreBaseInfo newInfo = icorebase.getValue(getBakIdSql);
        if (newInfo.get(entryName) == null || ((IObjectCollection)newInfo.get(entryName)).size() == 0) {
            return;
        }
        IObjectCollection entries = (IObjectCollection)newInfo.get(entryName);
        IObjectPK[] bakCardIds = new IObjectPK[entries.size()];
        IObjectPK[] bizCardIds = new IObjectPK[entries.size()];
        StringBuffer cardIdBuffs = new StringBuffer();
        StringBuffer bakCardIdBuffs = new StringBuffer();
        for (int i = 0; i < entries.size(); ++i) {
            BillEntryBaseInfo entry = (BillEntryBaseInfo)entries.getObject(i);
            FaCurCardInfo curcard = (FaCurCardInfo)entry.get(FaLastPeriodChangeUtils.getCurCardFieldName());
            FaBizCardInfo bizcard = (FaBizCardInfo)entry.get(FaLastPeriodChangeUtils.getBizCardFieldName());
            if (curcard == null || bizcard == null) continue;
            String bakCardPk = bizcard.getFaBakCard().getId().toString();
            bakCardIds[i] = new ObjectUuidPK(bakCardPk);
            bizCardIds[i] = new ObjectUuidPK(bizcard.getId().toString());
            cardIdBuffs.append("'" + curcard.getId() + "',");
            bakCardIdBuffs.append("'" + bakCardPk + "',");
        }
        if (cardIdBuffs.length() == 0) {
            return;
        }
        StringBuffer updateColumns = new StringBuffer();
        StringBuffer selectBakColumns = new StringBuffer();
        if (includes != null && includes.length > 0) {
            for (int i = 0; i < includes.length; ++i) {
                if (includes[i].equalsIgnoreCase("flastupdatetime") || includes[i].equalsIgnoreCase("fcreatetime")) continue;
                updateColumns.append(includes[i] + ",");
                selectBakColumns.append("bakcard." + includes[i] + ",");
            }
            updateColumns.append("flastperiodchange,");
            selectBakColumns.append("bakcard.flastperiodchange,");
        } else {
            if (ignores == null) {
                ignores = new String[]{};
            }
            String[] ignoreArray = new String[ignores.length + 5];
            System.arraycopy(ignores, 0, ignoreArray, 0, ignores.length);
            ignoreArray[ignoreArray.length - 1] = "fid";
            ignoreArray[ignoreArray.length - 2] = "flastupdatetime";
            ignoreArray[ignoreArray.length - 3] = "fcreatetime";
            ignoreArray[ignoreArray.length - 4] = "fiVouchered";
            ignoreArray[ignoreArray.length - 5] = "voucher";
            List columns = FaLocalUtils.getTableColumn(ctx, (CoreBaseInfo)new FaCurCardInfo(), ignoreArray);
            for (int i = 0; i < columns.size(); ++i) {
                updateColumns.append(columns.get(i) + ",");
                selectBakColumns.append("bakcard." + columns.get(i) + ",");
            }
        }
        StringBuffer sql = new StringBuffer("update t_fa_facurcard set (");
        sql.append(updateColumns);
        sql.append("flastupdatetime) = (select ");
        sql.append(selectBakColumns);
        sql.append("getdate() from t_fa_fabakcard bakcard where bakcard.fid in (");
        sql.append(bakCardIdBuffs.substring(0, bakCardIdBuffs.length() - 1));
        sql.append(") and bakcard.ffacurcardid = t_fa_facurcard.fid) where t_fa_facurcard.fid in (");
        sql.append(cardIdBuffs.substring(0, cardIdBuffs.length() - 1)).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        FaLastPeriodChangeUtils.deleteBizBakCard(ctx, bizCardIds, bakCardIds);
    }

    protected static void deleteBizBakCard(Context ctx, IObjectPK[] bizCardIds, IObjectPK[] bakCardIds) throws BOSException {
        int i;
        StringBuffer bizCardIdArray = new StringBuffer();
        StringBuffer bakCardIdArray = new StringBuffer();
        int batchSize = 100;
        if (bizCardIds != null && bizCardIds.length > 0) {
            for (i = 0; i < bizCardIds.length; ++i) {
                if (bizCardIds[i] == null) continue;
                bizCardIdArray.append("'" + bizCardIds[i] + "',");
                if ((i + 1) % batchSize != 0) continue;
                FaLastPeriodChangeUtils.deleteBizBakCard(ctx, bizCardIdArray.substring(0, bizCardIdArray.length() - 1), null);
                bizCardIdArray = new StringBuffer();
            }
            if (bizCardIdArray.length() > 0) {
                FaLastPeriodChangeUtils.deleteBizBakCard(ctx, bizCardIdArray.substring(0, bizCardIdArray.length() - 1), null);
            }
        }
        if (bakCardIds != null && bakCardIds.length > 0) {
            for (i = 0; i < bakCardIds.length; ++i) {
                if (bakCardIds[i] == null) continue;
                bakCardIdArray.append("'" + bakCardIds[i] + "',");
                if ((i + 1) % batchSize != 0) continue;
                FaLastPeriodChangeUtils.deleteBizBakCard(ctx, null, bakCardIdArray.substring(0, bakCardIdArray.length() - 1));
                bakCardIdArray = new StringBuffer();
            }
            if (bakCardIdArray.length() > 0) {
                FaLastPeriodChangeUtils.deleteBizBakCard(ctx, null, bakCardIdArray.substring(0, bakCardIdArray.length() - 1));
            }
        }
    }

    protected static void deleteBizBakCard(Context ctx, String bizCardIds, String bakCardIds) throws BOSException {
        if (bizCardIds != null && bizCardIds.trim().length() > 0) {
            DbUtil.execute((Context)ctx, (String)("delete from t_fa_fabizAsstActComposit where fFabizCostCenterId in  (select fid from t_fa_fabizcostcenter where ffabizcardid in (" + bizCardIds + ") )"));
            DbUtil.execute((Context)ctx, (String)("delete from t_fa_fabizcostcenter where ffabizcardid in (" + bizCardIds + ")"));
            DbUtil.execute((Context)ctx, (String)("delete from t_fa_fabizdepartment where ffabizcardid in (" + bizCardIds + ")"));
            DbUtil.execute((Context)ctx, (String)("delete from t_fa_fabizfacility where ffabizcardid in (" + bizCardIds + ")"));
            DbUtil.execute((Context)ctx, (String)("delete from t_fa_fabizinitdata where ffabizcardid in (" + bizCardIds + ")"));
            DbUtil.execute((Context)ctx, (String)("delete from t_fa_fabizcard where fid in (" + bizCardIds + ")"));
        }
        if (bakCardIds != null && bakCardIds.trim().length() > 0) {
            DbUtil.execute((Context)ctx, (String)("delete from t_fa_fabakAsstActComposit where fFabakCostCenterId in  (select fid from t_fa_fabakcostcenter where ffabakcardid in (" + bakCardIds + ") )"));
            DbUtil.execute((Context)ctx, (String)("delete from t_fa_fabakcostcenter where ffabakcardid in (" + bakCardIds + ")"));
            DbUtil.execute((Context)ctx, (String)("delete from t_fa_fabakdepartment where ffabakcardid in (" + bakCardIds + ")"));
            DbUtil.execute((Context)ctx, (String)("delete from t_fa_fabakfacility where ffabakcardid in (" + bakCardIds + ")"));
            DbUtil.execute((Context)ctx, (String)("delete from t_fa_fabakinitdata where ffabakcardid in (" + bakCardIds + ")"));
            DbUtil.execute((Context)ctx, (String)("delete from t_fa_fabakcard where fid in (" + bakCardIds + ")"));
        }
    }

    private static String getCurCardFieldName() {
        return "faCurCard";
    }

    private static String getBizCardFieldName() {
        return "faBizCard";
    }

    protected static void updateCurCardBySQL(Context ctx, String bizStatus, String lastBillID, String curCardID, boolean isLastPeriodChange) throws BOSException {
        String sql = "update T_FA_FACURCARD set fbizStatus = '" + bizStatus + "',flastBillID = " + (lastBillID == null ? "NULL" : "'" + lastBillID + "'") + ",FLastPeriodChange=" + (isLastPeriodChange ? 1 : 0) + ",flastupdatetime = GETDATE() where fid = '" + curCardID + "'";
        Connection conn = null;
        Statement stm = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stm = conn.createStatement();
            int num = stm.executeUpdate(sql);
            if (num < 1) {
                logger.error((Object)("+++++++++++++++++++++lijianqing PrcFaClearStrategy++++++++++++++++++++++++++++" + sql));
                throw new BOSException("\u66f4\u65b0\u5f53\u524d\u5361\u7247\u7684\u4e1a\u52a1\u72b6\u6001\u5931\u8d25\uff01");
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)("+++++++++++++++++++++lijianqing PrcFaClearStrategy SQLException++++++++++++++++++++++++++++" + sql));
                logger.error((Object)("+++++++++++++++++++++lijianqing PrcFaClearStrategy SQLException++++++++++++++++++++++++++++" + e.getMessage()));
                throw new BOSException("\u66f4\u65b0\u5f53\u524d\u5361\u7247\u7684\u4e1a\u52a1\u72b6\u6001\u5931\u8d25\uff01", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stm, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stm, (Connection)conn);
    }

    protected static void updateCurCardBySQLThisLastBillID(Context ctx, String bizStatus, String lastBillID, String curCardID, boolean isLastPeriodChange) throws BOSException {
        String sql = "update T_FA_FACURCARD set fbizStatus = '" + bizStatus + "',flastBillID = " + (lastBillID == null ? "NULL" : "'" + lastBillID + "'") + ",FLastPeriodChange=" + (isLastPeriodChange ? 1 : 0) + ",flastupdatetime = GETDATE() where fid = '" + curCardID + "' and flastBillID = '" + lastBillID + "'";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    protected static void updateCardWhenPeriodClose(Context ctx, String companyId, PeriodInfo period, String ids) throws BOSException {
        if (ids.length() > 0) {
            DbUtil.execute((Context)ctx, (String)("update t_fa_fabizcard set FLastPeriodChange=0 where ffabakcardid in(select fid from t_fa_fabakcard where fcompanyid=" + companyId + " and ffacurcardid in(" + ids + "))"));
            DbUtil.execute((Context)ctx, (String)("update t_fa_fabakcard set FLastPeriodChange=0 where fcompanyid in(" + companyId + ") and ffacurcardid in(" + ids + ")"));
            DbUtil.execute((Context)ctx, (String)("update t_fa_famoncard set FLastPeriodChange=0 where fcompanyid in(" + companyId + ") and ffaperiodid='" + period.getId() + "'"));
        }
    }

    protected static void updateCardWhenPeriodCloseForBigData(Context ctx, String strCompanyId, PeriodInfo period, String ids) throws BOSException {
        String companyId = "'" + strCompanyId + "'";
        if (ids.length() > 0) {
            DbUtil.execute((Context)ctx, (String)("update t_fa_fabizcard set FLastPeriodChange=0 where ffabakcardid in(select fid from t_fa_fabakcard where fcompanyid=" + companyId + " and ffacurcardid in(" + ids + "))"));
            DbUtil.execute((Context)ctx, (String)("update t_fa_fabakcard set FLastPeriodChange=0 where fcompanyid in(" + companyId + ") and ffacurcardid in(" + ids + ")"));
            FaPeriodCloseJobInfo info = FaLastPeriodChangeUtils.getPeriodCloseJob(ctx, strCompanyId, period.getId().toString());
            if (info == null) {
                throw new IllegalArgumentException("Is not the Lastest Period, get FaPeriodCloseJob null, error!");
            }
            String monCardTempTable = info.getFaMonCard();
            DbUtil.execute((Context)ctx, (String)("update " + monCardTempTable + " set FLastPeriodChange=0 where fcompanyid in(" + companyId + ") and ffaperiodid='" + period.getId() + "'"));
        }
    }
}

