/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseException;
import com.kingdee.eas.fi.fa.manage.IFaLeaseBalanceEntry;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaLeaseBalanceBillControllerBean;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Locale;

public class FaLeaseBalanceBillControllerBean
extends AbstractFaLeaseBalanceBillControllerBean {
    @Override
    protected void _checkBill(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("checkStatus");
        sic.add("period.id");
        sic.add("checker.id");
        sic.add("checkTime");
        sic.add("lastUpdateTime");
        IFaLeaseBalanceEntry iCheck = FaLeaseBalanceEntryFactory.getLocalInstance(ctx);
        FaLeaseBalanceEntryInfo entry = iCheck.getFaLeaseBalanceEntryInfo(pk, sic);
        this.checkPeriod(ctx, entry);
        if (entry.isCheckStatus()) {
            throw new FaLeaseException(FaLeaseException.PAYMENTHASCHECK);
        }
        entry.setCheckStatus(true);
        entry.setChecker(ContextUtil.getCurrentUserInfo((Context)ctx));
        entry.setCheckTime(new Date());
        entry.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        iCheck.updatePartial((CoreBaseInfo)entry, sic);
    }

    @Override
    protected void _unCheckBill(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("checkStatus");
        sic.add("checkedStatus");
        sic.add("period.id");
        sic.add("checker.id");
        sic.add("checkTime");
        sic.add("lastUpdateTime");
        IFaLeaseBalanceEntry iCheck = FaLeaseBalanceEntryFactory.getLocalInstance(ctx);
        FaLeaseBalanceEntryInfo entry = iCheck.getFaLeaseBalanceEntryInfo(pk, sic);
        this.checkPeriod(ctx, entry);
        if (!entry.isCheckStatus()) {
            throw new FaLeaseException(FaLeaseException.PAYMENTNOTCHECK);
        }
        if (entry.getCheckedStatus().getValue() == 2) {
            throw new FaLeaseException(FaLeaseException.PAYMENTHASAUDIT);
        }
        entry.setCheckStatus(false);
        entry.setChecker(null);
        entry.setCheckTime(null);
        entry.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        iCheck.updatePartial((CoreBaseInfo)entry, sic);
    }

    private void checkPeriod(Context ctx, FaLeaseBalanceEntryInfo entry) throws BOSException, EASBizException, FaLeaseException {
        PeriodInfo currentPeriod = FaLocalUtils.getCurrentPeriod(ctx);
        if (!entry.getPeriod().getId().toString().equals(currentPeriod.getId().toString())) {
            throw new FaLeaseException(FaLeaseException.PAYMENTNOTINPERIOD);
        }
    }

    @Override
    protected void _auditBill(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("checkStatus");
        sic.add("checkedStatus");
        sic.add("period.id");
        sic.add("lastUpdateTime");
        sic.add("auditor.id");
        sic.add("auditTime");
        IFaLeaseBalanceEntry iCheck = FaLeaseBalanceEntryFactory.getLocalInstance(ctx);
        FaLeaseBalanceEntryInfo entry = iCheck.getFaLeaseBalanceEntryInfo(pk, sic);
        this.checkPeriod(ctx, entry);
        if (!entry.isCheckStatus()) {
            throw new FaLeaseException(FaLeaseException.PAYMENTNOTCHECK);
        }
        if (entry.getCheckedStatus().getValue() == 2) {
            throw new FaLeaseException(FaLeaseException.PAYMENTHASAUDIT);
        }
        entry.setCheckedStatus(CheckedStatusEnum.AUDITED);
        Timestamp currTime = new Timestamp(System.currentTimeMillis());
        entry.setLastUpdateTime(currTime);
        entry.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        entry.setAuditTime(currTime);
        iCheck.updatePartial((CoreBaseInfo)entry, sic);
    }

    @Override
    protected void _unauditBill(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IFaLeaseBalanceEntry iCheck = FaLeaseBalanceEntryFactory.getLocalInstance(ctx);
        FaLeaseBalanceEntryInfo savedEntry = iCheck.getFaLeaseBalanceEntryInfo("select bill.leaseOutBill.bizStatus,bill.leaseInBill.bizStatus where id='" + pk + "'");
        if (savedEntry.getBill().getLeaseInBill() != null ? savedEntry.getBill().getLeaseInBill().getBizStatus().getValue() == 5 : savedEntry.getBill().getLeaseOutBill().getBizStatus().getValue() == 5) {
            throw new FaLeaseException(FaLeaseException.BILLHADCLOSED);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("checkedStatus");
        sic.add("fiVouchered");
        sic.add("period.id");
        sic.add("lastUpdateTime");
        sic.add("auditor.id");
        sic.add("auditTime");
        FaLeaseBalanceEntryInfo entry = iCheck.getFaLeaseBalanceEntryInfo(pk, sic);
        this.checkPeriod(ctx, entry);
        if (entry.getCheckedStatus().getValue() == 1) {
            throw new FaLeaseException(FaLeaseException.PAYMENTNOTAUDIT);
        }
        if (entry.isFiVouchered()) {
            throw new FaLeaseException(FaLeaseException.PAYMENTHASVOUCHER);
        }
        entry.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        Timestamp currTime = new Timestamp(System.currentTimeMillis());
        entry.setLastUpdateTime(currTime);
        entry.setAuditor(null);
        entry.setAuditTime(null);
        iCheck.updatePartial((CoreBaseInfo)entry, sic);
    }

    @Override
    protected void _checkUnAuditPayment(Context ctx, IObjectPK billid) throws BOSException, EASBizException {
        if (billid == null) {
            return;
        }
        String sql = "select e.fnumber,e.FIsPayment from T_FA_FaLeaseBalanceBill b inner join T_FA_FaLeaseBalanceEntry e on b.fid=e.fbillid ";
        sql = sql + "where (b.FLeaseOutBillID='" + billid + "' or b.FLeaseInBillID='" + billid + "') and e.FCheckedStatus=1 order by e.FIsPayment";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        String payBillTxt = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaLeaseResource.paymentBill", (Locale)ctx.getOriginLocale());
        String recvBillTxt = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaLeaseResource.gatheringBill", (Locale)ctx.getOriginLocale());
        StringBuffer msg = new StringBuffer();
        int lastPaymentType = 0;
        try {
            while (rs.next()) {
                int isPayment = rs.getInt(2);
                String number = rs.getString(1);
                if (msg.length() == 0) {
                    if (isPayment == 1) {
                        msg.append(payBillTxt + "[").append(number);
                        lastPaymentType = 1;
                        continue;
                    }
                    msg.append(recvBillTxt + "[").append(number);
                    continue;
                }
                if (isPayment == 1) {
                    if (isPayment != lastPaymentType) {
                        msg.append("]," + payBillTxt + "[").append(number);
                        lastPaymentType = 1;
                        continue;
                    }
                    msg.append("\u3001").append(number);
                    continue;
                }
                msg.append("\u3001").append(number);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (msg.length() > 0) {
            msg.append("]");
            throw new FaLeaseException(FaLeaseException.HASUNAUDITPAYMENT, new Object[]{msg.toString()});
        }
    }
}

