/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaContractCatInfo;
import com.kingdee.eas.fi.fa.manage.FaBillBizProcessor;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.FaChangeBillInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseBizStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaLeaseChangeBillCollection;
import com.kingdee.eas.fi.fa.manage.FaLeaseChangeBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaLeaseChangeBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseChangeBillFactory;
import com.kingdee.eas.fi.fa.manage.FaLeaseChangeBillInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillNewCollection;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillNewFactory;
import com.kingdee.eas.fi.fa.manage.FaLessorTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaRentDirectionEnum;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaLeaseChangeBillControllerBean;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.IBillBase;
import com.kingdee.eas.framework.ObjectValueUtil;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FaLeaseChangeBillControllerBean
extends AbstractFaLeaseChangeBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.manage.app.FaLeaseChangeBillControllerBean");
    public static final String RES_PATH_CARD = "com.kingdee.eas.fi.fa.manage.FaCardResource";
    public static final String RES_PATH_LEASECHANGE = "com.kingdee.eas.fi.fa.manage.FaLeaseChangeResource";
    private CompanyOrgUnitInfo currCompany;
    private PeriodInfo curPeriod;

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkModel(model);
        FaLeaseChangeBillInfo billInfo = (FaLeaseChangeBillInfo)model;
        FaLeaseChangeBillEntryCollection entries = billInfo.getEntries();
        this.lockLeaseChangeBill(ctx, billInfo.get("id"));
        this.lockLeaseBill(ctx, entries, billInfo.getRentDirection());
        if (billInfo.getId() == null && entries != null && entries.size() > 0) {
            this.checkFaLeaseBillBlock(ctx, billInfo);
        }
        this.checkForSave(ctx, (IObjectValue)billInfo);
        this.updateOldFields(ctx, billInfo);
        if (billInfo.getId() != null) {
            this.restoreLeaseBillStatus(ctx, (IObjectPK)new ObjectUuidPK(billInfo.getId()));
        }
        this.setRuleNumber(ctx, billInfo, FaLeaseChangeBillFactory.getLocalInstance(ctx));
        billInfo.setFiVouchered(false);
        billInfo.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        billInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        billInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
        Timestamp time = new Timestamp(new Date().getTime());
        if (billInfo.getId() == null) {
            billInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
            billInfo.setCreateTime(time);
        }
        billInfo.setLastUpdateTime(time);
        billInfo.setPeriod(this.getCurrentPeriod(ctx, billInfo));
        if (entries != null && entries.size() > 0) {
            FaRentDirectionEnum renDir = billInfo.getRentDirection();
            this.updateLeaseBillStatus(ctx, this.leaseIdCol2Str((IObjectCollection)entries, renDir), renDir, true, FaLeaseBizStatusEnum.CHANGING);
        }
        return super._save(ctx, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        try {
            CompanyOrgUnitInfo comp = (CompanyOrgUnitInfo)model.get("company");
            FaChangeBillInfo changeBillInfo = (FaChangeBillInfo)model.get("changeBill");
            this.setWorkflowServiceState(ctx, comp == null ? null : comp.getId().toString(), changeBillInfo == null || changeBillInfo.getId() == null ? null : changeBillInfo.getId().toString());
            IObjectPK iObjectPK = super.submit(ctx, model);
            return iObjectPK;
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkModel(model);
        FaLeaseChangeBillInfo billInfo = (FaLeaseChangeBillInfo)model;
        FaLeaseChangeBillEntryCollection entries = billInfo.getEntries();
        this.lockLeaseChangeBill(ctx, billInfo.getId());
        this.lockLeaseBill(ctx, entries, billInfo.getRentDirection());
        if (billInfo.getId() == null) {
            this.checkFaLeaseBillBlock(ctx, billInfo);
        }
        this.checkForSubmit(ctx, model);
        this.updateOldFields(ctx, billInfo);
        this.checkIsChange(ctx, billInfo);
        if (billInfo.getId() != null) {
            this.restoreLeaseBillStatus(ctx, (IObjectPK)new ObjectUuidPK(billInfo.getId()));
        }
        this.setRuleNumber(ctx, billInfo, FaLeaseChangeBillFactory.getLocalInstance(ctx));
        billInfo.setFiVouchered(false);
        billInfo.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        billInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        billInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
        Timestamp time = new Timestamp(new Date().getTime());
        if (billInfo.getId() == null) {
            billInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
            billInfo.setCreateTime(time);
        }
        billInfo.setLastUpdateTime(time);
        billInfo.setPeriod(this.getCurrentPeriod(ctx, billInfo));
        FaRentDirectionEnum renDir = billInfo.getRentDirection();
        this.updateLeaseBillStatus(ctx, this.leaseIdCol2Str((IObjectCollection)entries, renDir), renDir, true, FaLeaseBizStatusEnum.CHANGING);
        return super._submit(ctx, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void passAudit(Context ctx, IObjectPK pk, BillBaseInfo model) throws BOSException, EASBizException {
        try {
            this.setWorkflowServiceState(ctx, pk);
            super.passAudit(ctx, pk, model);
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    protected void setWorkflowServiceState(Context ctx, IObjectPK objId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.id"));
        CompanyOrgUnitInfo comp = (CompanyOrgUnitInfo)this.getValue(ctx, objId, sic).get("company");
        this.setWorkflowServiceState(ctx, comp.getId().toString(), objId.toString());
    }

    protected void setWorkflowServiceState(Context ctx, String companyId, String objId) throws BOSException, EASBizException {
        boolean isUseWorkflow = FaManageUtils.isUseWorkflow(ctx, companyId, this.getClass());
        if (!isUseWorkflow && (objId == null || objId != null && !FaLocalUtils.isRunningWorkflow(ctx, objId))) {
            WfEventListenerStateManager.getInstance().disableEventListener();
        }
    }

    @Override
    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (pk == null || pk.toString().length() == 0) {
            throw new EASBizException(EASBizException.CHECKPARENTDELETED);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("checkedStatus");
        sic.add("blockedStatus");
        sic.add("effectedStatus");
        sic.add("deletedStatus");
        sic.add("fiVouchered");
        sic.add("rentDirection");
        sic.add("period.id");
        sic.add("company.id");
        sic.add("entries.leaseInBill.id");
        sic.add("entries.leaseInBill.number");
        sic.add("entries.contractNameNew");
        sic.add("entries.rentInOutObjNew");
        sic.add("entries.rentInOutObjTypeNew");
        sic.add("entries.innerCompanyLessorNew.id");
        sic.add("entries.customerLessorNew.id");
        sic.add("entries.supplierLessorNew.id");
        sic.add("entries.costCenterNew.id");
        sic.add("entries.useDepartmentNew.id");
        sic.add("entries.contractCatNew.id");
        FaLeaseChangeBillInfo billInfo = this.getFaLeaseChangeBillInfo(ctx, pk, sic);
        model = billInfo;
        FaLeaseChangeBillEntryCollection entries = billInfo.getEntries();
        FaRentDirectionEnum renDir = billInfo.getRentDirection();
        this.lockLeaseChangeBill(ctx, billInfo.getId().toString());
        this.lockLeaseBill(ctx, entries, billInfo.getRentDirection());
        this.checkForAudit(ctx, pk, (IObjectValue)billInfo);
        this.checkDeprAmortVouchered(ctx, billInfo, true);
        this.updateLeaseBillChangeFields(ctx, billInfo, true);
        this.updateLeaseBillStatus(ctx, this.leaseIdCol2Str((IObjectCollection)entries, renDir), renDir, false, FaLeaseBizStatusEnum.HAVE_CHANGED);
        DbUtil.execute((Context)ctx, (String)"UPDATE T_Fa_FaLeaseChangeBill SET FCHECKEDSTATUS = 2, FAUDITORID = ?, FBIZDATE = NOW(), FLASTUPDATETIME = NOW() WHERE FID = ?", (Object[])new String[]{ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), pk.toString()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unpassAudit(Context ctx, IObjectPK pk, BillBaseInfo model) throws BOSException, EASBizException {
        try {
            this.setWorkflowServiceState(ctx, pk);
            super.unpassAudit(ctx, pk, model);
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    @Override
    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        if (pk == null || pk.toString().length() == 0) {
            throw new EASBizException(EASBizException.CHECKPARENTDELETED);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("checkedStatus");
        sic.add("blockedStatus");
        sic.add("effectedStatus");
        sic.add("deletedStatus");
        sic.add("fiVouchered");
        sic.add("rentDirection");
        sic.add("period.id");
        sic.add("company.id");
        sic.add("entries.leaseInBill.id");
        sic.add("entries.leaseInBill.number");
        sic.add("entries.contractNameOld");
        sic.add("entries.rentInOutObjOld");
        sic.add("entries.costCenterOld.id");
        sic.add("entries.useDepartmentOld.id");
        sic.add("entries.contractCatOld.id");
        sic.add("entries.rentInOutObjTypeOld");
        sic.add("entries.innerCompanyLessorOld.id");
        sic.add("entries.customerLessorOld.id");
        sic.add("entries.supplierLessorOld.id");
        FaLeaseChangeBillInfo billInfo = this.getFaLeaseChangeBillInfo(ctx, pk, sic);
        model = billInfo;
        FaLeaseChangeBillEntryCollection entries = billInfo.getEntries();
        FaRentDirectionEnum renDir = billInfo.getRentDirection();
        this.lockLeaseChangeBill(ctx, model.get("id"));
        this.lockLeaseBill(ctx, entries, billInfo.getRentDirection());
        this.checkForUnAudit(ctx, pk, (IObjectValue)model);
        this.checkDeprAmortVouchered(ctx, billInfo, false);
        this.checkLeaseBillFollowUpBiz(ctx, billInfo);
        this.updateLeaseBillChangeFields(ctx, billInfo, false);
        this.updateLeaseBillStatus(ctx, this.leaseIdCol2Str((IObjectCollection)entries, renDir), renDir, true, FaLeaseBizStatusEnum.CHANGING);
        DbUtil.execute((Context)ctx, (String)"UPDATE T_Fa_FaLeaseChangeBill SET FCHECKEDSTATUS = 1, FLASTUPDATETIME = NOW() WHERE FID = ?", (Object[])new String[]{pk.toString()});
    }

    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            this.setWorkflowServiceState(ctx, pk);
            super.delete(ctx, pk);
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null || pk.toString().length() == 0) {
            throw new EASBizException(EASBizException.CHECKPARENTDELETED);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("checkedStatus");
        sic.add("blockedStatus");
        sic.add("fiVouchered");
        sic.add("rentDirection");
        sic.add("company.id");
        sic.add("entries.leaseInBill.id");
        sic.add("entries.bizStatusOld");
        FaLeaseChangeBillInfo billInfo = this.getFaLeaseChangeBillInfo(ctx, pk, sic);
        FaLeaseChangeBillEntryCollection entries = billInfo.getEntries();
        this.lockLeaseChangeBill(ctx, pk);
        this.lockLeaseBill(ctx, entries, billInfo.getRentDirection());
        this.checkForDelete(ctx, billInfo);
        this.restoreLeaseBillStatus(ctx, billInfo);
        this.recycleNumber(ctx, billInfo);
        super._delete(ctx, pk);
    }

    protected DAPTransformResult _generateVoucher(Context ctx, IObjectCollection sourceBillCollection, IObjectPK botMappingPK) throws BOSException, EASBizException {
        StringBuffer eStr = new StringBuffer();
        for (int i = 0; i < sourceBillCollection.size(); ++i) {
            try {
                this.checkForOperate(ctx, (IObjectPK)new ObjectUuidPK((BOSUuid)sourceBillCollection.getObject(i).get("id")));
                continue;
            }
            catch (FaCardException e) {
                eStr.append(" ");
                eStr.append(e.getMessage());
                eStr.append(";");
                eStr.append("\n");
            }
        }
        if (eStr.toString().length() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("01", eStr.toString()));
        }
        return super._generateVoucher(ctx, sourceBillCollection, botMappingPK);
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        VoucherInfo voucher = FaLocalUtils.LookVoucherInfo(ctx, bOTRelationInfo);
        if (voucher == null) {
            super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
            return;
        }
        if (bOTBillOperStateEnum == BOTBillOperStateEnum.ADDNEW) {
            String updateBillSQL = "UPDATE T_Fa_FaLeaseChangeBill SET FiVouchered = 1, FVoucherID = ? WHERE FID = ?";
            DbUtil.execute((Context)ctx, (String)updateBillSQL, (Object[])new String[]{voucher.getId().toString(), srcBillVO.get("id").toString()});
        } else if (bOTBillOperStateEnum == BOTBillOperStateEnum.DELETE) {
            String updateBillSQL = "UPDATE T_Fa_FaLeaseChangeBill SET FiVouchered = 0, FVoucherID = null WHERE FID = ?";
            DbUtil.execute((Context)ctx, (String)updateBillSQL, (Object[])new String[]{srcBillVO.get("id").toString()});
        } else if (bOTBillOperStateEnum != BOTBillOperStateEnum.EDIT) {
            super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
        }
    }

    private void lockLeaseChangeBill(Context ctx, Object id) throws BOSException {
        if (id == null || id.toString().length() < 0) {
            return;
        }
        FaBillBizProcessor.lockTable(ctx, id.toString());
    }

    private void lockLeaseBill(Context ctx, FaLeaseChangeBillEntryCollection entries, FaRentDirectionEnum rentDir) throws BOSException {
        for (int i = 0; i < entries.size(); ++i) {
            FaBillBizProcessor.lockTable(ctx, entries.get(i).getLeaseInBill().getId().toString());
        }
    }

    private void checkFaLeaseBillBlock(Context ctx, FaLeaseChangeBillInfo billInfo) throws BOSException, FaCardException {
        FaRentDirectionEnum rentDir = billInfo.getRentDirection();
        StringBuffer ckSql = new StringBuffer();
        ckSql.append(" SELECT FNUMBER number FROM T_Fa_FaLeaseInBillNew WHERE FBLOCKEDSTATUS = 2 AND FID IN (");
        ckSql.append(this.leaseIdCol2Str((IObjectCollection)billInfo.getEntries(), rentDir));
        ckSql.append(")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)ckSql.toString());
        StringBuffer msg = new StringBuffer("");
        try {
            while (rs.next()) {
                msg.append(rs.getString("number"));
                msg.append(" ");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (msg.toString().length() > 0) {
            msg.append(ResourceBase.getString((String)RES_PATH_LEASECHANGE, (String)"BILL_BLOCKED", (Locale)ctx.getOriginLocale()));
            throw new FaCardException(FaCardException.UN_SUCCESS, new String[]{msg.toString()});
        }
    }

    private void checkModel(IObjectValue model) throws EASBizException {
        if (model == null) {
            throw new EASBizException(EASBizException.CHECKPARENTDELETED);
        }
    }

    protected void checkForSave(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        FaLeaseChangeBillInfo billInfo = (FaLeaseChangeBillInfo)model;
        StringBuffer sbMsg = new StringBuffer("");
        if (new Integer(2).equals(billInfo.get("effectedStatus"))) {
            sbMsg.append(" ");
            sbMsg.append(this.getEffectedStatus(billInfo, ctx));
        }
        if (new Integer(2).equals(billInfo.get("DeletedStatus"))) {
            sbMsg.append(" ");
            sbMsg.append(this.getDeletedStatus(billInfo, ctx));
        }
        if (new Integer(2).equals(billInfo.get("blockedStatus"))) {
            sbMsg.append(" ");
            sbMsg.append(this.getBlockedStatus(billInfo, ctx));
        }
        if (sbMsg.toString().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)RES_PATH_CARD, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append(sbMsg);
            throw new FaCardException(FaCardException.UN_SUCCESS, new String[]{sbAll.toString()});
        }
    }

    protected void checkForSubmit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        FaLeaseChangeBillInfo billInfo = (FaLeaseChangeBillInfo)model;
        StringBuffer sbMsg = new StringBuffer("");
        if (new Integer(2).equals(billInfo.get("DeletedStatus"))) {
            sbMsg.append(" ");
            sbMsg.append(this.getDeletedStatus(billInfo, ctx));
        }
        if (new Integer(2).equals(billInfo.get("checkedStatus"))) {
            sbMsg.append(" ");
            sbMsg.append(this.getCheckedStatus(billInfo, ctx));
        }
        if (new Integer(2).equals(billInfo.get("blockedStatus"))) {
            sbMsg.append(" ");
            sbMsg.append(this.getBlockedStatus(billInfo, ctx));
        }
        if (billInfo.getBoolean("fiVouchered")) {
            sbMsg.append(" ");
            sbMsg.append(this.getIsVouchered(billInfo, ctx));
        }
        if (FaLocalUtils.isCurrencyDisable(ctx, billInfo)) {
            sbMsg.append(" ");
            sbMsg.append(ResourceBase.getString((String)RES_PATH_CARD, (String)"CurrencyDisable", (Locale)ctx.getOriginLocale()));
        }
        if (sbMsg.toString().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)RES_PATH_CARD, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append(sbMsg);
            throw new FaCardException(FaCardException.UN_SUCCESS, new String[]{sbAll.toString()});
        }
    }

    protected void checkForAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        FaLeaseChangeBillInfo billInfo = (FaLeaseChangeBillInfo)model;
        if (!billInfo.getPeriod().getId().toString().equals(this.getCurrentPeriod(ctx, billInfo).getId().toString())) {
            throw new FaCardException(FaCardException.UN_SUCCESS, new String[]{ResourceBase.getString((String)RES_PATH_LEASECHANGE, (String)"NOT_ALLOW_AUDIT_IN_OTHER_PERIOD", (Locale)ctx.getOriginLocale())});
        }
        FaLocalUtils.checkLeaseChangeGenInFuturePeriod(ctx, (IObjectCollection)billInfo.getEntries(), this.getCurrentPeriod(ctx, billInfo));
        FaLocalUtils.checkDeprAndAmortGenInFuturePeriod(ctx, (IObjectCollection)billInfo.getEntries(), this.getCurrentPeriod(ctx, billInfo));
        FaLocalUtils.checkRSDownBillGenInFuturePeriod(ctx, (IObjectCollection)billInfo.getEntries(), this.getCurrentPeriod(ctx, billInfo));
        StringBuffer sbMsg = new StringBuffer("");
        if (new Integer(2).equals(billInfo.get("DeletedStatus"))) {
            sbMsg.append(" ");
            sbMsg.append(this.getDeletedStatus(billInfo, ctx));
        }
        if (new Integer(1).equals(billInfo.get("EffectedStatus"))) {
            sbMsg.append(" ");
            sbMsg.append(this.getEffectedStatus(billInfo, ctx));
        }
        if (new Integer(2).equals(billInfo.get("checkedStatus"))) {
            sbMsg.append(" ");
            sbMsg.append(this.getCheckedStatus(billInfo, ctx));
        }
        if (new Integer(2).equals(billInfo.get("blockedStatus"))) {
            sbMsg.append(" ");
            sbMsg.append(this.getBlockedStatus(billInfo, ctx));
        }
        if (billInfo.getBoolean("fiVouchered")) {
            sbMsg.append(" ");
            sbMsg.append(this.getIsVouchered(billInfo, ctx));
        }
        if (sbMsg.toString().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)RES_PATH_CARD, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append(sbMsg);
            throw new FaCardException(FaCardException.UN_SUCCESS, new String[]{sbAll.toString()});
        }
    }

    protected void checkForUnAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        if (model == null) {
            throw new EASBizException(EASBizException.CHECKPARENTDELETED);
        }
        if (pk == null || pk.toString().length() == 0) {
            throw new EASBizException(EASBizException.CHECKPARENTDELETED);
        }
        FaLeaseChangeBillInfo billInfo = (FaLeaseChangeBillInfo)model;
        if (!billInfo.getPeriod().getId().toString().equals(this.getCurrentPeriod(ctx, billInfo).getId().toString())) {
            throw new FaCardException(FaCardException.UN_SUCCESS, new String[]{ResourceBase.getString((String)RES_PATH_LEASECHANGE, (String)"NOT_ALLOW_UNAUDIT_IN_OTHER_PERIOD", (Locale)ctx.getOriginLocale())});
        }
        StringBuffer sbMsg = new StringBuffer("");
        if (new Integer(2).equals(billInfo.get("DeletedStatus"))) {
            sbMsg.append(" ");
            sbMsg.append(this.getDeletedStatus(billInfo, ctx));
        }
        if (new Integer(1).equals(billInfo.get("EffectedStatus"))) {
            sbMsg.append(" ");
            sbMsg.append(this.getEffectedStatus(billInfo, ctx));
        }
        if (new Integer(1).equals(billInfo.get("checkedStatus"))) {
            sbMsg.append(" ");
            sbMsg.append(this.getCheckedStatus(billInfo, ctx));
        }
        if (new Integer(2).equals(billInfo.get("blockedStatus"))) {
            sbMsg.append(" ");
            sbMsg.append(this.getBlockedStatus(billInfo, ctx));
        }
        if (billInfo.getBoolean("fiVouchered")) {
            sbMsg.append(" ");
            sbMsg.append(this.getIsVouchered(billInfo, ctx));
        }
        if (sbMsg.toString().trim().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)RES_PATH_CARD, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            String tips = " " + billInfo.getNumber();
            sbAll.append(tips + sbMsg);
            sbAll.append("\n");
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, new String[]{"", sbAll.toString()});
        }
    }

    private void checkDeprAmortVouchered(Context ctx, FaLeaseChangeBillInfo billInfo, boolean isAudit) throws EASBizException, BOSException {
        StringBuffer msg = new StringBuffer();
        try {
            for (int i = 0; i < billInfo.getEntries().size(); ++i) {
                String sql = "SELECT 1 FROM T_Fa_FaDepreAndAmort WHERE FLeaseInBillId = ? AND FPeriodId = ? AND FIVouchered = 1";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{billInfo.getEntries().get(i).getLeaseInBill().getId().toString(), billInfo.getPeriod().getId().toString()});
                if (rs == null || !rs.next()) continue;
                if (msg.length() > 0) {
                    msg.append(",");
                }
                msg.append(billInfo.getEntries().get(i).getLeaseInBill().getNumber());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (msg.length() > 0) {
            if (isAudit) {
                String exStr = ResourceBase.getString((String)RES_PATH_LEASECHANGE, (String)"DEPREANDAMORT_VOUCHERED_AUDIT_FAIL", (Locale)ctx.getOriginLocale(), (Object[])new String[]{msg.toString()});
                throw new FaCardException(FaCardException.CANNOT_BE_AUDITED, new String[]{exStr});
            }
            String exStr = ResourceBase.getString((String)RES_PATH_LEASECHANGE, (String)"DEPREANDAMORT_VOUCHERED_UNAUDIT_FAIL", (Locale)ctx.getOriginLocale(), (Object[])new String[]{msg.toString()});
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, new String[]{exStr, ""});
        }
    }

    protected void checkForDelete(Context ctx, FaLeaseChangeBillInfo billInfo) throws EASBizException, BOSException {
        if (billInfo == null) {
            throw new EASBizException(EASBizException.CHECKPARENTDELETED);
        }
        StringBuffer sbMsg = new StringBuffer("");
        if (new Integer(2).equals(billInfo.get("checkedStatus"))) {
            sbMsg.append(" ");
            sbMsg.append(this.getCheckedStatus(billInfo, ctx));
        }
        if (new Integer(2).equals(billInfo.get("blockedStatus"))) {
            sbMsg.append(" ");
            sbMsg.append(this.getBlockedStatus(billInfo, ctx));
        }
        if (billInfo.getBoolean("fiVouchered")) {
            sbMsg.append(" ");
            sbMsg.append(this.getIsVouchered(billInfo, ctx));
        }
        if (sbMsg.toString().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)RES_PATH_CARD, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append("[" + billInfo.getNumber() + "]");
            sbAll.append(sbMsg);
            sbAll.append("\n");
            throw new FaCardException(FaCardException.CANNOT_BE_DELETED, new String[]{sbAll.toString()});
        }
    }

    private void checkForOperate(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        if (pk == null || pk.toString().length() == 0) {
            throw new EASBizException(EASBizException.CHECKPARENTDELETED);
        }
        FaLeaseChangeBillInfo billInfo = this.getFaLeaseChangeBillInfo(ctx, pk);
        if (billInfo == null) {
            throw new EASBizException(EASBizException.CHECKPARENTDELETED);
        }
        StringBuffer sbMsg = new StringBuffer("");
        if (new Integer(2).equals(billInfo.get("DeletedStatus"))) {
            sbMsg.append(" ");
            sbMsg.append(this.getDeletedStatus(billInfo, ctx));
        }
        if (new Integer(1).equals(billInfo.get("EffectedStatus"))) {
            sbMsg.append(" ");
            sbMsg.append(this.getEffectedStatus(billInfo, ctx));
        }
        if (new Integer(1).equals(billInfo.get("checkedStatus"))) {
            sbMsg.append(" ");
            sbMsg.append(this.getCheckedStatus(billInfo, ctx));
        }
        if (new Integer(2).equals(billInfo.get("blockedStatus"))) {
            sbMsg.append(" ");
            sbMsg.append(this.getBlockedStatus(billInfo, ctx));
        }
        if (billInfo.getBoolean("fiVouchered")) {
            sbMsg.append(" ");
            sbMsg.append(this.getIsVouchered(billInfo, ctx));
        }
        if (sbMsg.toString().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)RES_PATH_CARD, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append("[" + billInfo.getNumber() + "]");
            sbAll.append(sbMsg);
            sbAll.append("\n");
            throw new FaCardException(FaCardException.CANNOT_BE_GENVOUCHER, new String[]{sbAll.toString()});
        }
    }

    protected StringBuffer getEffectedStatus(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("effectedStatus").equals(new Integer(2))) {
            sbMsg.append(ResourceBase.getString((String)RES_PATH_CARD, (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)RES_PATH_CARD, (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)RES_PATH_CARD, (String)"EFFECTED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    protected StringBuffer getCheckedStatus(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("checkedStatus").equals(new Integer(2))) {
            sbMsg.append(ResourceBase.getString((String)RES_PATH_CARD, (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)RES_PATH_CARD, (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)RES_PATH_CARD, (String)"CHECKED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    protected StringBuffer getDeletedStatus(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("deletedStatus").equals(new Integer(2))) {
            sbMsg.append(ResourceBase.getString((String)RES_PATH_CARD, (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)RES_PATH_CARD, (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)RES_PATH_CARD, (String)"DELETED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    protected StringBuffer getBlockedStatus(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("blockedStatus").equals(new Integer(2))) {
            sbMsg.append(ResourceBase.getString((String)RES_PATH_CARD, (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)RES_PATH_CARD, (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)RES_PATH_CARD, (String)"BLOCKED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    protected StringBuffer getIsVouchered(BillBaseInfo billInfo, Context ctx) {
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.getBoolean("fiVouchered")) {
            sbMsg.append(ResourceBase.getString((String)RES_PATH_CARD, (String)"HAD", (Locale)ctx.getOriginLocale()));
        } else {
            sbMsg.append(ResourceBase.getString((String)RES_PATH_CARD, (String)"HADNOT", (Locale)ctx.getOriginLocale()));
        }
        sbMsg.append(ResourceBase.getString((String)RES_PATH_CARD, (String)"ISVOUCHERED", (Locale)ctx.getOriginLocale()));
        return sbMsg;
    }

    protected PeriodInfo getCurrentPeriod(Context ctx, BillBaseInfo bill) throws EASBizException, BOSException {
        if (this.curPeriod == null && bill != null && bill.getCompany() != null && bill.getCompany().getId() != null) {
            this.curPeriod = this.getCurrentPeriod(ctx, bill.getCompany());
        }
        return this.curPeriod == null ? new PeriodInfo() : this.curPeriod;
    }

    protected PeriodInfo getCurrentPeriod(Context ctx, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        if (this.curPeriod == null && company != null && company.getId() != null) {
            String strCompanyOrgUnitInfoID = company.getId().toString();
            ISystemStatusCtrol ictrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("systemStatus.name", (Object)new Integer(SystemEnum.FINANCE_LEASE.getValue())));
            fic.add(new FilterItemInfo("company.id", (Object)strCompanyOrgUnitInfoID));
            SelectorItemCollection sic = view.getSelector();
            sic.add(new SelectorItemInfo("currentPeriod.id"));
            sic.add(new SelectorItemInfo("currentPeriod.number"));
            sic.add(new SelectorItemInfo("currentPeriod.periodYear"));
            sic.add(new SelectorItemInfo("currentPeriod.periodNumber"));
            sic.add(new SelectorItemInfo("currentPeriod.beginDate"));
            sic.add(new SelectorItemInfo("currentPeriod.endDate"));
            sic.add(new SelectorItemInfo("currentPeriod.isAdjustPeriod"));
            sic.add(new SelectorItemInfo("currentPeriod.periodType.id"));
            sic.add(new SelectorItemInfo("currentPeriod.periodType.CU.id"));
            sic.add(new SelectorItemInfo("currentPeriod.periodType.lastUpdateTime"));
            sic.add(new SelectorItemInfo("currentPeriod.periodType.lastUpdateUser.id"));
            sic.add(new SelectorItemInfo("currentPeriod.periodType.createTime"));
            sic.add(new SelectorItemInfo("currentPeriod.periodType.creator.id"));
            sic.add(new SelectorItemInfo("currentPeriod.periodType.simpleName"));
            sic.add(new SelectorItemInfo("currentPeriod.periodType.description"));
            sic.add(new SelectorItemInfo("currentPeriod.periodType.number"));
            sic.add(new SelectorItemInfo("currentPeriod.periodType.name"));
            SystemStatusCtrolCollection col = ictrol.getSystemStatusCtrolCollection(view);
            if (col.size() > 0) {
                this.curPeriod = col.get(0).getCurrentPeriod();
            }
        }
        return this.curPeriod == null ? new PeriodInfo() : this.curPeriod;
    }

    private void updateOldFields(Context ctx, FaLeaseChangeBillInfo billInfo) throws BOSException {
        FaLeaseChangeBillEntryCollection entries = billInfo.getEntries();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        FilterInfo filter = new FilterInfo();
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < entries.size(); ++i) {
            idSet.add(entries.get(i).getLeaseInBill().getId().toString());
        }
        if (billInfo.getRentDirection().getValue() == 0) {
            sic.add("id");
            sic.add("contractName");
            sic.add("lessor");
            sic.add("costCenter.id");
            sic.add("costCenter.name");
            sic.add("useDepartment.id");
            sic.add("useDepartment.name");
            sic.add("contractCat.id");
            sic.add("contractCat.name");
            sic.add("lessorType");
            sic.add("innerCompanyLessor.id");
            sic.add("innerCompanyLessor.name");
            sic.add("customerLessor.id");
            sic.add("customerLessor.name");
            sic.add("supplierLessor.id");
            sic.add("supplierLessor.name");
            sic.add("bizStatus");
            view.setSelector(sic);
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            FaLeaseInBillNewCollection leaseInBillCol = FaLeaseInBillNewFactory.getLocalInstance(ctx).getFaLeaseInBillNewCollection(view);
            block1: for (int i = 0; i < entries.size(); ++i) {
                for (int j = 0; j < leaseInBillCol.size(); ++j) {
                    if (!entries.get(i).getLeaseInBill().getId().toString().equals(leaseInBillCol.get(j).getId().toString())) continue;
                    entries.get(i).setContractNameOld(leaseInBillCol.get(j).getContractName());
                    entries.get(i).setRentInOutObjOld(leaseInBillCol.get(j).getLessor());
                    entries.get(i).setRentInOutObjTypeOld(leaseInBillCol.get(j).getLessorType());
                    entries.get(i).setInnerCompanyLessorOld(leaseInBillCol.get(j).getInnerCompanyLessor());
                    entries.get(i).setCustomerLessorOld(leaseInBillCol.get(j).getCustomerLessor());
                    entries.get(i).setSupplierLessorOld(leaseInBillCol.get(j).getSupplierLessor());
                    entries.get(i).setCostCenterOld(leaseInBillCol.get(j).getCostCenter());
                    entries.get(i).setUseDepartmentOld(leaseInBillCol.get(j).getUseDepartment());
                    entries.get(i).setContractCatOld(leaseInBillCol.get(j).getContractCat());
                    if (leaseInBillCol.get(j).getBizStatus().getValue() == 2) continue block1;
                    entries.get(i).setBizStatusOld(leaseInBillCol.get(j).getBizStatus());
                    continue block1;
                }
            }
        }
    }

    private void checkIsChange(Context ctx, FaLeaseChangeBillInfo billInfo) throws FaCardException {
        FaLeaseChangeBillEntryCollection entries = billInfo.getEntries();
        for (int i = 0; i < entries.size(); ++i) {
            FaLeaseChangeBillEntryInfo entryNew = new FaLeaseChangeBillEntryInfo();
            FaLeaseChangeBillEntryInfo entryOld = new FaLeaseChangeBillEntryInfo();
            FaContractCatInfo contractCatNew = entries.get(i).getContractCatOld();
            FaContractCatInfo contractCatOld = entries.get(i).getContractCatNew();
            entryNew.setContractCatNew(contractCatNew);
            entryOld.setContractCatNew(contractCatOld);
            String contractNameNew = entries.get(i).getContractNameNew();
            String contractNameOld = entries.get(i).getContractNameOld();
            entryNew.setContractNameNew(contractNameNew);
            entryOld.setContractNameNew(contractNameOld);
            FaLessorTypeEnum rentInOutObjTypeNew = entries.get(i).getRentInOutObjTypeNew();
            FaLessorTypeEnum rentInOutObjTypeOld = entries.get(i).getRentInOutObjTypeOld();
            entryNew.setRentInOutObjTypeNew(rentInOutObjTypeNew);
            entryOld.setRentInOutObjTypeNew(rentInOutObjTypeOld);
            CompanyOrgUnitInfo innerCompanyNew = entries.get(i).getInnerCompanyLessorNew();
            CompanyOrgUnitInfo innerCompanyOld = entries.get(i).getInnerCompanyLessorOld();
            entryNew.setInnerCompanyLessorNew(innerCompanyNew);
            entryOld.setInnerCompanyLessorNew(innerCompanyOld);
            CustomerInfo cutomerNew = entries.get(i).getCustomerLessorNew();
            CustomerInfo cutomerOld = entries.get(i).getCustomerLessorOld();
            entryNew.setCustomerLessorNew(cutomerNew);
            entryOld.setCustomerLessorNew(cutomerOld);
            SupplierInfo supplierNew = entries.get(i).getSupplierLessorNew();
            SupplierInfo supplierOld = entries.get(i).getSupplierLessorOld();
            entryNew.setSupplierLessorNew(supplierNew);
            entryOld.setSupplierLessorNew(supplierOld);
            AdminOrgUnitInfo usedepartmentNew = entries.get(i).getUseDepartmentNew();
            AdminOrgUnitInfo usedepartmentOld = entries.get(i).getUseDepartmentOld();
            entryNew.setUseDepartmentNew(usedepartmentNew);
            entryOld.setUseDepartmentNew(usedepartmentOld);
            CostCenterOrgUnitInfo costCenterNew = entries.get(i).getCostCenterNew();
            CostCenterOrgUnitInfo costCenterOld = entries.get(i).getCostCenterOld();
            entryNew.setCostCenterNew(costCenterNew);
            entryOld.setCostCenterNew(costCenterOld);
            if (!ObjectValueUtil.objectValueEquals((Context)ctx, (AbstractObjectValue)entryOld, (AbstractObjectValue)entryNew)) continue;
            StringBuffer msg = new StringBuffer();
            msg.append(ResourceBase.getString((String)RES_PATH_LEASECHANGE, (String)"ENTRY", (Locale)ctx.getOriginLocale()));
            msg.append(i + 1 + ResourceBase.getString((String)RES_PATH_LEASECHANGE, (String)"NO_CHANGE", (Locale)ctx.getOriginLocale()));
            throw new FaCardException(FaCardException.UN_SUCCESS, new String[]{msg.toString()});
        }
    }

    private String leaseIdCol2Str(IObjectCollection col, FaRentDirectionEnum renDir) {
        StringBuffer idsStr = new StringBuffer();
        for (int i = 0; i < col.size(); ++i) {
            idsStr.append("'");
            idsStr.append(((IObjectValue)col.getObject(i).get("leaseInBill")).get("Id").toString());
            idsStr.append("'");
            if (i >= col.size() - 1) continue;
            idsStr.append(",");
        }
        return idsStr.toString();
    }

    private void updateLeaseBillStatus(Context ctx, String idsStr, FaRentDirectionEnum renDir, boolean isBlock, FaLeaseBizStatusEnum bizStatus) throws BOSException {
        StringBuffer updateSql = new StringBuffer();
        updateSql.append(" UPDATE T_Fa_FaLeaseInBillNew SET FBLOCKEDSTATUS = ");
        updateSql.append(isBlock ? "2" : "1");
        updateSql.append(", FBizStatus = ");
        updateSql.append(bizStatus.getValue());
        updateSql.append(" WHERE FID IN (");
        updateSql.append(idsStr);
        updateSql.append(")");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
    }

    private void restoreLeaseBillStatus(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("entries.leaseInBill.id");
        sic.add("entries.bizStatusOld");
        this.restoreLeaseBillStatus(ctx, this.getFaLeaseChangeBillInfo(ctx, pk, sic));
    }

    private void restoreLeaseBillStatus(Context ctx, FaLeaseChangeBillInfo billInfo) throws BOSException {
        FaLeaseChangeBillEntryCollection entries = billInfo.getEntries();
        for (int i = 0; i < entries.size(); ++i) {
            StringBuffer updateSql = new StringBuffer();
            updateSql.append(" UPDATE T_Fa_FaLeaseInBillNew SET FBLOCKEDSTATUS = 1, FBizStatus = ");
            updateSql.append(entries.get(i).getBizStatusOld().getValue());
            updateSql.append(" WHERE FID = '");
            updateSql.append(entries.get(i).getLeaseInBill().getId().toString());
            updateSql.append("'");
            DbUtil.execute((Context)ctx, (String)updateSql.toString());
        }
    }

    private void updateLeaseBillChangeFields(Context ctx, FaLeaseChangeBillInfo billInfo, boolean isAudit) throws BOSException {
        FaLeaseChangeBillEntryCollection entries = billInfo.getEntries();
        String updateSql = " UPDATE T_Fa_FaLeaseInBillNew SET FContractName = ?, FLessor = ?, FCostCenterId = ?, FUseDepartmentId = ?,FLessorType = ?, FInnerCompanyLessorId = ?, FCustomerLessorId = ?, FSupplierLessorId = ?,  FContractCatId = ? WHERE FID = ? ";
        if (isAudit) {
            for (int i = 0; i < entries.size(); ++i) {
                Object[] params = new Object[]{entries.get(i).getContractNameNew(), entries.get(i).getRentInOutObjNew(), entries.get(i).getCostCenterNew() == null ? null : entries.get(i).getCostCenterNew().getId().toString(), entries.get(i).getUseDepartmentNew().getId().toString(), entries.get(i).getRentInOutObjTypeNew() == null ? null : Integer.valueOf(entries.get(i).getRentInOutObjTypeNew().getValue()), entries.get(i).getInnerCompanyLessorNew() == null ? null : entries.get(i).getInnerCompanyLessorNew().getId().toString(), entries.get(i).getCustomerLessorNew() == null ? null : entries.get(i).getCustomerLessorNew().getId().toString(), entries.get(i).getSupplierLessorNew() == null ? null : entries.get(i).getSupplierLessorNew().getId().toString(), entries.get(i).getContractCatNew().getId().toString(), entries.get(i).getLeaseInBill().getId().toString()};
                DbUtil.execute((Context)ctx, (String)updateSql, (Object[])params);
            }
        } else {
            for (int i = 0; i < entries.size(); ++i) {
                Object[] params = new Object[]{entries.get(i).getContractNameOld(), entries.get(i).getRentInOutObjOld(), entries.get(i).getCostCenterOld() == null ? null : entries.get(i).getCostCenterOld().getId().toString(), entries.get(i).getUseDepartmentOld().getId().toString(), entries.get(i).getRentInOutObjTypeOld() == null ? null : Integer.valueOf(entries.get(i).getRentInOutObjTypeOld().getValue()), entries.get(i).getInnerCompanyLessorOld() == null ? null : entries.get(i).getInnerCompanyLessorOld().getId().toString(), entries.get(i).getCustomerLessorOld() == null ? null : entries.get(i).getCustomerLessorOld().getId().toString(), entries.get(i).getSupplierLessorOld() == null ? null : entries.get(i).getSupplierLessorOld().getId().toString(), entries.get(i).getContractCatOld().getId().toString(), entries.get(i).getLeaseInBill().getId().toString()};
                DbUtil.execute((Context)ctx, (String)updateSql, (Object[])params);
            }
        }
    }

    protected void setRuleNumber(Context ctx, BillBaseInfo caller, IBillBase iBillBase) throws BOSException, EASBizException {
        String strCompanyID = caller.getCompany() != null && caller.getCompany().getId() != null ? caller.getCompany().getId().toString() : ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String number = (String)caller.get("number");
        caller.setCU(CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select id,CU.id,CU.number,CU.name where id='" + strCompanyID + "'").getCU());
        int maxCycleNum = 100;
        String filterString = "where number = '" + number + "' and company.id = '" + strCompanyID + "' " + (caller.get("id") != null ? "and id !='" + caller.get("id") + "'" : "");
        while (number == null || number.equals("") || iBillBase.exists(filterString)) {
            if (--maxCycleNum == 0) {
                throw new CodingRuleException(CodingRuleException.ERROR_REFERENCE_INVALID);
            }
            number = iCodingRuleManager.getNumber((IObjectValue)caller, strCompanyID);
            filterString = "where number = '" + number + "' and company.id = '" + strCompanyID + "' " + (caller.get("id") != null ? "and id !='" + caller.get("id") + "'" : "");
        }
        caller.setNumber(number);
    }

    protected void recycleNumber(Context ctx, BillBaseInfo caller) throws EASBizException, BOSException {
        if (caller == null) {
            return;
        }
        caller.setCU(CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select id,CU.id,CU.number,CU.name where id='" + caller.getCompany().getId() + "'").getCU());
        String strCompanyID = caller.getCompany() != null && caller.getCompany().getId() != null ? caller.getCompany().getId().toString() : ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (iCodingRuleManager.getCodingRule((IObjectValue)caller, strCompanyID) != null && iCodingRuleManager.isUseIntermitNumber((IObjectValue)caller, strCompanyID)) {
            iCodingRuleManager.recycleNumber((IObjectValue)caller, strCompanyID, caller.getNumber());
        }
    }

    private void checkLeaseBillFollowUpBiz(Context ctx, FaLeaseChangeBillInfo billInfo) throws BOSException, FaCardException {
        FaRentDirectionEnum rentDir = billInfo.getRentDirection();
        if (rentDir.getValue() == 0) {
            StringBuilder ckSql = new StringBuilder();
            ckSql.append(" SELECT lease.FNumber number FROM T_Fa_FaLeaseChangeBill bill ");
            ckSql.append(" LEFT JOIN T_Fa_FaLeaseChangeBillEntry entry ON bill.FID = entry.FBillId ");
            ckSql.append(" INNER JOIN ( ");
            ckSql.append(" SELECT entry.FLeaseInBillId FID FROM T_Fa_FaLeaseChangeBill bill ");
            ckSql.append(" LEFT JOIN T_Fa_FaLeaseChangeBillEntry entry ON bill.FID = entry.FBillId ");
            ckSql.append(" WHERE bill.FId = '");
            ckSql.append(billInfo.getId().toString());
            ckSql.append("') AS t ON t.FID = entry.FLeaseInBillId ");
            ckSql.append(" LEFT JOIN T_Fa_FaLeaseInBillNew lease ON lease.FID = entry.FLeaseInBillId ");
            ckSql.append(" WHERE bill.FBizDate > (SELECT FBizDate FROM T_Fa_FaLeaseChangeBill WHERE FID = '");
            ckSql.append(billInfo.getId().toString());
            ckSql.append("') ");
            ckSql.append(" AND entry.FBillId <> '");
            ckSql.append(billInfo.getId().toString());
            ckSql.append("'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)ckSql.toString());
            StringBuilder numberStr = new StringBuilder();
            try {
                while (rs.next()) {
                    numberStr.append(rs.getString("number"));
                    if (rs.isLast()) continue;
                    numberStr.append(";");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (rs != null && rs.size() > 0 && numberStr.length() > 0) {
                StringBuilder sbAll = new StringBuilder(ResourceBase.getString((String)RES_PATH_CARD, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
                sbAll.append(ResourceBase.getString((String)RES_PATH_LEASECHANGE, (String)"EXIST_FOLLOW_UP_BIZ", (Locale)ctx.getOriginLocale()));
                sbAll.append((CharSequence)numberStr);
                throw new FaCardException(FaCardException.UN_SUCCESS, new String[]{sbAll.toString()});
            }
            ckSql = new StringBuilder();
            ckSql.append(" SELECT lease.Fnumber number FROM T_Fa_FaLeaseChangeBill bill \r\n");
            ckSql.append(" LEFT JOIN T_Fa_FaLeaseChangeBillEntry cgEntry ON bill.FID = cgEntry.FBillID \r\n");
            ckSql.append(" LEFT JOIN T_Fa_FaTerminateBillEntry tmEntry ON tmEntry.FLeaseInBillID = cgEntry.FLeaseInBillID \r\n");
            ckSql.append(" INNER JOIN T_Fa_FaLeaseInBillNew lease ON lease.FID = tmEntry.FLeaseInBillID \r\n");
            ckSql.append(" WHERE bill.FID = '");
            ckSql.append(billInfo.getId().toString());
            ckSql.append("'");
            rs = DbUtil.executeQuery((Context)ctx, (String)ckSql.toString());
            numberStr = new StringBuilder();
            try {
                while (rs.next()) {
                    numberStr.append(rs.getString("number"));
                    if (rs.isLast()) continue;
                    numberStr.append(";");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (rs != null && rs.size() > 0 && numberStr.length() > 0) {
                StringBuilder sbAll = new StringBuilder(ResourceBase.getString((String)RES_PATH_CARD, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
                sbAll.append(ResourceBase.getString((String)RES_PATH_LEASECHANGE, (String)"EXIST_FOLLOW_UP_BIZ", (Locale)ctx.getOriginLocale()));
                sbAll.append((CharSequence)numberStr);
                throw new FaCardException(FaCardException.UN_SUCCESS, new String[]{sbAll.toString()});
            }
        }
    }

    @Override
    protected Map _getRcvPaidAmt(Context ctx, Set leaseBillIdSet, Date date, FaRentDirectionEnum rentDirection) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        if (rentDirection.getValue() == 0) {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT pp.FHEADID id, SUM(pp.FPAYMENTWITHOUTTAX) total FROM T_Fa_FaLeaseInBillNew bill");
            sql.append(" LEFT OUTER JOIN T_Fa_FaPaymentPlanNew pp ON bill.FID = pp.FHEADID");
            sql.append(" WHERE pp.FPAYDATE < ? AND bill.Fid IN (");
            sql.append(this.idSet2Str(leaseBillIdSet));
            sql.append(") GROUP BY pp.FHEADID");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Timestamp[]{new Timestamp(date.getTime())});
            try {
                while (rs.next()) {
                    String id = rs.getString("id");
                    BigDecimal total = rs.getBigDecimal("total");
                    resultMap.put(id, total);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return resultMap;
    }

    @Override
    protected Map _getDeprInterestAmt(Context ctx, Set leaseBillIdSet, FaRentDirectionEnum rentDirection) throws BOSException, EASBizException {
        HashMap<String, BigDecimal[]> resultMap = new HashMap<String, BigDecimal[]>();
        if (rentDirection.getValue() == 0) {
            for (String leaseInBillId : leaseBillIdSet) {
                StringBuffer sql = new StringBuffer();
                sql.append(" SELECT TOP 1 dep.FACUMDEPREAMT adAmt, dep.FACUMINTERESTEXPE aieAmt FROM T_FA_FaDepreAndAmort dep");
                sql.append(" LEFT OUTER JOIN T_BD_Period period ON DEP.FPERIODID = PERIOD.FID");
                sql.append(" WHERE dep.FLEASEINBILLID = ?");
                sql.append(" AND period.FNUMBER < ? ORDER BY period.FNUMBER DESC");
                PeriodInfo curPeriod = this.getCurrentPeriod(ctx, this.getCurrentCompany(ctx));
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, curPeriod.getNumber()});
                try {
                    if (rs != null && rs.next()) {
                        BigDecimal acumDepreAmt = rs.getBigDecimal("adAmt");
                        BigDecimal acumInterestExpe = rs.getBigDecimal("aieAmt");
                        BigDecimal[] amtArr = new BigDecimal[]{acumDepreAmt, acumInterestExpe};
                        resultMap.put(leaseInBillId, amtArr);
                        continue;
                    }
                    resultMap.put(leaseInBillId, new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO});
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        return resultMap;
    }

    @Override
    protected Map _getInitAmt(Context ctx, Set leaseBillIdSet, FaRentDirectionEnum rentDirection) throws BOSException, EASBizException {
        HashMap<String, BigDecimal[]> resultMap = new HashMap<String, BigDecimal[]>();
        if (rentDirection.getValue() == 0) {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT FID id, FINITIALASSET initAsset, FINITIALLIABILITY initAbility, FUNRECOGNIZEDFINANCEFEE unFncFee FROM T_FA_FALEASEINBILLNEW");
            sql.append(" WHERE FID IN (");
            sql.append(this.idSet2Str(leaseBillIdSet));
            sql.append(")");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                while (rs.next()) {
                    String id = rs.getString("id");
                    BigDecimal initAsset = rs.getBigDecimal("initAsset");
                    BigDecimal initAbility = rs.getBigDecimal("initAbility");
                    BigDecimal unFncFee = rs.getBigDecimal("unFncFee");
                    BigDecimal[] amtArr = new BigDecimal[]{initAsset, initAbility, unFncFee};
                    resultMap.put(id, amtArr);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return resultMap;
    }

    private String idSet2Str(Set idSet) {
        StringBuffer ids = new StringBuffer();
        Iterator it = idSet.iterator();
        while (it.hasNext()) {
            ids.append("'");
            ids.append((String)it.next());
            ids.append("'");
            if (!it.hasNext()) continue;
            ids.append(",");
        }
        return ids.toString();
    }

    private BigDecimal getBD(BigDecimal bd, int scale) {
        return bd == null ? BigDecimal.ZERO.setScale(scale, RoundingMode.HALF_UP) : bd.setScale(scale, RoundingMode.HALF_UP);
    }

    protected CompanyOrgUnitInfo getCurrentCompany(Context ctx) throws BOSException, EASBizException {
        if (this.currCompany == null) {
            String companyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
            this.currCompany = this.getCompanyById(ctx, companyID);
        }
        return this.currCompany;
    }

    protected CompanyOrgUnitInfo getCompanyById(Context ctx, String companyID) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("basecurrency.precision"));
        sic.add(new SelectorItemInfo("isbizunit"));
        return CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID), sic);
    }

    @Override
    protected FaLeaseChangeBillCollection _getLeaseChangeBillRecord(Context ctx, String id, FaRentDirectionEnum rentDirection) throws BOSException, EASBizException {
        if (id == null) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT");
        sql.append(" FALEASECHANGEBILL.FID billId,");
        sql.append(" FALEASECHANGEBILL.FDate changeDate,");
        sql.append(" FALEASECHANGEBILL.FNumber number,");
        sql.append(" ENTRIES.FID entryId,");
        sql.append(" ENTRIES.FContractNameOld contractNameOld,");
        sql.append(" ENTRIES.FContractNameNew contractNameNew,");
        sql.append(" ENTRIES.FRentInOutObjOld rentInOutObjOld,");
        sql.append(" ENTRIES.FRentInOutObjNew rentInOutObjNew,");
        sql.append(" COSTCENTEROLD.FID costCenterOldId,");
        sql.append(" COSTCENTEROLD.FName_l2 costCenterOldName,");
        sql.append(" COSTCENTERNEW.FID costCenterNewId,");
        sql.append(" COSTCENTERNEW.FName_l2 costCenterNewName,");
        sql.append(" USEDEPARTMENTOLD.FID useDepartmentOldId,");
        sql.append(" USEDEPARTMENTOLD.FName_l2 useDepartmentOldName,");
        sql.append(" USEDEPARTMENTNEW.FID useDepartmentNewId,");
        sql.append(" USEDEPARTMENTNEW.FName_l2 useDepartmentNewName,");
        sql.append(" CONTRACTCATOLD.FID contractCatOldId,");
        sql.append(" CONTRACTCATOLD.FName_l2 contractCatOldName,");
        sql.append(" CONTRACTCATNEW.FID contractCatNewId,");
        sql.append(" CONTRACTCATNEW.FName_l2 contractCatNewName");
        sql.append(" FROM T_FA_FaLeaseChangeBill AS FALEASECHANGEBILL");
        sql.append(" LEFT OUTER JOIN T_FA_FaLeaseChangeBillEntry AS ENTRIES");
        sql.append(" ON FALEASECHANGEBILL.FID = ENTRIES.FBillID");
        sql.append(" LEFT OUTER JOIN T_ORG_CostCenter AS COSTCENTEROLD");
        sql.append(" ON ENTRIES.FCostCenterOldID = COSTCENTEROLD.FID");
        sql.append(" LEFT OUTER JOIN T_ORG_CostCenter AS COSTCENTERNEW");
        sql.append(" ON ENTRIES.FCostCenterNewID = COSTCENTERNEW.FID");
        sql.append(" LEFT OUTER JOIN T_ORG_Admin AS USEDEPARTMENTOLD");
        sql.append(" ON ENTRIES.FUseDepartmentOldID = USEDEPARTMENTOLD.FID");
        sql.append(" LEFT OUTER JOIN T_ORG_Admin AS USEDEPARTMENTNEW");
        sql.append(" ON ENTRIES.FUseDepartmentNewID = USEDEPARTMENTNEW.FID");
        sql.append(" LEFT OUTER JOIN T_FA_FaLeaseInBillNew AS LEASEINBILL");
        sql.append(" ON ENTRIES.FLeaseInBillID = LEASEINBILL.FID");
        sql.append(" LEFT OUTER JOIN T_FA_FAContractCat AS CONTRACTCATOLD");
        sql.append(" ON ENTRIES.FContractCatOldID = CONTRACTCATOLD.FID");
        sql.append(" LEFT OUTER JOIN T_FA_FAContractCat AS CONTRACTCATNEW");
        sql.append(" ON ENTRIES.FContractCatNewID = CONTRACTCATNEW.FID");
        sql.append(" WHERE LEASEINBILL.FID = '");
        sql.append(id);
        sql.append("' AND");
        sql.append(" FALEASECHANGEBILL.FCHECKEDSTATUS = 2");
        sql.append(" ORDER BY");
        sql.append(" changeDate ASC,");
        sql.append(" number ASC");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        FaLeaseChangeBillCollection changeBillCol = new FaLeaseChangeBillCollection();
        try {
            while (rs.next()) {
                if (rs.getString("billId") == null || rs.getString("entryId") == null) continue;
                FaLeaseChangeBillInfo billInfo = new FaLeaseChangeBillInfo();
                FaLeaseChangeBillEntryCollection entries = new FaLeaseChangeBillEntryCollection();
                FaLeaseChangeBillEntryInfo entry = new FaLeaseChangeBillEntryInfo();
                billInfo.setId(BOSUuid.read((String)rs.getString("billId")));
                billInfo.setDate(rs.getDate("changeDate"));
                billInfo.setNumber(rs.getString("number"));
                entry.setId(BOSUuid.read((String)rs.getString("entryId")));
                entry.setContractNameOld(rs.getString("contractNameOld"));
                entry.setContractNameNew(rs.getString("contractNameNew"));
                entry.setRentInOutObjOld(rs.getString("rentInOutObjOld"));
                entry.setRentInOutObjNew(rs.getString("rentInOutObjNew"));
                CostCenterOrgUnitInfo costCenterOld = null;
                CostCenterOrgUnitInfo costCenterNew = null;
                AdminOrgUnitInfo useDepartmentOld = null;
                AdminOrgUnitInfo useDepartmentNew = null;
                FaContractCatInfo contractCatOld = null;
                FaContractCatInfo contractCatNew = null;
                if (rs.getString("costCenterOldId") != null) {
                    costCenterOld = new CostCenterOrgUnitInfo();
                    costCenterOld.setId(BOSUuid.read((String)rs.getString("costCenterOldId")));
                    costCenterOld.setName(rs.getString("costCenterOldName"));
                }
                if (rs.getString("costCenterNewId") != null) {
                    costCenterNew = new CostCenterOrgUnitInfo();
                    costCenterNew.setId(BOSUuid.read((String)rs.getString("costCenterNewId")));
                    costCenterNew.setName(rs.getString("costCenterNewName"));
                }
                if (rs.getString("useDepartmentOldId") != null) {
                    useDepartmentOld = new AdminOrgUnitInfo();
                    useDepartmentOld.setId(BOSUuid.read((String)rs.getString("useDepartmentOldId")));
                    useDepartmentOld.setName(rs.getString("useDepartmentOldName"));
                }
                if (rs.getString("useDepartmentNewId") != null) {
                    useDepartmentNew = new AdminOrgUnitInfo();
                    useDepartmentNew.setId(BOSUuid.read((String)rs.getString("useDepartmentNewId")));
                    useDepartmentNew.setName(rs.getString("useDepartmentNewName"));
                }
                if (rs.getString("contractCatOldId") != null) {
                    contractCatOld = new FaContractCatInfo();
                    contractCatOld.setId(BOSUuid.read((String)rs.getString("contractCatOldId")));
                    contractCatOld.setName(rs.getString("contractCatOldName"));
                }
                if (rs.getString("contractCatNewId") != null) {
                    contractCatNew = new FaContractCatInfo();
                    contractCatNew.setId(BOSUuid.read((String)rs.getString("contractCatNewId")));
                    contractCatNew.setName(rs.getString("contractCatNewName"));
                }
                entry.setCostCenterOld(costCenterOld);
                entry.setCostCenterNew(costCenterNew);
                entry.setUseDepartmentOld(useDepartmentOld);
                entry.setUseDepartmentNew(useDepartmentNew);
                entry.setContractCatOld(contractCatOld);
                entry.setContractCatNew(contractCatNew);
                entries.add(entry);
                billInfo.put("entries", (Object)entries);
                changeBillCol.add(billInfo);
            }
        }
        catch (SQLException e) {
            throw new EASBizException(new NumericExceptionSubItem("01", e.getMessage()));
        }
        return changeBillCol;
    }
}

