/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaBillBizProcessor;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillInfo;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaLeaseInBillControllerBean;
import com.kingdee.eas.fi.fa.manage.app.AbstractPrcFaManageStrategy;
import com.kingdee.eas.fi.fa.manage.app.PrcFaCoreManager;
import com.kingdee.eas.fi.fa.manage.app.PrcFaLeaseInStrategy;
import com.kingdee.eas.framework.BillBaseInfo;
import java.util.HashMap;

public class FaLeaseInBillControllerBean
extends AbstractFaLeaseInBillControllerBean {
    private static final long serialVersionUID = 8082771935930318517L;

    @Override
    public String getMasterTable() {
        return "T_FA_FaLeaseInBill";
    }

    @Override
    protected AbstractPrcFaManageStrategy getBillStrategy() {
        return new PrcFaLeaseInStrategy();
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        FaLeaseInBillInfo billInfo = (FaLeaseInBillInfo)super._getValue(ctx, pk, selector);
        for (int i = 0; i < billInfo.getEntry().size(); ++i) {
            FaLeaseInBillEntryInfo entryInfo = billInfo.getEntry().get(i);
            if (entryInfo.getFaCurCard() == null) continue;
            entryInfo.setAssetCat(entryInfo.getFaCurCard().getAssetCat());
            entryInfo.setCardNumber(entryInfo.getFaCurCard().getNumber());
            entryInfo.setCardName(entryInfo.getFaCurCard().getAssetName());
            entryInfo.setMeasureUnit(entryInfo.getFaCurCard().getMeasureUnit());
            entryInfo.setSpecs(entryInfo.getFaCurCard().getSpecs());
        }
        return billInfo;
    }

    @Override
    protected DAPTransformResult _generateVoucher(Context ctx, IObjectCollection sourceBillCollection, IObjectPK botMappingPK) throws BOSException, EASBizException {
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(this.getBillStrategy());
        int size = sourceBillCollection.size();
        for (int i = 0; i < size; ++i) {
            FaLeaseInBillInfo info = (FaLeaseInBillInfo)sourceBillCollection.getObject(i);
            if (info == null) continue;
            prcFaCoreManager.getFaManageStrategy().checkForOperate(ctx, info, 2);
        }
        return super._generateVoucher(ctx, sourceBillCollection, botMappingPK);
    }

    @Override
    protected void _giveBack(Context ctx, String billID) throws BOSException, EASBizException {
        FaBillBizProcessor.lockTable(ctx, billID);
        ((PrcFaLeaseInStrategy)this.getBillStrategy()).giveBack(ctx, BOSUuid.read((String)billID));
    }

    @Override
    protected void _buy(Context ctx, String billID) throws BOSException, EASBizException {
        FaBillBizProcessor.lockTable(ctx, billID);
        ((PrcFaLeaseInStrategy)this.getBillStrategy()).buy(ctx, BOSUuid.read((String)billID));
    }

    @Override
    protected BillBaseInfo _relet(Context ctx, String billID) throws BOSException, EASBizException {
        FaBillBizProcessor.lockTable(ctx, billID);
        return ((PrcFaLeaseInStrategy)this.getBillStrategy()).relet(ctx, BOSUuid.read((String)billID));
    }

    @Override
    protected void _unAction(Context ctx, String billID) throws BOSException, EASBizException {
        FaBillBizProcessor.lockTable(ctx, billID);
        ((PrcFaLeaseInStrategy)this.getBillStrategy()).unAction(ctx, BOSUuid.read((String)billID));
    }

    @Override
    protected SelectorItemCollection getSelfSelctor() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("auditor.id"));
        sic.add(new SelectorItemInfo("handler.id"));
        sic.add(new SelectorItemInfo("period.id"));
        sic.add(new SelectorItemInfo("billType"));
        sic.add(new SelectorItemInfo("bizStatus"));
        sic.add(new SelectorItemInfo("leaseType.number"));
        return sic;
    }

    @Override
    protected boolean isNeedGenVoucher() {
        return true;
    }

    @Override
    protected void checkBeforeSave(Context ctx, IObjectValue model) throws BOSException {
    }

    @Override
    protected void checkBeforeSubmit(Context ctx, IObjectValue model) throws BOSException {
    }

    @Override
    protected HashMap _getInfoForInitUI(Context ctx, String companyID) throws BOSException, EASBizException {
        HashMap initInfo = super._getInfoForInitUI(ctx, companyID);
        ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo currentCompany = (CompanyOrgUnitInfo)initInfo.get("currentCompany");
        CurrencyInfo baseCurrency = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currentCompany.getBaseCurrency().getId()));
        initInfo.put("baseCurrency", baseCurrency);
        ICurrency initICurrcny = CurrencyFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewCurrency = new EntityViewInfo();
        SelectorItemCollection sicCurrency = viewCurrency.getSelector();
        sicCurrency.add(new SelectorItemInfo("id"));
        sicCurrency.add(new SelectorItemInfo("number"));
        sicCurrency.add(new SelectorItemInfo("name"));
        sicCurrency.add(new SelectorItemInfo("isoCode"));
        sicCurrency.add(new SelectorItemInfo("sign"));
        sicCurrency.add(new SelectorItemInfo("baseUnit"));
        sicCurrency.add(new SelectorItemInfo("precision"));
        sicCurrency.add(new SelectorItemInfo("deletedStatus"));
        CurrencyCollection currencyCollection = initICurrcny.getCurrencyCollection(viewCurrency, true);
        if (baseCurrency != null && currencyCollection != null && currencyCollection.size() > 0) {
            for (int i = 0; i < currencyCollection.size(); ++i) {
                if (baseCurrency.getId() == null || !baseCurrency.getId().equals((Object)currencyCollection.get(i).getId())) continue;
                CurrencyInfo newCurrency = new CurrencyInfo();
                CurrencyInfo currencyFst = currencyCollection.get(0);
                CurrencyInfo currencyTmp = currencyCollection.get(i);
                currencyCollection.set(0, newCurrency);
                currencyCollection.set(i, currencyFst);
                currencyCollection.set(0, currencyTmp);
                break;
            }
        }
        initInfo.put("currencyCollection", currencyCollection);
        return initInfo;
    }
}

