/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.DepreciationMethodEnum;
import com.kingdee.eas.fi.fa.basedata.FaNewLeasePolicyFactory;
import com.kingdee.eas.fi.fa.basedata.FaNewLeasePolicyInfo;
import com.kingdee.eas.fi.fa.manage.FaBillBaseInfo;
import com.kingdee.eas.fi.fa.manage.FaBillBizProcessor;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillNewCollection;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillNewFactory;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillNewInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaLessorTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaNLMChangeAssetItemCollection;
import com.kingdee.eas.fi.fa.manage.FaNLMChangeAssetItemFactory;
import com.kingdee.eas.fi.fa.manage.FaPayFrequencyEnum;
import com.kingdee.eas.fi.fa.manage.FaPaymentPlanNewCollection;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaLeaseInBillNewControllerBean;
import com.kingdee.eas.fi.fa.manage.app.AbstractPrcFaManageStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.PrcFaCoreManager;
import com.kingdee.eas.fi.fa.manage.app.PrcFaLeaseInNewStrategy;
import com.kingdee.eas.fi.fa.manage.app.fleventlistener.utils.RPCMethodMappingUtils;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class FaLeaseInBillNewControllerBean
extends AbstractFaLeaseInBillNewControllerBean {
    public static final String RES_PATH_CARD = "com.kingdee.eas.fi.fa.manage.FaCardResource";
    public static final String RES_PATH_LEASENEW = "com.kingdee.eas.fi.fa.manage.FaLeaseNewResource";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.manage.app.FaLeaseInBillNewControllerBean");

    @Override
    protected void _giveBack(Context ctx, String billID) throws BOSException, EASBizException {
    }

    @Override
    protected void _buy(Context ctx, String billID) throws BOSException, EASBizException {
    }

    @Override
    protected BillBaseInfo _relet(Context ctx, String billID) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected void _unAction(Context ctx, String billID) throws BOSException, EASBizException {
    }

    @Override
    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String id = model.get("id") == null ? null : model.get("id").toString();
        FaBillBizProcessor.lockTable(ctx, id);
        this.checkBeforeSave(ctx, model);
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(this.getBillStrategy());
        FaBillBaseInfo billBaseInfo = (FaBillBaseInfo)model;
        if (billBaseInfo != null && billBaseInfo.getBOSUuid("id") != null) {
            prcFaCoreManager.getFaManageStrategy().checkForSave(ctx, (IObjectValue)billBaseInfo);
        }
        logger.debug((Object)"_save");
        return prcFaCoreManager.getFaManageStrategy().saveBill(ctx, model);
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk;
        PrcFaLeaseInNewStrategy strategy = (PrcFaLeaseInNewStrategy)this.getBillStrategy();
        FaLeaseInBillNewInfo billInfo = (FaLeaseInBillNewInfo)model;
        if (PrcFaLeaseInNewStrategy.isInitBill(ctx, billInfo, null)) {
            if (billInfo.getEffectedStatus() == EffectedStatusEnum.EFFECTED && billInfo.getCheckedStatus() == CheckedStatusEnum.AUDITED) {
                this._unpassAudit(ctx, (IObjectPK)new ObjectUuidPK(billInfo.getId()));
            }
            pk = this.ovrSubmit(ctx, model);
            this._passAudit(ctx, pk);
        } else {
            pk = this.ovrSubmit(ctx, model);
        }
        return pk;
    }

    private IObjectPK ovrSubmit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String pk = model.get("id") == null ? null : model.get("id").toString();
        FaBillBizProcessor.lockTable(ctx, pk);
        this.checkBeforeSubmit(ctx, model);
        if (model != null && model.getBoolean("forDAP")) {
            return this._submitSelf(ctx, (FaBillBaseInfo)model);
        }
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(this.getBillStrategy());
        FaBillBaseInfo billBaseInfo = (FaBillBaseInfo)model;
        if (billBaseInfo != null && billBaseInfo.getBOSUuid("id") != null) {
            prcFaCoreManager.getFaManageStrategy().checkForEdit(ctx, (IObjectValue)billBaseInfo);
        }
        logger.debug((Object)"_submit");
        return prcFaCoreManager.getFaManageStrategy().submitBill(ctx, model);
    }

    @Override
    protected void _submit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FaLeaseInBillNewInfo model = FaLeaseInBillNewFactory.getLocalInstance(ctx).getFaLeaseInBillNewInfo(pk);
        model.setDpInitCfmDate(FaManageUtils.getFirstImplDateServer(ctx, model.getCompany()));
        boolean isEnableStockContract = FaManageUtils.getFaParamValue(ctx, "NLM_HIDE_001", model.getCompany().getId().toString());
        model.setIsBeforeImplDate(model.isIsHistory() && isEnableStockContract && !model.isIsExempt() && model.getBeginDate() != null && model.getBeginDate().compareTo(FaManageUtils.getFirstImplDateServer(ctx, model.getCompany())) < 0);
        this.verifyBeforeSubmit(ctx, model);
        this._submit(ctx, (IObjectValue)model);
    }

    private void verifyBeforeSubmit(Context ctx, FaLeaseInBillNewInfo billInfo) throws EASBizException, BOSException {
        boolean isNLM_307;
        Date endDate;
        Date beginDate;
        if (billInfo.getNumber() == null || billInfo.getNumber().trim().equals("")) {
            this.throwVerifySubmitException(ctx, "Number_Not_Null");
        }
        if (billInfo.getContractName() == null || billInfo.getContractName().trim().equals("")) {
            this.throwVerifySubmitException(ctx, "Contract_Name_Not_Null");
        }
        if (billInfo.getContractCat() == null) {
            this.throwVerifySubmitException(ctx, "Contract_Cat_Not_Null");
        }
        PrcFaLeaseInNewStrategy strategy = (PrcFaLeaseInNewStrategy)this.getBillStrategy();
        PeriodInfo currPeriod = FaLocalUtils.getFLCurrentPeriod(billInfo.getCompany().getId().toString(), ctx);
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)billInfo.getCompany());
        Date fiAccountDate = billInfo.getFiAccountDate();
        if (PrcFaLeaseInNewStrategy.isInitBill(ctx, billInfo, null)) {
            if (fiAccountDate != null && fiAccountDate.compareTo(currPeriod.getBeginDate()) >= 0 && fiAccountDate.compareTo(currPeriod.getEndDate()) > 0) {
                // empty if block
            }
        } else if (fiAccountDate == null || billInfo.isIsHistory() && DateTimeUtils.dayAfter((Date)fiAccountDate, (Date)currPeriod.getEndDate()) || !billInfo.isIsHistory() && (DateTimeUtils.dayBefore((Date)fiAccountDate, (Date)currPeriod.getBeginDate()) || DateTimeUtils.dayAfter((Date)fiAccountDate, (Date)currPeriod.getEndDate()))) {
            this.throwVerifySubmitException(ctx, "Account_Date_Out_Of_Current_Period");
        }
        if (billInfo.getLessorType() != null && billInfo.getLessorType() != FaLessorTypeEnum.NONE && billInfo.getInnerCompanyLessor() == null && billInfo.getCustomerLessor() == null && billInfo.getSupplierLessor() == null) {
            this.throwVerifySubmitException(ctx, "Lessor_Not_Null");
        }
        if (billInfo.getCurrency() == null) {
            this.throwVerifySubmitException(ctx, "Currency_Not_Null");
        }
        if (billInfo.getExchangeRateValue() == null) {
            this.throwVerifySubmitException(ctx, "Exchange_Rate_Not_Null");
        }
        if ((beginDate = billInfo.getBeginDate()) == null) {
            this.throwVerifySubmitException(ctx, "Begin_Date_Not_Null");
        }
        if (DateTimeUtils.dayAfter((Date)beginDate, (Date)currPeriod.getEndDate())) {
            this.throwVerifySubmitException(ctx, "Begin_Date_Out_Of_Current_Period");
        }
        if ((endDate = billInfo.getEndDate()) == null) {
            this.throwVerifySubmitException(ctx, "End_Date_Not_Null");
        }
        if (DateTimeUtils.dayAfter((Date)beginDate, (Date)endDate)) {
            this.throwVerifySubmitException(ctx, "End_Date_Before_Begin_Date");
        }
        FaNewLeasePolicyInfo newLeasePolicy = FaNewLeasePolicyFactory.getLocalInstance((Context)ctx).getEnabledNewLeasePolicy(billInfo.getCompany().getId().toString());
        if (billInfo.getTimeCycle() <= 0 && billInfo.getLeaseType() == FaLeaseTypeEnum.OPERATING_LEASE && newLeasePolicy.getDepreciationMethod() == DepreciationMethodEnum.Second) {
            this.throwVerifySubmitException(ctx, "TimeCycle_Not_Null");
        }
        if (billInfo.getDepEndDate() != null || billInfo.getLeaseType() != FaLeaseTypeEnum.OPERATING_LEASE || newLeasePolicy.getDepreciationMethod() == DepreciationMethodEnum.First) {
            // empty if block
        }
        if (!this.checkPayOffWithOperaTing(billInfo)) {
            if (billInfo.getFirstPayTime() == null) {
                this.throwVerifySubmitException(ctx, "First_Pay_Time_Not_Null");
            }
            if (DateTimeUtils.dayBefore((Date)billInfo.getFirstPayTime(), (Date)beginDate)) {
                this.throwVerifySubmitException(ctx, "First_Pay_Time_Less_Than_Begin_Date");
            }
        }
        if (billInfo.getRentWithTax() == null) {
            this.throwVerifySubmitException(ctx, "Rent_With_Tax_Not_Null");
        }
        if (billInfo.getTaxRate() == null) {
            this.throwVerifySubmitException(ctx, "Tax_Rate_Not_Null");
        }
        if (billInfo.getInvoiceType() == null) {
            this.throwVerifySubmitException(ctx, "InvoiceType_Not_Null");
        }
        if (DateTimeUtils.dayAfter((Date)beginDate, (Date)fiAccountDate)) {
            this.throwVerifySubmitException(ctx, "Account_Date_Before_Begin_Date");
        }
        if (billInfo.getBeginRentDate() == null) {
            this.throwVerifySubmitException(ctx, "Begin_Free_Period_Date_Not_Null");
        }
        if (billInfo.isIsExistsFreePeriod()) {
            if (billInfo.getBeginFreePeriodDate() == null) {
                this.throwVerifySubmitException(ctx, "Begin_Free_Period_Date_Not_Null");
            }
            if (billInfo.getEndFreePeriodDate() == null) {
                this.throwVerifySubmitException(ctx, "End_Free_Period_Date_Not_Null");
            }
            if (billInfo.getBeginFreePeriodDate().compareTo(billInfo.getEndFreePeriodDate()) == 1) {
                this.throwVerifySubmitException(ctx, "Begin_Free_Period_Date_Not_Greater_Than_End_Free_Period_Date");
            }
            if (billInfo.getBeginFreePeriodDate().compareTo(billInfo.getBeginRentDate()) == 1) {
                this.throwVerifySubmitException(ctx, "Begin_Free_Period_Date_Not_Greater_Than_Begin_Rent_Date");
            }
        }
        for (int i = 0; i < FaManageUtils.COSTTYPES.length; ++i) {
            int propertyIndex = i + 1;
            if (!this.isCostRowInputed(billInfo, propertyIndex) || propertyIndex == 6) continue;
            if (billInfo.get("costDate" + propertyIndex) == null) {
                this.throwVerifySubmitException(ctx, "Cost_Type_Date_Not_Null", new String[]{ResourceBase.getString((String)RES_PATH_LEASENEW, (String)FaManageUtils.COSTTYPES[i], (Locale)ctx.getOriginLocale())});
            }
            if (billInfo.get("costTaxRate" + propertyIndex) == null) {
                this.throwVerifySubmitException(ctx, "Cost_Type_Tax_Rate_Not_Null", new String[]{ResourceBase.getString((String)RES_PATH_LEASENEW, (String)FaManageUtils.COSTTYPES[i], (Locale)ctx.getOriginLocale())});
            }
            if (billInfo.get("costPmWithTax" + propertyIndex) == null) {
                this.throwVerifySubmitException(ctx, "Cost_Type_Payment_With_Tax_Not_Null", new String[]{ResourceBase.getString((String)RES_PATH_LEASENEW, (String)FaManageUtils.COSTTYPES[i], (Locale)ctx.getOriginLocale())});
            }
            if (billInfo.get("costPmWithoutTax" + propertyIndex) == null) {
                this.throwVerifySubmitException(ctx, "Cost_Type_Payment_Without_Tax_Not_Null", new String[]{ResourceBase.getString((String)RES_PATH_LEASENEW, (String)FaManageUtils.COSTTYPES[i], (Locale)ctx.getOriginLocale())});
            }
            if (billInfo.get("costTax" + propertyIndex) != null) continue;
            this.throwVerifySubmitException(ctx, "Cost_Type_Payment_Tax_Not_Null", new String[]{ResourceBase.getString((String)RES_PATH_LEASENEW, (String)FaManageUtils.COSTTYPES[i], (Locale)ctx.getOriginLocale())});
        }
        FaPaymentPlanNewCollection pmEntry = this.sortEntryByPayDate(billInfo.getPaymentEntry());
        int currencyPrecision = PrcFaLeaseInNewStrategy.getCurrencyScale(billInfo.getCompany(), ctx);
        if (billInfo.isIsHistory()) {
            Integer hasRented = billInfo.getHasRented();
            BigDecimal hasPayedRent = billInfo.getHasPayedRent();
            if (hasPayedRent == null) {
                this.throwVerifySubmitException(ctx, "Has_Payed_Rent_Not_Null");
            }
            if (billInfo.getHasRented() < 0 || billInfo.getHasRented() > billInfo.getTotalPayPeriod()) {
                this.throwVerifySubmitException(ctx, "Has_Rented_Incorrect");
            }
            if (pmEntry.size() >= hasRented) {
                BigDecimal entryHasPayedRent = BigDecimal.ZERO;
                for (int x = hasRented - 1; x >= 0; --x) {
                    BigDecimal thePayedRent = BigDecimal.ZERO;
                    if (pmEntry.get(x).getPaymentWithTax() != null) {
                        thePayedRent = pmEntry.get(x).getPaymentWithTax().setScale(currencyPrecision, 4);
                    }
                    entryHasPayedRent = entryHasPayedRent.add(thePayedRent).setScale(currencyPrecision, 4);
                }
                if (entryHasPayedRent.compareTo(hasPayedRent) != 0) {
                    this.throwVerifySubmitException(ctx, "Pay_Plan_And_Header_Has_Payed_Rent_Not_Equal");
                }
            }
        }
        if (billInfo.getLeaseType() == FaLeaseTypeEnum.OPERATING_LEASE && billInfo.getDiscountRate() == null) {
            this.throwVerifySubmitException(ctx, "Discount_Rate_Not_Null");
        }
        if (!(isNLM_307 = FaManageUtils.getFaParamValue(ctx, "NLM_307", billInfo.getCompany().getId().toString())) && billInfo.getLeaseType() == FaLeaseTypeEnum.OPERATING_LEASE && BigDecimal.ZERO.compareTo(billInfo.getDiscountRate()) == 0) {
            this.throwVerifySubmitException(ctx, "Discount_Rate_Not_Zero");
        }
        if (!this.checkPayOffWithOperaTing(billInfo)) {
            int i;
            if (pmEntry.size() > 0) {
                BigDecimal total = pmEntry.get(pmEntry.size() - 1).getPaymentWithTax().setScale(currencyPrecision, 4);
                if (total.compareTo(billInfo.getRentWithTax().setScale(currencyPrecision, 4)) != 0) {
                    this.throwVerifySubmitException(ctx, "Pay_Plan_And_Header_Rent_With_Tax_Not_Equal");
                }
            } else {
                this.throwVerifySubmitException(ctx, "Pay_Plan_Not_Null");
            }
            if (pmEntry.size() - 1 != billInfo.getTotalPayPeriod()) {
                this.throwVerifySubmitException(ctx, "Pay_Plan_Total_Pay_Period_Must_Equal_Header_Total_Pay_Period");
            }
            StringBuilder chkPayDateMsg = new StringBuilder();
            for (i = 0; i < pmEntry.size() - 1; ++i) {
                if (pmEntry.get(i).getPayDate() != null) continue;
                if (chkPayDateMsg.length() > 0) {
                    chkPayDateMsg.append("\uff1b");
                }
                chkPayDateMsg.append(ResourceBase.getString((String)RES_PATH_LEASENEW, (String)"Pay_Plan_Date_Not_Null", (Locale)ctx.getOriginLocale(), (Object[])new String[]{String.valueOf(i + 1)}));
            }
            if (chkPayDateMsg.length() > 0) {
                String thisBillStr = ResourceBase.getString((String)RES_PATH_CARD, (String)"THISBILL", (Locale)ctx.getOriginLocale());
                throw new FaCardException(FaCardException.UN_SUCCESS, new String[]{thisBillStr + chkPayDateMsg.toString()});
            }
            for (i = 0; i < pmEntry.size() - 1; ++i) {
                if (i == pmEntry.size() - 1) continue;
                Date curDate = pmEntry.get(i).getPayDate();
                if (i == 0) {
                    if (!DateTimeUtils.dayBefore((Date)curDate, (Date)beginDate)) continue;
                    this.throwVerifySubmitException(ctx, "First_Pay_Plan_Time_Less_Than_Begin_Date");
                    continue;
                }
                Date preDate = pmEntry.get(i - 1).getPayDate();
                if (!DateTimeUtils.dayBefore((Date)curDate, (Date)preDate)) continue;
                this.throwVerifySubmitException(ctx, "Pay_Plan_Time_Less_Than_Pre_One", new String[]{String.valueOf(i + 1)});
            }
        }
        if (this.isCostRowInputed(billInfo, 1) && ((Date)billInfo.get("costDate1")).compareTo(billInfo.getBeginRentDate()) > 0) {
            this.throwVerifySubmitException(ctx, "Advance_Payment_Date_Not_Greater_Than_Begin_Date", new String[]{EASResource.getString((String)RES_PATH_LEASENEW, (String)FaManageUtils.COSTTYPES[0])});
        }
        if (this.isCostRowInputed(billInfo, 2) && ((Date)billInfo.get("costDate2")).compareTo(beginDate) > 0) {
            this.throwVerifySubmitException(ctx, "Advance_Payment_Date_Not_Greater_Than_PK_Begin_Date", new String[]{EASResource.getString((String)RES_PATH_LEASENEW, (String)FaManageUtils.COSTTYPES[1])});
        }
        if (this.isCostRowInputed(billInfo, 7) && ((Date)billInfo.get("costDate7")).compareTo(beginDate) > 0) {
            this.throwVerifySubmitException(ctx, "Advance_Payment_Date_Not_Greater_Than_PK_Begin_Date", new String[]{EASResource.getString((String)RES_PATH_LEASENEW, (String)FaManageUtils.COSTTYPES[6])});
        }
    }

    private void throwVerifySubmitException(Context ctx, String resName) throws FaCardException {
        this.throwVerifySubmitException(ctx, resName, null);
    }

    private void throwVerifySubmitException(Context ctx, String resName, String[] param) throws FaCardException {
        String thisBillStr = ResourceBase.getString((String)RES_PATH_CARD, (String)"THISBILL", (Locale)ctx.getOriginLocale());
        String info = "";
        info = param != null ? ResourceBase.getString((String)RES_PATH_LEASENEW, (String)resName, (Locale)ctx.getOriginLocale(), (Object[])param) : ResourceBase.getString((String)RES_PATH_LEASENEW, (String)resName, (Locale)ctx.getOriginLocale());
        throw new FaCardException(FaCardException.UN_SUCCESS, new String[]{thisBillStr + info});
    }

    private boolean isCostRowInputed(FaLeaseInBillNewInfo billInfo, int propertyIndex) {
        return billInfo.get("costPmWithTax" + propertyIndex) != null || billInfo.get("costPmWithoutTax" + propertyIndex) != null || billInfo.get("costTaxRate" + propertyIndex) != null || billInfo.get("costTax" + propertyIndex) != null;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("checkedstatus");
        selector.add("isHistory");
        selector.add("company.id");
        selector.add("company.number");
        FaLeaseInBillNewInfo billInfo = FaLeaseInBillNewFactory.getLocalInstance(ctx).getFaLeaseInBillNewInfo(pk, selector);
        PrcFaLeaseInNewStrategy strategy = (PrcFaLeaseInNewStrategy)this.getBillStrategy();
        if (PrcFaLeaseInNewStrategy.isInitBill(ctx, billInfo, null)) {
            String unVoucheredSql = "UPDATE T_Fa_FaLeaseInBillNew SET FFIVouchered = 0 WHERE FID = ?";
            DbUtil.execute((Context)ctx, (String)unVoucheredSql, (Object[])new String[]{pk.toString()});
            if (billInfo.getCheckedStatus() == CheckedStatusEnum.AUDITED) {
                this._unpassAudit(ctx, pk);
            }
        }
        FaBillBizProcessor.lockTable(ctx, pk.toString());
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(this.getBillStrategy());
        prcFaCoreManager.getFaManageStrategy().checkForDelete(ctx, pk);
        prcFaCoreManager.getFaManageStrategy().deleteBill(ctx, pk);
    }

    @Override
    protected void _passAuditSelf(Context ctx, IObjectPK pk, FaBillBaseInfo model) throws BOSException, EASBizException {
        StringBuffer _sql = new StringBuffer("update " + this.getMasterTable() + "  set");
        _sql.append(" FCheckedStatus = ?");
        _sql.append(",FAuditorId = ?");
        _sql.append(",FAuditTime = ?");
        _sql.append(",FBizDate = ?");
        _sql.append(" where fid = ?");
        Object[] params = new Object[5];
        params[0] = new Integer(2);
        params[1] = ctx.getCaller().toString();
        Date date = new Date();
        long time = date.getTime();
        params[2] = new Timestamp(time);
        CompanyOrgUnitInfo company = model.getCompany();
        if (company == null || company.getId() == null) {
            company = (CompanyOrgUnitInfo)this.getValue(ctx, "select company.id where id ='" + pk + "'").get("company");
        }
        params[3] = new Timestamp(FaLocalUtils.getBizDate4Fl(ctx, company.getId().toString()).getTime());
        params[4] = pk.toString();
        DbUtil.execute((Context)ctx, (String)_sql.toString(), (Object[])params);
    }

    @Override
    public String getMasterTable() {
        return "T_FA_FaLeaseInBillNew";
    }

    public boolean checkStatusValid(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        return true;
    }

    @Override
    protected void checkBeforeSave(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    protected void checkBeforeSubmit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    protected AbstractPrcFaManageStrategy getBillStrategy() {
        return new PrcFaLeaseInNewStrategy();
    }

    @Override
    protected String _getLinkLeaseInBillId(Context ctx, String curLeaseInBill) throws BOSException, EASBizException {
        try {
            StringBuffer sqlCreated = new StringBuffer();
            sqlCreated.append("SELECT entry.FCreatedLeaseInBillId leaseInBillId FROM T_Fa_FaTerminateBill bill");
            sqlCreated.append(" LEFT JOIN T_Fa_FaTerminateBillEntry entry ON entry.FBillId = bill.FId");
            sqlCreated.append(" WHERE entry.FLeaseInBillId = '");
            sqlCreated.append(curLeaseInBill);
            sqlCreated.append("' AND entry.FisCreateLeaseInBill = 1 AND bill.FCheckedStatus = 2");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlCreated.toString());
            if (rs != null && rs.next()) {
                return rs.getString("leaseInBillId");
            }
            StringBuffer sqlSrc = new StringBuffer();
            sqlSrc.append("SELECT entry.FLeaseInBillId leaseInBillId FROM T_Fa_FaTerminateBill bill");
            sqlSrc.append(" LEFT JOIN T_Fa_FaTerminateBillEntry entry ON entry.FBillId = bill.FId");
            sqlSrc.append(" WHERE entry.FCreatedLeaseInBillId = '");
            sqlSrc.append(curLeaseInBill);
            sqlSrc.append("' AND entry.FisCreateLeaseInBill = 1 AND bill.FCheckedStatus = 2");
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlSrc.toString());
            if (rs != null && rs.next()) {
                return rs.getString("leaseInBillId");
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    @Override
    protected String _getLinkLeaseInBillIdForAssetChangeUp(Context ctx, String curLeaseInBill) throws BOSException, EASBizException {
        FaNLMChangeAssetItemCollection faNLMChangeAssetItemCollection = FaNLMChangeAssetItemFactory.getLocalInstance(ctx).getFaNLMChangeAssetItemCollection("WHERE leaseInBillNew.id = '" + curLeaseInBill + "'");
        if (faNLMChangeAssetItemCollection != null && faNLMChangeAssetItemCollection.size() != 0) {
            return faNLMChangeAssetItemCollection.get(0).getLeaseInBillOld().getId().toString();
        }
        return null;
    }

    @Override
    protected String _getLinkLeaseInBillIdForAssetChangeDown(Context ctx, String curLeaseInBill) throws BOSException, EASBizException {
        FaNLMChangeAssetItemCollection faNLMChangeAssetItemCollection = FaNLMChangeAssetItemFactory.getLocalInstance(ctx).getFaNLMChangeAssetItemCollection("WHERE leaseInBillOld.id = '" + curLeaseInBill + "'");
        if (faNLMChangeAssetItemCollection != null && faNLMChangeAssetItemCollection.size() != 0) {
            return faNLMChangeAssetItemCollection.get(0).getLeaseInBillNew().getId().toString();
        }
        return null;
    }

    @Override
    protected void _checkExpired(Context ctx) throws BOSException, EASBizException {
        DbUtil.execute((Context)ctx, (String)"UPDATE T_FA_FALEASEINBILLNEW SET FIsExpire = 1 WHERE now() >= FEndDate");
    }

    @Override
    protected void _finishInit(Context ctx) throws BOSException, EASBizException {
        if (!this.isStartPeriod(ctx)) {
            throw new EASBizException(new NumericExceptionSubItem("00", ResourceBase.getString((String)RES_PATH_LEASENEW, (String)"Can_Not_Finish_Init_In_Not_Start_Period", (Locale)ctx.getOriginLocale())));
        }
        this.checkInitBillEffected(ctx);
        SystemStatusCtrolFactory.getLocalInstance((Context)ctx).start(SystemEnum.FINANCE_LEASE, ContextUtil.getCurrentFIUnit((Context)ctx), true);
    }

    @Override
    protected void _unFinishInit(Context ctx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        if (!this.isStartPeriod(ctx)) {
            throw new EASBizException(new NumericExceptionSubItem("00", ResourceBase.getString((String)RES_PATH_LEASENEW, (String)"Can_Not_Unfinish_Init_In_Not_Start_Period", (Locale)ctx.getOriginLocale())));
        }
        boolean isRelAccount = SystemStatusCtrolUtils.isRelAccount((Context)ctx, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)company);
        if (isRelAccount) {
            throw new EASBizException(new NumericExceptionSubItem("00", ResourceBase.getString((String)RES_PATH_LEASENEW, (String)"Has_RelAccount_Can_Not_Unfinish_Init", (Locale)ctx.getOriginLocale())));
        }
        SystemStatusCtrolFactory.getLocalInstance((Context)ctx).start(SystemEnum.FINANCE_LEASE, company, false);
    }

    protected boolean isStartPeriod(Context ctx) throws EASBizException {
        boolean isStartPeriod = false;
        try {
            CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
            PeriodInfo curPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)company);
            PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)company);
            if (curPeriod == null || startPeriod == null) {
                isStartPeriod = false;
                throw new EASBizException(new NumericExceptionSubItem("00", ResourceBase.getString((String)RES_PATH_LEASENEW, (String)"Lease_Period_Is_Null", (Locale)ctx.getOriginLocale())));
            }
            isStartPeriod = curPeriod.getId().toString().equals(startPeriod.getId().toString());
        }
        catch (Exception e) {
            throw new EASBizException(new NumericExceptionSubItem("00", e.getMessage()));
        }
        return isStartPeriod;
    }

    private void checkInitBillEffected(Context ctx) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        String companyId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isHistory", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("effectedStatus", (Object)1));
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(selector);
        view.setFilter(filter);
        FaLeaseInBillNewCollection leaseInBillCol = this.getFaLeaseInBillNewCollection(ctx, view);
        if (leaseInBillCol != null && leaseInBillCol.size() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("00", ResourceBase.getString((String)RES_PATH_LEASENEW, (String)"Exists_Temp_LeaseInBill_Can_Not_Finish_Init", (Locale)ctx.getOriginLocale())));
        }
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        VoucherInfo voucher = FaLocalUtils.LookVoucherInfo(ctx, bOTRelationInfo);
        if (voucher == null) {
            super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
            return;
        }
        if (bOTBillOperStateEnum == BOTBillOperStateEnum.ADDNEW) {
            String updateBillSQL = "UPDATE T_Fa_FaLeaseInBillNew SET FFiVouchered = 1, FVoucher = ? WHERE FID = ?";
            DbUtil.execute((Context)ctx, (String)updateBillSQL, (Object[])new String[]{voucher.getId().toString(), srcBillVO.get("id").toString()});
        } else if (bOTBillOperStateEnum == BOTBillOperStateEnum.DELETE) {
            String updateBillSQL = "UPDATE T_Fa_FaLeaseInBillNew SET FFiVouchered = 0, FVoucher = null WHERE FID = ?";
            DbUtil.execute((Context)ctx, (String)updateBillSQL, (Object[])new String[]{srcBillVO.get("id").toString()});
        } else if (bOTBillOperStateEnum != BOTBillOperStateEnum.EDIT) {
            super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
        }
    }

    private FaPaymentPlanNewCollection sortEntryByPayDate(FaPaymentPlanNewCollection entry) {
        if (entry == null || entry.size() == 0) {
            return entry;
        }
        FaPaymentPlanNewCollection tmpEntry = new FaPaymentPlanNewCollection();
        int i = 1;
        int j = entry.size();
        boolean[] memory = new boolean[j];
        while (i != j) {
            for (int n = 0; n < j; ++n) {
                if (i != entry.get(n).getRentPeriod()) continue;
                tmpEntry.add(entry.get(n));
                ++i;
                memory[n] = true;
            }
        }
        for (int k = 0; k < j; ++k) {
            if (memory[k]) continue;
            tmpEntry.add(entry.get(k));
        }
        return tmpEntry;
    }

    private boolean checkPayOffWithOperaTing(FaLeaseInBillNewInfo billInfo) {
        FaLeaseTypeEnum leaseType = billInfo.getLeaseType() == null ? FaLeaseTypeEnum.OPERATING_LEASE : billInfo.getLeaseType();
        FaPayFrequencyEnum payFrequency = billInfo.getPayFrequency();
        boolean isLeaseType = FaLeaseTypeEnum.OPERATING_LEASE == leaseType;
        boolean isPayFrequency = FaPayFrequencyEnum.PAY_IN_ADVANCE == payFrequency;
        return isLeaseType && isPayFrequency;
    }

    protected void invokeServiceAfter(ServiceContext svcCtx) throws BOSException {
        RPCMethodMappingUtils.invokeRPCMethodEventListener(svcCtx, new FaLeaseInBillNewInfo());
        super.invokeServiceAfter(svcCtx);
    }
}

