/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.person.app.PersonToWFAdapter;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.fa.basedata.FaAlterModeCollection;
import com.kingdee.eas.fi.fa.basedata.FaAlterModeFactory;
import com.kingdee.eas.fi.fa.basedata.FaAlterModeInfo;
import com.kingdee.eas.fi.fa.manage.FaAppLogForBusinessTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaApprovingInfo;
import com.kingdee.eas.fi.fa.manage.FaBakCardFactory;
import com.kingdee.eas.fi.fa.manage.FaBakCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBillBizProcessor;
import com.kingdee.eas.fi.fa.manage.FaBillOriginEnum;
import com.kingdee.eas.fi.fa.manage.FaBillTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaBizCardFactory;
import com.kingdee.eas.fi.fa.manage.FaBizCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBizStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.FaCardFactory;
import com.kingdee.eas.fi.fa.manage.FaChangeBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaChangeBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaChangeBillFactory;
import com.kingdee.eas.fi.fa.manage.FaChangeBillInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaMaintainEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaMaintainEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaMaintainEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaMaintainExpenseCollection;
import com.kingdee.eas.fi.fa.manage.FaMaintainExpenseInfo;
import com.kingdee.eas.fi.fa.manage.FaMaintainFactory;
import com.kingdee.eas.fi.fa.manage.FaMaintainInfo;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaWorkAreaFactory;
import com.kingdee.eas.fi.fa.manage.FaWorkAreaInfo;
import com.kingdee.eas.fi.fa.manage.IFaBakCard;
import com.kingdee.eas.fi.fa.manage.IFaBizCard;
import com.kingdee.eas.fi.fa.manage.IFaChangeBill;
import com.kingdee.eas.fi.fa.manage.IFaCurCard;
import com.kingdee.eas.fi.fa.manage.IFaMaintain;
import com.kingdee.eas.fi.fa.manage.IFaMaintainEntry;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaMaintainControllerBean;
import com.kingdee.eas.fi.fa.manage.app.AbstractPrcFaManageStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.PrcFaChangeStrategy;
import com.kingdee.eas.fi.fa.manage.app.PrcFaCoreManager;
import com.kingdee.eas.fi.fa.manage.app.PrcFaMaintainStrategy;
import com.kingdee.eas.fi.fa.manage.app.falog.event.FaMethodCalcOrderEnum;
import com.kingdee.eas.fi.fa.manage.app.falog.utils.FaRPCMethodMappingUtils;
import com.kingdee.eas.fi.fa.manage.client.FaApprovingEditUI;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class FaMaintainControllerBean
extends AbstractFaMaintainControllerBean {
    private static final long serialVersionUID = -6815277385131238832L;
    protected static final String FAMAINTAINRESOURCE = "com.kingdee.eas.fi.fa.manage.FaMaintainResource";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.manage.app.FaMaintainControllerBean");

    private static IFaCurCard getFaCurdCardInstance(Context ctx) throws BOSException {
        return FaCurCardFactory.getLocalInstance(ctx);
    }

    @Override
    public String getMasterTable() {
        return "T_FA_FaMaintain";
    }

    @Override
    protected AbstractPrcFaManageStrategy getBillStrategy() {
        return new PrcFaMaintainStrategy();
    }

    private SelectorItemCollection getFullCurCardSelector() {
        SelectorItemCollection sic = PrcFaCoreManager.getCurCardSelectors();
        sic.add(new SelectorItemInfo("currency.precision"));
        return sic;
    }

    private SelectorItemCollection getUpdateStatusSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("assetValue"));
        sic.add(new SelectorItemInfo("neatAmt"));
        sic.add(new SelectorItemInfo("lastBillID"));
        sic.add(new SelectorItemInfo("neatValue"));
        sic.add(new SelectorItemInfo("originAmt"));
        return sic;
    }

    private SelectorItemCollection getUpdateMaintainEntrySelector() {
        SelectorItemCollection maintainEntrySic = new SelectorItemCollection();
        maintainEntrySic.add(new SelectorItemInfo("oneCost"));
        maintainEntrySic.add(new SelectorItemInfo("expenseApportionScale"));
        maintainEntrySic.add(new SelectorItemInfo("faChangeBill"));
        maintainEntrySic.add(new SelectorItemInfo("faAlterModel"));
        return maintainEntrySic;
    }

    private SelectorItemCollection getChangeBillSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("changeBillEntry.*"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.*"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.faBakCard.id"));
        return sic;
    }

    private SelectorItemCollection getUpdateFaMaintainSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("alreadyCapitalMeltAmout"));
        sic.add(new SelectorItemInfo("isCapitalOrExpense"));
        return sic;
    }

    @Override
    protected void _cancelCap(Context ctx, String faMaintainId) throws BOSException, EASBizException {
        IFaCurCard iCurCard = FaCurCardFactory.getLocalInstance(ctx);
        IFaBizCard iBizCard = FaBizCardFactory.getLocalInstance(ctx);
        IFaBakCard iBakCard = FaBakCardFactory.getLocalInstance(ctx);
        IFaMaintainEntry iMaintainEntry = FaMaintainEntryFactory.getLocalInstance(ctx);
        IFaChangeBill iChangeBill = FaChangeBillFactory.getLocalInstance(ctx);
        PrcFaChangeStrategy changeStrategy = new PrcFaChangeStrategy();
        SelectorItemCollection updateCardSic = this.getUpdateStatusSelector();
        SelectorItemCollection updateMaintainSic = this.getUpdateMaintainEntrySelector();
        SelectorItemCollection changeBillSic = this.getChangeBillSelector();
        SelectorItemCollection updateFaMaintainSic = this.getUpdateFaMaintainSelector();
        FaMaintainInfo info = FaMaintainFactory.getLocalInstance(ctx).getFaMaintainInfo((IObjectPK)new ObjectStringPK(faMaintainId));
        FaMaintainEntryCollection entryCollection = info.getMaintainEntry();
        Iterator entryIterator = entryCollection.iterator();
        while (entryIterator.hasNext()) {
            FaMaintainEntryInfo maintainEntryInfo = (FaMaintainEntryInfo)entryIterator.next();
            BOSUuid cardId = maintainEntryInfo.getFaCurCard().getId();
            info.setAlreadyCapitalMeltAmout(null);
            info.setIsCapitalOrExpense(this.isIsExpenses(info));
            if (maintainEntryInfo.getFaChangeBill() == null) continue;
            FaChangeBillInfo change = iChangeBill.getFaChangeBillInfo((IObjectPK)new ObjectUuidPK(maintainEntryInfo.getFaChangeBill().getId().toString()));
            if (change.isFiVouchered()) {
                throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"Not_Withdraw_The_Capital", (Locale)ctx.getOriginLocale())));
            }
            FaMaintainFactory.getLocalInstance(ctx).updatePartial(info, updateFaMaintainSic);
            if (maintainEntryInfo.getFaChangeBill() != null && maintainEntryInfo.getFaChangeBill().getId() != null) {
                BOSUuid changeBillId = maintainEntryInfo.getFaChangeBill().getId();
                maintainEntryInfo.setOneCost(null);
                maintainEntryInfo.setExpenseApportionScale(null);
                maintainEntryInfo.setFaAlterModel(null);
                maintainEntryInfo.setFaChangeBill(null);
                iMaintainEntry.updatePartial((CoreBaseInfo)maintainEntryInfo, updateMaintainSic);
                CoreBaseInfo changeBillInfo = iChangeBill.getValue((IObjectPK)new ObjectUuidPK(changeBillId), changeBillSic);
                changeStrategy.unAuditBill(ctx, (IObjectValue)changeBillInfo);
                changeStrategy.deleteBill(ctx, (IObjectPK)new ObjectUuidPK(changeBillId));
            }
            SelectorItemCollection sicOfBak = PrcFaCoreManager.getBakCardSelectors();
            sicOfBak.add(new SelectorItemInfo("faCurCard.id"));
            FaBizCardInfo bizCardInfo = iBizCard.getFaBizCardInfo((IObjectPK)new ObjectUuidPK(maintainEntryInfo.getFaBizCard().getId()));
            FaBakCardInfo bakCardInfo = iBakCard.getFaBakCardInfo((IObjectPK)new ObjectUuidPK(bizCardInfo.getFaBakCard().getId()), sicOfBak);
            bakCardInfo.setLastBillID(info.getId().toString());
            FaCurCardInfo curCardInfo = FaManageUtils.BakCard2CurCard(bakCardInfo);
            curCardInfo.setBizStatus(FaBizStatusEnum.HAVE_MAINTAINED);
            curCardInfo.setId(cardId);
            iCurCard.updatePartial((CoreBaseInfo)curCardInfo, updateCardSic);
        }
    }

    private BigDecimal changeBenbiToYuanbi(Context ctx, FaCurCardInfo cardInfo, BigDecimal benbi, FaMaintainInfo maintainInfo) throws BOSException, EASBizException {
        BigDecimal yuanbi = null;
        FaCurCardInfo curCardInfo = cardInfo;
        BigDecimal exRate = curCardInfo.getExRate();
        CurrencyInfo targetCyInfo = curCardInfo.getCurrency();
        CurrencyInfo srcCyInfo1 = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectStringPK(curCardInfo.getCurrency().getId().toString()));
        int scale = srcCyInfo1.getPrecision();
        CurrencyInfo srcCyInfo = this.getDesCyInfo(ctx);
        if (srcCyInfo != null && targetCyInfo != null && exRate != null) {
            if (srcCyInfo.getId().equals((Object)targetCyInfo.getId())) {
                return benbi;
            }
            if (benbi != null && exRate.compareTo(new BigDecimal("0")) != 0) {
                yuanbi = benbi.divide(exRate, scale, 4);
            }
        }
        return yuanbi == null ? new BigDecimal("0") : yuanbi;
    }

    public CurrencyInfo getDesCyInfo(Context ctx) throws EASBizException, BOSException {
        CurrencyInfo srcCyInfo = FaManageUtils.getBaseCurrency(ctx);
        return srcCyInfo;
    }

    @Override
    protected void _confirmCap(Context ctx, Map dataMap) throws BOSException, EASBizException {
        IFaBakCard iBakCard = FaBakCardFactory.getLocalInstance(ctx);
        IFaMaintain faMaintain = FaMaintainFactory.getLocalInstance(ctx);
        IFaBizCard iBizCard = FaBizCardFactory.getLocalInstance(ctx);
        SelectorItemCollection fullCurCardSic = this.getFullCurCardSelector();
        PrcFaChangeStrategy changeStrategy = new PrcFaChangeStrategy();
        FaMaintainEntryCollection maintainEntryCollection = (FaMaintainEntryCollection)((Object)dataMap.get("entryCollection"));
        Iterator maintainEntryIterator = maintainEntryCollection.iterator();
        while (maintainEntryIterator.hasNext()) {
            FaMaintainEntryInfo entryInfo = (FaMaintainEntryInfo)maintainEntryIterator.next();
            FaCurCardInfo curCard = entryInfo.getFaCurCard();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("lastBillID"));
            sic.add(new SelectorItemInfo("assetName"));
            sic.add(new SelectorItemInfo("number"));
            curCard = FaCurCardFactory.getLocalInstance(ctx).getFaCurCardInfo((IObjectPK)new ObjectUuidPK(curCard.getId()), sic);
            if (curCard.getLastBillID() == null || curCard.getLastBillID().equals(dataMap.get("id").toString())) continue;
            throw new FaCardException(FaCardException.CURCARD_HASOTHEROPRATION, new String[]{curCard.getNumber() + "(" + curCard.getAssetName() + ")", "", FaLocalUtils.getEntityAlias(ctx, BOSUuid.getBOSObjectType((String)curCard.getLastBillID(), (boolean)false))});
        }
        FaMaintainInfo faMaintainInfo = faMaintain.getFaMaintainInfo((IObjectPK)new ObjectStringPK(dataMap.get("id").toString()));
        faMaintainInfo.setIsCapitalOrExpense(true);
        faMaintainInfo.setAlreadyCapitalMeltAmout(new BigDecimal(dataMap.get("costCap").toString()));
        FaMaintainFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectStringPK(dataMap.get("id").toString()), (CoreBaseInfo)faMaintainInfo);
        String alterNumber = dataMap.get("alterNumber").toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)alterNumber));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        FaAlterModeInfo alterMode = null;
        FaAlterModeCollection alterCollection = FaAlterModeFactory.getLocalInstance((Context)ctx).getFaAlterModeCollection(view);
        if (alterCollection.size() > 0) {
            alterMode = alterCollection.get(0);
        }
        FaMaintainEntryCollection entryCollection = (FaMaintainEntryCollection)((Object)dataMap.get("entryCollection"));
        Iterator entryIterator = entryCollection.iterator();
        while (entryIterator.hasNext()) {
            FaMaintainEntryInfo entryInfo = (FaMaintainEntryInfo)entryIterator.next();
            String curCardId = entryInfo.getFaCurCard().getId().toString();
            String entryId = entryInfo.getId().toString();
            BigDecimal oneCost = new BigDecimal(dataMap.get(curCardId).toString());
            if (oneCost.compareTo(new BigDecimal("0")) == 0) continue;
            FaCurCardInfo curCardInfo = FaMaintainControllerBean.getFaCurdCardInstance(ctx).getFaCurCardInfo((IObjectPK)new ObjectStringPK(curCardId), fullCurCardSic);
            FaCurCardInfo bakCardInfo = (FaCurCardInfo)curCardInfo.clone();
            FaChangeBillInfo changeInfo = (FaChangeBillInfo)this.getChangeBillInfoTemplate(ctx, curCardInfo).clone();
            changeInfo.setSourceBillId(faMaintainInfo.getId().toString());
            PrcFaChangeStrategy.setBillInfoNumber(ctx, changeInfo, FaChangeBillFactory.getLocalInstance(ctx));
            changeInfo.setDescription(ResourceBase.getString((String)FAMAINTAINRESOURCE, (String)"maintain", (Locale)ctx.getOriginLocale()) + faMaintainInfo.getNumber() + ResourceBase.getString((String)FAMAINTAINRESOURCE, (String)"Cap_Made", (Locale)ctx.getOriginLocale()));
            changeInfo.setChangeMode(alterMode);
            FaBakCardInfo bakCard = FaManageUtils.CurCard2BakCard(bakCardInfo);
            bakCard.setFaCurCard(curCardInfo);
            bakCard.setBillType(FaBillTypeEnum.CHANGE);
            iBakCard.addnew((CoreBaseInfo)bakCard);
            FaBizCardInfo bizCard = FaManageUtils.CurCard2BizCard(curCardInfo);
            bizCard.setBillType(FaBillTypeEnum.CHANGE);
            bizCard.setFaBakCard(bakCard);
            BigDecimal yuanbi = this.changeBenbiToYuanbi(ctx, curCardInfo, oneCost, faMaintainInfo);
            bizCard.setAssetValue(curCardInfo.getAssetValue().add(oneCost));
            bizCard.setOriginAmt(curCardInfo.getOriginAmt().add(yuanbi));
            bizCard.setInitEvalValue(curCardInfo.getInitEvalValue().add(oneCost));
            bizCard.setNeatValue(bizCard.getAssetValue().subtract(bizCard.getAccuDepr()));
            bizCard.setNeatAmt(bizCard.getAssetValue().subtract(bizCard.getAccuDepr()).subtract(bizCard.getDecValue()));
            FaChangeBillEntryInfo changeEntryInfo = changeInfo.getChangeBillEntry().get(0);
            changeEntryInfo.setBizCard(bizCard);
            changeEntryInfo.setCurCard(curCardInfo);
            changeEntryInfo.setOriginChg(new BigDecimal("0"));
            changeEntryInfo.setAccuDeprChg(new BigDecimal("0"));
            changeEntryInfo.setOriginChg(oneCost);
            IFaChangeBill iChangeBill = FaChangeBillFactory.getLocalInstance(ctx);
            iChangeBill.addnew((CoreBaseInfo)changeInfo);
            changeStrategy.auditBill(ctx, (IObjectValue)changeInfo);
            BigDecimal expenseApportionScale = new BigDecimal(dataMap.get(curCardId.toString() + "1").toString());
            StringBuffer sql = new StringBuffer();
            sql.append("update t_fa_famaintainentry set fonecost=" + oneCost + ",fexpenseApportionScale=" + expenseApportionScale + ",ffaalterid='" + alterMode.getId().toString() + "',ffaChangeBillID='" + changeInfo.getId().toString() + "' where fid='" + entryId + "'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private FaChangeBillInfo getChangeBillInfoTemplate(Context ctx, FaCurCardInfo curCardInfo) throws EASBizException, BOSException {
        Date today = DateTimeUtils.truncateDate((Date)new Date());
        FaChangeBillInfo changeInfo = new FaChangeBillInfo();
        PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)curCardInfo.getCompany());
        changeInfo.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        changeInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
        changeInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        changeInfo.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        changeInfo.setFiVouchered(false);
        if (today.after(periodInfo.getEndDate())) {
            changeInfo.setChangeDate(periodInfo.getEndDate());
        } else if (today.before(periodInfo.getBeginDate())) {
            changeInfo.setChangeDate(periodInfo.getBeginDate());
        } else {
            changeInfo.setFiVouchered(false);
            changeInfo.setChangeDate(today);
        }
        changeInfo.setBillType(FaBillOriginEnum.FROM_CAP);
        changeInfo.setCompany(curCardInfo.getCompany());
        changeInfo.setBizDate(today);
        changeInfo.setHasEffected(true);
        changeInfo.setHandler(ContextUtil.getCurrentUserInfo((Context)ctx));
        changeInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        changeInfo.setLastUpdateTime(null);
        FaChangeBillEntryCollection changeEntries = new FaChangeBillEntryCollection();
        FaChangeBillEntryInfo changeEntryInfo = new FaChangeBillEntryInfo();
        changeEntries.add(changeEntryInfo);
        changeInfo.put("changeBillEntry", (Object)changeEntries);
        changeEntryInfo.setChangeBill(changeInfo);
        changeEntryInfo.setDecValueChg(new BigDecimal("0"));
        return changeInfo;
    }

    @Override
    protected boolean _isAudit(Context ctx, String faMaintainId) throws BOSException, EASBizException {
        FaMaintainInfo faMaintainInfo = FaMaintainFactory.getLocalInstance(ctx).getFaMaintainInfo((IObjectPK)new ObjectStringPK(faMaintainId));
        return faMaintainInfo.getCheckedStatus().getValue() == 2;
    }

    @Override
    protected void _feedbackExpenseAddAmount(Context ctx, FaMaintainExpenseCollection mtExpenseCollection, String mtID) throws BOSException, EASBizException {
        int n = mtExpenseCollection.size();
        for (int i = 0; i < n; ++i) {
            FaMaintainExpenseInfo info = mtExpenseCollection.get(i);
            FaMaintainInfo faMaintainInfo = this.getIFaMaintain(ctx).getFaMaintainInfo((IObjectPK)new ObjectUuidPK(mtID));
            faMaintainInfo.setIsCapitalOrExpense(true);
            faMaintainInfo.setAlreadyExpenseMeltAmout(info.getExpenseMeltAmount());
            faMaintainInfo.setExpense(info);
            FaMaintainFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(mtID), (CoreBaseInfo)faMaintainInfo);
        }
    }

    @Override
    protected void _feedbackExpenseRemoveAmount(Context ctx, String mtID) throws BOSException, EASBizException {
        FaMaintainInfo faMaintainInfo = this.getIFaMaintain(ctx).getFaMaintainInfo((IObjectPK)new ObjectUuidPK(mtID));
        if (this.isIsCapital(faMaintainInfo)) {
            faMaintainInfo.setIsCapitalOrExpense(true);
        } else {
            faMaintainInfo.setIsCapitalOrExpense(false);
        }
        faMaintainInfo.setAlreadyExpenseMeltAmout(null);
        faMaintainInfo.setExpense(null);
        FaMaintainFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(mtID), (CoreBaseInfo)faMaintainInfo);
    }

    protected IFaMaintain getIFaMaintain(Context ctx) throws BOSException {
        IFaMaintain iFaMaintain = FaMaintainFactory.getLocalInstance(ctx);
        return iFaMaintain;
    }

    protected boolean isIsExpenses(FaMaintainInfo faMaintainInfo) throws BOSException {
        BigDecimal Zero = new BigDecimal("0");
        return faMaintainInfo.getAlreadyExpenseMeltAmout() != null && faMaintainInfo.getAlreadyExpenseMeltAmout().compareTo(Zero) != 0;
    }

    protected boolean isIsCapital(FaMaintainInfo faMaintainInfo) throws BOSException {
        BigDecimal Zero = new BigDecimal("0");
        return faMaintainInfo.getAlreadyCapitalMeltAmout() != null && faMaintainInfo.getAlreadyCapitalMeltAmout().compareTo(Zero) != 0;
    }

    @Override
    protected IRowSet _getRowset(Context ctx, String id, String queryName) throws BOSException, EASBizException {
        IQueryExecutor queryExcu = null;
        MetaDataPK queryPK = null;
        queryPK = new MetaDataPK(queryName);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)id));
        viewInfo.setFilter(fi);
        viewInfo.getSorter().add(new SorterItemInfo("maintainEntry.seq"));
        queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        IRowSet rows = queryExcu.executeQuery();
        return rows;
    }

    @Override
    protected boolean _isAlreadyExpenseMeltAmout(Context ctx, String id) throws BOSException, EASBizException {
        BigDecimal Zero = new BigDecimal("0");
        FaMaintainInfo info = this.getIFaMaintain(ctx).getFaMaintainInfo((IObjectPK)new ObjectStringPK(id));
        return info.getAlreadyExpenseMeltAmout() != null && info.getAlreadyExpenseMeltAmout().compareTo(Zero) != 0;
    }

    public static int checkPeriod(Context ctx, CompanyOrgUnitInfo company) {
        int i = 0;
        PeriodInfo aPeriodInfo = null;
        try {
            aPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)(company == null ? SysContext.getSysContext().getCurrentFIUnit() : company));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (aPeriodInfo == null) {
            i = 5;
        }
        return i;
    }

    public static int checkComp(Context ctx, CompanyOrgUnitInfo aCompanyOrgUnitInfo) {
        int i = 0;
        if (aCompanyOrgUnitInfo != null) {
            if (aCompanyOrgUnitInfo.getInvalidDate() != null && DateTimeUtils.dayBefore((Date)aCompanyOrgUnitInfo.getInvalidDate(), (Date)new Date())) {
                i = 1;
                return i;
            }
            if (!aCompanyOrgUnitInfo.isIsBizUnit()) {
                i = 2;
                return i;
            }
        } else {
            i = 3;
            return i;
        }
        i = FaMaintainControllerBean.checkPeriod(ctx, aCompanyOrgUnitInfo);
        return i;
    }

    public static int checkFaInit(Context ctx, CompanyOrgUnitInfo aCompanyOrgUnitInfo) throws Exception {
        int i = 0;
        boolean isInitEnd = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
        if (!isInitEnd) {
            i = 4;
        }
        return i;
    }

    public static void checkAccountSwap(Context ctx, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        FaCardFactory.getLocalInstance(ctx).checkAccountSwap(company);
    }

    @Override
    protected int _checkOnload(Context ctx, IObjectValue company) {
        int i = FaMaintainControllerBean.checkComp(ctx, (CompanyOrgUnitInfo)company);
        if (i != 0) {
            return i;
        }
        try {
            i = FaMaintainControllerBean.checkFaInit(ctx, (CompanyOrgUnitInfo)company);
            if (i != 0) {
                return i;
            }
            FaMaintainControllerBean.checkAccountSwap(ctx, (CompanyOrgUnitInfo)company);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return 0;
    }

    @Override
    protected String _getMaintainBizType(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaMaintainInfo info = (FaMaintainInfo)model;
        String lastBillID = info.getId() == null ? null : info.getId().toString();
        String sql = "select famaintainbiztype from t_Fa_famaintain where fid='" + lastBillID + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        String maintainBizType = "";
        try {
            if (rs.next()) {
                maintainBizType = rs.getString("famaintainbiztype");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return maintainBizType;
    }

    @Override
    protected Person[] _getUserWorkFlow(Context ctx, String areaName) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("entry.user.name");
        view.getSelector().add("entry.user.number");
        view.getSelector().add("id");
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("name", (Object)areaName));
        view.setFilter(f);
        CoreBaseCollection cols = FaWorkAreaFactory.getLocalInstance(ctx).getCollection(view);
        PersonToWFAdapter adapter = new PersonToWFAdapter();
        ArrayList<Person> list = new ArrayList<Person>();
        for (int i = 0; cols != null && i < cols.size(); ++i) {
            FaWorkAreaInfo areaInfo = (FaWorkAreaInfo)cols.get(i);
            for (int j = 0; j < areaInfo.getEntry().size(); ++j) {
                PersonInfo user = areaInfo.getEntry().get(j).getUser();
                Person[] temp = adapter.getPersonByEmployeeId(ctx, user.getId().toString());
                for (int k = 0; temp != null && k < temp.length; ++k) {
                    if (temp[k].getUserId() == null) continue;
                    list.add(temp[k]);
                }
            }
        }
        Person[] persons = new Person[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            persons[i] = (Person)list.get(i);
        }
        return persons;
    }

    @Override
    protected void _showAppovingUI(Context ctx, String billID) throws EASBizException, BOSException {
        FaMaintainInfo info = this.getIFaMaintain(ctx).getFaMaintainInfo((IObjectPK)new ObjectStringPK(billID));
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = null;
        uiContext.put((Object)"InitDataObject", (Object)new FaApprovingInfo());
        uiContext.put((Object)"userObject", (Object)info);
        IUIFactory factory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        uiWindow = factory.create(FaApprovingEditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    @Override
    protected void checkBeforeSave(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaMaintainInfo maintain = (FaMaintainInfo)model;
        FaMaintainEntryCollection entryColl = maintain.getMaintainEntry();
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            FaCurCardInfo card = entryColl.get(i).getFaCurCard();
            if (card == null || card.getId() == null || card.getLastUpdateTime() == null) continue;
            FaBillBizProcessor.lockFaCurCard(ctx, card.getId().toString());
            FaBillBizProcessor.checkFaCurCardVersion(ctx, card.getId().toString(), card.getLastUpdateTime());
        }
    }

    @Override
    protected void checkBeforeSubmit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaMaintainInfo maintain = (FaMaintainInfo)model;
        FaMaintainEntryCollection entryColl = maintain.getMaintainEntry();
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            FaCurCardInfo card = entryColl.get(i).getFaCurCard();
            if (card == null || card.getId() == null || card.getLastUpdateTime() == null) continue;
            FaBillBizProcessor.lockFaCurCard(ctx, card.getId().toString());
            FaBillBizProcessor.checkFaCurCardVersion(ctx, card.getId().toString(), card.getLastUpdateTime());
        }
    }

    protected void invokeServiceBefore(ServiceContext svcCtx) throws BOSException {
        FaRPCMethodMappingUtils.invokeRPCMethodEventListener(svcCtx, FaAppLogForBusinessTypeEnum.FA_MAINTAIN, FaMethodCalcOrderEnum.BEFORE);
        super.invokeServiceBefore(svcCtx);
    }

    protected void invokeServiceAfter(ServiceContext svcCtx) throws BOSException {
        FaRPCMethodMappingUtils.invokeRPCMethodEventListener(svcCtx, FaAppLogForBusinessTypeEnum.FA_MAINTAIN, FaMethodCalcOrderEnum.AFTER);
        super.invokeServiceAfter(svcCtx);
    }
}

