/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.app.FaNRptCardCheckService;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSQLUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FaNRptBaseService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.manage.app.FaNRptBaseService");
    protected static final Map<String, FaNRptBaseService> cache = new HashMap<String, FaNRptBaseService>();
    protected String T_TMP_DataTable = null;
    protected Set<String> tmpTables = new HashSet<String>();
    protected boolean debug = false;
    protected List<String> sqls = null;
    protected int sqlCount = 100;
    protected long sqlTime = 0L;

    public static FaNRptBaseService getService(Context ctx, Map<String, Object> params) {
        if ("cardCheck".equals(params.get("rptType"))) {
            return new FaNRptCardCheckService();
        }
        return new FaNRptBaseService();
    }

    public static Map<String, Object> _query(Context ctx, Map<String, Object> params) throws BOSException, EASBizException {
        FaNRptBaseService service = FaNRptBaseService.getService(ctx, params);
        Map<String, Object> result = service.query(ctx, params);
        String queryId = BOSUuid.create((String)"ABCD1234").toString();
        result.put("queryId", queryId);
        cache.put(queryId, service);
        return result;
    }

    protected static List<List<Object>> _getData(Context ctx, String queryId, int fromIndex, int pageSize) throws BOSException, EASBizException {
        FaNRptBaseService service = cache.get(queryId);
        if (service != null) {
            return service.getData(ctx, fromIndex, pageSize);
        }
        return new ArrayList<List<Object>>();
    }

    protected static void _release(Context ctx, String queryId) throws BOSException, EASBizException {
        FaNRptBaseService service = cache.remove(queryId);
        if (service != null) {
            service.release(ctx);
        }
    }

    protected Map<String, Object> query(Context ctx, Map<String, Object> params) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            this.beforeQuery(ctx, params);
            this.buildData(ctx, params);
            result.put("colNames", this.getColNames(ctx, params));
            result.put("rowCount", this.getRowCount(ctx, params));
            int pageSize = 100;
            Object param = params.get("pageSize");
            if (param != null && param.toString().trim().length() > 0) {
                try {
                    int i = Integer.parseInt(param.toString().trim());
                    if (i > 0) {
                        pageSize = i;
                    }
                }
                catch (Exception i) {
                    // empty catch block
                }
            }
            List<List<Object>> rows = this.getData(ctx, 1, pageSize);
            result.put("rows", rows);
            if (this.sqls != null && this.sqls.size() > 0) {
                result.put("sqls", this.sqls);
            }
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        catch (Exception e) {
            logger.error((Object)"fa nrpt query error!", (Throwable)e);
            this.release(ctx);
            if (e instanceof EASBizException) {
                throw (EASBizException)((Object)e);
            }
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
            throw new BOSException((Throwable)e);
        }
        finally {
            this.afterQuery(ctx, params);
        }
    }

    protected void beforeQuery(Context ctx, Map<String, Object> params) throws Exception {
        Object param;
        for (String key : params.keySet()) {
            if (key == null || !key.toString().trim().equalsIgnoreCase("debug")) continue;
            param = params.get(key);
            if (param == null || !param.toString().trim().equalsIgnoreCase("true")) break;
            this.debug = true;
            break;
        }
        if (this.debug) {
            this.sqls = new ArrayList<String>();
            param = params.get("sqlCount");
            if (param != null && param.toString().trim().length() > 0) {
                try {
                    int count = Integer.parseInt(param.toString().trim());
                    if (count >= 0) {
                        this.sqlCount = count;
                    }
                }
                catch (Exception count) {
                    // empty catch block
                }
            }
            if ((param = params.get("sqlTime")) != null && param.toString().trim().length() > 0) {
                try {
                    long time = Long.parseLong(param.toString().trim());
                    if (time >= 0L) {
                        this.sqlTime = time;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected void afterQuery(Context ctx, Map<String, Object> params) {
        if (!this.debug) {
            for (String tmpTable : this.tmpTables) {
                try {
                    TempTablePool.getInstance((Context)ctx).releaseTable(tmpTable);
                }
                catch (Throwable throwable) {}
            }
            this.tmpTables.clear();
        }
    }

    protected void buildData(Context ctx, Map<String, Object> params) throws Exception {
    }

    protected List<String> getColNames(Context ctx, Map<String, Object> params) {
        return new ArrayList<String>();
    }

    protected int getRowCount(Context ctx, Map<String, Object> params) throws Exception {
        int rowCount = 0;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select count(*) FCount from " + this.T_TMP_DataTable));
        if (rs.next()) {
            rowCount = rs.getInt("FCount");
        }
        return rowCount;
    }

    protected List<List<Object>> getData(Context ctx, int fromIndex, int pageSize) throws BOSException, EASBizException {
        return new ArrayList<List<Object>>();
    }

    protected void release(Context ctx) throws BOSException, EASBizException {
        if (this.T_TMP_DataTable != null) {
            try {
                TempTablePool.getInstance((Context)ctx).releaseTable(this.T_TMP_DataTable);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.T_TMP_DataTable = null;
        for (String tmpTable : this.tmpTables) {
            try {
                TempTablePool.getInstance((Context)ctx).releaseTable(tmpTable);
            }
            catch (Throwable throwable) {}
        }
        this.tmpTables.clear();
    }

    protected String createTempTable(Context ctx, String createSQL) throws Exception {
        return this.createTempTable(ctx, createSQL, true);
    }

    protected String createTempTable(Context ctx, String createSQL, boolean release) throws Exception {
        long start = System.currentTimeMillis();
        String tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(createSQL);
        this.logSql(tempTable + ": " + createSQL, null, System.currentTimeMillis() - start);
        if (release) {
            this.tmpTables.add(tempTable);
        }
        return tempTable;
    }

    protected IRowSet executeQuery(Context ctx, String sql) throws BOSException {
        return this.executeQuery(ctx, sql, null);
    }

    protected IRowSet executeQuery(Context ctx, String sql, Object[] params) throws BOSException {
        long start = System.currentTimeMillis();
        IRowSet rs = params == null ? DbUtil.executeQuery((Context)ctx, (String)sql) : DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        this.logSql(sql, params, System.currentTimeMillis() - start);
        return rs;
    }

    protected void execute(Context ctx, String sql) throws BOSException {
        this.execute(ctx, sql, null);
    }

    protected void execute(Context ctx, String sql, Object[] params) throws BOSException {
        long start = System.currentTimeMillis();
        if (params == null) {
            DbUtil.execute((Context)ctx, (String)sql);
        } else {
            DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        }
        this.logSql(sql, params, System.currentTimeMillis() - start);
    }

    protected void logSql(String sql, Object[] params, long time) {
        if (this.debug && this.sqls.size() < this.sqlCount && (time == -1L || time >= this.sqlTime)) {
            this.sqls.add("sql time:" + time + "ms\n" + (params == null ? sql : GLRptSQLUtil.getSqlWithParameters((String)sql, (Object[])params)));
        }
    }
}

