/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaBillOriginEnum;
import com.kingdee.eas.fi.fa.manage.app.FaNRptBaseService;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FaNRptCardCheckService
extends FaNRptBaseService {
    protected String companyId = null;
    protected PeriodInfo startPeriod = null;
    protected PeriodInfo currentPeriod = null;
    protected PeriodCollection periods = null;
    protected String T_TMP_Accumulate = null;
    protected java.util.Date fiAccountDateFrom = null;
    protected java.util.Date fiAccountDateTo = null;
    protected java.util.Date accountDateFrom = null;
    protected java.util.Date accountDateTo = null;
    protected String numberFrom = null;
    protected String numberTo = null;
    protected String assetCatId = null;
    protected String originMethodId = null;
    protected String useStatusId = null;
    protected String storeCityId = null;
    protected boolean isCardFilter = false;
    protected int checkHisCount = 1;
    protected PeriodInfo beginPeriod = null;
    protected boolean isCheckMonRep = false;
    protected boolean isCheckBalRep = false;

    @Override
    protected void beforeQuery(Context ctx, Map<String, Object> params) throws Exception {
        super.beforeQuery(ctx, params);
        SimpleDateFormat DF = new SimpleDateFormat("yyyy-MM-dd");
        Object param = params.get("fiAccountDateFrom");
        if (param != null && param.toString().trim().length() > 0) {
            try {
                this.fiAccountDateFrom = DF.parse(((String)param).trim());
                this.isCardFilter = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((param = params.get("fiAccountDateTo")) != null && param.toString().trim().length() > 0) {
            try {
                this.fiAccountDateTo = DF.parse(((String)param).trim());
                this.isCardFilter = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((param = params.get("accountDateFrom")) != null && param.toString().trim().length() > 0) {
            try {
                this.accountDateFrom = DF.parse(((String)param).trim());
                this.isCardFilter = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((param = params.get("accountDateTo")) != null && param.toString().trim().length() > 0) {
            try {
                this.accountDateTo = DF.parse(((String)param).trim());
                this.isCardFilter = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((param = params.get("numberFrom")) != null && param.toString().trim().length() > 0) {
            this.numberFrom = param.toString().trim();
            this.isCardFilter = true;
        }
        if ((param = params.get("numberTo")) != null && param.toString().trim().length() > 0) {
            this.numberTo = param.toString().trim();
            this.isCardFilter = true;
        }
        if ((param = params.get("assetCatId")) != null && param.toString().trim().length() > 0) {
            this.assetCatId = param.toString().trim();
            this.isCardFilter = true;
        }
        if ((param = params.get("originMethodId")) != null && param.toString().trim().length() > 0) {
            this.originMethodId = param.toString().trim();
            this.isCardFilter = true;
        }
        if ((param = params.get("useStatusId")) != null && param.toString().trim().length() > 0) {
            this.useStatusId = param.toString().trim();
            this.isCardFilter = true;
        }
        if ((param = params.get("storeCityId")) != null && param.toString().trim().length() > 0) {
            this.storeCityId = param.toString().trim();
            this.isCardFilter = true;
        }
        if ((param = params.get("checkHisCount")) != null && param.toString().trim().length() > 0) {
            try {
                int i = Integer.parseInt(param.toString().trim());
                if (i >= 0 && i <= 260) {
                    this.checkHisCount = i;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.isCheckMonRep = Boolean.valueOf((String)params.get("isCheckMonRep"));
        this.isCheckBalRep = Boolean.valueOf((String)params.get("isCheckBalRep"));
    }

    @Override
    protected void afterQuery(Context ctx, Map<String, Object> params) {
        super.afterQuery(ctx, params);
        this.clearProperties();
    }

    protected void clearProperties() {
        this.companyId = null;
        this.startPeriod = null;
        this.currentPeriod = null;
        this.periods = null;
        this.T_TMP_Accumulate = null;
        this.fiAccountDateFrom = null;
        this.fiAccountDateTo = null;
        this.accountDateFrom = null;
        this.accountDateTo = null;
        this.numberFrom = null;
        this.numberTo = null;
        this.assetCatId = null;
        this.originMethodId = null;
        this.useStatusId = null;
        this.storeCityId = null;
        this.isCardFilter = false;
        this.checkHisCount = 1;
        this.beginPeriod = null;
        this.isCheckMonRep = false;
        this.isCheckBalRep = false;
    }

    @Override
    protected void buildData(Context ctx, Map<String, Object> params) throws Exception {
        this.companyId = (String)params.get("companyId");
        this.T_TMP_DataTable = this.createDataTable(ctx, false, true);
        this.startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (IObjectPK)new ObjectUuidPK(this.companyId));
        this.currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (IObjectPK)new ObjectUuidPK(this.companyId));
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("periodYear");
        selector.add("periodNumber");
        selector.add("periodType.id");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)this.currentPeriod.getPeriodType().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)this.startPeriod.getNumber(), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)this.currentPeriod.getNumber(), CompareType.LESS_EQUALS));
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("number"));
        view.setSorter(sorter);
        this.periods = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(view);
        if (this.checkHisCount > 0 && this.periods.size() > 2 && this.checkHisCount <= this.periods.size() - 2) {
            this.beginPeriod = this.periods.get(this.periods.size() - 1 - this.checkHisCount);
        }
        this.checkChangeBill(ctx, params);
        this.checkCurCard(ctx, params);
        this.checkMonCard(ctx, params);
        this.checkBalance(ctx, params);
        this.buildPage(ctx, params);
    }

    protected void checkChangeBill(Context ctx, Map<String, Object> params) throws Exception {
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> ps = new ArrayList<Object>();
        sql.append("insert into " + this.T_TMP_DataTable + " ( \n");
        sql.append("    FCurCardID, \n");
        sql.append("    FPeriod, \n");
        sql.append("    FBizDate, \n");
        sql.append("    FBizNumber, \n");
        sql.append("    FType, \n");
        sql.append("    FOperate, \n");
        sql.append("    FError \n");
        sql.append(") \n");
        sql.append("select \n");
        sql.append("    ce.FCurCardID, \n");
        sql.append("    p.FNumber, \n");
        sql.append("    c.FBizDate, \n");
        sql.append("    c.FNumber, \n");
        sql.append("    1,  \n");
        sql.append("    c.FBillType, \n");
        sql.append("    case \n");
        sql.append("        when biz.FID is null then 1 \n");
        sql.append("        when bak.FID is null then 2 \n");
        sql.append("        when ce.TOriginChg <> (isnull(biz.FAssetValue, 0) - isnull(bak.FAssetValue, 0)) then 3 \n");
        sql.append("        when ce.TAccuDeprChg <> (isnull(biz.FAccuDepr, 0) - isnull(bak.FAccuDepr, 0)) then 4 \n");
        sql.append("        when ce.TDecValueChg <> (isnull(biz.FDecValue, 0) - isnull(bak.FDecValue, 0)) then 5 \n");
        sql.append("        else 0 \n");
        sql.append("    end FError \n");
        sql.append("from T_FA_FaChangeBill c \n");
        sql.append("join T_BD_Period p on p.FID = c.FPeriodID \n");
        sql.append("join T_FA_FaChangeBillEntry ce on ce.FChangeBillID = c.FID \n");
        sql.append("left join T_FA_FaBizCard biz on biz.FID = ce.FBizCardID \n");
        sql.append("left join T_FA_FaBakCard bak on biz.FFaBakCardID = bak.FID \n");
        if (this.isCardFilter) {
            sql.append("join T_FA_FaCurCard cur on cur.FID = ce.FCurCardID \n");
        }
        sql.append("where c.FCompanyID = ? \n");
        ps.add(this.companyId);
        sql.append("and c.FCheckedStatus = 2 \n");
        if (this.beginPeriod != null) {
            sql.append("and p.FNumber >= ? \n");
            ps.add(this.beginPeriod.getNumber());
        }
        this.appendCardFilter(sql, ps, true);
        sql.append("and ( \n");
        sql.append("    biz.FID is null \n");
        sql.append("    or bak.FID is null \n");
        sql.append("    or ce.TOriginChg <> (isnull(biz.FAssetValue, 0) - isnull(bak.FAssetValue, 0)) \n");
        sql.append("    or ce.TAccuDeprChg <> (isnull(biz.FAccuDepr, 0) - isnull(bak.FAccuDepr, 0)) \n");
        sql.append("    or ce.TDecValueChg <> (isnull(biz.FDecValue, 0) - isnull(bak.FDecValue, 0)) \n");
        sql.append(") \n");
        this.execute(ctx, sql.toString(), ps.toArray());
    }

    protected void appendCardFilter(StringBuffer sql, List<Object> ps, boolean addCompany) {
        if (this.isCardFilter && addCompany) {
            sql.append("and cur.FCompanyID = ? \n");
            ps.add(this.companyId);
        }
        if (this.fiAccountDateFrom != null) {
            sql.append("and cur.FFiAccountDate >= ? \n");
            ps.add(new Date(this.fiAccountDateFrom.getTime()));
        }
        if (this.fiAccountDateTo != null) {
            sql.append("and cur.FFiAccountDate <= ? \n");
            ps.add(new Date(this.fiAccountDateTo.getTime()));
        }
        if (this.accountDateFrom != null) {
            sql.append("and cur.FAccountDate >= ? \n");
            ps.add(new Date(this.accountDateFrom.getTime()));
        }
        if (this.accountDateTo != null) {
            sql.append("and cur.FAccountDate <= ? \n");
            ps.add(new Date(this.accountDateTo.getTime()));
        }
        if (this.numberFrom != null) {
            sql.append("and cur.FNumber >= ? \n");
            ps.add(this.numberFrom);
        }
        if (this.numberTo != null) {
            sql.append("and cur.FNumber <= ? \n");
            ps.add(this.numberTo);
        }
        if (this.assetCatId != null) {
            sql.append("and cur.FAssetCatID = ? \n");
            ps.add(this.assetCatId);
        }
        if (this.originMethodId != null) {
            sql.append("and cur.FOriginMethodID = ? \n");
            ps.add(this.originMethodId);
        }
        if (this.useStatusId != null) {
            sql.append("and cur.FUseStatusID = ? \n");
            ps.add(this.useStatusId);
        }
        if (this.storeCityId != null) {
            sql.append("and cur.FStoreCityID = ? \n");
            ps.add(this.storeCityId);
        }
    }

    protected void checkCurCard(Context ctx, Map<String, Object> params) throws Exception {
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> ps = new ArrayList<Object>();
        sql.append("create table T_TMP_Accumulate ( \n");
        sql.append("  FCurCardID VARCHAR(44), \n");
        sql.append("  FPeriodID VARCHAR(44), \n");
        sql.append("  FType int DEFAULT 0, \n");
        sql.append("  FDeprTermCount int DEFAULT 0, \n");
        sql.append("  FAssetValue NUMERIC(21,8) DEFAULT 0, \n");
        sql.append("  FAccuDepr NUMERIC(21,8) DEFAULT 0, \n");
        sql.append("  FAccuDeprtYear NUMERIC(21,8) DEFAULT 0, \n");
        sql.append("  FNeatValue NUMERIC(21,8) DEFAULT 0, \n");
        sql.append("  FDecValue NUMERIC(21,8) DEFAULT 0, \n");
        sql.append("  FNeatAmt NUMERIC(21,8) DEFAULT 0 \n");
        sql.append(") \n");
        this.T_TMP_Accumulate = this.createTempTable(ctx, sql.toString());
        sql.setLength(0);
        ps.clear();
        sql.append("insert into " + this.T_TMP_Accumulate + " ( \n");
        sql.append("    FCurCardID, FPeriodID, FType, FDeprTermCount, \n");
        sql.append("    FAssetValue, FAccuDepr, FAccuDeprtYear, \n");
        sql.append("    FNeatValue, FDecValue, FNeatAmt \n");
        sql.append(") \n");
        sql.append("select \n");
        sql.append("    mon.FFaCurCardID FCurCardID, \n");
        sql.append("    ?, \n");
        ps.add(this.startPeriod.getId().toString());
        sql.append("    1, \n");
        sql.append("    mon.FDeprTermCount, \n");
        sql.append("    mon.FAssetValue, \n");
        sql.append("    mon.FAccuDepr, \n");
        sql.append("    mon.FAccuDeprtYear, \n");
        sql.append("    mon.FNeatValue, \n");
        sql.append("    mon.FDecValue, \n");
        sql.append("    mon.FNeatAmt \n");
        sql.append("from T_FA_FaMonCard mon \n");
        if (this.isCardFilter) {
            sql.append("join T_FA_FaCurCard cur on cur.FID = mon.FFaCurCardID \n");
        }
        sql.append("where mon.FCompanyID = ? \n");
        sql.append("and mon.ForiginFlag = 0 \n");
        sql.append("and mon.FFaPeriodID is null \n");
        ps.add(this.companyId);
        this.appendCardFilter(sql, ps, true);
        this.execute(ctx, sql.toString(), ps.toArray());
        sql.setLength(0);
        ps.clear();
        sql.append("insert into " + this.T_TMP_Accumulate + " ( \n");
        sql.append("    FCurCardID, FPeriodID, FType, FDeprTermCount, \n");
        sql.append("    FAssetValue, FAccuDepr, FAccuDeprtYear, \n");
        sql.append("    FNeatValue, FDecValue, FNeatAmt \n");
        sql.append(") \n");
        sql.append("select \n");
        sql.append("    bak.FFaCurCardID FCurCardID, \n");
        sql.append("    p.FID, \n");
        sql.append("    2, \n");
        sql.append("    bak.FDeprTermCount, \n");
        sql.append("    bak.FAssetValue, \n");
        sql.append("    bak.FAccuDepr, \n");
        sql.append("    bak.FAccuDeprtYear, \n");
        sql.append("    bak.FNeatValue, \n");
        sql.append("    bak.FDecValue, \n");
        sql.append("    bak.FNeatAmt \n");
        sql.append("from T_FA_FaBakCard bak \n");
        sql.append("join T_BD_Period p on p.FID = bak.FPeriodID \n");
        if (this.isCardFilter) {
            sql.append("join T_FA_FaCurCard cur on cur.FID = bak.FFaCurCardID \n");
        }
        sql.append("where bak.FCompanyID = ? \n");
        sql.append("and bak.FBILLTYPE = 1 \n");
        sql.append("and bak.FCheckedStatus = 2 \n");
        ps.add(this.companyId);
        sql.append("and p.FNumber <= ? \n");
        ps.add(this.currentPeriod.getNumber());
        this.appendCardFilter(sql, ps, true);
        this.execute(ctx, sql.toString(), ps.toArray());
        sql.setLength(0);
        ps.clear();
        sql.append("insert into " + this.T_TMP_Accumulate + " ( \n");
        sql.append("    FCurCardID, FPeriodID, FType, FDeprTermCount, \n");
        sql.append("    FAssetValue, FAccuDepr, FAccuDeprtYear, \n");
        sql.append("    FNeatValue, FDecValue, FNeatAmt \n");
        sql.append(") \n");
        sql.append("select \n");
        sql.append("    ce.FCurCardID, \n");
        sql.append("    p.FID, \n");
        sql.append("    3, \n");
        sql.append("    0 FDeprTermCount, \n");
        sql.append("    ce.TOriginChg FAssetValue, \n");
        sql.append("    ce.TAccuDeprChg FAccuDepr, \n");
        sql.append("    (isnull(biz.FAccuDeprtYear, 0) - isnull(bak.FAccuDeprtYear, 0)) FAccuDeprtYear, \n");
        sql.append("    ce.TOriginChg - ce.TAccuDeprChg FNeatValue, \n");
        sql.append("    ce.TDecValueChg FDecValue, \n");
        sql.append("    ce.TOriginChg - ce.TAccuDeprChg - ce.TDecValueChg FNeatAmt \n");
        sql.append("from T_FA_FaChangeBill c \n");
        sql.append("join T_BD_Period p on p.FID = c.FPeriodID \n");
        sql.append("join T_FA_FaChangeBillEntry ce on ce.FChangeBillID = c.FID \n");
        sql.append("left join T_FA_FaBizCard biz on biz.FID = ce.FBizCardID \n");
        sql.append("left join T_FA_FaBakCard bak on biz.FFaBakCardID = bak.FID \n");
        if (this.isCardFilter) {
            sql.append("join T_FA_FaCurCard cur on cur.FID = ce.FCurCardID \n");
        }
        sql.append("where c.FCompanyID = ? \n");
        ps.add(this.companyId);
        sql.append("and c.FCheckedStatus = 2 \n");
        sql.append("and p.FNumber <= ? \n");
        ps.add(this.currentPeriod.getNumber());
        if (this.beginPeriod != null) {
            sql.append("and p.FNumber >= ? \n");
            ps.add(this.beginPeriod.getNumber());
        }
        this.appendCardFilter(sql, ps, true);
        this.execute(ctx, sql.toString(), ps.toArray());
        sql.setLength(0);
        ps.clear();
        sql.append("insert into " + this.T_TMP_Accumulate + " ( \n");
        sql.append("    FCurCardID, FPeriodID, FType, FDeprTermCount, \n");
        sql.append("    FAssetValue, FAccuDepr, FAccuDeprtYear, \n");
        sql.append("    FNeatValue, FDecValue, FNeatAmt \n");
        sql.append(") \n");
        sql.append("select \n");
        sql.append("    de.FFaCurCardID FCurCardID, \n");
        sql.append("    p.FID, \n");
        sql.append("    4, \n");
        sql.append("    1 FDeprTermCount, \n");
        sql.append("    0, \n");
        sql.append("    FDepreciation FAccuDepr, \n");
        sql.append("    FDepreciation FAccuDeprtYear, \n");
        sql.append("    0 - FDepreciation FNeatValue, \n");
        sql.append("    0 FDecValue, \n");
        sql.append("    0 - FDepreciation FNeatAmt \n");
        sql.append("FROM t_fa_FaDepreciation d \n");
        sql.append("join T_BD_Period p on p.FID = d.FPeriod \n");
        sql.append("join t_fa_FaDepreciationEntry de on de.FLnkFaDepreEntry = d.fid \n");
        if (this.isCardFilter) {
            sql.append("join T_FA_FaCurCard cur on cur.FID = de.FFaCurCardID \n");
        }
        sql.append("where d.FCompanyID = ? \n");
        ps.add(this.companyId);
        sql.append("and de.FState = 3 \n");
        sql.append("and p.FNumber <= ? \n");
        ps.add(this.currentPeriod.getNumber());
        if (this.beginPeriod != null) {
            sql.append("and p.FNumber >= ? \n");
            ps.add(this.beginPeriod.getNumber());
        }
        this.appendCardFilter(sql, ps, true);
        this.execute(ctx, sql.toString(), ps.toArray());
        sql.setLength(0);
        ps.clear();
        sql.append("insert into " + this.T_TMP_Accumulate + " ( \n");
        sql.append("    FCurCardID, FPeriodID, FType, FDeprTermCount, \n");
        sql.append("    FAssetValue, FAccuDepr, FAccuDeprtYear, \n");
        sql.append("    FNeatValue, FDecValue, FNeatAmt \n");
        sql.append(") \n");
        sql.append("select \n");
        sql.append("    bak.FFaCurCardID FCurCardID, \n");
        sql.append("    p.FID, \n");
        sql.append("    5, \n");
        sql.append("    0 FDeprTermCount, \n");
        sql.append("    0 - ce.FClrOriginal FAssetValue, \n");
        sql.append("    0 - ce.FClrAddupDep FAccuDepr, \n");
        sql.append("    ((bak.FAccuDepr - biz.FAccuDepr) - ce.FClrAddupDep) - (bak.FAccuDeprtYear - biz.FAccuDeprtYear) FClrAddupDepYear, \n");
        sql.append("    0 - ce.FClrOriginal + ce.FClrAddupDep FNeatValue, \n");
        sql.append("    0 - ce.FClrDecPrep FDecValue, \n");
        sql.append("    0 - ce.FClrOriginal + ce.FClrAddupDep - ce.FClrDecPrep FNeatAmt \n");
        sql.append("from T_FA_ClearBill c \n");
        sql.append("join T_BD_Period p on p.FID = c.FPeriodID \n");
        sql.append("join T_FA_ClearBillEntry ce on ce.FEntryID = c.FID \n");
        sql.append("join T_FA_FaBizCard biz on biz.FID = ce.FBIZCARDID \n");
        sql.append("join T_FA_FaBakCard bak on biz.FFaBakCardID = bak.FID \n");
        if (this.isCardFilter) {
            sql.append("join T_FA_FaCurCard cur on cur.FID = ce.FCurCardID \n");
        }
        sql.append("where c.FCompanyID = ? \n");
        ps.add(this.companyId);
        sql.append("and c.FCheckedStatus = 2 \n");
        sql.append("and (bak.FBillType = 3) \n");
        sql.append("and p.FNumber <= ? \n");
        ps.add(this.currentPeriod.getNumber());
        if (this.beginPeriod != null) {
            sql.append("and p.FNumber >= ? \n");
            ps.add(this.beginPeriod.getNumber());
        }
        this.appendCardFilter(sql, ps, true);
        this.execute(ctx, sql.toString(), ps.toArray());
        if (this.beginPeriod != null) {
            TempTablePool.getInstance((Context)ctx).createIndex(this.T_TMP_Accumulate, "FCurCardID, FPeriodID", false, false);
            TempTablePool.getInstance((Context)ctx).createIndex(this.T_TMP_Accumulate, "FPeriodID, FCurCardID", false, false);
            PeriodInfo prePeriod = null;
            if (this.periods.size() > 1) {
                prePeriod = this.periods.get(this.periods.size() - 2);
            }
            sql.setLength(0);
            ps.clear();
            sql.append("insert into " + this.T_TMP_DataTable + " ( \n");
            sql.append("    FCurCardID, \n");
            sql.append("    FPeriod, \n");
            sql.append("    FType, \n");
            sql.append("    FOperate, \n");
            sql.append("    FError \n");
            sql.append(") \n");
            sql.append("select \n");
            sql.append("    FCurCardID, \n");
            sql.append("    ?, \n");
            ps.add(this.currentPeriod.getNumber());
            sql.append("    3, \n");
            sql.append("    1, \n");
            sql.append("    case \n");
            sql.append("        when sum(FDeprTermCount) <> 0 then 1 \n");
            sql.append("        when sum(FAssetValue) <> 0 then 2 \n");
            sql.append("        when sum(FAccuDepr) <> 0 then 3 \n");
            sql.append("        when sum(FAccuDeprtYear) <> 0 then 4 \n");
            sql.append("        when sum(FNeatValue) <> 0 then 5 \n");
            sql.append("        when sum(FDecValue) <> 0 then 6 \n");
            sql.append("        when sum(FNeatAmt) <> 0 then 7 \n");
            sql.append("        else 0 \n");
            sql.append("    end FError \n");
            sql.append("from ( \n");
            if (prePeriod != null) {
                sql.append("select \n");
                sql.append("    mon.FFaCurCardID FCurCardID, \n");
                sql.append("    mon.FDeprTermCount, \n");
                sql.append("    mon.FAssetValue, \n");
                sql.append("    mon.FAccuDepr, \n");
                if (prePeriod.getPeriodYear() == this.currentPeriod.getPeriodYear()) {
                    sql.append("    mon.FAccuDeprtYear, \n");
                } else {
                    sql.append("    0, \n");
                }
                sql.append("    mon.FNeatValue, \n");
                sql.append("    mon.FDecValue, \n");
                sql.append("    mon.FNeatAmt \n");
                sql.append("from T_FA_FaMonCard mon \n");
                if (this.isCardFilter) {
                    sql.append("join T_FA_FaCurCard cur on cur.FID = mon.FFaCurCardID \n");
                }
                sql.append("where mon.FCompanyID = ? \n");
                ps.add(this.companyId);
                sql.append("and mon.FFaPeriodID = ? \n");
                ps.add(prePeriod.getId().toString());
                this.appendCardFilter(sql, ps, true);
                sql.append("union all \n");
            }
            sql.append("select \n");
            sql.append("    FCurCardID, \n");
            sql.append("    FDeprTermCount, \n");
            sql.append("    FAssetValue, \n");
            sql.append("    FAccuDepr, \n");
            sql.append("    FAccuDeprtYear, \n");
            sql.append("    FNeatValue, \n");
            sql.append("    FDecValue, \n");
            sql.append("    FNeatAmt \n");
            sql.append("from " + this.T_TMP_Accumulate + " b \n");
            sql.append("where FPeriodID = ? \n");
            ps.add(this.currentPeriod.getId().toString());
            sql.append("union all \n");
            sql.append("select \n");
            sql.append("    cur.FID FCurCardID, \n");
            sql.append("    0 - cur.FDeprTermCount FDeprTermCount, \n");
            sql.append("    0 - cur.FAssetValue FAssetValue, \n");
            sql.append("    0 - cur.FAccuDepr FAccuDepr, \n");
            sql.append("    0 - cur.FAccuDeprtYear FAccuDeprtYear, \n");
            sql.append("    0 - cur.FNeatValue FNeatValue, \n");
            sql.append("    0 - cur.FDecValue FDecValue, \n");
            sql.append("    0 - cur.FNeatAmt FNeatAmt \n");
            sql.append("from T_FA_FaCurCard cur \n");
            sql.append("left join T_FA_FaBakCard bak \n");
            sql.append("    on bak.FFaCurCardID = cur.FID and bak.FBILLTYPE = 1 and bak.FCheckedStatus = 2 \n");
            sql.append("left join T_BD_Period p on p.FID = bak.FPeriodID \n");
            sql.append("where cur.FCompanyID = ? \n");
            ps.add(this.companyId);
            sql.append("and cur.FCheckedStatus = 2 \n");
            sql.append("and (p.FID is null or p.FNumber <= ?) \n");
            ps.add(this.currentPeriod.getNumber());
            this.appendCardFilter(sql, ps, false);
            sql.append(") \n");
            sql.append("group by FCurCardID \n");
            sql.append("having ( \n");
            sql.append("    sum(FDeprTermCount) <> 0 \n");
            sql.append("    or sum(FAssetValue) <> 0 \n");
            sql.append("    or sum(FAccuDepr) <> 0 \n");
            sql.append("    or sum(FAccuDeprtYear) <> 0 \n");
            sql.append("    or sum(FNeatValue) <> 0 \n");
            sql.append("    or sum(FDecValue) <> 0 \n");
            sql.append("    or sum(FNeatAmt) <> 0 \n");
            sql.append(") \n");
            this.execute(ctx, sql.toString(), ps.toArray());
            return;
        }
        sql.setLength(0);
        ps.clear();
        sql.append("insert into " + this.T_TMP_Accumulate + " ( \n");
        sql.append("    FCurCardID, FPeriodID, FType, FDeprTermCount, \n");
        sql.append("    FAssetValue, FAccuDepr, FAccuDeprtYear, \n");
        sql.append("    FNeatValue, FDecValue, FNeatAmt \n");
        sql.append(") \n");
        sql.append("select \n");
        sql.append("    cur.FID FCurCardID, \n");
        sql.append("    ?, \n");
        ps.add(this.currentPeriod.getId().toString());
        sql.append("    6, \n");
        sql.append("    0 - cur.FDeprTermCount FDeprTermCount, \n");
        sql.append("    0 - cur.FAssetValue FAssetValue, \n");
        sql.append("    0 - cur.FAccuDepr FAccuDepr, \n");
        sql.append("    0 - cur.FAccuDeprtYear FAccuDeprtYear, \n");
        sql.append("    0 - cur.FNeatValue FNeatValue, \n");
        sql.append("    0 - cur.FDecValue FDecValue, \n");
        sql.append("    0 - cur.FNeatAmt FNeatAmt \n");
        sql.append("from T_FA_FaCurCard cur \n");
        sql.append("left join T_FA_FaBakCard bak \n");
        sql.append("    on bak.FFaCurCardID = cur.FID and bak.FBILLTYPE = 1 and bak.FCheckedStatus = 2 \n");
        sql.append("left join T_BD_Period p on p.FID = bak.FPeriodID \n");
        sql.append("where cur.FCompanyID = ? \n");
        ps.add(this.companyId);
        sql.append("and cur.FCheckedStatus = 2 \n");
        sql.append("and (p.FID is null or p.FNumber <= ?) \n");
        ps.add(this.currentPeriod.getNumber());
        this.appendCardFilter(sql, ps, false);
        this.execute(ctx, sql.toString(), ps.toArray());
        TempTablePool.getInstance((Context)ctx).createIndex(this.T_TMP_Accumulate, "FCurCardID, FPeriodID", false, false);
        TempTablePool.getInstance((Context)ctx).createIndex(this.T_TMP_Accumulate, "FPeriodID, FCurCardID", false, false);
        sql.setLength(0);
        ps.clear();
        sql.append("insert into " + this.T_TMP_DataTable + " ( \n");
        sql.append("    FCurCardID, \n");
        sql.append("    FPeriod, \n");
        sql.append("    FType, \n");
        sql.append("    FOperate, \n");
        sql.append("    FError \n");
        sql.append(") \n");
        sql.append("select \n");
        sql.append("    t.FCurCardID, \n");
        sql.append("    ?, \n");
        sql.append("    3, \n");
        sql.append("    1, \n");
        sql.append("    case \n");
        sql.append("        when sum(t.FDeprTermCount) <> 0 then 1 \n");
        sql.append("        when sum(t.FAssetValue) <> 0 then 2 \n");
        sql.append("        when sum(t.FAccuDepr) <> 0 then 3 \n");
        sql.append("        when sum(case when p.FPeriodYear = ? then t.FAccuDeprtYear else 0 end) <> 0 then 4 \n");
        sql.append("        when sum(t.FNeatValue) <> 0 then 5 \n");
        sql.append("        when sum(t.FDecValue) <> 0 then 6 \n");
        sql.append("        when sum(t.FNeatAmt) <> 0 then 7 \n");
        sql.append("        else 0 \n");
        sql.append("    end FError \n");
        sql.append("from " + this.T_TMP_Accumulate + " t \n");
        sql.append("join T_FA_FaCurCard cur on cur.FID = t.FCurCardID \n");
        sql.append("join T_BD_Period p on p.FID = t.FPeriodID \n");
        sql.append("where cur.FDeletedStatus <> 2 \n");
        sql.append("group by t.FCurCardID \n");
        sql.append("having ( \n");
        sql.append("    sum(t.FDeprTermCount) <> 0 \n");
        sql.append("    or sum(t.FAssetValue) <> 0 \n");
        sql.append("    or sum(t.FAccuDepr) <> 0 \n");
        sql.append("    or sum(case when p.FPeriodYear = ? then t.FAccuDeprtYear else 0 end) <> 0 \n");
        sql.append("    or sum(t.FNeatValue) <> 0 \n");
        sql.append("    or sum(t.FDecValue) <> 0 \n");
        sql.append("    or sum(t.FNeatAmt) <> 0 \n");
        sql.append(") \n");
        ps.add(this.currentPeriod.getNumber());
        ps.add(this.currentPeriod.getPeriodYear());
        ps.add(this.currentPeriod.getPeriodYear());
        this.execute(ctx, sql.toString(), ps.toArray());
    }

    protected void checkMonCard(Context ctx, Map<String, Object> params) throws Exception {
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> ps = new ArrayList<Object>();
        sql.append("insert into " + this.T_TMP_DataTable + " ( \n");
        sql.append("    FCurCardID, \n");
        sql.append("    FPeriod, \n");
        sql.append("    FType, \n");
        sql.append("    FOperate, \n");
        sql.append("    FError \n");
        sql.append(") \n");
        sql.append("select \n");
        sql.append("    imon.FFaCurCardID, \n");
        sql.append("    mp.FNumber, \n");
        sql.append("    80, \n");
        sql.append("    1, \n");
        sql.append("    1 \n");
        sql.append("from T_FA_FaMonCard imon \n");
        sql.append("join T_BD_Period mp on mp.FTypeID = ? \n");
        sql.append("left join T_FA_FaMonCard mon on mon.FFaCurCardID = imon.FFaCurCardID and mon.FFaPeriodID = mp.FID \n");
        if (this.isCardFilter) {
            sql.append("join T_FA_FaCurCard cur on cur.FID = imon.FFaCurCardID \n");
        }
        sql.append("where imon.FCompanyID = ? \n");
        sql.append("and imon.ForiginFlag = 0 \n");
        sql.append("and imon.FFaPeriodID is null \n");
        sql.append("and mp.FNumber >= ? \n");
        sql.append("and mp.FNumber < ? \n");
        sql.append("and mon.FID is null \n");
        ps.add(this.currentPeriod.getPeriodType().getId().toString());
        ps.add(this.companyId);
        ps.add(this.startPeriod.getNumber());
        ps.add(this.currentPeriod.getNumber());
        if (this.beginPeriod != null) {
            sql.append("and mp.FNumber >= ? \n");
            ps.add(this.beginPeriod.getNumber());
        }
        this.appendCardFilter(sql, ps, true);
        this.execute(ctx, sql.toString(), ps.toArray());
        sql.setLength(0);
        ps.clear();
        sql.append("insert into " + this.T_TMP_DataTable + " ( \n");
        sql.append("    FCurCardID, \n");
        sql.append("    FPeriod, \n");
        sql.append("    FType, \n");
        sql.append("    FOperate, \n");
        sql.append("    FError \n");
        sql.append(") \n");
        sql.append("select \n");
        sql.append("    bak.FFaCurCardID, \n");
        sql.append("    mp.FNumber, \n");
        sql.append("    80, \n");
        sql.append("    1, \n");
        sql.append("    1 \n");
        sql.append("from T_FA_FaBakCard bak \n");
        sql.append("join T_BD_Period p on p.FID = bak.FPeriodID \n");
        sql.append("join T_BD_Period mp on mp.FTypeID = p.FTypeID \n");
        sql.append("left join T_FA_FaMonCard mon on mon.FFaCurCardID = bak.FFaCurCardID and mon.FFaPeriodID = mp.FID \n");
        if (this.isCardFilter) {
            sql.append("join T_FA_FaCurCard cur on cur.FID = bak.FFaCurCardID \n");
        }
        sql.append("where bak.FCompanyID = ? \n");
        sql.append("and bak.FBILLTYPE = 1 \n");
        sql.append("and bak.FCheckedStatus = 2 \n");
        sql.append("and mp.FNumber >= p.FNumber \n");
        sql.append("and mp.FNumber < ? \n");
        sql.append("and mon.FID is null \n");
        ps.add(this.companyId);
        ps.add(this.currentPeriod.getNumber());
        if (this.beginPeriod != null) {
            sql.append("and mp.FNumber >= ? \n");
            ps.add(this.beginPeriod.getNumber());
        }
        this.appendCardFilter(sql, ps, true);
        this.execute(ctx, sql.toString(), ps.toArray());
        if (this.isCheckMonRep) {
            sql.setLength(0);
            ps.clear();
            sql.append("insert into " + this.T_TMP_DataTable + " ( \n");
            sql.append("    FCurCardID, \n");
            sql.append("    FPeriod, \n");
            sql.append("    FType, \n");
            sql.append("    FOperate, \n");
            sql.append("    FError \n");
            sql.append(") \n");
            sql.append("select \n");
            sql.append("    mon.FFaCurCardID, \n");
            sql.append("    p.FNumber, \n");
            sql.append("    80, \n");
            sql.append("    1, \n");
            sql.append("    2 \n");
            sql.append("from T_FA_FaMonCard mon \n");
            sql.append("join T_BD_Period p on p.FID = mon.FFaPeriodID \n");
            if (this.isCardFilter) {
                sql.append("join T_FA_FaCurCard cur on cur.FID = mon.FFaCurCardID \n");
            }
            sql.append("where mon.FCompanyID = ? \n");
            ps.add(this.companyId);
            if (this.beginPeriod != null) {
                sql.append("and p.FNumber >= ? \n");
                ps.add(this.beginPeriod.getNumber());
            }
            this.appendCardFilter(sql, ps, true);
            sql.append("group by mon.FFaCurCardID, p.FNumber \n");
            sql.append("having count(*) > 1 \n");
            this.execute(ctx, sql.toString(), ps.toArray());
        }
        for (int i = this.periods.size() - 2; i > 0; --i) {
            PeriodInfo period = this.periods.get(i);
            PeriodInfo prePeriod = i - 1 >= 0 ? this.periods.get(i - 1) : null;
            sql.setLength(0);
            ps.clear();
            sql.append("insert into " + this.T_TMP_DataTable + " ( \n");
            sql.append("    FCurCardID, \n");
            sql.append("    FPeriod, \n");
            sql.append("    FType, \n");
            sql.append("    FOperate, \n");
            sql.append("    FError \n");
            sql.append(") \n");
            sql.append("select \n");
            sql.append("    FCurCardID, \n");
            sql.append("    ?, \n");
            ps.add(period.getNumber());
            sql.append("    81, \n");
            sql.append("    1, \n");
            sql.append("    case \n");
            sql.append("        when sum(FDeprTermCount) <> 0 then 1 \n");
            sql.append("        when sum(FAssetValue) <> 0 then 2 \n");
            sql.append("        when sum(FAccuDepr) <> 0 then 3 \n");
            sql.append("        when sum(FAccuDeprtYear) <> 0 then 4 \n");
            sql.append("        when sum(FNeatValue) <> 0 then 5 \n");
            sql.append("        when sum(FDecValue) <> 0 then 6 \n");
            sql.append("        when sum(FNeatAmt) <> 0 then 7 \n");
            sql.append("        else 0 \n");
            sql.append("    end FError \n");
            sql.append("from ( \n");
            if (prePeriod != null) {
                sql.append("select \n");
                sql.append("    mon.FFaCurCardID FCurCardID, \n");
                sql.append("    mon.FDeprTermCount, \n");
                sql.append("    mon.FAssetValue, \n");
                sql.append("    mon.FAccuDepr, \n");
                if (prePeriod.getPeriodYear() == period.getPeriodYear()) {
                    sql.append("    mon.FAccuDeprtYear, \n");
                } else {
                    sql.append("    0 FAccuDeprtYear, \n");
                }
                sql.append("    mon.FNeatValue, \n");
                sql.append("    mon.FDecValue, \n");
                sql.append("    mon.FNeatAmt \n");
                sql.append("from T_FA_FaMonCard mon \n");
                if (this.isCardFilter) {
                    sql.append("join T_FA_FaCurCard cur on cur.FID = mon.FFaCurCardID \n");
                }
                sql.append("where mon.FCompanyID = ? \n");
                ps.add(this.companyId);
                sql.append("and mon.FFaPeriodID = ? \n");
                ps.add(prePeriod.getId().toString());
                this.appendCardFilter(sql, ps, true);
                sql.append("union all \n");
            }
            sql.append("select \n");
            sql.append("    FCurCardID, \n");
            sql.append("    FDeprTermCount, \n");
            sql.append("    FAssetValue, \n");
            sql.append("    FAccuDepr, \n");
            sql.append("    FAccuDeprtYear, \n");
            sql.append("    FNeatValue, \n");
            sql.append("    FDecValue, \n");
            sql.append("    FNeatAmt \n");
            sql.append("from " + this.T_TMP_Accumulate + " b \n");
            sql.append("where FPeriodID = ? \n");
            ps.add(period.getId().toString());
            sql.append("union all \n");
            sql.append("select \n");
            sql.append("    mon.FFaCurCardID FCurCardID, \n");
            sql.append("    0 - mon.FDeprTermCount FDeprTermCount, \n");
            sql.append("    0 - mon.FAssetValue FAssetValue, \n");
            sql.append("    0 - mon.FAccuDepr FAccuDepr, \n");
            sql.append("    0 - mon.FAccuDeprtYear FAccuDeprtYear, \n");
            sql.append("    0 - mon.FNeatValue FNeatValue, \n");
            sql.append("    0 - mon.FDecValue FDecValue, \n");
            sql.append("    0 - mon.FNeatAmt FNeatAmt \n");
            sql.append("from T_FA_FaMonCard mon \n");
            if (this.isCardFilter) {
                sql.append("join T_FA_FaCurCard cur on cur.FID = mon.FFaCurCardID \n");
            }
            sql.append("where mon.FCompanyID = ? \n");
            ps.add(this.companyId);
            sql.append("and mon.FFaPeriodID = ? \n");
            ps.add(period.getId().toString());
            this.appendCardFilter(sql, ps, true);
            sql.append(") \n");
            sql.append("group by FCurCardID \n");
            sql.append("having ( \n");
            sql.append("    sum(FDeprTermCount) <> 0 \n");
            sql.append("    or sum(FAssetValue) <> 0 \n");
            sql.append("    or sum(FAccuDepr) <> 0 \n");
            sql.append("    or sum(FAccuDeprtYear) <> 0 \n");
            sql.append("    or sum(FNeatValue) <> 0 \n");
            sql.append("    or sum(FDecValue) <> 0 \n");
            sql.append("    or sum(FNeatAmt) <> 0 \n");
            sql.append(") \n");
            this.execute(ctx, sql.toString(), ps.toArray());
            if (this.beginPeriod != null && this.periods.size() - 1 - i >= this.checkHisCount) break;
        }
    }

    protected void checkBalance(Context ctx, Map<String, Object> params) throws Exception {
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> ps = new ArrayList<Object>();
        sql.append("insert into " + this.T_TMP_DataTable + " ( \n");
        sql.append("    FCurCardID, \n");
        sql.append("    FPeriod, \n");
        sql.append("    FType, \n");
        sql.append("    FOperate, \n");
        sql.append("    FError \n");
        sql.append(") \n");
        sql.append("select \n");
        sql.append("    imon.FFaCurCardID, \n");
        sql.append("    mp.FNumber, \n");
        sql.append("    90, \n");
        sql.append("    1, \n");
        sql.append("    1 \n");
        sql.append("from T_FA_FaMonCard imon \n");
        sql.append("join T_BD_Period mp on mp.FTypeID = ? \n");
        sql.append("left join T_FA_FaAccountBalance b on b.FFaCurCardID = imon.FFaCurCardID and b.FPeriodID = mp.FID \n");
        if (this.isCardFilter) {
            sql.append("join T_FA_FaCurCard cur on cur.FID = imon.FFaCurCardID \n");
        }
        sql.append("where imon.FCompanyID = ? \n");
        sql.append("and imon.ForiginFlag = 0 \n");
        sql.append("and imon.FFaPeriodID is null \n");
        sql.append("and mp.FNumber >= ? \n");
        sql.append("and mp.FNumber < ? \n");
        sql.append("and b.FFaCurCardID is null \n");
        ps.add(this.currentPeriod.getPeriodType().getId().toString());
        ps.add(this.companyId);
        ps.add(this.startPeriod.getNumber());
        ps.add(this.currentPeriod.getNumber());
        if (this.beginPeriod != null) {
            sql.append("and mp.FNumber >= ? \n");
            ps.add(this.beginPeriod.getNumber());
        }
        this.appendCardFilter(sql, ps, true);
        this.execute(ctx, sql.toString(), ps.toArray());
        sql.setLength(0);
        ps.clear();
        sql.append("insert into " + this.T_TMP_DataTable + " ( \n");
        sql.append("    FCurCardID, \n");
        sql.append("    FPeriod, \n");
        sql.append("    FType, \n");
        sql.append("    FOperate, \n");
        sql.append("    FError \n");
        sql.append(") \n");
        sql.append("select \n");
        sql.append("    bak.FFaCurCardID, \n");
        sql.append("    mp.FNumber, \n");
        sql.append("    90, \n");
        sql.append("    1, \n");
        sql.append("    1 \n");
        sql.append("from T_FA_FaBakCard bak \n");
        sql.append("join T_BD_Period p on p.FID = bak.FPeriodID \n");
        sql.append("join T_BD_Period mp on mp.FTypeID = p.FTypeID \n");
        sql.append("left join T_FA_FaAccountBalance b on b.FFaCurCardID = bak.FFaCurCardID and b.FPeriodID = mp.FID \n");
        if (this.isCardFilter) {
            sql.append("join T_FA_FaCurCard cur on cur.FID = bak.FFaCurCardID \n");
        }
        sql.append("where bak.FCompanyID = ? \n");
        sql.append("and bak.FBILLTYPE = 1 \n");
        sql.append("and bak.FCheckedStatus = 2 \n");
        sql.append("and mp.FNumber >= p.FNumber \n");
        sql.append("and mp.FNumber < ? \n");
        sql.append("and b.FFaCurCardID is null \n");
        ps.add(this.companyId);
        ps.add(this.currentPeriod.getNumber());
        if (this.beginPeriod != null) {
            sql.append("and mp.FNumber >= ? \n");
            ps.add(this.beginPeriod.getNumber());
        }
        this.appendCardFilter(sql, ps, true);
        this.execute(ctx, sql.toString(), ps.toArray());
        if (this.isCheckBalRep) {
            sql.setLength(0);
            ps.clear();
            sql.append("insert into " + this.T_TMP_DataTable + " ( \n");
            sql.append("    FCurCardID, \n");
            sql.append("    FPeriod, \n");
            sql.append("    FType, \n");
            sql.append("    FOperate, \n");
            sql.append("    FError \n");
            sql.append(") \n");
            sql.append("select \n");
            sql.append("    b.FFaCurCardID, \n");
            sql.append("    p.FNumber, \n");
            sql.append("    90, \n");
            sql.append("    1, \n");
            sql.append("    2 \n");
            sql.append("from T_FA_FaAccountBalance b \n");
            if (this.isCardFilter) {
                sql.append("join T_FA_FaCurCard cur on cur.FID = b.FFaCurCardID \n");
            }
            sql.append("join T_BD_Period p on p.FID = b.FPeriodID \n");
            sql.append("where b.FCompanyOrgUnitID = ? \n");
            ps.add(this.companyId);
            if (this.beginPeriod != null) {
                sql.append("and p.FNumber >= ? \n");
                ps.add(this.beginPeriod.getNumber());
            }
            this.appendCardFilter(sql, ps, true);
            sql.append("group by b.FFaCurCardID, p.FNumber \n");
            sql.append("having count(*) > 1 \n");
            this.execute(ctx, sql.toString(), ps.toArray());
        }
        sql.setLength(0);
        ps.clear();
        sql.append("insert into " + this.T_TMP_DataTable + " ( \n");
        sql.append("    FCurCardID, \n");
        sql.append("    FPeriod, \n");
        sql.append("    FType, \n");
        sql.append("    FOperate, \n");
        sql.append("    FError \n");
        sql.append(") \n");
        sql.append("select \n");
        sql.append("    mon.FFaCurCardID, \n");
        sql.append("    p.FNumber, \n");
        sql.append("    91, \n");
        sql.append("    1, \n");
        sql.append("    case \n");
        sql.append("        when isnull(b.FRealEndBalanceFor, 0) <> mon.FAssetValue then 1 \n");
        sql.append("        when isnull(b.FDepreEndBalanceFor, 0) <> mon.FAccuDepr then 2 \n");
        sql.append("        when isnull(b.FDecValueEndBalanceFor, 0) <> mon.FDecValue then 3 \n");
        sql.append("        else 0 \n");
        sql.append("    end FError \n");
        sql.append("from T_FA_FaMonCard mon \n");
        sql.append("left join T_FA_FaAccountBalance b on b.FFaCurCardID = mon.FFaCurCardID and b.FPeriodID = mon.FFaPeriodID \n");
        sql.append("join T_BD_Period p on p.FID = mon.FFaPeriodID \n");
        if (this.isCardFilter) {
            sql.append("join T_FA_FaCurCard cur on cur.FID = mon.FFaCurCardID \n");
        }
        sql.append("where mon.FCompanyID = ? \n");
        ps.add(this.companyId);
        sql.append("and mon.FDeletedStatus <> 2 \n");
        sql.append("and p.FNumber < ? \n");
        ps.add(this.currentPeriod.getNumber());
        sql.append("and ( \n");
        sql.append("    isnull(b.FRealEndBalanceFor, 0) <> mon.FAssetValue \n");
        sql.append("    or isnull(b.FDepreEndBalanceFor, 0) <> mon.FAccuDepr \n");
        sql.append("    or isnull(b.FDecValueEndBalanceFor, 0) <> mon.FDecValue \n");
        sql.append(") \n");
        if (this.beginPeriod != null) {
            sql.append("and p.FNumber >= ? \n");
            ps.add(this.beginPeriod.getNumber());
        }
        this.appendCardFilter(sql, ps, true);
        this.execute(ctx, sql.toString(), ps.toArray());
    }

    protected void buildPage(Context ctx, Map<String, Object> params) throws Exception {
        StringBuffer sql = new StringBuffer();
        String T_TMP_PageTable = this.createDataTable(ctx, true, false);
        sql.append("insert into " + T_TMP_PageTable + " ( \n");
        sql.append("    KSQL_SEQ, \n");
        sql.append("    FCurCardID, \n");
        sql.append("    FPeriod, \n");
        sql.append("    FBizDate, \n");
        sql.append("    FBizNumber, \n");
        sql.append("    FType, \n");
        sql.append("    FOperate, \n");
        sql.append("    FError \n");
        sql.append(") \n");
        sql.append("select \n");
        sql.append("    t.FCurCardID, \n");
        sql.append("    t.FPeriod, \n");
        sql.append("    t.FBizDate, \n");
        sql.append("    t.FBizNumber, \n");
        sql.append("    t.FType, \n");
        sql.append("    t.FOperate, \n");
        sql.append("    t.FError \n");
        sql.append("from " + this.T_TMP_DataTable + " t \n");
        sql.append("join T_FA_FaCurCard cur on cur.FID = t.FCurCardID \n");
        sql.append("order by cur.FNumber, t.FPeriod \n");
        this.execute(ctx, sql.toString());
        this.T_TMP_DataTable = T_TMP_PageTable;
    }

    @Override
    protected List<String> getColNames(Context ctx, Map<String, Object> params) {
        ArrayList<String> colNames = new ArrayList<String>();
        colNames.add("id");
        colNames.add("catName");
        colNames.add("number");
        colNames.add("assetName");
        colNames.add("period");
        colNames.add("operate");
        colNames.add("note");
        colNames.add("bizDate");
        colNames.add("bizNumber");
        colNames.add("depPeriod");
        colNames.add("assetValue");
        colNames.add("accuDepr");
        colNames.add("neatValue");
        colNames.add("decValue");
        colNames.add("neatAmt");
        return colNames;
    }

    @Override
    protected List<List<Object>> getData(Context ctx, int fromIndex, int pageSize) throws BOSException, EASBizException {
        ArrayList<List<Object>> datas = new ArrayList<List<Object>>(pageSize);
        StringBuffer sql = new StringBuffer();
        sql.append("select \n");
        sql.append("    t.KSQL_SEQ FSeq, t.FPeriod, \n");
        sql.append("    cur.FID, c.FName_l2 FCatName, cur.FNumber, cur.FAssetName, \n");
        sql.append("    cur.FDeprTermCount, cur.FAssetValue, cur.FAccuDepr, cur.FNeatValue, cur.FDecValue, cur.FNeatAmt, \n");
        sql.append("    t.FBizDate, FBizNumber, \n");
        sql.append("    t.FType, t.FOperate, t.FError \n");
        sql.append("from " + this.T_TMP_DataTable + " t \n");
        sql.append("join T_FA_FaCurCard cur on cur.FID = t.FCurCardID \n");
        sql.append("left join T_FA_Cat c on c.FID = cur.FAssetCatID \n");
        sql.append("where t.KSQL_SEQ >= ? and t.KSQL_SEQ < ? \n");
        sql.append("order by t.KSQL_SEQ \n");
        IRowSet rs = this.executeQuery(ctx, sql.toString(), new Object[]{fromIndex, fromIndex + pageSize});
        try {
            while (rs.next()) {
                ArrayList<Object> data = new ArrayList<Object>();
                data.add(rs.getString("FID"));
                data.add(rs.getString("FCatName"));
                data.add(rs.getString("FNumber"));
                data.add(rs.getString("FAssetName"));
                data.add(rs.getInt("FPeriod"));
                int type = rs.getInt("FType");
                int operate = rs.getInt("FOperate");
                int error = rs.getInt("FError");
                if (type == 1) {
                    data.add(operate > 0 ? FaBillOriginEnum.getEnum(String.valueOf(operate)) : "\u53d8\u66f4");
                    if (error == 1) {
                        data.add("\u4e1a\u52a1\u5361\u7247\u4e22\u5931");
                    } else if (error == 2) {
                        data.add("\u5907\u4efd\u5361\u7247\u4e22\u5931");
                    } else if (error == 3) {
                        data.add("\u539f\u503c\u8c03\u6574\u4e0d\u7b49\u4e8e\u4e1a\u52a1\u5361\u7247");
                    } else if (error == 4) {
                        data.add("\u6298\u65e7\u8c03\u6574\u4e0d\u7b49\u4e8e\u4e1a\u52a1\u5361\u7247");
                    } else if (error == 5) {
                        data.add("\u51cf\u503c\u51c6\u5907\u8c03\u6574\u4e0d\u7b49\u4e8e\u4e1a\u52a1\u5361\u7247");
                    } else {
                        data.add("");
                    }
                } else if (type == 3) {
                    data.add("\u5f53\u524d");
                    if (error == 1) {
                        data.add("\u5f53\u524d\u6298\u65e7\u671f\u95f4\u6570\u9519\u8bef");
                    } else if (error == 2) {
                        data.add("\u5f53\u524d\u539f\u503c\u9519\u8bef");
                    } else if (error == 3) {
                        data.add("\u5f53\u524d\u7d2f\u8ba1\u6298\u65e7\u9519\u8bef");
                    } else if (error == 4) {
                        data.add("\u5f53\u524d\u672c\u5e74\u7d2f\u8ba1\u6298\u65e7\u9519\u8bef");
                    } else if (error == 5) {
                        data.add("\u5f53\u524d\u51c0\u503c\u9519\u8bef");
                    } else if (error == 6) {
                        data.add("\u5f53\u524d\u51cf\u503c\u51c6\u5907\u9519\u8bef");
                    } else if (error == 7) {
                        data.add("\u5f53\u524d\u51c0\u989d\u9519\u8bef");
                    } else {
                        data.add("");
                    }
                } else if (type == 80) {
                    data.add("\u6708\u7ed3");
                    if (error == 1) {
                        data.add("\u6708\u7ed3\u8bb0\u5f55\u7f3a\u5931");
                    } else if (error == 2) {
                        data.add("\u6708\u7ed3\u8bb0\u5f55\u91cd\u590d");
                    } else {
                        data.add("");
                    }
                } else if (type == 81) {
                    data.add("\u6708\u7ed3");
                    if (error == 1) {
                        data.add("\u6708\u7ed3\u6298\u65e7\u671f\u95f4\u6570\u9519\u8bef");
                    } else if (error == 2) {
                        data.add("\u6708\u7ed3\u539f\u503c\u9519\u8bef");
                    } else if (error == 3) {
                        data.add("\u6708\u7ed3\u7d2f\u8ba1\u6298\u65e7\u9519\u8bef");
                    } else if (error == 4) {
                        data.add("\u6708\u7ed3\u672c\u5e74\u7d2f\u8ba1\u6298\u65e7\u9519\u8bef");
                    } else if (error == 5) {
                        data.add("\u6708\u7ed3\u51c0\u503c\u9519\u8bef");
                    } else if (error == 6) {
                        data.add("\u6708\u7ed3\u51cf\u503c\u51c6\u5907\u9519\u8bef");
                    } else if (error == 7) {
                        data.add("\u6708\u7ed3\u51c0\u989d\u9519\u8bef");
                    } else {
                        data.add("");
                    }
                } else if (type == 90) {
                    data.add("\u6708\u7ed3");
                    if (error == 1) {
                        data.add("\u4f59\u989d\u8bb0\u5f55\u7f3a\u5931");
                    } else if (error == 2) {
                        data.add("\u4f59\u989d\u8bb0\u5f55\u91cd\u590d");
                    } else {
                        data.add("");
                    }
                } else if (type == 91) {
                    data.add("\u6708\u7ed3");
                    if (error == 1) {
                        data.add("\u539f\u503c\u4f59\u989d\u9519\u8bef");
                    } else if (error == 2) {
                        data.add("\u7d2f\u8ba1\u6298\u65e7\u4f59\u989d\u9519\u8bef");
                    } else if (error == 3) {
                        data.add("\u51cf\u503c\u51c6\u5907\u4f59\u989d\u9519\u8bef");
                    } else {
                        data.add("");
                    }
                } else {
                    data.add("\u64cd\u4f5c");
                    data.add("\u8bf4\u660e");
                }
                data.add(rs.getTimestamp("FBizDate"));
                data.add(rs.getString("FBizNumber"));
                data.add(rs.getInt("FDeprTermCount"));
                data.add(rs.getBigDecimal("FAssetValue"));
                data.add(rs.getBigDecimal("FAccuDepr"));
                data.add(rs.getBigDecimal("FNeatValue"));
                data.add(rs.getBigDecimal("FDecValue"));
                data.add(rs.getBigDecimal("FNeatAmt"));
                datas.add(data);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return datas;
    }

    protected String createDataTable(Context ctx, boolean ksqlSeq, boolean release) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("create table T_TMP_DataTable ( \n");
        if (ksqlSeq) {
            sql.append("  KSQL_SEQ INT IDENTITY (1, 1), \n");
        }
        sql.append("  FCurCardID VARCHAR(44), \n");
        sql.append("  FPeriod int DEFAULT 0, \n");
        sql.append("  FBizDate DateTime, \n");
        sql.append("  FBizNumber NVARCHAR(80), \n");
        sql.append("  FType int DEFAULT 0, \n");
        sql.append("  FOperate int DEFAULT 0, \n");
        sql.append("  FError int DEFAULT 0 \n");
        sql.append(") \n");
        return this.createTempTable(ctx, sql.toString(), release);
    }
}

