/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaBillBaseInfo;
import com.kingdee.eas.fi.fa.manage.FaBillBizProcessor;
import com.kingdee.eas.fi.fa.manage.FaPhysicalManageBaseException;
import com.kingdee.eas.fi.fa.manage.FaPhysicalManageBaseInfo;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaPhysicalManageBaseControllerBean;
import com.kingdee.eas.fi.fa.manage.app.AbstractPrcFaManageStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.PrcFaCoreManager;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.util.Date;
import org.apache.log4j.Logger;

public abstract class FaPhysicalManageBaseControllerBean
extends AbstractFaPhysicalManageBaseControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.manage.app.FaPhysicalManageBaseControllerBean");

    @Override
    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkNumberORSetNumber(ctx, model);
        String pk = model.get("id") == null ? null : model.get("id").toString();
        FaBillBizProcessor.lockTable(ctx, pk);
        this.checkBeforeSave(ctx, model);
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(this.getBillStrategy());
        FaBillBaseInfo billBaseInfo = (FaBillBaseInfo)model;
        if (billBaseInfo != null && billBaseInfo.getBOSUuid("id") != null) {
            prcFaCoreManager.getFaManageStrategy().checkForSave(ctx, (IObjectValue)billBaseInfo);
        } else {
            if (billBaseInfo.getCompany() != null && billBaseInfo.getCompany().getId() != null) {
                prcFaCoreManager.getFaManageStrategy().checkUnAuditFaDep(ctx, prcFaCoreManager.getFaManageStrategy().getCurrentPeriod(ctx, billBaseInfo), billBaseInfo.getCompany());
            }
            FaLocalUtils.verifyForLastestPeriod(ctx, (IObjectValue)billBaseInfo, 1);
        }
        logger.debug((Object)"_save");
        return prcFaCoreManager.getFaManageStrategy().saveBill(ctx, model);
    }

    protected void checkNumberORSetNumber(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaPhysicalManageBaseInfo info = (FaPhysicalManageBaseInfo)model;
        boolean isCodingRule = CodingRuleManagerFactory.getLocalInstance((Context)ctx).isExist((IObjectValue)info, info.getCompany().getId().toString());
        if (!isCodingRule) {
            if (model.getString("number") == null || model.getString("number").trim().length() == 0) {
                throw new FaPhysicalManageBaseException(FaPhysicalManageBaseException.NUMBERNULL);
            }
        } else {
            if (info.getId() == null) {
                info.setNumber(CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)info, info.getCompany().getId().toString()));
                return;
            }
            if (model.getString("number") == null || model.getString("number").trim().length() == 0) {
                throw new FaPhysicalManageBaseException(FaPhysicalManageBaseException.NUMBERNULL);
            }
        }
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
        f.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId().toString()));
        if (info.getId() != null) {
            f.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this.exists(ctx, f)) {
            throw new FaPhysicalManageBaseException(FaPhysicalManageBaseException.EXISTSNUMBER, new Object[]{info.getNumber()});
        }
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkNumberORSetNumber(ctx, model);
        String pk = model.get("id") == null ? null : model.get("id").toString();
        FaBillBizProcessor.lockTable(ctx, pk);
        this.checkBeforeSubmit(ctx, model);
        if (model != null && model.getBoolean("forDAP")) {
            return this._submitSelf(ctx, (FaBillBaseInfo)model);
        }
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(this.getBillStrategy());
        FaBillBaseInfo billBaseInfo = (FaBillBaseInfo)model;
        billBaseInfo.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        if (billBaseInfo != null && billBaseInfo.getBOSUuid("id") != null) {
            prcFaCoreManager.getFaManageStrategy().checkForEdit(ctx, (IObjectValue)billBaseInfo);
        } else {
            if (billBaseInfo.getCompany() != null && billBaseInfo.getCompany().getId() != null) {
                prcFaCoreManager.getFaManageStrategy().checkUnAuditFaDep(ctx, prcFaCoreManager.getFaManageStrategy().getCurrentPeriod(ctx, billBaseInfo), billBaseInfo.getCompany());
            }
            FaLocalUtils.verifyForLastestPeriod(ctx, (IObjectValue)billBaseInfo, 1);
        }
        logger.debug((Object)"_submit");
        return prcFaCoreManager.getFaManageStrategy().submitBill(ctx, model);
    }

    @Override
    protected AbstractPrcFaManageStrategy getBillStrategy() {
        return new AbstractPrcFaManageStrategy(){

            @Override
            protected void unAuditBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
                FaPhysicalManageBaseControllerBean.this._unpassAuditSelf(ctx, (IObjectPK)new ObjectUuidPK(model.get("id").toString()), (FaBillBaseInfo)model);
            }

            @Override
            protected IObjectPK submitBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
                FaPhysicalManageBaseInfo billInfo = (FaPhysicalManageBaseInfo)model;
                IObjectPK pk = FaPhysicalManageBaseControllerBean.this._submitSelf(ctx, billInfo);
                return pk;
            }

            @Override
            protected IObjectPK saveBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
                FaPhysicalManageBaseInfo billInfo = (FaPhysicalManageBaseInfo)model;
                billInfo.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
                IObjectPK pk = FaPhysicalManageBaseControllerBean.this._saveSelf(ctx, billInfo);
                return pk;
            }

            @Override
            protected void generateVourcher(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
            }

            @Override
            protected void deleteBill(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("company.id"));
                FaPhysicalManageBaseInfo billInfo = FaPhysicalManageBaseControllerBean.this.getFaPhysicalManageBaseInfo(ctx, pk, sic);
                this.recycleNumber(ctx, billInfo);
                FaPhysicalManageBaseControllerBean.this._deleteSelf(ctx, pk);
            }

            @Override
            protected void auditBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
                FaPhysicalManageBaseControllerBean.this.verfyBeforeAudit(model);
                FaPhysicalManageBaseControllerBean.this._passAuditSelf(ctx, (IObjectPK)new ObjectUuidPK(model.get("id").toString()), (FaBillBaseInfo)model);
            }
        };
    }

    @Override
    protected void _passAuditSelf(Context ctx, IObjectPK pk, FaBillBaseInfo model) throws BOSException, EASBizException {
        FaPhysicalManageBaseInfo billInfo = (FaPhysicalManageBaseInfo)model;
        billInfo.setCheckedStatus(CheckedStatusEnum.AUDITED);
        billInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        billInfo.setAuditTime(new Date());
        super.update(ctx, pk, (CoreBaseInfo)billInfo);
    }

    @Override
    protected void _unpassAuditSelf(Context ctx, IObjectPK pk, FaBillBaseInfo model) throws BOSException, EASBizException {
        FaPhysicalManageBaseInfo billInfo = (FaPhysicalManageBaseInfo)model;
        billInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        billInfo.setAuditor(null);
        billInfo.setAuditTime(null);
        super.update(ctx, pk, (CoreBaseInfo)billInfo);
    }

    protected void verfyBeforeAudit(IObjectValue model) throws BOSException, EASBizException {
    }

    protected void updateCurCardBySQL(Context ctx, String bizStatus, String lastBillID, String curCardIDsql) throws BOSException {
        String sql = "update T_FA_FACURCARD set fbizStatus = '" + bizStatus + "',flastBillID = " + (lastBillID == null ? "NULL" : "'" + lastBillID + "'") + ",flastupdatetime = GETDATE() where fid in (" + curCardIDsql + ") ";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    protected void updateCurCardBySQL(Context ctx, String bizStatus, String lastBillID, String curCardID, boolean isLastPeriodChange) throws BOSException {
        String sql = "update T_FA_FACURCARD set fbizStatus = '" + bizStatus + "',flastBillID = " + (lastBillID == null ? "NULL" : "'" + lastBillID + "'") + ",FLastPeriodChange=" + (isLastPeriodChange ? 1 : 0) + ",flastupdatetime = GETDATE() where fid = '" + curCardID + "'";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    protected void updateCurCardBySQLThisLastBillID(Context ctx, String bizStatus, String lastBillID, String curCardID, boolean isLastPeriodChange) throws BOSException {
        String sql = "update T_FA_FACURCARD set fbizStatus = '" + bizStatus + "',flastBillID = " + (lastBillID == null ? "NULL" : "'" + lastBillID + "'") + ",FLastPeriodChange=" + (isLastPeriodChange ? 1 : 0) + ",flastupdatetime = GETDATE() where fid = '" + curCardID + "' and flastBillID = '" + lastBillID + "'";
        DbUtil.execute((Context)ctx, (String)sql);
    }
}

