/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.attachment.AttachmentCollection;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgInnerFacade;
import com.kingdee.eas.basedata.org.OrgInnerFacadeFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.EvaItemDetailEnum;
import com.kingdee.eas.fi.fa.basedata.EvaItemEnum;
import com.kingdee.eas.fi.fa.basedata.FaAlterModeInfo;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeInfo;
import com.kingdee.eas.fi.fa.def.FaDefPropertyCollection;
import com.kingdee.eas.fi.fa.def.FaDefPropertyFactory;
import com.kingdee.eas.fi.fa.def.FaDefPropertyInfo;
import com.kingdee.eas.fi.fa.def.FaDefPropertyValueInfo;
import com.kingdee.eas.fi.fa.manage.AssistActItemInfo;
import com.kingdee.eas.fi.fa.manage.DateUnitEnum;
import com.kingdee.eas.fi.fa.manage.FALeaseContractInfo;
import com.kingdee.eas.fi.fa.manage.FaBizCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBorrowingEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaBorrowingInfo;
import com.kingdee.eas.fi.fa.manage.FaCardInfo;
import com.kingdee.eas.fi.fa.manage.FaChangeBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaChangeBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaChangeBillInfo;
import com.kingdee.eas.fi.fa.manage.FaClearBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaClearBillInfo;
import com.kingdee.eas.fi.fa.manage.FaCostCenterInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCostCenterCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCostCenterInfo;
import com.kingdee.eas.fi.fa.manage.FaCurDepartmentCollection;
import com.kingdee.eas.fi.fa.manage.FaCurDepartmentInfo;
import com.kingdee.eas.fi.fa.manage.FaCurFacilityInfo;
import com.kingdee.eas.fi.fa.manage.FaDispatchBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaDispatchBillInfo;
import com.kingdee.eas.fi.fa.manage.FaEvaValueCollection;
import com.kingdee.eas.fi.fa.manage.FaEvaValueInfo;
import com.kingdee.eas.fi.fa.manage.FaEvaluateBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaEvaluateBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaEvaluateBillInfo;
import com.kingdee.eas.fi.fa.manage.FaFromUnitCatEnum;
import com.kingdee.eas.fi.fa.manage.FaLeaseBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseBillInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillInfo;
import com.kingdee.eas.fi.fa.manage.FaMaintainEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaMaintainInfo;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaMonCardInfo;
import com.kingdee.eas.fi.fa.manage.FaMonCostCenterCollection;
import com.kingdee.eas.fi.fa.manage.FaMonCostCenterInfo;
import com.kingdee.eas.fi.fa.manage.FaMonDepartmentCollection;
import com.kingdee.eas.fi.fa.manage.FaMonDepartmentInfo;
import com.kingdee.eas.fi.fa.manage.FaMonFacilityInfo;
import com.kingdee.eas.fi.fa.manage.FaMonInitDataInfo;
import com.kingdee.eas.fi.fa.manage.FaMortagBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaMortagBillInfo;
import com.kingdee.eas.fi.fa.manage.FaRefundingEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaRefundingInfo;
import com.kingdee.eas.fi.fa.manage.FaRequisitionedBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaRequisitionedBillInfo;
import com.kingdee.eas.fi.fa.manage.FaReturnEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaReturnInfo;
import com.kingdee.eas.fi.fa.manage.FaStocktakingAOrPBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaStocktakingAOrPBillInfo;
import com.kingdee.eas.fi.fa.manage.FaStocktakingBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaStocktakingBillInfo;
import com.kingdee.eas.fi.fa.manage.FaStocktakingReportBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaStocktakingReportBillInfo;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaPrintManager;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class FaPrintServerHelper {
    private static final Logger logger = Logger.getLogger(FaPrintServerHelper.class);
    static final String[] columsForClear = new String[]{"clrQty", "clrOriginal", "clrAddupDep", "clrDecPrep", "clrFare", "spilthMoveIn", "spilthIncome", "splithDeal", "comment", "curCard.id", "bizCard.id", "bizCard.faBakCard.assetCat.name", "bizCard.faBakCard.number", "bizCard.faBakCard.assetName", "bizCard.faBakCard.specs", "bizCard.faBakCard.measureUnit.name", "bizCard.faBakCard.assetAmt", "bizCard.faBakCard.assetValue", "bizCard.faBakCard.accuDepr", "bizCard.faBakCard.decValue", "bizCard.faBakCard.accountDate", "bizCard.faBakCard.deprTTerm"};
    static final String[] columsForCard = new String[]{"facilityNumber", "facilityName", "facilityName", "facilityModel", "registerDate", "quantity", "amount", "remark", "measureUnit.name", "storePlace.name", "keeper.name"};

    public static void beforeBuildData(IObjectCollection collection, Context ctx) {
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        String companyName = company == null ? "" : company.getName();
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        String operator = user == null ? "" : user.getName();
        Date printDate = new Date();
        for (int i = 0; i < collection.size(); ++i) {
            IObjectValue editData = collection.getObject(i);
            if (editData instanceof BillBaseInfo) {
                BillBaseInfo info = (BillBaseInfo)editData;
                if (info.getCompany() == null) continue;
                if (info.getCompany().getName() == null || info.getCompany().getName().equals("")) {
                    info.getCompany().setName(companyName);
                }
            }
            editData.put("operator", (Object)operator);
            editData.put("printdate", (Object)printDate);
        }
    }

    public static BOSQueryDelegate getPrintManagerForEditUI(IObjectCollection collection, final KDTable[] tables, Context ctx) {
        FaPrintServerHelper.beforeBuildData(collection, ctx);
        AbstractFaPrintManager data = new AbstractFaPrintManager(collection, ctx){

            @Override
            public IRowSet execute(BOSQueryDataSource ds) {
                return this.getDefaltRowSet(ds, tables);
            }
        };
        return data;
    }

    public static BOSQueryDelegate getPrintManagerForFaClearBillListUI(IObjectCollection collection, Context ctx) {
        FaPrintServerHelper.beforeBuildData(collection, ctx);
        AbstractFaPrintManager data = new AbstractFaPrintManager(collection, ctx){

            @Override
            public IRowSet execute(BOSQueryDataSource ds) {
                return this.getDefaltRowSet(ds, columsForClear, "clearBillEntry");
            }

            @Override
            protected List beforeBuildColumn(List columns) {
                if (!columns.contains("imageNumber")) {
                    columns.add("imageNumber");
                }
                return columns;
            }

            @Override
            protected void afterHeadFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
                FaClearBillInfo info = (FaClearBillInfo)sourceInfo;
                rs.updateString("printdate", FaPrintServerHelper.transDateToStr((Date)info.get("printdate")));
                rs.updateString("cleardate", FaPrintServerHelper.transDateToStr(info.getClearDate()));
                rs.updateString("createtime", FaPrintServerHelper.transDateToStr(info.getCreateTime()));
                rs.updateString("bizdate", FaPrintServerHelper.transDateToStr(info.getBizDate()));
                if (info.getId() != null) {
                    String imageNumber = this.getImageNumber(new FaClearBillInfo().getBOSType().toString(), info.getId().toString());
                    rs.updateString("imageNumber", imageNumber);
                } else {
                    rs.updateString("imageNumber", "");
                }
            }

            @Override
            protected void afterDetailFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
                FaClearBillEntryInfo info = (FaClearBillEntryInfo)sourceInfo;
                if (info != null && info.getSplithDeal() != null) {
                    rs.updateString("clearBillEntry.splithDeal", info.getSplithDeal().toString());
                }
                if (info.getClrOriginal() != null) {
                    rs.updateString("clearbillentry.clroriginal", FaPrintServerHelper.transBigDecimalToStr(info.getClrOriginal()));
                }
                if (info.getClrAddupDep() != null) {
                    rs.updateString("clearbillentry.clraddupdep", FaPrintServerHelper.transBigDecimalToStr(info.getClrAddupDep()));
                }
                if (info.getClrDecPrep() != null) {
                    rs.updateString("clearbillentry.clrdecprep", FaPrintServerHelper.transBigDecimalToStr(info.getClrDecPrep()));
                }
                if (info.getClrFare() != null) {
                    rs.updateString("clearbillentry.clrfare", FaPrintServerHelper.transBigDecimalToStr(info.getClrFare()));
                }
                if (info.getSpilthMoveIn() != null) {
                    rs.updateString("clearbillentry.spilthmovein", FaPrintServerHelper.transBigDecimalToStr(info.getSpilthMoveIn()));
                }
                if (info.getSpilthIncome() != null) {
                    rs.updateString("clearbillentry.spilthincome", FaPrintServerHelper.transBigDecimalToStr(info.getSpilthIncome()));
                }
            }
        };
        return data;
    }

    public static BOSQueryDelegate getPrintManagerForFaClearEditUI(IObjectCollection collection, final KDTable[] tables, Context ctx) throws Exception {
        FaPrintServerHelper.beforeBuildData(collection, ctx);
        AbstractFaPrintManager data = new AbstractFaPrintManager(collection, ctx){
            CompanyOrgUnitInfo company;
            int basePrecision;
            Map faParameter;
            int quantityScale;
            {
                super(collection, ctx);
                this.company = ContextUtil.getCurrentFIUnit((Context)this.ctx);
                this.basePrecision = FaManageUtils.getCurrencyScale(this.company, this.ctx);
                this.faParameter = FaManageUtils.getFAParameter(this.company.getId(), this.ctx);
                this.quantityScale = Integer.valueOf(this.faParameter.get("FA_008") == null ? "0" : (String)this.faParameter.get("FA_008"));
            }

            @Override
            public IRowSet execute(BOSQueryDataSource ds) {
                return this.getDefaltRowSet(ds, tables);
            }

            @Override
            protected List beforeBuildColumn(List columns) {
                if (!columns.contains("clearbillentry.bizcard.fabakcard.assetcat.name")) {
                    columns.add("clearbillentry.bizcard.fabakcard.assetcat.name");
                }
                if (!columns.contains("clearbillentry.bizcard.fabakcard.number")) {
                    columns.add("clearbillentry.bizcard.fabakcard.number");
                }
                if (!columns.contains("clearbillentry.bizcard.fabakcard.assetname")) {
                    columns.add("clearbillentry.bizcard.fabakcard.assetname");
                }
                if (!columns.contains("clearbillentry.bizcard.fabakcard.specs")) {
                    columns.add("clearbillentry.bizcard.fabakcard.specs");
                }
                if (!columns.contains("clearbillentry.bizcard.fabakcard.measureunit.name")) {
                    columns.add("clearbillentry.bizcard.fabakcard.measureunit.name");
                }
                if (!columns.contains("clearbillentry.bizcard.fabakcard.assetamt")) {
                    columns.add("clearbillentry.bizcard.fabakcard.assetamt");
                }
                if (!columns.contains("clearbillentry.bizcard.fabakcard.assetvalue")) {
                    columns.add("clearbillentry.bizcard.fabakcard.assetvalue");
                }
                if (!columns.contains("clearbillentry.bizcard.fabakcard.initEvalValue")) {
                    columns.add("clearbillentry.bizcard.fabakcard.initEvalValue");
                }
                if (!columns.contains("clearbillentry.bizcard.fabakcard.accudepr")) {
                    columns.add("clearbillentry.bizcard.fabakcard.accudepr");
                }
                if (!columns.contains("clearbillentry.bizcard.fabakcard.decvalue")) {
                    columns.add("clearbillentry.bizcard.fabakcard.decvalue");
                }
                if (!columns.contains("clearbillentry.bizcard.fabakcard.accountdate")) {
                    columns.add("clearbillentry.bizcard.fabakcard.accountdate");
                }
                if (!columns.contains("clearbillentry.bizcard.fabakcard.deprtterm")) {
                    columns.add("clearbillentry.bizcard.fabakcard.deprtterm");
                }
                if (!columns.contains("imageNumber")) {
                    columns.add("imageNumber");
                }
                return columns;
            }

            @Override
            protected void afterHeadFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
                FaClearBillInfo clearBillInfo = (FaClearBillInfo)sourceInfo;
                rs.updateString("printdate", FaPrintServerHelper.transDateToStr((Date)clearBillInfo.get("printdate")));
                rs.updateString("cleardate", FaPrintServerHelper.transDateToStr(clearBillInfo.getClearDate()));
                rs.updateString("createtime", FaPrintServerHelper.transDateToStr(clearBillInfo.getCreateTime()));
                rs.updateString("bizdate", FaPrintServerHelper.transDateToStr(clearBillInfo.getBizDate()));
                if (clearBillInfo.getId() != null) {
                    String imageNumber = this.getImageNumber(new FaClearBillInfo().getBOSType().toString(), clearBillInfo.getId().toString());
                    rs.updateString("imageNumber", imageNumber);
                } else {
                    rs.updateString("imageNumber", "");
                }
            }

            @Override
            protected void afterDetailFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
                FaCardInfo cardInfo;
                FaClearBillEntryInfo clearBillEntryInfo = (FaClearBillEntryInfo)sourceInfo;
                if (clearBillEntryInfo.getClrOriginal() != null) {
                    rs.updateString("clearbillentry.clroriginal", FaPrintServerHelper.transBigDecimalToStr(clearBillEntryInfo.getClrOriginal().setScale(this.basePrecision, 4)));
                }
                if (clearBillEntryInfo.getClrEvalValue() != null) {
                    rs.updateString("clearbillentry.clrEvalValue", FaPrintServerHelper.transBigDecimalToStr(clearBillEntryInfo.getClrEvalValue().setScale(this.basePrecision, 4)));
                }
                rs.updateString("clearbillentry.clraddupdep", FaPrintServerHelper.transBigDecimalToStr(clearBillEntryInfo.getClrAddupDep().setScale(this.basePrecision, 4)));
                rs.updateString("clearbillentry.clrdecprep", FaPrintServerHelper.transBigDecimalToStr(clearBillEntryInfo.getClrDecPrep().setScale(this.basePrecision, 4)));
                rs.updateString("clearbillentry.clrfare", FaPrintServerHelper.transBigDecimalToStr(clearBillEntryInfo.getClrFare().setScale(this.basePrecision, 4)));
                rs.updateString("clearbillentry.spilthmovein", FaPrintServerHelper.transBigDecimalToStr(clearBillEntryInfo.getSpilthMoveIn().setScale(this.basePrecision, 4)));
                rs.updateString("clearbillentry.spilthincome", FaPrintServerHelper.transBigDecimalToStr(clearBillEntryInfo.getSpilthIncome().setScale(this.basePrecision, 4)));
                FaBizCardInfo bizCardInfo = clearBillEntryInfo.getBizCard();
                if (bizCardInfo == null) {
                    String cardId = (String)clearBillEntryInfo.get("facurcard");
                    cardInfo = FaCurCardFactory.getLocalInstance(this.ctx).getFaCurCardInfo((IObjectPK)new ObjectUuidPK(cardId));
                } else {
                    cardInfo = bizCardInfo.getFaBakCard();
                }
                if (cardInfo == null) {
                    return;
                }
                rs.updateString("clearbillentry.bizCard.faBakCard.assetamt", FaPrintServerHelper.transBigDecimalToStr(cardInfo.getAssetAmt().setScale(this.quantityScale, 4)));
                rs.updateString("clearbillentry.clrQty", FaPrintServerHelper.transBigDecimalToStr(clearBillEntryInfo.getClrQty().setScale(this.quantityScale, 4)));
            }
        };
        return data;
    }

    public static BOSQueryDelegate getPrintManagerForFaCurCardEditUI(IObjectCollection collection, Context ctx) throws Exception {
        return FaPrintServerHelper.getPrintManagerForFaCurCardListUI(collection, ctx);
    }

    public static BOSQueryDelegate getPrintManagerForFaCurCardListUI(IObjectCollection collection, Context ctx) throws Exception {
        FaPrintServerHelper.beforeBuildData(collection, ctx);
        AbstractFaPrintManager data = new AbstractFaPrintManager(collection, ctx){
            CompanyOrgUnitInfo company;
            Map faParameter;
            {
                this.company = ContextUtil.getCurrentFIUnit((Context)this.ctx);
                this.faParameter = FaManageUtils.getFAParameter(this.company.getId(), this.ctx);
            }

            @Override
            public IRowSet execute(BOSQueryDataSource ds) {
                return this.getDefaltRowSet(ds, columsForCard, "faCurFacility");
            }

            @Override
            protected List beforeBuildColumn(List columns) {
                if (!columns.contains("facurcostcenter.asstacttype.name")) {
                    columns.add("facurcostcenter.asstacttype.name");
                }
                if (!columns.contains("keeper.number")) {
                    columns.add("keeper.number");
                }
                if (!columns.contains("facurdepartment.usedepartment.name")) {
                    columns.add("facurdepartment.usedepartment.name");
                }
                if (!columns.contains("facurdepartment.useperson.name")) {
                    columns.add("facurdepartment.useperson.name");
                }
                if (!columns.contains("attachmentImage")) {
                    columns.add("attachmentImage");
                }
                if (!columns.contains("imageNumber")) {
                    columns.add("imageNumber");
                }
                try {
                    FaDefPropertyCollection ps = FaDefPropertyFactory.getLocalInstance((Context)this.ctx).getFaDefPropertyCollection();
                    for (int i = 0; i < ps.size(); ++i) {
                        String key = "def." + ps.get(i).getNumber();
                        if (columns.contains(key)) continue;
                        columns.add(key);
                    }
                }
                catch (BOSException e) {
                    throw new RuntimeException(e);
                }
                return columns;
            }

            @Override
            protected void afterHeadFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
                Object isUseGroupNumber;
                FaCurCardInfo info = (FaCurCardInfo)sourceInfo;
                if (info == null) {
                    return;
                }
                if (info.getCompany() != null && info.getCompany().getId() != null) {
                    this.faParameter = FaManageUtils.getFAParameter(info.getCompany().getId(), this.ctx);
                }
                String isDisDeptLName = this.faParameter.get("FA_025") == null ? "false" : (String)this.faParameter.get("FA_025");
                FaCurCostCenterCollection collection = info.getFaCurCostCenter();
                StringBuffer costCenterName = new StringBuffer();
                for (int i = 0; i < collection.size(); ++i) {
                    FaCurCostCenterInfo costCenter = collection.get(i);
                    String typeName = "";
                    if (costCenter.getAsstActType() != null) {
                        typeName = costCenter.getAsstActType().getName() == null ? "" : costCenter.getAsstActType().getName();
                    }
                    String itemName = "";
                    if (costCenter.getAsstActItem() != null) {
                        itemName = costCenter.getAsstActItem().getName() == null ? "" : costCenter.getAsstActItem().getName();
                    }
                    String account = costCenter.getAccountView() == null ? "" : costCenter.getAccountView().getNumber() + "-" + costCenter.getAccountView().getLongName();
                    String scale = costCenter.getApportionScale() == null ? "" : costCenter.getApportionScale().toString() + "%";
                    costCenterName.append(i == 0 ? "" : "; ").append("".equals(account) ? "" : account).append(" ").append(scale).append(" ").append(FaPrintServerHelper.getAsstActLName(collection.get(i)));
                }
                if (!"".equals(costCenterName.toString().trim())) {
                    rs.updateString("facurcostcenter.asstActType.name", costCenterName.toString());
                } else if (this.allColumns.indexOf("facurcostcenter.asstacttype.name") >= 0) {
                    rs.updateString("facurcostcenter.asstActType.name", "");
                }
                FaCurDepartmentCollection departmentColl = info.getFaCurDepartment();
                StringBuffer departmentsName = new StringBuffer();
                StringBuffer departmentsUsePerson = new StringBuffer();
                int size = departmentColl.size();
                for (int i = 0; i < size; ++i) {
                    FaCurDepartmentInfo departmentInfo = departmentColl.get(i);
                    if (departmentInfo != null && departmentInfo.getUseDepartment() != null) {
                        if ("true".equalsIgnoreCase(isDisDeptLName)) {
                            departmentsName.append(departmentInfo.getUseDepartment().getDisplayName());
                        } else {
                            departmentsName.append(departmentInfo.getUseDepartment().getName());
                        }
                        departmentsName.append("/");
                    }
                    if (departmentInfo == null || departmentInfo.getUsePerson() == null) continue;
                    departmentsUsePerson.append(departmentInfo.getUsePerson().getName());
                    departmentsUsePerson.append("/");
                }
                if (departmentsName.length() > 0) {
                    String departments = departmentsName.substring(0, departmentsName.length() - 1);
                    rs.updateString("facurdepartment.usedepartment.name", departments);
                } else if (this.allColumns.indexOf("facurdepartment.usedepartment.name") >= 0) {
                    rs.updateString("facurdepartment.usedepartment.name", "");
                }
                if (departmentsUsePerson.length() > 0) {
                    String personName = departmentsUsePerson.substring(0, departmentsUsePerson.length() - 1);
                    rs.updateString("facurdepartment.useperson.name", personName);
                } else if (this.allColumns.indexOf("facurdepartment.useperson.name") >= 0) {
                    rs.updateString("facurdepartment.useperson.name", "");
                }
                if (info.getEconomicPurp() != null) {
                    rs.updateString("economicPurp.name", info.getEconomicPurp().getName());
                } else if (this.allColumns.indexOf("economicPurp.name") >= 0) {
                    rs.updateString("economicPurp.name", "");
                }
                if (info.getOriginType() != null) {
                    rs.updateString("originType", info.getOriginType().toString());
                } else if (this.allColumns.indexOf("originType") >= 0) {
                    rs.updateString("originType", "");
                }
                rs.updateString("originunit", FaPrintServerHelper.transferFromUnit((FaCardInfo)sourceInfo, this.ctx));
                if (!info.isIsEvaledBefore()) {
                    rs.updateString("initEvalValue", "");
                    rs.updateString("evalLeftPeriod", "");
                }
                if (info.getAccountAsset() != null) {
                    rs.updateString("accountasset.name", info.getAccountAsset().getNumber() + "-" + info.getAccountAsset().getLongName());
                } else if (this.allColumns.indexOf("accountasset.name") >= 0) {
                    rs.updateString("accountasset.name", "");
                }
                if (info.getAccountAccuDepr() != null) {
                    rs.updateString("accountaccudepr.name", info.getAccountAccuDepr().getNumber() + "-" + info.getAccountAccuDepr().getLongName());
                } else if (this.allColumns.indexOf("accountaccudepr.name") >= 0) {
                    rs.updateString("accountaccudepr.name", "");
                }
                if (info.getAccountDecValue() != null) {
                    rs.updateString("accountdecvalue.name", info.getAccountDecValue().getNumber() + "-" + info.getAccountDecValue().getLongName());
                } else if (this.allColumns.indexOf("accountdecvalue.name") >= 0) {
                    rs.updateString("accountdecvalue.name", "");
                }
                rs.updateString("assetAmt", FaPrintServerHelper.transBigDecimalToStr(info.getAssetAmt()));
                rs.updateString("originAmt", FaPrintServerHelper.transBigDecimalToStr(info.getOriginAmt()));
                if (info.getAssetValue() != null && info.getInputTax() != null) {
                    info.setInputTax(info.getInputTax().setScale(info.getAssetValue().scale(), 4));
                    rs.updateString("inputTax", FaPrintServerHelper.transBigDecimalToStr(info.getInputTax()));
                }
                rs.updateString("assetValue", FaPrintServerHelper.transBigDecimalToStr(info.getAssetValue()));
                rs.updateString("buyValue", FaPrintServerHelper.transBigDecimalToStr(info.getBuyValue()));
                rs.updateString("buyAccuDepr", FaPrintServerHelper.transBigDecimalToStr(info.getBuyAccuDepr()));
                rs.updateString("initEvalValue", FaPrintServerHelper.transBigDecimalToStr(info.getInitEvalValue()));
                boolean isWorkLoadMethod = FaManageUtils.isWorkLoadMethod((FaDepreciationModeInfo)info.getDeprMethod());
                if (isWorkLoadMethod) {
                    if (info.getEvalLeftPeriod() != null) {
                        info.setEvalLeftPeriod(info.getEvalLeftPeriod().setScale(2));
                    }
                    rs.updateString("evalLeftPeriod", FaPrintServerHelper.transBigDecimalToStr(info.getEvalLeftPeriod()));
                } else {
                    if (info.getEvalLeftPeriod() != null) {
                        info.setEvalLeftPeriod(info.getEvalLeftPeriod().setScale(0));
                    }
                    rs.updateString("evalLeftPeriod", FaPrintServerHelper.transBigDecimalToStr(info.getEvalLeftPeriod()));
                }
                rs.updateString("useTermCount", FaPrintServerHelper.transBigDecimalToStr(info.getUseTermCount()));
                rs.updateString("deprTermCount", FaPrintServerHelper.transBigDecimalToStr(info.getDeprTermCount()));
                rs.updateString("accuDepr", FaPrintServerHelper.transBigDecimalToStr(info.getAccuDepr()));
                rs.updateString("accuDeprTYear", FaPrintServerHelper.transBigDecimalToStr(info.getAccuDeprTYear()));
                rs.updateString("neatRemValue", FaPrintServerHelper.transBigDecimalToStr(info.getNeatRemValue()));
                rs.updateString("decValue", FaPrintServerHelper.transBigDecimalToStr(info.getDecValue()));
                rs.updateString("neatValue", FaPrintServerHelper.transBigDecimalToStr(info.getNeatValue()));
                rs.updateString("neatAmt", FaPrintServerHelper.transBigDecimalToStr(info.getNeatAmt()));
                rs.updateString("accuDeprAll", FaPrintServerHelper.transBigDecimalToStr(info.getAccuDeprAll()));
                rs.updateString("addonFare", FaPrintServerHelper.transBigDecimalToStr(info.getAddonFare()));
                rs.updateString("fairValue", FaPrintServerHelper.transBigDecimalToStr(info.getFairValue()));
                rs.updateString("treatmentIncome", FaPrintServerHelper.transBigDecimalToStr(info.getTreatmentIncome()));
                rs.updateString("addons", FaPrintServerHelper.transBigDecimalToStr(info.getAddons()));
                if (info.getNeatLeftRate() != null) {
                    info.setNeatLeftRate(info.getNeatLeftRate().setScale(2));
                    rs.updateString("neatLeftRate", FaPrintServerHelper.transBigDecimalToStr(info.getNeatLeftRate()));
                }
                rs.updateString("printdate", FaPrintServerHelper.transDateToStr((Date)info.get("printdate")));
                rs.updateString("accountdate", FaPrintServerHelper.transDateToStr(info.getAccountDate()));
                rs.updateString("fiAccountDate", FaPrintServerHelper.transDateToStr(info.getFiAccountDate()));
                rs.updateString("levfrdate", FaPrintServerHelper.transDateToStr(info.getLevFrDate()));
                rs.updateString("deliverdate", FaPrintServerHelper.transDateToStr(info.getDeliverDate()));
                rs.updateString("startusedate", FaPrintServerHelper.transDateToStr(info.getStartUseDate()));
                if (!(this.faParameter == null || (isUseGroupNumber = this.faParameter.get("FA_030")) != null && Boolean.valueOf(isUseGroupNumber.toString()).booleanValue())) {
                    rs.updateString("groupNumber", "");
                }
                rs.updateBytes("attachmentImage", "".getBytes());
                AttachmentServerManager acm = AttachmentManagerFactory.getServerManager((Context)this.ctx);
                String boID = info.getId() != null ? info.getId().toString() : null;
                String[] strsStrings = acm.getAttachmentIDsByBoBOSType(boID);
                HashSet<String> idset = new HashSet<String>();
                for (int i = 0; i < strsStrings.length; ++i) {
                    idset.add(strsStrings[i]);
                }
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo("id", idset, CompareType.INCLUDE));
                AttachmentCollection attachments = AttachmentFactory.getLocalInstance((Context)this.ctx).getAttachmentCollection(view);
                for (int i = 0; i < attachments.size(); ++i) {
                    if (!"jpg".equals(attachments.get(i).getSimpleName().trim()) && !"bmp".equals(attachments.get(i).getSimpleName().trim())) continue;
                    rs.updateBytes("attachmentImage", attachments.get(i).getFile());
                    break;
                }
                if (info.getId() != null) {
                    String imageNumber = this.getImageNumber(new FaCurCardInfo().getBOSType().toString(), info.getId().toString());
                    rs.updateString("imageNumber", imageNumber);
                } else {
                    rs.updateString("imageNumber", "");
                }
                FaDefPropertyValueInfo value = (FaDefPropertyValueInfo)info.get("def");
                if (value != null) {
                    int i;
                    FaDefPropertyCollection pc = FaDefPropertyFactory.getLocalInstance((Context)this.ctx).getFaDefPropertyCollection();
                    HashMap<String, FaDefPropertyInfo> numberMap = new HashMap<String, FaDefPropertyInfo>();
                    for (i = 0; i < pc.size(); ++i) {
                        numberMap.put(pc.get(i).getNumber().toLowerCase(), pc.get(i));
                    }
                    int n = this.allColumns.size();
                    for (i = 0; i < n; ++i) {
                        String key = (String)this.allColumns.get(i);
                        if (!key.startsWith("def.")) continue;
                        String number = key.substring(4);
                        Object v = value.get(number);
                        String str = null;
                        if (v == null) {
                            str = "";
                        } else {
                            FaDefPropertyInfo p = (FaDefPropertyInfo)numberMap.get(number.toLowerCase());
                            if (p != null) {
                                if (p.getType().getValue() == 2) {
                                    Number num = (Number)v;
                                    BigDecimal bg = new BigDecimal(num.doubleValue());
                                    bg = bg.setScale(p.getDecimalQty(), 4);
                                    str = FaPrintServerHelper.transBigDecimalToStr(bg);
                                } else if (p.getType().getValue() == 4) {
                                    SimpleDateFormat sdf = (SimpleDateFormat)FaManageUtils.getDateFormat();
                                    str = sdf.format((Date)v);
                                } else {
                                    str = String.valueOf(v);
                                }
                            } else {
                                str = String.valueOf(v);
                            }
                        }
                        rs.updateString(key, str);
                    }
                }
            }

            @Override
            protected void afterDetailFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
                FaCurFacilityInfo facilityInfo = (FaCurFacilityInfo)sourceInfo;
                rs.updateString("faCurFacility.amount", FaPrintServerHelper.transBigDecimalToStr(facilityInfo.getAmount()));
                rs.updateString("faCurFacility.quantity", FaPrintServerHelper.transBigDecimalToStr(facilityInfo.getQuantity()));
                rs.updateString("facurfacility.registerdate", FaPrintServerHelper.transDateToStr(facilityInfo.getRegisterDate()));
            }
        };
        return data;
    }

    public static String getAsstActLName(FaCostCenterInfo costCenterInfo) {
        if (costCenterInfo instanceof FaCurCostCenterInfo) {
            FaCurCostCenterInfo curCostCenter = (FaCurCostCenterInfo)costCenterInfo;
            int size = curCostCenter.getFaCurAsstActComposit().size();
            StringBuffer asstActLName = new StringBuffer("");
            for (int i = 0; i < size; ++i) {
                String asstTypeName = "";
                AsstActTypeInfo asstType = curCostCenter.getFaCurAsstActComposit().get(i).getAsstActType();
                if (asstType != null && asstType.getName() != null) {
                    asstTypeName = curCostCenter.getFaCurAsstActComposit().get(i).getAsstActType().getName();
                }
                String asstItemName = "";
                AssistActItemInfo asstItem = curCostCenter.getFaCurAsstActComposit().get(i).getAsstActItem();
                if (asstItem != null && asstItem.getName() != null) {
                    asstItemName = curCostCenter.getFaCurAsstActComposit().get(i).getAsstActItem().getName();
                }
                asstActLName.append(asstTypeName);
                asstActLName.append("-");
                asstActLName.append(asstItemName);
                if (i == size - 1) continue;
                asstActLName.append("/");
            }
            return asstActLName.toString();
        }
        if (costCenterInfo instanceof FaMonCostCenterInfo) {
            FaMonCostCenterInfo curCostCenter = (FaMonCostCenterInfo)costCenterInfo;
            int size = curCostCenter.getFaMonAsstActComposit().size();
            StringBuffer asstActLName = new StringBuffer("");
            for (int i = 0; i < size; ++i) {
                String asstTypeName = "";
                AsstActTypeInfo asstType = curCostCenter.getFaMonAsstActComposit().get(i).getAsstActType();
                if (asstType != null && asstType.getName() != null) {
                    asstTypeName = asstType.getName();
                }
                String asstItemName = "";
                AssistActItemInfo asstItem = curCostCenter.getFaMonAsstActComposit().get(i).getAsstActItem();
                if (asstItem != null && asstItem.getName() != null) {
                    asstItemName = asstItem.getName();
                }
                asstActLName.append(asstTypeName);
                asstActLName.append("-");
                asstActLName.append(asstItemName);
                if (i == size - 1) continue;
                asstActLName.append(" ");
            }
            return asstActLName.toString();
        }
        return "";
    }

    public static BOSQueryDelegate getPrintManagerForFaInitCardEditUI(IObjectCollection collection, Context ctx) throws Exception {
        FaPrintServerHelper.beforeBuildData(collection, ctx);
        AbstractFaPrintManager data = new AbstractFaPrintManager(collection, ctx){
            CompanyOrgUnitInfo company;
            int basePrecision;
            Map faParameter;
            {
                this.company = ContextUtil.getCurrentFIUnit((Context)this.ctx);
                this.basePrecision = FaManageUtils.getCurrencyScale(this.company, this.ctx);
                this.faParameter = FaManageUtils.getFAParameter(this.company.getId(), this.ctx);
            }

            @Override
            public IRowSet execute(BOSQueryDataSource ds) {
                return this.getDefaltRowSet(ds, columsForCard, "faMonFacility");
            }

            @Override
            protected List beforeBuildColumn(List columns) {
                if (!columns.contains("famoncostcenter.asstacttype.name")) {
                    columns.add("famoncostcenter.asstacttype.name");
                }
                return columns;
            }

            @Override
            protected void afterHeadFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
                Object isUseGroupNumber;
                String isDisDeptLName = this.faParameter.get("FA_025") == null ? "false" : (String)this.faParameter.get("FA_025");
                FaMonCardInfo info = (FaMonCardInfo)sourceInfo;
                if (info == null) {
                    return;
                }
                FaMonCostCenterCollection collection = info.getFaMonCostCenter();
                StringBuffer costCenterName = new StringBuffer();
                for (int i = 0; i < collection.size(); ++i) {
                    FaMonCostCenterInfo costCenter = collection.get(i);
                    String typeName = "";
                    if (costCenter.getAsstActType() != null) {
                        typeName = costCenter.getAsstActType().getName() == null ? "" : costCenter.getAsstActType().getName();
                    }
                    String name = "";
                    if (costCenter.getAsstActItem() != null) {
                        name = costCenter.getAsstActItem().getName() == null ? "" : costCenter.getAsstActItem().getName();
                    }
                    String account = costCenter.getAccountView() == null ? "" : costCenter.getAccountView().getNumber() + "-" + costCenter.getAccountView().getLongName();
                    String scale = costCenter.getApportionScale() == null ? "" : costCenter.getApportionScale().setScale(2).toString() + "%";
                    costCenterName.append(i == 0 ? "" : "; ").append("".equals(account) ? "" : account).append(" ").append(scale).append(" ").append(FaPrintServerHelper.getAsstActLName(collection.get(i)));
                }
                if (!"".equals(costCenterName.toString().trim())) {
                    rs.updateString("famoncostcenter.asstacttype.name", costCenterName.toString());
                }
                FaMonDepartmentCollection departmentColl = info.getFaMonDepartment();
                StringBuffer departmentsName = new StringBuffer();
                StringBuffer departmentsUsePerson = new StringBuffer();
                int size = departmentColl.size();
                for (int i = 0; i < size; ++i) {
                    FaMonDepartmentInfo departmentInfo = departmentColl.get(i);
                    if (departmentInfo != null && departmentInfo.getUseDepartment() != null) {
                        if ("true".equalsIgnoreCase(isDisDeptLName)) {
                            departmentsName.append(departmentInfo.getUseDepartment().getDisplayName());
                        } else {
                            departmentsName.append(departmentInfo.getUseDepartment().getName());
                        }
                        departmentsName.append("/");
                    }
                    if (departmentInfo == null || departmentInfo.getUsePerson() == null) continue;
                    departmentsUsePerson.append(departmentInfo.getUsePerson().getName());
                    departmentsUsePerson.append("/");
                }
                if (departmentsName.length() > 0) {
                    String departments = departmentsName.substring(0, departmentsName.length() - 1);
                    rs.updateString("famondepartment.usedepartment.name", departments);
                }
                if (departmentsUsePerson.length() > 0) {
                    String personName = departmentsUsePerson.substring(0, departmentsUsePerson.length() - 1);
                    rs.updateString("famondepartment.useperson.name", personName);
                }
                if (info.getEconomicPurp() != null) {
                    rs.updateString("economicPurp.name", info.getEconomicPurp().getName());
                }
                if (info.getOriginType() != null) {
                    rs.updateString("originType", info.getOriginType().toString());
                }
                rs.updateString("originunit", FaPrintServerHelper.transferFromUnit((FaCardInfo)sourceInfo, this.ctx));
                if (!info.isIsEvaledBefore()) {
                    rs.updateString("initEvalValue", "");
                    rs.updateString("evalLeftPeriod", "");
                }
                if (info.getAccountAsset() != null) {
                    rs.updateString("accountasset.name", info.getAccountAsset().getNumber() + "-" + info.getAccountAsset().getLongName());
                }
                if (info.getAccountAccuDepr() != null) {
                    rs.updateString("accountaccudepr.name", info.getAccountAccuDepr().getNumber() + "-" + info.getAccountAccuDepr().getLongName());
                }
                if (info.getAccountDecValue() != null) {
                    rs.updateString("accountdecvalue.name", info.getAccountDecValue().getNumber() + "-" + info.getAccountDecValue().getLongName());
                }
                rs.updateString("assetAmt", FaPrintServerHelper.transBigDecimalToStr(info.getAssetAmt()));
                rs.updateString("originAmt", FaPrintServerHelper.transBigDecimalToStr(info.getOriginAmt()));
                if (info.getAssetValue() != null && info.getInputTax() != null) {
                    info.setInputTax(info.getInputTax().setScale(info.getAssetValue().scale(), 4));
                    rs.updateString("inputTax", FaPrintServerHelper.transBigDecimalToStr(info.getInputTax()));
                }
                rs.updateString("assetValue", FaPrintServerHelper.transBigDecimalToStr(info.getAssetValue()));
                rs.updateString("buyValue", FaPrintServerHelper.transBigDecimalToStr(info.getBuyValue()));
                rs.updateString("buyAccuDepr", FaPrintServerHelper.transBigDecimalToStr(info.getBuyAccuDepr()));
                rs.updateString("initEvalValue", FaPrintServerHelper.transBigDecimalToStr(info.getInitEvalValue()));
                boolean isWorkLoadMethod = FaManageUtils.isWorkLoadMethod((FaDepreciationModeInfo)info.getDeprMethod());
                if (isWorkLoadMethod) {
                    if (info.getEvalLeftPeriod() != null) {
                        info.setEvalLeftPeriod(info.getEvalLeftPeriod().setScale(2));
                    }
                    rs.updateString("evalLeftPeriod", FaPrintServerHelper.transBigDecimalToStr(info.getEvalLeftPeriod()));
                    if (info.getUseTermCount() != null) {
                        info.setUseTermCount(info.getUseTermCount().setScale(2));
                    }
                    rs.updateString("useTermCount", FaPrintServerHelper.transBigDecimalToStr(info.getUseTermCount()));
                    if (info.getDeprTermCount() != null) {
                        info.setDeprTermCount(info.getDeprTermCount().setScale(2));
                    }
                    rs.updateString("deprTermCount", FaPrintServerHelper.transBigDecimalToStr(info.getDeprTermCount()));
                } else {
                    if (info.getEvalLeftPeriod() != null) {
                        info.setEvalLeftPeriod(info.getEvalLeftPeriod().setScale(0));
                    }
                    rs.updateString("evalLeftPeriod", FaPrintServerHelper.transBigDecimalToStr(info.getEvalLeftPeriod()));
                    rs.updateString("useTermCount", FaPrintServerHelper.transBigDecimalToStr(info.getUseTermCount()));
                    rs.updateString("deprTermCount", FaPrintServerHelper.transBigDecimalToStr(info.getDeprTermCount()));
                }
                rs.updateString("accuDepr", FaPrintServerHelper.transBigDecimalToStr(info.getAccuDepr()));
                rs.updateString("accuDeprTYear", FaPrintServerHelper.transBigDecimalToStr(info.getAccuDeprTYear()));
                rs.updateString("neatRemValue", FaPrintServerHelper.transBigDecimalToStr(info.getNeatRemValue()));
                rs.updateString("decValue", FaPrintServerHelper.transBigDecimalToStr(info.getDecValue()));
                rs.updateString("neatValue", FaPrintServerHelper.transBigDecimalToStr(info.getNeatValue()));
                rs.updateString("neatAmt", FaPrintServerHelper.transBigDecimalToStr(info.getNeatAmt()));
                rs.updateString("accuDeprAll", FaPrintServerHelper.transBigDecimalToStr(info.getAccuDeprAll()));
                rs.updateString("addonFare", FaPrintServerHelper.transBigDecimalToStr(info.getAddonFare()));
                rs.updateString("fairValue", FaPrintServerHelper.transBigDecimalToStr(info.getFairValue()));
                rs.updateString("treatmentIncome", FaPrintServerHelper.transBigDecimalToStr(info.getTreatmentIncome()));
                rs.updateString("addons", FaPrintServerHelper.transBigDecimalToStr(info.getAddons()));
                if (info.getNeatLeftRate() != null) {
                    info.setNeatLeftRate(info.getNeatLeftRate().setScale(2));
                    rs.updateString("neatLeftRate", FaPrintServerHelper.transBigDecimalToStr(info.getNeatLeftRate()));
                }
                if (info.getFaMonInitData() != null) {
                    FaMonInitDataInfo initDataInfo = info.getFaMonInitData().get(0);
                    rs.updateString("faMonInitData.assetAmtDecQty", FaPrintServerHelper.transBigDecimalToStr(initDataInfo.getAssetAmtDecQty()));
                    rs.updateString("faMonInitData.assetAmtIncQty", FaPrintServerHelper.transBigDecimalToStr(initDataInfo.getAssetAmtIncQty()));
                    rs.updateString("faMonInitData.assetAmtBeginQty", FaPrintServerHelper.transBigDecimalToStr(initDataInfo.getAssetAmtBeginQty()));
                    rs.updateString("faMonInitData.decValueDecQty", FaPrintServerHelper.transBigDecimalToStr(initDataInfo.getDecValueDecQty()));
                    rs.updateString("faMonInitData.decValueIncQty", FaPrintServerHelper.transBigDecimalToStr(initDataInfo.getDecValueIncQty()));
                    rs.updateString("faMonInitData.decValueBeginQty", FaPrintServerHelper.transBigDecimalToStr(initDataInfo.getDecValueBeginQty()));
                    rs.updateString("faMonInitData.deprIncQty", FaPrintServerHelper.transBigDecimalToStr(initDataInfo.getDeprIncQty()));
                    rs.updateString("faMonInitData.deprDecQty", FaPrintServerHelper.transBigDecimalToStr(initDataInfo.getDeprDecQty()));
                    rs.updateString("faMonInitData.deprBeginQty", FaPrintServerHelper.transBigDecimalToStr(initDataInfo.getDeprBeginQty()));
                    rs.updateString("faMonInitData.originDecQty", FaPrintServerHelper.transBigDecimalToStr(initDataInfo.getOriginDecQty()));
                    rs.updateString("faMonInitData.originIncQty", FaPrintServerHelper.transBigDecimalToStr(initDataInfo.getOriginIncQty()));
                    rs.updateString("faMonInitData.originBeginQty", FaPrintServerHelper.transBigDecimalToStr(initDataInfo.getOriginBeginQty()));
                }
                if (!(this.faParameter == null || (isUseGroupNumber = this.faParameter.get("FA_030")) != null && Boolean.valueOf(isUseGroupNumber.toString()).booleanValue())) {
                    rs.updateString("groupNumber", "");
                }
                rs.updateString("printdate", FaPrintServerHelper.transDateToStr((Date)info.get("printdate")));
                rs.updateString("accountdate", FaPrintServerHelper.transDateToStr(info.getAccountDate()));
                rs.updateString("fiAccountDate", FaPrintServerHelper.transDateToStr(info.getFiAccountDate()));
                rs.updateString("levfrdate", FaPrintServerHelper.transDateToStr(info.getLevFrDate()));
                rs.updateString("deliverdate", FaPrintServerHelper.transDateToStr(info.getDeliverDate()));
                rs.updateString("startusedate", FaPrintServerHelper.transDateToStr(info.getStartUseDate()));
            }

            @Override
            protected void afterDetailFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
                FaMonFacilityInfo facilityInfo = (FaMonFacilityInfo)sourceInfo;
                rs.updateString("faMonFacility.amount", FaPrintServerHelper.transBigDecimalToStr(facilityInfo.getAmount().setScale(this.basePrecision, 4)));
                rs.updateString("faMonFacility.quantity", FaPrintServerHelper.transBigDecimalToStr(facilityInfo.getQuantity()));
                if (facilityInfo.getRegisterDate() != null) {
                    rs.updateString("famonfacility.registerdate", FaPrintServerHelper.transDateToStr(facilityInfo.getRegisterDate()));
                }
            }
        };
        return data;
    }

    public static BOSQueryDelegate getPrintManagerForFaChangeBillListUI(IObjectCollection collection, Context ctx) throws Exception {
        return FaPrintServerHelper.getPrintManagerForFaCurCardListUI(collection, ctx);
    }

    public static BOSQueryDelegate getPrintManagerForFaEvalueBillEditUI(IObjectCollection collection, final KDTable[] tables, Context ctx) throws Exception {
        FaPrintServerHelper.beforeBuildData(collection, ctx);
        AbstractFaPrintManager data = new AbstractFaPrintManager(collection, ctx){
            CompanyOrgUnitInfo company;
            int basePrecision;
            {
                super(collection, ctx);
                this.company = ContextUtil.getCurrentFIUnit((Context)this.ctx);
                this.basePrecision = FaManageUtils.getCurrencyScale(this.company, this.ctx);
            }

            @Override
            public IRowSet execute(BOSQueryDataSource ds) {
                return this.getDefaltRowSet(ds, tables);
            }

            @Override
            protected List beforeBuildColumn(List columns) {
                if (!columns.contains("faEvaluateBillEntry.id")) {
                    columns.add("faEvaluateBillEntry.id");
                }
                if (!columns.contains("faEvaluateBillEntry.faCurCard.id")) {
                    columns.add("faEvaluateBillEntry.faCurCard.id");
                }
                if (!columns.contains("faEvaluateBillEntry.faBizCard.id")) {
                    columns.add("faEvaluateBillEntry.faBizCard.id");
                }
                if (!columns.contains("faEvaluateBillEntry.faCurCard.lastUpdateTime")) {
                    columns.add("faEvaluateBillEntry.faCurCard.lastUpdateTime");
                }
                if (!columns.contains("faEvaluateBillEntry.faBizCard.number")) {
                    columns.add("faEvaluateBillEntry.faBizCard.number");
                }
                if (!columns.contains("faEvaluateBillEntry.faBizCard.assetCat.name")) {
                    columns.add("faEvaluateBillEntry.faBizCard.assetCat.name");
                }
                if (!columns.contains("faEvaluateBillEntry.faBizCard.assetCat.number")) {
                    columns.add("faEvaluateBillEntry.faBizCard.assetCat.number");
                }
                if (!columns.contains("faEvaluateBillEntry.faBizCard.deprmethod.number")) {
                    columns.add("faEvaluateBillEntry.faBizCard.deprmethod.number");
                }
                if (!columns.contains("faEvaluateBillEntry.faBizCard.assetName")) {
                    columns.add("faEvaluateBillEntry.faBizCard.assetName");
                }
                if (!columns.contains("faEvaluateBillEntry.faBizCard.specs")) {
                    columns.add("faEvaluateBillEntry.faBizCard.specs");
                }
                if (!columns.contains("faEvaluateBillEntry.faBizCard.measureUnit.name")) {
                    columns.add("faEvaluateBillEntry.faBizCard.measureUnit.name");
                }
                if (!columns.contains("faEvaluateBillEntry.faEvaValue.Asset")) {
                    columns.add("faEvaluateBillEntry.faEvaValue.Asset");
                }
                if (!columns.contains("faEvaluateBillEntry.faEvaValue.neatValue")) {
                    columns.add("faEvaluateBillEntry.faEvaValue.neatValue");
                }
                if (!columns.contains("faEvaluateBillEntry.faEvaValue.AssetEvaValue")) {
                    columns.add("faEvaluateBillEntry.faEvaValue.AssetEvaValue");
                }
                if (!columns.contains("faEvaluateBillEntry.faEvaValue.leftYear")) {
                    columns.add("faEvaluateBillEntry.faEvaValue.leftYear");
                }
                if (!columns.contains("faEvaluateBillEntry.faEvaValue.leftYearEvalue")) {
                    columns.add("faEvaluateBillEntry.faEvaValue.leftYearEvalue");
                }
                if (!columns.contains("faEvaluateBillEntry.description")) {
                    columns.add("faEvaluateBillEntry.description");
                }
                if (!columns.contains("evaItem")) {
                    columns.add("evaItem");
                }
                return columns;
            }

            @Override
            protected void afterHeadFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
                FaEvaluateBillInfo evaBillInfo = (FaEvaluateBillInfo)sourceInfo;
                FaEvaluateBillEntryCollection evaluateBillEntryColl = evaBillInfo.getFaEvaluateBillEntry();
                String evaItem = "0";
                boolean ASSETVALUE = false;
                boolean ODDUSELIFE = false;
                int size = evaluateBillEntryColl.size();
                for (int i = 0; i < size; ++i) {
                    FaEvaValueCollection evaValueColl = evaluateBillEntryColl.get(i).getEvaValue();
                    int count = evaValueColl.size();
                    for (int j = 0; j < count; ++j) {
                        EvaItemEnum evaItemEnum = evaValueColl.get(j).getMainType();
                        if (evaItemEnum.equals((Object)EvaItemEnum.ASSETVALUE)) {
                            ASSETVALUE = true;
                            continue;
                        }
                        if (!evaItemEnum.equals((Object)EvaItemEnum.ODDUSELIFE)) continue;
                        ODDUSELIFE = true;
                    }
                }
                if (ASSETVALUE && ODDUSELIFE) {
                    evaItem = "11";
                } else if (ASSETVALUE) {
                    evaItem = "10";
                } else if (ODDUSELIFE) {
                    evaItem = "01";
                }
                rs.updateString("evaItem", evaItem);
                rs.updateString("creator", evaBillInfo.getCreator() == null ? "" : evaBillInfo.getCreator().getName());
                rs.updateString("auditor", evaBillInfo.getAuditor() == null ? "" : evaBillInfo.getAuditor().getName());
                String year = EASCommonResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose.year", (Locale)this.ctx.getOriginLocale());
                rs.updateString("validityYear", evaBillInfo.getValidityYear().intValue() + year);
                rs.updateString("printdate", FaPrintServerHelper.transDateToStr((Date)evaBillInfo.get("printdate")));
                rs.updateString("benchmarkDate", FaPrintServerHelper.transDateToStr(evaBillInfo.getBenchmarkDate()));
                rs.updateString("beginDate", FaPrintServerHelper.transDateToStr(evaBillInfo.getBeginDate()));
                rs.updateString("endDate", FaPrintServerHelper.transDateToStr(evaBillInfo.getEndDate()));
                rs.updateString("adjustDate", FaPrintServerHelper.transDateToStr(evaBillInfo.getAdjustDate()));
                rs.updateString("createTime", FaPrintServerHelper.transDateToStr(evaBillInfo.getCreateTime()));
                rs.updateString("auditTime", FaPrintServerHelper.transDateToStr(evaBillInfo.getAuditTime()));
            }

            @Override
            protected ArrayList getAllKey(IObjectValue sourceInfo, String upper) {
                ArrayList<String> result = new ArrayList<String>();
                Enumeration enumKeys = sourceInfo.keys();
                while (enumKeys.hasMoreElements()) {
                    String key = enumKeys.nextElement().toString();
                    result.add(upper + key);
                }
                return result;
            }

            @Override
            protected void insertRowFromInfo(IObjectValue sourceInfo, IRowSet rs, String upper) throws Exception {
                Enumeration enumKeys = sourceInfo.keys();
                while (enumKeys.hasMoreElements()) {
                    String key = enumKeys.nextElement().toString();
                    Object info = sourceInfo.get(key);
                    rs.updateString(upper + key, this.convertObject(info));
                }
            }

            @Override
            protected void insertRowFromKDTable(IRowSet rs, KDTable[] tables2, IObjectValue sourceInfo) throws Exception {
                for (int tableCount = 0; tableCount < tables2.length; ++tableCount) {
                    KDTable table = tables2[tableCount];
                    String key = "";
                    if (table.getRowCount() == 0) {
                        rs.insertRow();
                    }
                    int n = table.getRowCount();
                    for (int i = 0; i < n; ++i) {
                        IRow row = table.getRow(i);
                        IObjectValue obj = (IObjectValue)row.getUserObject();
                        if (i == 0) {
                            key = this.getEntryName(sourceInfo, obj, "");
                        } else {
                            rs.moveToInsertRow();
                            this.insertRowFromInfo(sourceInfo, rs, "");
                            this.afterHeadFill(rs, sourceInfo);
                        }
                        FaEvaluateBillInfo evaluateBillInfo = (FaEvaluateBillInfo)sourceInfo;
                        FaEvaluateBillEntryCollection coll = (FaEvaluateBillEntryCollection)((Object)evaluateBillInfo.get("faEvaluateBillEntry"));
                        this.updateRowFromKDTable(table, rs, row, (IObjectValue)coll.get(i), key);
                        rs.insertRow();
                    }
                }
            }

            @Override
            protected void afterDetailFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
                FaEvaValueCollection evaValueColl;
                FaEvaluateBillEntryInfo info = (FaEvaluateBillEntryInfo)sourceInfo;
                Boolean isWorkLoadMethod = (Boolean)info.getFaCurCard().get("isWorkLoadMethod");
                int scale = 0;
                if (isWorkLoadMethod != null && isWorkLoadMethod.booleanValue()) {
                    scale = 2;
                }
                if ((evaValueColl = info.getEvaValue()) != null && !evaValueColl.isEmpty()) {
                    int count = evaValueColl.size();
                    for (int j = 0; j < count; ++j) {
                        String strEvaValue;
                        FaEvaValueInfo evaValueInfo = evaValueColl.get(j);
                        BigDecimal evaValue = evaValueInfo.getEvaValue();
                        if (evaValueInfo.getMainType().equals((Object)EvaItemEnum.ASSETVALUE)) {
                            strEvaValue = FaPrintServerHelper.transBigDecimalToStr(evaValue.setScale(this.basePrecision, 4));
                            if (evaValueInfo.getSubType().equals((Object)EvaItemDetailEnum.ASSET_ASSET)) {
                                rs.updateString("faEvaluateBillEntry.faEvaValue.Asset", strEvaValue);
                                continue;
                            }
                            if (evaValueInfo.getSubType().equals((Object)EvaItemDetailEnum.ASSET_NEATVALUE)) {
                                rs.updateString("faEvaluateBillEntry.faEvaValue.neatValue", strEvaValue);
                                continue;
                            }
                            if (!evaValueInfo.getSubType().equals((Object)EvaItemDetailEnum.EAV_VALUE)) continue;
                            rs.updateString("faEvaluateBillEntry.faEvaValue.AssetEvaValue", strEvaValue);
                            continue;
                        }
                        if (!evaValueInfo.getMainType().equals((Object)EvaItemEnum.ODDUSELIFE)) continue;
                        strEvaValue = FaPrintServerHelper.transBigDecimalToStr(evaValue.setScale(scale, 4));
                        if (evaValueInfo.getSubType().equals((Object)EvaItemDetailEnum.ODDUSELIFE_LEFTYEAR)) {
                            rs.updateString("faEvaluateBillEntry.faEvaValue.leftYear", strEvaValue);
                            continue;
                        }
                        if (!evaValueInfo.getSubType().equals((Object)EvaItemDetailEnum.EAV_VALUE)) continue;
                        rs.updateString("faEvaluateBillEntry.faEvaValue.leftYearEvalue", strEvaValue);
                    }
                }
            }
        };
        return data;
    }

    public static BOSQueryDelegate getPrintManagerForFaLeaseBillEditUI(IObjectCollection collection, final KDTable[] tables, Context ctx) throws Exception {
        FaPrintServerHelper.beforeBuildData(collection, ctx);
        AbstractFaPrintManager data = new AbstractFaPrintManager(collection, ctx){
            CompanyOrgUnitInfo company;
            int basePrecision;
            int hireScale;
            Map faParameter;
            int quantityScale;
            {
                super(collection, ctx);
                this.company = ContextUtil.getCurrentFIUnit((Context)this.ctx);
                this.hireScale = this.basePrecision = FaManageUtils.getCurrencyScale(this.company, this.ctx);
                this.faParameter = FaManageUtils.getFAParameter(this.company.getId(), this.ctx);
                this.quantityScale = Integer.valueOf(this.faParameter.get("FA_008") == null ? "0" : (String)this.faParameter.get("FA_008"));
            }

            @Override
            public IRowSet execute(BOSQueryDataSource ds) {
                return this.getDefaltRowSet(ds, tables);
            }

            @Override
            protected void afterHeadFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
                CurrencyInfo hireCurrency;
                String measureUnit = DateUnitEnum.getEnum(rs.getInt("measureUnit")).getAlias();
                String newValue = rs.getString("bargainTime") + " " + measureUnit;
                rs.updateString("bargainTime", newValue);
                FaLeaseBillInfo leaseBillInfo = (FaLeaseBillInfo)sourceInfo;
                if (leaseBillInfo.getHireNaturalAmt() != null) {
                    rs.updateString("hireNaturalAmt", FaPrintServerHelper.transBigDecimalToStr(leaseBillInfo.getHireNaturalAmt().setScale(this.basePrecision, 4)));
                }
                if (leaseBillInfo.getSubsNaturalAmt() != null) {
                    rs.updateString("subsNaturalAmt", FaPrintServerHelper.transBigDecimalToStr(leaseBillInfo.getSubsNaturalAmt().setScale(this.basePrecision, 4)));
                }
                if ((hireCurrency = leaseBillInfo.getHireCurrency()) != null) {
                    this.hireScale = hireCurrency.getPrecision();
                }
                if (leaseBillInfo.getHireNaturalAmt() != null) {
                    rs.updateString("hireOriginAmt", FaPrintServerHelper.transBigDecimalToStr(leaseBillInfo.getHireOriginAmt().setScale(this.hireScale, 4)));
                }
                int subsScale = this.basePrecision;
                CurrencyInfo subsCurrency = leaseBillInfo.getSubsCurrency();
                if (subsCurrency != null) {
                    subsScale = subsCurrency.getPrecision();
                }
                if (leaseBillInfo.getSubsOriginAmt() != null) {
                    rs.updateString("subsOriginAmt", FaPrintServerHelper.transBigDecimalToStr(leaseBillInfo.getSubsOriginAmt().setScale(subsScale, 4)));
                }
                if (leaseBillInfo.getMeasureUnit() != null) {
                    rs.updateString("measureUnit", DateUnitEnum.getEnum(leaseBillInfo.getMeasureUnit().getValue()).getAlias());
                }
                rs.updateString("printdate", FaPrintServerHelper.transDateToStr((Date)leaseBillInfo.get("printdate")));
                rs.updateString("signatureDate", FaPrintServerHelper.transDateToStr(leaseBillInfo.getSignatureDate()));
                rs.updateString("beginDate", FaPrintServerHelper.transDateToStr(leaseBillInfo.getBeginDate()));
                rs.updateString("endDate", FaPrintServerHelper.transDateToStr(leaseBillInfo.getEndDate()));
                rs.updateString("deliverDate", FaPrintServerHelper.transDateToStr(leaseBillInfo.getDeliverDate()));
                rs.updateString("createTime", FaPrintServerHelper.transDateToStr(leaseBillInfo.getCreateTime()));
                rs.updateString("auditTime", FaPrintServerHelper.transDateToStr(leaseBillInfo.getAuditTime()));
            }

            @Override
            protected void afterDetailFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
                if (rs.getString("faLeaseBillEntry.hasInsurance").equals("true")) {
                    String haveStr = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaLeaseResource", (String)"Print_Have");
                    rs.updateString("faLeaseBillEntry.hasInsurance", haveStr);
                } else {
                    String noStr = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaLeaseResource", (String)"Print_No");
                    rs.updateString("faLeaseBillEntry.hasInsurance", noStr);
                }
                FaLeaseBillEntryInfo leaseBillEntryInfo = (FaLeaseBillEntryInfo)sourceInfo;
                rs.updateString("faLeaseBillEntry.faBizCard.assetAmt", FaPrintServerHelper.transBigDecimalToStr(leaseBillEntryInfo.getFaBizCard().getAssetAmt().setScale(this.quantityScale, 4)));
                rs.updateString("faLeaseBillEntry.quantity", FaPrintServerHelper.transBigDecimalToStr(leaseBillEntryInfo.getQuantity().setScale(this.quantityScale, 4)));
                if (leaseBillEntryInfo.getAssetValue() != null) {
                    rs.updateString("faLeaseBillEntry.assetValue", FaPrintServerHelper.transBigDecimalToStr(leaseBillEntryInfo.getAssetValue().setScale(this.basePrecision, 4)));
                }
                if (leaseBillEntryInfo.getMonOriginHireAmt() != null) {
                    rs.updateString("faLeaseBillEntry.monOriginHireAmt", FaPrintServerHelper.transBigDecimalToStr(leaseBillEntryInfo.getMonOriginHireAmt().setScale(this.hireScale, 4)));
                }
                if (leaseBillEntryInfo.getMonLocalHireAmt() != null) {
                    rs.updateString("faLeaseBillEntry.monLocalHireAmt", FaPrintServerHelper.transBigDecimalToStr(leaseBillEntryInfo.getMonLocalHireAmt().setScale(this.basePrecision, 4)));
                }
                if (leaseBillEntryInfo.getHireOriginAmt() != null) {
                    rs.updateString("faLeaseBillEntry.hireOriginAmt", FaPrintServerHelper.transBigDecimalToStr(leaseBillEntryInfo.getHireOriginAmt().setScale(this.hireScale, 4)));
                }
                if (leaseBillEntryInfo.getHireLocalAmt() != null) {
                    rs.updateString("faLeaseBillEntry.hireLocalAmt", FaPrintServerHelper.transBigDecimalToStr(leaseBillEntryInfo.getHireLocalAmt().setScale(this.basePrecision, 4)));
                }
                if (leaseBillEntryInfo.getEvaluateValue() != null) {
                    rs.updateString("faLeaseBillEntry.evaluateValue", FaPrintServerHelper.transBigDecimalToStr(leaseBillEntryInfo.getEvaluateValue().setScale(this.basePrecision, 4)));
                }
                if (leaseBillEntryInfo.getInitAmt() != null) {
                    rs.updateString("faLeaseBillEntry.initAmt", FaPrintServerHelper.transBigDecimalToStr(leaseBillEntryInfo.getInitAmt().setScale(this.basePrecision, 4)));
                }
                if (leaseBillEntryInfo.getUnAssuredAmt() != null) {
                    rs.updateString("faLeaseBillEntry.unAssuredAmt", FaPrintServerHelper.transBigDecimalToStr(leaseBillEntryInfo.getUnAssuredAmt().setScale(this.basePrecision, 4)));
                }
                if (leaseBillEntryInfo.getInsuranceAmt() != null) {
                    rs.updateString("faLeaseBillEntry.insuranceAmt", FaPrintServerHelper.transBigDecimalToStr(leaseBillEntryInfo.getInsuranceAmt().setScale(this.basePrecision, 4)));
                }
                if (leaseBillEntryInfo.getBailAmt() != null) {
                    rs.updateString("faLeaseBillEntry.bailAmt", FaPrintServerHelper.transBigDecimalToStr(leaseBillEntryInfo.getBailAmt().setScale(this.basePrecision, 4)));
                }
                if (leaseBillEntryInfo.getAttornAmt() != null) {
                    rs.updateString("faLeaseBillEntry.attornAmt", FaPrintServerHelper.transBigDecimalToStr(leaseBillEntryInfo.getAttornAmt().setScale(this.basePrecision, 4)));
                }
            }
        };
        return data;
    }

    public static BOSQueryDelegate getPrintManagerForFaLeaseInBillEditUI(IObjectCollection collection, final KDTable[] tables, Context ctx) throws Exception {
        FaPrintServerHelper.beforeBuildData(collection, ctx);
        AbstractFaPrintManager data = new AbstractFaPrintManager(collection, ctx){
            CompanyOrgUnitInfo company;
            int basePrecision;
            int hireScale;
            Map faParameter;
            int quantityScale;
            {
                super(collection, ctx);
                this.company = ContextUtil.getCurrentFIUnit((Context)this.ctx);
                this.hireScale = this.basePrecision = FaManageUtils.getCurrencyScale(this.company, this.ctx);
                this.faParameter = FaManageUtils.getFAParameter(this.company.getId(), this.ctx);
                this.quantityScale = Integer.valueOf(this.faParameter.get("FA_008") == null ? "0" : (String)this.faParameter.get("FA_008"));
            }

            @Override
            public IRowSet execute(BOSQueryDataSource ds) {
                return this.getDefaltRowSet(ds, tables);
            }

            @Override
            protected void afterHeadFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
                CurrencyInfo hireCurrency;
                String measureUnit = DateUnitEnum.getEnum(rs.getInt("measureUnit")).getAlias();
                FaLeaseInBillInfo leaseBillInfo = (FaLeaseInBillInfo)sourceInfo;
                if (leaseBillInfo.getBargainTime() != null) {
                    rs.updateString("bargainTime", FaPrintServerHelper.transBigDecimalToStr(leaseBillInfo.getBargainTime().setScale(0, 4)));
                } else {
                    rs.updateString("bargainTime", FaPrintServerHelper.transBigDecimalToStr(new BigDecimal(0).setScale(0, 4)));
                }
                String newValue = rs.getString("bargainTime") + " " + measureUnit;
                rs.updateString("bargainTime", newValue);
                if (leaseBillInfo.getHireNaturalAmt() != null) {
                    rs.updateString("hireNaturalAmt", FaPrintServerHelper.transBigDecimalToStr(leaseBillInfo.getHireNaturalAmt().setScale(this.basePrecision, 4)));
                }
                if (leaseBillInfo.getSubsNaturalAmt() != null) {
                    rs.updateString("subsNaturalAmt", FaPrintServerHelper.transBigDecimalToStr(leaseBillInfo.getSubsNaturalAmt().setScale(this.basePrecision, 4)));
                }
                if ((hireCurrency = leaseBillInfo.getHireCurrency()) != null) {
                    this.hireScale = hireCurrency.getPrecision();
                }
                if (leaseBillInfo.getHireNaturalAmt() != null) {
                    rs.updateString("hireOriginAmt", FaPrintServerHelper.transBigDecimalToStr(leaseBillInfo.getHireOriginAmt().setScale(this.hireScale, 4)));
                }
                int subsScale = this.basePrecision;
                CurrencyInfo subsCurrency = leaseBillInfo.getSubsCurrency();
                if (subsCurrency != null) {
                    subsScale = subsCurrency.getPrecision();
                }
                if (leaseBillInfo.getSubsOriginAmt() != null) {
                    rs.updateString("subsOriginAmt", FaPrintServerHelper.transBigDecimalToStr(leaseBillInfo.getSubsOriginAmt().setScale(subsScale, 4)));
                }
                if (leaseBillInfo.getMeasureUnit() != null) {
                    rs.updateString("measureUnit", DateUnitEnum.getEnum(leaseBillInfo.getMeasureUnit().getValue()).getAlias());
                }
                rs.updateString("printdate", FaPrintServerHelper.transDateToStr((Date)leaseBillInfo.get("printdate")));
                rs.updateString("signatureDate", FaPrintServerHelper.transDateToStr(leaseBillInfo.getSignatureDate()));
                rs.updateString("beginDate", FaPrintServerHelper.transDateToStr(leaseBillInfo.getBeginDate()));
                rs.updateString("endDate", FaPrintServerHelper.transDateToStr(leaseBillInfo.getEndDate()));
                rs.updateString("deliverDate", FaPrintServerHelper.transDateToStr(leaseBillInfo.getDeliverDate()));
                rs.updateString("createTime", FaPrintServerHelper.transDateToStr(leaseBillInfo.getCreateTime()));
                rs.updateString("auditTime", FaPrintServerHelper.transDateToStr(leaseBillInfo.getAuditTime()));
            }

            @Override
            protected void afterDetailFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
                if (rs.getString("entry.hasInsurance").equals("true")) {
                    String haveStr = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaLeaseResource", (String)"Print_Have");
                    rs.updateString("entry.hasInsurance", haveStr);
                } else {
                    String noStr = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaLeaseResource", (String)"Print_No");
                    rs.updateString("entry.hasInsurance", noStr);
                }
                FaLeaseInBillEntryInfo leaseBillEntryInfo = (FaLeaseInBillEntryInfo)sourceInfo;
                if (leaseBillEntryInfo.getAssetCat() != null) {
                    rs.updateString("entry.assetCat.name", leaseBillEntryInfo.getAssetCat().getName());
                }
                if (leaseBillEntryInfo.getMeasureUnit() != null) {
                    rs.updateString("entry.measureUnit.name", leaseBillEntryInfo.getMeasureUnit().getName());
                }
                rs.updateString("entry.quantity", FaPrintServerHelper.transBigDecimalToStr(leaseBillEntryInfo.getQuantity().setScale(this.quantityScale, 4)));
                if (leaseBillEntryInfo.getMonOriginHireAmt() != null) {
                    rs.updateString("entry.monOriginHireAmt", FaPrintServerHelper.transBigDecimalToStr(leaseBillEntryInfo.getMonOriginHireAmt().setScale(this.hireScale, 4)));
                }
                if (leaseBillEntryInfo.getMonLocalHireAmt() != null) {
                    rs.updateString("entry.monLocalHireAmt", FaPrintServerHelper.transBigDecimalToStr(leaseBillEntryInfo.getMonLocalHireAmt().setScale(this.basePrecision, 4)));
                }
                if (leaseBillEntryInfo.getHireOriginAmt() != null) {
                    rs.updateString("entry.hireOriginAmt", FaPrintServerHelper.transBigDecimalToStr(leaseBillEntryInfo.getHireOriginAmt().setScale(this.hireScale, 4)));
                }
                if (leaseBillEntryInfo.getHireLocalAmt() != null) {
                    rs.updateString("entry.hireLocalAmt", FaPrintServerHelper.transBigDecimalToStr(leaseBillEntryInfo.getHireLocalAmt().setScale(this.basePrecision, 4)));
                }
                if (leaseBillEntryInfo.getAssetValue() != null) {
                    rs.updateString("entry.assetValue", FaPrintServerHelper.transBigDecimalToStr(leaseBillEntryInfo.getAssetValue().setScale(this.basePrecision, 4)));
                }
                if (leaseBillEntryInfo.getFairAmt() != null) {
                    rs.updateString("entry.fairAmt", FaPrintServerHelper.transBigDecimalToStr(leaseBillEntryInfo.getFairAmt().setScale(this.basePrecision, 4)));
                }
                if (leaseBillEntryInfo.getInitAmt() != null) {
                    rs.updateString("entry.initAmt", FaPrintServerHelper.transBigDecimalToStr(leaseBillEntryInfo.getInitAmt().setScale(this.basePrecision, 4)));
                }
                if (leaseBillEntryInfo.getUnAssuredAmt() != null) {
                    rs.updateString("entry.unAssuredAmt", FaPrintServerHelper.transBigDecimalToStr(leaseBillEntryInfo.getUnAssuredAmt().setScale(this.basePrecision, 4)));
                }
                if (leaseBillEntryInfo.getInsuranceAmt() != null) {
                    rs.updateString("entry.insuranceAmt", FaPrintServerHelper.transBigDecimalToStr(leaseBillEntryInfo.getInsuranceAmt().setScale(this.basePrecision, 4)));
                }
                if (leaseBillEntryInfo.getBailAmt() != null) {
                    rs.updateString("entry.bailAmt", FaPrintServerHelper.transBigDecimalToStr(leaseBillEntryInfo.getBailAmt().setScale(this.basePrecision, 4)));
                }
                if (leaseBillEntryInfo.getAttornAmt() != null) {
                    rs.updateString("entry.attornAmt", FaPrintServerHelper.transBigDecimalToStr(leaseBillEntryInfo.getAttornAmt().setScale(this.basePrecision, 4)));
                }
                if (leaseBillEntryInfo.getDeprLife() != null) {
                    rs.updateString("entry.deprLife", FaPrintServerHelper.transBigDecimalToStr(leaseBillEntryInfo.getDeprLife().setScale(0, 4)));
                }
            }
        };
        return data;
    }

    public static BOSQueryDelegate getPrintManagerForFaStockingBillEditUI(IObjectCollection collection, final KDTable[] tables, Context ctx) throws Exception {
        IObjectValue editData;
        int i;
        ArrayList<Object> list = new ArrayList<Object>();
        for (i = 0; i < collection.size(); ++i) {
            editData = collection.getObject(i);
            list.add(editData.get("operator"));
        }
        FaPrintServerHelper.beforeBuildData(collection, ctx);
        for (i = 0; i < collection.size() && list.size() >= i + 1; ++i) {
            editData = collection.getObject(i);
            editData.put("operator", list.get(i));
        }
        AbstractFaPrintManager data = new AbstractFaPrintManager(collection, ctx){
            CompanyOrgUnitInfo company;
            Map faParameter;
            int quantityScale;
            {
                super(collection, ctx);
                this.company = ContextUtil.getCurrentFIUnit((Context)this.ctx);
                this.faParameter = FaManageUtils.getFAParameter(this.company.getId(), this.ctx);
                this.quantityScale = Integer.valueOf(this.faParameter.get("FA_008") == null ? "0" : (String)this.faParameter.get("FA_008"));
            }

            @Override
            protected List beforeBuildColumn(List columns) {
                if (!columns.contains("entries.differentAmt")) {
                    columns.add("entries.differentAmt");
                }
                if (!columns.contains("entries.assetcat")) {
                    columns.add("entries.assetcat");
                }
                if (!columns.contains("entries.useStatus")) {
                    columns.add("entries.useStatus");
                }
                if (!columns.contains("entries.usePerson.name".toLowerCase())) {
                    columns.add("entries.usePerson.name".toLowerCase());
                }
                if (!columns.contains("entries.keeper".toLowerCase())) {
                    columns.add("entries.keeper".toLowerCase());
                }
                if (!columns.contains("operator".toLowerCase())) {
                    columns.add("operator".toLowerCase());
                }
                if (!columns.contains("entries.groupNumber".toLowerCase())) {
                    columns.add("entries.groupNumber".toLowerCase());
                }
                return columns;
            }

            @Override
            public IRowSet execute(BOSQueryDataSource ds) {
                return this.getDefaltRowSet(ds, tables);
            }

            @Override
            protected void afterHeadFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
                FaStocktakingBillInfo stockingBillInfo = (FaStocktakingBillInfo)sourceInfo;
                if (stockingBillInfo.getCreateTime() != null) {
                    rs.updateString("creator.createTime", FaPrintServerHelper.transDateToStr(stockingBillInfo.getCreateTime()));
                }
                rs.updateString("printdate", FaPrintServerHelper.transDateToStr((Date)stockingBillInfo.get("printdate")));
                rs.updateString("beginDate", FaPrintServerHelper.transDateToStr(stockingBillInfo.getBeginDate()));
                rs.updateString("endDate", FaPrintServerHelper.transDateToStr(stockingBillInfo.getEndDate()));
                rs.updateString("audittime", FaPrintServerHelper.transDateToStr(stockingBillInfo.getAuditTime()));
            }

            @Override
            protected void afterDetailFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
                FaStocktakingBillEntryInfo stockingBillEntryInfo = (FaStocktakingBillEntryInfo)sourceInfo;
                rs.updateString("entries.assetAmt", FaPrintServerHelper.transBigDecimalToStr(stockingBillEntryInfo.getAssetAmt().setScale(this.quantityScale, 4)));
                rs.updateString("entries.stocktakingAmt", FaPrintServerHelper.transBigDecimalToStr(stockingBillEntryInfo.getStocktakingAmt().setScale(this.quantityScale, 4)));
                BigDecimal differentAmt = new BigDecimal("0.0");
                if (stockingBillEntryInfo.getStocktakingAmt() != null && stockingBillEntryInfo.getAssetAmt() != null) {
                    differentAmt = stockingBillEntryInfo.getStocktakingAmt().subtract(stockingBillEntryInfo.getAssetAmt());
                }
                rs.updateString("entries.differentAmt", FaPrintServerHelper.transBigDecimalToStr(differentAmt.setScale(this.quantityScale, 4)));
                if (stockingBillEntryInfo.getAssetCat() != null) {
                    rs.updateString("entries.assetCat.name", stockingBillEntryInfo.getAssetCat().getName());
                }
                if (stockingBillEntryInfo.getUsePerson() != null) {
                    rs.updateString("entries.usePerson.name".toLowerCase(), stockingBillEntryInfo.getUsePerson().getName());
                }
                if (stockingBillEntryInfo.getUseStatus() != null) {
                    rs.updateString("entries.useStatus.name", stockingBillEntryInfo.getUseStatus().getName());
                }
                if (stockingBillEntryInfo.getGroupNumber() != null) {
                    rs.updateString("entries.groupNumber".toLowerCase(), stockingBillEntryInfo.getGroupNumber());
                }
            }
        };
        return data;
    }

    public static BOSQueryDelegate getPrintManagerForFaRequisitionedBillEditUI(IObjectCollection collection, final KDTable[] tables, Context ctx) throws Exception {
        FaPrintServerHelper.beforeBuildData(collection, ctx);
        AbstractFaPrintManager data = new AbstractFaPrintManager(collection, ctx){
            CompanyOrgUnitInfo company;
            int basePrecision;
            Map faParameter;
            int quantityScale;
            {
                super(collection, ctx);
                this.company = ContextUtil.getCurrentFIUnit((Context)this.ctx);
                this.basePrecision = FaManageUtils.getCurrencyScale(this.company, this.ctx);
                this.faParameter = FaManageUtils.getFAParameter(this.company.getId(), this.ctx);
                this.quantityScale = Integer.valueOf(this.faParameter.get("FA_008") == null ? "0" : (String)this.faParameter.get("FA_008"));
            }

            @Override
            protected List beforeBuildColumn(List columns) {
                return columns;
            }

            @Override
            public IRowSet execute(BOSQueryDataSource ds) {
                return this.getDefaltRowSet(ds, tables);
            }

            @Override
            protected void afterHeadFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
                FaRequisitionedBillInfo billInfo = (FaRequisitionedBillInfo)sourceInfo;
                if (billInfo.getAmounttotal() != null) {
                    rs.updateString("amounttotal", FaPrintServerHelper.transBigDecimalToStr(billInfo.getAmounttotal().setScale(this.basePrecision, 4)));
                }
                rs.updateString("printdate", FaPrintServerHelper.transDateToStr((Date)billInfo.get("printdate")));
                rs.updateString("bizDate", FaPrintServerHelper.transDateToStr(billInfo.getBizDate()));
                rs.updateString("createTime", FaPrintServerHelper.transDateToStr(billInfo.getCreateTime()));
                rs.updateString("auditTime", FaPrintServerHelper.transDateToStr(billInfo.getAuditTime()));
            }

            @Override
            protected void afterDetailFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
                FaRequisitionedBillEntryInfo entryInfo = (FaRequisitionedBillEntryInfo)sourceInfo;
                if (entryInfo.getFaCurCard() != null && entryInfo.getFaCurCard().getAssetAmt() != null) {
                    rs.updateString("Entrys.faCurCard.assetAmt", FaPrintServerHelper.transBigDecimalToStr(entryInfo.getFaCurCard().getAssetAmt().setScale(this.quantityScale, 4)));
                }
                if (entryInfo.getFaCurCard() != null && entryInfo.getFaCurCard().getAssetValue() != null) {
                    rs.updateString("Entrys.faCurCard.assetValue", FaPrintServerHelper.transBigDecimalToStr(entryInfo.getFaCurCard().getAssetValue().setScale(this.basePrecision, 4)));
                }
            }
        };
        return data;
    }

    public static BOSQueryDelegate getPrintManagerForFaRefundingEditUI(IObjectCollection collection, final KDTable[] tables, Context ctx) throws Exception {
        FaPrintServerHelper.beforeBuildData(collection, ctx);
        AbstractFaPrintManager data = new AbstractFaPrintManager(collection, ctx){
            CompanyOrgUnitInfo company;
            int basePrecision;
            Map faParameter;
            int quantityScale;
            {
                super(collection, ctx);
                this.company = ContextUtil.getCurrentFIUnit((Context)this.ctx);
                this.basePrecision = FaManageUtils.getCurrencyScale(this.company, this.ctx);
                this.faParameter = FaManageUtils.getFAParameter(this.company.getId(), this.ctx);
                this.quantityScale = Integer.valueOf(this.faParameter.get("FA_008") == null ? "0" : (String)this.faParameter.get("FA_008"));
            }

            @Override
            protected List beforeBuildColumn(List columns) {
                return columns;
            }

            @Override
            public IRowSet execute(BOSQueryDataSource ds) {
                return this.getDefaltRowSet(ds, tables);
            }

            @Override
            protected void afterHeadFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
                FaRefundingInfo billInfo = (FaRefundingInfo)sourceInfo;
                if (billInfo.getAmounttotal() != null) {
                    rs.updateString("amounttotal", FaPrintServerHelper.transBigDecimalToStr(billInfo.getAmounttotal().setScale(this.basePrecision, 4)));
                }
                rs.updateString("printdate", FaPrintServerHelper.transDateToStr((Date)billInfo.get("printdate")));
                rs.updateString("bizDate", FaPrintServerHelper.transDateToStr(billInfo.getBizDate()));
                rs.updateString("createTime", FaPrintServerHelper.transDateToStr(billInfo.getCreateTime()));
                rs.updateString("auditTime", FaPrintServerHelper.transDateToStr(billInfo.getAuditTime()));
            }

            @Override
            protected void afterDetailFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
                FaRefundingEntryInfo entryInfo = (FaRefundingEntryInfo)sourceInfo;
                rs.updateString("entry.keeper.name", entryInfo.getKeeper().getName(this.ctx.getOriginLocale()));
                rs.updateString("entry.keepdispartment.name", entryInfo.getKeepDispartment().getName(this.ctx.getOriginLocale()));
                if (entryInfo.getFaCurCard() != null && entryInfo.getFaCurCard().getAssetAmt() != null) {
                    rs.updateString("entry.faCurCard.assetAmt", FaPrintServerHelper.transBigDecimalToStr(entryInfo.getFaCurCard().getAssetAmt().setScale(this.quantityScale, 4)));
                }
                if (entryInfo.getFaCurCard() != null && entryInfo.getFaCurCard().getAssetValue() != null) {
                    rs.updateString("entry.faCurCard.assetValue", FaPrintServerHelper.transBigDecimalToStr(entryInfo.getFaCurCard().getAssetValue().setScale(this.basePrecision, 4)));
                }
            }
        };
        return data;
    }

    public static BOSQueryDelegate getPrintManagerForFaStockAPEditUI(IObjectCollection collection, final KDTable[] tables, Context ctx) throws Exception {
        FaPrintServerHelper.beforeBuildData(collection, ctx);
        AbstractFaPrintManager data = new AbstractFaPrintManager(collection, ctx){
            CompanyOrgUnitInfo company;
            Map faParameter;
            int quantityScale;
            {
                super(collection, ctx);
                this.company = ContextUtil.getCurrentFIUnit((Context)this.ctx);
                this.faParameter = FaManageUtils.getFAParameter(this.company.getId(), this.ctx);
                this.quantityScale = Integer.valueOf(this.faParameter.get("FA_008") == null ? "0" : (String)this.faParameter.get("FA_008"));
            }

            @Override
            protected List beforeBuildColumn(List columns) {
                if (!columns.contains("entries.changeMode")) {
                    columns.add("entries.changeMode");
                }
                if (!columns.contains("entries.bakCard.measureUnit")) {
                    columns.add("entries.bakCard.measureUnit");
                }
                if (!columns.contains("entries.bakCard.storeCity")) {
                    columns.add("entries.bakCard.storeCity");
                }
                if (!columns.contains("entries.bizCard.storeCity".toLowerCase())) {
                    columns.add("entries.bizCard.storeCity".toLowerCase());
                }
                if (!columns.contains("entries.bakCard.dept".toLowerCase())) {
                    columns.add("entries.bakCard.dept".toLowerCase());
                }
                if (!columns.contains("entries.bakCard.keeper".toLowerCase())) {
                    columns.add("entries.bakCard.keeper".toLowerCase());
                }
                if (!columns.contains("entries.bizCard.dept".toLowerCase())) {
                    columns.add("entries.bizCard.dept".toLowerCase());
                }
                if (!columns.contains("entries.bizCard.keeper".toLowerCase())) {
                    columns.add("entries.bizCard.keeper".toLowerCase());
                }
                if (!columns.contains("entries.bakCard.faBakDepartment.useDepartment".toLowerCase())) {
                    columns.add("entries.bakCard.faBakDepartment.useDepartment".toLowerCase());
                }
                if (!columns.contains("entries.bizCard.faBizDepartment.useDepartment".toLowerCase())) {
                    columns.add("entries.bizCard.faBizDepartment.useDepartment".toLowerCase());
                }
                if (!columns.contains("entries.bakCard.faBakDepartment.usePerson".toLowerCase())) {
                    columns.add("entries.bakCard.faBakDepartment.usePerson".toLowerCase());
                }
                if (!columns.contains("entries.bizCard.faBizDepartment.usePerson".toLowerCase())) {
                    columns.add("entries.bizCard.faBizDepartment.usePerson".toLowerCase());
                }
                return columns;
            }

            @Override
            public IRowSet execute(BOSQueryDataSource ds) {
                return this.getDefaltRowSet(ds, tables);
            }

            @Override
            protected void afterHeadFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
                FaStocktakingAOrPBillInfo stocktakingBillInfo = (FaStocktakingAOrPBillInfo)sourceInfo;
                rs.updateString("printdate", FaPrintServerHelper.transDateToStr((Date)stocktakingBillInfo.get("printdate")));
                rs.updateString("adjustDate", FaPrintServerHelper.transDateToStr(stocktakingBillInfo.getAdjustDate()));
                rs.updateString("bill.beginDate", FaPrintServerHelper.transDateToStr(stocktakingBillInfo.getTaskBill().getBeginDate()));
                rs.updateString("bill.endDate", FaPrintServerHelper.transDateToStr(stocktakingBillInfo.getTaskBill().getEndDate()));
            }

            protected void afterDetailFill(IRowSet rs, IObjectValue sourceInfo, Context ctx) throws Exception {
                FaStocktakingAOrPBillEntryInfo stockingapBillEntryInfo = (FaStocktakingAOrPBillEntryInfo)sourceInfo;
                if (stockingapBillEntryInfo.isIsCreate()) {
                    rs.updateString("entries.isCreate", EASCommonResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaStocktakingResource.true", (Locale)ctx.getOriginLocale()));
                }
                if (!stockingapBillEntryInfo.isIsCreate()) {
                    rs.updateString("entries.isCreate", EASCommonResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaStocktakingResource.false", (Locale)ctx.getOriginLocale()));
                }
            }
        };
        return data;
    }

    public static BOSQueryDelegate getPrintManagerForFaBorrowingEditUI(IObjectCollection collection, final KDTable[] tables, Context ctx) throws Exception {
        FaPrintServerHelper.beforeBuildData(collection, ctx);
        AbstractFaPrintManager data = new AbstractFaPrintManager(collection, ctx){
            CompanyOrgUnitInfo company;
            int basePrecision;
            Map faParameter;
            int quantityScale;
            {
                super(collection, ctx);
                this.company = ContextUtil.getCurrentFIUnit((Context)this.ctx);
                this.basePrecision = FaManageUtils.getCurrencyScale(this.company, this.ctx);
                this.faParameter = FaManageUtils.getFAParameter(this.company.getId(), this.ctx);
                this.quantityScale = Integer.valueOf(this.faParameter.get("FA_008") == null ? "0" : (String)this.faParameter.get("FA_008"));
            }

            @Override
            protected List beforeBuildColumn(List columns) {
                return columns;
            }

            @Override
            public IRowSet execute(BOSQueryDataSource ds) {
                return this.getDefaltRowSet(ds, tables);
            }

            @Override
            protected void afterHeadFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
                FaBorrowingInfo billInfo = (FaBorrowingInfo)sourceInfo;
                if (billInfo.getAmounttotal() != null) {
                    rs.updateString("amounttotal", FaPrintServerHelper.transBigDecimalToStr(billInfo.getAmounttotal().setScale(this.basePrecision, 4)));
                }
                rs.updateString("printdate", FaPrintServerHelper.transDateToStr((Date)billInfo.get("printdate")));
                rs.updateString("bizDate", FaPrintServerHelper.transDateToStr(billInfo.getBizDate()));
                rs.updateString("createTime", FaPrintServerHelper.transDateToStr(billInfo.getCreateTime()));
                rs.updateString("auditTime", FaPrintServerHelper.transDateToStr(billInfo.getAuditTime()));
            }

            @Override
            protected void afterDetailFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
                FaBorrowingEntryInfo entryInfo = (FaBorrowingEntryInfo)sourceInfo;
                if (entryInfo.getFaCurCard() != null && entryInfo.getFaCurCard().getAssetAmt() != null) {
                    rs.updateString("entry.faCurCard.assetAmt", FaPrintServerHelper.transBigDecimalToStr(entryInfo.getFaCurCard().getAssetAmt().setScale(this.quantityScale, 4)));
                }
                if (entryInfo.getFaCurCard() != null && entryInfo.getFaCurCard().getAssetValue() != null) {
                    rs.updateString("entry.faCurCard.assetValue", FaPrintServerHelper.transBigDecimalToStr(entryInfo.getFaCurCard().getAssetValue().setScale(this.basePrecision, 4)));
                }
            }
        };
        return data;
    }

    public static BOSQueryDelegate getPrintManagerForFaReturnEditUI(IObjectCollection collection, final KDTable[] tables, Context ctx) throws Exception {
        FaPrintServerHelper.beforeBuildData(collection, ctx);
        AbstractFaPrintManager data = new AbstractFaPrintManager(collection, ctx){
            CompanyOrgUnitInfo company;
            int basePrecision;
            Map faParameter;
            int quantityScale;
            {
                super(collection, ctx);
                this.company = ContextUtil.getCurrentFIUnit((Context)this.ctx);
                this.basePrecision = FaManageUtils.getCurrencyScale(this.company, this.ctx);
                this.faParameter = FaManageUtils.getFAParameter(this.company.getId(), this.ctx);
                this.quantityScale = Integer.valueOf(this.faParameter.get("FA_008") == null ? "0" : (String)this.faParameter.get("FA_008"));
            }

            @Override
            protected List beforeBuildColumn(List columns) {
                return columns;
            }

            @Override
            public IRowSet execute(BOSQueryDataSource ds) {
                return this.getDefaltRowSet(ds, tables);
            }

            @Override
            protected void afterHeadFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
                FaReturnInfo billInfo = (FaReturnInfo)sourceInfo;
                if (billInfo.getAmounttotal() != null) {
                    rs.updateString("amounttotal", FaPrintServerHelper.transBigDecimalToStr(billInfo.getAmounttotal().setScale(this.basePrecision, 4)));
                }
                rs.updateString("printdate", FaPrintServerHelper.transDateToStr((Date)billInfo.get("printdate")));
                rs.updateString("bizDate", FaPrintServerHelper.transDateToStr(billInfo.getBizDate()));
                rs.updateString("createTime", FaPrintServerHelper.transDateToStr(billInfo.getCreateTime()));
                rs.updateString("auditTime", FaPrintServerHelper.transDateToStr(billInfo.getAuditTime()));
            }

            @Override
            protected void afterDetailFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
                FaReturnEntryInfo entryInfo = (FaReturnEntryInfo)sourceInfo;
                if (entryInfo.getFaCurCard() != null && entryInfo.getFaCurCard().getAssetAmt() != null) {
                    rs.updateString("entry.faCurCard.assetAmt", FaPrintServerHelper.transBigDecimalToStr(entryInfo.getFaCurCard().getAssetAmt().setScale(this.quantityScale, 4)));
                }
                if (entryInfo.getFaCurCard() != null && entryInfo.getFaCurCard().getAssetValue() != null) {
                    rs.updateString("entry.faCurCard.assetValue", FaPrintServerHelper.transBigDecimalToStr(entryInfo.getFaCurCard().getAssetValue().setScale(this.basePrecision, 4)));
                }
            }
        };
        return data;
    }

    public static BOSQueryDelegate getPrintManagerForFaStockingRptEditUI(IObjectCollection collection, final KDTable[] tables, Context ctx) throws Exception {
        FaPrintServerHelper.beforeBuildData(collection, ctx);
        AbstractFaPrintManager data = new AbstractFaPrintManager(collection, ctx){
            CompanyOrgUnitInfo company;
            int basePrecision;
            Map faParameter;
            int quantityScale;
            {
                super(collection, ctx);
                this.company = ContextUtil.getCurrentFIUnit((Context)this.ctx);
                this.basePrecision = FaManageUtils.getCurrencyScale(this.company, this.ctx);
                this.faParameter = FaManageUtils.getFAParameter(this.company.getId(), this.ctx);
                this.quantityScale = Integer.valueOf(this.faParameter.get("FA_008") == null ? "0" : (String)this.faParameter.get("FA_008"));
            }

            @Override
            protected List beforeBuildColumn(List columns) {
                if (!columns.contains("entries.altermode")) {
                    columns.add("entries.altermode");
                }
                return columns;
            }

            @Override
            public IRowSet execute(BOSQueryDataSource ds) {
                return this.getDefaltRowSet(ds, tables);
            }

            @Override
            protected void afterHeadFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
                FaStocktakingReportBillInfo billInfo = (FaStocktakingReportBillInfo)sourceInfo;
                rs.updateString("stocktakingStatus", billInfo.getStocktakingStatus().getAlias());
                rs.updateString("printdate", FaPrintServerHelper.transDateToStr((Date)billInfo.get("printdate")));
                rs.updateString("adjustDate", FaPrintServerHelper.transDateToStr(billInfo.getAdjustDate()));
                rs.updateString("bill.beginDate", FaPrintServerHelper.transDateToStr(billInfo.getTaskBill().getBeginDate()));
                rs.updateString("bill.endDate", FaPrintServerHelper.transDateToStr(billInfo.getTaskBill().getEndDate()));
            }

            @Override
            protected void afterDetailFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
                FaStocktakingReportBillEntryInfo stockingRptBillEntryInfo = (FaStocktakingReportBillEntryInfo)sourceInfo;
                if (stockingRptBillEntryInfo.getBillEntry() != null && stockingRptBillEntryInfo.getBillEntry().getStocktakingAmt() != null) {
                    rs.updateString("entries.billEntry.stocktakingAmt", FaPrintServerHelper.transBigDecimalToStr(stockingRptBillEntryInfo.getBillEntry().getStocktakingAmt().setScale(this.quantityScale, 4)));
                }
                if (stockingRptBillEntryInfo.getBillEntry() != null && stockingRptBillEntryInfo.getBillEntry().getAssetAmt() != null) {
                    rs.updateString("entries.billEntry.assetAmt", FaPrintServerHelper.transBigDecimalToStr(stockingRptBillEntryInfo.getBillEntry().getAssetAmt().setScale(this.quantityScale, 4)));
                }
                if (stockingRptBillEntryInfo.getProfitAmt() != null) {
                    rs.updateString("entries.profitAmt", FaPrintServerHelper.transBigDecimalToStr(stockingRptBillEntryInfo.getProfitAmt().setScale(this.quantityScale, 4)));
                }
                if (stockingRptBillEntryInfo.getLossAmt() != null) {
                    rs.updateString("entries.lossAmt", FaPrintServerHelper.transBigDecimalToStr(stockingRptBillEntryInfo.getLossAmt().setScale(this.quantityScale, 4)));
                }
                if (stockingRptBillEntryInfo.getProfitValue() != null) {
                    rs.updateString("entries.profitValue", FaPrintServerHelper.transBigDecimalToStr(stockingRptBillEntryInfo.getProfitValue().setScale(this.basePrecision, 4)));
                }
                if (stockingRptBillEntryInfo.getLossValue() != null) {
                    rs.updateString("entries.lossValue", FaPrintServerHelper.transBigDecimalToStr(stockingRptBillEntryInfo.getLossValue().setScale(this.basePrecision, 4)));
                }
                if (stockingRptBillEntryInfo.isAdjustAsset()) {
                    rs.updateString("entries.adjustAsset", EASCommonResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaStocktakingResource.true", (Locale)this.ctx.getOriginLocale()));
                }
                if (!stockingRptBillEntryInfo.isAdjustAsset()) {
                    rs.updateString("entries.adjustAsset", EASCommonResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaStocktakingResource.false", (Locale)this.ctx.getOriginLocale()));
                }
            }
        };
        return data;
    }

    public static BOSQueryDelegate getPrintManagerForFaMortagBillEditUI(IObjectCollection collection, final KDTable[] tables, Context ctx) throws Exception {
        FaPrintServerHelper.beforeBuildData(collection, ctx);
        AbstractFaPrintManager data = new AbstractFaPrintManager(collection, ctx){
            CompanyOrgUnitInfo company;
            int basePrecision;
            Map faParameter;
            int quantityScale;
            {
                super(collection, ctx);
                this.company = ContextUtil.getCurrentFIUnit((Context)this.ctx);
                this.basePrecision = FaManageUtils.getCurrencyScale(this.company, this.ctx);
                this.faParameter = FaManageUtils.getFAParameter(this.company.getId(), this.ctx);
                this.quantityScale = Integer.valueOf(this.faParameter.get("FA_008") == null ? "0" : (String)this.faParameter.get("FA_008"));
            }

            @Override
            public IRowSet execute(BOSQueryDataSource ds) {
                return this.getDefaltRowSet(ds, tables);
            }

            @Override
            protected List beforeBuildColumn(List columns) {
                boolean have = false;
                for (int i = 0; i < columns.size(); ++i) {
                    if (!columns.get(i).toString().equalsIgnoreCase("faMortagBillEntry.keeper")) continue;
                    have = true;
                    break;
                }
                if (!have) {
                    columns.add("faMortagBillEntry.keeper");
                }
                return columns;
            }

            @Override
            protected void afterHeadFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
                FaMortagBillInfo mortagBillInfo = (FaMortagBillInfo)sourceInfo;
                if (mortagBillInfo.getCreditNaturalAmt() != null) {
                    rs.updateString("creditNaturalAmt", FaPrintServerHelper.transBigDecimalToStr(mortagBillInfo.getCreditNaturalAmt().setScale(this.basePrecision, 4)));
                }
                if (mortagBillInfo.getMortagageAmount() != null) {
                    rs.updateString("mortagageAmount", FaPrintServerHelper.transBigDecimalToStr(mortagBillInfo.getMortagageAmount().setScale(this.basePrecision, 4)));
                }
                if (mortagBillInfo.getMortagageRate() != null) {
                    rs.updateString("mortagageRate", mortagBillInfo.getMortagageRate().setScale(2, 4).toString() + "%");
                }
                int creditScale = this.basePrecision;
                CurrencyInfo creditCurrency = mortagBillInfo.getCreditCurrency();
                if (creditCurrency != null) {
                    creditScale = creditCurrency.getPrecision();
                }
                if (mortagBillInfo.getCreditOriginAmt() != null) {
                    rs.updateString("creditOriginAmt", FaPrintServerHelper.transBigDecimalToStr(mortagBillInfo.getCreditOriginAmt().setScale(creditScale, 4)));
                }
                rs.updateString("printdate", FaPrintServerHelper.transDateToStr((Date)mortagBillInfo.get("printdate")));
                rs.updateString("signatureDate", FaPrintServerHelper.transDateToStr(mortagBillInfo.getSignatureDate()));
                rs.updateString("beginDate", FaPrintServerHelper.transDateToStr(mortagBillInfo.getBeginDate()));
                rs.updateString("endDate", FaPrintServerHelper.transDateToStr(mortagBillInfo.getEndDate()));
                rs.updateString("createTime", FaPrintServerHelper.transDateToStr(mortagBillInfo.getCreateTime()));
            }

            @Override
            protected void afterDetailFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
                if (rs.getString("faMortagBillEntry.hasInsurance").equals("true")) {
                    String haveStr = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaLeaseResource", (String)"Print_Have");
                    rs.updateString("faMortagBillEntry.hasInsurance", haveStr);
                } else {
                    String noStr = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaLeaseResource", (String)"Print_No");
                    rs.updateString("faMortagBillEntry.hasInsurance", noStr);
                }
                FaMortagBillEntryInfo mortagBillEntryInfo = (FaMortagBillEntryInfo)sourceInfo;
                rs.updateString("faMortagBillEntry.faBizCard.assetAmt", FaPrintServerHelper.transBigDecimalToStr(mortagBillEntryInfo.getFaBizCard().getAssetAmt().setScale(this.quantityScale, 4)));
                rs.updateString("faMortagBillEntry.quantity", FaPrintServerHelper.transBigDecimalToStr(mortagBillEntryInfo.getQuantity().setScale(this.quantityScale, 4)));
                if (mortagBillEntryInfo.getShowAm() != null) {
                    rs.updateString("faMortagBillEntry.showAm", FaPrintServerHelper.transBigDecimalToStr(mortagBillEntryInfo.getShowAm().setScale(this.basePrecision, 4)));
                }
                if (mortagBillEntryInfo.getEvaluateAmt() != null) {
                    rs.updateString("faMortagBillEntry.evaluateAmt", FaPrintServerHelper.transBigDecimalToStr(mortagBillEntryInfo.getEvaluateAmt().setScale(this.basePrecision, 4)));
                }
                if (mortagBillEntryInfo.getKeepAmt() != null) {
                    rs.updateString("faMortagBillEntry.keepAmt", FaPrintServerHelper.transBigDecimalToStr(mortagBillEntryInfo.getKeepAmt().setScale(this.basePrecision, 4)));
                }
                if (mortagBillEntryInfo.getKeeper() != null) {
                    rs.updateString("faMortagBillEntry.keeper.name", mortagBillEntryInfo.getKeeper().getName());
                }
            }
        };
        return data;
    }

    public static BOSQueryDelegate getPrintManagerForFaMaintainEditUI(IObjectCollection collection, final KDTable[] tables, Context ctx) throws Exception {
        FaPrintServerHelper.beforeBuildData(collection, ctx);
        AbstractFaPrintManager data = new AbstractFaPrintManager(collection, ctx){
            CompanyOrgUnitInfo company;
            int basePrecision;
            Map faParameter;
            int quantityScale;
            {
                super(collection, ctx);
                this.company = ContextUtil.getCurrentFIUnit((Context)this.ctx);
                this.basePrecision = FaManageUtils.getCurrencyScale(this.company, this.ctx);
                this.faParameter = FaManageUtils.getFAParameter(this.company.getId(), this.ctx);
                this.quantityScale = Integer.valueOf(this.faParameter.get("FA_008") == null ? "0" : (String)this.faParameter.get("FA_008"));
            }

            @Override
            public IRowSet execute(BOSQueryDataSource ds) {
                return this.getDefaltRowSet(ds, tables);
            }

            @Override
            protected List beforeBuildColumn(List columns) {
                if (!columns.contains("gateMaintainOriginalAmount.s")) {
                    columns.add("gateMaintainOriginalAmount.s");
                }
                if (!columns.contains("gateMaintainLocallAmount.s")) {
                    columns.add("gateMaintainLocallAmount.s");
                }
                if (!columns.contains("factMaintainOriginalAmount.s")) {
                    columns.add("factMaintainOriginalAmount.s");
                }
                if (!columns.contains("factMaintainLocalAmount.s")) {
                    columns.add("factMaintainLocalAmount.s");
                }
                if (!columns.contains("expenseMeltAmount.s")) {
                    columns.add("expenseMeltAmount.s");
                }
                if (!columns.contains("capitalMeltAmout.s")) {
                    columns.add("capitalMeltAmout.s");
                }
                if (!columns.contains("exRate.s")) {
                    columns.add("exRate.s");
                }
                if (!columns.contains("expenseApportionScale.s")) {
                    columns.add("expenseApportionScale.s");
                }
                if (!columns.contains("createTime.s")) {
                    columns.add("createTime.s");
                }
                if (!columns.contains("auditTime.s")) {
                    columns.add("auditTime.s");
                }
                if (!columns.contains("faBizCard.assetAmt.s")) {
                    columns.add("faBizCard.assetAmt.s");
                }
                if (!columns.contains("maintainEntry.maintainAmt.s")) {
                    columns.add("maintainEntry.maintainAmt.s");
                }
                if (!columns.contains("faBizCard.number")) {
                    columns.add("faBizCard.number");
                }
                if (!columns.contains("faBizCard.assetName")) {
                    columns.add("faBizCard.assetName");
                }
                if (!columns.contains("faBizCard.specs")) {
                    columns.add("faBizCard.specs");
                }
                if (!columns.contains("measureUnit.name")) {
                    columns.add("measureUnit.name");
                }
                if (!columns.contains("assetCat.name")) {
                    columns.add("assetCat.name");
                }
                if (!columns.contains("tainType.s")) {
                    columns.add("tainType.s");
                }
                return columns;
            }

            @Override
            protected void afterHeadFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
                FaMaintainInfo maintainInfo = (FaMaintainInfo)sourceInfo;
                CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)this.ctx);
                int basePrecision = 0;
                int exRateScale = FaManageUtils.getExchangRateScale(maintainInfo.getCurrency(), this.ctx);
                basePrecision = maintainInfo.getCurrency().getId().toString().equals(FaManageUtils.getBaseCurrency(null).getId()) ? FaManageUtils.getCurrencyScale(company, this.ctx) : maintainInfo.getCurrency().getPrecision();
                if (maintainInfo.getGateMaintainOriginalAmount() != null) {
                    rs.updateString("gateMaintainOriginalAmount.s", FaPrintServerHelper.transBigDecimalToStr(maintainInfo.getGateMaintainOriginalAmount().setScale(basePrecision, 4)));
                }
                if (maintainInfo.getGateMaintainLocallAmount() != null) {
                    rs.updateString("gateMaintainLocallAmount.s", FaPrintServerHelper.transBigDecimalToStr(maintainInfo.getGateMaintainLocallAmount().setScale(basePrecision, 4)));
                }
                if (maintainInfo.getFactMaintainOriginalAmount() != null) {
                    rs.updateString("factMaintainOriginalAmount.s", FaPrintServerHelper.transBigDecimalToStr(maintainInfo.getFactMaintainOriginalAmount().setScale(basePrecision, 4)));
                }
                if (maintainInfo.getFactMaintainLocalAmount() != null) {
                    rs.updateString("factMaintainLocalAmount.s", FaPrintServerHelper.transBigDecimalToStr(maintainInfo.getFactMaintainLocalAmount().setScale(basePrecision, 4)));
                }
                if (maintainInfo.getExpenseMeltAmount() != null) {
                    rs.updateString("expenseMeltAmount.s", FaPrintServerHelper.transBigDecimalToStr(maintainInfo.getExpenseMeltAmount().setScale(basePrecision, 4)));
                }
                if (maintainInfo.getCapitalMeltAmout() != null) {
                    rs.updateString("capitalMeltAmout.s", FaPrintServerHelper.transBigDecimalToStr(maintainInfo.getCapitalMeltAmout().setScale(basePrecision, 4)));
                }
                if (maintainInfo.getExRate() != null) {
                    rs.updateString("exRate.s", FaPrintServerHelper.transBigDecimalToStr(maintainInfo.getExRate().setScale(exRateScale, 4)));
                }
                if (maintainInfo.getExpenseApportionScale() != null) {
                    rs.updateString("expenseApportionScale.s", FaPrintServerHelper.transBigDecimalToStr(maintainInfo.getExpenseApportionScale().setScale(1, 4)));
                }
                if (maintainInfo.getCreateTime() != null) {
                    rs.updateString("createTime.s", FaPrintServerHelper.transDateToStr(maintainInfo.getCreateTime()));
                }
                if (maintainInfo.getAuditTime() != null) {
                    rs.updateString("auditTime.s", FaPrintServerHelper.transDateToStr(maintainInfo.getAuditTime()));
                }
                if (maintainInfo.getTainType() != null) {
                    rs.updateString("tainType.s", maintainInfo.getTainType().toString());
                }
                rs.updateString("printdate", FaPrintServerHelper.transDateToStr((Date)maintainInfo.get("printdate")));
                rs.updateString("maintainBeginDate", FaPrintServerHelper.transDateToStr(maintainInfo.getMaintainBeginDate()));
                rs.updateString("maintainEndDate", FaPrintServerHelper.transDateToStr(maintainInfo.getMaintainEndDate()));
            }

            @Override
            protected void afterDetailFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
                FaMaintainEntryInfo maintainEntryInfo = (FaMaintainEntryInfo)sourceInfo;
                if (maintainEntryInfo.getFaBizCard().getNumber() != null) {
                    rs.updateString("faBizCard.number", maintainEntryInfo.getFaBizCard().getNumber());
                }
                if (maintainEntryInfo.getFaBizCard().getAssetName() != null) {
                    rs.updateString("faBizCard.assetName", maintainEntryInfo.getFaBizCard().getAssetName());
                }
                if (maintainEntryInfo.getFaBizCard().getSpecs() != null) {
                    rs.updateString("faBizCard.specs", maintainEntryInfo.getFaBizCard().getSpecs());
                }
                if (maintainEntryInfo.getFaBizCard().getMeasureUnit() != null) {
                    rs.updateString("measureUnit.name", maintainEntryInfo.getFaBizCard().getMeasureUnit().getName());
                }
                if (maintainEntryInfo.getFaBizCard().getAssetCat() != null) {
                    rs.updateString("assetCat.name", maintainEntryInfo.getFaBizCard().getAssetCat().getName());
                }
                if (maintainEntryInfo.getFaBizCard().getAssetAmt() != null) {
                    rs.updateString("faBizCard.assetAmt.s", FaPrintServerHelper.transBigDecimalToStr(maintainEntryInfo.getFaBizCard().getAssetAmt().setScale(this.quantityScale, 4)));
                }
                if (maintainEntryInfo.getMaintainAmt() != null) {
                    rs.updateString("maintainEntry.maintainAmt.s", FaPrintServerHelper.transBigDecimalToStr(maintainEntryInfo.getMaintainAmt().setScale(this.quantityScale, 4)));
                }
            }
        };
        return data;
    }

    public static BOSQueryDelegate getPrintManagerForFaChangeBillEditUI(IObjectCollection collection, Context ctx) throws EASBizException, BOSException {
        FaPrintServerHelper.beforeBuildData(collection, ctx);
        AbstractFaPrintManager data = new AbstractFaPrintManager(collection, ctx){
            CompanyOrgUnitInfo company;
            Map faParameter;
            {
                this.company = ContextUtil.getCurrentFIUnit((Context)this.ctx);
                this.faParameter = FaManageUtils.getFAParameter(this.company.getId(), this.ctx);
            }

            @Override
            public IRowSet execute(BOSQueryDataSource ds) {
                return this.getDefaltRowSet(ds, columsForCard, "faCurFacility");
            }

            @Override
            protected List beforeBuildColumn(List columns) {
                if (!columns.contains("changebill.changedate")) {
                    columns.add("changebill.changedate");
                }
                if (!columns.contains("changebill.changemode.name")) {
                    columns.add("changebill.changemode.name");
                }
                if (!columns.contains("changebill.number")) {
                    columns.add("changebill.number");
                }
                if (!columns.contains("measureUnitWL")) {
                    columns.add("measureUnitWL");
                }
                if (!columns.contains("facurcostcenter.asstacttype.number")) {
                    columns.add("facurcostcenter.asstacttype.number");
                }
                if (!columns.contains("originchg")) {
                    columns.add("originchg");
                }
                if (!columns.contains("imageNumber")) {
                    columns.add("imageNumber");
                }
                return columns;
            }

            @Override
            protected void afterHeadFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
                FaChangeBillEntryCollection cc;
                FaChangeBillInfo bill;
                String isDisDeptLName = this.faParameter.get("FA_025") == null ? "false" : (String)this.faParameter.get("FA_025");
                FaCurCardInfo info = (FaCurCardInfo)sourceInfo;
                if (info == null) {
                    return;
                }
                FaCurCostCenterCollection collection = info.getFaCurCostCenter();
                StringBuffer costCenterName = new StringBuffer();
                for (int i = 0; i < collection.size(); ++i) {
                    FaCurCostCenterInfo costCenter = collection.get(i);
                    String account = costCenter.getAccountView() == null ? "" : costCenter.getAccountView().getNumber() + "-" + costCenter.getAccountView().getLongName();
                    String scale = costCenter.getApportionScale() == null ? "" : costCenter.getApportionScale().toString() + "%";
                    costCenterName.append(i == 0 ? "" : "; ").append("".equals(account) ? "" : account).append(" ").append(scale).append(" ").append(FaPrintServerHelper.getAsstActLName(collection.get(i)));
                }
                if (!"".equals(costCenterName.toString().trim())) {
                    rs.updateString("facurcostcenter.asstacttype.number", costCenterName.toString());
                }
                FaCurDepartmentCollection departmentColl = info.getFaCurDepartment();
                StringBuffer departmentsName = new StringBuffer();
                int size = departmentColl.size();
                for (int i = 0; i < size; ++i) {
                    FaCurDepartmentInfo departmentInfo = departmentColl.get(i);
                    if (departmentInfo == null || departmentInfo.getUseDepartment() == null) continue;
                    if ("true".equalsIgnoreCase(isDisDeptLName)) {
                        departmentsName.append(departmentInfo.getUseDepartment().getDisplayName());
                    } else {
                        departmentsName.append(departmentInfo.getUseDepartment().getName());
                    }
                    departmentsName.append("; ");
                }
                if (departmentsName.length() > 0) {
                    String departments = departmentsName.substring(0, departmentsName.length() - 1).toString();
                    rs.updateString("facurdepartment.usedepartment.name", departments);
                }
                if (info.getEconomicPurp() != null) {
                    rs.updateString("economicPurp.name", info.getEconomicPurp().getName());
                }
                if (info.getOriginType() != null) {
                    rs.updateString("originType", info.getOriginType().toString());
                }
                if (info.getAccountAsset() != null) {
                    rs.updateString("accountasset.name", info.getAccountAsset().getNumber() + "-" + info.getAccountAsset().getLongName());
                }
                if (info.getAccountAccuDepr() != null) {
                    rs.updateString("accountaccudepr.name", info.getAccountAccuDepr().getNumber() + "-" + info.getAccountAccuDepr().getLongName());
                }
                if (info.getAccountDecValue() != null) {
                    rs.updateString("accountdecvalue.name", info.getAccountDecValue().getNumber() + "-" + info.getAccountDecValue().getLongName());
                }
                Date changeDate = (Date)info.get("changeDate");
                FaAlterModeInfo alterModeInfo = (FaAlterModeInfo)info.get("changeMode");
                String changeNumber = (String)info.get("changeNumber");
                rs.updateString("changebill.changedate", this.convertObject(changeDate));
                rs.updateString("changebill.changemode.name", alterModeInfo == null ? "" : alterModeInfo.getName());
                rs.updateString("changebill.number", changeNumber);
                rs.updateString("originunit", FaPrintServerHelper.transferFromUnit((FaCardInfo)sourceInfo, this.ctx));
                if (FaManageUtils.isWorkLoadMethod((FaDepreciationModeInfo)info.getDeprMethod())) {
                    rs.updateString("useYears", "");
                } else {
                    rs.updateString("measureUnitWL", "");
                }
                if (!info.isIsEvaledBefore()) {
                    rs.updateString("initEvalValue", "");
                    rs.updateString("evalLeftPeriod", "");
                }
                if ((bill = (FaChangeBillInfo)info.get("changebill")) != null && bill.getChangeBillEntry() != null && (cc = bill.getChangeBillEntry()).size() > 0) {
                    FaChangeBillEntryInfo ef = cc.get(0);
                    rs.updateString("originchg", FaPrintServerHelper.transBigDecimalToStr(ef.getOriginChg()));
                }
                rs.updateString("assetAmt", FaPrintServerHelper.transBigDecimalToStr(info.getAssetAmt()));
                rs.updateString("originAmt", FaPrintServerHelper.transBigDecimalToStr(info.getOriginAmt()));
                rs.updateString("assetValue", FaPrintServerHelper.transBigDecimalToStr(info.getAssetValue()));
                rs.updateString("buyValue", FaPrintServerHelper.transBigDecimalToStr(info.getBuyValue()));
                rs.updateString("buyAccuDepr", FaPrintServerHelper.transBigDecimalToStr(info.getBuyAccuDepr()));
                rs.updateString("initEvalValue", FaPrintServerHelper.transBigDecimalToStr(info.getInitEvalValue()));
                rs.updateString("evalLeftPeriod", FaPrintServerHelper.transBigDecimalToStr(info.getEvalLeftPeriod()));
                rs.updateString("useTermCount", FaPrintServerHelper.transBigDecimalToStr(info.getUseTermCount()));
                rs.updateString("deprTermCount", FaPrintServerHelper.transBigDecimalToStr(info.getDeprTermCount()));
                rs.updateString("accuDepr", FaPrintServerHelper.transBigDecimalToStr(info.getAccuDepr()));
                rs.updateString("accuDeprTYear", FaPrintServerHelper.transBigDecimalToStr(info.getAccuDeprTYear()));
                rs.updateString("neatRemValue", FaPrintServerHelper.transBigDecimalToStr(info.getNeatRemValue()));
                rs.updateString("decValue", FaPrintServerHelper.transBigDecimalToStr(info.getDecValue()));
                rs.updateString("neatValue", FaPrintServerHelper.transBigDecimalToStr(info.getNeatValue()));
                rs.updateString("neatAmt", FaPrintServerHelper.transBigDecimalToStr(info.getNeatAmt()));
                rs.updateString("accuDeprAll", FaPrintServerHelper.transBigDecimalToStr(info.getAccuDeprAll()));
                rs.updateString("addons", FaPrintServerHelper.transBigDecimalToStr(info.getAddons()));
                rs.updateString("treatmentIncome", FaPrintServerHelper.transBigDecimalToStr(info.getTreatmentIncome()));
                rs.updateString("fairValue", FaPrintServerHelper.transBigDecimalToStr(info.getFairValue()));
                rs.updateString("printdate", FaPrintServerHelper.transDateToStr((Date)info.get("printdate")));
                rs.updateString("accountdate", FaPrintServerHelper.transDateToStr(info.getAccountDate()));
                rs.updateString("fiAccountDate", FaPrintServerHelper.transDateToStr(info.getFiAccountDate()));
                rs.updateString("levfrdate", FaPrintServerHelper.transDateToStr(info.getLevFrDate()));
                rs.updateString("deliverdate", FaPrintServerHelper.transDateToStr(info.getDeliverDate()));
                rs.updateString("startusedate", FaPrintServerHelper.transDateToStr(info.getStartUseDate()));
                if (bill.getId() != null) {
                    String imageNumber = this.getImageNumber(new FaChangeBillInfo().getBOSType().toString(), bill != null && bill.getId() != null ? bill.getId().toString() : "");
                    rs.updateString("imageNumber", imageNumber);
                } else {
                    rs.updateString("imageNumber", "");
                }
            }

            @Override
            protected void afterDetailFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
                FaCurFacilityInfo facilityInfo = (FaCurFacilityInfo)sourceInfo;
                rs.updateString("faCurFacility.amount", FaPrintServerHelper.transBigDecimalToStr(facilityInfo.getAmount()));
                rs.updateString("faCurFacility.quantity", FaPrintServerHelper.transBigDecimalToStr(facilityInfo.getQuantity()));
                rs.updateString("facurfacility.registerdate", FaPrintServerHelper.transDateToStr(facilityInfo.getRegisterDate()));
            }
        };
        return data;
    }

    public static BOSQueryDelegate getPrintManagerForFaDispatchBillEditUI(IObjectCollection collection, final KDTable[] tables, Context ctx) throws Exception {
        FaPrintServerHelper.beforeBuildData(collection, ctx);
        AbstractFaPrintManager data = new AbstractFaPrintManager(collection, ctx){
            CompanyOrgUnitInfo company;
            int basePrecision;
            Map faParameter;
            int quantityScale;
            {
                super(collection, ctx);
                this.company = ContextUtil.getCurrentFIUnit((Context)this.ctx);
                this.basePrecision = FaManageUtils.getCurrencyScale(this.company, this.ctx);
                this.faParameter = FaManageUtils.getFAParameter(this.company.getId(), this.ctx);
                this.quantityScale = Integer.valueOf(this.faParameter.get("FA_008") == null ? "0" : (String)this.faParameter.get("FA_008"));
            }

            @Override
            public IRowSet execute(BOSQueryDataSource ds) {
                return this.getDefaltRowSet(ds, tables);
            }

            @Override
            protected List beforeBuildColumn(List columns) {
                if (!columns.contains("FaDispatchBillEntry.faBizCard.useStatus")) {
                    columns.add("FaDispatchBillEntry.faBizCard.useStatus");
                }
                return columns;
            }

            @Override
            protected void afterHeadFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
                FaDispatchBillInfo dispatchBillInfo = (FaDispatchBillInfo)sourceInfo;
                if (dispatchBillInfo.getDispatchAmount() != null) {
                    rs.updateString("dispatchAmount", FaPrintServerHelper.transBigDecimalToStr(dispatchBillInfo.getDispatchAmount().setScale(this.basePrecision, 4)));
                }
                rs.updateString("printdate", FaPrintServerHelper.transDateToStr((Date)dispatchBillInfo.get("printdate")));
                rs.updateString("dispatchDate", FaPrintServerHelper.transDateToStr(dispatchBillInfo.getDispatchDate()));
                rs.updateString("createTime", FaPrintServerHelper.transDateToStr(dispatchBillInfo.getCreateTime()));
                rs.updateString("auditTime", FaPrintServerHelper.transDateToStr(dispatchBillInfo.getAuditTime()));
                rs.updateString("affirmDate", FaPrintServerHelper.transDateToStr(dispatchBillInfo.getAffirmDate()));
            }

            @Override
            protected void afterDetailFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
                FaDispatchBillEntryInfo dispatchBillEntryInfo = (FaDispatchBillEntryInfo)sourceInfo;
                rs.updateString("FaDispatchBillEntry.faBizCard.useStatus", dispatchBillEntryInfo.getFaBizCard().getUseStatus().getName());
                rs.updateString("FaDispatchBillEntry.assetValue", FaPrintServerHelper.transBigDecimalToStr(dispatchBillEntryInfo.getAssetValue().setScale(this.basePrecision, 4)));
                rs.updateString("FaDispatchBillEntry.accuDepr", FaPrintServerHelper.transBigDecimalToStr(dispatchBillEntryInfo.getAccuDepr().setScale(this.basePrecision, 4)));
                rs.updateString("FaDispatchBillEntry.neatValue", FaPrintServerHelper.transBigDecimalToStr(dispatchBillEntryInfo.getNeatValue().setScale(this.basePrecision, 4)));
                rs.updateString("FaDispatchBillEntry.evaluateValue", FaPrintServerHelper.transBigDecimalToStr(dispatchBillEntryInfo.getEvaluateValue().setScale(this.basePrecision, 4)));
                rs.updateString("FaDispatchBillEntry.faBizCard.assetAmt", FaPrintServerHelper.transBigDecimalToStr(dispatchBillEntryInfo.getFaBizCard().getAssetAmt().setScale(this.quantityScale, 4)));
                rs.updateString("FaDispatchBillEntry.quantity", FaPrintServerHelper.transBigDecimalToStr(dispatchBillEntryInfo.getQuantity().setScale(this.quantityScale, 4)));
            }
        };
        return data;
    }

    public static BOSQueryDelegate getPrintManagerForFaLeaseContractUI(IObjectCollection collection, final KDTable[] tables, Context ctx) throws Exception {
        FaPrintServerHelper.beforeBuildData(collection, ctx);
        AbstractFaPrintManager data = new AbstractFaPrintManager(collection, ctx){

            @Override
            public IRowSet execute(BOSQueryDataSource ds) {
                return this.getDefaltRowSet(ds, tables);
            }

            @Override
            protected void afterHeadFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
                FALeaseContractInfo leaseContractInfo = (FALeaseContractInfo)sourceInfo;
                rs.updateString("printdate", FaPrintServerHelper.transDateToStr((Date)leaseContractInfo.get("printdate")));
                rs.updateString("signDateC", FaPrintServerHelper.transDateToStr(leaseContractInfo.getSignDateC()));
                rs.updateString("signDateB", FaPrintServerHelper.transDateToStr(leaseContractInfo.getSignDateB()));
                rs.updateString("signDateA", FaPrintServerHelper.transDateToStr(leaseContractInfo.getSignDateA()));
                rs.updateString("effectiveDate", FaPrintServerHelper.transDateToStr(leaseContractInfo.getEffectiveDate()));
            }
        };
        return data;
    }

    private static String transferFromUnit(FaCardInfo cardInfo, Context ctx) {
        FaFromUnitCatEnum item = cardInfo.getOriginType();
        String id = cardInfo.getOriginUnit();
        if (id == null || id.equals("")) {
            return "";
        }
        if ((id = id.trim()).equals("")) {
            return "";
        }
        BOSUuid uuid = null;
        try {
            uuid = BOSUuid.read((String)id);
            if (uuid == null) {
                return "";
            }
            ObjectUuidPK pk = new ObjectUuidPK(uuid);
            if (item.getValue() == 2) {
                IOrgInnerFacade iOrgInner = OrgInnerFacadeFactory.getLocalInstance((Context)ctx);
                OrgUnitInfo info = null;
                BOSUuid[] bosUuids = new BOSUuid[]{uuid};
                Object[] result = iOrgInner.getOrgUnitCollection(bosUuids);
                if (result != null && result.length > 0) {
                    info = (OrgUnitInfo)result[0];
                    return info.getName();
                }
                return "";
            }
            if (item.getValue() == 1) {
                ICustomer iCustomer = CustomerFactory.getLocalInstance((Context)ctx);
                CustomerInfo info = iCustomer.getCustomerInfo((IObjectPK)pk);
                return info.getName();
            }
            if (item.getValue() == 0) {
                ISupplier iSupplier = SupplierFactory.getLocalInstance((Context)ctx);
                SupplierInfo info = iSupplier.getSupplierInfo((IObjectPK)pk);
                return info.getName();
            }
            return "";
        }
        catch (Exception e) {
            logger.error((Object)e);
            return "";
        }
    }

    private static String transBigDecimalToStr(BigDecimal val) {
        String pattern = null;
        if (val == null) {
            return null;
        }
        int scale = val.scale();
        switch (scale) {
            case 0: {
                pattern = "#,##0";
                break;
            }
            case 1: {
                pattern = "#,##0.0";
                break;
            }
            case 2: {
                pattern = "#,##0.00";
                break;
            }
            case 3: {
                pattern = "#,##0.000";
                break;
            }
            case 4: {
                pattern = "#,##0.0000";
                break;
            }
            default: {
                StringBuffer buf = new StringBuffer("#,##0.00000");
                for (int i = 5; i < scale; ++i) {
                    buf.append("0");
                }
                pattern = buf.toString();
            }
        }
        DecimalFormat decimalFormat = (DecimalFormat)CtrlFormatUtilities.getDecimalFormat();
        decimalFormat.applyPattern(pattern);
        return decimalFormat.format(val);
    }

    private static String transDateToStr(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dateFormat = (SimpleDateFormat)CtrlFormatUtilities.getDateFormat();
        return dateFormat.format(date);
    }
}

