/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.AssistActItemInfo;
import com.kingdee.eas.fi.fa.manage.FaBakCardFactory;
import com.kingdee.eas.fi.fa.manage.FaBakCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBillBaseInfo;
import com.kingdee.eas.fi.fa.manage.FaBillBizProcessor;
import com.kingdee.eas.fi.fa.manage.FaBillOriginEnum;
import com.kingdee.eas.fi.fa.manage.FaBillTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaBizAsstActCompositInfo;
import com.kingdee.eas.fi.fa.manage.FaBizCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBizCostCenterCollection;
import com.kingdee.eas.fi.fa.manage.FaBizCostCenterInfo;
import com.kingdee.eas.fi.fa.manage.FaBizDepartmentCollection;
import com.kingdee.eas.fi.fa.manage.FaBizDepartmentInfo;
import com.kingdee.eas.fi.fa.manage.FaBizStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaChangeBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaChangeBillFactory;
import com.kingdee.eas.fi.fa.manage.FaChangeBillInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaPhysicalManageBaseException;
import com.kingdee.eas.fi.fa.manage.FaRequisitionedBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaRequisitionedBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaRequisitionedBillInfo;
import com.kingdee.eas.fi.fa.manage.IFaChangeBill;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaRequisitionedBillControllerBean;
import com.kingdee.eas.fi.fa.manage.app.FaLastPeriodChangeUtils;
import com.kingdee.eas.fi.fa.manage.app.PrcFaChangeStrategy;
import com.kingdee.eas.fi.fa.manage.app.PrcFaCoreManager;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.DBUtilx;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class FaRequisitionedBillControllerBean
extends AbstractFaRequisitionedBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.manage.app.FaRequisitionedBillControllerBean");
    public static final Set bizState = new HashSet();

    @Override
    public String getMasterTable() {
        return "T_FA_FaRequisitionedBill";
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.updateCurCard(ctx, (FaRequisitionedBillInfo)model);
        super._update(ctx, pk, model);
        this.updateCurCardBySQL(ctx, FaBizStatusEnum.REQUISITIONING.getValue(), pk.toString(), "select FCurcardID from T_FA_FaRequisitionedBillEntry where FParentID='" + pk.toString() + "'");
    }

    protected FaRequisitionedBillInfo _getValueByChgBillId(Context ctx, String id) throws BOSException, EASBizException {
        try {
            String selectSql = "select bill.fid ,bill.ffivouchered from T_FA_FaRequisitionedBill bill inner join T_FA_FaRequisitionedBillentry entry on bill.fid = entry.FFPrarentID inner join t_fa_fachangebill change on entry.FFaChangeBillID = change.fid where change.fid = ?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql, (Object[])new Object[]{id});
            if (rs.next()) {
                String evaId = rs.getString(1);
                return this.getFaRequisitionedBillInfo(ctx, "select id,number,fiVouchered where id = '" + evaId + "'");
            }
            return null;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    @Override
    protected void _saveSelf(Context ctx, IObjectPK pk, FaBillBaseInfo model) throws BOSException, EASBizException {
        this.updateCurCard(ctx, (FaRequisitionedBillInfo)model);
        this.checkCardHasRequisitioned(ctx, (FaRequisitionedBillInfo)model);
        super._saveSelf(ctx, pk, model);
        this.updateCurCardBySQL(ctx, FaBizStatusEnum.REQUISITIONING.getValue(), pk.toString(), "select FCurcardID from T_FA_FaRequisitionedBillEntry where FParentID='" + pk.toString() + "'");
    }

    @Override
    protected IObjectPK _saveSelf(Context ctx, FaBillBaseInfo model) throws BOSException, EASBizException {
        this.updateCurCard(ctx, (FaRequisitionedBillInfo)model);
        this.checkCardHasRequisitioned(ctx, (FaRequisitionedBillInfo)model);
        IObjectPK pk = super._saveSelf(ctx, model);
        this.updateCurCardBySQL(ctx, FaBizStatusEnum.REQUISITIONING.getValue(), pk.toString(), "select FCurcardID from T_FA_FaRequisitionedBillEntry where FParentID='" + pk.toString() + "'");
        return pk;
    }

    protected void updateCurCard(Context ctx, FaRequisitionedBillInfo newInfo) throws EASBizException, BOSException {
        FaRequisitionedBillEntryInfo entryInfo;
        int i;
        if (newInfo.getId() == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(newInfo.getId().toString());
        SelectorItemCollection sic = this.getSelfSelctor();
        sic.add("Entrys.bizCard.id");
        sic.add("Entrys.bizCard.bizStatus");
        sic.add("Entrys.bizCard.lastBillID");
        HashSet<String> set = new HashSet<String>();
        FaRequisitionedBillInfo info = this.getFaRequisitionedBillInfo(ctx, (IObjectPK)pk, sic);
        for (i = 0; i < info.getEntrys().size(); ++i) {
            entryInfo = info.getEntrys().get(i);
            if (entryInfo.getBizCard() == null) continue;
            set.add(entryInfo.getFaCurCard().getId().toString());
        }
        for (i = 0; i < newInfo.getEntrys().size(); ++i) {
            entryInfo = newInfo.getEntrys().get(i);
            if (entryInfo.getId() == null || entryInfo.getBizCard() == null) continue;
            set.remove(entryInfo.getFaCurCard().getId().toString());
        }
        if (set.isEmpty()) {
            return;
        }
        for (i = 0; i < info.getEntrys().size(); ++i) {
            entryInfo = info.getEntrys().get(i);
            if (entryInfo.getBizCard() == null || !set.contains(entryInfo.getFaCurCard().getId().toString())) continue;
            FaLastPeriodChangeUtils.updateCurCardBySQL(ctx, entryInfo.getBizCard().getBizStatus().getValue(), entryInfo.getBizCard().getLastBillID(), entryInfo.getFaCurCard().getId().toString(), entryInfo.getBizCard().isLastPeriodChange());
        }
    }

    @Override
    protected void _submitSelf(Context ctx, IObjectPK pk, FaBillBaseInfo model) throws BOSException, EASBizException {
        this.updateCurCard(ctx, (FaRequisitionedBillInfo)model);
        String id = pk != null ? pk.toString() : (model.getId() == null ? null : model.getId().toString().toString());
        this.checkCardHasRequisitioned(ctx, (FaRequisitionedBillInfo)model);
        super._submitSelf(ctx, pk, model);
        this.updateCurCardBySQL(ctx, FaBizStatusEnum.REQUISITIONING.getValue(), id, "select FCurcardID from T_FA_FaRequisitionedBillEntry where FParentID='" + id + "'");
    }

    @Override
    protected IObjectPK _submitSelf(Context ctx, FaBillBaseInfo model) throws BOSException, EASBizException {
        this.updateCurCard(ctx, (FaRequisitionedBillInfo)model);
        this.checkCardHasRequisitioned(ctx, (FaRequisitionedBillInfo)model);
        IObjectPK pk = super._submitSelf(ctx, model);
        String id = pk != null ? pk.toString() : model.getId().toString();
        this.updateCurCardBySQL(ctx, FaBizStatusEnum.REQUISITIONING.getValue(), id, "select FCurcardID from T_FA_FaRequisitionedBillEntry where FParentID='" + id + "'");
        return pk;
    }

    @Override
    protected void verfyBeforeAudit(IObjectValue model) throws BOSException, EASBizException {
        super.verfyBeforeAudit(model);
        FaRequisitionedBillInfo info = (FaRequisitionedBillInfo)model;
        if (info.getEntrys() == null || info.getEntrys().size() == 0) {
            throw new FaPhysicalManageBaseException(FaPhysicalManageBaseException.ENTRYNULL, new Object[0]);
        }
    }

    @Override
    protected SelectorItemCollection getSelfSelctor() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("auditor.id"));
        sic.add(new SelectorItemInfo("handler.id"));
        sic.add(new SelectorItemInfo("period.id"));
        sic.add("company.id");
        sic.add("Entrys.id");
        sic.add("Entrys.faCurCard.isBorrowing");
        sic.add("Entrys.faCurCard.bizStatus");
        sic.add("Entrys.faCurCard.id");
        sic.add("Entrys.faCurCard.number");
        sic.add("Entrys.faChangeBill.id");
        sic.add("user.id");
        sic.add("userDispartment.id");
        sic.add("userDispartment.isLeaf");
        sic.add("CU.id");
        sic.add("Entrys.faCurCard.faCurDepartment.*");
        sic.add("Entrys.faCurCard.isRequisitioned");
        return sic;
    }

    @Override
    protected void _unpassAudit(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        super._unpassAudit(ctx, pk);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        super._unpassAudit(ctx, pk, model);
    }

    @Override
    protected void _passAuditSelf(Context ctx, IObjectPK pk, FaBillBaseInfo model) throws BOSException, EASBizException {
        this.updateCurCard(ctx, (FaRequisitionedBillInfo)model);
        super._passAuditSelf(ctx, pk, model);
        String strValue = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(model.getCompany().getId().toString()), "FA_044");
        if (strValue != null && Boolean.valueOf(strValue.trim()).booleanValue()) {
            FaRequisitionedBillInfo info = (FaRequisitionedBillInfo)model;
            int n = info.getEntrys().size();
            for (int i = 0; i < n; ++i) {
                try {
                    this._createNewFaChangeBills(ctx, info, info.getEntrys().get(i));
                    continue;
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        this.updateCurCardBySQL(ctx, FaBizStatusEnum.HAVE_REQUISITIONED.getValue(), pk.toString(), "select FCurcardID from T_FA_FaRequisitionedBillEntry where FParentID='" + pk.toString() + "'");
    }

    private void _createNewFaChangeBills(Context ctx, FaRequisitionedBillInfo bill, FaRequisitionedBillEntryInfo entryInfo) throws BOSException, EASBizException, SQLException {
        FaCurCardInfo facurcard = this.getFaCurCards(ctx, entryInfo);
        if (facurcard == null) {
            return;
        }
        boolean flag = this.checkFacurCard(ctx, facurcard);
        if (flag) {
            FaChangeBillInfo changeBillInfo = this.getChangetBillTemplate(ctx, facurcard);
            changeBillInfo.setSourceBillId(bill.getId().toString());
            FaBizCardInfo bizCard = changeBillInfo.getChangeBillEntry().get(0).getBizCard();
            this.setKeeperAndUser(bizCard, bill);
            IFaChangeBill ifachangeBill = FaChangeBillFactory.getLocalInstance(ctx);
            ifachangeBill.addnew((CoreBaseInfo)changeBillInfo);
            new PrcFaChangeStrategy().auditBill(ctx, (IObjectValue)changeBillInfo);
            entryInfo.setFaChangebill(changeBillInfo);
            String sql = "update T_FA_FaRequisitionedBillEntry set FFaChangeBillID=? where FID=?";
            DBUtilx.execute((String)sql, (SqlParams)new SqlParams().addString(changeBillInfo.getId().toString()).addString(entryInfo.getId().toString()), (Context)ctx);
        }
    }

    @Override
    protected void _deleteSelf(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = this.getSelfSelctor();
        sic.add("Entrys.bizCard.id");
        sic.add("Entrys.bizCard.bizStatus");
        sic.add("Entrys.bizCard.lastBillID");
        FaRequisitionedBillInfo info = this.getFaRequisitionedBillInfo(ctx, pk, sic);
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            FaRequisitionedBillEntryInfo entryInfo = info.getEntrys().get(i);
            if (entryInfo.getBizCard() == null || entryInfo.getBizCard().getBizStatus() == null) continue;
            FaLastPeriodChangeUtils.updateCurCardBySQL(ctx, entryInfo.getBizCard().getBizStatus().getValue(), entryInfo.getBizCard().getLastBillID(), entryInfo.getFaCurCard().getId().toString(), entryInfo.getBizCard().isLastPeriodChange());
        }
        super._deleteSelf(ctx, pk);
    }

    @Override
    protected void _deleteSelf(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        if (arrayPK == null || arrayPK.length == 0) {
            return;
        }
        for (int k = 0; k < arrayPK.length; ++k) {
            SelectorItemCollection sic = this.getSelfSelctor();
            sic.add("Entrys.bizCard.bizStatus");
            sic.add("Entrys.bizCard.lastBillID");
            sic.add("Entrys.bizCard.lastPeriodChange");
            FaRequisitionedBillInfo info = this.getFaRequisitionedBillInfo(ctx, arrayPK[k], sic);
            for (int i = 0; i < info.getEntrys().size(); ++i) {
                FaRequisitionedBillEntryInfo entryInfo = info.getEntrys().get(i);
                FaLastPeriodChangeUtils.updateCurCardBySQL(ctx, entryInfo.getBizCard().getBizStatus().getValue(), entryInfo.getBizCard().getLastBillID(), entryInfo.getFaCurCard().getId().toString(), entryInfo.getBizCard().isLastPeriodChange());
            }
        }
        super._deleteSelf(ctx, arrayPK);
    }

    private void setKeeperAndUser(FaBizCardInfo bizCard, FaRequisitionedBillInfo billInfo) {
        bizCard.setDept(billInfo.getUserDispartment());
        bizCard.setKeeper(billInfo.getUser());
        FaBizDepartmentCollection bizDepartmentColl = bizCard.getFaBizDepartment();
        if (bizDepartmentColl == null || bizDepartmentColl.size() == 0) {
            return;
        }
        FaBizDepartmentInfo bizDepartmentInfo = bizDepartmentColl.get(0);
        int n = bizDepartmentColl.size();
        for (int i = 0; i < n; ++i) {
            if (bizDepartmentColl.get(i).getSeq() != 1) continue;
            bizDepartmentInfo = bizDepartmentColl.get(i);
            break;
        }
        bizDepartmentInfo.setUsePerson(billInfo.getUser());
        bizDepartmentInfo.setUseDepartment(billInfo.getUserDispartment());
        if (!billInfo.getUserDispartment().isIsLeaf()) {
            return;
        }
        String newOrgID = billInfo.getUserDispartment().getId().toString();
        FaBizCostCenterCollection costCenterColl = bizCard.getFaBizCostCenter();
        block1: for (int i = 0; i < costCenterColl.size(); ++i) {
            FaBizCostCenterInfo costCenterInfo = costCenterColl.get(i);
            for (int j = 0; j < costCenterInfo.getFaBizAsstActComposit().size(); ++j) {
                AssistActItemInfo asstactItem;
                FaBizAsstActCompositInfo actCompostion = costCenterInfo.getFaBizAsstActComposit().get(j);
                if (actCompostion == null || actCompostion.getAsstActType() == null || !"T_ORG_Admin".equalsIgnoreCase(actCompostion.getAsstActType().getRealtionDataObject()) || (asstactItem = actCompostion.getAsstActItem()) == null) continue;
                asstactItem = new AssistActItemInfo();
                asstactItem.setId(BOSUuid.read((String)newOrgID));
                actCompostion.setAsstActItem(asstactItem);
                continue block1;
            }
        }
    }

    private FaCurCardInfo getFaCurCards(Context ctx, FaRequisitionedBillEntryInfo entryInfo) throws BOSException {
        SelectorItemCollection sic = PrcFaCoreManager.getCurCardSelectors();
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(sic);
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)new Integer(2)));
        f.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
        f.getFilterItems().add(new FilterItemInfo("effectedStatus", (Object)new Integer(2)));
        f.getFilterItems().add(new FilterItemInfo("blockedStatus", (Object)new Integer(1)));
        f.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)FaBizStatusEnum.REQUISITIONING.getValue(), CompareType.EQUALS));
        f.getFilterItems().add(new FilterItemInfo("id", (Object)entryInfo.getFaCurCard().getId()));
        view.setFilter(f);
        FaCurCardCollection cols = FaCurCardFactory.getLocalInstance(ctx).getFaCurCardCollection(view);
        if (cols == null || cols.size() == 0) {
            return null;
        }
        return cols.get(0);
    }

    public Set getFaBizStatusEnumSet() {
        if (bizState.isEmpty()) {
            bizState.add(FaBizStatusEnum.REQUISITIONING);
        }
        return bizState;
    }

    private boolean checkFacurCard(Context ctx, FaCurCardInfo facurcard) {
        return true;
    }

    @Override
    protected void _unpassAuditSelf(Context ctx, IObjectPK pk, FaBillBaseInfo model) throws BOSException, EASBizException {
        String id;
        super._unpassAuditSelf(ctx, pk, model);
        String string = id = pk != null ? pk.toString() : model.getId().toString();
        if (model == null) {
            model = this.getFaBillBaseInfo(ctx, pk, this.getSelfSelctor());
        }
        FaRequisitionedBillInfo info = (FaRequisitionedBillInfo)model;
        int n = info.getEntrys().size();
        for (int i = 0; i < n; ++i) {
            FaChangeBillInfo obj = info.getEntrys().get(i).getFaChangebill();
            if (obj == null) continue;
            FaChangeBillInfo changeBillInfo = FaChangeBillFactory.getLocalInstance(ctx).getFaChangeBillInfo((IObjectPK)new ObjectUuidPK(obj.getId().toString()), this.getChangeBillSelectors());
            new PrcFaChangeStrategy().unAuditBill(ctx, (IObjectValue)changeBillInfo);
            new PrcFaChangeStrategy().deleteBill(ctx, (IObjectPK)new ObjectUuidPK(obj.getId().toString()));
        }
        String sql = "update T_FA_FaRequisitionedBillEntry set FFaChangeBillID=null where FParentID=?";
        try {
            DBUtilx.execute((String)sql, (SqlParams)new SqlParams().addString(id), (Context)ctx);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        this.updateCurCardBySQL(ctx, FaBizStatusEnum.REQUISITIONING.getValue(), pk.toString(), "select FCurcardID from T_FA_FaRequisitionedBillEntry where FParentID='" + pk.toString() + "'");
    }

    private SelectorItemCollection getChangeBillSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("fiVouchered"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("changeMode.*"));
        sic.add(new SelectorItemInfo("changeBillEntry.*"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.faBakCard.id"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.number"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.assetValue"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.assetAmt"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.buyValue"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.buyAccuDepr"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.accuDepr"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.accuDeprTYear"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.decValue"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.isNeedReDepr"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.fiVouchered"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.tempDeprMethod"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.tempDeprTermCount"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.deprTermCount"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.deprMethod.*"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.currency.*"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.fiAccountDate"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.evalAssetValue"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.evalAddDepr"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.evalYearDepr"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.evalDecValue"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.evalDeprPeriodNum"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.evalDeprMode.*"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.accountAsset.number"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.accountAccuDepr.number"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.accountDecValue.number"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.voucher.id"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.voucherNumber"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.faBakCard.accountAsset.number"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.faBakCard.accountAccuDepr.number"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.faBakCard.accountDecValue.number"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.faBakCard.assetValue"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.faBakCard.accuDepr"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.faBakCard.decValue"));
        return sic;
    }

    private void checkCardHasRequisitioned(Context ctx, FaRequisitionedBillInfo model) throws BOSException, EASBizException {
        FaRequisitionedBillEntryCollection cols = model.getEntrys();
        String billID = model.getId() == null ? null : model.getId().toString();
        int n = cols.size();
        for (int i = 0; i < n; ++i) {
            FaCurCardInfo cardInfo = cols.get(i).getFaCurCard();
            if (billID != null && billID.equalsIgnoreCase(cardInfo.getLastBillID())) continue;
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("bizStatus");
            FaCurCardInfo facurcardInfo = FaCurCardFactory.getLocalInstance(ctx).getFaCurCardInfo((IObjectPK)new ObjectUuidPK(cardInfo.getId().toString()), sic);
            if (!facurcardInfo.getBizStatus().getValue().toString().endsWith("01")) continue;
            throw new FaPhysicalManageBaseException(FaPhysicalManageBaseException.EXSITYW_LY, new Object[]{cardInfo.getNumber(), facurcardInfo.getBizStatus().getAlias()});
        }
    }

    private FaChangeBillInfo getChangetBillTemplate(Context ctx, FaCurCardInfo faCurCard) throws EASBizException, BOSException {
        FaChangeBillInfo changeBillInfo = new FaChangeBillInfo();
        changeBillInfo.setBillType(FaBillOriginEnum.FPOM_REQUISITIONED);
        changeBillInfo.setDescription(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"creatChangeBillByRequisition", (Locale)ctx.getOriginLocale()));
        changeBillInfo.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        changeBillInfo.setSourceBillId(null);
        changeBillInfo.setCompany(faCurCard.getCompany());
        changeBillInfo.setCU(faCurCard.getCU());
        PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)faCurCard.getCompany());
        Date today = DateTimeUtils.truncateDate((Date)new Date());
        if (today.after(periodInfo.getEndDate())) {
            changeBillInfo.setChangeDate(periodInfo.getEndDate());
        } else if (today.before(periodInfo.getBeginDate())) {
            changeBillInfo.setChangeDate(periodInfo.getBeginDate());
        } else {
            changeBillInfo.setChangeDate(today);
        }
        changeBillInfo.setBizDate(DateTimeUtils.truncateDate((Date)new Date()));
        changeBillInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
        changeBillInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        changeBillInfo.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        changeBillInfo.setFiVouchered(false);
        changeBillInfo.setHandler(ContextUtil.getCurrentUserInfo((Context)ctx));
        changeBillInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        changeBillInfo.setChangeMode(faCurCard.getOriginMethod());
        FaBakCardInfo bakCard = PrcFaCoreManager.CurCard2BakCard(faCurCard);
        bakCard.setFaCurCard(faCurCard);
        bakCard.setBillType(FaBillTypeEnum.CHANGE);
        FaChangeBillEntryInfo cgBillentryInfo = new FaChangeBillEntryInfo();
        FaBizCardInfo bizCard = PrcFaCoreManager.CurCard2BizCard(faCurCard);
        bizCard.setFaBakCard(bakCard);
        bizCard.setBillType(FaBillTypeEnum.CHANGE);
        bakCard.setId((BOSUuid)FaBakCardFactory.getLocalInstance(ctx).submit((CoreBaseInfo)bakCard).getKeyValue("id"));
        cgBillentryInfo.setBizCard(bizCard);
        cgBillentryInfo.setCurCard(faCurCard);
        BigDecimal ZERO = new BigDecimal(0);
        cgBillentryInfo.setOriginChg(ZERO);
        cgBillentryInfo.setAccuDeprChg(ZERO);
        cgBillentryInfo.setDecValueChg(ZERO);
        changeBillInfo.getChangeBillEntry().add(cgBillentryInfo);
        this.setChangeBillNewNumber(ctx, changeBillInfo, 100);
        return changeBillInfo;
    }

    protected void setChangeBillNewNumber(Context ctx, FaChangeBillInfo billInfo, int deepNo) throws EASBizException, BOSException {
        if (deepNo == 0) {
            throw new CodingRuleException(CodingRuleException.ERROR_REFERENCE_INVALID);
        }
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = billInfo.getCompany();
        if (aCompanyOrgUnitInfo == null) {
            aCompanyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        String strCompanyId = aCompanyOrgUnitInfo.getId().toString();
        String number = iCodingRuleManager.getNumber((IObjectValue)billInfo, strCompanyId);
        billInfo.setNumber(number);
        if (this.existChangeBillNumber(ctx, billInfo)) {
            this.setChangeBillNewNumber(ctx, billInfo, deepNo - 1);
        }
    }

    protected boolean existChangeBillNumber(Context ctx, FaChangeBillInfo billInfo) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FID FROM T_FA_FACHANGEBILL WHERE FNUMBER = '");
        sql.append(billInfo.getNumber()).append("'");
        sql.append(" AND FCOMPANYID = '").append(billInfo.getCompany().getId().toString()).append("'");
        if (billInfo.getId() != null) {
            sql.append(" AND FID != '").append(billInfo.getId().toString()).append("'");
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            return rowSet.next();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void checkBeforeSave(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaRequisitionedBillInfo requisitionedBill = (FaRequisitionedBillInfo)model;
        FaRequisitionedBillEntryCollection entryColl = requisitionedBill.getEntrys();
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            FaCurCardInfo card = entryColl.get(i).getFaCurCard();
            if (card == null || card.getId() == null || card.getLastUpdateTime() == null) continue;
            FaBillBizProcessor.lockFaCurCard(ctx, card.getId().toString());
            FaBillBizProcessor.checkFaCurCardVersion(ctx, card.getId().toString(), card.getLastUpdateTime());
        }
    }

    @Override
    protected void checkBeforeSubmit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaRequisitionedBillInfo requisitionedBill = (FaRequisitionedBillInfo)model;
        FaRequisitionedBillEntryCollection entryColl = requisitionedBill.getEntrys();
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            FaCurCardInfo card = entryColl.get(i).getFaCurCard();
            if (card == null || card.getId() == null || card.getLastUpdateTime() == null) continue;
            FaBillBizProcessor.lockFaCurCard(ctx, card.getId().toString());
            FaBillBizProcessor.checkFaCurCardVersion(ctx, card.getId().toString(), card.getLastUpdateTime());
        }
    }
}

