/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaBillBaseInfo;
import com.kingdee.eas.fi.fa.manage.FaBillBizProcessor;
import com.kingdee.eas.fi.fa.manage.FaBizStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaPhysicalManageBaseException;
import com.kingdee.eas.fi.fa.manage.FaReturnEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaReturnEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaReturnInfo;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaReturnControllerBean;
import com.kingdee.eas.fi.fa.manage.app.FaLastPeriodChangeUtils;
import com.kingdee.eas.framework.report.util.DBUtilx;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class FaReturnControllerBean
extends AbstractFaReturnControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.manage.app.FaReturnControllerBean");

    @Override
    public String getMasterTable() {
        return "T_FA_FaReturn";
    }

    @Override
    protected void verfyBeforeAudit(IObjectValue model) throws BOSException, EASBizException {
        super.verfyBeforeAudit(model);
        FaReturnInfo info = (FaReturnInfo)model;
        if (null == info.getEntry() || info.getEntry().size() == 0) {
            throw new FaPhysicalManageBaseException(FaPhysicalManageBaseException.ENTRY_RETURN_NULL, new Object[0]);
        }
    }

    @Override
    protected SelectorItemCollection getSelfSelctor() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("auditor.id"));
        sic.add(new SelectorItemInfo("handler.id"));
        sic.add(new SelectorItemInfo("period.id"));
        sic.add("company.id");
        sic.add("entry.id");
        sic.add("entry.faCurCard.isBorrowing");
        sic.add("entry.faCurCard.bizStatus");
        sic.add("entry.faCurCard.id");
        sic.add("entry.faCurCard.number");
        sic.add("user.id");
        sic.add("userDispartment.id");
        sic.add("userDispartment.isLeaf");
        sic.add("CU.id");
        sic.add("entry.faCurCard.faCurDepartment.*");
        sic.add("entry.faCurCard.isRequisitioned");
        return sic;
    }

    protected void updateCurCard(Context ctx, FaReturnInfo newInfo) throws EASBizException, BOSException {
        FaReturnEntryInfo entryInfo;
        int i;
        if (newInfo.getId() == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(newInfo.getId().toString());
        SelectorItemCollection sic = this.getSelfSelctor();
        sic.add("entry.bizCard.id");
        sic.add("entry.bizCard.bizStatus");
        sic.add("entry.bizCard.lastBillID");
        HashSet<String> set = new HashSet<String>();
        FaReturnInfo info = this.getFaReturnInfo(ctx, (IObjectPK)pk, sic);
        for (i = 0; i < info.getEntry().size(); ++i) {
            entryInfo = info.getEntry().get(i);
            if (entryInfo.getBizCard() == null) continue;
            set.add(entryInfo.getFaCurCard().getId().toString());
        }
        for (i = 0; i < newInfo.getEntry().size(); ++i) {
            entryInfo = newInfo.getEntry().get(i);
            if (entryInfo.getId() == null || entryInfo.getBizCard() == null) continue;
            set.remove(entryInfo.getFaCurCard().getId().toString());
        }
        if (set.isEmpty()) {
            return;
        }
        for (i = 0; i < info.getEntry().size(); ++i) {
            entryInfo = info.getEntry().get(i);
            if (entryInfo.getBizCard() == null || !set.contains(entryInfo.getFaCurCard().getId().toString())) continue;
            FaLastPeriodChangeUtils.updateCurCardBySQL(ctx, entryInfo.getBizCard().getBizStatus().getValue(), entryInfo.getBizCard().getLastBillID(), entryInfo.getFaCurCard().getId().toString(), entryInfo.getBizCard().isLastPeriodChange());
        }
    }

    @Override
    protected void _saveSelf(Context ctx, IObjectPK pk, FaBillBaseInfo model) throws BOSException, EASBizException {
        this.updateCurCard(ctx, (FaReturnInfo)model);
        super._saveSelf(ctx, pk, model);
        String bizStatus = FaBizStatusEnum.RETURNING.getValue();
        String lastBillID = pk.toString();
        String curCardIDsql = "select FCurcardID from T_Fa_FaReturnEntry where FParentID = '" + lastBillID + "'";
        this.updateCurCardBySQL(ctx, bizStatus, lastBillID, curCardIDsql);
    }

    @Override
    protected IObjectPK _saveSelf(Context ctx, FaBillBaseInfo model) throws BOSException, EASBizException {
        this.updateCurCard(ctx, (FaReturnInfo)model);
        IObjectPK pk = super._saveSelf(ctx, model);
        String bizStatus = FaBizStatusEnum.RETURNING.getValue();
        String lastBillID = pk.toString();
        String curCardIDsql = "select FCurcardID from T_Fa_FaReturnEntry where FParentID = '" + lastBillID + "'";
        this.updateCurCardBySQL(ctx, bizStatus, lastBillID, curCardIDsql);
        return pk;
    }

    @Override
    protected void _submitSelf(Context ctx, IObjectPK pk, FaBillBaseInfo model) throws BOSException, EASBizException {
        this.verfyBeforeSubmit(ctx, (FaReturnInfo)model);
        this.updateCurCard(ctx, (FaReturnInfo)model);
        super._submitSelf(ctx, pk, model);
        String bizStatus = FaBizStatusEnum.RETURNING.getValue();
        String lastBillID = pk != null ? pk.toString() : (model.getId() == null ? null : model.getId().toString());
        String curCardIDsql = "select FCurcardID from T_Fa_FaReturnEntry where FParentID = '" + lastBillID + "'";
        this.updateCurCardBySQL(ctx, bizStatus, lastBillID, curCardIDsql);
    }

    @Override
    protected IObjectPK _submitSelf(Context ctx, FaBillBaseInfo model) throws BOSException, EASBizException {
        this.verfyBeforeSubmit(ctx, (FaReturnInfo)model);
        this.updateCurCard(ctx, (FaReturnInfo)model);
        IObjectPK pk = super._submitSelf(ctx, model);
        String lastBillID = pk != null ? pk.toString() : (model.getId() == null ? null : model.getId().toString());
        String bizStatus = FaBizStatusEnum.RETURNING.getValue();
        String curCardIDsql = "select FCurcardID from T_Fa_FaReturnEntry where FParentID = '" + lastBillID + "'";
        this.updateCurCardBySQL(ctx, bizStatus, lastBillID, curCardIDsql);
        return pk;
    }

    private void verfyBeforeSubmit(Context ctx, FaReturnInfo newInfo) throws EASBizException, BOSException {
        ArrayList<Date> list = new ArrayList<Date>();
        for (int i = 0; i < newInfo.getEntry().size(); ++i) {
            FaReturnEntryInfo entryInfo = newInfo.getEntry().get(i);
            String curCardID = entryInfo.getFaCurCard().getId().toString();
            String parentIDsql = "select FParentID from T_Fa_FaBorrowingEntry where FCurCardID = '" + curCardID + "'";
            String sql = "select FBizDate from T_Fa_FaBorrowing where fid in (" + parentIDsql + ") order by fcreatetime desc";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                if (!rs.next()) continue;
                list.add(rs.getDate("FBizDate"));
                continue;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        java.util.Date maxDate = (java.util.Date)Collections.max(list);
        if (newInfo.getBizDate().before(maxDate)) {
            throw new FaPhysicalManageBaseException(FaPhysicalManageBaseException.RETURNDATEERROR, new Object[0]);
        }
    }

    @Override
    protected void _unpassAudit(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        super._unpassAudit(ctx, pk);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        super._unpassAudit(ctx, pk, model);
    }

    @Override
    protected void _unpassAuditSelf(Context ctx, IObjectPK pk, FaBillBaseInfo model) throws BOSException, EASBizException {
        super._unpassAuditSelf(ctx, pk, model);
        String bizStatus = FaBizStatusEnum.RETURNING.getValue();
        String lastBillID = pk.toString();
        String curCardIDsql = "select FCurcardID from T_Fa_FaReturnEntry where FParentID = '" + lastBillID + "'";
        this.updateCurCardBySQL(ctx, bizStatus, lastBillID, curCardIDsql);
        String temp = "unpassAuditSelf";
        FaReturnInfo info = (FaReturnInfo)model;
        int n = info.getEntry().size();
        for (int i = 0; i < n; ++i) {
            this.updateFaBorrowingInfoBySQL(ctx, ((FaReturnInfo)model).getEntry().get(i).getFaCurCard().getId().toString(), temp);
        }
    }

    @Override
    protected void _passAuditSelf(Context ctx, IObjectPK pk, FaBillBaseInfo model) throws BOSException, EASBizException {
        this.updateCurCard(ctx, (FaReturnInfo)model);
        super._passAuditSelf(ctx, pk, model);
        String lastBillID = pk.toString();
        String bizStatus = FaBizStatusEnum.HAVE_RETURNED.getValue();
        String curCardIDsql = "select FCurcardID from T_Fa_FaReturnEntry where FParentID='" + lastBillID + "'";
        this.updateCurCardBySQL(ctx, bizStatus, lastBillID, curCardIDsql);
        String temp = "passAuditSelf";
        FaReturnInfo info = (FaReturnInfo)model;
        int n = info.getEntry().size();
        for (int i = 0; i < n; ++i) {
            this.updateFaBorrowingInfoBySQL(ctx, ((FaReturnInfo)model).getEntry().get(i).getFaCurCard().getId().toString(), temp);
        }
    }

    private void updateFaBorrowingInfoBySQL(Context ctx, String curcardID, String temp) throws BOSException {
        String parentIDsql = "select FParentID from T_Fa_FaReturnEntry where FCurCardID = ?";
        String sql = "select FBizDate from T_Fa_FaReturn where fid in (" + parentIDsql + ") order by fcreatetime desc";
        SqlParams sp = new SqlParams();
        sp.addString(curcardID);
        if (temp.equals("passAuditSelf")) {
            try {
                RptRowSet rs = DBUtilx.executeQuery((String)sql, (SqlParams)sp, (Context)ctx);
                sp.clear();
                if (rs.next()) {
                    Timestamp timestamp = (Timestamp)rs.getObject("FBizDate");
                    sp.addDate(new Date(timestamp.getTime()));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            sp.addInt(1);
        } else if (temp.equals("unpassAuditSelf")) {
            sp.clear();
            sp.addDate(null);
            sp.addInt(0);
        }
        sp.addString(curcardID);
        sp.addString(curcardID);
        String sql1 = "select top 1 entry.fid  from T_Fa_FaBorrowingEntry entry left join T_Fa_FaBorrowing parent on parent.fid=entry.fparentid where entry.fcurcardid=?  order by fcreatetime desc";
        String updateSql = "update T_Fa_FaBorrowingEntry set Factualreturndate = ?,Fisreturned = ? where FCurCardID =? and fid in(" + sql1 + ")";
        try {
            DBUtilx.execute((String)updateSql, (SqlParams)sp, (Context)ctx);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _deleteSelf(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = this.getSelfSelctor();
        sic.add("entry.bizCard.id");
        sic.add("entry.bizCard.bizStatus");
        sic.add("entry.bizCard.lastBillID");
        FaReturnInfo info = this.getFaReturnInfo(ctx, pk, sic);
        for (int i = 0; i < info.getEntry().size(); ++i) {
            FaReturnEntryInfo entryInfo = info.getEntry().get(i);
            if (entryInfo.getBizCard() == null || entryInfo.getBizCard().getBizStatus() == null) continue;
            String bizStatus = entryInfo.getBizCard().getBizStatus().getValue();
            String lastBillID = entryInfo.getBizCard().getLastBillID();
            String curCardID = entryInfo.getFaCurCard().getId().toString();
            boolean isLastPeriodChange = entryInfo.getBizCard().isLastPeriodChange();
            FaLastPeriodChangeUtils.updateCurCardBySQL(ctx, bizStatus, lastBillID, curCardID, isLastPeriodChange);
        }
        super._deleteSelf(ctx, pk);
    }

    @Override
    protected void _deleteSelf(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        if (arrayPK == null || arrayPK.length == 0) {
            return;
        }
        for (int k = 0; k < arrayPK.length; ++k) {
            SelectorItemCollection sic = this.getSelfSelctor();
            sic.add("entry.bizCard.bizStatus");
            sic.add("entry.bizCard.lastBillID");
            sic.add("entry.bizCard.lastPeriodChange");
            FaReturnInfo info = this.getFaReturnInfo(ctx, arrayPK[k], sic);
            for (int i = 0; i < info.getEntry().size(); ++i) {
                FaReturnEntryInfo entryInfo = info.getEntry().get(i);
                String bizStatus = entryInfo.getBizCard().getBizStatus().getValue();
                String lastBillID = entryInfo.getBizCard().getLastBillID();
                String curCardID = entryInfo.getFaCurCard().getId().toString();
                boolean isLastPeriodChange = entryInfo.getBizCard().isLastPeriodChange();
                FaLastPeriodChangeUtils.updateCurCardBySQL(ctx, bizStatus, lastBillID, curCardID, isLastPeriodChange);
            }
        }
        super._deleteSelf(ctx, arrayPK);
    }

    @Override
    protected void checkBeforeSave(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaReturnInfo returnBill = (FaReturnInfo)model;
        FaReturnEntryCollection entryColl = returnBill.getEntry();
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            FaCurCardInfo card = entryColl.get(i).getFaCurCard();
            if (card == null || card.getId() == null || card.getLastUpdateTime() == null) continue;
            FaBillBizProcessor.lockFaCurCard(ctx, card.getId().toString());
            FaBillBizProcessor.checkFaCurCardVersion(ctx, card.getId().toString(), card.getLastUpdateTime());
        }
    }

    @Override
    protected void checkBeforeSubmit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaReturnInfo returnBill = (FaReturnInfo)model;
        FaReturnEntryCollection entryColl = returnBill.getEntry();
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            FaCurCardInfo card = entryColl.get(i).getFaCurCard();
            if (card == null || card.getId() == null || card.getLastUpdateTime() == null) continue;
            FaBillBizProcessor.lockFaCurCard(ctx, card.getId().toString());
            FaBillBizProcessor.checkFaCurCardVersion(ctx, card.getId().toString(), card.getLastUpdateTime());
        }
    }
}

