/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaAppLogForBusinessTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaBillBaseInfo;
import com.kingdee.eas.fi.fa.manage.FaBillBizProcessor;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaSplitBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaSplitBillEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaSplitBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaSplitBillFactory;
import com.kingdee.eas.fi.fa.manage.FaSplitBillInfo;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaSplitBillControllerBean;
import com.kingdee.eas.fi.fa.manage.app.AbstractPrcFaManageStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaLastPeriodChangeUtils;
import com.kingdee.eas.fi.fa.manage.app.PrcFaSplitStrategy;
import com.kingdee.eas.fi.fa.manage.app.falog.event.FaMethodCalcOrderEnum;
import com.kingdee.eas.fi.fa.manage.app.falog.utils.FaRPCMethodMappingUtils;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class FaSplitBillControllerBean
extends AbstractFaSplitBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.manage.app.FaSplitBillControllerBean");

    @Override
    protected AbstractPrcFaManageStrategy getBillStrategy() {
        return new PrcFaSplitStrategy();
    }

    @Override
    protected FaCurCardCollection _split(Context ctx, IObjectPK pk, int splitType) throws BOSException, EASBizException {
        FaCurCardInfo curCard = FaCurCardFactory.getLocalInstance(ctx).getFaCurCardInfo(pk);
        return PrcFaSplitStrategy.splitCard(curCard, splitType);
    }

    @Override
    protected void _passAuditSelf(Context ctx, IObjectPK pk, FaBillBaseInfo model) throws BOSException, EASBizException {
        FaSplitBillInfo billInfo = (FaSplitBillInfo)model;
        billInfo.setCheckedStatus(CheckedStatusEnum.AUDITED);
        billInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        billInfo.setAuditTime(new Date());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("checkedStatus"));
        selector.add(new SelectorItemInfo("auditor"));
        selector.add(new SelectorItemInfo("auditTime"));
        selector.add(new SelectorItemInfo("faSplitBillEntry.faCurCard"));
        super.update(ctx, pk, (CoreBaseInfo)billInfo);
        FaLastPeriodChangeUtils.updateCardLastPeriodChange(ctx, model.getCompany().getId().toString(), pk.toString(), 4);
    }

    @Override
    protected void _unpassAuditSelf(Context ctx, IObjectPK pk, FaBillBaseInfo model) throws BOSException, EASBizException {
        FaLastPeriodChangeUtils.updateCardLastPeriodChange(ctx, model.getCompany().getId().toString(), pk.toString(), 5);
    }

    @Override
    protected SelectorItemCollection getSelfSelctor() {
        SelectorItemCollection sic = super.getSelfSelctor();
        sic.add(new SelectorItemInfo("faSplitBillEntry.id"));
        sic.add(new SelectorItemInfo("faSplitBillEntry.faBizCard.faBakCard.id"));
        sic.add(new SelectorItemInfo("faSplitBillEntry.faBizCard.company.id"));
        sic.add(new SelectorItemInfo("faSplitBillEntry.faBizCard.id"));
        sic.add(new SelectorItemInfo("faSplitBillEntry.faCurCard.*"));
        sic.add(new SelectorItemInfo("faSplitBillEntry.faCurCard.company.id"));
        sic.add(new SelectorItemInfo("faSplitBillEntry.faCurCard.deprMethod.number"));
        sic.add(new SelectorItemInfo("faSplitBillEntry.faCurCard.deprMethod.isWorkload"));
        sic.add(new SelectorItemInfo("faBizCard.faBakCard.id"));
        sic.add(new SelectorItemInfo("faBizCard.faBakCard.bizStatus"));
        sic.add(new SelectorItemInfo("faBizCard.faBakCard.lastBillID"));
        sic.add(new SelectorItemInfo("faBizCard.faBakCard.hasCleared"));
        sic.add(new SelectorItemInfo("faBizCard.faBakCard.assetAmt"));
        sic.add(new SelectorItemInfo("faBizCard.faBakCard.lastEvalValue"));
        sic.add(new SelectorItemInfo("faBizCard.faBakCard.initEvalValue"));
        sic.add(new SelectorItemInfo("faBizCard.id"));
        sic.add(new SelectorItemInfo("faCurCard.*"));
        sic.add(new SelectorItemInfo("faCurCard.company.id"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("clearMode.id"));
        sic.add(new SelectorItemInfo("faClearBill.id"));
        sic.add(new SelectorItemInfo("faClearBill.number"));
        sic.add(new SelectorItemInfo("faClearBill.fiVouchered"));
        sic.add(new SelectorItemInfo("splitDate"));
        return sic;
    }

    @Override
    public String getMasterTable() {
        return "T_FA_FASPLITBILL";
    }

    @Override
    protected void checkBeforeSave(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaSplitBillInfo splitBill = (FaSplitBillInfo)model;
        FaCurCardInfo card = splitBill.getFaCurCard();
        if (card != null && card.getId() != null && card.getLastUpdateTime() != null) {
            FaBillBizProcessor.lockFaCurCard(ctx, card.getId().toString());
            FaBillBizProcessor.checkFaCurCardVersion(ctx, card.getId().toString(), card.getLastUpdateTime());
        }
    }

    @Override
    protected void checkBeforeSubmit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaSplitBillInfo splitBill = (FaSplitBillInfo)model;
        FaCurCardInfo card = splitBill.getFaCurCard();
        if (card != null && card.getId() != null && card.getLastUpdateTime() != null) {
            FaBillBizProcessor.lockFaCurCard(ctx, card.getId().toString());
            FaBillBizProcessor.checkFaCurCardVersion(ctx, card.getId().toString(), card.getLastUpdateTime());
        }
    }

    @Override
    protected void _passAudit(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        FaSplitBillInfo faSplitBillInfo = FaSplitBillFactory.getLocalInstance(ctx).getFaSplitBillInfo(pk);
        FaSplitBillEntryCollection faSplitBillEntryCollection = faSplitBillInfo.getFaSplitBillEntry();
        if (this.isCurrencyDisable(ctx, faSplitBillEntryCollection)) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"CurrencyDisable", (Locale)ctx.getOriginLocale()));
            throw new FaCardException(FaCardException.CURRENCYDISABLEFORSPLIT_AUDIT, new String[]{" " + sbAll.toString() + " "});
        }
        super._passAudit(ctx, pk);
    }

    private boolean isCurrencyDisable(Context ctx, FaSplitBillEntryCollection faSplitBillEntryCollection) throws EASBizException, BOSException {
        boolean isDisable = false;
        int size = faSplitBillEntryCollection.size();
        for (int i = 0; i < size; ++i) {
            FaSplitBillEntryInfo faSplitBillEntryInfo = faSplitBillEntryCollection.get(i);
            if (faSplitBillEntryInfo != null && faSplitBillEntryInfo.getId() != null) {
                CurrencyInfo currencyInfo;
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("fabizcard.id"));
                sic.add(new SelectorItemInfo("fabizcard.Currency.id"));
                sic.add(new SelectorItemInfo("fabizcard.Currency.name"));
                sic.add(new SelectorItemInfo("fabizcard.Currency.number"));
                faSplitBillEntryInfo = (FaSplitBillEntryInfo)FaSplitBillEntryFactory.getLocalInstance(ctx).getFaBillBaseEntityInfo((IObjectPK)new ObjectUuidPK(faSplitBillEntryInfo.getId()), sic);
                if (faSplitBillEntryInfo != null && faSplitBillEntryInfo.getFaBizCard() != null && faSplitBillEntryInfo.getFaBizCard().getCurrency() != null && (currencyInfo = faSplitBillEntryInfo.getFaBizCard().getCurrency()) != null && currencyInfo.getId() != null) {
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)currencyInfo.getId().toString(), CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)"2", CompareType.EQUALS));
                    isDisable = CurrencyFactory.getLocalInstance((Context)ctx).exists(filter);
                }
            }
            if (isDisable) break;
        }
        return isDisable;
    }

    protected void invokeServiceBefore(ServiceContext svcCtx) throws BOSException {
        FaRPCMethodMappingUtils.invokeRPCMethodEventListener(svcCtx, FaAppLogForBusinessTypeEnum.FA_SPLIT, FaMethodCalcOrderEnum.BEFORE);
        super.invokeServiceBefore(svcCtx);
    }

    protected void invokeServiceAfter(ServiceContext svcCtx) throws BOSException {
        FaRPCMethodMappingUtils.invokeRPCMethodEventListener(svcCtx, FaAppLogForBusinessTypeEnum.FA_SPLIT, FaMethodCalcOrderEnum.AFTER);
        super.invokeServiceAfter(svcCtx);
    }
}

