/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.service.OrgCommonUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.facade.app.util.FasBosUtils;
import com.kingdee.eas.fi.fa.manage.FaBillBizProcessor;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.FaCardFactory;
import com.kingdee.eas.fi.fa.manage.FaSplitBillFactory;
import com.kingdee.eas.fi.fa.manage.FaSplitBillInfo;
import com.kingdee.eas.fi.fa.manage.FaWebException;
import com.kingdee.eas.fi.fa.manage.IFaSplitBill;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaSplitBillWebFacadeControllerBean;
import com.kingdee.eas.fi.fa.manage.app.PrcFaCoreManager;
import com.kingdee.eas.fi.fa.manage.app.PrcFaSplitStrategy;
import com.kingdee.eas.fi.fa.manage.common.BatchBillProcessResult;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class FaSplitBillWebFacadeControllerBean
extends AbstractFaSplitBillWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.manage.app.FaSplitBillWebFacadeControllerBean");
    private String RESOURCE_PATH = "com.kingdee.eas.fi.fa.manage.FaCardResource";
    private static final BigDecimal ZERO = new BigDecimal("0");
    private int amountScale = 10;
    private int originScale = 10;
    private int quantityScale = 0;
    private int rateScale = 3;

    @Override
    protected Map _delete(Context ctx, String[] pks) throws BOSException, EASBizException {
        BatchBillProcessResult resultList = new BatchBillProcessResult();
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(new PrcFaSplitStrategy());
        String permissionName = "fa_cardsplit_delete";
        HashMap permissionMap = new HashMap();
        int success = 0;
        IFaSplitBill billBase = FaSplitBillFactory.getLocalInstance(ctx);
        for (int i = 0; i < pks.length; ++i) {
            String pk = pks[i];
            try {
                boolean isPermission;
                if (!billBase.exists((IObjectPK)new ObjectUuidPK(pk))) {
                    throw new EASBizException(EASBizException.CHECKEXIST);
                }
                FaSplitBillInfo outBillInfo = (FaSplitBillInfo)billBase.getValue((IObjectPK)new ObjectUuidPK(pk), this.getSelector());
                if (permissionMap.get(outBillInfo.getCompany().getId().toString()) != null) {
                    HashMap map = (HashMap)permissionMap.get(outBillInfo.getCompany().getId().toString());
                    isPermission = (Boolean)map.get("isPermission");
                    if (!isPermission) {
                        String companyName = (String)map.get("companyName");
                        String number = (String)map.get("number");
                        String msg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaWebResource.NOPASSAUDIT_THISBILL", (Object[])new String[]{companyName});
                        throw new EASBizException(new NumericExceptionSubItem("NOPASSAUDIT_THISBILL", msg));
                    }
                } else {
                    HashMap<String, Object> companyMap = new HashMap<String, Object>();
                    isPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(outBillInfo.getCompany().getId().toString()), permissionName);
                    companyMap.put("companyName", outBillInfo.getCompany().getName());
                    companyMap.put("isPermission", isPermission);
                    companyMap.put("number", outBillInfo.getNumber());
                    permissionMap.put(outBillInfo.getCompany().getId().toString(), companyMap);
                    if (!isPermission) {
                        String msg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaWebResource.NODELETE_THISBILL", (Object[])new String[]{outBillInfo.getCompany().getName()});
                        throw new EASBizException(new NumericExceptionSubItem("NODELETE_THISBILL", msg));
                    }
                }
                FaBillBizProcessor.lockTable(ctx, pk.toString());
                prcFaCoreManager.getFaManageStrategy().checkForDelete(ctx, (IObjectPK)new ObjectUuidPK(pk));
                prcFaCoreManager.getFaManageStrategy().deleteBill(ctx, (IObjectPK)new ObjectUuidPK(pk));
                ++success;
                continue;
            }
            catch (Exception e) {
                BatchBillProcessResult result = new BatchBillProcessResult();
                logger.equals(e.getMessage());
                e.printStackTrace();
                result.setIconType("error");
                result.setInfo(e.getMessage());
                resultList.getDetailMsgList().add(result);
            }
        }
        if (success == pks.length) {
            resultList.setSummaryMsg(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaWebResource.DELETEALL_SUCCESS"));
        } else {
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaWebResource.DELETE_SUCCESSFUL_FAILURE", (Object[])new String[]{String.valueOf(success), String.valueOf(pks.length - success)});
            resultList.setSummaryMsg(msg);
        }
        return resultList;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("number"));
        return sic;
    }

    @Override
    protected Map _passAudit(Context ctx, String[] pks) throws BOSException, EASBizException {
        BatchBillProcessResult resultList = new BatchBillProcessResult();
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(new PrcFaSplitStrategy());
        String permissionName = "fa_cardsplit_audit";
        HashMap permissionMap = new HashMap();
        int success = 0;
        IFaSplitBill billBase = FaSplitBillFactory.getLocalInstance(ctx);
        for (int i = 0; i < pks.length; ++i) {
            String pk = pks[i];
            try {
                boolean isPermission;
                if (!billBase.exists((IObjectPK)new ObjectUuidPK(pk))) {
                    throw new EASBizException(EASBizException.CHECKEXIST);
                }
                FaSplitBillInfo outBillInfo = (FaSplitBillInfo)billBase.getValue((IObjectPK)new ObjectUuidPK(pk), this.getSelector());
                if (permissionMap.get(outBillInfo.getCompany().getId().toString()) != null) {
                    HashMap map = (HashMap)permissionMap.get(outBillInfo.getCompany().getId().toString());
                    isPermission = (Boolean)map.get("isPermission");
                    if (!isPermission) {
                        String companyName = (String)map.get("companyName");
                        String number = (String)map.get("number");
                        String msg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaWebResource.NOPASSAUDIT_THISBILL", (Object[])new String[]{companyName});
                        throw new EASBizException(new NumericExceptionSubItem("NOPASSAUDIT_THISBILL", msg));
                    }
                } else {
                    HashMap<String, Object> companyMap = new HashMap<String, Object>();
                    isPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(outBillInfo.getCompany().getId().toString()), permissionName);
                    companyMap.put("companyName", outBillInfo.getCompany().getName());
                    companyMap.put("isPermission", isPermission);
                    companyMap.put("number", outBillInfo.getNumber());
                    permissionMap.put(outBillInfo.getCompany().getId().toString(), companyMap);
                    if (!isPermission) {
                        String msg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaWebResource.NOPASSAUDIT_THISBILL", (Object[])new String[]{outBillInfo.getCompany().getName()});
                        throw new EASBizException(new NumericExceptionSubItem("NOPASSAUDIT_THISBILL", msg));
                    }
                }
                FaBillBizProcessor.lockTable(ctx, pk.toString());
                prcFaCoreManager.getFaManageStrategy().checkForAudit(ctx, (IObjectPK)new ObjectUuidPK(pk));
                FaSplitBillInfo bill = new FaSplitBillInfo();
                bill = (FaSplitBillInfo)billBase.getValue((IObjectPK)new ObjectUuidPK(pk), this.getSelfSelctor());
                bill.setId(BOSUuid.read((String)pk.toString()));
                prcFaCoreManager.getFaManageStrategy().auditBill(ctx, (IObjectValue)bill);
                ++success;
                continue;
            }
            catch (Exception e) {
                BatchBillProcessResult result = new BatchBillProcessResult();
                logger.equals(e.getMessage());
                e.printStackTrace();
                result.setIconType("error");
                result.setInfo(e.getMessage());
                resultList.getDetailMsgList().add(result);
            }
        }
        if (success == pks.length) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaWebResource.ALL_PASSAUDIT_SUCCESS");
            resultList.setSummaryMsg(msg);
        } else {
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaWebResource.AUDIT_SUCCESSFUL_FAILURE", (Object[])new String[]{String.valueOf(success), String.valueOf(pks.length - success)});
            resultList.setSummaryMsg(msg);
        }
        return resultList;
    }

    protected SelectorItemCollection getSelfSelctor() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("faSplitBillEntry.id"));
        sic.add(new SelectorItemInfo("faSplitBillEntry.faBizCard.faBakCard.id"));
        sic.add(new SelectorItemInfo("faSplitBillEntry.faBizCard.company.id"));
        sic.add(new SelectorItemInfo("faSplitBillEntry.faBizCard.id"));
        sic.add(new SelectorItemInfo("faSplitBillEntry.faCurCard.*"));
        sic.add(new SelectorItemInfo("faSplitBillEntry.faCurCard.company.id"));
        sic.add(new SelectorItemInfo("faSplitBillEntry.faCurCard.deprMethod.number"));
        sic.add(new SelectorItemInfo("faSplitBillEntry.faCurCard.deprMethod.isWorkload"));
        sic.add(new SelectorItemInfo("faBizCard.faBakCard.id"));
        sic.add(new SelectorItemInfo("faBizCard.faBakCard.bizStatus"));
        sic.add(new SelectorItemInfo("faBizCard.faBakCard.lastBillID"));
        sic.add(new SelectorItemInfo("faBizCard.faBakCard.hasCleared"));
        sic.add(new SelectorItemInfo("faBizCard.faBakCard.assetAmt"));
        sic.add(new SelectorItemInfo("faBizCard.faBakCard.lastEvalValue"));
        sic.add(new SelectorItemInfo("faBizCard.faBakCard.initEvalValue"));
        sic.add(new SelectorItemInfo("faBizCard.id"));
        sic.add(new SelectorItemInfo("faCurCard.*"));
        sic.add(new SelectorItemInfo("faCurCard.company.id"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("clearMode.id"));
        sic.add(new SelectorItemInfo("faClearBill.id"));
        sic.add(new SelectorItemInfo("faClearBill.number"));
        sic.add(new SelectorItemInfo("faClearBill.fiVouchered"));
        sic.add(new SelectorItemInfo("splitDate"));
        return sic;
    }

    @Override
    protected Map _unpassAudit(Context ctx, String[] pks) throws BOSException, EASBizException {
        BatchBillProcessResult resultList = new BatchBillProcessResult();
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(new PrcFaSplitStrategy());
        String permissionName = "fa_cardsplit_unaudit";
        HashMap permissionMap = new HashMap();
        int success = 0;
        IFaSplitBill billBase = FaSplitBillFactory.getLocalInstance(ctx);
        for (int i = 0; i < pks.length; ++i) {
            String pk = pks[i];
            try {
                boolean isPermission;
                if (!billBase.exists((IObjectPK)new ObjectUuidPK(pk))) {
                    throw new EASBizException(EASBizException.CHECKEXIST);
                }
                FaSplitBillInfo outBillInfo = (FaSplitBillInfo)billBase.getValue((IObjectPK)new ObjectUuidPK(pk), this.getSelector());
                if (permissionMap.get(outBillInfo.getCompany().getId().toString()) != null) {
                    HashMap map = (HashMap)permissionMap.get(outBillInfo.getCompany().getId().toString());
                    isPermission = (Boolean)map.get("isPermission");
                    if (!isPermission) {
                        String companyName = (String)map.get("companyName");
                        String number = (String)map.get("number");
                        String msg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaWebResource.NOUNPASSAUDI_THISBILL", (Object[])new String[]{companyName});
                        throw new EASBizException(new NumericExceptionSubItem("NOUNPASSAUDI_THISBILL", msg));
                    }
                } else {
                    HashMap<String, Object> companyMap = new HashMap<String, Object>();
                    isPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(outBillInfo.getCompany().getId().toString()), permissionName);
                    companyMap.put("companyName", outBillInfo.getCompany().getName());
                    companyMap.put("isPermission", isPermission);
                    companyMap.put("number", outBillInfo.getNumber());
                    permissionMap.put(outBillInfo.getCompany().getId().toString(), companyMap);
                    if (!isPermission) {
                        String msg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaWebResource.NOUNPASSAUDI_THISBILL", (Object[])new String[]{outBillInfo.getCompany().getName()});
                        throw new EASBizException(new NumericExceptionSubItem("NOUNPASSAUDI_THISBILL", msg));
                    }
                }
                FaBillBizProcessor.lockTable(ctx, pk.toString());
                prcFaCoreManager.getFaManageStrategy().checkForUnAudit(ctx, (IObjectPK)new ObjectUuidPK(pk));
                FaSplitBillInfo bill = new FaSplitBillInfo();
                bill = (FaSplitBillInfo)billBase.getValue((IObjectPK)new ObjectUuidPK(pk), this.getSelfSelctor());
                bill.setId(BOSUuid.read((String)pk.toString()));
                prcFaCoreManager.getFaManageStrategy().unAuditBill(ctx, (IObjectValue)bill);
                ++success;
                continue;
            }
            catch (Exception e) {
                BatchBillProcessResult result = new BatchBillProcessResult();
                logger.equals(e.getMessage());
                e.printStackTrace();
                result.setIconType("error");
                result.setInfo(e.getMessage());
                resultList.getDetailMsgList().add(result);
            }
        }
        if (success == pks.length) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaWebResource.ALL_UNPASSAUDIT_SUCCESS");
            resultList.setSummaryMsg(msg);
        } else {
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaWebResource.UNAUDIT_SUCCESSFUL_FAILURE", (Object[])new String[]{String.valueOf(success), String.valueOf(pks.length - success)});
            resultList.setSummaryMsg(msg);
        }
        return resultList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String _getOrgDataFilter(Context ctx, boolean share) throws BOSException, EASBizException {
        String permItem = "fa_cardsplit_list";
        StringBuffer orgDataFilter = new StringBuffer("id in ( ");
        CompanyOrgUnitCollection companyOrgUnitCollection = new CompanyOrgUnitCollection();
        if (!share) {
            CompanyOrgUnitInfo current = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
            if (!current.isIsBizUnit()) throw new FaWebException(FaWebException.CUORGVIRTUAL);
            boolean isPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(current.getId().toString()), permItem);
            if (!isPermission) {
                throw new FaWebException(FaWebException.NO_VIEW_PERMISSION);
            }
            if (current.isIsSealUp()) {
                throw new FaWebException(FaWebException.CUORGSEALED);
            }
            if (current.getInvalidDate() != null && DateTimeUtils.dayBefore((Date)current.getInvalidDate(), (Date)new Date())) {
                String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.Company_Disabled");
                throw new EASBizException(new NumericExceptionSubItem("Company_Disabled", strMsg));
            }
            boolean isInitEnd = SystemStatusCtrolUtils.isStart(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)current);
            if (!isInitEnd) {
                String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource.FaCurCardEditUI_FANotEndInit");
                throw new EASBizException(new NumericExceptionSubItem("FaCurCardEditUI_FANotEndInit", strMsg));
            }
            FaCardFactory.getRemoteInstance().checkAccountSwap(current);
            companyOrgUnitCollection.add(current);
        } else {
            companyOrgUnitCollection = this.getOrgsByPermission(ctx, permItem);
        }
        for (int i = 0; i < companyOrgUnitCollection.size(); ++i) {
            CompanyOrgUnitInfo orgInfo = companyOrgUnitCollection.get(i);
            orgDataFilter.append("'" + orgInfo.getId().toString() + "',");
        }
        if (orgDataFilter.toString().equals("id in ( ")) {
            orgDataFilter = new StringBuffer("id in ('NE')");
            return orgDataFilter.toString();
        } else {
            orgDataFilter.deleteCharAt(orgDataFilter.length() - 1);
            orgDataFilter.append(") ");
        }
        return orgDataFilter.toString();
    }

    public CompanyOrgUnitCollection getOrgsByPermission(Context ctx, String permItem) throws BOSException, EASBizException {
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitCollection collection = new CompanyOrgUnitCollection();
        CompanyOrgUnitCollection permCollection = new CompanyOrgUnitCollection();
        collection = this.getAuthrizedCompanyOrg(ctx, ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), permItem, false);
        Iterator iterator = collection.iterator();
        boolean i = false;
        while (iterator.hasNext()) {
            CompanyOrgUnitInfo orgInfo = (CompanyOrgUnitInfo)iterator.next();
            if (!orgInfo.isIsBizUnit() || orgInfo.isIsSealUp()) continue;
            permCollection.add(orgInfo);
        }
        if (permCollection == null || permCollection.size() <= 0) {
            throw new FaWebException(FaWebException.NO_VIEW_PERMISSION_ALL);
        }
        CompanyOrgUnitCollection isInitEndCollection = new CompanyOrgUnitCollection();
        for (int j = 0; j < permCollection.size(); ++j) {
            CompanyOrgUnitInfo orgInfo = permCollection.get(j);
            boolean isInitEnd = SystemStatusCtrolUtils.isStart(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)orgInfo);
            if (!isInitEnd) continue;
            isInitEndCollection.add(orgInfo);
        }
        if (isInitEndCollection == null || isInitEndCollection.size() == 0) {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource.FaCurCardEditUI_FANotEndInit");
            throw new EASBizException(new NumericExceptionSubItem("FaCurCardEditUI_FANotEndInit", strMsg));
        }
        CompanyOrgUnitCollection accountSwapCollection = new CompanyOrgUnitCollection();
        for (int j = 0; j < isInitEndCollection.size(); ++j) {
            CompanyOrgUnitInfo orgInfo = isInitEndCollection.get(j);
            try {
                CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgInfo.getId()));
                FaCardFactory.getRemoteInstance().checkAccountSwap(companyOrgUnitInfo);
                accountSwapCollection.add(orgInfo);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (accountSwapCollection == null || accountSwapCollection.size() == 0) {
            throw new FaCardException(FaCardException.ACCOUNTSWAP);
        }
        return accountSwapCollection;
    }

    protected CompanyOrgUnitCollection getAuthrizedCompanyOrg(Context ctx, String userID, String permItemName, boolean includeVirtual) throws BOSException, EASBizException {
        FullOrgUnitCollection collection;
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        String orgTreeId = OrgCommonUtils.getOrgTreeId((OrgType)OrgType.Company);
        ObjectUuidPK orgTreePK = null;
        if (orgTreeId != null) {
            orgTreePK = new ObjectUuidPK(orgTreeId);
        }
        if ((collection = iPermission.getAuthorizedOrg(ctx.getCaller(), OrgType.Company, (IObjectPK)orgTreePK, permItemName)).size() == 0) {
            return new CompanyOrgUnitCollection();
        }
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < collection.size(); ++i) {
            idSet.add(collection.get(i).getId().toString());
        }
        FasBosUtils.EntityViewBuilder viewBuilder = FasBosUtils.entityViewBuilder();
        viewBuilder.select(new String[]{"id", "number", "name", "longNumber", "level", "isBizUnit", "isIsSealUp"}).sort("longNumber", SortType.ASCEND).sort("number", SortType.ASCEND).filter("id", idSet, CompareType.INCLUDE);
        if (!includeVirtual) {
            viewBuilder.filter("isBizUnit", (Object)true, CompareType.EQUALS);
        }
        CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(viewBuilder.build());
        return coll;
    }

    @Override
    protected Map _save(Context ctx, IObjectValue dataObject) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _submit(Context ctx, IObjectValue dataObject) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _batchSubmit(Context ctx, Map paramMap) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _submit(Context ctx, Map paramMap) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _getPermissionsByCompany(Context ctx, Map argJsonMap) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _submitPrompt(Context ctx, IObjectValue dataObject) throws BOSException, EASBizException {
        return null;
    }
}

