/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.basedata.FaAlterModeInfo;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeInfo;
import com.kingdee.eas.fi.fa.def.FaDefPropertyValueInfo;
import com.kingdee.eas.fi.fa.manage.BarCodeStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaBakCardFactory;
import com.kingdee.eas.fi.fa.manage.FaBakCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBillOriginEnum;
import com.kingdee.eas.fi.fa.manage.FaBillTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaBizCardFactory;
import com.kingdee.eas.fi.fa.manage.FaBizCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBizStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.FaCardOriginEnum;
import com.kingdee.eas.fi.fa.manage.FaChangeBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaChangeBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaChangeBillFactory;
import com.kingdee.eas.fi.fa.manage.FaChangeBillInfo;
import com.kingdee.eas.fi.fa.manage.FaChangeStatusEnmu;
import com.kingdee.eas.fi.fa.manage.FaClearBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaClearBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaClearBillFactory;
import com.kingdee.eas.fi.fa.manage.FaClearBillInfo;
import com.kingdee.eas.fi.fa.manage.FaClearStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaCurAsstActCompositCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCostCenterCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCostCenterInfo;
import com.kingdee.eas.fi.fa.manage.FaCurDepartmentInfo;
import com.kingdee.eas.fi.fa.manage.FaCurFacilityCollection;
import com.kingdee.eas.fi.fa.manage.FaCurFacilityInfo;
import com.kingdee.eas.fi.fa.manage.FaDepCalFacadeFactory;
import com.kingdee.eas.fi.fa.manage.FaDepreciationEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaFromUnitCatEnum;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaStocktakingBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaStocktakingException;
import com.kingdee.eas.fi.fa.manage.FaStocktakingReportBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaStocktakingReportBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaStocktakingReportBillFactory;
import com.kingdee.eas.fi.fa.manage.FaStocktakingReportBillInfo;
import com.kingdee.eas.fi.fa.manage.FaStocktakingTaskBillFactory;
import com.kingdee.eas.fi.fa.manage.FaStocktakingTaskBillInfo;
import com.kingdee.eas.fi.fa.manage.GroupNumberStatusEnum;
import com.kingdee.eas.fi.fa.manage.IFaBakCard;
import com.kingdee.eas.fi.fa.manage.IFaBizCard;
import com.kingdee.eas.fi.fa.manage.IFaChangeBill;
import com.kingdee.eas.fi.fa.manage.IFaClearBill;
import com.kingdee.eas.fi.fa.manage.IFaCurCard;
import com.kingdee.eas.fi.fa.manage.IFaStocktakingReportBill;
import com.kingdee.eas.fi.fa.manage.IFaStocktakingTaskBill;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaStocktakingReportBillControllerBean;
import com.kingdee.eas.fi.fa.manage.app.AbstractPrcFaManageStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaCardDefPropertyPersist;
import com.kingdee.eas.fi.fa.manage.app.FaDepORMapping;
import com.kingdee.eas.fi.fa.manage.app.FaDepreCalculator;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.PrcFaAddStrategy;
import com.kingdee.eas.fi.fa.manage.app.PrcFaChangeStrategy;
import com.kingdee.eas.fi.fa.manage.app.PrcFaClearStrategy;
import com.kingdee.eas.fi.fa.manage.app.PrcFaCoreManager;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.report.util.DBUtilx;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class FaStocktakingReportBillControllerBean
extends AbstractFaStocktakingReportBillControllerBean {
    private static final long serialVersionUID = -5034927756818684203L;
    private static final BigDecimal ZERO = new BigDecimal("0");
    public static String IS_FROM_STOCK_TAKING_REPORT_BILL = "isFromStocktakingReportBill";
    protected HashMap hmParam;
    private CompanyOrgUnitInfo currCompany;

    @Override
    protected void _profitLoss(Context ctx, BOSUuid pk) throws BOSException, EASBizException {
        FaCurCardInfo cardInfo;
        FaStocktakingBillEntryInfo billEntry;
        FaStocktakingReportBillEntryInfo rptEntry;
        int i;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("adjustDate"));
        sic.add(new SelectorItemInfo("effectedStatus"));
        sic.add(new SelectorItemInfo("taskBill.id"));
        sic.add(new SelectorItemInfo("taskBill.period.id"));
        sic.add(new SelectorItemInfo("bill.id"));
        sic.add(new SelectorItemInfo("stocktakingStatus"));
        sic.add(new SelectorItemInfo("entries.adjustAsset"));
        sic.add(new SelectorItemInfo("entries.operType"));
        sic.add(new SelectorItemInfo("entries.profitAmt"));
        sic.add(new SelectorItemInfo("entries.profitValue"));
        sic.add(new SelectorItemInfo("entries.lossAmt"));
        sic.add(new SelectorItemInfo("entries.lossValue"));
        sic.add(new SelectorItemInfo("entries.alterMode.id"));
        sic.add(new SelectorItemInfo("entries.billEntry.*"));
        sic.add(new SelectorItemInfo("entries.billEntry.assetCat.id"));
        sic.add(new SelectorItemInfo("entries.billEntry.assetCat.numberRule"));
        sic.add(new SelectorItemInfo("entries.billEntry.assetCat.number"));
        sic.add(new SelectorItemInfo("entries.billEntry.assetCat.name"));
        sic.add(new SelectorItemInfo("entries.billEntry.dept.id"));
        sic.add(new SelectorItemInfo("entries.billEntry.dept.name"));
        sic.add(new SelectorItemInfo("entries.billEntry.dept.number"));
        sic.add(new SelectorItemInfo("entries.billEntry.CU.id"));
        sic.add(new SelectorItemInfo("entries.billEntry.CU.name"));
        sic.add(new SelectorItemInfo("entries.billEntry.CU.number"));
        sic.add(new SelectorItemInfo("entries.billEntry.number"));
        sic.add(new SelectorItemInfo("entries.billEntry.effectedStatus"));
        sic.add(new SelectorItemInfo("entries.billEntry.company.id"));
        sic.add(new SelectorItemInfo("entries.billEntry.company.name"));
        sic.add(new SelectorItemInfo("entries.billEntry.company.number"));
        sic.add(new SelectorItemInfo("entries.billEntry.useStatus"));
        sic.add(new SelectorItemInfo("entries.billEntry.faCurCard.*"));
        sic.add(new SelectorItemInfo("entries.billEntry.faCurCard.assetCat.id"));
        sic.add(new SelectorItemInfo("entries.billEntry.faCurCard.assetCat.numberRule"));
        sic.add(new SelectorItemInfo("entries.billEntry.faCurCard.assetCat.name"));
        sic.add(new SelectorItemInfo("entries.billEntry.faCurCard.assetCat.number"));
        sic.add(new SelectorItemInfo("entries.billEntry.faCurCard.dept.id"));
        sic.add(new SelectorItemInfo("entries.billEntry.faCurCard.dept.name"));
        sic.add(new SelectorItemInfo("entries.billEntry.faCurCard.dept.number"));
        sic.add(new SelectorItemInfo("entries.billEntry.faCurCard.CU.id"));
        sic.add(new SelectorItemInfo("entries.billEntry.faCurCard.CU.name"));
        sic.add(new SelectorItemInfo("entries.billEntry.faCurCard.CU.number"));
        sic.add(new SelectorItemInfo("entries.billEntry.faCurCard.number"));
        sic.add(new SelectorItemInfo("entries.billEntry.faCurCard.effectedStatus"));
        sic.add(new SelectorItemInfo("entries.billEntry.faCurCard.company.id"));
        sic.add(new SelectorItemInfo("entries.billEntry.faCurCard.company.name"));
        sic.add(new SelectorItemInfo("entries.billEntry.faCurCard.company.number"));
        sic.add(new SelectorItemInfo("entries.billEntry.faCurCard.useStatus"));
        sic.add(new SelectorItemInfo("entries.billEntry.faCurCard.faCurCostCenter.*"));
        sic.add(new SelectorItemInfo("entries.billEntry.faCurCard.faCurCostCenter.faCurAsstActComposit.*"));
        sic.add(new SelectorItemInfo("entries.billEntry.faCurCard.faCurCostCenter.faCurAsstActComposit.asstActType.*"));
        sic.add(new SelectorItemInfo("entries.billEntry.faCurCard.faCurCostCenter.faCurAsstActComposit.asstActItem.*"));
        sic.add(new SelectorItemInfo("entries.billEntry.faCurCard.faCurFacility.*"));
        sic.add(new SelectorItemInfo("entries.billEntry.faCurCard.faCurDepartment.*"));
        sic.add(new SelectorItemInfo("entries.billEntry.faCurCard.assetCat.calcuByEvaluate"));
        sic.add(new SelectorItemInfo("entries.billEntry.faCurCard.propertyValue.*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.baseCurrency.precision"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)pk.toString()));
        FaStocktakingReportBillInfo rptInfo = this.getFaStocktakingReportBillInfo(ctx, view.toString());
        FaLocalUtils.checkPeriodConsistent(ctx, rptInfo.getCompany(), rptInfo.getTaskBill().getPeriod(), true);
        if (rptInfo.getEffectedStatus().getValue() != 2) {
            throw new FaStocktakingException(FaStocktakingException.RPT_NOT_SUBMIT);
        }
        if (rptInfo.getStocktakingStatus().getValue() != 1) {
            throw new FaStocktakingException(FaStocktakingException.RPT_HAD_PROFIT);
        }
        PeriodInfo period = FaLocalUtils.getCurrentPeriod(ctx);
        boolean hasNoAudit = FaDepORMapping.hasNoAudit(ctx, period.getPeriodYear(), period.getPeriodNumber(), rptInfo.getCompany().getId().toString());
        if (hasNoAudit) {
            throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCal_NoAudit", (Locale)ctx.getOriginLocale()) + "," + ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCal_DoAction", (Locale)ctx.getOriginLocale())));
        }
        ArrayList<FaStocktakingReportBillEntryInfo> addList = new ArrayList<FaStocktakingReportBillEntryInfo>();
        ArrayList<FaStocktakingReportBillEntryInfo> changeList = new ArrayList<FaStocktakingReportBillEntryInfo>();
        ArrayList<FaStocktakingReportBillEntryInfo> clearList = new ArrayList<FaStocktakingReportBillEntryInfo>();
        for (int i2 = 0; i2 < rptInfo.getEntries().size(); ++i2) {
            FaStocktakingReportBillEntryInfo rptEntry2 = rptInfo.getEntries().get(i2);
            FaCurCardInfo cardInfo2 = rptEntry2.getBillEntry().getFaCurCard();
            if (!rptEntry2.isAdjustAsset()) continue;
            if (rptEntry2.getOperType().getValue() == 1) {
                addList.add(rptEntry2);
                continue;
            }
            if (rptEntry2.getOperType().getValue() == 2) {
                this.verifyCard(ctx, rptEntry2, cardInfo2, false);
                changeList.add(rptEntry2);
                continue;
            }
            if (rptEntry2.getOperType().getValue() != 3) continue;
            clearList.add(rptEntry2);
            this.verifyCard(ctx, rptEntry2, cardInfo2, true);
        }
        IFaCurCard iCard = FaCurCardFactory.getLocalInstance(ctx);
        IFaChangeBill iChange = FaChangeBillFactory.getLocalInstance(ctx);
        IFaClearBill iClear = FaClearBillFactory.getLocalInstance(ctx);
        IFaBizCard iBizCard = FaBizCardFactory.getLocalInstance(ctx);
        IFaBakCard iBakCard = FaBakCardFactory.getLocalInstance(ctx);
        PrcFaChangeStrategy prcChg = new PrcFaChangeStrategy();
        PrcFaClearStrategy prcClr = new PrcFaClearStrategy();
        FaCurCardInfo cardTemp = this.getFaCurCardInfo(ctx);
        FaChangeBillInfo changeTemp = this.getChangeBillInfo(ctx);
        FaClearBillInfo clearTemp = this.getClearBillInfo(ctx);
        for (i = 0; i < addList.size(); ++i) {
            rptEntry = (FaStocktakingReportBillEntryInfo)addList.get(i);
            billEntry = rptEntry.getBillEntry();
            FaCurCardInfo curCardInfo = billEntry.getFaCurCard();
            if (curCardInfo == null) {
                curCardInfo = new FaCurCardInfo();
            }
            cardInfo = (FaCurCardInfo)cardTemp.clone();
            cardInfo.setSourceBillId(rptInfo.getId().toString());
            cardInfo.setAccountDate(rptInfo.getAdjustDate());
            cardInfo.setBizDate(rptInfo.getAdjustDate());
            cardInfo.setOriginMethod(rptEntry.getAlterMode());
            cardInfo.setAssetCat(billEntry.getAssetCat());
            cardInfo.setUseStatus(billEntry.getUseStatus());
            cardInfo.setEconomicPurp(billEntry.getEconomicPurp());
            cardInfo.setStoreCity(billEntry.getAddress());
            cardInfo.setOldNumber(billEntry.getOldNumber());
            if (billEntry.getFaCurCard() != null) {
                FaCurCardInfo faCurCardBak = billEntry.getFaCurCard();
                billEntry.getFaCurCard().setId(null);
                if (this.checkBlocCardDup(ctx, (IObjectValue)billEntry.getFaCurCard(), billEntry.getGroupNumber())) {
                    cardInfo.setGroupNumber(billEntry.getGroupNumber());
                } else {
                    cardInfo.setGroupNumber(null);
                }
                if (this.checkBarCodeDup(ctx, (IObjectValue)billEntry.getFaCurCard(), billEntry.getBarCode())) {
                    cardInfo.setBarCode(billEntry.getBarCode());
                } else {
                    cardInfo.setBarCode(null);
                }
                billEntry.setFaCurCard(faCurCardBak);
            } else {
                cardInfo.setGroupNumber(billEntry.getGroupNumber());
                cardInfo.setBarCode(billEntry.getBarCode());
            }
            cardInfo.setDept(billEntry.getAdminDept());
            if (billEntry.getUseDept() != null) {
                FaCurDepartmentInfo dept = new FaCurDepartmentInfo();
                dept.setUseDepartment(billEntry.getUseDept());
                cardInfo.getFaCurDepartment().add(dept);
            }
            cardInfo.setAssetAmt(rptEntry.getProfitAmt());
            cardInfo.setAssetValue(rptEntry.getProfitValue());
            cardInfo.setOriginAmt(rptEntry.getProfitValue());
            cardInfo.setTaxOriginAmt(rptEntry.getProfitValue());
            cardInfo.setInitEvalValue(rptEntry.getProfitValue());
            cardInfo.setLastEvalValue(rptEntry.getProfitValue());
            cardInfo.setNeatValue(rptEntry.getProfitValue());
            cardInfo.setNeatAmt(rptEntry.getProfitValue());
            cardInfo.setSpecs(billEntry.getSpecs());
            cardInfo.setAssetName(billEntry.getAssetName());
            cardInfo.setAccountAsset(curCardInfo.getAccountAsset());
            cardInfo.setAccountAccuDepr(curCardInfo.getAccountAccuDepr());
            cardInfo.setAccountDecValue(curCardInfo.getAccountDecValue());
            FaCurFacilityCollection facilities = curCardInfo.getFaCurFacility();
            for (int j = 0; j < facilities.size(); ++j) {
                FaCurFacilityInfo facility = facilities.get(j);
                facility.setId(null);
                facility.setFaCurCard(cardInfo);
                cardInfo.getFaCurFacility().add(facility);
            }
            FaLocalUtils.reGetCurCostCenterInfo(curCardInfo, ctx);
            FaCurCostCenterCollection costCenters = curCardInfo.getFaCurCostCenter();
            for (int j = 0; j < costCenters.size(); ++j) {
                FaCurCostCenterInfo costcenter = costCenters.get(j);
                costcenter.setId(null);
                costcenter.setFaCurCard(cardInfo);
                cardInfo.getFaCurCostCenter().add(costcenter);
                FaCurAsstActCompositCollection curAsstActCollection = costcenter.getFaCurAsstActComposit();
                if (curAsstActCollection == null || curAsstActCollection.size() <= 0) continue;
                for (int k = 0; k < curAsstActCollection.size(); ++k) {
                    curAsstActCollection.get(k).setId(null);
                }
            }
            cardInfo.setDeprMethod(curCardInfo.getDeprMethod());
            cardInfo.setMeasureUnit(billEntry.getMeasureUnit());
            cardInfo.setStartUseDate(new Date());
            cardInfo.setUseTermCount(curCardInfo.getUseTermCount());
            cardInfo.setUseYears(curCardInfo.getUseYears());
            IObjectPK cardId = iCard.save((CoreBaseInfo)cardInfo);
            DbUtil.execute((Context)ctx, (String)"update t_fa_stocktakingrptentry set FNewCardID=? where fid=?", (Object[])new Object[]{cardId.toString(), rptEntry.getId().toString()});
        }
        for (i = 0; i < changeList.size(); ++i) {
            rptEntry = (FaStocktakingReportBillEntryInfo)changeList.get(i);
            billEntry = rptEntry.getBillEntry();
            FaChangeBillInfo changeInfo = (FaChangeBillInfo)changeTemp.clone();
            changeInfo.setChangeDate(rptInfo.getAdjustDate());
            changeInfo.setBizDate(rptInfo.getAdjustDate());
            changeInfo.setChangeMode(rptEntry.getAlterMode());
            changeInfo.setSourceBillId(rptInfo.getId().toString());
            AbstractPrcFaManageStrategy.setBillInfoNumber(ctx, changeInfo, iChange);
            cardInfo = billEntry.getFaCurCard();
            FaBakCardInfo bakCard = FaManageUtils.CurCard2BakCard((FaCurCardInfo)cardInfo.clone());
            bakCard.setFaCurCard(cardInfo);
            bakCard.setBillType(FaBillTypeEnum.CHANGE);
            if (cardInfo.getPropertyValue() != null) {
                FaDefPropertyValueInfo bakPV = FaCardDefPropertyPersist.copy(cardInfo.getPropertyValue().getId(), ctx);
                bakCard.setPropertyValue(bakPV);
            } else {
                bakCard.setPropertyValue(null);
            }
            iBakCard.addnew((CoreBaseInfo)bakCard);
            FaBizCardInfo bizCard = FaManageUtils.CurCard2BizCard(cardInfo);
            if (billEntry.getUseStatus() != null) {
                bizCard.setUseStatus(billEntry.getUseStatus());
            }
            if (billEntry.getEconomicPurp() != null) {
                bizCard.setEconomicPurp(billEntry.getEconomicPurp());
            }
            if (rptEntry.getProfitAmt() != null && rptEntry.getProfitAmt().compareTo(ZERO) > 0) {
                bizCard.setAssetAmt(bizCard.getAssetAmt().add(rptEntry.getProfitAmt()));
            } else if (rptEntry.getLossAmt() != null && rptEntry.getLossAmt().compareTo(ZERO) > 0) {
                if (rptEntry.getLossAmt().compareTo(bizCard.getAssetAmt()) > 0) {
                    throw new FaStocktakingException(FaStocktakingException.CHANGE_AMT_EXCEED_LIMITED, new Object[]{bizCard.getNumber()});
                }
                bizCard.setAssetAmt(bizCard.getAssetAmt().subtract(rptEntry.getLossAmt()));
            }
            BigDecimal profitValue = ZERO;
            if (rptEntry.getProfitValue() != null && rptEntry.getProfitValue().compareTo(ZERO) > 0) {
                profitValue = rptEntry.getProfitValue();
            } else if (rptEntry.getLossValue() != null && rptEntry.getLossValue().compareTo(ZERO) > 0) {
                profitValue = rptEntry.getLossValue().negate();
            }
            if (profitValue.compareTo(ZERO) != 0) {
                if (profitValue.add(bizCard.getAssetValue()).compareTo(ZERO) <= 0) {
                    throw new FaStocktakingException(FaStocktakingException.CHANGE_AMT_EXCEED_LIMITED, new Object[]{bizCard.getNumber()});
                }
                bizCard.setAssetValue(bizCard.getAssetValue().add(profitValue));
                BigDecimal addons = bizCard.getAddons() == null ? ZERO : bizCard.getAddons();
                bizCard.setOriginAmt(bizCard.getAssetValue().subtract(addons).divide(bizCard.getExRate(), 4));
                if (!bizCard.isIsEvaledBefore()) {
                    bizCard.setLastEvalValue(bizCard.getAssetValue());
                    bizCard.setInitEvalValue(bizCard.getAssetValue());
                }
                if (bizCard.getAssetCat().isCalcuByEvaluate() && !bizCard.isIsEvaledBefore() || !bizCard.getAssetCat().isCalcuByEvaluate()) {
                    if (bizCard.getNeatAmt().add(profitValue).compareTo(ZERO) < 0 || bizCard.getNeatValue().add(profitValue).compareTo(ZERO) < 0) {
                        throw new FaStocktakingException(FaStocktakingException.CHANGE_AMT_EXCEED_LIMITED, new Object[]{bizCard.getNumber()});
                    }
                    bizCard.setNeatAmt(bizCard.getNeatAmt().add(profitValue));
                    bizCard.setNeatValue(bizCard.getNeatValue().add(profitValue));
                }
            }
            bizCard.setBillType(FaBillTypeEnum.CHANGE);
            bizCard.setFaBakCard(bakCard);
            if (cardInfo.getPropertyValue() != null) {
                FaDefPropertyValueInfo bizPV = FaCardDefPropertyPersist.copy(cardInfo.getPropertyValue().getId(), ctx);
                bizCard.setPropertyValue(bizPV);
            } else {
                bizCard.setPropertyValue(null);
            }
            FaChangeBillEntryInfo changeEntryInfo = changeInfo.getChangeBillEntry().get(0);
            changeEntryInfo.setBizCard(bizCard);
            changeEntryInfo.setCurCard(cardInfo);
            changeEntryInfo.setOriginChg(profitValue);
            IObjectPK changeId = iChange.addnew((CoreBaseInfo)changeInfo);
            prcChg.auditBill(ctx, (IObjectValue)changeInfo);
            DbUtil.execute((Context)ctx, (String)"update t_fa_stocktakingrptentry set FChangeBillID=? where fid=?", (Object[])new Object[]{changeId.toString(), rptEntry.getId().toString()});
        }
        if (clearList.size() > 0) {
            int baseScale = rptInfo.getCompany().getBaseCurrency() == null ? 2 : rptInfo.getCompany().getBaseCurrency().getPrecision();
            Map mode2Card = this.sortByAlterMode(clearList);
            sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("clearBillEntry.*"));
            sic.add(new SelectorItemInfo("clearBillEntry.bizCard.faBakCard.id"));
            sic.add(new SelectorItemInfo("clearBillEntry.bizCard.faBakCard.assetAmt"));
            sic.add(new SelectorItemInfo("clearBillEntry.bizCard.faBakCard.lastEvalValue"));
            for (FaAlterModeInfo alterMode : mode2Card.keySet()) {
                FaStocktakingReportBillEntryCollection rptEntires = (FaStocktakingReportBillEntryCollection)((Object)mode2Card.get(alterMode));
                FaClearBillInfo clearBill = (FaClearBillInfo)clearTemp.clone();
                clearBill.setClearMode(alterMode);
                FaClearBillEntryCollection clearEntries = clearBill.getClearBillEntry();
                FaCurCardCollection curCards = new FaCurCardCollection();
                for (int i3 = 0; i3 < rptEntires.size(); ++i3) {
                    FaCurCardInfo curcard;
                    FaStocktakingReportBillEntryInfo rptEntry3 = rptEntires.get(i3);
                    FaStocktakingBillEntryInfo billEntry2 = rptEntry3.getBillEntry();
                    boolean isFullClear = rptEntry3.getLossAmt().compareTo(billEntry2.getFaCurCard().getAssetAmt()) == 0;
                    clearBill.setClearDate(rptInfo.getAdjustDate());
                    clearBill.setSourceBillId(rptInfo.getId().toString());
                    FaClearBillEntryInfo clearEntry = new FaClearBillEntryInfo();
                    clearEntry.setClrQty(rptEntry3.getLossAmt());
                    clearEntry.setClrOriginal(rptEntry3.getLossValue());
                    BigDecimal needChange = this.isClearBillDepr(ctx, billEntry2, rptEntry3);
                    if (isFullClear) {
                        curcard = billEntry2.getFaCurCard();
                        clearEntry.setClrDecPrep(curcard.getDecValue());
                        clearEntry.setClrAddupDep(curcard.getAccuDepr().add(needChange));
                    } else {
                        curcard = billEntry2.getFaCurCard();
                        clearEntry.setClrDecPrep(curcard.getDecValue().multiply(clearEntry.getClrQty()).divide(curcard.getAssetAmt(), 4).setScale(baseScale, 4));
                        clearEntry.setClrAddupDep(curcard.getAccuDepr().add(needChange).multiply(clearEntry.getClrQty()).divide(curcard.getAssetAmt(), 4).setScale(baseScale, 4));
                    }
                    clearEntry.put("faCurCard", billEntry2.getFaCurCard().getId().toString());
                    clearEntry.put("cardUpdateTime", billEntry2.getFaCurCard().getLastUpdateTime());
                    clearEntry.setComment(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaStocktakingResource", (String)"remark", (Locale)ctx.getOriginLocale()));
                    curCards.add(billEntry2.getFaCurCard());
                    clearEntries.add(clearEntry);
                }
                clearBill.put("curCardCollection", (Object)curCards);
                IObjectPK clearId = prcClr.submitBillNoWF(ctx, (IObjectValue)clearBill);
                clearBill = iClear.getFaClearBillInfo(clearId, sic);
                clearBill.put(IS_FROM_STOCK_TAKING_REPORT_BILL, "true");
                prcClr.auditBill(ctx, (IObjectValue)clearBill);
                iClear.passAuditSelf((IObjectPK)new ObjectUuidPK(clearBill.getId()), clearBill);
                String sql = "update t_fa_stocktakingrptentry set FClearBillID =? where freportbillid =? and fbillentryid in (select be.fid from t_fa_clearbillentry ce inner join t_fa_stocktakingbillentry be on be.fcurcardid=ce.fcurcardid where ce.fentryid =?)";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{clearId.toString(), pk.toString(), clearId.toString()});
            }
        }
        String sql = null;
        try {
            sql = "SELECT FID FROM T_FA_FaStocktakingAOrPBill WHERE FTaskBillID=? and FStocktakingStatus=6 ";
            SqlParams sp = new SqlParams();
            sp.addString(rptInfo.getTaskBill().getId().toString());
            RptRowSet rs = DBUtilx.executeQuery((String)sql, (SqlParams)sp, (Context)ctx);
            if (rs.next()) {
                sql = "update t_fa_stocktakingtaskbill set FStocktakingStatus=6 ,FlastUpdaterID=? where fid=?";
                sp = new SqlParams();
                sp.addString(pk.toString()).addString(rptInfo.getTaskBill().getId().toString());
                DBUtilx.executeUpdate((String)sql, (SqlParams)sp, (Context)ctx);
                sql = "update t_fa_stocktakingbill set FStocktakingStatus=6  where fid=?";
                sp = new SqlParams();
                sp.addString(rptInfo.getBill().getId().toString());
                DBUtilx.executeUpdate((String)sql, (SqlParams)sp, (Context)ctx);
            }
            sql = "update t_fa_stocktakingrptbill set FStocktakingStatus=6 where fid=?";
            sp = new SqlParams();
            sp.addString(pk.toString());
            DBUtilx.executeUpdate((String)sql, (SqlParams)sp, (Context)ctx);
        }
        catch (SQLException e) {
            throw new EASBizException(new NumericExceptionSubItem("00", sql + e.getMessage()), (Throwable)e);
        }
    }

    private BigDecimal isClearBillDepr(Context ctx, FaStocktakingBillEntryInfo billEntry, FaStocktakingReportBillEntryInfo rptEntry) throws EASBizException, BOSException {
        boolean isStartDeprTime;
        BigDecimal initValue = new BigDecimal("0");
        PeriodInfo curPeriod = FaLocalUtils.getCurrentPeriod(ctx);
        FaCurCardInfo curCardInfo = billEntry.getFaCurCard();
        boolean isDep = FaDepreciationEntryFactory.getLocalInstance(ctx).exists("select fid where LnkFaDepreEntry.period.id='" + curPeriod.getId().toString() + "' and LnkFaDepreEntry.company.id='" + curCardInfo.getCompany().getId().toString() + "' and faCurCard.id='" + curCardInfo.getId().toString() + "'");
        SelectorItemCollection sic = PrcFaCoreManager.getCurCardSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("useStatus.*"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.StartDeprTime"));
        sic.add(new SelectorItemInfo("company.baseCurrency.*"));
        sic.add(new SelectorItemInfo("deprMethod.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("evalDeprMode.*"));
        FaCurCardInfo curCardInfoForDep = FaCurCardFactory.getLocalInstance(ctx).getFaCurCardInfo((IObjectPK)new ObjectUuidPK(curCardInfo.getId()), sic);
        boolean bl = isStartDeprTime = curCardInfoForDep.getAssetCat().getDepreciationPolicy().getStartDeprTime().getValue() != 0;
        if (!FaLocalUtils.isWellOnlyMethod((FaDepreciationModeInfo)curCardInfoForDep.getDeprMethod()) && curCardInfoForDep.getDeprMethod() != null) {
            if (!isDep && isStartDeprTime) {
                HashMap map = FaDepCalFacadeFactory.getLocalInstance(ctx).calOneCardDep(curCardInfoForDep);
                BigDecimal deprTerm = new BigDecimal("0");
                if (map != null) {
                    deprTerm = map.get(FaDepreCalculator.FA_DEP_AMOUNT) != null ? new BigDecimal(map.get(FaDepreCalculator.FA_DEP_AMOUNT).toString()) : new BigDecimal("0");
                }
                initValue = initValue.add(deprTerm);
            }
            if (isDep && !isStartDeprTime) {
                BigDecimal deprTerm = curCardInfoForDep.getDeprTTerm() != null ? curCardInfoForDep.getDeprTTerm() : new BigDecimal("0");
                initValue = initValue.subtract(deprTerm);
            }
        }
        return initValue;
    }

    private FaClearBillInfo getClearBillInfo(Context ctx) throws EASBizException, BOSException {
        FaClearBillInfo clearBill = new FaClearBillInfo();
        clearBill.setCompany(ContextUtil.getCurrentFIUnit((Context)ctx));
        clearBill.setPeriod(FaLocalUtils.getCurrentPeriod(ctx));
        clearBill.setBillType(FaBillOriginEnum.FROM_STOCKTAKING);
        clearBill.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        clearBill.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        clearBill.setDeletedStatus(DeletedStatusEnum.NORMAL);
        clearBill.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        clearBill.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        clearBill.setHandler(ContextUtil.getCurrentUserInfo((Context)ctx));
        clearBill.setDescription(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"88_FaStocktakingReportBillControllerBean", (Locale)ctx.getOriginLocale()));
        return clearBill;
    }

    private Map sortByAlterMode(List clearList) {
        HashMap<FaAlterModeInfo, FaStocktakingReportBillEntryCollection> sortMap = new HashMap<FaAlterModeInfo, FaStocktakingReportBillEntryCollection>();
        for (int i = 0; i < clearList.size(); ++i) {
            FaStocktakingReportBillEntryCollection entries;
            FaStocktakingReportBillEntryInfo rptEntry = (FaStocktakingReportBillEntryInfo)clearList.get(i);
            if (sortMap.containsKey(rptEntry.getAlterMode())) {
                entries = (FaStocktakingReportBillEntryCollection)((Object)sortMap.get(rptEntry.getAlterMode()));
                entries.add(rptEntry);
                continue;
            }
            entries = new FaStocktakingReportBillEntryCollection();
            entries.add(rptEntry);
            sortMap.put(rptEntry.getAlterMode(), entries);
        }
        return sortMap;
    }

    private FaChangeBillInfo getChangeBillInfo(Context ctx) throws EASBizException, BOSException {
        FaChangeBillInfo changeInfo = new FaChangeBillInfo();
        changeInfo.setBillType(FaBillOriginEnum.FROM_STOCKTAKING);
        changeInfo.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        changeInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
        changeInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        changeInfo.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        changeInfo.setFiVouchered(false);
        changeInfo.setPeriod(FaLocalUtils.getCurrentPeriod(ctx));
        changeInfo.setCompany(ContextUtil.getCurrentFIUnit((Context)ctx));
        changeInfo.setHasEffected(true);
        changeInfo.setHandler(ContextUtil.getCurrentUserInfo((Context)ctx));
        changeInfo.setAuditor(changeInfo.getHandler());
        changeInfo.setDescription(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"88_FaStocktakingReportBillControllerBean", (Locale)ctx.getOriginLocale()));
        FaChangeBillEntryCollection changeEntries = new FaChangeBillEntryCollection();
        FaChangeBillEntryInfo changeEntryInfo = new FaChangeBillEntryInfo();
        changeEntries.add(changeEntryInfo);
        changeInfo.put("changeBillEntry", (Object)changeEntries);
        changeEntryInfo.setChangeBill(changeInfo);
        changeEntryInfo.setDecValueChg(new BigDecimal("0"));
        changeEntryInfo.setAccuDeprChg(new BigDecimal("0"));
        return changeInfo;
    }

    private FaCurCardInfo getFaCurCardInfo(Context ctx) throws EASBizException, BOSException {
        FaCurCardInfo cardInfo = new FaCurCardInfo();
        cardInfo.setOriginFlag(FaCardOriginEnum.STOCKTAKING);
        cardInfo.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        cardInfo.setGroupNumberStatus(GroupNumberStatusEnum.EFFECTED);
        cardInfo.setBarCodeStatus(BarCodeStatusEnum.EFFECTED);
        cardInfo.setHasDisabled(false);
        cardInfo.setBizStatus(FaBizStatusEnum.ADDING);
        cardInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        cardInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
        cardInfo.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        cardInfo.setHasCleared(FaClearStatusEnum.HasNotCleared);
        cardInfo.setFiVouchered(false);
        cardInfo.setIsNeedReDepr(false);
        cardInfo.setHasSplited(false);
        cardInfo.setHasEvaled(false);
        cardInfo.setHasChanged(FaChangeStatusEnmu.HasNotChanged);
        cardInfo.setOriginType(FaFromUnitCatEnum.NULL);
        cardInfo.setHandler(SysContext.getSysContext().getCurrentUserInfo());
        cardInfo.setBizDate(new Date());
        cardInfo.setHasNew(true);
        cardInfo.setPeriod(FaLocalUtils.getCurrentPeriod(ctx));
        cardInfo.setCompany(ContextUtil.getCurrentFIUnit((Context)ctx));
        cardInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        CurrencyInfo baseCurrency = ContextUtil.getCurrentFIUnit((Context)ctx).getBaseCurrency();
        cardInfo.setCurrency(baseCurrency);
        cardInfo.setExRate(new BigDecimal("1"));
        cardInfo.setOriginDif(cardInfo.getAssetValue());
        cardInfo.setOriginAccuDif(cardInfo.getAssetValue());
        cardInfo.setAccuDeprChg(cardInfo.getAccuDepr());
        cardInfo.setAccuDeprAccuChg(cardInfo.getAccuDepr());
        cardInfo.setAccuDeprChgTYear(cardInfo.getAccuDeprTYear());
        cardInfo.setAccuDeprAccuChgTYear(cardInfo.getAccuDeprTYear());
        cardInfo.setDecValueChg(cardInfo.getDecValue());
        cardInfo.setDecValueAccuChg(cardInfo.getDecValue());
        cardInfo.setRemark(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"88_FaStocktakingReportBillControllerBean", (Locale)ctx.getOriginLocale()));
        return cardInfo;
    }

    private void verifyCard(Context ctx, FaStocktakingReportBillEntryInfo rptEntry, FaCurCardInfo cardInfo, boolean isClear) throws EASBizException {
        if (cardInfo == null) {
            throw new FaStocktakingException(FaStocktakingException.CARD_NOT_FOUND);
        }
        if (!cardInfo.getBizStatus().getValue().endsWith("99")) {
            throw new FaCardException(FaCardException.CURCARD_NOTVALID, new String[]{cardInfo.getNumber() + "(" + cardInfo.getAssetName() + ") " + cardInfo.getBizStatus().getAlias()});
        }
        if (cardInfo.getBlockedStatus().getValue() == 2) {
            throw new FaStocktakingException(FaStocktakingException.CARD_HAS_BLOCKED, new Object[]{cardInfo.getNumber()});
        }
        if (cardInfo.getHasCleared().getValue() == 2) {
            throw new FaStocktakingException(FaStocktakingException.CARD_HAS_CLEARED, new Object[]{cardInfo.getNumber()});
        }
        if (cardInfo.getDeletedStatus().getValue() == 2) {
            throw new FaStocktakingException(FaStocktakingException.CARD_HAS_DELETED, new Object[]{cardInfo.getNumber()});
        }
        if (isClear && cardInfo.getAssetAmt().compareTo(rptEntry.getLossAmt()) < 0) {
            throw new FaStocktakingException(FaStocktakingException.CLEAR_CANNOT_PERF, new Object[]{cardInfo.getNumber(), cardInfo.getAssetAmt()});
        }
    }

    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FaStocktakingReportBillInfo rptInfo = this.getFaStocktakingReportBillInfo(ctx, "select stocktakingStatus,taskBill.id,bill.id where id='" + pk + "'");
        if (rptInfo.getStocktakingStatus().getValue() == 6) {
            throw new FaStocktakingException(FaStocktakingException.CANNOT_DEL_RPT);
        }
        super.delete(ctx, pk);
        try {
            String sql = "SELECT * FROM T_FA_FaStocktakingAOrPBill WHERE FTaskBillID=?";
            SqlParams sp = new SqlParams();
            sp.addString(rptInfo.getTaskBill().getId().toString());
            RptRowSet rs = DBUtilx.executeQuery((String)sql, (SqlParams)sp, (Context)ctx);
            if (!rs.next()) {
                sql = "update t_fa_stocktakingtaskbill set FStocktakingStatus=4 where fid=?";
                sp = new SqlParams();
                sp.addString(rptInfo.getTaskBill().getId().toString());
                DBUtilx.executeUpdate((String)sql, (SqlParams)sp, (Context)ctx);
                sql = "update t_fa_stocktakingbill set FStocktakingStatus=2 where fid=?";
                sp = new SqlParams();
                sp.addString(rptInfo.getBill().getId().toString());
                DBUtilx.executeUpdate((String)sql, (SqlParams)sp, (Context)ctx);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("taskBill.lastUpdater"));
        sic.add(new SelectorItemInfo("bill.id"));
        sic.add(new SelectorItemInfo("taskBill.id"));
        sic.add(new SelectorItemInfo("taskBill.period.id"));
        sic.add(new SelectorItemInfo("stocktakingStatus"));
        sic.add(new SelectorItemInfo("entries.adjustAsset"));
        sic.add(new SelectorItemInfo("entries.newCard.id"));
        sic.add(new SelectorItemInfo("entries.newCard.number"));
        sic.add(new SelectorItemInfo("entries.newCard.effectedStatus"));
        sic.add(new SelectorItemInfo("entries.newCard.checkedStatus"));
        sic.add(new SelectorItemInfo("entries.changeBill.*"));
        sic.add(new SelectorItemInfo("entries.changeBill.changeBillEntry.*"));
        sic.add(new SelectorItemInfo("entries.changeBill.changeBillEntry.curCard.*"));
        sic.add(new SelectorItemInfo("entries.changeBill.changeBillEntry.bizCard.faBakCard.id"));
        sic.add(new SelectorItemInfo("entries.clearBill.*"));
        sic.add(new SelectorItemInfo("entries.clearBill.clearBillEntry.*"));
        sic.add(new SelectorItemInfo("entries.clearBill.clearBillEntry.curCard.*"));
        sic.add(new SelectorItemInfo("entries.clearBill.clearBillEntry.bizCard.faBakCard.id"));
        sic.add(new SelectorItemInfo("entries.clearBill.clearBillEntry.bizCard.faBakCard.assetAmt"));
        sic.add(new SelectorItemInfo("entries.clearBill.clearBillEntry.bizCard.faBakCard.lastEvalValue"));
        sic.add(new SelectorItemInfo("company.id"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)pk.toString()));
        FaStocktakingReportBillInfo rptInfo = this.getFaStocktakingReportBillInfo(ctx, view.toString());
        String lastu = rptInfo.getTaskBill().getLastUpdater();
        if (lastu != null && lastu.trim().length() > 0 && !lastu.equals(pk.toString())) {
            throw new FaStocktakingException(FaStocktakingException.CANCEL_RPT);
        }
        FaLocalUtils.checkPeriodConsistent(ctx, rptInfo.getCompany(), rptInfo.getTaskBill().getPeriod(), true);
        if (rptInfo.getStocktakingStatus().getValue() != 6) {
            throw new FaStocktakingException(FaStocktakingException.CANNOT_CANCEL_RPT);
        }
        PeriodInfo period = FaLocalUtils.getCurrentPeriod(ctx);
        boolean hasNoAudit = FaDepORMapping.hasNoAudit(ctx, period.getPeriodYear(), period.getPeriodNumber(), rptInfo.getCompany().getId().toString());
        if (hasNoAudit) {
            throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCal_NoAudit", (Locale)ctx.getOriginLocale()) + "," + ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCal_DoAction", (Locale)ctx.getOriginLocale())));
        }
        String sql = "update t_fa_stocktakingrptentry set fnewcardid=null,fclearbillid=null,fchangebillid=null where freportbillid=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{rptInfo.getId().toString()});
        PrcFaAddStrategy prcAdd = new PrcFaAddStrategy();
        PrcFaClearStrategy prcClr = new PrcFaClearStrategy();
        PrcFaChangeStrategy prcChg = new PrcFaChangeStrategy();
        prcAdd.getTempParam().put("FROM_SOURCE", Boolean.TRUE);
        prcClr.getTempParam().put("FROM_SOURCE", Boolean.TRUE);
        prcChg.getTempParam().put("FROM_SOURCE", Boolean.TRUE);
        ArrayList<String> hasClearList = new ArrayList<String>();
        for (int i = 0; i < rptInfo.getEntries().size(); ++i) {
            FaStocktakingReportBillEntryInfo rptEntry = rptInfo.getEntries().get(i);
            if (!rptEntry.isAdjustAsset()) continue;
            if (rptEntry.getNewCard() != null) {
                FaCurCardInfo newCard = rptEntry.getNewCard();
                if (newCard.getCheckedStatus().getValue() == 2) {
                    throw new FaStocktakingException(FaStocktakingException.CARD_HAD_CHECKED, new Object[]{newCard.getNumber()});
                }
                if (newCard.getEffectedStatus().getValue() == 2) {
                    FaLocalUtils.abortWfProcessByObjId(ctx, newCard.getId().toString());
                }
                prcAdd.deleteBill(ctx, (IObjectPK)new ObjectUuidPK(newCard.getId()));
                continue;
            }
            if (rptEntry.getClearBill() != null) {
                FaClearBillInfo clearBill = rptEntry.getClearBill();
                if (hasClearList.contains(clearBill.getId().toString())) continue;
                prcClr.checkForUnAudit(ctx, (IObjectPK)new ObjectUuidPK(clearBill.getId()));
                prcClr.unAuditBill(ctx, (IObjectValue)clearBill);
                prcClr.deleteBill(ctx, (IObjectPK)new ObjectUuidPK(clearBill.getId()));
                hasClearList.add(clearBill.getId().toString());
                continue;
            }
            if (rptEntry.getChangeBill() == null) continue;
            FaChangeBillInfo changeBill = rptEntry.getChangeBill();
            prcChg.checkForUnAudit(ctx, (IObjectPK)new ObjectUuidPK(changeBill.getId()));
            prcChg.unAuditBill(ctx, (IObjectValue)changeBill);
            prcChg.deleteBill(ctx, (IObjectPK)new ObjectUuidPK(rptEntry.getChangeBill().getId()));
        }
        sql = "update t_fa_stocktakingtaskbill set FStocktakingStatus=5,flastupdatetime=?,FLASTUPDATERID='' where fid=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Timestamp(System.currentTimeMillis()), rptInfo.getTaskBill().getId().toString()});
        sql = "update t_fa_stocktakingbill set FStocktakingStatus=5,flastupdatetime=? where fid=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Timestamp(System.currentTimeMillis()), rptInfo.getBill().getId().toString()});
        sql = "update t_fa_stocktakingrptbill set FStocktakingStatus=1,flastupdatetime=? where fid=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Timestamp(System.currentTimeMillis()), rptInfo.getId().toString()});
    }

    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        return this.innerSubmit(ctx, model, true);
    }

    public IObjectPK save(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        return this.innerSubmit(ctx, model, false);
    }

    private IObjectPK innerSubmit(Context ctx, CoreBaseInfo model, boolean isSubmit) throws FaStocktakingException, EASBizException, BOSException {
        FaStocktakingReportBillInfo rptInfo = (FaStocktakingReportBillInfo)model;
        IFaStocktakingReportBill iRpt = FaStocktakingReportBillFactory.getLocalInstance(ctx);
        IFaStocktakingTaskBill iTask = FaStocktakingTaskBillFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)rptInfo.getTaskBill().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("stocktakingStatus", (Object)new Integer(4)));
        filter.getFilterItems().add(new FilterItemInfo("stocktakingStatus", (Object)new Integer(5)));
        filter.setMaskString("#0 and (#1 or #2)");
        if (!iTask.exists(filter)) {
            FaStocktakingTaskBillInfo v = FaStocktakingTaskBillFactory.getLocalInstance(ctx).getFaStocktakingTaskBillInfo("select stocktakingStatus where id='" + rptInfo.getTaskBill().getId() + "'");
            throw new FaStocktakingException(FaStocktakingException.CANNOT_OPERATE, new Object[]{v.getStocktakingStatus().toString()});
        }
        if (iRpt.exists("where taskBill.id='" + rptInfo.getTaskBill().getId() + "'" + (rptInfo.getId() == null ? "" : " and id !='" + rptInfo.getId() + "'"))) {
            throw new FaStocktakingException(FaStocktakingException.RPT_HAVE_GEN);
        }
        String sql = "update t_fa_stocktakingtaskbill set FStocktakingStatus=5,flastupdatetime=? where fid=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Timestamp(System.currentTimeMillis()), rptInfo.getTaskBill().getId().toString()});
        sql = "update t_fa_stocktakingbill set FStocktakingStatus=5,flastupdatetime=? where fid=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Timestamp(System.currentTimeMillis()), rptInfo.getBill().getId().toString()});
        if (isSubmit) {
            rptInfo.setEffectedStatus(EffectedStatusEnum.EFFECTED);
            return super.submit(ctx, model);
        }
        rptInfo.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        return super.save(ctx, model);
    }

    public boolean checkNumberDup(Context ctx, IObjectPK pk, CoreBillBaseInfo model) throws BOSException, EASBizException {
        return false;
    }

    @Override
    protected IRowSet _getRowset(Context ctx, String id, String queryName) throws BOSException, EASBizException {
        IQueryExecutor queryExcu = null;
        MetaDataPK queryPK = null;
        queryPK = new MetaDataPK(queryName);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)id));
        viewInfo.setFilter(fi);
        queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        IRowSet rows = queryExcu.executeQuery();
        return rows;
    }

    protected HashMap gethmParam(Context ctx) throws BOSException, EASBizException {
        if (this.hmParam == null || this.hmParam.size() == 0) {
            this.hmParam = FaManageUtils.getFAParameter(this.getCurrentCompany(ctx).getId(), ctx);
        }
        return this.hmParam;
    }

    protected CompanyOrgUnitInfo getCurrentCompany(Context ctx) throws BOSException, EASBizException {
        if (this.currCompany == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            BOSUuid id = ContextUtil.getCurrentFIUnit((Context)ctx).getId();
            this.currCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(id), sic);
        }
        return this.currCompany;
    }

    private boolean checkBlocCardDup(Context ctx, IObjectValue model, String groupNumber) throws EASBizException, BOSException {
        String usebarCodeNumber = (String)this.gethmParam(ctx).get("FA_030");
        String auto = (String)this.gethmParam(ctx).get("FA_189");
        if ("true".equalsIgnoreCase(usebarCodeNumber) && "false".equalsIgnoreCase(auto)) {
            if (groupNumber == null || "".equals(groupNumber)) {
                return true;
            }
            FilterItemInfo barCodeFilter = new FilterItemInfo("groupNumber", (Object)groupNumber, CompareType.EQUALS);
            if (FaLocalUtils.existNumber(ctx, model, barCodeFilter)) {
                return false;
            }
        }
        return true;
    }

    private boolean checkBarCodeDup(Context ctx, IObjectValue model, String barCode) throws EASBizException, BOSException {
        String usebarCodeNumber = (String)this.gethmParam(ctx).get("FA_043");
        String auto = (String)this.gethmParam(ctx).get("FA_101");
        if ("true".equalsIgnoreCase(usebarCodeNumber) && "false".equalsIgnoreCase(auto)) {
            if (barCode == null || "".equals(barCode)) {
                return true;
            }
            FilterItemInfo barCodeFilter = new FilterItemInfo("barCode", (Object)barCode, CompareType.EQUALS);
            if (FaLocalUtils.existNumber(ctx, model, barCodeFilter)) {
                return false;
            }
        }
        return true;
    }
}

