/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FlBasicException;
import com.kingdee.eas.fi.fa.manage.FlContrastCaclFactory;
import com.kingdee.eas.fi.fa.manage.IFlContrastCacl;
import com.kingdee.eas.fi.fa.manage.NLMAccountBalanceCollection;
import com.kingdee.eas.fi.fa.manage.NLMAccountBalanceFactory;
import com.kingdee.eas.fi.fa.manage.NLMAccountBalanceInfo;
import com.kingdee.eas.fi.fa.manage.app.AbstractFlPeriodCloseFacadeControllerBean;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class FlPeriodCloseFacadeControllerBean
extends AbstractFlPeriodCloseFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.manage.app.FlPeriodCloseFacadeControllerBean");

    @Override
    protected IObjectValue _carrayForward(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        try {
            NLMAccountBalanceCollection incrementalBalanceData;
            boolean isInitEnd = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)company);
            if (!isInitEnd) {
                throw new FlBasicException(FlBasicException.IS_INIT_END);
            }
            PeriodInfo curPeriod = this.getCurrentPeriod(ctx, company.getId().toString());
            PeriodInfo nextPeriod = this.getNextPeriod(ctx, company.getId().toString());
            int count = 0;
            if (nextPeriod == null || nextPeriod.getId() == null) {
                throw new FlBasicException(FlBasicException.NO_NEXT_PERIOD);
            }
            boolean isRelAccount = SystemStatusCtrolUtils.isRelAccount((Context)ctx, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)company);
            boolean isSettleWithoutAcctequals = FaManageUtils.getFaParamValue(ctx, "NLM_309", company.getId().toString());
            if (isSettleWithoutAcctequals) {
                this.checkBeforeCarrayForward(ctx, curPeriod, company);
            }
            if (isRelAccount && !curPeriod.isIsAdjustPeriod()) {
                boolean isAllVouchered;
                boolean isNLM_306;
                boolean isRentSettlementVouchered = FaManageUtils.getFaParamValue(ctx, "NLM_301", company.getId().toString());
                if (isRentSettlementVouchered) {
                    StringBuilder rentSql = new StringBuilder();
                    rentSql.append("select count(*) as count from T_FA_FaRentSettlementBill bill \n");
                    rentSql.append("left join T_FA_FaLeaseInBillNew billInfo ON billInfo.FID = bill.FLEASEBILLID \n");
                    rentSql.append("left join T_FA_FaRentSettlementBillEntry entry ON bill.FID = entry.FBillID \n");
                    rentSql.append("where bill.FCompanyID = ? \n");
                    rentSql.append("and entry.FPlanDate >= ? \n");
                    rentSql.append("and entry.FPlanDate <= ? \n");
                    rentSql.append("and (entry.FFiVouchered = 0 or entry.FFiVouchered is null) \n");
                    rentSql.append("and (entry.FPLANWITHTAXAMT is not null and entry.FPLANWITHTAXAMT <> 0) \n");
                    rentSql.append("and billInfo.FBizStatus <> 5 \n");
                    rentSql.append("and billInfo.FBizStatus <> 7 \n");
                    rentSql.append("and billInfo.FBizStatus <> 11 \n");
                    Object[] rentParams = new Object[]{company.getId().toString(), curPeriod.getBeginDate(), curPeriod.getEndDate()};
                    IRowSet rentRowset = DbUtil.executeQuery((Context)ctx, (String)rentSql.toString(), (Object[])rentParams);
                    while (rentRowset.next()) {
                        count = rentRowset.getInt("count");
                    }
                    if (count > 0) {
                        throw new FlBasicException(FlBasicException.RENT_SETTLEMENT_NOT_VOUCHERED);
                    }
                }
                if (isNLM_306 = FaManageUtils.getFaParamValue(ctx, "NLM_306", company.getId().toString())) {
                    StringBuilder rentSql = new StringBuilder();
                    rentSql.append("select count(*) as count from T_FA_FaRentSettlementBill bill \n");
                    rentSql.append("left join T_FA_FaLeaseInBillNew billInfo ON billInfo.FID = bill.FLEASEBILLID \n");
                    rentSql.append("left join T_FA_FaRentSettlementBillEntry entry ON bill.FID = entry.FBillID \n");
                    rentSql.append("where bill.FCompanyID = ? \n");
                    rentSql.append("and entry.FPlanDate >= ? \n");
                    rentSql.append("and entry.FPlanDate <= ? \n");
                    rentSql.append("and (entry.FFiVouchered = 0 or entry.FFiVouchered is null) \n");
                    rentSql.append("and (entry.FPLANWITHTAXAMT is null or entry.FPLANWITHTAXAMT = 0) \n");
                    rentSql.append("and billInfo.FBizStatus <> 5 \n");
                    rentSql.append("and billInfo.FBizStatus <> 7 \n");
                    rentSql.append("and billInfo.FBizStatus <> 11 \n");
                    Object[] rentParams = new Object[]{company.getId().toString(), curPeriod.getBeginDate(), curPeriod.getEndDate()};
                    IRowSet rentRowset = DbUtil.executeQuery((Context)ctx, (String)rentSql.toString(), (Object[])rentParams);
                    while (rentRowset.next()) {
                        count = rentRowset.getInt("count");
                    }
                    if (count > 0) {
                        throw new FlBasicException(FlBasicException.RENT_SETTLEMENT_ZERO_NOT_VOUCHERED);
                    }
                }
                if (isAllVouchered = FaManageUtils.getFaParamValue(ctx, "NLM_302", company.getId().toString())) {
                    String leaseInSql = " select count(*) as count from T_FA_FaLeaseInBillNew where FCompanyID = ? and FPeriodID = ? and FFiVouchered = 0 and FIsExempt = 0 and FLeaseType != 2";
                    Object[] leaseInParams = new Object[]{company.getId().toString(), curPeriod.getId().toString()};
                    IRowSet rentRowset = DbUtil.executeQuery((Context)ctx, (String)leaseInSql, (Object[])leaseInParams);
                    while (rentRowset.next()) {
                        count = rentRowset.getInt("count");
                    }
                    if (count > 0) {
                        throw new FlBasicException(FlBasicException.NOT_LEASE_IN_VOUCHERED);
                    }
                    String deprSql = " select count(*) as count from T_FA_FaDepreAndAmort where FCompanyID = ? and FPeriodID = ? and (FiVouchered = 0 or FiVouchered is null) and (FDeletedStatus is null or FDeletedStatus <> 2) and (FMONTHLYDEPREAMT is not null or FMONTHLYINTERESTEXPE is not null) and (FMONTHLYDEPREAMT <> 0 or FMONTHLYINTERESTEXPE <> 0)";
                    Object[] deprParams = new Object[]{company.getId().toString(), curPeriod.getId().toString()};
                    IRowSet deprRowset = DbUtil.executeQuery((Context)ctx, (String)deprSql, (Object[])deprParams);
                    while (deprRowset.next()) {
                        count = deprRowset.getInt("count");
                    }
                    if (count > 0) {
                        throw new FlBasicException(FlBasicException.NOT_DEPR_VOUCHERED);
                    }
                    String terminateSql = " select count(*) as count from T_FA_FaTerminateBill where FCompanyID = ? and FPeriodID = ? and FFiVouchered = 0 ";
                    Object[] terminateParams = new Object[]{company.getId().toString(), curPeriod.getId().toString()};
                    IRowSet terminateRowset = DbUtil.executeQuery((Context)ctx, (String)terminateSql, (Object[])terminateParams);
                    while (terminateRowset.next()) {
                        count = terminateRowset.getInt("count");
                    }
                    if (count > 0) {
                        throw new FlBasicException(FlBasicException.NOT_TERMINATE_VOUCHERED);
                    }
                }
            }
            if (!curPeriod.isIsAdjustPeriod()) {
                String leaseInSql = " select count(*) as count from T_FA_FaLeaseInBillNew where FCompanyID = ? and FPeriodID = ? and FCheckedStatus = 1 ";
                Object[] leaseInParams = new Object[]{company.getId().toString(), curPeriod.getId().toString()};
                IRowSet rentRowset = DbUtil.executeQuery((Context)ctx, (String)leaseInSql, (Object[])leaseInParams);
                while (rentRowset.next()) {
                    count = rentRowset.getInt("count");
                }
                if (count > 0) {
                    throw new FlBasicException(FlBasicException.NOT_LEASE_IN_CHECKED);
                }
                String changeSql = " select count(*) as count from T_FA_FaLeaseChangeBill where FCompanyID = ? and FPeriodID = ? and FCheckedStatus = 1 ";
                Object[] changeParams = new Object[]{company.getId().toString(), curPeriod.getId().toString()};
                IRowSet changeRowset = DbUtil.executeQuery((Context)ctx, (String)changeSql, (Object[])changeParams);
                while (changeRowset.next()) {
                    count = changeRowset.getInt("count");
                }
                if (count > 0) {
                    throw new FlBasicException(FlBasicException.NOT_CHANGE_CHECKED);
                }
                String terminateSql = " select count(*) as count from T_FA_FaTerminateBill where FCompanyID = ? and FPeriodID = ? and FCheckedStatus = 1 ";
                Object[] terminateParams = new Object[]{company.getId().toString(), curPeriod.getId().toString()};
                IRowSet terminateRowset = DbUtil.executeQuery((Context)ctx, (String)terminateSql, (Object[])terminateParams);
                while (terminateRowset.next()) {
                    count = terminateRowset.getInt("count");
                }
                if (count > 0) {
                    throw new FlBasicException(FlBasicException.NOT_TERMINATE_CHECKED);
                }
                this.checkNeedCalcLeaseInBillExists(ctx, curPeriod, company);
                this.checkDepExists(ctx, curPeriod, company);
            }
            if (!NLMAccountBalanceFactory.getLocalInstance(ctx).exists("where company.id = '" + company.getId().toString() + "' and period.id = '" + nextPeriod.getId().toString() + "'")) {
                this.closingBalance(ctx, company, curPeriod);
            }
            if ((incrementalBalanceData = this.calcIncrementalBalanceData(ctx, company, curPeriod, nextPeriod)).size() != 0) {
                this.closingincrementalBalanceData(ctx, company, curPeriod, incrementalBalanceData);
            }
            ISystemStatusCtrol ictrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
            ictrol.nextPeriod(SystemEnum.FINANCE_LEASE, (OrgUnitInfo)company);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return this.getCurrentPeriod(ctx, company.getId().toString());
    }

    protected void checkBeforeCarrayForward(Context ctx, PeriodInfo period, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        IFlContrastCacl iFlContrastCacl = FlContrastCaclFactory.getLocalInstance(ctx);
        boolean checkResult = iFlContrastCacl.isAcctEquals(company.getId().toString(), period);
        if (!checkResult) {
            throw new FlBasicException(FlBasicException.FORWARD_CHECKGL);
        }
    }

    private void checkNeedCalcLeaseInBillExists(Context ctx, PeriodInfo curPeriod, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        try {
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT lease.FID leaseInID, lease.FPeriodID periodID \r\n");
            sql.append("FROM T_FA_FALEASEINBILLNEW lease \r\n");
            sql.append("LEFT JOIN T_FA_FAAMORTIZEDCOSTRPT rpt ON lease.FID = rpt.FLeaseInBillID \r\n");
            sql.append("LEFT JOIN T_FA_FAAMORTIZEDCOSTRPTENTRY rptEntry ON rptEntry.FAmortizedCostRptID = rpt.FID \r\n");
            sql.append("LEFT JOIN T_FA_FaTerminateBillEntry tme ON lease.FID = tme.FLeaseInBillID \r\n");
            sql.append("LEFT JOIN T_FA_FaTerminateBill tm ON tme.FBillID = tm.FID \r\n");
            sql.append("LEFT JOIN T_BD_PERIOD period ON period.FID = lease.FPERIODID \r\n");
            sql.append("WHERE ");
            sql.append("lease.FID NOT IN (SELECT FLeaseInBillID FROM T_Fa_FaDepreAndAmort WHERE FPeriodID = ? AND FCompanyId = ?) \r\n");
            sql.append("AND lease.FCompanyID = ? \r\n");
            sql.append("AND lease.FCheckedStatus = 2 \r\n");
            sql.append("\t\tAND (lease.FBizStatus <> 5 OR (lease.FBizStatus = 5 AND tm.FPeriodID = ? AND lease.FTerminatedType <> '3' AND lease.FTerminatedType <> '2')) \r\n");
            sql.append("AND (lease.FBizStatus <> 7) \r\n");
            sql.append("AND (lease.FBizStatus <> 11) \r\n");
            sql.append("AND (lease.FSourceType <> 3 OR (lease.FSourceType = 3 AND period.FNumber <= " + curPeriod.getNumber() + ")) \r\n");
            sql.append("AND lease.FIsExempt = 0 \r\n");
            sql.append("AND rptEntry.FDate >= ?  \r\n");
            sql.append("AND rptEntry.FDate <= ? \r\n");
            String companyId = company.getId().toString();
            String curPeriodId = curPeriod.getId().toString();
            Timestamp beginTime = new Timestamp(curPeriod.getBeginDate().getTime());
            Timestamp endTime = curPeriod.getEndDate();
            IRowSet needCalcRs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{curPeriodId, companyId, companyId, curPeriodId, beginTime, endTime});
            boolean tmp = false;
            while (needCalcRs.next()) {
                String periodID = needCalcRs.getString("periodID");
                PeriodInfo periodInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(periodID));
                if (curPeriod.getNumber() < periodInfo.getNumber()) continue;
                tmp = true;
                break;
            }
            if (tmp) {
                throw new FlBasicException(FlBasicException.HAS_DEPR_AND_AMORT);
            }
        }
        catch (SQLException e) {
            throw new EASBizException(new NumericExceptionSubItem("008", e.getMessage()));
        }
    }

    private void checkDepExists(Context ctx, PeriodInfo curPeriod, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        try {
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT t1.FID, t3.FNumber billNumber \r\n");
            sql.append("FROM T_FA_FaLeaseNewDepCostSharing t1 \r\n");
            sql.append("INNER JOIN T_BD_Period t2 on t1.FPeriodID = t2.FID \n");
            sql.append("INNER JOIN T_FA_FaLeaseInBillNew t3 ON t1.FLeaseInBillID = t3.FID \n");
            sql.append("WHERE t1.FCompanyID = ? \n");
            sql.append("AND t1.FPeriodID = ? \r\n");
            sql.append("AND t1.FDataStatus = 1 \r\n");
            String companyId = company.getId().toString();
            String curPeriodId = curPeriod.getId().toString();
            IRowSet needCalcRs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, curPeriodId});
            if (needCalcRs.next()) {
                throw new EASBizException(new NumericExceptionSubItem("008", "" + needCalcRs.getString("billNumber") + ""));
            }
        }
        catch (SQLException e) {
            throw new EASBizException(new NumericExceptionSubItem("008", e.getMessage()));
        }
    }

    private PeriodInfo getCurrentPeriod(Context ctx, String companyId) throws BOSException, EASBizException {
        return SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FINANCE_LEASE, (IObjectPK)new ObjectUuidPK(companyId));
    }

    private PeriodInfo getNextPeriod(Context ctx, String companyId) throws BOSException, EASBizException {
        return PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)this.getCurrentPeriod(ctx, companyId));
    }

    @Override
    protected IObjectValue _carrayBack(Context ctx, String companyId) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyId));
        PeriodInfo curPeriod = this.getCurrentPeriod(ctx, companyId);
        PeriodInfo prePeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)curPeriod);
        PeriodInfo curGLPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)new ObjectUuidPK(companyId));
        boolean isRelAccount = SystemStatusCtrolUtils.isRelAccount((Context)ctx, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)company);
        if (isRelAccount && this.periodCompare(prePeriod, curGLPeriod) == -1) {
            throw new FlBasicException(FlBasicException.CAN_NOT_CARRAYBACK_TO_GL_PERIOD_BEFORE);
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select sysStaCtr.fid, sysStaCtr.FRelatedPeriodID relatedPeriodID ");
        sql.append(" from T_BD_SystemStatusCtrol sysStaCtr,T_BD_SystemStatus sysSta ");
        sql.append(" where sysStaCtr.FSystemStatusID=sysSta.FID ");
        sql.append(" and sysStaCtr.FCompanyID='");
        sql.append(companyId);
        sql.append("'");
        sql.append(" and sysSta.FName=");
        sql.append(2001);
        sql.append(" and sysStaCtr.FIsRelAccount = 1");
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (iRowSet != null && iRowSet.size() > 0 && iRowSet.next()) {
                String relatedPeriodID = iRowSet.getString("relatedPeriodID");
                PeriodInfo relPeriodInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(relatedPeriodID));
                if (this.periodCompare(prePeriod, relPeriodInfo) == -1) {
                    throw new FlBasicException(FlBasicException.CAN_NOT_CARRAYBACK_TO_RELACCOUNT_PERIOD_BEFORE);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)company);
        if (this.periodCompare(curPeriod, startPeriod) == 0) {
            throw new FlBasicException(FlBasicException.CAN_NOT_CARRAYBACK_IN_INIT_PERIOD);
        }
        ISystemStatusCtrol ictrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        ictrol.prePeriod(SystemEnum.FINANCE_LEASE, (OrgUnitInfo)company);
        return prePeriod;
    }

    private int periodCompare(PeriodInfo sourceperiodInfo, PeriodInfo targetperiodInfo) {
        if (sourceperiodInfo.getPeriodYear() > targetperiodInfo.getPeriodYear()) {
            return 1;
        }
        if (sourceperiodInfo.getPeriodYear() == targetperiodInfo.getPeriodYear()) {
            if (sourceperiodInfo.getPeriodNumber() > targetperiodInfo.getPeriodNumber()) {
                return 1;
            }
            if (sourceperiodInfo.getPeriodNumber() == targetperiodInfo.getPeriodNumber()) {
                return 0;
            }
            return -1;
        }
        return -1;
    }

    private void closingBalance(Context ctx, CompanyOrgUnitInfo currentCompany, PeriodInfo currentPeriod) throws EASBizException, BOSException {
        PeriodInfo nextPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)currentPeriod);
        NLMAccountBalanceCollection nlmAccountBalanceCollection = NLMAccountBalanceFactory.getLocalInstance(ctx).getNLMAccountBalanceCollection("where period.id = '" + currentPeriod.getId().toString() + "' and company.id = '" + currentCompany.getId().toString() + "'");
        int j = nlmAccountBalanceCollection.size();
        for (int i = 0; i < j; ++i) {
            NLMAccountBalanceInfo old = nlmAccountBalanceCollection.get(i);
            NLMAccountBalanceInfo nlmAccountBalanceInfoNew = new NLMAccountBalanceInfo();
            nlmAccountBalanceInfoNew.setId(BOSUuid.create((BOSObjectType)nlmAccountBalanceInfoNew.getBOSType()));
            nlmAccountBalanceInfoNew.setLeaseInBill(old.getLeaseInBill());
            nlmAccountBalanceInfoNew.setCompany(old.getCompany());
            nlmAccountBalanceInfoNew.setCurrency(old.getCurrency());
            nlmAccountBalanceInfoNew.setPeriod(nextPeriod);
            nlmAccountBalanceInfoNew.setOpeningBalanceForAsset(old.getEndingBalanceForAsset());
            nlmAccountBalanceInfoNew.setCurrentBorrowingForAsset(new BigDecimal("0"));
            nlmAccountBalanceInfoNew.setCurrentLoanForAsset(new BigDecimal("0"));
            nlmAccountBalanceInfoNew.setEndingBalanceForAsset(old.getEndingBalanceForAsset());
            nlmAccountBalanceInfoNew.setOpeningBalanceForDep(old.getEndingBalanceForDep());
            nlmAccountBalanceInfoNew.setCurrentBorrowingForDep(new BigDecimal("0"));
            nlmAccountBalanceInfoNew.setCurrentLoanForDep(new BigDecimal("0"));
            nlmAccountBalanceInfoNew.setEndingBalanceForDep(old.getEndingBalanceForDep());
            nlmAccountBalanceInfoNew.setOpeningBalanceForDec(old.getEndingBalanceForDec());
            nlmAccountBalanceInfoNew.setCurrentBorrowingForDec(new BigDecimal("0"));
            nlmAccountBalanceInfoNew.setCurrentLoanForDec(new BigDecimal("0"));
            nlmAccountBalanceInfoNew.setEndingBalanceForDec(old.getEndingBalanceForDec());
            NLMAccountBalanceFactory.getLocalInstance(ctx).addnew(nlmAccountBalanceInfoNew);
        }
    }

    private NLMAccountBalanceCollection calcIncrementalBalanceData(Context ctx, CompanyOrgUnitInfo company, PeriodInfo curPeriod, PeriodInfo nextPeriod) throws BOSException {
        NLMAccountBalanceCollection curBalanceCollection = NLMAccountBalanceFactory.getLocalInstance(ctx).getNLMAccountBalanceCollection("where period.id = '" + curPeriod.getId().toString() + "' and company.id = '" + company.getId().toString() + "'");
        NLMAccountBalanceCollection nextBalanceCollection = NLMAccountBalanceFactory.getLocalInstance(ctx).getNLMAccountBalanceCollection("where period.id = '" + nextPeriod.getId().toString() + "' and company.id = '" + company.getId().toString() + "'");
        NLMAccountBalanceCollection result = new NLMAccountBalanceCollection();
        if (curBalanceCollection.size() != nextBalanceCollection.size()) {
            int i;
            HashMap<String, NLMAccountBalanceInfo> tmpMap = new HashMap<String, NLMAccountBalanceInfo>();
            int j = nextBalanceCollection.size();
            for (i = 0; i < j; ++i) {
                tmpMap.put(nextBalanceCollection.get(i).getLeaseInBill().getId().toString(), nextBalanceCollection.get(i));
            }
            j = curBalanceCollection.size();
            for (i = 0; i < j; ++i) {
                if (tmpMap.containsKey(curBalanceCollection.get(i).getLeaseInBill().getId().toString())) continue;
                result.add(curBalanceCollection.get(i));
            }
        }
        return result;
    }

    private void closingincrementalBalanceData(Context ctx, CompanyOrgUnitInfo company, PeriodInfo curPeriod, NLMAccountBalanceCollection incrementalBalanceData) throws EASBizException, BOSException {
        PeriodInfo nextPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)curPeriod);
        int j = incrementalBalanceData.size();
        for (int i = 0; i < j; ++i) {
            NLMAccountBalanceInfo old = incrementalBalanceData.get(i);
            NLMAccountBalanceInfo nlmAccountBalanceInfoNew = new NLMAccountBalanceInfo();
            nlmAccountBalanceInfoNew.setId(BOSUuid.create((BOSObjectType)nlmAccountBalanceInfoNew.getBOSType()));
            nlmAccountBalanceInfoNew.setLeaseInBill(old.getLeaseInBill());
            nlmAccountBalanceInfoNew.setCompany(old.getCompany());
            nlmAccountBalanceInfoNew.setCurrency(old.getCurrency());
            nlmAccountBalanceInfoNew.setPeriod(nextPeriod);
            nlmAccountBalanceInfoNew.setOpeningBalanceForAsset(old.getEndingBalanceForAsset());
            nlmAccountBalanceInfoNew.setCurrentBorrowingForAsset(new BigDecimal("0"));
            nlmAccountBalanceInfoNew.setCurrentLoanForAsset(new BigDecimal("0"));
            nlmAccountBalanceInfoNew.setEndingBalanceForAsset(old.getEndingBalanceForAsset());
            nlmAccountBalanceInfoNew.setOpeningBalanceForDep(old.getEndingBalanceForDep());
            nlmAccountBalanceInfoNew.setCurrentBorrowingForDep(new BigDecimal("0"));
            nlmAccountBalanceInfoNew.setCurrentLoanForDep(new BigDecimal("0"));
            nlmAccountBalanceInfoNew.setEndingBalanceForDep(old.getEndingBalanceForDep());
            nlmAccountBalanceInfoNew.setOpeningBalanceForDec(old.getEndingBalanceForDec());
            nlmAccountBalanceInfoNew.setCurrentBorrowingForDec(new BigDecimal("0"));
            nlmAccountBalanceInfoNew.setCurrentLoanForDec(new BigDecimal("0"));
            nlmAccountBalanceInfoNew.setEndingBalanceForDec(old.getEndingBalanceForDec());
            NLMAccountBalanceFactory.getLocalInstance(ctx).addnew(nlmAccountBalanceInfoNew);
        }
    }
}

